/*
 * Decompiled with CFR 0.152.
 */
package io.appform.functionmetrics;

import com.codahale.metrics.Timer;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import io.appform.functionmetrics.FunctionInvocation;
import io.appform.functionmetrics.FunctionMetricConstants;
import io.appform.functionmetrics.FunctionMetricsManager;
import io.appform.functionmetrics.MetricTerm;
import io.appform.functionmetrics.MonitoredFunction;
import io.appform.functionmetrics.Options;
import io.appform.functionmetrics.TimerDomain;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class FunctionTimerAspect {
    private static final Logger log = LoggerFactory.getLogger((String)FunctionTimerAspect.class.getSimpleName());
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ FunctionTimerAspect ajc$perSingletonInstance;

    static {
        try {
            FunctionTimerAspect.ajc$perSingletonInstance = new FunctionTimerAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(io.appform.functionmetrics.MonitoredFunction)")
    public /* synthetic */ void monitoredFunctionCalled() {
    }

    @Pointcut(value="execution(* *(..))")
    public /* synthetic */ void anyFunctionCalled() {
    }

    @Around(value="monitoredFunctionCalled() && anyFunctionCalled()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        List paramValues;
        Signature callSignature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)MethodSignature.class.cast(callSignature);
        MonitoredFunction monitoredFunction = methodSignature.getMethod().getAnnotation(MonitoredFunction.class);
        String className = Strings.isNullOrEmpty((String)monitoredFunction.className()) ? callSignature.getDeclaringType().getSimpleName() : monitoredFunction.className();
        String methodName = Strings.isNullOrEmpty((String)monitoredFunction.method()) ? callSignature.getName() : monitoredFunction.method();
        methodSignature.getParameterNames();
        Options options = FunctionMetricsManager.getOptions();
        String parameterString = "";
        if (options != null && options.isEnableParameterCapture() && (paramValues = Streams.zip(Arrays.stream(methodSignature.getMethod().getParameters()), Arrays.stream(joinPoint.getArgs()), Pair::new).map(pair -> {
            MetricTerm metricTerm = ((Parameter)pair.getKey()).getAnnotation(MetricTerm.class);
            if (metricTerm == null) {
                return null;
            }
            pair.getValue();
            String paramValueStr = this.convertToString(pair.getValue()).trim();
            boolean matches = FunctionMetricConstants.VALID_PARAM_VALUE_PATTERN.matcher(paramValueStr).matches();
            String sanitizedParamValue = matches ? options.getCaseFormat().to(CaseFormat.LOWER_CAMEL, paramValueStr) : "";
            return new Pair((Object)metricTerm.order(), (Object)sanitizedParamValue);
        }).filter(Objects::nonNull).sorted(Comparator.comparingInt(Pair::getKey)).map(Pair::getValue).collect(Collectors.toList())).stream().noneMatch(Strings::isNullOrEmpty)) {
            parameterString = Joiner.on((String)".").join(paramValues);
        }
        log.trace("Called for class: {} method: {} parameterString: {}", new Object[]{className, methodName, parameterString});
        FunctionInvocation invocation = new FunctionInvocation(className, methodName, parameterString);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Object response = joinPoint.proceed();
            stopwatch.stop();
            FunctionMetricsManager.timer(TimerDomain.SUCCESS, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
            Object object = response;
            return object;
        }
        catch (Throwable t) {
            stopwatch.stop();
            FunctionMetricsManager.timer(TimerDomain.FAILURE, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
            throw t;
        }
        finally {
            FunctionMetricsManager.timer(TimerDomain.ALL, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
        }
    }

    private void updateTimer(Timer timer, Stopwatch stopwatch) {
        timer.update(stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    private String convertToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        return "";
    }

    public static FunctionTimerAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.appform.functionmetrics.FunctionTimerAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

