/*
 * Decompiled with CFR 0.152.
 */
package io.appform.functionmetrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.appform.functionmetrics.FunctionInvocation;
import io.appform.functionmetrics.TimerDomain;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionMetricsManager {
    private static final Logger log = LoggerFactory.getLogger((String)FunctionMetricsManager.class.getSimpleName());
    private static MetricRegistry registry;
    private static String prefix;

    private FunctionMetricsManager() {
    }

    public static void initialize(String packageName, MetricRegistry registry) {
        log.info("Functional Metric prefix: {}", (Object)packageName);
        FunctionMetricsManager.registry = registry;
        prefix = packageName;
    }

    public static Optional<Timer> timer(TimerDomain domain, FunctionInvocation invocation) {
        if (registry == null) {
            log.warn("Please call FunctionalMetricsManager.initialize() to setup metrics collection. No metrics will be pushed.");
            return Optional.empty();
        }
        return Optional.of(registry.timer(String.format("%s.%s.%s.%s", prefix, invocation.getClassName(), invocation.getMethodName(), domain.getValue())));
    }
}

