/*
 * Decompiled with CFR 0.152.
 */
package io.appform.functionmetrics;

import com.codahale.metrics.Timer;
import com.google.common.base.Stopwatch;
import io.appform.functionmetrics.FunctionInvocation;
import io.appform.functionmetrics.FunctionMetricsManager;
import io.appform.functionmetrics.TimerDomain;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class FunctionTimerAspect {
    private static final Logger log = LoggerFactory.getLogger((String)FunctionTimerAspect.class.getSimpleName());
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ FunctionTimerAspect ajc$perSingletonInstance;

    static {
        try {
            FunctionTimerAspect.ajc$perSingletonInstance = new FunctionTimerAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(io.appform.functionmetrics.MonitoredFunction)")
    public /* synthetic */ void monitoredFunctionCalled() {
    }

    @Pointcut(value="execution(* *(..))")
    public /* synthetic */ void anyFunctionCalled() {
    }

    @Around(value="monitoredFunctionCalled() && anyFunctionCalled()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature callSignature = joinPoint.getSignature();
        String className = callSignature.getDeclaringType().getSimpleName();
        String methodName = callSignature.getName();
        FunctionTimerAspect.log.trace("Called for class: {} method: {}", (Object)className, (Object)methodName);
        FunctionInvocation invocation = new FunctionInvocation(className, methodName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Object response = joinPoint.proceed();
            stopwatch.stop();
            FunctionMetricsManager.timer(TimerDomain.SUCCESS, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
            Object object = response;
            return object;
        }
        catch (Throwable t) {
            stopwatch.stop();
            FunctionMetricsManager.timer(TimerDomain.FAILURE, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
            throw t;
        }
        finally {
            FunctionMetricsManager.timer(TimerDomain.ALL, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
        }
    }

    private void updateTimer(Timer timer, Stopwatch stopwatch) {
        timer.update(stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public static FunctionTimerAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.appform.functionmetrics.FunctionTimerAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

