/*
 * Decompiled with CFR 0.152.
 */
package io.appform.functionmetrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import io.appform.functionmetrics.FunctionInvocation;
import io.appform.functionmetrics.TimerDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionalMetricsManager {
    private static final Logger log = LoggerFactory.getLogger((String)FunctionalMetricsManager.class.getSimpleName());
    private static MetricRegistry registry;
    private static String prefix;

    private FunctionalMetricsManager() {
    }

    public static void initialize(String packageName, MetricRegistry registry) {
        log.info("Functional Metric prefix: {}", (Object)packageName);
        FunctionalMetricsManager.registry = registry;
        prefix = packageName;
    }

    public static Timer timer(TimerDomain domain, FunctionInvocation invocation) {
        Preconditions.checkNotNull((Object)registry, (Object)"Please call FunctionalMetricsManager.initialize() to setup metrics collection");
        return registry.timer(String.format("%s.%s.%s.%s", prefix, invocation.getClassName(), invocation.getMethodName(), domain.getValue()));
    }
}

