/*
 * Decompiled with CFR 0.152.
 */
package me.g_fresh.dropwizard.metrics.collectd;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.collectd.CollectdReporter;
import com.codahale.metrics.collectd.SecurityLevel;
import com.codahale.metrics.collectd.Sender;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseReporterFactory;
import io.dropwizard.validation.OneOf;
import io.dropwizard.validation.ValidationMethod;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="collectd")
public class CollectdReporterFactory
extends BaseReporterFactory {
    @NotNull
    private String host;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    private int port;
    private String localHost;
    @OneOf(value={"NONE", "SIGN", "ENCRYPT"})
    private @OneOf(value={"NONE", "SIGN", "ENCRYPT"}) SecurityLevel securityLevel = SecurityLevel.NONE;
    private String username;
    private String password;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(SecurityLevel level) {
        this.securityLevel = level;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ValidationMethod(message="username and password are required when using security level SIGN or ENCRYPT.")
    boolean isSecurityLevelConfiguredCorrectly() {
        boolean credentialsRequired;
        boolean bl = credentialsRequired = this.securityLevel != SecurityLevel.NONE;
        if (credentialsRequired) {
            return CollectdReporterFactory.isNotBlank(this.username) && CollectdReporterFactory.isNotBlank(this.password);
        }
        return true;
    }

    private static boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public ScheduledReporter build(MetricRegistry registry) {
        return CollectdReporter.forRegistry((MetricRegistry)registry).withHostName(this.localHost).withSecurityLevel(this.getSecurityLevel()).withUsername(this.username).withPassword(this.password).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).build(new Sender(this.host, this.port));
    }
}

