/*
 * Decompiled with CFR 0.152.
 */
package io.appform.core.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import io.appform.core.hystrix.HandlerAdapter;
import rx.Observable;

public class GenericHystrixCommand<ReturnType> {
    private final HystrixObservableCommand.Setter setter;

    public GenericHystrixCommand(HystrixObservableCommand.Setter setter) {
        this.setter = setter;
    }

    public HystrixObservableCommand<ReturnType> executor(final HandlerAdapter<ReturnType> function) throws Exception {
        return new HystrixObservableCommand<ReturnType>(this.setter){

            protected Observable<ReturnType> construct() {
                return Observable.create(observer -> {
                    if (!observer.isUnsubscribed()) {
                        try {
                            observer.onNext(function.run());
                            observer.onCompleted();
                        }
                        catch (Throwable t) {
                            observer.onError(t);
                        }
                    }
                });
            }
        };
    }
}

