/*
 * Decompiled with CFR 0.152.
 */
package com.domain;

import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Range<T extends Comparable<T>>
implements Serializable {
    private T from;
    private T upto;
    private boolean includeLower;
    private boolean includeUpper;

    public static <T extends Comparable<T>> Range<T> of(T from, T upto, boolean includeLower, boolean includeUpper) {
        return new Range<T>(from, upto).includeLower(includeLower).includeUpper(includeUpper);
    }

    public Range() {
    }

    public Range(Range<T> range) {
        if (range != null) {
            this.from = range.from;
            this.upto = range.upto;
        }
    }

    public Range(T from, T upto) {
        this.from = from;
        this.upto = upto;
    }

    public Range<T> gt(T value) {
        return this.from(value).includeLower(false);
    }

    public Range<T> gte(T value) {
        return this.from(value).includeLower(true);
    }

    public Range<T> lt(T value) {
        return this.upto(value).includeUpper(false);
    }

    public Range<T> lte(T value) {
        return this.upto(value).includeUpper(true);
    }

    public Range<T> from(T from) {
        this.from = from;
        return this;
    }

    public Range<T> upto(T upto) {
        this.upto = upto;
        return this;
    }

    public Range<T> includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public Range<T> includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public T getFrom() {
        return this.from;
    }

    public void setFrom(T from) {
        this.from = from;
    }

    public T getUpto() {
        return this.upto;
    }

    public void setUpto(T upto) {
        this.upto = upto;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public void setIncludeLower(boolean includeLower) {
        this.includeLower = includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    public void setIncludeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
    }

    public boolean isWithinRange(T value) {
        if (value == null) {
            return false;
        }
        int cmp = value.compareTo(this.from);
        if (cmp < 0) {
            return false;
        }
        cmp = value.compareTo(this.upto);
        return cmp <= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.includeLower != range.includeLower) {
            return false;
        }
        if (this.includeUpper != range.includeUpper) {
            return false;
        }
        if (this.from != null ? !this.from.equals(range.from) : range.from != null) {
            return false;
        }
        return !(this.upto != null ? !this.upto.equals(range.upto) : range.upto != null);
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.upto != null ? this.upto.hashCode() : 0);
        result = 31 * result + (this.includeLower ? 1 : 0);
        result = 31 * result + (this.includeUpper ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Range{from=" + this.from + ", upto=" + this.upto + ", includeLower=" + this.includeLower + ", includeUpper=" + this.includeUpper + '}';
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public boolean isValid() {
        return this.from != null || this.upto != null;
    }
}

