(ns invetica.spec
  "Perfunctory docstring."
  (:require
   [clojure.spec :as s]
   [clojure.spec.gen :as sgen]
   [clojure.string :as str]))

(s/def ::some-string-alphanumeric
  (s/with-gen string?
    (fn []
      (sgen/such-that (complement str/blank?) (sgen/string-alphanumeric)))))

(defn nilable
  [gen]
  (sgen/one-of (sgen/return nil) gen))

(defn opt-kvs
  [ks]
  (letfn [(k->kv [k] [(-> k name keyword) (s/gen (s/nilable k))])]
    (flatten (into [] (comp (map k->kv) cat) ks))))

(defn opt-hash-map
  [ks]
  (apply sgen/hash-map (into {} (filter (comp some? val)) (opt-kvs ks))))
