;; ## transplant
;; CLRS 3rd Edition pg. 323
(defn transplant [tree u v]
    (if (= (get-parent u) (get-sentinel tree))
        (set-root tree v)
        (if (= u (get-left (get-parent u)))
            (set-left (get-parent u) v)
            (set-right (get-parent u) v)))
    (let [parent (get-parent u) grandparent (get-parent parent)]
        (if (not= parent (get-sentinel tree))
            (update-max parent))
        (if (not= grandparent (get-sentinel tree))
            (update-max grandparent)))
    (set-parent v (get-parent u)))

;; ## delete-fixup-v3
;; The delete-fixup routine in CLRS 3rd Edition
;; pg 326
(defn delete-fixup-v3 [tree node]
    (let [x (ref node) w (ref nil) sentinel (get-sentinel tree) root (get-root tree)]
        (while (and (not= @x root) (= (get-color @x) black))
            (if (= @x (get-left (get-parent @x)))
                (do
                    (ref-set w (get-right (get-parent @x)))
                    (if (= (get-color @w) red)
                        (do
                            (set-color @w black)
                            (set-color (get-parent @x) red)
                            (left-rotate tree (get-parent @x))))
                    (if (and (not= (get-left @w) nil)
                             (not= (get-right @w) nil)
                             (= (get-color (get-left @w)) black)
                             (= (get-color (get-right @w)) black))
                        (do
                            (set-color @w red)
                            (ref-set x (get-parent @x)))
                        (do
                            (if (and (not= (get-right @w) nil)
                                     (= (get-color (get-right @w)) black))
                                (do
                                    (set-color (get-left @w) black)
                                    (set-color @w red)
                                    (right-rotate tree @w)
                                    (ref-set w (get-right (get-parent @x)))))
                            (set-color @w (get-color (get-parent @x)))
                            (set-color (get-parent @x) black)
                            (if (not= (get-right @w) nil)
                                (set-color (get-right @w) black))
                            (left-rotate tree (get-parent @x))
                            (ref-set x root))))
                (do
                    (ref-set w (get-left (get-parent @x)))
                    (if (= (get-color @w) red)
                        (do
                            (set-color @w black)
                            (set-color (get-parent @x) red)
                            (right-rotate tree (get-parent @x))))
                    (if (and (not= (get-right @w) nil)
                             (not= (get-left @w) nil)
                             (= (get-color (get-right @w)) black)
                             (= (get-color (get-left @w)) black))
                        (do
                            (set-color @w red)
                            (ref-set x (get-parent @x)))
                        (do
                            (if (and (not= (get-left @w) nil)
                                     (= (get-color (get-left @w)) black))
                                (do
                                    (set-color (get-right @w) black)
                                    (set-color @w red)
                                    (left-rotate tree @w)
                                    (ref-set w (get-left (get-parent @x)))))
                            (set-color @w (get-color (get-parent @x)))
                            (set-color (get-parent @x) black)
                            (if (not= (get-left @w) nil)
                                (set-color (get-left @w) black))
                            (right-rotate tree (get-parent @x))
                            (ref-set x root))))))
        (set-color @x black)))

;; ## delete-v3
;; The delete routine in CLRS 3rd Edition
;; pg 324
(defn delete-v3 [tree interval]
    (dosync
        (let [z (ref (lookup-node tree interval))]
            (if (not= @z nil)
                (let [y (ref @z) x (ref nil) y-original-color (ref (get-color @y)) sentinel (get-sentinel tree)]
                    (if (= (get-left @z) sentinel)
                        (do
                            (ref-set x (get-right @z))
                            (transplant tree @z (get-right @z)))
                        (if (= (get-right @z) sentinel)
                            (do
                                (ref-set x (get-left @z))
                                (transplant tree @z (get-left @z)))
                            (do
                                (ref-set y (tree-minimum tree (get-right @z)))
                                (ref-set y-original-color (get-color @y))
                                (ref-set x (get-right @y))
                                (if (= (get-parent @y) @z)
                                    (set-parent @x @y)
                                    (do
                                        (transplant tree @y (get-right @y))
                                        (set-right @y (get-right @z))
                                        (set-parent (get-right @y) @y)))
                                (transplant tree @z @y)
                                (set-left @y (get-left @z))
                                (set-parent (get-left @y) @y)
                                (set-color @y (get-color @z))
                                (update-max @y)
                                (let [parent (get-parent @y)]
                                    (if (not= parent sentinel)
                                        (update-max parent))))))
                    (if (= @y-original-color black)
                        (delete-fixup-v3 tree @x)))))))