# interval-tree

[![Build Status](https://travis-ci.org/mobiusinversion/interval-tree.png)](https://travis-ci.org/mobiusinversion/interval-tree)


From https://travis-ci.org/mobiusinversion/interval-tree - a fix to resolve issues with versioning between readme, git and clojars.

A Clojure library for creating and querying interval trees.  The underlying
tree is an augmented red-black tree following CLRS, second edition, fourth printing.

Leiningen

    :dependencies [[interval-tree "0.2.7"]]

## Usage

    (:require [interval-tree.core :as it])

    ;; Make a new interval-tree
    (def tree it/new)

    ;; (it/insert interval payload)
    ;; the tree stores arbitrary interval value pairs

    ;; Insert some interval value pairs
    (it/insert tree [-2 6.5] {:data "this is my value payload"})
    (it/insert tree [8 42] :gaz)
    (it/insert tree [3.14 16.9] [:waka-waka {:data "more data"}]

    ;; get the value payload associated with this interval
    (println (it/lookup [8 42]))

    ;; delete this node
    (it/delete tree [8 42])

    ;; Returns a vector of all interval values pairs
    ;; such that each interval contains 9
    (it/point-query tree 9)

    ;; Returns a vector of all interval values pairs
    ;; such that each interval non-trivially intersects [3.14 42]
    (it/interval-query tree [3.14 42])

## Note

This implementation allows duplicate intervals, so each of the following will add another node to the tree:

    (it/insert tree [4 5] :foo)
    (it/insert tree [4 5] :bar)
    (it/insert tree [4.0 5.00] :gaz)
    (it/insert tree [4.0000 5.0000] :gaz)

Delete operations will remove the first node found with that interval.

    (it/insert tree [4 5] :foo)
    (it/insert tree [4 5] :bar)

    ;; Deletes only one node, the first one found
    (it/delete [4 5])

The delete-all function will delete all occurances of that interval in the tree

    (it/insert tree [4 5] :foo)
	(it/insert tree [4 5] :bar)
	(it/insert tree [4.0000 5.000] :gaz)
	(it/insert tree [4.0000 5.000] :waka-waka)

	;; Deletes all four
	(it/delete-all [4 5])

Hence how duplicates are handled is left to the user.  If you need unique nodes, please dedupe prior to tree insertion.

## License

Copyright  2013 David Williams

Distributed under the Eclipse Public License, the same as Clojure.

