// Compiled by ClojureScript 1.9.293 {}
goog.provide('imcljs.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.spec');
imcljs.query.value = (function imcljs$query$value(x){
return [cljs.core.str("<value>"),cljs.core.str(x),cljs.core.str("</value>")].join('');
});
/**
 * xml string representation of an edn map.
 *   (map->xlmstr constraint {:key1 val1 key2 val2}) => <constraint key1=val1 key2=val2 />
 */
imcljs.query.map__GT_xmlstr = (function imcljs$query$map__GT_xmlstr(elem,m){
var m__$1 = cljs.core.select_keys.call(null,m,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"values","values",372645556),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"code","code",1586293142)], null));
var values = new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(m__$1);
return [cljs.core.str("<"),cljs.core.str(elem),cljs.core.str(" "),cljs.core.str(cljs.core.reduce.call(null,((function (m__$1,values){
return (function (total,p__36457){
var vec__36458 = p__36457;
var k = cljs.core.nth.call(null,vec__36458,(0),null);
var v = cljs.core.nth.call(null,vec__36458,(1),null);
if(cljs.core.not_EQ_.call(null,k,new cljs.core.Keyword(null,"values","values",372645556))){
return [cljs.core.str(total),cljs.core.str((cljs.core.truth_(total)?" ":null)),cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str("="),cljs.core.str([cljs.core.str("\""),cljs.core.str(v),cljs.core.str("\"")].join(''))].join('');
} else {
return total;
}
});})(m__$1,values))
,null,m__$1)),cljs.core.str((cljs.core.truth_(values)?[cljs.core.str(">"),cljs.core.str(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,imcljs.query.value,values))),cljs.core.str("</"),cljs.core.str(elem),cljs.core.str(">")].join(''):"/>"))].join('');
});
imcljs.query.stringiy_map = (function imcljs$query$stringiy_map(m){
return cljs.core.reduce.call(null,(function (total,p__36465){
var vec__36466 = p__36465;
var k = cljs.core.nth.call(null,vec__36466,(0),null);
var v = cljs.core.nth.call(null,vec__36466,(1),null);
return [cljs.core.str(total),cljs.core.str((cljs.core.truth_(total)?" ":null)),cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str("="),cljs.core.str([cljs.core.str("\""),cljs.core.str(v),cljs.core.str("\"")].join(''))].join('');
}),null,m);
});
imcljs.query.enforce_origin = (function imcljs$query$enforce_origin(query){
if((new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query) == null)){
return cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"from","from",1815293044),cljs.core.first.call(null,clojure.string.split.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(query)),".")));
} else {
return query;
}
});
imcljs.query.enforce_views_have_class = (function imcljs$query$enforce_views_have_class(query){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.partial.call(null,cljs.core.mapv,(function (path){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query),cljs.core.first.call(null,clojure.string.split.call(null,path,".")))){
return path;
} else {
return [cljs.core.str(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query)),cljs.core.str("."),cljs.core.str(path)].join('');
}
})));
});
imcljs.query.enforce_sorting = (function imcljs$query$enforce_sorting(query){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),cljs.core.partial.call(null,cljs.core.map,(function (order){
var order__$1 = (((new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(order) == null))?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),[cljs.core.str(cljs.core.name.call(null,cljs.core.first.call(null,cljs.core.first.call(null,cljs.core.seq.call(null,order)))))].join(''),new cljs.core.Keyword(null,"direction","direction",-633359395),cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.seq.call(null,order)))], null):order);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query),cljs.core.first.call(null,clojure.string.split.call(null,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(order__$1),".")))){
return order__$1;
} else {
return cljs.core.assoc.call(null,order__$1,new cljs.core.Keyword(null,"path","path",-188191168),[cljs.core.str(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query)),cljs.core.str("."),cljs.core.str(new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(order__$1))].join(''));
}
})));
});
imcljs.query.sterilize_query = cljs.core.comp.call(null,imcljs.query.enforce_sorting,imcljs.query.enforce_views_have_class,imcljs.query.enforce_origin);
/**
 * Returns the stringfied XML representation of an EDN intermine query.
 */
imcljs.query.__GT_xml = (function imcljs$query$__GT_xml(model,query){
var query__$1 = imcljs.query.sterilize_query.call(null,query);
var head_attributes = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(model),new cljs.core.Keyword(null,"view","view",1247994814),clojure.string.join.call(null," ",new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(query__$1)),new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514),clojure.string.join.call(null," ",cljs.core.flatten.call(null,cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"direction","direction",-633359395)),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(query__$1))))], null);
return [cljs.core.str("<query "),cljs.core.str(imcljs.query.stringiy_map.call(null,head_attributes)),cljs.core.str(">"),cljs.core.str(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.query.map__GT_xmlstr,"constraint"),new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(query__$1)))),cljs.core.str("</query>")].join('');
});

//# sourceMappingURL=query.js.map