// Compiled by ClojureScript 1.9.293 {}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.utils');
goog.require('clojure.string');
imcljs.path.path_types = new cljs.core.PersistentArrayMap(null, 6, [null,new cljs.core.Keyword(null,"class","class",-2030961996),"java.lang.String",new cljs.core.Keyword(null,"string","string",-1989541586),"java.lang.Boolean",new cljs.core.Keyword(null,"boolean","boolean",-1919418404),"java.lang.Integer",new cljs.core.Keyword(null,"integer","integer",-604721710),"java.lang.Double",new cljs.core.Keyword(null,"double","double",884886883),"java.lang.Float",new cljs.core.Keyword(null,"float","float",-1732389368)], null);
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path_str,"."));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.core.name,path_str));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,class_kw,field_kw){
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null))),field_kw)));
});
imcljs.path.is_attribute = (function imcljs$path$is_attribute(class$,value){
return cljs.core.get_in.call(null,class$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),value], null));
});
/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 */
imcljs.path.walk = (function imcljs$path$walk(var_args){
var args34879 = [];
var len__28114__auto___34889 = arguments.length;
var i__28115__auto___34890 = (0);
while(true){
if((i__28115__auto___34890 < len__28114__auto___34889)){
args34879.push((arguments[i__28115__auto___34890]));

var G__34891 = (i__28115__auto___34890 + (1));
i__28115__auto___34890 = G__34891;
continue;
} else {
}
break;
}

var G__34881 = args34879.length;
switch (G__34881) {
case 2:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34879.length)].join('')));

}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
return imcljs.path.walk.call(null,model,((typeof path === 'string')?imcljs.path.split_path.call(null,path):path),cljs.core.PersistentVector.EMPTY);
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$3 = (function (model,p__34882,trail){
while(true){
var vec__34883 = p__34882;
var seq__34884 = cljs.core.seq.call(null,vec__34883);
var first__34885 = cljs.core.first.call(null,seq__34884);
var seq__34884__$1 = cljs.core.next.call(null,seq__34884);
var class_kw = first__34885;
var vec__34886 = seq__34884__$1;
var seq__34887 = cljs.core.seq.call(null,vec__34886);
var first__34888 = cljs.core.first.call(null,seq__34887);
var seq__34887__$1 = cljs.core.next.call(null,seq__34887);
var path = first__34888;
var remaining = seq__34887__$1;
var temp__6745__auto__ = imcljs.path.is_attribute.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),path);
if(cljs.core.truth_(temp__6745__auto__)){
var attribute = temp__6745__auto__;
return cljs.core.reduce.call(null,cljs.core.conj,trail,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),attribute], null));
} else {
var temp__6745__auto____$1 = imcljs.path.referenced_class.call(null,model,class_kw,path);
if(cljs.core.truth_(temp__6745__auto____$1)){
var class$ = temp__6745__auto____$1;
var G__34893 = model;
var G__34894 = cljs.core.conj.call(null,remaining,class$);
var G__34895 = cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)));
model = G__34893;
p__34882 = G__34894;
trail = G__34895;
continue;
} else {
if(cljs.core.not.call(null,path)){
var temp__6745__auto____$2 = cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null));
if(cljs.core.truth_(temp__6745__auto____$2)){
var final$ = temp__6745__auto____$2;
return cljs.core.conj.call(null,trail,final$);
} else {
return null;
}
} else {
return null;
}
}
}
break;
}
});

imcljs.path.walk.cljs$lang$maxFixedArity = 3;

/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
var temp__6745__auto__ = imcljs.path.walk.call(null,model,path);
if(cljs.core.truth_(temp__6745__auto__)){
var walked = temp__6745__auto__;
return cljs.core.get.call(null,imcljs.path.path_types,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,walked)));
} else {
return null;
}
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__34896_SHARP_){
return imcljs.utils.does_not_contain_QMARK_.call(null,p1__34896_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,done)));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__34897_SHARP_){
return imcljs.utils.does_not_contain_QMARK_.call(null,p1__34897_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return imcljs.path.join_path.call(null,cljs.core.take.call(null,cljs.core.count.call(null,done),imcljs.path.split_path.call(null,path)));
});

//# sourceMappingURL=path.js.map