// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__26886__auto__ = v;
if(cljs.core.truth_(and__26886__auto__)){
return (v > (0));
} else {
return and__26886__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__34901_SHARP_,p2__34900_SHARP_){
var vec__34905 = clojure.string.split.call(null,p2__34900_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__34905,(0),null);
var v = cljs.core.nth.call(null,vec__34905,(1),null);
return cljs.core.assoc.call(null,p1__34901_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode.call(null,[cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__34908_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__34908_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__34909){
var vec__34913 = p__34909;
var k = cljs.core.nth.call(null,vec__34913,(0),null);
var v = cljs.core.nth.call(null,vec__34913,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__34916_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__34916_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__26886__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__26886__auto__){
var and__26886__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__26886__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__26886__auto____$1;
}
} else {
return and__26886__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var params = temp__6745__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__34917_SHARP_){
return cljs_http.client.decode_body.call(null,p1__34917_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__28121__auto__ = [];
var len__28114__auto___34924 = arguments.length;
var i__28115__auto___34925 = (0);
while(true){
if((i__28115__auto___34925 < len__28114__auto___34924)){
args__28121__auto__.push((arguments[i__28115__auto___34925]));

var G__34926 = (i__28115__auto___34925 + (1));
i__28115__auto___34925 = G__34926;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__34920){
var vec__34921 = p__34920;
var default_headers = cljs.core.nth.call(null,vec__34921,(0),null);
return ((function (vec__34921,default_headers){
return (function (request){
var temp__6745__auto__ = (function (){var or__26898__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__6745__auto__)){
var default_headers__$1 = temp__6745__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__34921,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq34918){
var G__34919 = cljs.core.first.call(null,seq34918);
var seq34918__$1 = cljs.core.next.call(null,seq34918);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__34919,seq34918__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__28121__auto__ = [];
var len__28114__auto___34933 = arguments.length;
var i__28115__auto___34934 = (0);
while(true){
if((i__28115__auto___34934 < len__28114__auto___34933)){
args__28121__auto__.push((arguments[i__28115__auto___34934]));

var G__34935 = (i__28115__auto___34934 + (1));
i__28115__auto___34934 = G__34935;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__34929){
var vec__34930 = p__34929;
var accept = cljs.core.nth.call(null,vec__34930,(0),null);
return ((function (vec__34930,accept){
return (function (request){
var temp__6745__auto__ = (function (){var or__26898__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__6745__auto__)){
var accept__$1 = temp__6745__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__34930,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq34927){
var G__34928 = cljs.core.first.call(null,seq34927);
var seq34927__$1 = cljs.core.next.call(null,seq34927);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__34928,seq34927__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__28121__auto__ = [];
var len__28114__auto___34942 = arguments.length;
var i__28115__auto___34943 = (0);
while(true){
if((i__28115__auto___34943 < len__28114__auto___34942)){
args__28121__auto__.push((arguments[i__28115__auto___34943]));

var G__34944 = (i__28115__auto___34943 + (1));
i__28115__auto___34943 = G__34944;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__34938){
var vec__34939 = p__34938;
var content_type = cljs.core.nth.call(null,vec__34939,(0),null);
return ((function (vec__34939,content_type){
return (function (request){
var temp__6745__auto__ = (function (){var or__26898__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__6745__auto__)){
var content_type__$1 = temp__6745__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__34939,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq34936){
var G__34937 = cljs.core.first.call(null,seq34936);
var seq34936__$1 = cljs.core.next.call(null,seq34936);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__34937,seq34936__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var params = temp__6745__auto__;
var map__34947 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__34947__$1 = ((((!((map__34947 == null)))?((((map__34947.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34947.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34947):map__34947);
var encoding = cljs.core.get.call(null,map__34947__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__34947__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__34953 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__34953__$1 = ((((!((map__34953 == null)))?((((map__34953.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34953.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34953):map__34953);
var decoding = cljs.core.get.call(null,map__34953__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__34953__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__34953,map__34953__$1,decoding,decoding_opts){
return (function (p1__34949_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__34949_SHARP_,decoding,decoding_opts);
});})(map__34953,map__34953__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__34953,map__34953__$1,decoding,decoding_opts,transit_decode){
return (function (p1__34950_SHARP_){
return cljs_http.client.decode_body.call(null,p1__34950_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__34953,map__34953__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var params = temp__6745__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__34955_SHARP_){
return cljs_http.client.decode_body.call(null,p1__34955_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__34959){
var map__34960 = p__34959;
var map__34960__$1 = ((((!((map__34960 == null)))?((((map__34960.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34960.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34960):map__34960);
var req = map__34960__$1;
var query_params = cljs.core.get.call(null,map__34960__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__34965){
var map__34966 = p__34965;
var map__34966__$1 = ((((!((map__34966 == null)))?((((map__34966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34966.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34966):map__34966);
var request = map__34966__$1;
var form_params = cljs.core.get.call(null,map__34966__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__34966__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__34966__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__26886__auto__ = form_params;
if(cljs.core.truth_(and__26886__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__26886__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__34978_34988 = cljs.core.seq.call(null,params);
var chunk__34979_34989 = null;
var count__34980_34990 = (0);
var i__34981_34991 = (0);
while(true){
if((i__34981_34991 < count__34980_34990)){
var vec__34982_34992 = cljs.core._nth.call(null,chunk__34979_34989,i__34981_34991);
var k_34993 = cljs.core.nth.call(null,vec__34982_34992,(0),null);
var v_34994 = cljs.core.nth.call(null,vec__34982_34992,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_34994)){
form_data.append(cljs.core.name.call(null,k_34993),cljs.core.first.call(null,v_34994),cljs.core.second.call(null,v_34994));
} else {
form_data.append(cljs.core.name.call(null,k_34993),v_34994);
}

var G__34995 = seq__34978_34988;
var G__34996 = chunk__34979_34989;
var G__34997 = count__34980_34990;
var G__34998 = (i__34981_34991 + (1));
seq__34978_34988 = G__34995;
chunk__34979_34989 = G__34996;
count__34980_34990 = G__34997;
i__34981_34991 = G__34998;
continue;
} else {
var temp__6747__auto___34999 = cljs.core.seq.call(null,seq__34978_34988);
if(temp__6747__auto___34999){
var seq__34978_35000__$1 = temp__6747__auto___34999;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34978_35000__$1)){
var c__27804__auto___35001 = cljs.core.chunk_first.call(null,seq__34978_35000__$1);
var G__35002 = cljs.core.chunk_rest.call(null,seq__34978_35000__$1);
var G__35003 = c__27804__auto___35001;
var G__35004 = cljs.core.count.call(null,c__27804__auto___35001);
var G__35005 = (0);
seq__34978_34988 = G__35002;
chunk__34979_34989 = G__35003;
count__34980_34990 = G__35004;
i__34981_34991 = G__35005;
continue;
} else {
var vec__34985_35006 = cljs.core.first.call(null,seq__34978_35000__$1);
var k_35007 = cljs.core.nth.call(null,vec__34985_35006,(0),null);
var v_35008 = cljs.core.nth.call(null,vec__34985_35006,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_35008)){
form_data.append(cljs.core.name.call(null,k_35007),cljs.core.first.call(null,v_35008),cljs.core.second.call(null,v_35008));
} else {
form_data.append(cljs.core.name.call(null,k_35007),v_35008);
}

var G__35009 = cljs.core.next.call(null,seq__34978_35000__$1);
var G__35010 = null;
var G__35011 = (0);
var G__35012 = (0);
seq__34978_34988 = G__35009;
chunk__34979_34989 = G__35010;
count__34980_34990 = G__35011;
i__34981_34991 = G__35012;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__35016){
var map__35017 = p__35016;
var map__35017__$1 = ((((!((map__35017 == null)))?((((map__35017.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35017.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35017):map__35017);
var request = map__35017__$1;
var multipart_params = cljs.core.get.call(null,map__35017__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__35017__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__26886__auto__ = multipart_params;
if(cljs.core.truth_(and__26886__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__26886__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__6745__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6745__auto__)){
var m = temp__6745__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__35019_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__35019_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__35024){
var map__35025 = p__35024;
var map__35025__$1 = ((((!((map__35025 == null)))?((((map__35025.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35025.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35025):map__35025);
var req = map__35025__$1;
var query_params = cljs.core.get.call(null,map__35025__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__6745__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__6745__auto__)){
var spec = temp__6745__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__6745__auto__,map__35025,map__35025__$1,req,query_params){
return (function (p1__35020_SHARP_){
return cljs.core.merge.call(null,p1__35020_SHARP_,query_params);
});})(spec,temp__6745__auto__,map__35025,map__35025__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35033 = arguments.length;
var i__28115__auto___35034 = (0);
while(true){
if((i__28115__auto___35034 < len__28114__auto___35033)){
args__28121__auto__.push((arguments[i__28115__auto___35034]));

var G__35035 = (i__28115__auto___35034 + (1));
i__28115__auto___35034 = G__35035;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35029){
var vec__35030 = p__35029;
var credentials = cljs.core.nth.call(null,vec__35030,(0),null);
return ((function (vec__35030,credentials){
return (function (req){
var credentials__$1 = (function (){var or__26898__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__35030,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq35027){
var G__35028 = cljs.core.first.call(null,seq35027);
var seq35027__$1 = cljs.core.next.call(null,seq35027);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__35028,seq35027__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__6745__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6745__auto__)){
var oauth_token = temp__6745__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__6745__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6745__auto__)){
var custom_channel = temp__6745__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35042 = arguments.length;
var i__28115__auto___35043 = (0);
while(true){
if((i__28115__auto___35043 < len__28114__auto___35042)){
args__28121__auto__.push((arguments[i__28115__auto___35043]));

var G__35044 = (i__28115__auto___35043 + (1));
i__28115__auto___35043 = G__35044;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35038){
var vec__35039 = p__35038;
var req = cljs.core.nth.call(null,vec__35039,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq35036){
var G__35037 = cljs.core.first.call(null,seq35036);
var seq35036__$1 = cljs.core.next.call(null,seq35036);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__35037,seq35036__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35051 = arguments.length;
var i__28115__auto___35052 = (0);
while(true){
if((i__28115__auto___35052 < len__28114__auto___35051)){
args__28121__auto__.push((arguments[i__28115__auto___35052]));

var G__35053 = (i__28115__auto___35052 + (1));
i__28115__auto___35052 = G__35053;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35047){
var vec__35048 = p__35047;
var req = cljs.core.nth.call(null,vec__35048,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq35045){
var G__35046 = cljs.core.first.call(null,seq35045);
var seq35045__$1 = cljs.core.next.call(null,seq35045);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__35046,seq35045__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35060 = arguments.length;
var i__28115__auto___35061 = (0);
while(true){
if((i__28115__auto___35061 < len__28114__auto___35060)){
args__28121__auto__.push((arguments[i__28115__auto___35061]));

var G__35062 = (i__28115__auto___35061 + (1));
i__28115__auto___35061 = G__35062;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35056){
var vec__35057 = p__35056;
var req = cljs.core.nth.call(null,vec__35057,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq35054){
var G__35055 = cljs.core.first.call(null,seq35054);
var seq35054__$1 = cljs.core.next.call(null,seq35054);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__35055,seq35054__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35069 = arguments.length;
var i__28115__auto___35070 = (0);
while(true){
if((i__28115__auto___35070 < len__28114__auto___35069)){
args__28121__auto__.push((arguments[i__28115__auto___35070]));

var G__35071 = (i__28115__auto___35070 + (1));
i__28115__auto___35070 = G__35071;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35065){
var vec__35066 = p__35065;
var req = cljs.core.nth.call(null,vec__35066,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq35063){
var G__35064 = cljs.core.first.call(null,seq35063);
var seq35063__$1 = cljs.core.next.call(null,seq35063);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__35064,seq35063__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35078 = arguments.length;
var i__28115__auto___35079 = (0);
while(true){
if((i__28115__auto___35079 < len__28114__auto___35078)){
args__28121__auto__.push((arguments[i__28115__auto___35079]));

var G__35080 = (i__28115__auto___35079 + (1));
i__28115__auto___35079 = G__35080;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35074){
var vec__35075 = p__35074;
var req = cljs.core.nth.call(null,vec__35075,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq35072){
var G__35073 = cljs.core.first.call(null,seq35072);
var seq35072__$1 = cljs.core.next.call(null,seq35072);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__35073,seq35072__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35087 = arguments.length;
var i__28115__auto___35088 = (0);
while(true){
if((i__28115__auto___35088 < len__28114__auto___35087)){
args__28121__auto__.push((arguments[i__28115__auto___35088]));

var G__35089 = (i__28115__auto___35088 + (1));
i__28115__auto___35088 = G__35089;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35083){
var vec__35084 = p__35083;
var req = cljs.core.nth.call(null,vec__35084,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq35081){
var G__35082 = cljs.core.first.call(null,seq35081);
var seq35081__$1 = cljs.core.next.call(null,seq35081);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__35082,seq35081__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35096 = arguments.length;
var i__28115__auto___35097 = (0);
while(true){
if((i__28115__auto___35097 < len__28114__auto___35096)){
args__28121__auto__.push((arguments[i__28115__auto___35097]));

var G__35098 = (i__28115__auto___35097 + (1));
i__28115__auto___35097 = G__35098;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35092){
var vec__35093 = p__35092;
var req = cljs.core.nth.call(null,vec__35093,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq35090){
var G__35091 = cljs.core.first.call(null,seq35090);
var seq35090__$1 = cljs.core.next.call(null,seq35090);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__35091,seq35090__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35105 = arguments.length;
var i__28115__auto___35106 = (0);
while(true){
if((i__28115__auto___35106 < len__28114__auto___35105)){
args__28121__auto__.push((arguments[i__28115__auto___35106]));

var G__35107 = (i__28115__auto___35106 + (1));
i__28115__auto___35106 = G__35107;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35101){
var vec__35102 = p__35101;
var req = cljs.core.nth.call(null,vec__35102,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq35099){
var G__35100 = cljs.core.first.call(null,seq35099);
var seq35099__$1 = cljs.core.next.call(null,seq35099);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__35100,seq35099__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__28121__auto__ = [];
var len__28114__auto___35114 = arguments.length;
var i__28115__auto___35115 = (0);
while(true){
if((i__28115__auto___35115 < len__28114__auto___35114)){
args__28121__auto__.push((arguments[i__28115__auto___35115]));

var G__35116 = (i__28115__auto___35115 + (1));
i__28115__auto___35115 = G__35116;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35110){
var vec__35111 = p__35110;
var req = cljs.core.nth.call(null,vec__35111,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq35108){
var G__35109 = cljs.core.first.call(null,seq35108);
var seq35108__$1 = cljs.core.next.call(null,seq35108);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__35109,seq35108__$1);
});


//# sourceMappingURL=client.js.map