// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args29638 = [];
var len__28114__auto___29644 = arguments.length;
var i__28115__auto___29645 = (0);
while(true){
if((i__28115__auto___29645 < len__28114__auto___29644)){
args29638.push((arguments[i__28115__auto___29645]));

var G__29646 = (i__28115__auto___29645 + (1));
i__28115__auto___29645 = G__29646;
continue;
} else {
}
break;
}

var G__29640 = args29638.length;
switch (G__29640) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29638.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async29641 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29641 = (function (f,blockable,meta29642){
this.f = f;
this.blockable = blockable;
this.meta29642 = meta29642;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29643,meta29642__$1){
var self__ = this;
var _29643__$1 = this;
return (new cljs.core.async.t_cljs$core$async29641(self__.f,self__.blockable,meta29642__$1));
});

cljs.core.async.t_cljs$core$async29641.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29643){
var self__ = this;
var _29643__$1 = this;
return self__.meta29642;
});

cljs.core.async.t_cljs$core$async29641.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29641.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29641.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async29641.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async29641.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29642","meta29642",851221117,null)], null);
});

cljs.core.async.t_cljs$core$async29641.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29641.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29641";

cljs.core.async.t_cljs$core$async29641.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async29641");
});

cljs.core.async.__GT_t_cljs$core$async29641 = (function cljs$core$async$__GT_t_cljs$core$async29641(f__$1,blockable__$1,meta29642){
return (new cljs.core.async.t_cljs$core$async29641(f__$1,blockable__$1,meta29642));
});

}

return (new cljs.core.async.t_cljs$core$async29641(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args29650 = [];
var len__28114__auto___29653 = arguments.length;
var i__28115__auto___29654 = (0);
while(true){
if((i__28115__auto___29654 < len__28114__auto___29653)){
args29650.push((arguments[i__28115__auto___29654]));

var G__29655 = (i__28115__auto___29654 + (1));
i__28115__auto___29654 = G__29655;
continue;
} else {
}
break;
}

var G__29652 = args29650.length;
switch (G__29652) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29650.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args29657 = [];
var len__28114__auto___29660 = arguments.length;
var i__28115__auto___29661 = (0);
while(true){
if((i__28115__auto___29661 < len__28114__auto___29660)){
args29657.push((arguments[i__28115__auto___29661]));

var G__29662 = (i__28115__auto___29661 + (1));
i__28115__auto___29661 = G__29662;
continue;
} else {
}
break;
}

var G__29659 = args29657.length;
switch (G__29659) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29657.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args29664 = [];
var len__28114__auto___29667 = arguments.length;
var i__28115__auto___29668 = (0);
while(true){
if((i__28115__auto___29668 < len__28114__auto___29667)){
args29664.push((arguments[i__28115__auto___29668]));

var G__29669 = (i__28115__auto___29668 + (1));
i__28115__auto___29668 = G__29669;
continue;
} else {
}
break;
}

var G__29666 = args29664.length;
switch (G__29666) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29664.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29671 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29671);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29671,ret){
return (function (){
return fn1.call(null,val_29671);
});})(val_29671,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args29672 = [];
var len__28114__auto___29675 = arguments.length;
var i__28115__auto___29676 = (0);
while(true){
if((i__28115__auto___29676 < len__28114__auto___29675)){
args29672.push((arguments[i__28115__auto___29676]));

var G__29677 = (i__28115__auto___29676 + (1));
i__28115__auto___29676 = G__29677;
continue;
} else {
}
break;
}

var G__29674 = args29672.length;
switch (G__29674) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29672.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6745__auto__)){
var ret = temp__6745__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6745__auto__)){
var retb = temp__6745__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6745__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6745__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27914__auto___29679 = n;
var x_29680 = (0);
while(true){
if((x_29680 < n__27914__auto___29679)){
(a[x_29680] = (0));

var G__29681 = (x_29680 + (1));
x_29680 = G__29681;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29682 = (i + (1));
i = G__29682;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async29686 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29686 = (function (flag,meta29687){
this.flag = flag;
this.meta29687 = meta29687;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29686.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29688,meta29687__$1){
var self__ = this;
var _29688__$1 = this;
return (new cljs.core.async.t_cljs$core$async29686(self__.flag,meta29687__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async29686.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29688){
var self__ = this;
var _29688__$1 = this;
return self__.meta29687;
});})(flag))
;

cljs.core.async.t_cljs$core$async29686.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29686.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async29686.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29686.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29686.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29687","meta29687",-2047123773,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async29686.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29686.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29686";

cljs.core.async.t_cljs$core$async29686.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async29686");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async29686 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29686(flag__$1,meta29687){
return (new cljs.core.async.t_cljs$core$async29686(flag__$1,meta29687));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async29686(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async29692 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29692 = (function (flag,cb,meta29693){
this.flag = flag;
this.cb = cb;
this.meta29693 = meta29693;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29694,meta29693__$1){
var self__ = this;
var _29694__$1 = this;
return (new cljs.core.async.t_cljs$core$async29692(self__.flag,self__.cb,meta29693__$1));
});

cljs.core.async.t_cljs$core$async29692.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29694){
var self__ = this;
var _29694__$1 = this;
return self__.meta29693;
});

cljs.core.async.t_cljs$core$async29692.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29692.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async29692.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29692.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async29692.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29693","meta29693",1436998975,null)], null);
});

cljs.core.async.t_cljs$core$async29692.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29692.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29692";

cljs.core.async.t_cljs$core$async29692.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async29692");
});

cljs.core.async.__GT_t_cljs$core$async29692 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29692(flag__$1,cb__$1,meta29693){
return (new cljs.core.async.t_cljs$core$async29692(flag__$1,cb__$1,meta29693));
});

}

return (new cljs.core.async.t_cljs$core$async29692(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29695_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29695_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29696_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29696_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26898__auto__ = wport;
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29697 = (i + (1));
i = G__29697;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26898__auto__ = ret;
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6747__auto__ = (function (){var and__26886__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26886__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26886__auto__;
}
})();
if(cljs.core.truth_(temp__6747__auto__)){
var got = temp__6747__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28121__auto__ = [];
var len__28114__auto___29703 = arguments.length;
var i__28115__auto___29704 = (0);
while(true){
if((i__28115__auto___29704 < len__28114__auto___29703)){
args__28121__auto__.push((arguments[i__28115__auto___29704]));

var G__29705 = (i__28115__auto___29704 + (1));
i__28115__auto___29704 = G__29705;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((1) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28122__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29700){
var map__29701 = p__29700;
var map__29701__$1 = ((((!((map__29701 == null)))?((((map__29701.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29701.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29701):map__29701);
var opts = map__29701__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29698){
var G__29699 = cljs.core.first.call(null,seq29698);
var seq29698__$1 = cljs.core.next.call(null,seq29698);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29699,seq29698__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args29706 = [];
var len__28114__auto___29756 = arguments.length;
var i__28115__auto___29757 = (0);
while(true){
if((i__28115__auto___29757 < len__28114__auto___29756)){
args29706.push((arguments[i__28115__auto___29757]));

var G__29758 = (i__28115__auto___29757 + (1));
i__28115__auto___29757 = G__29758;
continue;
} else {
}
break;
}

var G__29708 = args29706.length;
switch (G__29708) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29706.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29579__auto___29760 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___29760){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___29760){
return (function (state_29732){
var state_val_29733 = (state_29732[(1)]);
if((state_val_29733 === (7))){
var inst_29728 = (state_29732[(2)]);
var state_29732__$1 = state_29732;
var statearr_29734_29761 = state_29732__$1;
(statearr_29734_29761[(2)] = inst_29728);

(statearr_29734_29761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (1))){
var state_29732__$1 = state_29732;
var statearr_29735_29762 = state_29732__$1;
(statearr_29735_29762[(2)] = null);

(statearr_29735_29762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (4))){
var inst_29711 = (state_29732[(7)]);
var inst_29711__$1 = (state_29732[(2)]);
var inst_29712 = (inst_29711__$1 == null);
var state_29732__$1 = (function (){var statearr_29736 = state_29732;
(statearr_29736[(7)] = inst_29711__$1);

return statearr_29736;
})();
if(cljs.core.truth_(inst_29712)){
var statearr_29737_29763 = state_29732__$1;
(statearr_29737_29763[(1)] = (5));

} else {
var statearr_29738_29764 = state_29732__$1;
(statearr_29738_29764[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (13))){
var state_29732__$1 = state_29732;
var statearr_29739_29765 = state_29732__$1;
(statearr_29739_29765[(2)] = null);

(statearr_29739_29765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (6))){
var inst_29711 = (state_29732[(7)]);
var state_29732__$1 = state_29732;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29732__$1,(11),to,inst_29711);
} else {
if((state_val_29733 === (3))){
var inst_29730 = (state_29732[(2)]);
var state_29732__$1 = state_29732;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29732__$1,inst_29730);
} else {
if((state_val_29733 === (12))){
var state_29732__$1 = state_29732;
var statearr_29740_29766 = state_29732__$1;
(statearr_29740_29766[(2)] = null);

(statearr_29740_29766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (2))){
var state_29732__$1 = state_29732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29732__$1,(4),from);
} else {
if((state_val_29733 === (11))){
var inst_29721 = (state_29732[(2)]);
var state_29732__$1 = state_29732;
if(cljs.core.truth_(inst_29721)){
var statearr_29741_29767 = state_29732__$1;
(statearr_29741_29767[(1)] = (12));

} else {
var statearr_29742_29768 = state_29732__$1;
(statearr_29742_29768[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (9))){
var state_29732__$1 = state_29732;
var statearr_29743_29769 = state_29732__$1;
(statearr_29743_29769[(2)] = null);

(statearr_29743_29769[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (5))){
var state_29732__$1 = state_29732;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29744_29770 = state_29732__$1;
(statearr_29744_29770[(1)] = (8));

} else {
var statearr_29745_29771 = state_29732__$1;
(statearr_29745_29771[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (14))){
var inst_29726 = (state_29732[(2)]);
var state_29732__$1 = state_29732;
var statearr_29746_29772 = state_29732__$1;
(statearr_29746_29772[(2)] = inst_29726);

(statearr_29746_29772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (10))){
var inst_29718 = (state_29732[(2)]);
var state_29732__$1 = state_29732;
var statearr_29747_29773 = state_29732__$1;
(statearr_29747_29773[(2)] = inst_29718);

(statearr_29747_29773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29733 === (8))){
var inst_29715 = cljs.core.async.close_BANG_.call(null,to);
var state_29732__$1 = state_29732;
var statearr_29748_29774 = state_29732__$1;
(statearr_29748_29774[(2)] = inst_29715);

(statearr_29748_29774[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___29760))
;
return ((function (switch__29465__auto__,c__29579__auto___29760){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_29752 = [null,null,null,null,null,null,null,null];
(statearr_29752[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_29752[(1)] = (1));

return statearr_29752;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_29732){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_29732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e29753){if((e29753 instanceof Object)){
var ex__29469__auto__ = e29753;
var statearr_29754_29775 = state_29732;
(statearr_29754_29775[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29732);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29753;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29776 = state_29732;
state_29732 = G__29776;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_29732){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_29732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___29760))
})();
var state__29581__auto__ = (function (){var statearr_29755 = f__29580__auto__.call(null);
(statearr_29755[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___29760);

return statearr_29755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___29760))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__29964){
var vec__29965 = p__29964;
var v = cljs.core.nth.call(null,vec__29965,(0),null);
var p = cljs.core.nth.call(null,vec__29965,(1),null);
var job = vec__29965;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__29579__auto___30151 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___30151,res,vec__29965,v,p,job,jobs,results){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___30151,res,vec__29965,v,p,job,jobs,results){
return (function (state_29972){
var state_val_29973 = (state_29972[(1)]);
if((state_val_29973 === (1))){
var state_29972__$1 = state_29972;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29972__$1,(2),res,v);
} else {
if((state_val_29973 === (2))){
var inst_29969 = (state_29972[(2)]);
var inst_29970 = cljs.core.async.close_BANG_.call(null,res);
var state_29972__$1 = (function (){var statearr_29974 = state_29972;
(statearr_29974[(7)] = inst_29969);

return statearr_29974;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29972__$1,inst_29970);
} else {
return null;
}
}
});})(c__29579__auto___30151,res,vec__29965,v,p,job,jobs,results))
;
return ((function (switch__29465__auto__,c__29579__auto___30151,res,vec__29965,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0 = (function (){
var statearr_29978 = [null,null,null,null,null,null,null,null];
(statearr_29978[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__);

(statearr_29978[(1)] = (1));

return statearr_29978;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1 = (function (state_29972){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_29972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e29979){if((e29979 instanceof Object)){
var ex__29469__auto__ = e29979;
var statearr_29980_30152 = state_29972;
(statearr_29980_30152[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29972);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29979;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30153 = state_29972;
state_29972 = G__30153;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = function(state_29972){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1.call(this,state_29972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___30151,res,vec__29965,v,p,job,jobs,results))
})();
var state__29581__auto__ = (function (){var statearr_29981 = f__29580__auto__.call(null);
(statearr_29981[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___30151);

return statearr_29981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___30151,res,vec__29965,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29982){
var vec__29983 = p__29982;
var v = cljs.core.nth.call(null,vec__29983,(0),null);
var p = cljs.core.nth.call(null,vec__29983,(1),null);
var job = vec__29983;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27914__auto___30154 = n;
var __30155 = (0);
while(true){
if((__30155 < n__27914__auto___30154)){
var G__29986_30156 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29986_30156) {
case "compute":
var c__29579__auto___30158 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30155,c__29579__auto___30158,G__29986_30156,n__27914__auto___30154,jobs,results,process,async){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (__30155,c__29579__auto___30158,G__29986_30156,n__27914__auto___30154,jobs,results,process,async){
return (function (state_29999){
var state_val_30000 = (state_29999[(1)]);
if((state_val_30000 === (1))){
var state_29999__$1 = state_29999;
var statearr_30001_30159 = state_29999__$1;
(statearr_30001_30159[(2)] = null);

(statearr_30001_30159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (2))){
var state_29999__$1 = state_29999;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29999__$1,(4),jobs);
} else {
if((state_val_30000 === (3))){
var inst_29997 = (state_29999[(2)]);
var state_29999__$1 = state_29999;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29999__$1,inst_29997);
} else {
if((state_val_30000 === (4))){
var inst_29989 = (state_29999[(2)]);
var inst_29990 = process.call(null,inst_29989);
var state_29999__$1 = state_29999;
if(cljs.core.truth_(inst_29990)){
var statearr_30002_30160 = state_29999__$1;
(statearr_30002_30160[(1)] = (5));

} else {
var statearr_30003_30161 = state_29999__$1;
(statearr_30003_30161[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (5))){
var state_29999__$1 = state_29999;
var statearr_30004_30162 = state_29999__$1;
(statearr_30004_30162[(2)] = null);

(statearr_30004_30162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (6))){
var state_29999__$1 = state_29999;
var statearr_30005_30163 = state_29999__$1;
(statearr_30005_30163[(2)] = null);

(statearr_30005_30163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (7))){
var inst_29995 = (state_29999[(2)]);
var state_29999__$1 = state_29999;
var statearr_30006_30164 = state_29999__$1;
(statearr_30006_30164[(2)] = inst_29995);

(statearr_30006_30164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30155,c__29579__auto___30158,G__29986_30156,n__27914__auto___30154,jobs,results,process,async))
;
return ((function (__30155,switch__29465__auto__,c__29579__auto___30158,G__29986_30156,n__27914__auto___30154,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0 = (function (){
var statearr_30010 = [null,null,null,null,null,null,null];
(statearr_30010[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__);

(statearr_30010[(1)] = (1));

return statearr_30010;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1 = (function (state_29999){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_29999);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30011){if((e30011 instanceof Object)){
var ex__29469__auto__ = e30011;
var statearr_30012_30165 = state_29999;
(statearr_30012_30165[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29999);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30011;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30166 = state_29999;
state_29999 = G__30166;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = function(state_29999){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1.call(this,state_29999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__;
})()
;})(__30155,switch__29465__auto__,c__29579__auto___30158,G__29986_30156,n__27914__auto___30154,jobs,results,process,async))
})();
var state__29581__auto__ = (function (){var statearr_30013 = f__29580__auto__.call(null);
(statearr_30013[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___30158);

return statearr_30013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(__30155,c__29579__auto___30158,G__29986_30156,n__27914__auto___30154,jobs,results,process,async))
);


break;
case "async":
var c__29579__auto___30167 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30155,c__29579__auto___30167,G__29986_30156,n__27914__auto___30154,jobs,results,process,async){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (__30155,c__29579__auto___30167,G__29986_30156,n__27914__auto___30154,jobs,results,process,async){
return (function (state_30026){
var state_val_30027 = (state_30026[(1)]);
if((state_val_30027 === (1))){
var state_30026__$1 = state_30026;
var statearr_30028_30168 = state_30026__$1;
(statearr_30028_30168[(2)] = null);

(statearr_30028_30168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (2))){
var state_30026__$1 = state_30026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30026__$1,(4),jobs);
} else {
if((state_val_30027 === (3))){
var inst_30024 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30026__$1,inst_30024);
} else {
if((state_val_30027 === (4))){
var inst_30016 = (state_30026[(2)]);
var inst_30017 = async.call(null,inst_30016);
var state_30026__$1 = state_30026;
if(cljs.core.truth_(inst_30017)){
var statearr_30029_30169 = state_30026__$1;
(statearr_30029_30169[(1)] = (5));

} else {
var statearr_30030_30170 = state_30026__$1;
(statearr_30030_30170[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (5))){
var state_30026__$1 = state_30026;
var statearr_30031_30171 = state_30026__$1;
(statearr_30031_30171[(2)] = null);

(statearr_30031_30171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (6))){
var state_30026__$1 = state_30026;
var statearr_30032_30172 = state_30026__$1;
(statearr_30032_30172[(2)] = null);

(statearr_30032_30172[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (7))){
var inst_30022 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30033_30173 = state_30026__$1;
(statearr_30033_30173[(2)] = inst_30022);

(statearr_30033_30173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30155,c__29579__auto___30167,G__29986_30156,n__27914__auto___30154,jobs,results,process,async))
;
return ((function (__30155,switch__29465__auto__,c__29579__auto___30167,G__29986_30156,n__27914__auto___30154,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0 = (function (){
var statearr_30037 = [null,null,null,null,null,null,null];
(statearr_30037[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__);

(statearr_30037[(1)] = (1));

return statearr_30037;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1 = (function (state_30026){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30038){if((e30038 instanceof Object)){
var ex__29469__auto__ = e30038;
var statearr_30039_30174 = state_30026;
(statearr_30039_30174[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30026);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30175 = state_30026;
state_30026 = G__30175;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = function(state_30026){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1.call(this,state_30026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__;
})()
;})(__30155,switch__29465__auto__,c__29579__auto___30167,G__29986_30156,n__27914__auto___30154,jobs,results,process,async))
})();
var state__29581__auto__ = (function (){var statearr_30040 = f__29580__auto__.call(null);
(statearr_30040[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___30167);

return statearr_30040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(__30155,c__29579__auto___30167,G__29986_30156,n__27914__auto___30154,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__30176 = (__30155 + (1));
__30155 = G__30176;
continue;
} else {
}
break;
}

var c__29579__auto___30177 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___30177,jobs,results,process,async){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___30177,jobs,results,process,async){
return (function (state_30062){
var state_val_30063 = (state_30062[(1)]);
if((state_val_30063 === (1))){
var state_30062__$1 = state_30062;
var statearr_30064_30178 = state_30062__$1;
(statearr_30064_30178[(2)] = null);

(statearr_30064_30178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30063 === (2))){
var state_30062__$1 = state_30062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30062__$1,(4),from);
} else {
if((state_val_30063 === (3))){
var inst_30060 = (state_30062[(2)]);
var state_30062__$1 = state_30062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30062__$1,inst_30060);
} else {
if((state_val_30063 === (4))){
var inst_30043 = (state_30062[(7)]);
var inst_30043__$1 = (state_30062[(2)]);
var inst_30044 = (inst_30043__$1 == null);
var state_30062__$1 = (function (){var statearr_30065 = state_30062;
(statearr_30065[(7)] = inst_30043__$1);

return statearr_30065;
})();
if(cljs.core.truth_(inst_30044)){
var statearr_30066_30179 = state_30062__$1;
(statearr_30066_30179[(1)] = (5));

} else {
var statearr_30067_30180 = state_30062__$1;
(statearr_30067_30180[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30063 === (5))){
var inst_30046 = cljs.core.async.close_BANG_.call(null,jobs);
var state_30062__$1 = state_30062;
var statearr_30068_30181 = state_30062__$1;
(statearr_30068_30181[(2)] = inst_30046);

(statearr_30068_30181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30063 === (6))){
var inst_30043 = (state_30062[(7)]);
var inst_30048 = (state_30062[(8)]);
var inst_30048__$1 = cljs.core.async.chan.call(null,(1));
var inst_30049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30050 = [inst_30043,inst_30048__$1];
var inst_30051 = (new cljs.core.PersistentVector(null,2,(5),inst_30049,inst_30050,null));
var state_30062__$1 = (function (){var statearr_30069 = state_30062;
(statearr_30069[(8)] = inst_30048__$1);

return statearr_30069;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30062__$1,(8),jobs,inst_30051);
} else {
if((state_val_30063 === (7))){
var inst_30058 = (state_30062[(2)]);
var state_30062__$1 = state_30062;
var statearr_30070_30182 = state_30062__$1;
(statearr_30070_30182[(2)] = inst_30058);

(statearr_30070_30182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30063 === (8))){
var inst_30048 = (state_30062[(8)]);
var inst_30053 = (state_30062[(2)]);
var state_30062__$1 = (function (){var statearr_30071 = state_30062;
(statearr_30071[(9)] = inst_30053);

return statearr_30071;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30062__$1,(9),results,inst_30048);
} else {
if((state_val_30063 === (9))){
var inst_30055 = (state_30062[(2)]);
var state_30062__$1 = (function (){var statearr_30072 = state_30062;
(statearr_30072[(10)] = inst_30055);

return statearr_30072;
})();
var statearr_30073_30183 = state_30062__$1;
(statearr_30073_30183[(2)] = null);

(statearr_30073_30183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___30177,jobs,results,process,async))
;
return ((function (switch__29465__auto__,c__29579__auto___30177,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0 = (function (){
var statearr_30077 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30077[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__);

(statearr_30077[(1)] = (1));

return statearr_30077;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1 = (function (state_30062){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30078){if((e30078 instanceof Object)){
var ex__29469__auto__ = e30078;
var statearr_30079_30184 = state_30062;
(statearr_30079_30184[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30078;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30185 = state_30062;
state_30062 = G__30185;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = function(state_30062){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1.call(this,state_30062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___30177,jobs,results,process,async))
})();
var state__29581__auto__ = (function (){var statearr_30080 = f__29580__auto__.call(null);
(statearr_30080[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___30177);

return statearr_30080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___30177,jobs,results,process,async))
);


var c__29579__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto__,jobs,results,process,async){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto__,jobs,results,process,async){
return (function (state_30118){
var state_val_30119 = (state_30118[(1)]);
if((state_val_30119 === (7))){
var inst_30114 = (state_30118[(2)]);
var state_30118__$1 = state_30118;
var statearr_30120_30186 = state_30118__$1;
(statearr_30120_30186[(2)] = inst_30114);

(statearr_30120_30186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (20))){
var state_30118__$1 = state_30118;
var statearr_30121_30187 = state_30118__$1;
(statearr_30121_30187[(2)] = null);

(statearr_30121_30187[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (1))){
var state_30118__$1 = state_30118;
var statearr_30122_30188 = state_30118__$1;
(statearr_30122_30188[(2)] = null);

(statearr_30122_30188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (4))){
var inst_30083 = (state_30118[(7)]);
var inst_30083__$1 = (state_30118[(2)]);
var inst_30084 = (inst_30083__$1 == null);
var state_30118__$1 = (function (){var statearr_30123 = state_30118;
(statearr_30123[(7)] = inst_30083__$1);

return statearr_30123;
})();
if(cljs.core.truth_(inst_30084)){
var statearr_30124_30189 = state_30118__$1;
(statearr_30124_30189[(1)] = (5));

} else {
var statearr_30125_30190 = state_30118__$1;
(statearr_30125_30190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (15))){
var inst_30096 = (state_30118[(8)]);
var state_30118__$1 = state_30118;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30118__$1,(18),to,inst_30096);
} else {
if((state_val_30119 === (21))){
var inst_30109 = (state_30118[(2)]);
var state_30118__$1 = state_30118;
var statearr_30126_30191 = state_30118__$1;
(statearr_30126_30191[(2)] = inst_30109);

(statearr_30126_30191[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (13))){
var inst_30111 = (state_30118[(2)]);
var state_30118__$1 = (function (){var statearr_30127 = state_30118;
(statearr_30127[(9)] = inst_30111);

return statearr_30127;
})();
var statearr_30128_30192 = state_30118__$1;
(statearr_30128_30192[(2)] = null);

(statearr_30128_30192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (6))){
var inst_30083 = (state_30118[(7)]);
var state_30118__$1 = state_30118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30118__$1,(11),inst_30083);
} else {
if((state_val_30119 === (17))){
var inst_30104 = (state_30118[(2)]);
var state_30118__$1 = state_30118;
if(cljs.core.truth_(inst_30104)){
var statearr_30129_30193 = state_30118__$1;
(statearr_30129_30193[(1)] = (19));

} else {
var statearr_30130_30194 = state_30118__$1;
(statearr_30130_30194[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (3))){
var inst_30116 = (state_30118[(2)]);
var state_30118__$1 = state_30118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30118__$1,inst_30116);
} else {
if((state_val_30119 === (12))){
var inst_30093 = (state_30118[(10)]);
var state_30118__$1 = state_30118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30118__$1,(14),inst_30093);
} else {
if((state_val_30119 === (2))){
var state_30118__$1 = state_30118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30118__$1,(4),results);
} else {
if((state_val_30119 === (19))){
var state_30118__$1 = state_30118;
var statearr_30131_30195 = state_30118__$1;
(statearr_30131_30195[(2)] = null);

(statearr_30131_30195[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (11))){
var inst_30093 = (state_30118[(2)]);
var state_30118__$1 = (function (){var statearr_30132 = state_30118;
(statearr_30132[(10)] = inst_30093);

return statearr_30132;
})();
var statearr_30133_30196 = state_30118__$1;
(statearr_30133_30196[(2)] = null);

(statearr_30133_30196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (9))){
var state_30118__$1 = state_30118;
var statearr_30134_30197 = state_30118__$1;
(statearr_30134_30197[(2)] = null);

(statearr_30134_30197[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (5))){
var state_30118__$1 = state_30118;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30135_30198 = state_30118__$1;
(statearr_30135_30198[(1)] = (8));

} else {
var statearr_30136_30199 = state_30118__$1;
(statearr_30136_30199[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (14))){
var inst_30096 = (state_30118[(8)]);
var inst_30098 = (state_30118[(11)]);
var inst_30096__$1 = (state_30118[(2)]);
var inst_30097 = (inst_30096__$1 == null);
var inst_30098__$1 = cljs.core.not.call(null,inst_30097);
var state_30118__$1 = (function (){var statearr_30137 = state_30118;
(statearr_30137[(8)] = inst_30096__$1);

(statearr_30137[(11)] = inst_30098__$1);

return statearr_30137;
})();
if(inst_30098__$1){
var statearr_30138_30200 = state_30118__$1;
(statearr_30138_30200[(1)] = (15));

} else {
var statearr_30139_30201 = state_30118__$1;
(statearr_30139_30201[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (16))){
var inst_30098 = (state_30118[(11)]);
var state_30118__$1 = state_30118;
var statearr_30140_30202 = state_30118__$1;
(statearr_30140_30202[(2)] = inst_30098);

(statearr_30140_30202[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (10))){
var inst_30090 = (state_30118[(2)]);
var state_30118__$1 = state_30118;
var statearr_30141_30203 = state_30118__$1;
(statearr_30141_30203[(2)] = inst_30090);

(statearr_30141_30203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (18))){
var inst_30101 = (state_30118[(2)]);
var state_30118__$1 = state_30118;
var statearr_30142_30204 = state_30118__$1;
(statearr_30142_30204[(2)] = inst_30101);

(statearr_30142_30204[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30119 === (8))){
var inst_30087 = cljs.core.async.close_BANG_.call(null,to);
var state_30118__$1 = state_30118;
var statearr_30143_30205 = state_30118__$1;
(statearr_30143_30205[(2)] = inst_30087);

(statearr_30143_30205[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto__,jobs,results,process,async))
;
return ((function (switch__29465__auto__,c__29579__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0 = (function (){
var statearr_30147 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30147[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__);

(statearr_30147[(1)] = (1));

return statearr_30147;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1 = (function (state_30118){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30148){if((e30148 instanceof Object)){
var ex__29469__auto__ = e30148;
var statearr_30149_30206 = state_30118;
(statearr_30149_30206[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30118);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30148;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30207 = state_30118;
state_30118 = G__30207;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__ = function(state_30118){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1.call(this,state_30118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29466__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto__,jobs,results,process,async))
})();
var state__29581__auto__ = (function (){var statearr_30150 = f__29580__auto__.call(null);
(statearr_30150[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto__);

return statearr_30150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto__,jobs,results,process,async))
);

return c__29579__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args30208 = [];
var len__28114__auto___30211 = arguments.length;
var i__28115__auto___30212 = (0);
while(true){
if((i__28115__auto___30212 < len__28114__auto___30211)){
args30208.push((arguments[i__28115__auto___30212]));

var G__30213 = (i__28115__auto___30212 + (1));
i__28115__auto___30212 = G__30213;
continue;
} else {
}
break;
}

var G__30210 = args30208.length;
switch (G__30210) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30208.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args30215 = [];
var len__28114__auto___30218 = arguments.length;
var i__28115__auto___30219 = (0);
while(true){
if((i__28115__auto___30219 < len__28114__auto___30218)){
args30215.push((arguments[i__28115__auto___30219]));

var G__30220 = (i__28115__auto___30219 + (1));
i__28115__auto___30219 = G__30220;
continue;
} else {
}
break;
}

var G__30217 = args30215.length;
switch (G__30217) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30215.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args30222 = [];
var len__28114__auto___30275 = arguments.length;
var i__28115__auto___30276 = (0);
while(true){
if((i__28115__auto___30276 < len__28114__auto___30275)){
args30222.push((arguments[i__28115__auto___30276]));

var G__30277 = (i__28115__auto___30276 + (1));
i__28115__auto___30276 = G__30277;
continue;
} else {
}
break;
}

var G__30224 = args30222.length;
switch (G__30224) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30222.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__29579__auto___30279 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___30279,tc,fc){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___30279,tc,fc){
return (function (state_30250){
var state_val_30251 = (state_30250[(1)]);
if((state_val_30251 === (7))){
var inst_30246 = (state_30250[(2)]);
var state_30250__$1 = state_30250;
var statearr_30252_30280 = state_30250__$1;
(statearr_30252_30280[(2)] = inst_30246);

(statearr_30252_30280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (1))){
var state_30250__$1 = state_30250;
var statearr_30253_30281 = state_30250__$1;
(statearr_30253_30281[(2)] = null);

(statearr_30253_30281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (4))){
var inst_30227 = (state_30250[(7)]);
var inst_30227__$1 = (state_30250[(2)]);
var inst_30228 = (inst_30227__$1 == null);
var state_30250__$1 = (function (){var statearr_30254 = state_30250;
(statearr_30254[(7)] = inst_30227__$1);

return statearr_30254;
})();
if(cljs.core.truth_(inst_30228)){
var statearr_30255_30282 = state_30250__$1;
(statearr_30255_30282[(1)] = (5));

} else {
var statearr_30256_30283 = state_30250__$1;
(statearr_30256_30283[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (13))){
var state_30250__$1 = state_30250;
var statearr_30257_30284 = state_30250__$1;
(statearr_30257_30284[(2)] = null);

(statearr_30257_30284[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (6))){
var inst_30227 = (state_30250[(7)]);
var inst_30233 = p.call(null,inst_30227);
var state_30250__$1 = state_30250;
if(cljs.core.truth_(inst_30233)){
var statearr_30258_30285 = state_30250__$1;
(statearr_30258_30285[(1)] = (9));

} else {
var statearr_30259_30286 = state_30250__$1;
(statearr_30259_30286[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (3))){
var inst_30248 = (state_30250[(2)]);
var state_30250__$1 = state_30250;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30250__$1,inst_30248);
} else {
if((state_val_30251 === (12))){
var state_30250__$1 = state_30250;
var statearr_30260_30287 = state_30250__$1;
(statearr_30260_30287[(2)] = null);

(statearr_30260_30287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (2))){
var state_30250__$1 = state_30250;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30250__$1,(4),ch);
} else {
if((state_val_30251 === (11))){
var inst_30227 = (state_30250[(7)]);
var inst_30237 = (state_30250[(2)]);
var state_30250__$1 = state_30250;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30250__$1,(8),inst_30237,inst_30227);
} else {
if((state_val_30251 === (9))){
var state_30250__$1 = state_30250;
var statearr_30261_30288 = state_30250__$1;
(statearr_30261_30288[(2)] = tc);

(statearr_30261_30288[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (5))){
var inst_30230 = cljs.core.async.close_BANG_.call(null,tc);
var inst_30231 = cljs.core.async.close_BANG_.call(null,fc);
var state_30250__$1 = (function (){var statearr_30262 = state_30250;
(statearr_30262[(8)] = inst_30230);

return statearr_30262;
})();
var statearr_30263_30289 = state_30250__$1;
(statearr_30263_30289[(2)] = inst_30231);

(statearr_30263_30289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (14))){
var inst_30244 = (state_30250[(2)]);
var state_30250__$1 = state_30250;
var statearr_30264_30290 = state_30250__$1;
(statearr_30264_30290[(2)] = inst_30244);

(statearr_30264_30290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (10))){
var state_30250__$1 = state_30250;
var statearr_30265_30291 = state_30250__$1;
(statearr_30265_30291[(2)] = fc);

(statearr_30265_30291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30251 === (8))){
var inst_30239 = (state_30250[(2)]);
var state_30250__$1 = state_30250;
if(cljs.core.truth_(inst_30239)){
var statearr_30266_30292 = state_30250__$1;
(statearr_30266_30292[(1)] = (12));

} else {
var statearr_30267_30293 = state_30250__$1;
(statearr_30267_30293[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___30279,tc,fc))
;
return ((function (switch__29465__auto__,c__29579__auto___30279,tc,fc){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_30271 = [null,null,null,null,null,null,null,null,null];
(statearr_30271[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_30271[(1)] = (1));

return statearr_30271;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_30250){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30250);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30272){if((e30272 instanceof Object)){
var ex__29469__auto__ = e30272;
var statearr_30273_30294 = state_30250;
(statearr_30273_30294[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30250);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30272;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30295 = state_30250;
state_30250 = G__30295;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_30250){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_30250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___30279,tc,fc))
})();
var state__29581__auto__ = (function (){var statearr_30274 = f__29580__auto__.call(null);
(statearr_30274[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___30279);

return statearr_30274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___30279,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29579__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto__){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto__){
return (function (state_30359){
var state_val_30360 = (state_30359[(1)]);
if((state_val_30360 === (7))){
var inst_30355 = (state_30359[(2)]);
var state_30359__$1 = state_30359;
var statearr_30361_30382 = state_30359__$1;
(statearr_30361_30382[(2)] = inst_30355);

(statearr_30361_30382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (1))){
var inst_30339 = init;
var state_30359__$1 = (function (){var statearr_30362 = state_30359;
(statearr_30362[(7)] = inst_30339);

return statearr_30362;
})();
var statearr_30363_30383 = state_30359__$1;
(statearr_30363_30383[(2)] = null);

(statearr_30363_30383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (4))){
var inst_30342 = (state_30359[(8)]);
var inst_30342__$1 = (state_30359[(2)]);
var inst_30343 = (inst_30342__$1 == null);
var state_30359__$1 = (function (){var statearr_30364 = state_30359;
(statearr_30364[(8)] = inst_30342__$1);

return statearr_30364;
})();
if(cljs.core.truth_(inst_30343)){
var statearr_30365_30384 = state_30359__$1;
(statearr_30365_30384[(1)] = (5));

} else {
var statearr_30366_30385 = state_30359__$1;
(statearr_30366_30385[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (6))){
var inst_30339 = (state_30359[(7)]);
var inst_30342 = (state_30359[(8)]);
var inst_30346 = (state_30359[(9)]);
var inst_30346__$1 = f.call(null,inst_30339,inst_30342);
var inst_30347 = cljs.core.reduced_QMARK_.call(null,inst_30346__$1);
var state_30359__$1 = (function (){var statearr_30367 = state_30359;
(statearr_30367[(9)] = inst_30346__$1);

return statearr_30367;
})();
if(inst_30347){
var statearr_30368_30386 = state_30359__$1;
(statearr_30368_30386[(1)] = (8));

} else {
var statearr_30369_30387 = state_30359__$1;
(statearr_30369_30387[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (3))){
var inst_30357 = (state_30359[(2)]);
var state_30359__$1 = state_30359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30359__$1,inst_30357);
} else {
if((state_val_30360 === (2))){
var state_30359__$1 = state_30359;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30359__$1,(4),ch);
} else {
if((state_val_30360 === (9))){
var inst_30346 = (state_30359[(9)]);
var inst_30339 = inst_30346;
var state_30359__$1 = (function (){var statearr_30370 = state_30359;
(statearr_30370[(7)] = inst_30339);

return statearr_30370;
})();
var statearr_30371_30388 = state_30359__$1;
(statearr_30371_30388[(2)] = null);

(statearr_30371_30388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (5))){
var inst_30339 = (state_30359[(7)]);
var state_30359__$1 = state_30359;
var statearr_30372_30389 = state_30359__$1;
(statearr_30372_30389[(2)] = inst_30339);

(statearr_30372_30389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (10))){
var inst_30353 = (state_30359[(2)]);
var state_30359__$1 = state_30359;
var statearr_30373_30390 = state_30359__$1;
(statearr_30373_30390[(2)] = inst_30353);

(statearr_30373_30390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (8))){
var inst_30346 = (state_30359[(9)]);
var inst_30349 = cljs.core.deref.call(null,inst_30346);
var state_30359__$1 = state_30359;
var statearr_30374_30391 = state_30359__$1;
(statearr_30374_30391[(2)] = inst_30349);

(statearr_30374_30391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto__))
;
return ((function (switch__29465__auto__,c__29579__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__29466__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29466__auto____0 = (function (){
var statearr_30378 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30378[(0)] = cljs$core$async$reduce_$_state_machine__29466__auto__);

(statearr_30378[(1)] = (1));

return statearr_30378;
});
var cljs$core$async$reduce_$_state_machine__29466__auto____1 = (function (state_30359){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30379){if((e30379 instanceof Object)){
var ex__29469__auto__ = e30379;
var statearr_30380_30392 = state_30359;
(statearr_30380_30392[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30359);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30379;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30393 = state_30359;
state_30359 = G__30393;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29466__auto__ = function(state_30359){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29466__auto____1.call(this,state_30359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29466__auto____0;
cljs$core$async$reduce_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29466__auto____1;
return cljs$core$async$reduce_$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto__))
})();
var state__29581__auto__ = (function (){var statearr_30381 = f__29580__auto__.call(null);
(statearr_30381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto__);

return statearr_30381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto__))
);

return c__29579__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__29579__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto__,f__$1){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto__,f__$1){
return (function (state_30413){
var state_val_30414 = (state_30413[(1)]);
if((state_val_30414 === (1))){
var inst_30408 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_30413__$1 = state_30413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30413__$1,(2),inst_30408);
} else {
if((state_val_30414 === (2))){
var inst_30410 = (state_30413[(2)]);
var inst_30411 = f__$1.call(null,inst_30410);
var state_30413__$1 = state_30413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30413__$1,inst_30411);
} else {
return null;
}
}
});})(c__29579__auto__,f__$1))
;
return ((function (switch__29465__auto__,c__29579__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__29466__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29466__auto____0 = (function (){
var statearr_30418 = [null,null,null,null,null,null,null];
(statearr_30418[(0)] = cljs$core$async$transduce_$_state_machine__29466__auto__);

(statearr_30418[(1)] = (1));

return statearr_30418;
});
var cljs$core$async$transduce_$_state_machine__29466__auto____1 = (function (state_30413){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30419){if((e30419 instanceof Object)){
var ex__29469__auto__ = e30419;
var statearr_30420_30422 = state_30413;
(statearr_30420_30422[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30413);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30419;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30423 = state_30413;
state_30413 = G__30423;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29466__auto__ = function(state_30413){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29466__auto____1.call(this,state_30413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29466__auto____0;
cljs$core$async$transduce_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29466__auto____1;
return cljs$core$async$transduce_$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto__,f__$1))
})();
var state__29581__auto__ = (function (){var statearr_30421 = f__29580__auto__.call(null);
(statearr_30421[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto__);

return statearr_30421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto__,f__$1))
);

return c__29579__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30424 = [];
var len__28114__auto___30476 = arguments.length;
var i__28115__auto___30477 = (0);
while(true){
if((i__28115__auto___30477 < len__28114__auto___30476)){
args30424.push((arguments[i__28115__auto___30477]));

var G__30478 = (i__28115__auto___30477 + (1));
i__28115__auto___30477 = G__30478;
continue;
} else {
}
break;
}

var G__30426 = args30424.length;
switch (G__30426) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30424.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29579__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto__){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto__){
return (function (state_30451){
var state_val_30452 = (state_30451[(1)]);
if((state_val_30452 === (7))){
var inst_30433 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
var statearr_30453_30480 = state_30451__$1;
(statearr_30453_30480[(2)] = inst_30433);

(statearr_30453_30480[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (1))){
var inst_30427 = cljs.core.seq.call(null,coll);
var inst_30428 = inst_30427;
var state_30451__$1 = (function (){var statearr_30454 = state_30451;
(statearr_30454[(7)] = inst_30428);

return statearr_30454;
})();
var statearr_30455_30481 = state_30451__$1;
(statearr_30455_30481[(2)] = null);

(statearr_30455_30481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (4))){
var inst_30428 = (state_30451[(7)]);
var inst_30431 = cljs.core.first.call(null,inst_30428);
var state_30451__$1 = state_30451;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30451__$1,(7),ch,inst_30431);
} else {
if((state_val_30452 === (13))){
var inst_30445 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
var statearr_30456_30482 = state_30451__$1;
(statearr_30456_30482[(2)] = inst_30445);

(statearr_30456_30482[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (6))){
var inst_30436 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
if(cljs.core.truth_(inst_30436)){
var statearr_30457_30483 = state_30451__$1;
(statearr_30457_30483[(1)] = (8));

} else {
var statearr_30458_30484 = state_30451__$1;
(statearr_30458_30484[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (3))){
var inst_30449 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30451__$1,inst_30449);
} else {
if((state_val_30452 === (12))){
var state_30451__$1 = state_30451;
var statearr_30459_30485 = state_30451__$1;
(statearr_30459_30485[(2)] = null);

(statearr_30459_30485[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (2))){
var inst_30428 = (state_30451[(7)]);
var state_30451__$1 = state_30451;
if(cljs.core.truth_(inst_30428)){
var statearr_30460_30486 = state_30451__$1;
(statearr_30460_30486[(1)] = (4));

} else {
var statearr_30461_30487 = state_30451__$1;
(statearr_30461_30487[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (11))){
var inst_30442 = cljs.core.async.close_BANG_.call(null,ch);
var state_30451__$1 = state_30451;
var statearr_30462_30488 = state_30451__$1;
(statearr_30462_30488[(2)] = inst_30442);

(statearr_30462_30488[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (9))){
var state_30451__$1 = state_30451;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30463_30489 = state_30451__$1;
(statearr_30463_30489[(1)] = (11));

} else {
var statearr_30464_30490 = state_30451__$1;
(statearr_30464_30490[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (5))){
var inst_30428 = (state_30451[(7)]);
var state_30451__$1 = state_30451;
var statearr_30465_30491 = state_30451__$1;
(statearr_30465_30491[(2)] = inst_30428);

(statearr_30465_30491[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (10))){
var inst_30447 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
var statearr_30466_30492 = state_30451__$1;
(statearr_30466_30492[(2)] = inst_30447);

(statearr_30466_30492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (8))){
var inst_30428 = (state_30451[(7)]);
var inst_30438 = cljs.core.next.call(null,inst_30428);
var inst_30428__$1 = inst_30438;
var state_30451__$1 = (function (){var statearr_30467 = state_30451;
(statearr_30467[(7)] = inst_30428__$1);

return statearr_30467;
})();
var statearr_30468_30493 = state_30451__$1;
(statearr_30468_30493[(2)] = null);

(statearr_30468_30493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto__))
;
return ((function (switch__29465__auto__,c__29579__auto__){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_30472 = [null,null,null,null,null,null,null,null];
(statearr_30472[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_30472[(1)] = (1));

return statearr_30472;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_30451){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30451);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30473){if((e30473 instanceof Object)){
var ex__29469__auto__ = e30473;
var statearr_30474_30494 = state_30451;
(statearr_30474_30494[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30451);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30473;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30495 = state_30451;
state_30451 = G__30495;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_30451){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_30451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto__))
})();
var state__29581__auto__ = (function (){var statearr_30475 = f__29580__auto__.call(null);
(statearr_30475[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto__);

return statearr_30475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto__))
);

return c__29579__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27611__auto__ = (((_ == null))?null:_);
var m__27612__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,_);
} else {
var m__27612__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27612__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m);
} else {
var m__27612__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30721 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30721 = (function (ch,cs,meta30722){
this.ch = ch;
this.cs = cs;
this.meta30722 = meta30722;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30723,meta30722__$1){
var self__ = this;
var _30723__$1 = this;
return (new cljs.core.async.t_cljs$core$async30721(self__.ch,self__.cs,meta30722__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30723){
var self__ = this;
var _30723__$1 = this;
return self__.meta30722;
});})(cs))
;

cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30721.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30721.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30722","meta30722",-1249521225,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async30721.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30721.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30721";

cljs.core.async.t_cljs$core$async30721.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async30721");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async30721 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async30721(ch__$1,cs__$1,meta30722){
return (new cljs.core.async.t_cljs$core$async30721(ch__$1,cs__$1,meta30722));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async30721(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__29579__auto___30946 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___30946,cs,m,dchan,dctr,done){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___30946,cs,m,dchan,dctr,done){
return (function (state_30858){
var state_val_30859 = (state_30858[(1)]);
if((state_val_30859 === (7))){
var inst_30854 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30860_30947 = state_30858__$1;
(statearr_30860_30947[(2)] = inst_30854);

(statearr_30860_30947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (20))){
var inst_30757 = (state_30858[(7)]);
var inst_30769 = cljs.core.first.call(null,inst_30757);
var inst_30770 = cljs.core.nth.call(null,inst_30769,(0),null);
var inst_30771 = cljs.core.nth.call(null,inst_30769,(1),null);
var state_30858__$1 = (function (){var statearr_30861 = state_30858;
(statearr_30861[(8)] = inst_30770);

return statearr_30861;
})();
if(cljs.core.truth_(inst_30771)){
var statearr_30862_30948 = state_30858__$1;
(statearr_30862_30948[(1)] = (22));

} else {
var statearr_30863_30949 = state_30858__$1;
(statearr_30863_30949[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (27))){
var inst_30726 = (state_30858[(9)]);
var inst_30799 = (state_30858[(10)]);
var inst_30806 = (state_30858[(11)]);
var inst_30801 = (state_30858[(12)]);
var inst_30806__$1 = cljs.core._nth.call(null,inst_30799,inst_30801);
var inst_30807 = cljs.core.async.put_BANG_.call(null,inst_30806__$1,inst_30726,done);
var state_30858__$1 = (function (){var statearr_30864 = state_30858;
(statearr_30864[(11)] = inst_30806__$1);

return statearr_30864;
})();
if(cljs.core.truth_(inst_30807)){
var statearr_30865_30950 = state_30858__$1;
(statearr_30865_30950[(1)] = (30));

} else {
var statearr_30866_30951 = state_30858__$1;
(statearr_30866_30951[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (1))){
var state_30858__$1 = state_30858;
var statearr_30867_30952 = state_30858__$1;
(statearr_30867_30952[(2)] = null);

(statearr_30867_30952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (24))){
var inst_30757 = (state_30858[(7)]);
var inst_30776 = (state_30858[(2)]);
var inst_30777 = cljs.core.next.call(null,inst_30757);
var inst_30735 = inst_30777;
var inst_30736 = null;
var inst_30737 = (0);
var inst_30738 = (0);
var state_30858__$1 = (function (){var statearr_30868 = state_30858;
(statearr_30868[(13)] = inst_30735);

(statearr_30868[(14)] = inst_30737);

(statearr_30868[(15)] = inst_30736);

(statearr_30868[(16)] = inst_30776);

(statearr_30868[(17)] = inst_30738);

return statearr_30868;
})();
var statearr_30869_30953 = state_30858__$1;
(statearr_30869_30953[(2)] = null);

(statearr_30869_30953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (39))){
var state_30858__$1 = state_30858;
var statearr_30873_30954 = state_30858__$1;
(statearr_30873_30954[(2)] = null);

(statearr_30873_30954[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (4))){
var inst_30726 = (state_30858[(9)]);
var inst_30726__$1 = (state_30858[(2)]);
var inst_30727 = (inst_30726__$1 == null);
var state_30858__$1 = (function (){var statearr_30874 = state_30858;
(statearr_30874[(9)] = inst_30726__$1);

return statearr_30874;
})();
if(cljs.core.truth_(inst_30727)){
var statearr_30875_30955 = state_30858__$1;
(statearr_30875_30955[(1)] = (5));

} else {
var statearr_30876_30956 = state_30858__$1;
(statearr_30876_30956[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (15))){
var inst_30735 = (state_30858[(13)]);
var inst_30737 = (state_30858[(14)]);
var inst_30736 = (state_30858[(15)]);
var inst_30738 = (state_30858[(17)]);
var inst_30753 = (state_30858[(2)]);
var inst_30754 = (inst_30738 + (1));
var tmp30870 = inst_30735;
var tmp30871 = inst_30737;
var tmp30872 = inst_30736;
var inst_30735__$1 = tmp30870;
var inst_30736__$1 = tmp30872;
var inst_30737__$1 = tmp30871;
var inst_30738__$1 = inst_30754;
var state_30858__$1 = (function (){var statearr_30877 = state_30858;
(statearr_30877[(18)] = inst_30753);

(statearr_30877[(13)] = inst_30735__$1);

(statearr_30877[(14)] = inst_30737__$1);

(statearr_30877[(15)] = inst_30736__$1);

(statearr_30877[(17)] = inst_30738__$1);

return statearr_30877;
})();
var statearr_30878_30957 = state_30858__$1;
(statearr_30878_30957[(2)] = null);

(statearr_30878_30957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (21))){
var inst_30780 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30882_30958 = state_30858__$1;
(statearr_30882_30958[(2)] = inst_30780);

(statearr_30882_30958[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (31))){
var inst_30806 = (state_30858[(11)]);
var inst_30810 = done.call(null,null);
var inst_30811 = cljs.core.async.untap_STAR_.call(null,m,inst_30806);
var state_30858__$1 = (function (){var statearr_30883 = state_30858;
(statearr_30883[(19)] = inst_30810);

return statearr_30883;
})();
var statearr_30884_30959 = state_30858__$1;
(statearr_30884_30959[(2)] = inst_30811);

(statearr_30884_30959[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (32))){
var inst_30799 = (state_30858[(10)]);
var inst_30800 = (state_30858[(20)]);
var inst_30801 = (state_30858[(12)]);
var inst_30798 = (state_30858[(21)]);
var inst_30813 = (state_30858[(2)]);
var inst_30814 = (inst_30801 + (1));
var tmp30879 = inst_30799;
var tmp30880 = inst_30800;
var tmp30881 = inst_30798;
var inst_30798__$1 = tmp30881;
var inst_30799__$1 = tmp30879;
var inst_30800__$1 = tmp30880;
var inst_30801__$1 = inst_30814;
var state_30858__$1 = (function (){var statearr_30885 = state_30858;
(statearr_30885[(10)] = inst_30799__$1);

(statearr_30885[(20)] = inst_30800__$1);

(statearr_30885[(22)] = inst_30813);

(statearr_30885[(12)] = inst_30801__$1);

(statearr_30885[(21)] = inst_30798__$1);

return statearr_30885;
})();
var statearr_30886_30960 = state_30858__$1;
(statearr_30886_30960[(2)] = null);

(statearr_30886_30960[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (40))){
var inst_30826 = (state_30858[(23)]);
var inst_30830 = done.call(null,null);
var inst_30831 = cljs.core.async.untap_STAR_.call(null,m,inst_30826);
var state_30858__$1 = (function (){var statearr_30887 = state_30858;
(statearr_30887[(24)] = inst_30830);

return statearr_30887;
})();
var statearr_30888_30961 = state_30858__$1;
(statearr_30888_30961[(2)] = inst_30831);

(statearr_30888_30961[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (33))){
var inst_30817 = (state_30858[(25)]);
var inst_30819 = cljs.core.chunked_seq_QMARK_.call(null,inst_30817);
var state_30858__$1 = state_30858;
if(inst_30819){
var statearr_30889_30962 = state_30858__$1;
(statearr_30889_30962[(1)] = (36));

} else {
var statearr_30890_30963 = state_30858__$1;
(statearr_30890_30963[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (13))){
var inst_30747 = (state_30858[(26)]);
var inst_30750 = cljs.core.async.close_BANG_.call(null,inst_30747);
var state_30858__$1 = state_30858;
var statearr_30891_30964 = state_30858__$1;
(statearr_30891_30964[(2)] = inst_30750);

(statearr_30891_30964[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (22))){
var inst_30770 = (state_30858[(8)]);
var inst_30773 = cljs.core.async.close_BANG_.call(null,inst_30770);
var state_30858__$1 = state_30858;
var statearr_30892_30965 = state_30858__$1;
(statearr_30892_30965[(2)] = inst_30773);

(statearr_30892_30965[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (36))){
var inst_30817 = (state_30858[(25)]);
var inst_30821 = cljs.core.chunk_first.call(null,inst_30817);
var inst_30822 = cljs.core.chunk_rest.call(null,inst_30817);
var inst_30823 = cljs.core.count.call(null,inst_30821);
var inst_30798 = inst_30822;
var inst_30799 = inst_30821;
var inst_30800 = inst_30823;
var inst_30801 = (0);
var state_30858__$1 = (function (){var statearr_30893 = state_30858;
(statearr_30893[(10)] = inst_30799);

(statearr_30893[(20)] = inst_30800);

(statearr_30893[(12)] = inst_30801);

(statearr_30893[(21)] = inst_30798);

return statearr_30893;
})();
var statearr_30894_30966 = state_30858__$1;
(statearr_30894_30966[(2)] = null);

(statearr_30894_30966[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (41))){
var inst_30817 = (state_30858[(25)]);
var inst_30833 = (state_30858[(2)]);
var inst_30834 = cljs.core.next.call(null,inst_30817);
var inst_30798 = inst_30834;
var inst_30799 = null;
var inst_30800 = (0);
var inst_30801 = (0);
var state_30858__$1 = (function (){var statearr_30895 = state_30858;
(statearr_30895[(10)] = inst_30799);

(statearr_30895[(20)] = inst_30800);

(statearr_30895[(27)] = inst_30833);

(statearr_30895[(12)] = inst_30801);

(statearr_30895[(21)] = inst_30798);

return statearr_30895;
})();
var statearr_30896_30967 = state_30858__$1;
(statearr_30896_30967[(2)] = null);

(statearr_30896_30967[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (43))){
var state_30858__$1 = state_30858;
var statearr_30897_30968 = state_30858__$1;
(statearr_30897_30968[(2)] = null);

(statearr_30897_30968[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (29))){
var inst_30842 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30898_30969 = state_30858__$1;
(statearr_30898_30969[(2)] = inst_30842);

(statearr_30898_30969[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (44))){
var inst_30851 = (state_30858[(2)]);
var state_30858__$1 = (function (){var statearr_30899 = state_30858;
(statearr_30899[(28)] = inst_30851);

return statearr_30899;
})();
var statearr_30900_30970 = state_30858__$1;
(statearr_30900_30970[(2)] = null);

(statearr_30900_30970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (6))){
var inst_30790 = (state_30858[(29)]);
var inst_30789 = cljs.core.deref.call(null,cs);
var inst_30790__$1 = cljs.core.keys.call(null,inst_30789);
var inst_30791 = cljs.core.count.call(null,inst_30790__$1);
var inst_30792 = cljs.core.reset_BANG_.call(null,dctr,inst_30791);
var inst_30797 = cljs.core.seq.call(null,inst_30790__$1);
var inst_30798 = inst_30797;
var inst_30799 = null;
var inst_30800 = (0);
var inst_30801 = (0);
var state_30858__$1 = (function (){var statearr_30901 = state_30858;
(statearr_30901[(10)] = inst_30799);

(statearr_30901[(20)] = inst_30800);

(statearr_30901[(29)] = inst_30790__$1);

(statearr_30901[(30)] = inst_30792);

(statearr_30901[(12)] = inst_30801);

(statearr_30901[(21)] = inst_30798);

return statearr_30901;
})();
var statearr_30902_30971 = state_30858__$1;
(statearr_30902_30971[(2)] = null);

(statearr_30902_30971[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (28))){
var inst_30817 = (state_30858[(25)]);
var inst_30798 = (state_30858[(21)]);
var inst_30817__$1 = cljs.core.seq.call(null,inst_30798);
var state_30858__$1 = (function (){var statearr_30903 = state_30858;
(statearr_30903[(25)] = inst_30817__$1);

return statearr_30903;
})();
if(inst_30817__$1){
var statearr_30904_30972 = state_30858__$1;
(statearr_30904_30972[(1)] = (33));

} else {
var statearr_30905_30973 = state_30858__$1;
(statearr_30905_30973[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (25))){
var inst_30800 = (state_30858[(20)]);
var inst_30801 = (state_30858[(12)]);
var inst_30803 = (inst_30801 < inst_30800);
var inst_30804 = inst_30803;
var state_30858__$1 = state_30858;
if(cljs.core.truth_(inst_30804)){
var statearr_30906_30974 = state_30858__$1;
(statearr_30906_30974[(1)] = (27));

} else {
var statearr_30907_30975 = state_30858__$1;
(statearr_30907_30975[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (34))){
var state_30858__$1 = state_30858;
var statearr_30908_30976 = state_30858__$1;
(statearr_30908_30976[(2)] = null);

(statearr_30908_30976[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (17))){
var state_30858__$1 = state_30858;
var statearr_30909_30977 = state_30858__$1;
(statearr_30909_30977[(2)] = null);

(statearr_30909_30977[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (3))){
var inst_30856 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30858__$1,inst_30856);
} else {
if((state_val_30859 === (12))){
var inst_30785 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30910_30978 = state_30858__$1;
(statearr_30910_30978[(2)] = inst_30785);

(statearr_30910_30978[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (2))){
var state_30858__$1 = state_30858;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30858__$1,(4),ch);
} else {
if((state_val_30859 === (23))){
var state_30858__$1 = state_30858;
var statearr_30911_30979 = state_30858__$1;
(statearr_30911_30979[(2)] = null);

(statearr_30911_30979[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (35))){
var inst_30840 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30912_30980 = state_30858__$1;
(statearr_30912_30980[(2)] = inst_30840);

(statearr_30912_30980[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (19))){
var inst_30757 = (state_30858[(7)]);
var inst_30761 = cljs.core.chunk_first.call(null,inst_30757);
var inst_30762 = cljs.core.chunk_rest.call(null,inst_30757);
var inst_30763 = cljs.core.count.call(null,inst_30761);
var inst_30735 = inst_30762;
var inst_30736 = inst_30761;
var inst_30737 = inst_30763;
var inst_30738 = (0);
var state_30858__$1 = (function (){var statearr_30913 = state_30858;
(statearr_30913[(13)] = inst_30735);

(statearr_30913[(14)] = inst_30737);

(statearr_30913[(15)] = inst_30736);

(statearr_30913[(17)] = inst_30738);

return statearr_30913;
})();
var statearr_30914_30981 = state_30858__$1;
(statearr_30914_30981[(2)] = null);

(statearr_30914_30981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (11))){
var inst_30757 = (state_30858[(7)]);
var inst_30735 = (state_30858[(13)]);
var inst_30757__$1 = cljs.core.seq.call(null,inst_30735);
var state_30858__$1 = (function (){var statearr_30915 = state_30858;
(statearr_30915[(7)] = inst_30757__$1);

return statearr_30915;
})();
if(inst_30757__$1){
var statearr_30916_30982 = state_30858__$1;
(statearr_30916_30982[(1)] = (16));

} else {
var statearr_30917_30983 = state_30858__$1;
(statearr_30917_30983[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (9))){
var inst_30787 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30918_30984 = state_30858__$1;
(statearr_30918_30984[(2)] = inst_30787);

(statearr_30918_30984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (5))){
var inst_30733 = cljs.core.deref.call(null,cs);
var inst_30734 = cljs.core.seq.call(null,inst_30733);
var inst_30735 = inst_30734;
var inst_30736 = null;
var inst_30737 = (0);
var inst_30738 = (0);
var state_30858__$1 = (function (){var statearr_30919 = state_30858;
(statearr_30919[(13)] = inst_30735);

(statearr_30919[(14)] = inst_30737);

(statearr_30919[(15)] = inst_30736);

(statearr_30919[(17)] = inst_30738);

return statearr_30919;
})();
var statearr_30920_30985 = state_30858__$1;
(statearr_30920_30985[(2)] = null);

(statearr_30920_30985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (14))){
var state_30858__$1 = state_30858;
var statearr_30921_30986 = state_30858__$1;
(statearr_30921_30986[(2)] = null);

(statearr_30921_30986[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (45))){
var inst_30848 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30922_30987 = state_30858__$1;
(statearr_30922_30987[(2)] = inst_30848);

(statearr_30922_30987[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (26))){
var inst_30790 = (state_30858[(29)]);
var inst_30844 = (state_30858[(2)]);
var inst_30845 = cljs.core.seq.call(null,inst_30790);
var state_30858__$1 = (function (){var statearr_30923 = state_30858;
(statearr_30923[(31)] = inst_30844);

return statearr_30923;
})();
if(inst_30845){
var statearr_30924_30988 = state_30858__$1;
(statearr_30924_30988[(1)] = (42));

} else {
var statearr_30925_30989 = state_30858__$1;
(statearr_30925_30989[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (16))){
var inst_30757 = (state_30858[(7)]);
var inst_30759 = cljs.core.chunked_seq_QMARK_.call(null,inst_30757);
var state_30858__$1 = state_30858;
if(inst_30759){
var statearr_30926_30990 = state_30858__$1;
(statearr_30926_30990[(1)] = (19));

} else {
var statearr_30927_30991 = state_30858__$1;
(statearr_30927_30991[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (38))){
var inst_30837 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30928_30992 = state_30858__$1;
(statearr_30928_30992[(2)] = inst_30837);

(statearr_30928_30992[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (30))){
var state_30858__$1 = state_30858;
var statearr_30929_30993 = state_30858__$1;
(statearr_30929_30993[(2)] = null);

(statearr_30929_30993[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (10))){
var inst_30736 = (state_30858[(15)]);
var inst_30738 = (state_30858[(17)]);
var inst_30746 = cljs.core._nth.call(null,inst_30736,inst_30738);
var inst_30747 = cljs.core.nth.call(null,inst_30746,(0),null);
var inst_30748 = cljs.core.nth.call(null,inst_30746,(1),null);
var state_30858__$1 = (function (){var statearr_30930 = state_30858;
(statearr_30930[(26)] = inst_30747);

return statearr_30930;
})();
if(cljs.core.truth_(inst_30748)){
var statearr_30931_30994 = state_30858__$1;
(statearr_30931_30994[(1)] = (13));

} else {
var statearr_30932_30995 = state_30858__$1;
(statearr_30932_30995[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (18))){
var inst_30783 = (state_30858[(2)]);
var state_30858__$1 = state_30858;
var statearr_30933_30996 = state_30858__$1;
(statearr_30933_30996[(2)] = inst_30783);

(statearr_30933_30996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (42))){
var state_30858__$1 = state_30858;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30858__$1,(45),dchan);
} else {
if((state_val_30859 === (37))){
var inst_30726 = (state_30858[(9)]);
var inst_30826 = (state_30858[(23)]);
var inst_30817 = (state_30858[(25)]);
var inst_30826__$1 = cljs.core.first.call(null,inst_30817);
var inst_30827 = cljs.core.async.put_BANG_.call(null,inst_30826__$1,inst_30726,done);
var state_30858__$1 = (function (){var statearr_30934 = state_30858;
(statearr_30934[(23)] = inst_30826__$1);

return statearr_30934;
})();
if(cljs.core.truth_(inst_30827)){
var statearr_30935_30997 = state_30858__$1;
(statearr_30935_30997[(1)] = (39));

} else {
var statearr_30936_30998 = state_30858__$1;
(statearr_30936_30998[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30859 === (8))){
var inst_30737 = (state_30858[(14)]);
var inst_30738 = (state_30858[(17)]);
var inst_30740 = (inst_30738 < inst_30737);
var inst_30741 = inst_30740;
var state_30858__$1 = state_30858;
if(cljs.core.truth_(inst_30741)){
var statearr_30937_30999 = state_30858__$1;
(statearr_30937_30999[(1)] = (10));

} else {
var statearr_30938_31000 = state_30858__$1;
(statearr_30938_31000[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___30946,cs,m,dchan,dctr,done))
;
return ((function (switch__29465__auto__,c__29579__auto___30946,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__29466__auto__ = null;
var cljs$core$async$mult_$_state_machine__29466__auto____0 = (function (){
var statearr_30942 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30942[(0)] = cljs$core$async$mult_$_state_machine__29466__auto__);

(statearr_30942[(1)] = (1));

return statearr_30942;
});
var cljs$core$async$mult_$_state_machine__29466__auto____1 = (function (state_30858){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_30858);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e30943){if((e30943 instanceof Object)){
var ex__29469__auto__ = e30943;
var statearr_30944_31001 = state_30858;
(statearr_30944_31001[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30858);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30943;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31002 = state_30858;
state_30858 = G__31002;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29466__auto__ = function(state_30858){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29466__auto____1.call(this,state_30858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29466__auto____0;
cljs$core$async$mult_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29466__auto____1;
return cljs$core$async$mult_$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___30946,cs,m,dchan,dctr,done))
})();
var state__29581__auto__ = (function (){var statearr_30945 = f__29580__auto__.call(null);
(statearr_30945[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___30946);

return statearr_30945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___30946,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args31003 = [];
var len__28114__auto___31006 = arguments.length;
var i__28115__auto___31007 = (0);
while(true){
if((i__28115__auto___31007 < len__28114__auto___31006)){
args31003.push((arguments[i__28115__auto___31007]));

var G__31008 = (i__28115__auto___31007 + (1));
i__28115__auto___31007 = G__31008;
continue;
} else {
}
break;
}

var G__31005 = args31003.length;
switch (G__31005) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31003.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m);
} else {
var m__27612__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,state_map);
} else {
var m__27612__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27611__auto__ = (((m == null))?null:m);
var m__27612__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,m,mode);
} else {
var m__27612__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28121__auto__ = [];
var len__28114__auto___31020 = arguments.length;
var i__28115__auto___31021 = (0);
while(true){
if((i__28115__auto___31021 < len__28114__auto___31020)){
args__28121__auto__.push((arguments[i__28115__auto___31021]));

var G__31022 = (i__28115__auto___31021 + (1));
i__28115__auto___31021 = G__31022;
continue;
} else {
}
break;
}

var argseq__28122__auto__ = ((((3) < args__28121__auto__.length))?(new cljs.core.IndexedSeq(args__28121__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28122__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31014){
var map__31015 = p__31014;
var map__31015__$1 = ((((!((map__31015 == null)))?((((map__31015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31015.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31015):map__31015);
var opts = map__31015__$1;
var statearr_31017_31023 = state;
(statearr_31017_31023[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6747__auto__ = cljs.core.async.do_alts.call(null,((function (map__31015,map__31015__$1,opts){
return (function (val){
var statearr_31018_31024 = state;
(statearr_31018_31024[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31015,map__31015__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6747__auto__)){
var cb = temp__6747__auto__;
var statearr_31019_31025 = state;
(statearr_31019_31025[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31010){
var G__31011 = cljs.core.first.call(null,seq31010);
var seq31010__$1 = cljs.core.next.call(null,seq31010);
var G__31012 = cljs.core.first.call(null,seq31010__$1);
var seq31010__$2 = cljs.core.next.call(null,seq31010__$1);
var G__31013 = cljs.core.first.call(null,seq31010__$2);
var seq31010__$3 = cljs.core.next.call(null,seq31010__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31011,G__31012,G__31013,seq31010__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31193 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31193 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31194){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31194 = meta31194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31195,meta31194__$1){
var self__ = this;
var _31195__$1 = this;
return (new cljs.core.async.t_cljs$core$async31193(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31194__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31195){
var self__ = this;
var _31195__$1 = this;
return self__.meta31194;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31194","meta31194",-363302556,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31193.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31193";

cljs.core.async.t_cljs$core$async31193.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async31193");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31193 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31193(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31194){
return (new cljs.core.async.t_cljs$core$async31193(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31194));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31193(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29579__auto___31360 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___31360,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___31360,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31297){
var state_val_31298 = (state_31297[(1)]);
if((state_val_31298 === (7))){
var inst_31212 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
var statearr_31299_31361 = state_31297__$1;
(statearr_31299_31361[(2)] = inst_31212);

(statearr_31299_31361[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (20))){
var inst_31224 = (state_31297[(7)]);
var state_31297__$1 = state_31297;
var statearr_31300_31362 = state_31297__$1;
(statearr_31300_31362[(2)] = inst_31224);

(statearr_31300_31362[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (27))){
var state_31297__$1 = state_31297;
var statearr_31301_31363 = state_31297__$1;
(statearr_31301_31363[(2)] = null);

(statearr_31301_31363[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (1))){
var inst_31199 = (state_31297[(8)]);
var inst_31199__$1 = calc_state.call(null);
var inst_31201 = (inst_31199__$1 == null);
var inst_31202 = cljs.core.not.call(null,inst_31201);
var state_31297__$1 = (function (){var statearr_31302 = state_31297;
(statearr_31302[(8)] = inst_31199__$1);

return statearr_31302;
})();
if(inst_31202){
var statearr_31303_31364 = state_31297__$1;
(statearr_31303_31364[(1)] = (2));

} else {
var statearr_31304_31365 = state_31297__$1;
(statearr_31304_31365[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (24))){
var inst_31271 = (state_31297[(9)]);
var inst_31248 = (state_31297[(10)]);
var inst_31257 = (state_31297[(11)]);
var inst_31271__$1 = inst_31248.call(null,inst_31257);
var state_31297__$1 = (function (){var statearr_31305 = state_31297;
(statearr_31305[(9)] = inst_31271__$1);

return statearr_31305;
})();
if(cljs.core.truth_(inst_31271__$1)){
var statearr_31306_31366 = state_31297__$1;
(statearr_31306_31366[(1)] = (29));

} else {
var statearr_31307_31367 = state_31297__$1;
(statearr_31307_31367[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (4))){
var inst_31215 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
if(cljs.core.truth_(inst_31215)){
var statearr_31308_31368 = state_31297__$1;
(statearr_31308_31368[(1)] = (8));

} else {
var statearr_31309_31369 = state_31297__$1;
(statearr_31309_31369[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (15))){
var inst_31242 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
if(cljs.core.truth_(inst_31242)){
var statearr_31310_31370 = state_31297__$1;
(statearr_31310_31370[(1)] = (19));

} else {
var statearr_31311_31371 = state_31297__$1;
(statearr_31311_31371[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (21))){
var inst_31247 = (state_31297[(12)]);
var inst_31247__$1 = (state_31297[(2)]);
var inst_31248 = cljs.core.get.call(null,inst_31247__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31249 = cljs.core.get.call(null,inst_31247__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31250 = cljs.core.get.call(null,inst_31247__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31297__$1 = (function (){var statearr_31312 = state_31297;
(statearr_31312[(12)] = inst_31247__$1);

(statearr_31312[(13)] = inst_31249);

(statearr_31312[(10)] = inst_31248);

return statearr_31312;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31297__$1,(22),inst_31250);
} else {
if((state_val_31298 === (31))){
var inst_31279 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
if(cljs.core.truth_(inst_31279)){
var statearr_31313_31372 = state_31297__$1;
(statearr_31313_31372[(1)] = (32));

} else {
var statearr_31314_31373 = state_31297__$1;
(statearr_31314_31373[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (32))){
var inst_31256 = (state_31297[(14)]);
var state_31297__$1 = state_31297;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31297__$1,(35),out,inst_31256);
} else {
if((state_val_31298 === (33))){
var inst_31247 = (state_31297[(12)]);
var inst_31224 = inst_31247;
var state_31297__$1 = (function (){var statearr_31315 = state_31297;
(statearr_31315[(7)] = inst_31224);

return statearr_31315;
})();
var statearr_31316_31374 = state_31297__$1;
(statearr_31316_31374[(2)] = null);

(statearr_31316_31374[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (13))){
var inst_31224 = (state_31297[(7)]);
var inst_31231 = inst_31224.cljs$lang$protocol_mask$partition0$;
var inst_31232 = (inst_31231 & (64));
var inst_31233 = inst_31224.cljs$core$ISeq$;
var inst_31234 = (cljs.core.PROTOCOL_SENTINEL === inst_31233);
var inst_31235 = (inst_31232) || (inst_31234);
var state_31297__$1 = state_31297;
if(cljs.core.truth_(inst_31235)){
var statearr_31317_31375 = state_31297__$1;
(statearr_31317_31375[(1)] = (16));

} else {
var statearr_31318_31376 = state_31297__$1;
(statearr_31318_31376[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (22))){
var inst_31256 = (state_31297[(14)]);
var inst_31257 = (state_31297[(11)]);
var inst_31255 = (state_31297[(2)]);
var inst_31256__$1 = cljs.core.nth.call(null,inst_31255,(0),null);
var inst_31257__$1 = cljs.core.nth.call(null,inst_31255,(1),null);
var inst_31258 = (inst_31256__$1 == null);
var inst_31259 = cljs.core._EQ_.call(null,inst_31257__$1,change);
var inst_31260 = (inst_31258) || (inst_31259);
var state_31297__$1 = (function (){var statearr_31319 = state_31297;
(statearr_31319[(14)] = inst_31256__$1);

(statearr_31319[(11)] = inst_31257__$1);

return statearr_31319;
})();
if(cljs.core.truth_(inst_31260)){
var statearr_31320_31377 = state_31297__$1;
(statearr_31320_31377[(1)] = (23));

} else {
var statearr_31321_31378 = state_31297__$1;
(statearr_31321_31378[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (36))){
var inst_31247 = (state_31297[(12)]);
var inst_31224 = inst_31247;
var state_31297__$1 = (function (){var statearr_31322 = state_31297;
(statearr_31322[(7)] = inst_31224);

return statearr_31322;
})();
var statearr_31323_31379 = state_31297__$1;
(statearr_31323_31379[(2)] = null);

(statearr_31323_31379[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (29))){
var inst_31271 = (state_31297[(9)]);
var state_31297__$1 = state_31297;
var statearr_31324_31380 = state_31297__$1;
(statearr_31324_31380[(2)] = inst_31271);

(statearr_31324_31380[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (6))){
var state_31297__$1 = state_31297;
var statearr_31325_31381 = state_31297__$1;
(statearr_31325_31381[(2)] = false);

(statearr_31325_31381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (28))){
var inst_31267 = (state_31297[(2)]);
var inst_31268 = calc_state.call(null);
var inst_31224 = inst_31268;
var state_31297__$1 = (function (){var statearr_31326 = state_31297;
(statearr_31326[(15)] = inst_31267);

(statearr_31326[(7)] = inst_31224);

return statearr_31326;
})();
var statearr_31327_31382 = state_31297__$1;
(statearr_31327_31382[(2)] = null);

(statearr_31327_31382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (25))){
var inst_31293 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
var statearr_31328_31383 = state_31297__$1;
(statearr_31328_31383[(2)] = inst_31293);

(statearr_31328_31383[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (34))){
var inst_31291 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
var statearr_31329_31384 = state_31297__$1;
(statearr_31329_31384[(2)] = inst_31291);

(statearr_31329_31384[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (17))){
var state_31297__$1 = state_31297;
var statearr_31330_31385 = state_31297__$1;
(statearr_31330_31385[(2)] = false);

(statearr_31330_31385[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (3))){
var state_31297__$1 = state_31297;
var statearr_31331_31386 = state_31297__$1;
(statearr_31331_31386[(2)] = false);

(statearr_31331_31386[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (12))){
var inst_31295 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31297__$1,inst_31295);
} else {
if((state_val_31298 === (2))){
var inst_31199 = (state_31297[(8)]);
var inst_31204 = inst_31199.cljs$lang$protocol_mask$partition0$;
var inst_31205 = (inst_31204 & (64));
var inst_31206 = inst_31199.cljs$core$ISeq$;
var inst_31207 = (cljs.core.PROTOCOL_SENTINEL === inst_31206);
var inst_31208 = (inst_31205) || (inst_31207);
var state_31297__$1 = state_31297;
if(cljs.core.truth_(inst_31208)){
var statearr_31332_31387 = state_31297__$1;
(statearr_31332_31387[(1)] = (5));

} else {
var statearr_31333_31388 = state_31297__$1;
(statearr_31333_31388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (23))){
var inst_31256 = (state_31297[(14)]);
var inst_31262 = (inst_31256 == null);
var state_31297__$1 = state_31297;
if(cljs.core.truth_(inst_31262)){
var statearr_31334_31389 = state_31297__$1;
(statearr_31334_31389[(1)] = (26));

} else {
var statearr_31335_31390 = state_31297__$1;
(statearr_31335_31390[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (35))){
var inst_31282 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
if(cljs.core.truth_(inst_31282)){
var statearr_31336_31391 = state_31297__$1;
(statearr_31336_31391[(1)] = (36));

} else {
var statearr_31337_31392 = state_31297__$1;
(statearr_31337_31392[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (19))){
var inst_31224 = (state_31297[(7)]);
var inst_31244 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31224);
var state_31297__$1 = state_31297;
var statearr_31338_31393 = state_31297__$1;
(statearr_31338_31393[(2)] = inst_31244);

(statearr_31338_31393[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (11))){
var inst_31224 = (state_31297[(7)]);
var inst_31228 = (inst_31224 == null);
var inst_31229 = cljs.core.not.call(null,inst_31228);
var state_31297__$1 = state_31297;
if(inst_31229){
var statearr_31339_31394 = state_31297__$1;
(statearr_31339_31394[(1)] = (13));

} else {
var statearr_31340_31395 = state_31297__$1;
(statearr_31340_31395[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (9))){
var inst_31199 = (state_31297[(8)]);
var state_31297__$1 = state_31297;
var statearr_31341_31396 = state_31297__$1;
(statearr_31341_31396[(2)] = inst_31199);

(statearr_31341_31396[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (5))){
var state_31297__$1 = state_31297;
var statearr_31342_31397 = state_31297__$1;
(statearr_31342_31397[(2)] = true);

(statearr_31342_31397[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (14))){
var state_31297__$1 = state_31297;
var statearr_31343_31398 = state_31297__$1;
(statearr_31343_31398[(2)] = false);

(statearr_31343_31398[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (26))){
var inst_31257 = (state_31297[(11)]);
var inst_31264 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31257);
var state_31297__$1 = state_31297;
var statearr_31344_31399 = state_31297__$1;
(statearr_31344_31399[(2)] = inst_31264);

(statearr_31344_31399[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (16))){
var state_31297__$1 = state_31297;
var statearr_31345_31400 = state_31297__$1;
(statearr_31345_31400[(2)] = true);

(statearr_31345_31400[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (38))){
var inst_31287 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
var statearr_31346_31401 = state_31297__$1;
(statearr_31346_31401[(2)] = inst_31287);

(statearr_31346_31401[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (30))){
var inst_31249 = (state_31297[(13)]);
var inst_31248 = (state_31297[(10)]);
var inst_31257 = (state_31297[(11)]);
var inst_31274 = cljs.core.empty_QMARK_.call(null,inst_31248);
var inst_31275 = inst_31249.call(null,inst_31257);
var inst_31276 = cljs.core.not.call(null,inst_31275);
var inst_31277 = (inst_31274) && (inst_31276);
var state_31297__$1 = state_31297;
var statearr_31347_31402 = state_31297__$1;
(statearr_31347_31402[(2)] = inst_31277);

(statearr_31347_31402[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (10))){
var inst_31199 = (state_31297[(8)]);
var inst_31220 = (state_31297[(2)]);
var inst_31221 = cljs.core.get.call(null,inst_31220,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31222 = cljs.core.get.call(null,inst_31220,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31223 = cljs.core.get.call(null,inst_31220,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31224 = inst_31199;
var state_31297__$1 = (function (){var statearr_31348 = state_31297;
(statearr_31348[(16)] = inst_31223);

(statearr_31348[(7)] = inst_31224);

(statearr_31348[(17)] = inst_31221);

(statearr_31348[(18)] = inst_31222);

return statearr_31348;
})();
var statearr_31349_31403 = state_31297__$1;
(statearr_31349_31403[(2)] = null);

(statearr_31349_31403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (18))){
var inst_31239 = (state_31297[(2)]);
var state_31297__$1 = state_31297;
var statearr_31350_31404 = state_31297__$1;
(statearr_31350_31404[(2)] = inst_31239);

(statearr_31350_31404[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (37))){
var state_31297__$1 = state_31297;
var statearr_31351_31405 = state_31297__$1;
(statearr_31351_31405[(2)] = null);

(statearr_31351_31405[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31298 === (8))){
var inst_31199 = (state_31297[(8)]);
var inst_31217 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31199);
var state_31297__$1 = state_31297;
var statearr_31352_31406 = state_31297__$1;
(statearr_31352_31406[(2)] = inst_31217);

(statearr_31352_31406[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___31360,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__29465__auto__,c__29579__auto___31360,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__29466__auto__ = null;
var cljs$core$async$mix_$_state_machine__29466__auto____0 = (function (){
var statearr_31356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31356[(0)] = cljs$core$async$mix_$_state_machine__29466__auto__);

(statearr_31356[(1)] = (1));

return statearr_31356;
});
var cljs$core$async$mix_$_state_machine__29466__auto____1 = (function (state_31297){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_31297);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e31357){if((e31357 instanceof Object)){
var ex__29469__auto__ = e31357;
var statearr_31358_31407 = state_31297;
(statearr_31358_31407[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31297);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31357;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31408 = state_31297;
state_31297 = G__31408;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29466__auto__ = function(state_31297){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29466__auto____1.call(this,state_31297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29466__auto____0;
cljs$core$async$mix_$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29466__auto____1;
return cljs$core$async$mix_$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___31360,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__29581__auto__ = (function (){var statearr_31359 = f__29580__auto__.call(null);
(statearr_31359[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___31360);

return statearr_31359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___31360,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27612__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p,v,ch);
} else {
var m__27612__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31409 = [];
var len__28114__auto___31412 = arguments.length;
var i__28115__auto___31413 = (0);
while(true){
if((i__28115__auto___31413 < len__28114__auto___31412)){
args31409.push((arguments[i__28115__auto___31413]));

var G__31414 = (i__28115__auto___31413 + (1));
i__28115__auto___31413 = G__31414;
continue;
} else {
}
break;
}

var G__31411 = args31409.length;
switch (G__31411) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31409.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p);
} else {
var m__27612__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27611__auto__ = (((p == null))?null:p);
var m__27612__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27611__auto__)]);
if(!((m__27612__auto__ == null))){
return m__27612__auto__.call(null,p,v);
} else {
var m__27612__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27612__auto____$1 == null))){
return m__27612__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31417 = [];
var len__28114__auto___31542 = arguments.length;
var i__28115__auto___31543 = (0);
while(true){
if((i__28115__auto___31543 < len__28114__auto___31542)){
args31417.push((arguments[i__28115__auto___31543]));

var G__31544 = (i__28115__auto___31543 + (1));
i__28115__auto___31543 = G__31544;
continue;
} else {
}
break;
}

var G__31419 = args31417.length;
switch (G__31419) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31417.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26898__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26898__auto__)){
return or__26898__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26898__auto__,mults){
return (function (p1__31416_SHARP_){
if(cljs.core.truth_(p1__31416_SHARP_.call(null,topic))){
return p1__31416_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31416_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26898__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31420 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31420 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31421){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31421 = meta31421;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31422,meta31421__$1){
var self__ = this;
var _31422__$1 = this;
return (new cljs.core.async.t_cljs$core$async31420(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31421__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31422){
var self__ = this;
var _31422__$1 = this;
return self__.meta31421;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6747__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6747__auto__)){
var m = temp__6747__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31421","meta31421",668451571,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31420.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31420.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31420";

cljs.core.async.t_cljs$core$async31420.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async31420");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31420 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31420(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31421){
return (new cljs.core.async.t_cljs$core$async31420(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31421));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31420(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29579__auto___31546 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___31546,mults,ensure_mult,p){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___31546,mults,ensure_mult,p){
return (function (state_31494){
var state_val_31495 = (state_31494[(1)]);
if((state_val_31495 === (7))){
var inst_31490 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31496_31547 = state_31494__$1;
(statearr_31496_31547[(2)] = inst_31490);

(statearr_31496_31547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (20))){
var state_31494__$1 = state_31494;
var statearr_31497_31548 = state_31494__$1;
(statearr_31497_31548[(2)] = null);

(statearr_31497_31548[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (1))){
var state_31494__$1 = state_31494;
var statearr_31498_31549 = state_31494__$1;
(statearr_31498_31549[(2)] = null);

(statearr_31498_31549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (24))){
var inst_31473 = (state_31494[(7)]);
var inst_31482 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31473);
var state_31494__$1 = state_31494;
var statearr_31499_31550 = state_31494__$1;
(statearr_31499_31550[(2)] = inst_31482);

(statearr_31499_31550[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (4))){
var inst_31425 = (state_31494[(8)]);
var inst_31425__$1 = (state_31494[(2)]);
var inst_31426 = (inst_31425__$1 == null);
var state_31494__$1 = (function (){var statearr_31500 = state_31494;
(statearr_31500[(8)] = inst_31425__$1);

return statearr_31500;
})();
if(cljs.core.truth_(inst_31426)){
var statearr_31501_31551 = state_31494__$1;
(statearr_31501_31551[(1)] = (5));

} else {
var statearr_31502_31552 = state_31494__$1;
(statearr_31502_31552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (15))){
var inst_31467 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31503_31553 = state_31494__$1;
(statearr_31503_31553[(2)] = inst_31467);

(statearr_31503_31553[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (21))){
var inst_31487 = (state_31494[(2)]);
var state_31494__$1 = (function (){var statearr_31504 = state_31494;
(statearr_31504[(9)] = inst_31487);

return statearr_31504;
})();
var statearr_31505_31554 = state_31494__$1;
(statearr_31505_31554[(2)] = null);

(statearr_31505_31554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (13))){
var inst_31449 = (state_31494[(10)]);
var inst_31451 = cljs.core.chunked_seq_QMARK_.call(null,inst_31449);
var state_31494__$1 = state_31494;
if(inst_31451){
var statearr_31506_31555 = state_31494__$1;
(statearr_31506_31555[(1)] = (16));

} else {
var statearr_31507_31556 = state_31494__$1;
(statearr_31507_31556[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (22))){
var inst_31479 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
if(cljs.core.truth_(inst_31479)){
var statearr_31508_31557 = state_31494__$1;
(statearr_31508_31557[(1)] = (23));

} else {
var statearr_31509_31558 = state_31494__$1;
(statearr_31509_31558[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (6))){
var inst_31475 = (state_31494[(11)]);
var inst_31473 = (state_31494[(7)]);
var inst_31425 = (state_31494[(8)]);
var inst_31473__$1 = topic_fn.call(null,inst_31425);
var inst_31474 = cljs.core.deref.call(null,mults);
var inst_31475__$1 = cljs.core.get.call(null,inst_31474,inst_31473__$1);
var state_31494__$1 = (function (){var statearr_31510 = state_31494;
(statearr_31510[(11)] = inst_31475__$1);

(statearr_31510[(7)] = inst_31473__$1);

return statearr_31510;
})();
if(cljs.core.truth_(inst_31475__$1)){
var statearr_31511_31559 = state_31494__$1;
(statearr_31511_31559[(1)] = (19));

} else {
var statearr_31512_31560 = state_31494__$1;
(statearr_31512_31560[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (25))){
var inst_31484 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31513_31561 = state_31494__$1;
(statearr_31513_31561[(2)] = inst_31484);

(statearr_31513_31561[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (17))){
var inst_31449 = (state_31494[(10)]);
var inst_31458 = cljs.core.first.call(null,inst_31449);
var inst_31459 = cljs.core.async.muxch_STAR_.call(null,inst_31458);
var inst_31460 = cljs.core.async.close_BANG_.call(null,inst_31459);
var inst_31461 = cljs.core.next.call(null,inst_31449);
var inst_31435 = inst_31461;
var inst_31436 = null;
var inst_31437 = (0);
var inst_31438 = (0);
var state_31494__$1 = (function (){var statearr_31514 = state_31494;
(statearr_31514[(12)] = inst_31435);

(statearr_31514[(13)] = inst_31437);

(statearr_31514[(14)] = inst_31460);

(statearr_31514[(15)] = inst_31438);

(statearr_31514[(16)] = inst_31436);

return statearr_31514;
})();
var statearr_31515_31562 = state_31494__$1;
(statearr_31515_31562[(2)] = null);

(statearr_31515_31562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (3))){
var inst_31492 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31494__$1,inst_31492);
} else {
if((state_val_31495 === (12))){
var inst_31469 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31516_31563 = state_31494__$1;
(statearr_31516_31563[(2)] = inst_31469);

(statearr_31516_31563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (2))){
var state_31494__$1 = state_31494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31494__$1,(4),ch);
} else {
if((state_val_31495 === (23))){
var state_31494__$1 = state_31494;
var statearr_31517_31564 = state_31494__$1;
(statearr_31517_31564[(2)] = null);

(statearr_31517_31564[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (19))){
var inst_31475 = (state_31494[(11)]);
var inst_31425 = (state_31494[(8)]);
var inst_31477 = cljs.core.async.muxch_STAR_.call(null,inst_31475);
var state_31494__$1 = state_31494;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31494__$1,(22),inst_31477,inst_31425);
} else {
if((state_val_31495 === (11))){
var inst_31435 = (state_31494[(12)]);
var inst_31449 = (state_31494[(10)]);
var inst_31449__$1 = cljs.core.seq.call(null,inst_31435);
var state_31494__$1 = (function (){var statearr_31518 = state_31494;
(statearr_31518[(10)] = inst_31449__$1);

return statearr_31518;
})();
if(inst_31449__$1){
var statearr_31519_31565 = state_31494__$1;
(statearr_31519_31565[(1)] = (13));

} else {
var statearr_31520_31566 = state_31494__$1;
(statearr_31520_31566[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (9))){
var inst_31471 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31521_31567 = state_31494__$1;
(statearr_31521_31567[(2)] = inst_31471);

(statearr_31521_31567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (5))){
var inst_31432 = cljs.core.deref.call(null,mults);
var inst_31433 = cljs.core.vals.call(null,inst_31432);
var inst_31434 = cljs.core.seq.call(null,inst_31433);
var inst_31435 = inst_31434;
var inst_31436 = null;
var inst_31437 = (0);
var inst_31438 = (0);
var state_31494__$1 = (function (){var statearr_31522 = state_31494;
(statearr_31522[(12)] = inst_31435);

(statearr_31522[(13)] = inst_31437);

(statearr_31522[(15)] = inst_31438);

(statearr_31522[(16)] = inst_31436);

return statearr_31522;
})();
var statearr_31523_31568 = state_31494__$1;
(statearr_31523_31568[(2)] = null);

(statearr_31523_31568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (14))){
var state_31494__$1 = state_31494;
var statearr_31527_31569 = state_31494__$1;
(statearr_31527_31569[(2)] = null);

(statearr_31527_31569[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (16))){
var inst_31449 = (state_31494[(10)]);
var inst_31453 = cljs.core.chunk_first.call(null,inst_31449);
var inst_31454 = cljs.core.chunk_rest.call(null,inst_31449);
var inst_31455 = cljs.core.count.call(null,inst_31453);
var inst_31435 = inst_31454;
var inst_31436 = inst_31453;
var inst_31437 = inst_31455;
var inst_31438 = (0);
var state_31494__$1 = (function (){var statearr_31528 = state_31494;
(statearr_31528[(12)] = inst_31435);

(statearr_31528[(13)] = inst_31437);

(statearr_31528[(15)] = inst_31438);

(statearr_31528[(16)] = inst_31436);

return statearr_31528;
})();
var statearr_31529_31570 = state_31494__$1;
(statearr_31529_31570[(2)] = null);

(statearr_31529_31570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (10))){
var inst_31435 = (state_31494[(12)]);
var inst_31437 = (state_31494[(13)]);
var inst_31438 = (state_31494[(15)]);
var inst_31436 = (state_31494[(16)]);
var inst_31443 = cljs.core._nth.call(null,inst_31436,inst_31438);
var inst_31444 = cljs.core.async.muxch_STAR_.call(null,inst_31443);
var inst_31445 = cljs.core.async.close_BANG_.call(null,inst_31444);
var inst_31446 = (inst_31438 + (1));
var tmp31524 = inst_31435;
var tmp31525 = inst_31437;
var tmp31526 = inst_31436;
var inst_31435__$1 = tmp31524;
var inst_31436__$1 = tmp31526;
var inst_31437__$1 = tmp31525;
var inst_31438__$1 = inst_31446;
var state_31494__$1 = (function (){var statearr_31530 = state_31494;
(statearr_31530[(12)] = inst_31435__$1);

(statearr_31530[(13)] = inst_31437__$1);

(statearr_31530[(17)] = inst_31445);

(statearr_31530[(15)] = inst_31438__$1);

(statearr_31530[(16)] = inst_31436__$1);

return statearr_31530;
})();
var statearr_31531_31571 = state_31494__$1;
(statearr_31531_31571[(2)] = null);

(statearr_31531_31571[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (18))){
var inst_31464 = (state_31494[(2)]);
var state_31494__$1 = state_31494;
var statearr_31532_31572 = state_31494__$1;
(statearr_31532_31572[(2)] = inst_31464);

(statearr_31532_31572[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31495 === (8))){
var inst_31437 = (state_31494[(13)]);
var inst_31438 = (state_31494[(15)]);
var inst_31440 = (inst_31438 < inst_31437);
var inst_31441 = inst_31440;
var state_31494__$1 = state_31494;
if(cljs.core.truth_(inst_31441)){
var statearr_31533_31573 = state_31494__$1;
(statearr_31533_31573[(1)] = (10));

} else {
var statearr_31534_31574 = state_31494__$1;
(statearr_31534_31574[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___31546,mults,ensure_mult,p))
;
return ((function (switch__29465__auto__,c__29579__auto___31546,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_31538 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31538[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_31538[(1)] = (1));

return statearr_31538;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_31494){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_31494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e31539){if((e31539 instanceof Object)){
var ex__29469__auto__ = e31539;
var statearr_31540_31575 = state_31494;
(statearr_31540_31575[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31494);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31539;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31576 = state_31494;
state_31494 = G__31576;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_31494){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_31494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___31546,mults,ensure_mult,p))
})();
var state__29581__auto__ = (function (){var statearr_31541 = f__29580__auto__.call(null);
(statearr_31541[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___31546);

return statearr_31541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___31546,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args31577 = [];
var len__28114__auto___31580 = arguments.length;
var i__28115__auto___31581 = (0);
while(true){
if((i__28115__auto___31581 < len__28114__auto___31580)){
args31577.push((arguments[i__28115__auto___31581]));

var G__31582 = (i__28115__auto___31581 + (1));
i__28115__auto___31581 = G__31582;
continue;
} else {
}
break;
}

var G__31579 = args31577.length;
switch (G__31579) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31577.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args31584 = [];
var len__28114__auto___31587 = arguments.length;
var i__28115__auto___31588 = (0);
while(true){
if((i__28115__auto___31588 < len__28114__auto___31587)){
args31584.push((arguments[i__28115__auto___31588]));

var G__31589 = (i__28115__auto___31588 + (1));
i__28115__auto___31588 = G__31589;
continue;
} else {
}
break;
}

var G__31586 = args31584.length;
switch (G__31586) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31584.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args31591 = [];
var len__28114__auto___31662 = arguments.length;
var i__28115__auto___31663 = (0);
while(true){
if((i__28115__auto___31663 < len__28114__auto___31662)){
args31591.push((arguments[i__28115__auto___31663]));

var G__31664 = (i__28115__auto___31663 + (1));
i__28115__auto___31663 = G__31664;
continue;
} else {
}
break;
}

var G__31593 = args31591.length;
switch (G__31593) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31591.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__29579__auto___31666 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___31666,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___31666,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31632){
var state_val_31633 = (state_31632[(1)]);
if((state_val_31633 === (7))){
var state_31632__$1 = state_31632;
var statearr_31634_31667 = state_31632__$1;
(statearr_31634_31667[(2)] = null);

(statearr_31634_31667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (1))){
var state_31632__$1 = state_31632;
var statearr_31635_31668 = state_31632__$1;
(statearr_31635_31668[(2)] = null);

(statearr_31635_31668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (4))){
var inst_31596 = (state_31632[(7)]);
var inst_31598 = (inst_31596 < cnt);
var state_31632__$1 = state_31632;
if(cljs.core.truth_(inst_31598)){
var statearr_31636_31669 = state_31632__$1;
(statearr_31636_31669[(1)] = (6));

} else {
var statearr_31637_31670 = state_31632__$1;
(statearr_31637_31670[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (15))){
var inst_31628 = (state_31632[(2)]);
var state_31632__$1 = state_31632;
var statearr_31638_31671 = state_31632__$1;
(statearr_31638_31671[(2)] = inst_31628);

(statearr_31638_31671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (13))){
var inst_31621 = cljs.core.async.close_BANG_.call(null,out);
var state_31632__$1 = state_31632;
var statearr_31639_31672 = state_31632__$1;
(statearr_31639_31672[(2)] = inst_31621);

(statearr_31639_31672[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (6))){
var state_31632__$1 = state_31632;
var statearr_31640_31673 = state_31632__$1;
(statearr_31640_31673[(2)] = null);

(statearr_31640_31673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (3))){
var inst_31630 = (state_31632[(2)]);
var state_31632__$1 = state_31632;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31632__$1,inst_31630);
} else {
if((state_val_31633 === (12))){
var inst_31618 = (state_31632[(8)]);
var inst_31618__$1 = (state_31632[(2)]);
var inst_31619 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_31618__$1);
var state_31632__$1 = (function (){var statearr_31641 = state_31632;
(statearr_31641[(8)] = inst_31618__$1);

return statearr_31641;
})();
if(cljs.core.truth_(inst_31619)){
var statearr_31642_31674 = state_31632__$1;
(statearr_31642_31674[(1)] = (13));

} else {
var statearr_31643_31675 = state_31632__$1;
(statearr_31643_31675[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (2))){
var inst_31595 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_31596 = (0);
var state_31632__$1 = (function (){var statearr_31644 = state_31632;
(statearr_31644[(9)] = inst_31595);

(statearr_31644[(7)] = inst_31596);

return statearr_31644;
})();
var statearr_31645_31676 = state_31632__$1;
(statearr_31645_31676[(2)] = null);

(statearr_31645_31676[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (11))){
var inst_31596 = (state_31632[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31632,(10),Object,null,(9));
var inst_31605 = chs__$1.call(null,inst_31596);
var inst_31606 = done.call(null,inst_31596);
var inst_31607 = cljs.core.async.take_BANG_.call(null,inst_31605,inst_31606);
var state_31632__$1 = state_31632;
var statearr_31646_31677 = state_31632__$1;
(statearr_31646_31677[(2)] = inst_31607);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31632__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (9))){
var inst_31596 = (state_31632[(7)]);
var inst_31609 = (state_31632[(2)]);
var inst_31610 = (inst_31596 + (1));
var inst_31596__$1 = inst_31610;
var state_31632__$1 = (function (){var statearr_31647 = state_31632;
(statearr_31647[(7)] = inst_31596__$1);

(statearr_31647[(10)] = inst_31609);

return statearr_31647;
})();
var statearr_31648_31678 = state_31632__$1;
(statearr_31648_31678[(2)] = null);

(statearr_31648_31678[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (5))){
var inst_31616 = (state_31632[(2)]);
var state_31632__$1 = (function (){var statearr_31649 = state_31632;
(statearr_31649[(11)] = inst_31616);

return statearr_31649;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31632__$1,(12),dchan);
} else {
if((state_val_31633 === (14))){
var inst_31618 = (state_31632[(8)]);
var inst_31623 = cljs.core.apply.call(null,f,inst_31618);
var state_31632__$1 = state_31632;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31632__$1,(16),out,inst_31623);
} else {
if((state_val_31633 === (16))){
var inst_31625 = (state_31632[(2)]);
var state_31632__$1 = (function (){var statearr_31650 = state_31632;
(statearr_31650[(12)] = inst_31625);

return statearr_31650;
})();
var statearr_31651_31679 = state_31632__$1;
(statearr_31651_31679[(2)] = null);

(statearr_31651_31679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (10))){
var inst_31600 = (state_31632[(2)]);
var inst_31601 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_31632__$1 = (function (){var statearr_31652 = state_31632;
(statearr_31652[(13)] = inst_31600);

return statearr_31652;
})();
var statearr_31653_31680 = state_31632__$1;
(statearr_31653_31680[(2)] = inst_31601);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31632__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31633 === (8))){
var inst_31614 = (state_31632[(2)]);
var state_31632__$1 = state_31632;
var statearr_31654_31681 = state_31632__$1;
(statearr_31654_31681[(2)] = inst_31614);

(statearr_31654_31681[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___31666,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__29465__auto__,c__29579__auto___31666,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_31658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31658[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_31658[(1)] = (1));

return statearr_31658;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_31632){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_31632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e31659){if((e31659 instanceof Object)){
var ex__29469__auto__ = e31659;
var statearr_31660_31682 = state_31632;
(statearr_31660_31682[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31632);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31683 = state_31632;
state_31632 = G__31683;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_31632){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_31632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___31666,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__29581__auto__ = (function (){var statearr_31661 = f__29580__auto__.call(null);
(statearr_31661[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___31666);

return statearr_31661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___31666,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args31685 = [];
var len__28114__auto___31743 = arguments.length;
var i__28115__auto___31744 = (0);
while(true){
if((i__28115__auto___31744 < len__28114__auto___31743)){
args31685.push((arguments[i__28115__auto___31744]));

var G__31745 = (i__28115__auto___31744 + (1));
i__28115__auto___31744 = G__31745;
continue;
} else {
}
break;
}

var G__31687 = args31685.length;
switch (G__31687) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31685.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29579__auto___31747 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___31747,out){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___31747,out){
return (function (state_31719){
var state_val_31720 = (state_31719[(1)]);
if((state_val_31720 === (7))){
var inst_31699 = (state_31719[(7)]);
var inst_31698 = (state_31719[(8)]);
var inst_31698__$1 = (state_31719[(2)]);
var inst_31699__$1 = cljs.core.nth.call(null,inst_31698__$1,(0),null);
var inst_31700 = cljs.core.nth.call(null,inst_31698__$1,(1),null);
var inst_31701 = (inst_31699__$1 == null);
var state_31719__$1 = (function (){var statearr_31721 = state_31719;
(statearr_31721[(7)] = inst_31699__$1);

(statearr_31721[(9)] = inst_31700);

(statearr_31721[(8)] = inst_31698__$1);

return statearr_31721;
})();
if(cljs.core.truth_(inst_31701)){
var statearr_31722_31748 = state_31719__$1;
(statearr_31722_31748[(1)] = (8));

} else {
var statearr_31723_31749 = state_31719__$1;
(statearr_31723_31749[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (1))){
var inst_31688 = cljs.core.vec.call(null,chs);
var inst_31689 = inst_31688;
var state_31719__$1 = (function (){var statearr_31724 = state_31719;
(statearr_31724[(10)] = inst_31689);

return statearr_31724;
})();
var statearr_31725_31750 = state_31719__$1;
(statearr_31725_31750[(2)] = null);

(statearr_31725_31750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (4))){
var inst_31689 = (state_31719[(10)]);
var state_31719__$1 = state_31719;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31719__$1,(7),inst_31689);
} else {
if((state_val_31720 === (6))){
var inst_31715 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
var statearr_31726_31751 = state_31719__$1;
(statearr_31726_31751[(2)] = inst_31715);

(statearr_31726_31751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (3))){
var inst_31717 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31719__$1,inst_31717);
} else {
if((state_val_31720 === (2))){
var inst_31689 = (state_31719[(10)]);
var inst_31691 = cljs.core.count.call(null,inst_31689);
var inst_31692 = (inst_31691 > (0));
var state_31719__$1 = state_31719;
if(cljs.core.truth_(inst_31692)){
var statearr_31728_31752 = state_31719__$1;
(statearr_31728_31752[(1)] = (4));

} else {
var statearr_31729_31753 = state_31719__$1;
(statearr_31729_31753[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (11))){
var inst_31689 = (state_31719[(10)]);
var inst_31708 = (state_31719[(2)]);
var tmp31727 = inst_31689;
var inst_31689__$1 = tmp31727;
var state_31719__$1 = (function (){var statearr_31730 = state_31719;
(statearr_31730[(11)] = inst_31708);

(statearr_31730[(10)] = inst_31689__$1);

return statearr_31730;
})();
var statearr_31731_31754 = state_31719__$1;
(statearr_31731_31754[(2)] = null);

(statearr_31731_31754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (9))){
var inst_31699 = (state_31719[(7)]);
var state_31719__$1 = state_31719;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31719__$1,(11),out,inst_31699);
} else {
if((state_val_31720 === (5))){
var inst_31713 = cljs.core.async.close_BANG_.call(null,out);
var state_31719__$1 = state_31719;
var statearr_31732_31755 = state_31719__$1;
(statearr_31732_31755[(2)] = inst_31713);

(statearr_31732_31755[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (10))){
var inst_31711 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
var statearr_31733_31756 = state_31719__$1;
(statearr_31733_31756[(2)] = inst_31711);

(statearr_31733_31756[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (8))){
var inst_31699 = (state_31719[(7)]);
var inst_31700 = (state_31719[(9)]);
var inst_31689 = (state_31719[(10)]);
var inst_31698 = (state_31719[(8)]);
var inst_31703 = (function (){var cs = inst_31689;
var vec__31694 = inst_31698;
var v = inst_31699;
var c = inst_31700;
return ((function (cs,vec__31694,v,c,inst_31699,inst_31700,inst_31689,inst_31698,state_val_31720,c__29579__auto___31747,out){
return (function (p1__31684_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31684_SHARP_);
});
;})(cs,vec__31694,v,c,inst_31699,inst_31700,inst_31689,inst_31698,state_val_31720,c__29579__auto___31747,out))
})();
var inst_31704 = cljs.core.filterv.call(null,inst_31703,inst_31689);
var inst_31689__$1 = inst_31704;
var state_31719__$1 = (function (){var statearr_31734 = state_31719;
(statearr_31734[(10)] = inst_31689__$1);

return statearr_31734;
})();
var statearr_31735_31757 = state_31719__$1;
(statearr_31735_31757[(2)] = null);

(statearr_31735_31757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___31747,out))
;
return ((function (switch__29465__auto__,c__29579__auto___31747,out){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_31739 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31739[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_31739[(1)] = (1));

return statearr_31739;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_31719){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_31719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e31740){if((e31740 instanceof Object)){
var ex__29469__auto__ = e31740;
var statearr_31741_31758 = state_31719;
(statearr_31741_31758[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31719);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31759 = state_31719;
state_31719 = G__31759;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_31719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_31719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___31747,out))
})();
var state__29581__auto__ = (function (){var statearr_31742 = f__29580__auto__.call(null);
(statearr_31742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___31747);

return statearr_31742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___31747,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args31760 = [];
var len__28114__auto___31809 = arguments.length;
var i__28115__auto___31810 = (0);
while(true){
if((i__28115__auto___31810 < len__28114__auto___31809)){
args31760.push((arguments[i__28115__auto___31810]));

var G__31811 = (i__28115__auto___31810 + (1));
i__28115__auto___31810 = G__31811;
continue;
} else {
}
break;
}

var G__31762 = args31760.length;
switch (G__31762) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31760.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29579__auto___31813 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___31813,out){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___31813,out){
return (function (state_31786){
var state_val_31787 = (state_31786[(1)]);
if((state_val_31787 === (7))){
var inst_31768 = (state_31786[(7)]);
var inst_31768__$1 = (state_31786[(2)]);
var inst_31769 = (inst_31768__$1 == null);
var inst_31770 = cljs.core.not.call(null,inst_31769);
var state_31786__$1 = (function (){var statearr_31788 = state_31786;
(statearr_31788[(7)] = inst_31768__$1);

return statearr_31788;
})();
if(inst_31770){
var statearr_31789_31814 = state_31786__$1;
(statearr_31789_31814[(1)] = (8));

} else {
var statearr_31790_31815 = state_31786__$1;
(statearr_31790_31815[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (1))){
var inst_31763 = (0);
var state_31786__$1 = (function (){var statearr_31791 = state_31786;
(statearr_31791[(8)] = inst_31763);

return statearr_31791;
})();
var statearr_31792_31816 = state_31786__$1;
(statearr_31792_31816[(2)] = null);

(statearr_31792_31816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (4))){
var state_31786__$1 = state_31786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31786__$1,(7),ch);
} else {
if((state_val_31787 === (6))){
var inst_31781 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
var statearr_31793_31817 = state_31786__$1;
(statearr_31793_31817[(2)] = inst_31781);

(statearr_31793_31817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (3))){
var inst_31783 = (state_31786[(2)]);
var inst_31784 = cljs.core.async.close_BANG_.call(null,out);
var state_31786__$1 = (function (){var statearr_31794 = state_31786;
(statearr_31794[(9)] = inst_31783);

return statearr_31794;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31786__$1,inst_31784);
} else {
if((state_val_31787 === (2))){
var inst_31763 = (state_31786[(8)]);
var inst_31765 = (inst_31763 < n);
var state_31786__$1 = state_31786;
if(cljs.core.truth_(inst_31765)){
var statearr_31795_31818 = state_31786__$1;
(statearr_31795_31818[(1)] = (4));

} else {
var statearr_31796_31819 = state_31786__$1;
(statearr_31796_31819[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (11))){
var inst_31763 = (state_31786[(8)]);
var inst_31773 = (state_31786[(2)]);
var inst_31774 = (inst_31763 + (1));
var inst_31763__$1 = inst_31774;
var state_31786__$1 = (function (){var statearr_31797 = state_31786;
(statearr_31797[(10)] = inst_31773);

(statearr_31797[(8)] = inst_31763__$1);

return statearr_31797;
})();
var statearr_31798_31820 = state_31786__$1;
(statearr_31798_31820[(2)] = null);

(statearr_31798_31820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (9))){
var state_31786__$1 = state_31786;
var statearr_31799_31821 = state_31786__$1;
(statearr_31799_31821[(2)] = null);

(statearr_31799_31821[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (5))){
var state_31786__$1 = state_31786;
var statearr_31800_31822 = state_31786__$1;
(statearr_31800_31822[(2)] = null);

(statearr_31800_31822[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (10))){
var inst_31778 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
var statearr_31801_31823 = state_31786__$1;
(statearr_31801_31823[(2)] = inst_31778);

(statearr_31801_31823[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31787 === (8))){
var inst_31768 = (state_31786[(7)]);
var state_31786__$1 = state_31786;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31786__$1,(11),out,inst_31768);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___31813,out))
;
return ((function (switch__29465__auto__,c__29579__auto___31813,out){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_31805 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31805[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_31805[(1)] = (1));

return statearr_31805;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_31786){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_31786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e31806){if((e31806 instanceof Object)){
var ex__29469__auto__ = e31806;
var statearr_31807_31824 = state_31786;
(statearr_31807_31824[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31786);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31825 = state_31786;
state_31786 = G__31825;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_31786){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_31786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___31813,out))
})();
var state__29581__auto__ = (function (){var statearr_31808 = f__29580__auto__.call(null);
(statearr_31808[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___31813);

return statearr_31808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___31813,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31833 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31833 = (function (f,ch,meta31834){
this.f = f;
this.ch = ch;
this.meta31834 = meta31834;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31835,meta31834__$1){
var self__ = this;
var _31835__$1 = this;
return (new cljs.core.async.t_cljs$core$async31833(self__.f,self__.ch,meta31834__$1));
});

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31835){
var self__ = this;
var _31835__$1 = this;
return self__.meta31834;
});

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async31836 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31836 = (function (f,ch,meta31834,_,fn1,meta31837){
this.f = f;
this.ch = ch;
this.meta31834 = meta31834;
this._ = _;
this.fn1 = fn1;
this.meta31837 = meta31837;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31836.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31838,meta31837__$1){
var self__ = this;
var _31838__$1 = this;
return (new cljs.core.async.t_cljs$core$async31836(self__.f,self__.ch,self__.meta31834,self__._,self__.fn1,meta31837__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async31836.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31838){
var self__ = this;
var _31838__$1 = this;
return self__.meta31837;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31836.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31836.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31836.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31836.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31826_SHARP_){
return f1.call(null,(((p1__31826_SHARP_ == null))?null:self__.f.call(null,p1__31826_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async31836.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31834","meta31834",1360667107,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async31833","cljs.core.async/t_cljs$core$async31833",-2014857167,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31837","meta31837",404994191,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31836.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31836.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31836";

cljs.core.async.t_cljs$core$async31836.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async31836");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async31836 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31836(f__$1,ch__$1,meta31834__$1,___$2,fn1__$1,meta31837){
return (new cljs.core.async.t_cljs$core$async31836(f__$1,ch__$1,meta31834__$1,___$2,fn1__$1,meta31837));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async31836(self__.f,self__.ch,self__.meta31834,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26886__auto__ = ret;
if(cljs.core.truth_(and__26886__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26886__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31833.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async31833.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31834","meta31834",1360667107,null)], null);
});

cljs.core.async.t_cljs$core$async31833.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31833.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31833";

cljs.core.async.t_cljs$core$async31833.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async31833");
});

cljs.core.async.__GT_t_cljs$core$async31833 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31833(f__$1,ch__$1,meta31834){
return (new cljs.core.async.t_cljs$core$async31833(f__$1,ch__$1,meta31834));
});

}

return (new cljs.core.async.t_cljs$core$async31833(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31842 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31842 = (function (f,ch,meta31843){
this.f = f;
this.ch = ch;
this.meta31843 = meta31843;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31844,meta31843__$1){
var self__ = this;
var _31844__$1 = this;
return (new cljs.core.async.t_cljs$core$async31842(self__.f,self__.ch,meta31843__$1));
});

cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31844){
var self__ = this;
var _31844__$1 = this;
return self__.meta31843;
});

cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31842.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async31842.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31843","meta31843",1381043081,null)], null);
});

cljs.core.async.t_cljs$core$async31842.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31842.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31842";

cljs.core.async.t_cljs$core$async31842.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async31842");
});

cljs.core.async.__GT_t_cljs$core$async31842 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async31842(f__$1,ch__$1,meta31843){
return (new cljs.core.async.t_cljs$core$async31842(f__$1,ch__$1,meta31843));
});

}

return (new cljs.core.async.t_cljs$core$async31842(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async31848 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31848 = (function (p,ch,meta31849){
this.p = p;
this.ch = ch;
this.meta31849 = meta31849;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31850,meta31849__$1){
var self__ = this;
var _31850__$1 = this;
return (new cljs.core.async.t_cljs$core$async31848(self__.p,self__.ch,meta31849__$1));
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31850){
var self__ = this;
var _31850__$1 = this;
return self__.meta31849;
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async31848.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31849","meta31849",19854652,null)], null);
});

cljs.core.async.t_cljs$core$async31848.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31848.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31848";

cljs.core.async.t_cljs$core$async31848.cljs$lang$ctorPrWriter = (function (this__27550__auto__,writer__27551__auto__,opt__27552__auto__){
return cljs.core._write.call(null,writer__27551__auto__,"cljs.core.async/t_cljs$core$async31848");
});

cljs.core.async.__GT_t_cljs$core$async31848 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async31848(p__$1,ch__$1,meta31849){
return (new cljs.core.async.t_cljs$core$async31848(p__$1,ch__$1,meta31849));
});

}

return (new cljs.core.async.t_cljs$core$async31848(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args31851 = [];
var len__28114__auto___31895 = arguments.length;
var i__28115__auto___31896 = (0);
while(true){
if((i__28115__auto___31896 < len__28114__auto___31895)){
args31851.push((arguments[i__28115__auto___31896]));

var G__31897 = (i__28115__auto___31896 + (1));
i__28115__auto___31896 = G__31897;
continue;
} else {
}
break;
}

var G__31853 = args31851.length;
switch (G__31853) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31851.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29579__auto___31899 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___31899,out){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___31899,out){
return (function (state_31874){
var state_val_31875 = (state_31874[(1)]);
if((state_val_31875 === (7))){
var inst_31870 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
var statearr_31876_31900 = state_31874__$1;
(statearr_31876_31900[(2)] = inst_31870);

(statearr_31876_31900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (1))){
var state_31874__$1 = state_31874;
var statearr_31877_31901 = state_31874__$1;
(statearr_31877_31901[(2)] = null);

(statearr_31877_31901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (4))){
var inst_31856 = (state_31874[(7)]);
var inst_31856__$1 = (state_31874[(2)]);
var inst_31857 = (inst_31856__$1 == null);
var state_31874__$1 = (function (){var statearr_31878 = state_31874;
(statearr_31878[(7)] = inst_31856__$1);

return statearr_31878;
})();
if(cljs.core.truth_(inst_31857)){
var statearr_31879_31902 = state_31874__$1;
(statearr_31879_31902[(1)] = (5));

} else {
var statearr_31880_31903 = state_31874__$1;
(statearr_31880_31903[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (6))){
var inst_31856 = (state_31874[(7)]);
var inst_31861 = p.call(null,inst_31856);
var state_31874__$1 = state_31874;
if(cljs.core.truth_(inst_31861)){
var statearr_31881_31904 = state_31874__$1;
(statearr_31881_31904[(1)] = (8));

} else {
var statearr_31882_31905 = state_31874__$1;
(statearr_31882_31905[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (3))){
var inst_31872 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31874__$1,inst_31872);
} else {
if((state_val_31875 === (2))){
var state_31874__$1 = state_31874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31874__$1,(4),ch);
} else {
if((state_val_31875 === (11))){
var inst_31864 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
var statearr_31883_31906 = state_31874__$1;
(statearr_31883_31906[(2)] = inst_31864);

(statearr_31883_31906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (9))){
var state_31874__$1 = state_31874;
var statearr_31884_31907 = state_31874__$1;
(statearr_31884_31907[(2)] = null);

(statearr_31884_31907[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (5))){
var inst_31859 = cljs.core.async.close_BANG_.call(null,out);
var state_31874__$1 = state_31874;
var statearr_31885_31908 = state_31874__$1;
(statearr_31885_31908[(2)] = inst_31859);

(statearr_31885_31908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (10))){
var inst_31867 = (state_31874[(2)]);
var state_31874__$1 = (function (){var statearr_31886 = state_31874;
(statearr_31886[(8)] = inst_31867);

return statearr_31886;
})();
var statearr_31887_31909 = state_31874__$1;
(statearr_31887_31909[(2)] = null);

(statearr_31887_31909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (8))){
var inst_31856 = (state_31874[(7)]);
var state_31874__$1 = state_31874;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31874__$1,(11),out,inst_31856);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___31899,out))
;
return ((function (switch__29465__auto__,c__29579__auto___31899,out){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_31891 = [null,null,null,null,null,null,null,null,null];
(statearr_31891[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_31891[(1)] = (1));

return statearr_31891;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_31874){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_31874);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e31892){if((e31892 instanceof Object)){
var ex__29469__auto__ = e31892;
var statearr_31893_31910 = state_31874;
(statearr_31893_31910[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31874);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31892;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31911 = state_31874;
state_31874 = G__31911;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_31874){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_31874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___31899,out))
})();
var state__29581__auto__ = (function (){var statearr_31894 = f__29580__auto__.call(null);
(statearr_31894[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___31899);

return statearr_31894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___31899,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args31912 = [];
var len__28114__auto___31915 = arguments.length;
var i__28115__auto___31916 = (0);
while(true){
if((i__28115__auto___31916 < len__28114__auto___31915)){
args31912.push((arguments[i__28115__auto___31916]));

var G__31917 = (i__28115__auto___31916 + (1));
i__28115__auto___31916 = G__31917;
continue;
} else {
}
break;
}

var G__31914 = args31912.length;
switch (G__31914) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31912.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29579__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto__){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto__){
return (function (state_32084){
var state_val_32085 = (state_32084[(1)]);
if((state_val_32085 === (7))){
var inst_32080 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
var statearr_32086_32127 = state_32084__$1;
(statearr_32086_32127[(2)] = inst_32080);

(statearr_32086_32127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (20))){
var inst_32050 = (state_32084[(7)]);
var inst_32061 = (state_32084[(2)]);
var inst_32062 = cljs.core.next.call(null,inst_32050);
var inst_32036 = inst_32062;
var inst_32037 = null;
var inst_32038 = (0);
var inst_32039 = (0);
var state_32084__$1 = (function (){var statearr_32087 = state_32084;
(statearr_32087[(8)] = inst_32036);

(statearr_32087[(9)] = inst_32038);

(statearr_32087[(10)] = inst_32061);

(statearr_32087[(11)] = inst_32039);

(statearr_32087[(12)] = inst_32037);

return statearr_32087;
})();
var statearr_32088_32128 = state_32084__$1;
(statearr_32088_32128[(2)] = null);

(statearr_32088_32128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (1))){
var state_32084__$1 = state_32084;
var statearr_32089_32129 = state_32084__$1;
(statearr_32089_32129[(2)] = null);

(statearr_32089_32129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (4))){
var inst_32025 = (state_32084[(13)]);
var inst_32025__$1 = (state_32084[(2)]);
var inst_32026 = (inst_32025__$1 == null);
var state_32084__$1 = (function (){var statearr_32090 = state_32084;
(statearr_32090[(13)] = inst_32025__$1);

return statearr_32090;
})();
if(cljs.core.truth_(inst_32026)){
var statearr_32091_32130 = state_32084__$1;
(statearr_32091_32130[(1)] = (5));

} else {
var statearr_32092_32131 = state_32084__$1;
(statearr_32092_32131[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (15))){
var state_32084__$1 = state_32084;
var statearr_32096_32132 = state_32084__$1;
(statearr_32096_32132[(2)] = null);

(statearr_32096_32132[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (21))){
var state_32084__$1 = state_32084;
var statearr_32097_32133 = state_32084__$1;
(statearr_32097_32133[(2)] = null);

(statearr_32097_32133[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (13))){
var inst_32036 = (state_32084[(8)]);
var inst_32038 = (state_32084[(9)]);
var inst_32039 = (state_32084[(11)]);
var inst_32037 = (state_32084[(12)]);
var inst_32046 = (state_32084[(2)]);
var inst_32047 = (inst_32039 + (1));
var tmp32093 = inst_32036;
var tmp32094 = inst_32038;
var tmp32095 = inst_32037;
var inst_32036__$1 = tmp32093;
var inst_32037__$1 = tmp32095;
var inst_32038__$1 = tmp32094;
var inst_32039__$1 = inst_32047;
var state_32084__$1 = (function (){var statearr_32098 = state_32084;
(statearr_32098[(8)] = inst_32036__$1);

(statearr_32098[(9)] = inst_32038__$1);

(statearr_32098[(14)] = inst_32046);

(statearr_32098[(11)] = inst_32039__$1);

(statearr_32098[(12)] = inst_32037__$1);

return statearr_32098;
})();
var statearr_32099_32134 = state_32084__$1;
(statearr_32099_32134[(2)] = null);

(statearr_32099_32134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (22))){
var state_32084__$1 = state_32084;
var statearr_32100_32135 = state_32084__$1;
(statearr_32100_32135[(2)] = null);

(statearr_32100_32135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (6))){
var inst_32025 = (state_32084[(13)]);
var inst_32034 = f.call(null,inst_32025);
var inst_32035 = cljs.core.seq.call(null,inst_32034);
var inst_32036 = inst_32035;
var inst_32037 = null;
var inst_32038 = (0);
var inst_32039 = (0);
var state_32084__$1 = (function (){var statearr_32101 = state_32084;
(statearr_32101[(8)] = inst_32036);

(statearr_32101[(9)] = inst_32038);

(statearr_32101[(11)] = inst_32039);

(statearr_32101[(12)] = inst_32037);

return statearr_32101;
})();
var statearr_32102_32136 = state_32084__$1;
(statearr_32102_32136[(2)] = null);

(statearr_32102_32136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (17))){
var inst_32050 = (state_32084[(7)]);
var inst_32054 = cljs.core.chunk_first.call(null,inst_32050);
var inst_32055 = cljs.core.chunk_rest.call(null,inst_32050);
var inst_32056 = cljs.core.count.call(null,inst_32054);
var inst_32036 = inst_32055;
var inst_32037 = inst_32054;
var inst_32038 = inst_32056;
var inst_32039 = (0);
var state_32084__$1 = (function (){var statearr_32103 = state_32084;
(statearr_32103[(8)] = inst_32036);

(statearr_32103[(9)] = inst_32038);

(statearr_32103[(11)] = inst_32039);

(statearr_32103[(12)] = inst_32037);

return statearr_32103;
})();
var statearr_32104_32137 = state_32084__$1;
(statearr_32104_32137[(2)] = null);

(statearr_32104_32137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (3))){
var inst_32082 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32084__$1,inst_32082);
} else {
if((state_val_32085 === (12))){
var inst_32070 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
var statearr_32105_32138 = state_32084__$1;
(statearr_32105_32138[(2)] = inst_32070);

(statearr_32105_32138[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (2))){
var state_32084__$1 = state_32084;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32084__$1,(4),in$);
} else {
if((state_val_32085 === (23))){
var inst_32078 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
var statearr_32106_32139 = state_32084__$1;
(statearr_32106_32139[(2)] = inst_32078);

(statearr_32106_32139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (19))){
var inst_32065 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
var statearr_32107_32140 = state_32084__$1;
(statearr_32107_32140[(2)] = inst_32065);

(statearr_32107_32140[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (11))){
var inst_32036 = (state_32084[(8)]);
var inst_32050 = (state_32084[(7)]);
var inst_32050__$1 = cljs.core.seq.call(null,inst_32036);
var state_32084__$1 = (function (){var statearr_32108 = state_32084;
(statearr_32108[(7)] = inst_32050__$1);

return statearr_32108;
})();
if(inst_32050__$1){
var statearr_32109_32141 = state_32084__$1;
(statearr_32109_32141[(1)] = (14));

} else {
var statearr_32110_32142 = state_32084__$1;
(statearr_32110_32142[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (9))){
var inst_32072 = (state_32084[(2)]);
var inst_32073 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32084__$1 = (function (){var statearr_32111 = state_32084;
(statearr_32111[(15)] = inst_32072);

return statearr_32111;
})();
if(cljs.core.truth_(inst_32073)){
var statearr_32112_32143 = state_32084__$1;
(statearr_32112_32143[(1)] = (21));

} else {
var statearr_32113_32144 = state_32084__$1;
(statearr_32113_32144[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (5))){
var inst_32028 = cljs.core.async.close_BANG_.call(null,out);
var state_32084__$1 = state_32084;
var statearr_32114_32145 = state_32084__$1;
(statearr_32114_32145[(2)] = inst_32028);

(statearr_32114_32145[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (14))){
var inst_32050 = (state_32084[(7)]);
var inst_32052 = cljs.core.chunked_seq_QMARK_.call(null,inst_32050);
var state_32084__$1 = state_32084;
if(inst_32052){
var statearr_32115_32146 = state_32084__$1;
(statearr_32115_32146[(1)] = (17));

} else {
var statearr_32116_32147 = state_32084__$1;
(statearr_32116_32147[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (16))){
var inst_32068 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
var statearr_32117_32148 = state_32084__$1;
(statearr_32117_32148[(2)] = inst_32068);

(statearr_32117_32148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32085 === (10))){
var inst_32039 = (state_32084[(11)]);
var inst_32037 = (state_32084[(12)]);
var inst_32044 = cljs.core._nth.call(null,inst_32037,inst_32039);
var state_32084__$1 = state_32084;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32084__$1,(13),out,inst_32044);
} else {
if((state_val_32085 === (18))){
var inst_32050 = (state_32084[(7)]);
var inst_32059 = cljs.core.first.call(null,inst_32050);
var state_32084__$1 = state_32084;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32084__$1,(20),out,inst_32059);
} else {
if((state_val_32085 === (8))){
var inst_32038 = (state_32084[(9)]);
var inst_32039 = (state_32084[(11)]);
var inst_32041 = (inst_32039 < inst_32038);
var inst_32042 = inst_32041;
var state_32084__$1 = state_32084;
if(cljs.core.truth_(inst_32042)){
var statearr_32118_32149 = state_32084__$1;
(statearr_32118_32149[(1)] = (10));

} else {
var statearr_32119_32150 = state_32084__$1;
(statearr_32119_32150[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto__))
;
return ((function (switch__29465__auto__,c__29579__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29466__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29466__auto____0 = (function (){
var statearr_32123 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32123[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29466__auto__);

(statearr_32123[(1)] = (1));

return statearr_32123;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29466__auto____1 = (function (state_32084){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_32084);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e32124){if((e32124 instanceof Object)){
var ex__29469__auto__ = e32124;
var statearr_32125_32151 = state_32084;
(statearr_32125_32151[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32084);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32124;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32152 = state_32084;
state_32084 = G__32152;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29466__auto__ = function(state_32084){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29466__auto____1.call(this,state_32084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29466__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29466__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto__))
})();
var state__29581__auto__ = (function (){var statearr_32126 = f__29580__auto__.call(null);
(statearr_32126[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto__);

return statearr_32126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto__))
);

return c__29579__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args32153 = [];
var len__28114__auto___32156 = arguments.length;
var i__28115__auto___32157 = (0);
while(true){
if((i__28115__auto___32157 < len__28114__auto___32156)){
args32153.push((arguments[i__28115__auto___32157]));

var G__32158 = (i__28115__auto___32157 + (1));
i__28115__auto___32157 = G__32158;
continue;
} else {
}
break;
}

var G__32155 = args32153.length;
switch (G__32155) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32153.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args32160 = [];
var len__28114__auto___32163 = arguments.length;
var i__28115__auto___32164 = (0);
while(true){
if((i__28115__auto___32164 < len__28114__auto___32163)){
args32160.push((arguments[i__28115__auto___32164]));

var G__32165 = (i__28115__auto___32164 + (1));
i__28115__auto___32164 = G__32165;
continue;
} else {
}
break;
}

var G__32162 = args32160.length;
switch (G__32162) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32160.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args32167 = [];
var len__28114__auto___32218 = arguments.length;
var i__28115__auto___32219 = (0);
while(true){
if((i__28115__auto___32219 < len__28114__auto___32218)){
args32167.push((arguments[i__28115__auto___32219]));

var G__32220 = (i__28115__auto___32219 + (1));
i__28115__auto___32219 = G__32220;
continue;
} else {
}
break;
}

var G__32169 = args32167.length;
switch (G__32169) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32167.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29579__auto___32222 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___32222,out){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___32222,out){
return (function (state_32193){
var state_val_32194 = (state_32193[(1)]);
if((state_val_32194 === (7))){
var inst_32188 = (state_32193[(2)]);
var state_32193__$1 = state_32193;
var statearr_32195_32223 = state_32193__$1;
(statearr_32195_32223[(2)] = inst_32188);

(statearr_32195_32223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32194 === (1))){
var inst_32170 = null;
var state_32193__$1 = (function (){var statearr_32196 = state_32193;
(statearr_32196[(7)] = inst_32170);

return statearr_32196;
})();
var statearr_32197_32224 = state_32193__$1;
(statearr_32197_32224[(2)] = null);

(statearr_32197_32224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32194 === (4))){
var inst_32173 = (state_32193[(8)]);
var inst_32173__$1 = (state_32193[(2)]);
var inst_32174 = (inst_32173__$1 == null);
var inst_32175 = cljs.core.not.call(null,inst_32174);
var state_32193__$1 = (function (){var statearr_32198 = state_32193;
(statearr_32198[(8)] = inst_32173__$1);

return statearr_32198;
})();
if(inst_32175){
var statearr_32199_32225 = state_32193__$1;
(statearr_32199_32225[(1)] = (5));

} else {
var statearr_32200_32226 = state_32193__$1;
(statearr_32200_32226[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32194 === (6))){
var state_32193__$1 = state_32193;
var statearr_32201_32227 = state_32193__$1;
(statearr_32201_32227[(2)] = null);

(statearr_32201_32227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32194 === (3))){
var inst_32190 = (state_32193[(2)]);
var inst_32191 = cljs.core.async.close_BANG_.call(null,out);
var state_32193__$1 = (function (){var statearr_32202 = state_32193;
(statearr_32202[(9)] = inst_32190);

return statearr_32202;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32193__$1,inst_32191);
} else {
if((state_val_32194 === (2))){
var state_32193__$1 = state_32193;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32193__$1,(4),ch);
} else {
if((state_val_32194 === (11))){
var inst_32173 = (state_32193[(8)]);
var inst_32182 = (state_32193[(2)]);
var inst_32170 = inst_32173;
var state_32193__$1 = (function (){var statearr_32203 = state_32193;
(statearr_32203[(10)] = inst_32182);

(statearr_32203[(7)] = inst_32170);

return statearr_32203;
})();
var statearr_32204_32228 = state_32193__$1;
(statearr_32204_32228[(2)] = null);

(statearr_32204_32228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32194 === (9))){
var inst_32173 = (state_32193[(8)]);
var state_32193__$1 = state_32193;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32193__$1,(11),out,inst_32173);
} else {
if((state_val_32194 === (5))){
var inst_32173 = (state_32193[(8)]);
var inst_32170 = (state_32193[(7)]);
var inst_32177 = cljs.core._EQ_.call(null,inst_32173,inst_32170);
var state_32193__$1 = state_32193;
if(inst_32177){
var statearr_32206_32229 = state_32193__$1;
(statearr_32206_32229[(1)] = (8));

} else {
var statearr_32207_32230 = state_32193__$1;
(statearr_32207_32230[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32194 === (10))){
var inst_32185 = (state_32193[(2)]);
var state_32193__$1 = state_32193;
var statearr_32208_32231 = state_32193__$1;
(statearr_32208_32231[(2)] = inst_32185);

(statearr_32208_32231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32194 === (8))){
var inst_32170 = (state_32193[(7)]);
var tmp32205 = inst_32170;
var inst_32170__$1 = tmp32205;
var state_32193__$1 = (function (){var statearr_32209 = state_32193;
(statearr_32209[(7)] = inst_32170__$1);

return statearr_32209;
})();
var statearr_32210_32232 = state_32193__$1;
(statearr_32210_32232[(2)] = null);

(statearr_32210_32232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___32222,out))
;
return ((function (switch__29465__auto__,c__29579__auto___32222,out){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_32214 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32214[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_32214[(1)] = (1));

return statearr_32214;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_32193){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_32193);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e32215){if((e32215 instanceof Object)){
var ex__29469__auto__ = e32215;
var statearr_32216_32233 = state_32193;
(statearr_32216_32233[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32193);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32215;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32234 = state_32193;
state_32193 = G__32234;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_32193){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_32193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___32222,out))
})();
var state__29581__auto__ = (function (){var statearr_32217 = f__29580__auto__.call(null);
(statearr_32217[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___32222);

return statearr_32217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___32222,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args32235 = [];
var len__28114__auto___32305 = arguments.length;
var i__28115__auto___32306 = (0);
while(true){
if((i__28115__auto___32306 < len__28114__auto___32305)){
args32235.push((arguments[i__28115__auto___32306]));

var G__32307 = (i__28115__auto___32306 + (1));
i__28115__auto___32306 = G__32307;
continue;
} else {
}
break;
}

var G__32237 = args32235.length;
switch (G__32237) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32235.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29579__auto___32309 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___32309,out){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___32309,out){
return (function (state_32275){
var state_val_32276 = (state_32275[(1)]);
if((state_val_32276 === (7))){
var inst_32271 = (state_32275[(2)]);
var state_32275__$1 = state_32275;
var statearr_32277_32310 = state_32275__$1;
(statearr_32277_32310[(2)] = inst_32271);

(statearr_32277_32310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (1))){
var inst_32238 = (new Array(n));
var inst_32239 = inst_32238;
var inst_32240 = (0);
var state_32275__$1 = (function (){var statearr_32278 = state_32275;
(statearr_32278[(7)] = inst_32240);

(statearr_32278[(8)] = inst_32239);

return statearr_32278;
})();
var statearr_32279_32311 = state_32275__$1;
(statearr_32279_32311[(2)] = null);

(statearr_32279_32311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (4))){
var inst_32243 = (state_32275[(9)]);
var inst_32243__$1 = (state_32275[(2)]);
var inst_32244 = (inst_32243__$1 == null);
var inst_32245 = cljs.core.not.call(null,inst_32244);
var state_32275__$1 = (function (){var statearr_32280 = state_32275;
(statearr_32280[(9)] = inst_32243__$1);

return statearr_32280;
})();
if(inst_32245){
var statearr_32281_32312 = state_32275__$1;
(statearr_32281_32312[(1)] = (5));

} else {
var statearr_32282_32313 = state_32275__$1;
(statearr_32282_32313[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (15))){
var inst_32265 = (state_32275[(2)]);
var state_32275__$1 = state_32275;
var statearr_32283_32314 = state_32275__$1;
(statearr_32283_32314[(2)] = inst_32265);

(statearr_32283_32314[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (13))){
var state_32275__$1 = state_32275;
var statearr_32284_32315 = state_32275__$1;
(statearr_32284_32315[(2)] = null);

(statearr_32284_32315[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (6))){
var inst_32240 = (state_32275[(7)]);
var inst_32261 = (inst_32240 > (0));
var state_32275__$1 = state_32275;
if(cljs.core.truth_(inst_32261)){
var statearr_32285_32316 = state_32275__$1;
(statearr_32285_32316[(1)] = (12));

} else {
var statearr_32286_32317 = state_32275__$1;
(statearr_32286_32317[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (3))){
var inst_32273 = (state_32275[(2)]);
var state_32275__$1 = state_32275;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32275__$1,inst_32273);
} else {
if((state_val_32276 === (12))){
var inst_32239 = (state_32275[(8)]);
var inst_32263 = cljs.core.vec.call(null,inst_32239);
var state_32275__$1 = state_32275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32275__$1,(15),out,inst_32263);
} else {
if((state_val_32276 === (2))){
var state_32275__$1 = state_32275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32275__$1,(4),ch);
} else {
if((state_val_32276 === (11))){
var inst_32255 = (state_32275[(2)]);
var inst_32256 = (new Array(n));
var inst_32239 = inst_32256;
var inst_32240 = (0);
var state_32275__$1 = (function (){var statearr_32287 = state_32275;
(statearr_32287[(10)] = inst_32255);

(statearr_32287[(7)] = inst_32240);

(statearr_32287[(8)] = inst_32239);

return statearr_32287;
})();
var statearr_32288_32318 = state_32275__$1;
(statearr_32288_32318[(2)] = null);

(statearr_32288_32318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (9))){
var inst_32239 = (state_32275[(8)]);
var inst_32253 = cljs.core.vec.call(null,inst_32239);
var state_32275__$1 = state_32275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32275__$1,(11),out,inst_32253);
} else {
if((state_val_32276 === (5))){
var inst_32248 = (state_32275[(11)]);
var inst_32240 = (state_32275[(7)]);
var inst_32243 = (state_32275[(9)]);
var inst_32239 = (state_32275[(8)]);
var inst_32247 = (inst_32239[inst_32240] = inst_32243);
var inst_32248__$1 = (inst_32240 + (1));
var inst_32249 = (inst_32248__$1 < n);
var state_32275__$1 = (function (){var statearr_32289 = state_32275;
(statearr_32289[(11)] = inst_32248__$1);

(statearr_32289[(12)] = inst_32247);

return statearr_32289;
})();
if(cljs.core.truth_(inst_32249)){
var statearr_32290_32319 = state_32275__$1;
(statearr_32290_32319[(1)] = (8));

} else {
var statearr_32291_32320 = state_32275__$1;
(statearr_32291_32320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (14))){
var inst_32268 = (state_32275[(2)]);
var inst_32269 = cljs.core.async.close_BANG_.call(null,out);
var state_32275__$1 = (function (){var statearr_32293 = state_32275;
(statearr_32293[(13)] = inst_32268);

return statearr_32293;
})();
var statearr_32294_32321 = state_32275__$1;
(statearr_32294_32321[(2)] = inst_32269);

(statearr_32294_32321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (10))){
var inst_32259 = (state_32275[(2)]);
var state_32275__$1 = state_32275;
var statearr_32295_32322 = state_32275__$1;
(statearr_32295_32322[(2)] = inst_32259);

(statearr_32295_32322[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32276 === (8))){
var inst_32248 = (state_32275[(11)]);
var inst_32239 = (state_32275[(8)]);
var tmp32292 = inst_32239;
var inst_32239__$1 = tmp32292;
var inst_32240 = inst_32248;
var state_32275__$1 = (function (){var statearr_32296 = state_32275;
(statearr_32296[(7)] = inst_32240);

(statearr_32296[(8)] = inst_32239__$1);

return statearr_32296;
})();
var statearr_32297_32323 = state_32275__$1;
(statearr_32297_32323[(2)] = null);

(statearr_32297_32323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___32309,out))
;
return ((function (switch__29465__auto__,c__29579__auto___32309,out){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_32301 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32301[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_32301[(1)] = (1));

return statearr_32301;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_32275){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_32275);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e32302){if((e32302 instanceof Object)){
var ex__29469__auto__ = e32302;
var statearr_32303_32324 = state_32275;
(statearr_32303_32324[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32275);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32302;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32325 = state_32275;
state_32275 = G__32325;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_32275){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_32275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___32309,out))
})();
var state__29581__auto__ = (function (){var statearr_32304 = f__29580__auto__.call(null);
(statearr_32304[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___32309);

return statearr_32304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___32309,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args32326 = [];
var len__28114__auto___32400 = arguments.length;
var i__28115__auto___32401 = (0);
while(true){
if((i__28115__auto___32401 < len__28114__auto___32400)){
args32326.push((arguments[i__28115__auto___32401]));

var G__32402 = (i__28115__auto___32401 + (1));
i__28115__auto___32401 = G__32402;
continue;
} else {
}
break;
}

var G__32328 = args32326.length;
switch (G__32328) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32326.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29579__auto___32404 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29579__auto___32404,out){
return (function (){
var f__29580__auto__ = (function (){var switch__29465__auto__ = ((function (c__29579__auto___32404,out){
return (function (state_32370){
var state_val_32371 = (state_32370[(1)]);
if((state_val_32371 === (7))){
var inst_32366 = (state_32370[(2)]);
var state_32370__$1 = state_32370;
var statearr_32372_32405 = state_32370__$1;
(statearr_32372_32405[(2)] = inst_32366);

(statearr_32372_32405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (1))){
var inst_32329 = [];
var inst_32330 = inst_32329;
var inst_32331 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32370__$1 = (function (){var statearr_32373 = state_32370;
(statearr_32373[(7)] = inst_32331);

(statearr_32373[(8)] = inst_32330);

return statearr_32373;
})();
var statearr_32374_32406 = state_32370__$1;
(statearr_32374_32406[(2)] = null);

(statearr_32374_32406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (4))){
var inst_32334 = (state_32370[(9)]);
var inst_32334__$1 = (state_32370[(2)]);
var inst_32335 = (inst_32334__$1 == null);
var inst_32336 = cljs.core.not.call(null,inst_32335);
var state_32370__$1 = (function (){var statearr_32375 = state_32370;
(statearr_32375[(9)] = inst_32334__$1);

return statearr_32375;
})();
if(inst_32336){
var statearr_32376_32407 = state_32370__$1;
(statearr_32376_32407[(1)] = (5));

} else {
var statearr_32377_32408 = state_32370__$1;
(statearr_32377_32408[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (15))){
var inst_32360 = (state_32370[(2)]);
var state_32370__$1 = state_32370;
var statearr_32378_32409 = state_32370__$1;
(statearr_32378_32409[(2)] = inst_32360);

(statearr_32378_32409[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (13))){
var state_32370__$1 = state_32370;
var statearr_32379_32410 = state_32370__$1;
(statearr_32379_32410[(2)] = null);

(statearr_32379_32410[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (6))){
var inst_32330 = (state_32370[(8)]);
var inst_32355 = inst_32330.length;
var inst_32356 = (inst_32355 > (0));
var state_32370__$1 = state_32370;
if(cljs.core.truth_(inst_32356)){
var statearr_32380_32411 = state_32370__$1;
(statearr_32380_32411[(1)] = (12));

} else {
var statearr_32381_32412 = state_32370__$1;
(statearr_32381_32412[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (3))){
var inst_32368 = (state_32370[(2)]);
var state_32370__$1 = state_32370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32370__$1,inst_32368);
} else {
if((state_val_32371 === (12))){
var inst_32330 = (state_32370[(8)]);
var inst_32358 = cljs.core.vec.call(null,inst_32330);
var state_32370__$1 = state_32370;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32370__$1,(15),out,inst_32358);
} else {
if((state_val_32371 === (2))){
var state_32370__$1 = state_32370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32370__$1,(4),ch);
} else {
if((state_val_32371 === (11))){
var inst_32334 = (state_32370[(9)]);
var inst_32338 = (state_32370[(10)]);
var inst_32348 = (state_32370[(2)]);
var inst_32349 = [];
var inst_32350 = inst_32349.push(inst_32334);
var inst_32330 = inst_32349;
var inst_32331 = inst_32338;
var state_32370__$1 = (function (){var statearr_32382 = state_32370;
(statearr_32382[(11)] = inst_32350);

(statearr_32382[(7)] = inst_32331);

(statearr_32382[(8)] = inst_32330);

(statearr_32382[(12)] = inst_32348);

return statearr_32382;
})();
var statearr_32383_32413 = state_32370__$1;
(statearr_32383_32413[(2)] = null);

(statearr_32383_32413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (9))){
var inst_32330 = (state_32370[(8)]);
var inst_32346 = cljs.core.vec.call(null,inst_32330);
var state_32370__$1 = state_32370;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32370__$1,(11),out,inst_32346);
} else {
if((state_val_32371 === (5))){
var inst_32331 = (state_32370[(7)]);
var inst_32334 = (state_32370[(9)]);
var inst_32338 = (state_32370[(10)]);
var inst_32338__$1 = f.call(null,inst_32334);
var inst_32339 = cljs.core._EQ_.call(null,inst_32338__$1,inst_32331);
var inst_32340 = cljs.core.keyword_identical_QMARK_.call(null,inst_32331,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32341 = (inst_32339) || (inst_32340);
var state_32370__$1 = (function (){var statearr_32384 = state_32370;
(statearr_32384[(10)] = inst_32338__$1);

return statearr_32384;
})();
if(cljs.core.truth_(inst_32341)){
var statearr_32385_32414 = state_32370__$1;
(statearr_32385_32414[(1)] = (8));

} else {
var statearr_32386_32415 = state_32370__$1;
(statearr_32386_32415[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (14))){
var inst_32363 = (state_32370[(2)]);
var inst_32364 = cljs.core.async.close_BANG_.call(null,out);
var state_32370__$1 = (function (){var statearr_32388 = state_32370;
(statearr_32388[(13)] = inst_32363);

return statearr_32388;
})();
var statearr_32389_32416 = state_32370__$1;
(statearr_32389_32416[(2)] = inst_32364);

(statearr_32389_32416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (10))){
var inst_32353 = (state_32370[(2)]);
var state_32370__$1 = state_32370;
var statearr_32390_32417 = state_32370__$1;
(statearr_32390_32417[(2)] = inst_32353);

(statearr_32390_32417[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32371 === (8))){
var inst_32330 = (state_32370[(8)]);
var inst_32334 = (state_32370[(9)]);
var inst_32338 = (state_32370[(10)]);
var inst_32343 = inst_32330.push(inst_32334);
var tmp32387 = inst_32330;
var inst_32330__$1 = tmp32387;
var inst_32331 = inst_32338;
var state_32370__$1 = (function (){var statearr_32391 = state_32370;
(statearr_32391[(7)] = inst_32331);

(statearr_32391[(14)] = inst_32343);

(statearr_32391[(8)] = inst_32330__$1);

return statearr_32391;
})();
var statearr_32392_32418 = state_32370__$1;
(statearr_32392_32418[(2)] = null);

(statearr_32392_32418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29579__auto___32404,out))
;
return ((function (switch__29465__auto__,c__29579__auto___32404,out){
return (function() {
var cljs$core$async$state_machine__29466__auto__ = null;
var cljs$core$async$state_machine__29466__auto____0 = (function (){
var statearr_32396 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32396[(0)] = cljs$core$async$state_machine__29466__auto__);

(statearr_32396[(1)] = (1));

return statearr_32396;
});
var cljs$core$async$state_machine__29466__auto____1 = (function (state_32370){
while(true){
var ret_value__29467__auto__ = (function (){try{while(true){
var result__29468__auto__ = switch__29465__auto__.call(null,state_32370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29468__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29468__auto__;
}
break;
}
}catch (e32397){if((e32397 instanceof Object)){
var ex__29469__auto__ = e32397;
var statearr_32398_32419 = state_32370;
(statearr_32398_32419[(5)] = ex__29469__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32370);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32397;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29467__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32420 = state_32370;
state_32370 = G__32420;
continue;
} else {
return ret_value__29467__auto__;
}
break;
}
});
cljs$core$async$state_machine__29466__auto__ = function(state_32370){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29466__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29466__auto____1.call(this,state_32370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29466__auto____0;
cljs$core$async$state_machine__29466__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29466__auto____1;
return cljs$core$async$state_machine__29466__auto__;
})()
;})(switch__29465__auto__,c__29579__auto___32404,out))
})();
var state__29581__auto__ = (function (){var statearr_32399 = f__29580__auto__.call(null);
(statearr_32399[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29579__auto___32404);

return statearr_32399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29581__auto__);
});})(c__29579__auto___32404,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map