// Compiled by ClojureScript 1.9.671 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return !((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__31578 = url;
var G__31578__$1 = (cljs.core.truth_(imcljs.internal.utils.missing_http_QMARK__.call(null,url))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1("http://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31578)].join(''):G__31578);
if(cljs.core.truth_(imcljs.internal.utils.missing_service_QMARK__.call(null,url))){
return imcljs.internal.utils.append_.call(null,"/service",G__31578__$1);
} else {
return G__31578__$1;
}
});
imcljs.internal.utils.copy_list_query = (function imcljs$internal$utils$copy_list_query(p__31579){
var map__31580 = p__31579;
var map__31580__$1 = ((((!((map__31580 == null)))?((((map__31580.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31580.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31580):map__31580);
var old_list_details = map__31580__$1;
var old_list_name = cljs.core.get.call(null,map__31580__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var old_list_type = cljs.core.get.call(null,map__31580__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),old_list_type,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(old_list_type),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".id")].join('')], null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),old_list_type,new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"value","value",305978217),old_list_name], null)], null)], null);
});
/**
 * Given a collection of channels, returns a collection containing
 *   the first result of each channel (similiar to JS Promise.all)
 */
imcljs.internal.utils._LT__LT__BANG_ = (function imcljs$internal$utils$_LT__LT__BANG_(chans){
var c__31519__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31519__auto__){
return (function (){
var f__31520__auto__ = (function (){var switch__31496__auto__ = ((function (c__31519__auto__){
return (function (state_31600){
var state_val_31601 = (state_31600[(1)]);
if((state_val_31601 === (1))){
var inst_31582 = cljs.core.List.EMPTY;
var inst_31583 = inst_31582;
var inst_31584 = chans;
var state_31600__$1 = (function (){var statearr_31602 = state_31600;
(statearr_31602[(7)] = inst_31584);

(statearr_31602[(8)] = inst_31583);

return statearr_31602;
})();
var statearr_31603_31614 = state_31600__$1;
(statearr_31603_31614[(2)] = null);

(statearr_31603_31614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (2))){
var inst_31584 = (state_31600[(7)]);
var inst_31586 = cljs.core.seq.call(null,inst_31584);
var state_31600__$1 = state_31600;
if(inst_31586){
var statearr_31604_31615 = state_31600__$1;
(statearr_31604_31615[(1)] = (4));

} else {
var statearr_31605_31616 = state_31600__$1;
(statearr_31605_31616[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (3))){
var inst_31598 = (state_31600[(2)]);
var state_31600__$1 = state_31600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31600__$1,inst_31598);
} else {
if((state_val_31601 === (4))){
var inst_31584 = (state_31600[(7)]);
var inst_31588 = cljs.core.first.call(null,inst_31584);
var state_31600__$1 = state_31600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31600__$1,(7),inst_31588);
} else {
if((state_val_31601 === (5))){
var inst_31583 = (state_31600[(8)]);
var state_31600__$1 = state_31600;
var statearr_31606_31617 = state_31600__$1;
(statearr_31606_31617[(2)] = inst_31583);

(statearr_31606_31617[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (6))){
var inst_31596 = (state_31600[(2)]);
var state_31600__$1 = state_31600;
var statearr_31607_31618 = state_31600__$1;
(statearr_31607_31618[(2)] = inst_31596);

(statearr_31607_31618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (7))){
var inst_31584 = (state_31600[(7)]);
var inst_31583 = (state_31600[(8)]);
var inst_31590 = (state_31600[(2)]);
var inst_31591 = cljs.core.conj.call(null,inst_31583,inst_31590);
var inst_31592 = cljs.core.rest.call(null,inst_31584);
var inst_31583__$1 = inst_31591;
var inst_31584__$1 = inst_31592;
var state_31600__$1 = (function (){var statearr_31608 = state_31600;
(statearr_31608[(7)] = inst_31584__$1);

(statearr_31608[(8)] = inst_31583__$1);

return statearr_31608;
})();
var statearr_31609_31619 = state_31600__$1;
(statearr_31609_31619[(2)] = null);

(statearr_31609_31619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__31519__auto__))
;
return ((function (switch__31496__auto__,c__31519__auto__){
return (function() {
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto__ = null;
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto____0 = (function (){
var statearr_31610 = [null,null,null,null,null,null,null,null,null];
(statearr_31610[(0)] = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto__);

(statearr_31610[(1)] = (1));

return statearr_31610;
});
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto____1 = (function (state_31600){
while(true){
var ret_value__31498__auto__ = (function (){try{while(true){
var result__31499__auto__ = switch__31496__auto__.call(null,state_31600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31499__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31499__auto__;
}
break;
}
}catch (e31611){if((e31611 instanceof Object)){
var ex__31500__auto__ = e31611;
var statearr_31612_31620 = state_31600;
(statearr_31612_31620[(5)] = ex__31500__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31600);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31611;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31498__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31621 = state_31600;
state_31600 = G__31621;
continue;
} else {
return ret_value__31498__auto__;
}
break;
}
});
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto__ = function(state_31600){
switch(arguments.length){
case 0:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto____0.call(this);
case 1:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto____1.call(this,state_31600);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto____0;
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto____1;
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__31497__auto__;
})()
;})(switch__31496__auto__,c__31519__auto__))
})();
var state__31521__auto__ = (function (){var statearr_31613 = f__31520__auto__.call(null);
(statearr_31613[(6)] = c__31519__auto__);

return statearr_31613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31521__auto__);
});})(c__31519__auto__))
);

return c__31519__auto__;
});

//# sourceMappingURL=utils.js.map