// Compiled by ClojureScript 1.9.293 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__28564_28568 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__28565_28569 = null;
var count__28566_28570 = (0);
var i__28567_28571 = (0);
while(true){
if((i__28567_28571 < count__28566_28570)){
var k_28572 = cljs.core._nth.call(null,chunk__28565_28569,i__28567_28571);
var v_28573 = (b[k_28572]);
(a[k_28572] = v_28573);

var G__28574 = seq__28564_28568;
var G__28575 = chunk__28565_28569;
var G__28576 = count__28566_28570;
var G__28577 = (i__28567_28571 + (1));
seq__28564_28568 = G__28574;
chunk__28565_28569 = G__28575;
count__28566_28570 = G__28576;
i__28567_28571 = G__28577;
continue;
} else {
var temp__6747__auto___28578 = cljs.core.seq.call(null,seq__28564_28568);
if(temp__6747__auto___28578){
var seq__28564_28579__$1 = temp__6747__auto___28578;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28564_28579__$1)){
var c__27938__auto___28580 = cljs.core.chunk_first.call(null,seq__28564_28579__$1);
var G__28581 = cljs.core.chunk_rest.call(null,seq__28564_28579__$1);
var G__28582 = c__27938__auto___28580;
var G__28583 = cljs.core.count.call(null,c__27938__auto___28580);
var G__28584 = (0);
seq__28564_28568 = G__28581;
chunk__28565_28569 = G__28582;
count__28566_28570 = G__28583;
i__28567_28571 = G__28584;
continue;
} else {
var k_28585 = cljs.core.first.call(null,seq__28564_28579__$1);
var v_28586 = (b[k_28585]);
(a[k_28585] = v_28586);

var G__28587 = cljs.core.next.call(null,seq__28564_28579__$1);
var G__28588 = null;
var G__28589 = (0);
var G__28590 = (0);
seq__28564_28568 = G__28587;
chunk__28565_28569 = G__28588;
count__28566_28570 = G__28589;
i__28567_28571 = G__28590;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args28591 = [];
var len__28248__auto___28594 = arguments.length;
var i__28249__auto___28595 = (0);
while(true){
if((i__28249__auto___28595 < len__28248__auto___28594)){
args28591.push((arguments[i__28249__auto___28595]));

var G__28596 = (i__28249__auto___28595 + (1));
i__28249__auto___28595 = G__28596;
continue;
} else {
}
break;
}

var G__28593 = args28591.length;
switch (G__28593) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28591.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__28598 = (i + (2));
var G__28599 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__28598;
ret = G__28599;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;

/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__28600_28604 = cljs.core.seq.call(null,v);
var chunk__28601_28605 = null;
var count__28602_28606 = (0);
var i__28603_28607 = (0);
while(true){
if((i__28603_28607 < count__28602_28606)){
var x_28608 = cljs.core._nth.call(null,chunk__28601_28605,i__28603_28607);
ret.push(x_28608);

var G__28609 = seq__28600_28604;
var G__28610 = chunk__28601_28605;
var G__28611 = count__28602_28606;
var G__28612 = (i__28603_28607 + (1));
seq__28600_28604 = G__28609;
chunk__28601_28605 = G__28610;
count__28602_28606 = G__28611;
i__28603_28607 = G__28612;
continue;
} else {
var temp__6747__auto___28613 = cljs.core.seq.call(null,seq__28600_28604);
if(temp__6747__auto___28613){
var seq__28600_28614__$1 = temp__6747__auto___28613;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28600_28614__$1)){
var c__27938__auto___28615 = cljs.core.chunk_first.call(null,seq__28600_28614__$1);
var G__28616 = cljs.core.chunk_rest.call(null,seq__28600_28614__$1);
var G__28617 = c__27938__auto___28615;
var G__28618 = cljs.core.count.call(null,c__27938__auto___28615);
var G__28619 = (0);
seq__28600_28604 = G__28616;
chunk__28601_28605 = G__28617;
count__28602_28606 = G__28618;
i__28603_28607 = G__28619;
continue;
} else {
var x_28620 = cljs.core.first.call(null,seq__28600_28614__$1);
ret.push(x_28620);

var G__28621 = cljs.core.next.call(null,seq__28600_28614__$1);
var G__28622 = null;
var G__28623 = (0);
var G__28624 = (0);
seq__28600_28604 = G__28621;
chunk__28601_28605 = G__28622;
count__28602_28606 = G__28623;
i__28603_28607 = G__28624;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__28625_28629 = cljs.core.seq.call(null,v);
var chunk__28626_28630 = null;
var count__28627_28631 = (0);
var i__28628_28632 = (0);
while(true){
if((i__28628_28632 < count__28627_28631)){
var x_28633 = cljs.core._nth.call(null,chunk__28626_28630,i__28628_28632);
ret.push(x_28633);

var G__28634 = seq__28625_28629;
var G__28635 = chunk__28626_28630;
var G__28636 = count__28627_28631;
var G__28637 = (i__28628_28632 + (1));
seq__28625_28629 = G__28634;
chunk__28626_28630 = G__28635;
count__28627_28631 = G__28636;
i__28628_28632 = G__28637;
continue;
} else {
var temp__6747__auto___28638 = cljs.core.seq.call(null,seq__28625_28629);
if(temp__6747__auto___28638){
var seq__28625_28639__$1 = temp__6747__auto___28638;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28625_28639__$1)){
var c__27938__auto___28640 = cljs.core.chunk_first.call(null,seq__28625_28639__$1);
var G__28641 = cljs.core.chunk_rest.call(null,seq__28625_28639__$1);
var G__28642 = c__27938__auto___28640;
var G__28643 = cljs.core.count.call(null,c__27938__auto___28640);
var G__28644 = (0);
seq__28625_28629 = G__28641;
chunk__28626_28630 = G__28642;
count__28627_28631 = G__28643;
i__28628_28632 = G__28644;
continue;
} else {
var x_28645 = cljs.core.first.call(null,seq__28625_28639__$1);
ret.push(x_28645);

var G__28646 = cljs.core.next.call(null,seq__28625_28639__$1);
var G__28647 = null;
var G__28648 = (0);
var G__28649 = (0);
seq__28625_28629 = G__28646;
chunk__28626_28630 = G__28647;
count__28627_28631 = G__28648;
i__28628_28632 = G__28649;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__28650_28654 = cljs.core.seq.call(null,v);
var chunk__28651_28655 = null;
var count__28652_28656 = (0);
var i__28653_28657 = (0);
while(true){
if((i__28653_28657 < count__28652_28656)){
var x_28658 = cljs.core._nth.call(null,chunk__28651_28655,i__28653_28657);
ret.push(x_28658);

var G__28659 = seq__28650_28654;
var G__28660 = chunk__28651_28655;
var G__28661 = count__28652_28656;
var G__28662 = (i__28653_28657 + (1));
seq__28650_28654 = G__28659;
chunk__28651_28655 = G__28660;
count__28652_28656 = G__28661;
i__28653_28657 = G__28662;
continue;
} else {
var temp__6747__auto___28663 = cljs.core.seq.call(null,seq__28650_28654);
if(temp__6747__auto___28663){
var seq__28650_28664__$1 = temp__6747__auto___28663;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28650_28664__$1)){
var c__27938__auto___28665 = cljs.core.chunk_first.call(null,seq__28650_28664__$1);
var G__28666 = cljs.core.chunk_rest.call(null,seq__28650_28664__$1);
var G__28667 = c__27938__auto___28665;
var G__28668 = cljs.core.count.call(null,c__27938__auto___28665);
var G__28669 = (0);
seq__28650_28654 = G__28666;
chunk__28651_28655 = G__28667;
count__28652_28656 = G__28668;
i__28653_28657 = G__28669;
continue;
} else {
var x_28670 = cljs.core.first.call(null,seq__28650_28664__$1);
ret.push(x_28670);

var G__28671 = cljs.core.next.call(null,seq__28650_28664__$1);
var G__28672 = null;
var G__28673 = (0);
var G__28674 = (0);
seq__28650_28654 = G__28671;
chunk__28651_28655 = G__28672;
count__28652_28656 = G__28673;
i__28653_28657 = G__28674;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args28675 = [];
var len__28248__auto___28690 = arguments.length;
var i__28249__auto___28691 = (0);
while(true){
if((i__28249__auto___28691 < len__28248__auto___28690)){
args28675.push((arguments[i__28249__auto___28691]));

var G__28692 = (i__28249__auto___28691 + (1));
i__28249__auto___28691 = G__28692;
continue;
} else {
}
break;
}

var G__28677 = args28675.length;
switch (G__28677) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28675.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__28678 = obj;
G__28678.push(kfn.call(null,k),vfn.call(null,v));

return G__28678;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x28679 = cljs.core.clone.call(null,handlers);
x28679.forEach = ((function (x28679,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__28680 = cljs.core.seq.call(null,coll);
var chunk__28681 = null;
var count__28682 = (0);
var i__28683 = (0);
while(true){
if((i__28683 < count__28682)){
var vec__28684 = cljs.core._nth.call(null,chunk__28681,i__28683);
var k = cljs.core.nth.call(null,vec__28684,(0),null);
var v = cljs.core.nth.call(null,vec__28684,(1),null);
f.call(null,v,k);

var G__28694 = seq__28680;
var G__28695 = chunk__28681;
var G__28696 = count__28682;
var G__28697 = (i__28683 + (1));
seq__28680 = G__28694;
chunk__28681 = G__28695;
count__28682 = G__28696;
i__28683 = G__28697;
continue;
} else {
var temp__6747__auto__ = cljs.core.seq.call(null,seq__28680);
if(temp__6747__auto__){
var seq__28680__$1 = temp__6747__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28680__$1)){
var c__27938__auto__ = cljs.core.chunk_first.call(null,seq__28680__$1);
var G__28698 = cljs.core.chunk_rest.call(null,seq__28680__$1);
var G__28699 = c__27938__auto__;
var G__28700 = cljs.core.count.call(null,c__27938__auto__);
var G__28701 = (0);
seq__28680 = G__28698;
chunk__28681 = G__28699;
count__28682 = G__28700;
i__28683 = G__28701;
continue;
} else {
var vec__28687 = cljs.core.first.call(null,seq__28680__$1);
var k = cljs.core.nth.call(null,vec__28687,(0),null);
var v = cljs.core.nth.call(null,vec__28687,(1),null);
f.call(null,v,k);

var G__28702 = cljs.core.next.call(null,seq__28680__$1);
var G__28703 = null;
var G__28704 = (0);
var G__28705 = (0);
seq__28680 = G__28702;
chunk__28681 = G__28703;
count__28682 = G__28704;
i__28683 = G__28705;
continue;
}
} else {
return null;
}
}
break;
}
});})(x28679,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x28679;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;

/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args28706 = [];
var len__28248__auto___28712 = arguments.length;
var i__28249__auto___28713 = (0);
while(true){
if((i__28249__auto___28713 < len__28248__auto___28712)){
args28706.push((arguments[i__28249__auto___28713]));

var G__28714 = (i__28249__auto___28713 + (1));
i__28249__auto___28713 = G__28714;
continue;
} else {
}
break;
}

var G__28708 = args28706.length;
switch (G__28708) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28706.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit28709 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit28709 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta28710){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta28710 = meta28710;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit28709.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28711,meta28710__$1){
var self__ = this;
var _28711__$1 = this;
return (new cognitect.transit.t_cognitect$transit28709(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta28710__$1));
});

cognitect.transit.t_cognitect$transit28709.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28711){
var self__ = this;
var _28711__$1 = this;
return self__.meta28710;
});

cognitect.transit.t_cognitect$transit28709.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit28709.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit28709.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit28709.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit28709.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta28710","meta28710",-2019777593,null)], null);
});

cognitect.transit.t_cognitect$transit28709.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit28709.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit28709";

cognitect.transit.t_cognitect$transit28709.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cognitect.transit/t_cognitect$transit28709");
});

cognitect.transit.__GT_t_cognitect$transit28709 = (function cognitect$transit$__GT_t_cognitect$transit28709(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta28710){
return (new cognitect.transit.t_cognitect$transit28709(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta28710));
});

}

return (new cognitect.transit.t_cognitect$transit28709(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;

/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__27032__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map