// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args30205 = [];
var len__28248__auto___30211 = arguments.length;
var i__28249__auto___30212 = (0);
while(true){
if((i__28249__auto___30212 < len__28248__auto___30211)){
args30205.push((arguments[i__28249__auto___30212]));

var G__30213 = (i__28249__auto___30212 + (1));
i__28249__auto___30212 = G__30213;
continue;
} else {
}
break;
}

var G__30207 = args30205.length;
switch (G__30207) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30205.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30208 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30208 = (function (f,blockable,meta30209){
this.f = f;
this.blockable = blockable;
this.meta30209 = meta30209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30210,meta30209__$1){
var self__ = this;
var _30210__$1 = this;
return (new cljs.core.async.t_cljs$core$async30208(self__.f,self__.blockable,meta30209__$1));
});

cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30210){
var self__ = this;
var _30210__$1 = this;
return self__.meta30209;
});

cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30209","meta30209",928436287,null)], null);
});

cljs.core.async.t_cljs$core$async30208.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30208.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30208";

cljs.core.async.t_cljs$core$async30208.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async30208");
});

cljs.core.async.__GT_t_cljs$core$async30208 = (function cljs$core$async$__GT_t_cljs$core$async30208(f__$1,blockable__$1,meta30209){
return (new cljs.core.async.t_cljs$core$async30208(f__$1,blockable__$1,meta30209));
});

}

return (new cljs.core.async.t_cljs$core$async30208(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args30217 = [];
var len__28248__auto___30220 = arguments.length;
var i__28249__auto___30221 = (0);
while(true){
if((i__28249__auto___30221 < len__28248__auto___30220)){
args30217.push((arguments[i__28249__auto___30221]));

var G__30222 = (i__28249__auto___30221 + (1));
i__28249__auto___30221 = G__30222;
continue;
} else {
}
break;
}

var G__30219 = args30217.length;
switch (G__30219) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30217.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args30224 = [];
var len__28248__auto___30227 = arguments.length;
var i__28249__auto___30228 = (0);
while(true){
if((i__28249__auto___30228 < len__28248__auto___30227)){
args30224.push((arguments[i__28249__auto___30228]));

var G__30229 = (i__28249__auto___30228 + (1));
i__28249__auto___30228 = G__30229;
continue;
} else {
}
break;
}

var G__30226 = args30224.length;
switch (G__30226) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30224.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args30231 = [];
var len__28248__auto___30234 = arguments.length;
var i__28249__auto___30235 = (0);
while(true){
if((i__28249__auto___30235 < len__28248__auto___30234)){
args30231.push((arguments[i__28249__auto___30235]));

var G__30236 = (i__28249__auto___30235 + (1));
i__28249__auto___30235 = G__30236;
continue;
} else {
}
break;
}

var G__30233 = args30231.length;
switch (G__30233) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30231.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_30238 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_30238);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_30238,ret){
return (function (){
return fn1.call(null,val_30238);
});})(val_30238,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args30239 = [];
var len__28248__auto___30242 = arguments.length;
var i__28249__auto___30243 = (0);
while(true){
if((i__28249__auto___30243 < len__28248__auto___30242)){
args30239.push((arguments[i__28249__auto___30243]));

var G__30244 = (i__28249__auto___30243 + (1));
i__28249__auto___30243 = G__30244;
continue;
} else {
}
break;
}

var G__30241 = args30239.length;
switch (G__30241) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30239.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6745__auto__)){
var ret = temp__6745__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6745__auto__)){
var retb = temp__6745__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6745__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6745__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28048__auto___30246 = n;
var x_30247 = (0);
while(true){
if((x_30247 < n__28048__auto___30246)){
(a[x_30247] = (0));

var G__30248 = (x_30247 + (1));
x_30247 = G__30248;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__30249 = (i + (1));
i = G__30249;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async30253 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30253 = (function (flag,meta30254){
this.flag = flag;
this.meta30254 = meta30254;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30253.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_30255,meta30254__$1){
var self__ = this;
var _30255__$1 = this;
return (new cljs.core.async.t_cljs$core$async30253(self__.flag,meta30254__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async30253.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_30255){
var self__ = this;
var _30255__$1 = this;
return self__.meta30254;
});})(flag))
;

cljs.core.async.t_cljs$core$async30253.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30253.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async30253.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30253.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30253.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30254","meta30254",881504943,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async30253.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30253.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30253";

cljs.core.async.t_cljs$core$async30253.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async30253");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async30253 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30253(flag__$1,meta30254){
return (new cljs.core.async.t_cljs$core$async30253(flag__$1,meta30254));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async30253(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async30259 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30259 = (function (flag,cb,meta30260){
this.flag = flag;
this.cb = cb;
this.meta30260 = meta30260;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30259.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30261,meta30260__$1){
var self__ = this;
var _30261__$1 = this;
return (new cljs.core.async.t_cljs$core$async30259(self__.flag,self__.cb,meta30260__$1));
});

cljs.core.async.t_cljs$core$async30259.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30261){
var self__ = this;
var _30261__$1 = this;
return self__.meta30260;
});

cljs.core.async.t_cljs$core$async30259.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30259.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async30259.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30259.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async30259.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30260","meta30260",-1099601706,null)], null);
});

cljs.core.async.t_cljs$core$async30259.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30259.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30259";

cljs.core.async.t_cljs$core$async30259.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async30259");
});

cljs.core.async.__GT_t_cljs$core$async30259 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30259(flag__$1,cb__$1,meta30260){
return (new cljs.core.async.t_cljs$core$async30259(flag__$1,cb__$1,meta30260));
});

}

return (new cljs.core.async.t_cljs$core$async30259(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30262_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30262_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30263_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30263_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27032__auto__ = wport;
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30264 = (i + (1));
i = G__30264;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27032__auto__ = ret;
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6747__auto__ = (function (){var and__27020__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27020__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27020__auto__;
}
})();
if(cljs.core.truth_(temp__6747__auto__)){
var got = temp__6747__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28255__auto__ = [];
var len__28248__auto___30270 = arguments.length;
var i__28249__auto___30271 = (0);
while(true){
if((i__28249__auto___30271 < len__28248__auto___30270)){
args__28255__auto__.push((arguments[i__28249__auto___30271]));

var G__30272 = (i__28249__auto___30271 + (1));
i__28249__auto___30271 = G__30272;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((1) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28256__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30267){
var map__30268 = p__30267;
var map__30268__$1 = ((((!((map__30268 == null)))?((((map__30268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30268.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30268):map__30268);
var opts = map__30268__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30265){
var G__30266 = cljs.core.first.call(null,seq30265);
var seq30265__$1 = cljs.core.next.call(null,seq30265);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30266,seq30265__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args30273 = [];
var len__28248__auto___30323 = arguments.length;
var i__28249__auto___30324 = (0);
while(true){
if((i__28249__auto___30324 < len__28248__auto___30323)){
args30273.push((arguments[i__28249__auto___30324]));

var G__30325 = (i__28249__auto___30324 + (1));
i__28249__auto___30324 = G__30325;
continue;
} else {
}
break;
}

var G__30275 = args30273.length;
switch (G__30275) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30273.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30146__auto___30327 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___30327){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___30327){
return (function (state_30299){
var state_val_30300 = (state_30299[(1)]);
if((state_val_30300 === (7))){
var inst_30295 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30301_30328 = state_30299__$1;
(statearr_30301_30328[(2)] = inst_30295);

(statearr_30301_30328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (1))){
var state_30299__$1 = state_30299;
var statearr_30302_30329 = state_30299__$1;
(statearr_30302_30329[(2)] = null);

(statearr_30302_30329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (4))){
var inst_30278 = (state_30299[(7)]);
var inst_30278__$1 = (state_30299[(2)]);
var inst_30279 = (inst_30278__$1 == null);
var state_30299__$1 = (function (){var statearr_30303 = state_30299;
(statearr_30303[(7)] = inst_30278__$1);

return statearr_30303;
})();
if(cljs.core.truth_(inst_30279)){
var statearr_30304_30330 = state_30299__$1;
(statearr_30304_30330[(1)] = (5));

} else {
var statearr_30305_30331 = state_30299__$1;
(statearr_30305_30331[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (13))){
var state_30299__$1 = state_30299;
var statearr_30306_30332 = state_30299__$1;
(statearr_30306_30332[(2)] = null);

(statearr_30306_30332[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (6))){
var inst_30278 = (state_30299[(7)]);
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30299__$1,(11),to,inst_30278);
} else {
if((state_val_30300 === (3))){
var inst_30297 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30299__$1,inst_30297);
} else {
if((state_val_30300 === (12))){
var state_30299__$1 = state_30299;
var statearr_30307_30333 = state_30299__$1;
(statearr_30307_30333[(2)] = null);

(statearr_30307_30333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (2))){
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30299__$1,(4),from);
} else {
if((state_val_30300 === (11))){
var inst_30288 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
if(cljs.core.truth_(inst_30288)){
var statearr_30308_30334 = state_30299__$1;
(statearr_30308_30334[(1)] = (12));

} else {
var statearr_30309_30335 = state_30299__$1;
(statearr_30309_30335[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (9))){
var state_30299__$1 = state_30299;
var statearr_30310_30336 = state_30299__$1;
(statearr_30310_30336[(2)] = null);

(statearr_30310_30336[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (5))){
var state_30299__$1 = state_30299;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30311_30337 = state_30299__$1;
(statearr_30311_30337[(1)] = (8));

} else {
var statearr_30312_30338 = state_30299__$1;
(statearr_30312_30338[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (14))){
var inst_30293 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30313_30339 = state_30299__$1;
(statearr_30313_30339[(2)] = inst_30293);

(statearr_30313_30339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (10))){
var inst_30285 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30314_30340 = state_30299__$1;
(statearr_30314_30340[(2)] = inst_30285);

(statearr_30314_30340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (8))){
var inst_30282 = cljs.core.async.close_BANG_.call(null,to);
var state_30299__$1 = state_30299;
var statearr_30315_30341 = state_30299__$1;
(statearr_30315_30341[(2)] = inst_30282);

(statearr_30315_30341[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___30327))
;
return ((function (switch__30032__auto__,c__30146__auto___30327){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_30319 = [null,null,null,null,null,null,null,null];
(statearr_30319[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_30319[(1)] = (1));

return statearr_30319;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_30299){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30320){if((e30320 instanceof Object)){
var ex__30036__auto__ = e30320;
var statearr_30321_30342 = state_30299;
(statearr_30321_30342[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30299);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30320;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30343 = state_30299;
state_30299 = G__30343;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_30299){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_30299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___30327))
})();
var state__30148__auto__ = (function (){var statearr_30322 = f__30147__auto__.call(null);
(statearr_30322[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___30327);

return statearr_30322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___30327))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__30531){
var vec__30532 = p__30531;
var v = cljs.core.nth.call(null,vec__30532,(0),null);
var p = cljs.core.nth.call(null,vec__30532,(1),null);
var job = vec__30532;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30146__auto___30718 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___30718,res,vec__30532,v,p,job,jobs,results){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___30718,res,vec__30532,v,p,job,jobs,results){
return (function (state_30539){
var state_val_30540 = (state_30539[(1)]);
if((state_val_30540 === (1))){
var state_30539__$1 = state_30539;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30539__$1,(2),res,v);
} else {
if((state_val_30540 === (2))){
var inst_30536 = (state_30539[(2)]);
var inst_30537 = cljs.core.async.close_BANG_.call(null,res);
var state_30539__$1 = (function (){var statearr_30541 = state_30539;
(statearr_30541[(7)] = inst_30536);

return statearr_30541;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30539__$1,inst_30537);
} else {
return null;
}
}
});})(c__30146__auto___30718,res,vec__30532,v,p,job,jobs,results))
;
return ((function (switch__30032__auto__,c__30146__auto___30718,res,vec__30532,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0 = (function (){
var statearr_30545 = [null,null,null,null,null,null,null,null];
(statearr_30545[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__);

(statearr_30545[(1)] = (1));

return statearr_30545;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1 = (function (state_30539){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30546){if((e30546 instanceof Object)){
var ex__30036__auto__ = e30546;
var statearr_30547_30719 = state_30539;
(statearr_30547_30719[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30539);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30546;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30720 = state_30539;
state_30539 = G__30720;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = function(state_30539){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1.call(this,state_30539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___30718,res,vec__30532,v,p,job,jobs,results))
})();
var state__30148__auto__ = (function (){var statearr_30548 = f__30147__auto__.call(null);
(statearr_30548[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___30718);

return statearr_30548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___30718,res,vec__30532,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__30549){
var vec__30550 = p__30549;
var v = cljs.core.nth.call(null,vec__30550,(0),null);
var p = cljs.core.nth.call(null,vec__30550,(1),null);
var job = vec__30550;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28048__auto___30721 = n;
var __30722 = (0);
while(true){
if((__30722 < n__28048__auto___30721)){
var G__30553_30723 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__30553_30723) {
case "compute":
var c__30146__auto___30725 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30722,c__30146__auto___30725,G__30553_30723,n__28048__auto___30721,jobs,results,process,async){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (__30722,c__30146__auto___30725,G__30553_30723,n__28048__auto___30721,jobs,results,process,async){
return (function (state_30566){
var state_val_30567 = (state_30566[(1)]);
if((state_val_30567 === (1))){
var state_30566__$1 = state_30566;
var statearr_30568_30726 = state_30566__$1;
(statearr_30568_30726[(2)] = null);

(statearr_30568_30726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (2))){
var state_30566__$1 = state_30566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30566__$1,(4),jobs);
} else {
if((state_val_30567 === (3))){
var inst_30564 = (state_30566[(2)]);
var state_30566__$1 = state_30566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30566__$1,inst_30564);
} else {
if((state_val_30567 === (4))){
var inst_30556 = (state_30566[(2)]);
var inst_30557 = process.call(null,inst_30556);
var state_30566__$1 = state_30566;
if(cljs.core.truth_(inst_30557)){
var statearr_30569_30727 = state_30566__$1;
(statearr_30569_30727[(1)] = (5));

} else {
var statearr_30570_30728 = state_30566__$1;
(statearr_30570_30728[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (5))){
var state_30566__$1 = state_30566;
var statearr_30571_30729 = state_30566__$1;
(statearr_30571_30729[(2)] = null);

(statearr_30571_30729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (6))){
var state_30566__$1 = state_30566;
var statearr_30572_30730 = state_30566__$1;
(statearr_30572_30730[(2)] = null);

(statearr_30572_30730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30567 === (7))){
var inst_30562 = (state_30566[(2)]);
var state_30566__$1 = state_30566;
var statearr_30573_30731 = state_30566__$1;
(statearr_30573_30731[(2)] = inst_30562);

(statearr_30573_30731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30722,c__30146__auto___30725,G__30553_30723,n__28048__auto___30721,jobs,results,process,async))
;
return ((function (__30722,switch__30032__auto__,c__30146__auto___30725,G__30553_30723,n__28048__auto___30721,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0 = (function (){
var statearr_30577 = [null,null,null,null,null,null,null];
(statearr_30577[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__);

(statearr_30577[(1)] = (1));

return statearr_30577;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1 = (function (state_30566){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30578){if((e30578 instanceof Object)){
var ex__30036__auto__ = e30578;
var statearr_30579_30732 = state_30566;
(statearr_30579_30732[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30566);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30578;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30733 = state_30566;
state_30566 = G__30733;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = function(state_30566){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1.call(this,state_30566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__;
})()
;})(__30722,switch__30032__auto__,c__30146__auto___30725,G__30553_30723,n__28048__auto___30721,jobs,results,process,async))
})();
var state__30148__auto__ = (function (){var statearr_30580 = f__30147__auto__.call(null);
(statearr_30580[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___30725);

return statearr_30580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(__30722,c__30146__auto___30725,G__30553_30723,n__28048__auto___30721,jobs,results,process,async))
);


break;
case "async":
var c__30146__auto___30734 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30722,c__30146__auto___30734,G__30553_30723,n__28048__auto___30721,jobs,results,process,async){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (__30722,c__30146__auto___30734,G__30553_30723,n__28048__auto___30721,jobs,results,process,async){
return (function (state_30593){
var state_val_30594 = (state_30593[(1)]);
if((state_val_30594 === (1))){
var state_30593__$1 = state_30593;
var statearr_30595_30735 = state_30593__$1;
(statearr_30595_30735[(2)] = null);

(statearr_30595_30735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30594 === (2))){
var state_30593__$1 = state_30593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30593__$1,(4),jobs);
} else {
if((state_val_30594 === (3))){
var inst_30591 = (state_30593[(2)]);
var state_30593__$1 = state_30593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30593__$1,inst_30591);
} else {
if((state_val_30594 === (4))){
var inst_30583 = (state_30593[(2)]);
var inst_30584 = async.call(null,inst_30583);
var state_30593__$1 = state_30593;
if(cljs.core.truth_(inst_30584)){
var statearr_30596_30736 = state_30593__$1;
(statearr_30596_30736[(1)] = (5));

} else {
var statearr_30597_30737 = state_30593__$1;
(statearr_30597_30737[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30594 === (5))){
var state_30593__$1 = state_30593;
var statearr_30598_30738 = state_30593__$1;
(statearr_30598_30738[(2)] = null);

(statearr_30598_30738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30594 === (6))){
var state_30593__$1 = state_30593;
var statearr_30599_30739 = state_30593__$1;
(statearr_30599_30739[(2)] = null);

(statearr_30599_30739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30594 === (7))){
var inst_30589 = (state_30593[(2)]);
var state_30593__$1 = state_30593;
var statearr_30600_30740 = state_30593__$1;
(statearr_30600_30740[(2)] = inst_30589);

(statearr_30600_30740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30722,c__30146__auto___30734,G__30553_30723,n__28048__auto___30721,jobs,results,process,async))
;
return ((function (__30722,switch__30032__auto__,c__30146__auto___30734,G__30553_30723,n__28048__auto___30721,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0 = (function (){
var statearr_30604 = [null,null,null,null,null,null,null];
(statearr_30604[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__);

(statearr_30604[(1)] = (1));

return statearr_30604;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1 = (function (state_30593){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30605){if((e30605 instanceof Object)){
var ex__30036__auto__ = e30605;
var statearr_30606_30741 = state_30593;
(statearr_30606_30741[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30593);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30742 = state_30593;
state_30593 = G__30742;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = function(state_30593){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1.call(this,state_30593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__;
})()
;})(__30722,switch__30032__auto__,c__30146__auto___30734,G__30553_30723,n__28048__auto___30721,jobs,results,process,async))
})();
var state__30148__auto__ = (function (){var statearr_30607 = f__30147__auto__.call(null);
(statearr_30607[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___30734);

return statearr_30607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(__30722,c__30146__auto___30734,G__30553_30723,n__28048__auto___30721,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__30743 = (__30722 + (1));
__30722 = G__30743;
continue;
} else {
}
break;
}

var c__30146__auto___30744 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___30744,jobs,results,process,async){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___30744,jobs,results,process,async){
return (function (state_30629){
var state_val_30630 = (state_30629[(1)]);
if((state_val_30630 === (1))){
var state_30629__$1 = state_30629;
var statearr_30631_30745 = state_30629__$1;
(statearr_30631_30745[(2)] = null);

(statearr_30631_30745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30630 === (2))){
var state_30629__$1 = state_30629;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30629__$1,(4),from);
} else {
if((state_val_30630 === (3))){
var inst_30627 = (state_30629[(2)]);
var state_30629__$1 = state_30629;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30629__$1,inst_30627);
} else {
if((state_val_30630 === (4))){
var inst_30610 = (state_30629[(7)]);
var inst_30610__$1 = (state_30629[(2)]);
var inst_30611 = (inst_30610__$1 == null);
var state_30629__$1 = (function (){var statearr_30632 = state_30629;
(statearr_30632[(7)] = inst_30610__$1);

return statearr_30632;
})();
if(cljs.core.truth_(inst_30611)){
var statearr_30633_30746 = state_30629__$1;
(statearr_30633_30746[(1)] = (5));

} else {
var statearr_30634_30747 = state_30629__$1;
(statearr_30634_30747[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30630 === (5))){
var inst_30613 = cljs.core.async.close_BANG_.call(null,jobs);
var state_30629__$1 = state_30629;
var statearr_30635_30748 = state_30629__$1;
(statearr_30635_30748[(2)] = inst_30613);

(statearr_30635_30748[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30630 === (6))){
var inst_30615 = (state_30629[(8)]);
var inst_30610 = (state_30629[(7)]);
var inst_30615__$1 = cljs.core.async.chan.call(null,(1));
var inst_30616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30617 = [inst_30610,inst_30615__$1];
var inst_30618 = (new cljs.core.PersistentVector(null,2,(5),inst_30616,inst_30617,null));
var state_30629__$1 = (function (){var statearr_30636 = state_30629;
(statearr_30636[(8)] = inst_30615__$1);

return statearr_30636;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30629__$1,(8),jobs,inst_30618);
} else {
if((state_val_30630 === (7))){
var inst_30625 = (state_30629[(2)]);
var state_30629__$1 = state_30629;
var statearr_30637_30749 = state_30629__$1;
(statearr_30637_30749[(2)] = inst_30625);

(statearr_30637_30749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30630 === (8))){
var inst_30615 = (state_30629[(8)]);
var inst_30620 = (state_30629[(2)]);
var state_30629__$1 = (function (){var statearr_30638 = state_30629;
(statearr_30638[(9)] = inst_30620);

return statearr_30638;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30629__$1,(9),results,inst_30615);
} else {
if((state_val_30630 === (9))){
var inst_30622 = (state_30629[(2)]);
var state_30629__$1 = (function (){var statearr_30639 = state_30629;
(statearr_30639[(10)] = inst_30622);

return statearr_30639;
})();
var statearr_30640_30750 = state_30629__$1;
(statearr_30640_30750[(2)] = null);

(statearr_30640_30750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___30744,jobs,results,process,async))
;
return ((function (switch__30032__auto__,c__30146__auto___30744,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0 = (function (){
var statearr_30644 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30644[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__);

(statearr_30644[(1)] = (1));

return statearr_30644;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1 = (function (state_30629){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30629);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30645){if((e30645 instanceof Object)){
var ex__30036__auto__ = e30645;
var statearr_30646_30751 = state_30629;
(statearr_30646_30751[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30629);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30645;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30752 = state_30629;
state_30629 = G__30752;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = function(state_30629){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1.call(this,state_30629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___30744,jobs,results,process,async))
})();
var state__30148__auto__ = (function (){var statearr_30647 = f__30147__auto__.call(null);
(statearr_30647[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___30744);

return statearr_30647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___30744,jobs,results,process,async))
);


var c__30146__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto__,jobs,results,process,async){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto__,jobs,results,process,async){
return (function (state_30685){
var state_val_30686 = (state_30685[(1)]);
if((state_val_30686 === (7))){
var inst_30681 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
var statearr_30687_30753 = state_30685__$1;
(statearr_30687_30753[(2)] = inst_30681);

(statearr_30687_30753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (20))){
var state_30685__$1 = state_30685;
var statearr_30688_30754 = state_30685__$1;
(statearr_30688_30754[(2)] = null);

(statearr_30688_30754[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (1))){
var state_30685__$1 = state_30685;
var statearr_30689_30755 = state_30685__$1;
(statearr_30689_30755[(2)] = null);

(statearr_30689_30755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (4))){
var inst_30650 = (state_30685[(7)]);
var inst_30650__$1 = (state_30685[(2)]);
var inst_30651 = (inst_30650__$1 == null);
var state_30685__$1 = (function (){var statearr_30690 = state_30685;
(statearr_30690[(7)] = inst_30650__$1);

return statearr_30690;
})();
if(cljs.core.truth_(inst_30651)){
var statearr_30691_30756 = state_30685__$1;
(statearr_30691_30756[(1)] = (5));

} else {
var statearr_30692_30757 = state_30685__$1;
(statearr_30692_30757[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (15))){
var inst_30663 = (state_30685[(8)]);
var state_30685__$1 = state_30685;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30685__$1,(18),to,inst_30663);
} else {
if((state_val_30686 === (21))){
var inst_30676 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
var statearr_30693_30758 = state_30685__$1;
(statearr_30693_30758[(2)] = inst_30676);

(statearr_30693_30758[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (13))){
var inst_30678 = (state_30685[(2)]);
var state_30685__$1 = (function (){var statearr_30694 = state_30685;
(statearr_30694[(9)] = inst_30678);

return statearr_30694;
})();
var statearr_30695_30759 = state_30685__$1;
(statearr_30695_30759[(2)] = null);

(statearr_30695_30759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (6))){
var inst_30650 = (state_30685[(7)]);
var state_30685__$1 = state_30685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30685__$1,(11),inst_30650);
} else {
if((state_val_30686 === (17))){
var inst_30671 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
if(cljs.core.truth_(inst_30671)){
var statearr_30696_30760 = state_30685__$1;
(statearr_30696_30760[(1)] = (19));

} else {
var statearr_30697_30761 = state_30685__$1;
(statearr_30697_30761[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (3))){
var inst_30683 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30685__$1,inst_30683);
} else {
if((state_val_30686 === (12))){
var inst_30660 = (state_30685[(10)]);
var state_30685__$1 = state_30685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30685__$1,(14),inst_30660);
} else {
if((state_val_30686 === (2))){
var state_30685__$1 = state_30685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30685__$1,(4),results);
} else {
if((state_val_30686 === (19))){
var state_30685__$1 = state_30685;
var statearr_30698_30762 = state_30685__$1;
(statearr_30698_30762[(2)] = null);

(statearr_30698_30762[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (11))){
var inst_30660 = (state_30685[(2)]);
var state_30685__$1 = (function (){var statearr_30699 = state_30685;
(statearr_30699[(10)] = inst_30660);

return statearr_30699;
})();
var statearr_30700_30763 = state_30685__$1;
(statearr_30700_30763[(2)] = null);

(statearr_30700_30763[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (9))){
var state_30685__$1 = state_30685;
var statearr_30701_30764 = state_30685__$1;
(statearr_30701_30764[(2)] = null);

(statearr_30701_30764[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (5))){
var state_30685__$1 = state_30685;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30702_30765 = state_30685__$1;
(statearr_30702_30765[(1)] = (8));

} else {
var statearr_30703_30766 = state_30685__$1;
(statearr_30703_30766[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (14))){
var inst_30663 = (state_30685[(8)]);
var inst_30665 = (state_30685[(11)]);
var inst_30663__$1 = (state_30685[(2)]);
var inst_30664 = (inst_30663__$1 == null);
var inst_30665__$1 = cljs.core.not.call(null,inst_30664);
var state_30685__$1 = (function (){var statearr_30704 = state_30685;
(statearr_30704[(8)] = inst_30663__$1);

(statearr_30704[(11)] = inst_30665__$1);

return statearr_30704;
})();
if(inst_30665__$1){
var statearr_30705_30767 = state_30685__$1;
(statearr_30705_30767[(1)] = (15));

} else {
var statearr_30706_30768 = state_30685__$1;
(statearr_30706_30768[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (16))){
var inst_30665 = (state_30685[(11)]);
var state_30685__$1 = state_30685;
var statearr_30707_30769 = state_30685__$1;
(statearr_30707_30769[(2)] = inst_30665);

(statearr_30707_30769[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (10))){
var inst_30657 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
var statearr_30708_30770 = state_30685__$1;
(statearr_30708_30770[(2)] = inst_30657);

(statearr_30708_30770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (18))){
var inst_30668 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
var statearr_30709_30771 = state_30685__$1;
(statearr_30709_30771[(2)] = inst_30668);

(statearr_30709_30771[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (8))){
var inst_30654 = cljs.core.async.close_BANG_.call(null,to);
var state_30685__$1 = state_30685;
var statearr_30710_30772 = state_30685__$1;
(statearr_30710_30772[(2)] = inst_30654);

(statearr_30710_30772[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto__,jobs,results,process,async))
;
return ((function (switch__30032__auto__,c__30146__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0 = (function (){
var statearr_30714 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30714[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__);

(statearr_30714[(1)] = (1));

return statearr_30714;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1 = (function (state_30685){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30715){if((e30715 instanceof Object)){
var ex__30036__auto__ = e30715;
var statearr_30716_30773 = state_30685;
(statearr_30716_30773[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30715;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30774 = state_30685;
state_30685 = G__30774;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__ = function(state_30685){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1.call(this,state_30685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30033__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto__,jobs,results,process,async))
})();
var state__30148__auto__ = (function (){var statearr_30717 = f__30147__auto__.call(null);
(statearr_30717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto__);

return statearr_30717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto__,jobs,results,process,async))
);

return c__30146__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args30775 = [];
var len__28248__auto___30778 = arguments.length;
var i__28249__auto___30779 = (0);
while(true){
if((i__28249__auto___30779 < len__28248__auto___30778)){
args30775.push((arguments[i__28249__auto___30779]));

var G__30780 = (i__28249__auto___30779 + (1));
i__28249__auto___30779 = G__30780;
continue;
} else {
}
break;
}

var G__30777 = args30775.length;
switch (G__30777) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30775.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args30782 = [];
var len__28248__auto___30785 = arguments.length;
var i__28249__auto___30786 = (0);
while(true){
if((i__28249__auto___30786 < len__28248__auto___30785)){
args30782.push((arguments[i__28249__auto___30786]));

var G__30787 = (i__28249__auto___30786 + (1));
i__28249__auto___30786 = G__30787;
continue;
} else {
}
break;
}

var G__30784 = args30782.length;
switch (G__30784) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30782.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args30789 = [];
var len__28248__auto___30842 = arguments.length;
var i__28249__auto___30843 = (0);
while(true){
if((i__28249__auto___30843 < len__28248__auto___30842)){
args30789.push((arguments[i__28249__auto___30843]));

var G__30844 = (i__28249__auto___30843 + (1));
i__28249__auto___30843 = G__30844;
continue;
} else {
}
break;
}

var G__30791 = args30789.length;
switch (G__30791) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30789.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30146__auto___30846 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___30846,tc,fc){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___30846,tc,fc){
return (function (state_30817){
var state_val_30818 = (state_30817[(1)]);
if((state_val_30818 === (7))){
var inst_30813 = (state_30817[(2)]);
var state_30817__$1 = state_30817;
var statearr_30819_30847 = state_30817__$1;
(statearr_30819_30847[(2)] = inst_30813);

(statearr_30819_30847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (1))){
var state_30817__$1 = state_30817;
var statearr_30820_30848 = state_30817__$1;
(statearr_30820_30848[(2)] = null);

(statearr_30820_30848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (4))){
var inst_30794 = (state_30817[(7)]);
var inst_30794__$1 = (state_30817[(2)]);
var inst_30795 = (inst_30794__$1 == null);
var state_30817__$1 = (function (){var statearr_30821 = state_30817;
(statearr_30821[(7)] = inst_30794__$1);

return statearr_30821;
})();
if(cljs.core.truth_(inst_30795)){
var statearr_30822_30849 = state_30817__$1;
(statearr_30822_30849[(1)] = (5));

} else {
var statearr_30823_30850 = state_30817__$1;
(statearr_30823_30850[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (13))){
var state_30817__$1 = state_30817;
var statearr_30824_30851 = state_30817__$1;
(statearr_30824_30851[(2)] = null);

(statearr_30824_30851[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (6))){
var inst_30794 = (state_30817[(7)]);
var inst_30800 = p.call(null,inst_30794);
var state_30817__$1 = state_30817;
if(cljs.core.truth_(inst_30800)){
var statearr_30825_30852 = state_30817__$1;
(statearr_30825_30852[(1)] = (9));

} else {
var statearr_30826_30853 = state_30817__$1;
(statearr_30826_30853[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (3))){
var inst_30815 = (state_30817[(2)]);
var state_30817__$1 = state_30817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30817__$1,inst_30815);
} else {
if((state_val_30818 === (12))){
var state_30817__$1 = state_30817;
var statearr_30827_30854 = state_30817__$1;
(statearr_30827_30854[(2)] = null);

(statearr_30827_30854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (2))){
var state_30817__$1 = state_30817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30817__$1,(4),ch);
} else {
if((state_val_30818 === (11))){
var inst_30794 = (state_30817[(7)]);
var inst_30804 = (state_30817[(2)]);
var state_30817__$1 = state_30817;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30817__$1,(8),inst_30804,inst_30794);
} else {
if((state_val_30818 === (9))){
var state_30817__$1 = state_30817;
var statearr_30828_30855 = state_30817__$1;
(statearr_30828_30855[(2)] = tc);

(statearr_30828_30855[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (5))){
var inst_30797 = cljs.core.async.close_BANG_.call(null,tc);
var inst_30798 = cljs.core.async.close_BANG_.call(null,fc);
var state_30817__$1 = (function (){var statearr_30829 = state_30817;
(statearr_30829[(8)] = inst_30797);

return statearr_30829;
})();
var statearr_30830_30856 = state_30817__$1;
(statearr_30830_30856[(2)] = inst_30798);

(statearr_30830_30856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (14))){
var inst_30811 = (state_30817[(2)]);
var state_30817__$1 = state_30817;
var statearr_30831_30857 = state_30817__$1;
(statearr_30831_30857[(2)] = inst_30811);

(statearr_30831_30857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (10))){
var state_30817__$1 = state_30817;
var statearr_30832_30858 = state_30817__$1;
(statearr_30832_30858[(2)] = fc);

(statearr_30832_30858[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30818 === (8))){
var inst_30806 = (state_30817[(2)]);
var state_30817__$1 = state_30817;
if(cljs.core.truth_(inst_30806)){
var statearr_30833_30859 = state_30817__$1;
(statearr_30833_30859[(1)] = (12));

} else {
var statearr_30834_30860 = state_30817__$1;
(statearr_30834_30860[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___30846,tc,fc))
;
return ((function (switch__30032__auto__,c__30146__auto___30846,tc,fc){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_30838 = [null,null,null,null,null,null,null,null,null];
(statearr_30838[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_30838[(1)] = (1));

return statearr_30838;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_30817){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30839){if((e30839 instanceof Object)){
var ex__30036__auto__ = e30839;
var statearr_30840_30861 = state_30817;
(statearr_30840_30861[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30817);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30839;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30862 = state_30817;
state_30817 = G__30862;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_30817){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_30817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___30846,tc,fc))
})();
var state__30148__auto__ = (function (){var statearr_30841 = f__30147__auto__.call(null);
(statearr_30841[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___30846);

return statearr_30841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___30846,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30146__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto__){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto__){
return (function (state_30926){
var state_val_30927 = (state_30926[(1)]);
if((state_val_30927 === (7))){
var inst_30922 = (state_30926[(2)]);
var state_30926__$1 = state_30926;
var statearr_30928_30949 = state_30926__$1;
(statearr_30928_30949[(2)] = inst_30922);

(statearr_30928_30949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30927 === (1))){
var inst_30906 = init;
var state_30926__$1 = (function (){var statearr_30929 = state_30926;
(statearr_30929[(7)] = inst_30906);

return statearr_30929;
})();
var statearr_30930_30950 = state_30926__$1;
(statearr_30930_30950[(2)] = null);

(statearr_30930_30950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30927 === (4))){
var inst_30909 = (state_30926[(8)]);
var inst_30909__$1 = (state_30926[(2)]);
var inst_30910 = (inst_30909__$1 == null);
var state_30926__$1 = (function (){var statearr_30931 = state_30926;
(statearr_30931[(8)] = inst_30909__$1);

return statearr_30931;
})();
if(cljs.core.truth_(inst_30910)){
var statearr_30932_30951 = state_30926__$1;
(statearr_30932_30951[(1)] = (5));

} else {
var statearr_30933_30952 = state_30926__$1;
(statearr_30933_30952[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30927 === (6))){
var inst_30909 = (state_30926[(8)]);
var inst_30913 = (state_30926[(9)]);
var inst_30906 = (state_30926[(7)]);
var inst_30913__$1 = f.call(null,inst_30906,inst_30909);
var inst_30914 = cljs.core.reduced_QMARK_.call(null,inst_30913__$1);
var state_30926__$1 = (function (){var statearr_30934 = state_30926;
(statearr_30934[(9)] = inst_30913__$1);

return statearr_30934;
})();
if(inst_30914){
var statearr_30935_30953 = state_30926__$1;
(statearr_30935_30953[(1)] = (8));

} else {
var statearr_30936_30954 = state_30926__$1;
(statearr_30936_30954[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30927 === (3))){
var inst_30924 = (state_30926[(2)]);
var state_30926__$1 = state_30926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30926__$1,inst_30924);
} else {
if((state_val_30927 === (2))){
var state_30926__$1 = state_30926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30926__$1,(4),ch);
} else {
if((state_val_30927 === (9))){
var inst_30913 = (state_30926[(9)]);
var inst_30906 = inst_30913;
var state_30926__$1 = (function (){var statearr_30937 = state_30926;
(statearr_30937[(7)] = inst_30906);

return statearr_30937;
})();
var statearr_30938_30955 = state_30926__$1;
(statearr_30938_30955[(2)] = null);

(statearr_30938_30955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30927 === (5))){
var inst_30906 = (state_30926[(7)]);
var state_30926__$1 = state_30926;
var statearr_30939_30956 = state_30926__$1;
(statearr_30939_30956[(2)] = inst_30906);

(statearr_30939_30956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30927 === (10))){
var inst_30920 = (state_30926[(2)]);
var state_30926__$1 = state_30926;
var statearr_30940_30957 = state_30926__$1;
(statearr_30940_30957[(2)] = inst_30920);

(statearr_30940_30957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30927 === (8))){
var inst_30913 = (state_30926[(9)]);
var inst_30916 = cljs.core.deref.call(null,inst_30913);
var state_30926__$1 = state_30926;
var statearr_30941_30958 = state_30926__$1;
(statearr_30941_30958[(2)] = inst_30916);

(statearr_30941_30958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto__))
;
return ((function (switch__30032__auto__,c__30146__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30033__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30033__auto____0 = (function (){
var statearr_30945 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30945[(0)] = cljs$core$async$reduce_$_state_machine__30033__auto__);

(statearr_30945[(1)] = (1));

return statearr_30945;
});
var cljs$core$async$reduce_$_state_machine__30033__auto____1 = (function (state_30926){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30946){if((e30946 instanceof Object)){
var ex__30036__auto__ = e30946;
var statearr_30947_30959 = state_30926;
(statearr_30947_30959[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30926);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30946;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30960 = state_30926;
state_30926 = G__30960;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30033__auto__ = function(state_30926){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30033__auto____1.call(this,state_30926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30033__auto____0;
cljs$core$async$reduce_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30033__auto____1;
return cljs$core$async$reduce_$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto__))
})();
var state__30148__auto__ = (function (){var statearr_30948 = f__30147__auto__.call(null);
(statearr_30948[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto__);

return statearr_30948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto__))
);

return c__30146__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__30146__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto__,f__$1){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto__,f__$1){
return (function (state_30980){
var state_val_30981 = (state_30980[(1)]);
if((state_val_30981 === (1))){
var inst_30975 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_30980__$1 = state_30980;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30980__$1,(2),inst_30975);
} else {
if((state_val_30981 === (2))){
var inst_30977 = (state_30980[(2)]);
var inst_30978 = f__$1.call(null,inst_30977);
var state_30980__$1 = state_30980;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30980__$1,inst_30978);
} else {
return null;
}
}
});})(c__30146__auto__,f__$1))
;
return ((function (switch__30032__auto__,c__30146__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__30033__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30033__auto____0 = (function (){
var statearr_30985 = [null,null,null,null,null,null,null];
(statearr_30985[(0)] = cljs$core$async$transduce_$_state_machine__30033__auto__);

(statearr_30985[(1)] = (1));

return statearr_30985;
});
var cljs$core$async$transduce_$_state_machine__30033__auto____1 = (function (state_30980){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_30980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e30986){if((e30986 instanceof Object)){
var ex__30036__auto__ = e30986;
var statearr_30987_30989 = state_30980;
(statearr_30987_30989[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30980);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30990 = state_30980;
state_30980 = G__30990;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30033__auto__ = function(state_30980){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30033__auto____1.call(this,state_30980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30033__auto____0;
cljs$core$async$transduce_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30033__auto____1;
return cljs$core$async$transduce_$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto__,f__$1))
})();
var state__30148__auto__ = (function (){var statearr_30988 = f__30147__auto__.call(null);
(statearr_30988[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto__);

return statearr_30988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto__,f__$1))
);

return c__30146__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30991 = [];
var len__28248__auto___31043 = arguments.length;
var i__28249__auto___31044 = (0);
while(true){
if((i__28249__auto___31044 < len__28248__auto___31043)){
args30991.push((arguments[i__28249__auto___31044]));

var G__31045 = (i__28249__auto___31044 + (1));
i__28249__auto___31044 = G__31045;
continue;
} else {
}
break;
}

var G__30993 = args30991.length;
switch (G__30993) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30991.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30146__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto__){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto__){
return (function (state_31018){
var state_val_31019 = (state_31018[(1)]);
if((state_val_31019 === (7))){
var inst_31000 = (state_31018[(2)]);
var state_31018__$1 = state_31018;
var statearr_31020_31047 = state_31018__$1;
(statearr_31020_31047[(2)] = inst_31000);

(statearr_31020_31047[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (1))){
var inst_30994 = cljs.core.seq.call(null,coll);
var inst_30995 = inst_30994;
var state_31018__$1 = (function (){var statearr_31021 = state_31018;
(statearr_31021[(7)] = inst_30995);

return statearr_31021;
})();
var statearr_31022_31048 = state_31018__$1;
(statearr_31022_31048[(2)] = null);

(statearr_31022_31048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (4))){
var inst_30995 = (state_31018[(7)]);
var inst_30998 = cljs.core.first.call(null,inst_30995);
var state_31018__$1 = state_31018;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31018__$1,(7),ch,inst_30998);
} else {
if((state_val_31019 === (13))){
var inst_31012 = (state_31018[(2)]);
var state_31018__$1 = state_31018;
var statearr_31023_31049 = state_31018__$1;
(statearr_31023_31049[(2)] = inst_31012);

(statearr_31023_31049[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (6))){
var inst_31003 = (state_31018[(2)]);
var state_31018__$1 = state_31018;
if(cljs.core.truth_(inst_31003)){
var statearr_31024_31050 = state_31018__$1;
(statearr_31024_31050[(1)] = (8));

} else {
var statearr_31025_31051 = state_31018__$1;
(statearr_31025_31051[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (3))){
var inst_31016 = (state_31018[(2)]);
var state_31018__$1 = state_31018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31018__$1,inst_31016);
} else {
if((state_val_31019 === (12))){
var state_31018__$1 = state_31018;
var statearr_31026_31052 = state_31018__$1;
(statearr_31026_31052[(2)] = null);

(statearr_31026_31052[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (2))){
var inst_30995 = (state_31018[(7)]);
var state_31018__$1 = state_31018;
if(cljs.core.truth_(inst_30995)){
var statearr_31027_31053 = state_31018__$1;
(statearr_31027_31053[(1)] = (4));

} else {
var statearr_31028_31054 = state_31018__$1;
(statearr_31028_31054[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (11))){
var inst_31009 = cljs.core.async.close_BANG_.call(null,ch);
var state_31018__$1 = state_31018;
var statearr_31029_31055 = state_31018__$1;
(statearr_31029_31055[(2)] = inst_31009);

(statearr_31029_31055[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (9))){
var state_31018__$1 = state_31018;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31030_31056 = state_31018__$1;
(statearr_31030_31056[(1)] = (11));

} else {
var statearr_31031_31057 = state_31018__$1;
(statearr_31031_31057[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (5))){
var inst_30995 = (state_31018[(7)]);
var state_31018__$1 = state_31018;
var statearr_31032_31058 = state_31018__$1;
(statearr_31032_31058[(2)] = inst_30995);

(statearr_31032_31058[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (10))){
var inst_31014 = (state_31018[(2)]);
var state_31018__$1 = state_31018;
var statearr_31033_31059 = state_31018__$1;
(statearr_31033_31059[(2)] = inst_31014);

(statearr_31033_31059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31019 === (8))){
var inst_30995 = (state_31018[(7)]);
var inst_31005 = cljs.core.next.call(null,inst_30995);
var inst_30995__$1 = inst_31005;
var state_31018__$1 = (function (){var statearr_31034 = state_31018;
(statearr_31034[(7)] = inst_30995__$1);

return statearr_31034;
})();
var statearr_31035_31060 = state_31018__$1;
(statearr_31035_31060[(2)] = null);

(statearr_31035_31060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto__))
;
return ((function (switch__30032__auto__,c__30146__auto__){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_31039 = [null,null,null,null,null,null,null,null];
(statearr_31039[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_31039[(1)] = (1));

return statearr_31039;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_31018){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_31018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e31040){if((e31040 instanceof Object)){
var ex__30036__auto__ = e31040;
var statearr_31041_31061 = state_31018;
(statearr_31041_31061[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31040;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31062 = state_31018;
state_31018 = G__31062;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_31018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_31018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto__))
})();
var state__30148__auto__ = (function (){var statearr_31042 = f__30147__auto__.call(null);
(statearr_31042[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto__);

return statearr_31042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto__))
);

return c__30146__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27745__auto__ = (((_ == null))?null:_);
var m__27746__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,_);
} else {
var m__27746__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27746__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m,ch);
} else {
var m__27746__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m);
} else {
var m__27746__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31288 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31288 = (function (ch,cs,meta31289){
this.ch = ch;
this.cs = cs;
this.meta31289 = meta31289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31290,meta31289__$1){
var self__ = this;
var _31290__$1 = this;
return (new cljs.core.async.t_cljs$core$async31288(self__.ch,self__.cs,meta31289__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31290){
var self__ = this;
var _31290__$1 = this;
return self__.meta31289;
});})(cs))
;

cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31288.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31288.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31289","meta31289",-154881234,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31288.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31288.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31288";

cljs.core.async.t_cljs$core$async31288.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async31288");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31288 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31288(ch__$1,cs__$1,meta31289){
return (new cljs.core.async.t_cljs$core$async31288(ch__$1,cs__$1,meta31289));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31288(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30146__auto___31513 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___31513,cs,m,dchan,dctr,done){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___31513,cs,m,dchan,dctr,done){
return (function (state_31425){
var state_val_31426 = (state_31425[(1)]);
if((state_val_31426 === (7))){
var inst_31421 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31427_31514 = state_31425__$1;
(statearr_31427_31514[(2)] = inst_31421);

(statearr_31427_31514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (20))){
var inst_31324 = (state_31425[(7)]);
var inst_31336 = cljs.core.first.call(null,inst_31324);
var inst_31337 = cljs.core.nth.call(null,inst_31336,(0),null);
var inst_31338 = cljs.core.nth.call(null,inst_31336,(1),null);
var state_31425__$1 = (function (){var statearr_31428 = state_31425;
(statearr_31428[(8)] = inst_31337);

return statearr_31428;
})();
if(cljs.core.truth_(inst_31338)){
var statearr_31429_31515 = state_31425__$1;
(statearr_31429_31515[(1)] = (22));

} else {
var statearr_31430_31516 = state_31425__$1;
(statearr_31430_31516[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (27))){
var inst_31373 = (state_31425[(9)]);
var inst_31366 = (state_31425[(10)]);
var inst_31293 = (state_31425[(11)]);
var inst_31368 = (state_31425[(12)]);
var inst_31373__$1 = cljs.core._nth.call(null,inst_31366,inst_31368);
var inst_31374 = cljs.core.async.put_BANG_.call(null,inst_31373__$1,inst_31293,done);
var state_31425__$1 = (function (){var statearr_31431 = state_31425;
(statearr_31431[(9)] = inst_31373__$1);

return statearr_31431;
})();
if(cljs.core.truth_(inst_31374)){
var statearr_31432_31517 = state_31425__$1;
(statearr_31432_31517[(1)] = (30));

} else {
var statearr_31433_31518 = state_31425__$1;
(statearr_31433_31518[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (1))){
var state_31425__$1 = state_31425;
var statearr_31434_31519 = state_31425__$1;
(statearr_31434_31519[(2)] = null);

(statearr_31434_31519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (24))){
var inst_31324 = (state_31425[(7)]);
var inst_31343 = (state_31425[(2)]);
var inst_31344 = cljs.core.next.call(null,inst_31324);
var inst_31302 = inst_31344;
var inst_31303 = null;
var inst_31304 = (0);
var inst_31305 = (0);
var state_31425__$1 = (function (){var statearr_31435 = state_31425;
(statearr_31435[(13)] = inst_31302);

(statearr_31435[(14)] = inst_31303);

(statearr_31435[(15)] = inst_31343);

(statearr_31435[(16)] = inst_31304);

(statearr_31435[(17)] = inst_31305);

return statearr_31435;
})();
var statearr_31436_31520 = state_31425__$1;
(statearr_31436_31520[(2)] = null);

(statearr_31436_31520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (39))){
var state_31425__$1 = state_31425;
var statearr_31440_31521 = state_31425__$1;
(statearr_31440_31521[(2)] = null);

(statearr_31440_31521[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (4))){
var inst_31293 = (state_31425[(11)]);
var inst_31293__$1 = (state_31425[(2)]);
var inst_31294 = (inst_31293__$1 == null);
var state_31425__$1 = (function (){var statearr_31441 = state_31425;
(statearr_31441[(11)] = inst_31293__$1);

return statearr_31441;
})();
if(cljs.core.truth_(inst_31294)){
var statearr_31442_31522 = state_31425__$1;
(statearr_31442_31522[(1)] = (5));

} else {
var statearr_31443_31523 = state_31425__$1;
(statearr_31443_31523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (15))){
var inst_31302 = (state_31425[(13)]);
var inst_31303 = (state_31425[(14)]);
var inst_31304 = (state_31425[(16)]);
var inst_31305 = (state_31425[(17)]);
var inst_31320 = (state_31425[(2)]);
var inst_31321 = (inst_31305 + (1));
var tmp31437 = inst_31302;
var tmp31438 = inst_31303;
var tmp31439 = inst_31304;
var inst_31302__$1 = tmp31437;
var inst_31303__$1 = tmp31438;
var inst_31304__$1 = tmp31439;
var inst_31305__$1 = inst_31321;
var state_31425__$1 = (function (){var statearr_31444 = state_31425;
(statearr_31444[(13)] = inst_31302__$1);

(statearr_31444[(18)] = inst_31320);

(statearr_31444[(14)] = inst_31303__$1);

(statearr_31444[(16)] = inst_31304__$1);

(statearr_31444[(17)] = inst_31305__$1);

return statearr_31444;
})();
var statearr_31445_31524 = state_31425__$1;
(statearr_31445_31524[(2)] = null);

(statearr_31445_31524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (21))){
var inst_31347 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31449_31525 = state_31425__$1;
(statearr_31449_31525[(2)] = inst_31347);

(statearr_31449_31525[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (31))){
var inst_31373 = (state_31425[(9)]);
var inst_31377 = done.call(null,null);
var inst_31378 = cljs.core.async.untap_STAR_.call(null,m,inst_31373);
var state_31425__$1 = (function (){var statearr_31450 = state_31425;
(statearr_31450[(19)] = inst_31377);

return statearr_31450;
})();
var statearr_31451_31526 = state_31425__$1;
(statearr_31451_31526[(2)] = inst_31378);

(statearr_31451_31526[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (32))){
var inst_31365 = (state_31425[(20)]);
var inst_31367 = (state_31425[(21)]);
var inst_31366 = (state_31425[(10)]);
var inst_31368 = (state_31425[(12)]);
var inst_31380 = (state_31425[(2)]);
var inst_31381 = (inst_31368 + (1));
var tmp31446 = inst_31365;
var tmp31447 = inst_31367;
var tmp31448 = inst_31366;
var inst_31365__$1 = tmp31446;
var inst_31366__$1 = tmp31448;
var inst_31367__$1 = tmp31447;
var inst_31368__$1 = inst_31381;
var state_31425__$1 = (function (){var statearr_31452 = state_31425;
(statearr_31452[(22)] = inst_31380);

(statearr_31452[(20)] = inst_31365__$1);

(statearr_31452[(21)] = inst_31367__$1);

(statearr_31452[(10)] = inst_31366__$1);

(statearr_31452[(12)] = inst_31368__$1);

return statearr_31452;
})();
var statearr_31453_31527 = state_31425__$1;
(statearr_31453_31527[(2)] = null);

(statearr_31453_31527[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (40))){
var inst_31393 = (state_31425[(23)]);
var inst_31397 = done.call(null,null);
var inst_31398 = cljs.core.async.untap_STAR_.call(null,m,inst_31393);
var state_31425__$1 = (function (){var statearr_31454 = state_31425;
(statearr_31454[(24)] = inst_31397);

return statearr_31454;
})();
var statearr_31455_31528 = state_31425__$1;
(statearr_31455_31528[(2)] = inst_31398);

(statearr_31455_31528[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (33))){
var inst_31384 = (state_31425[(25)]);
var inst_31386 = cljs.core.chunked_seq_QMARK_.call(null,inst_31384);
var state_31425__$1 = state_31425;
if(inst_31386){
var statearr_31456_31529 = state_31425__$1;
(statearr_31456_31529[(1)] = (36));

} else {
var statearr_31457_31530 = state_31425__$1;
(statearr_31457_31530[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (13))){
var inst_31314 = (state_31425[(26)]);
var inst_31317 = cljs.core.async.close_BANG_.call(null,inst_31314);
var state_31425__$1 = state_31425;
var statearr_31458_31531 = state_31425__$1;
(statearr_31458_31531[(2)] = inst_31317);

(statearr_31458_31531[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (22))){
var inst_31337 = (state_31425[(8)]);
var inst_31340 = cljs.core.async.close_BANG_.call(null,inst_31337);
var state_31425__$1 = state_31425;
var statearr_31459_31532 = state_31425__$1;
(statearr_31459_31532[(2)] = inst_31340);

(statearr_31459_31532[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (36))){
var inst_31384 = (state_31425[(25)]);
var inst_31388 = cljs.core.chunk_first.call(null,inst_31384);
var inst_31389 = cljs.core.chunk_rest.call(null,inst_31384);
var inst_31390 = cljs.core.count.call(null,inst_31388);
var inst_31365 = inst_31389;
var inst_31366 = inst_31388;
var inst_31367 = inst_31390;
var inst_31368 = (0);
var state_31425__$1 = (function (){var statearr_31460 = state_31425;
(statearr_31460[(20)] = inst_31365);

(statearr_31460[(21)] = inst_31367);

(statearr_31460[(10)] = inst_31366);

(statearr_31460[(12)] = inst_31368);

return statearr_31460;
})();
var statearr_31461_31533 = state_31425__$1;
(statearr_31461_31533[(2)] = null);

(statearr_31461_31533[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (41))){
var inst_31384 = (state_31425[(25)]);
var inst_31400 = (state_31425[(2)]);
var inst_31401 = cljs.core.next.call(null,inst_31384);
var inst_31365 = inst_31401;
var inst_31366 = null;
var inst_31367 = (0);
var inst_31368 = (0);
var state_31425__$1 = (function (){var statearr_31462 = state_31425;
(statearr_31462[(20)] = inst_31365);

(statearr_31462[(21)] = inst_31367);

(statearr_31462[(10)] = inst_31366);

(statearr_31462[(12)] = inst_31368);

(statearr_31462[(27)] = inst_31400);

return statearr_31462;
})();
var statearr_31463_31534 = state_31425__$1;
(statearr_31463_31534[(2)] = null);

(statearr_31463_31534[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (43))){
var state_31425__$1 = state_31425;
var statearr_31464_31535 = state_31425__$1;
(statearr_31464_31535[(2)] = null);

(statearr_31464_31535[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (29))){
var inst_31409 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31465_31536 = state_31425__$1;
(statearr_31465_31536[(2)] = inst_31409);

(statearr_31465_31536[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (44))){
var inst_31418 = (state_31425[(2)]);
var state_31425__$1 = (function (){var statearr_31466 = state_31425;
(statearr_31466[(28)] = inst_31418);

return statearr_31466;
})();
var statearr_31467_31537 = state_31425__$1;
(statearr_31467_31537[(2)] = null);

(statearr_31467_31537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (6))){
var inst_31357 = (state_31425[(29)]);
var inst_31356 = cljs.core.deref.call(null,cs);
var inst_31357__$1 = cljs.core.keys.call(null,inst_31356);
var inst_31358 = cljs.core.count.call(null,inst_31357__$1);
var inst_31359 = cljs.core.reset_BANG_.call(null,dctr,inst_31358);
var inst_31364 = cljs.core.seq.call(null,inst_31357__$1);
var inst_31365 = inst_31364;
var inst_31366 = null;
var inst_31367 = (0);
var inst_31368 = (0);
var state_31425__$1 = (function (){var statearr_31468 = state_31425;
(statearr_31468[(20)] = inst_31365);

(statearr_31468[(21)] = inst_31367);

(statearr_31468[(10)] = inst_31366);

(statearr_31468[(30)] = inst_31359);

(statearr_31468[(29)] = inst_31357__$1);

(statearr_31468[(12)] = inst_31368);

return statearr_31468;
})();
var statearr_31469_31538 = state_31425__$1;
(statearr_31469_31538[(2)] = null);

(statearr_31469_31538[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (28))){
var inst_31365 = (state_31425[(20)]);
var inst_31384 = (state_31425[(25)]);
var inst_31384__$1 = cljs.core.seq.call(null,inst_31365);
var state_31425__$1 = (function (){var statearr_31470 = state_31425;
(statearr_31470[(25)] = inst_31384__$1);

return statearr_31470;
})();
if(inst_31384__$1){
var statearr_31471_31539 = state_31425__$1;
(statearr_31471_31539[(1)] = (33));

} else {
var statearr_31472_31540 = state_31425__$1;
(statearr_31472_31540[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (25))){
var inst_31367 = (state_31425[(21)]);
var inst_31368 = (state_31425[(12)]);
var inst_31370 = (inst_31368 < inst_31367);
var inst_31371 = inst_31370;
var state_31425__$1 = state_31425;
if(cljs.core.truth_(inst_31371)){
var statearr_31473_31541 = state_31425__$1;
(statearr_31473_31541[(1)] = (27));

} else {
var statearr_31474_31542 = state_31425__$1;
(statearr_31474_31542[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (34))){
var state_31425__$1 = state_31425;
var statearr_31475_31543 = state_31425__$1;
(statearr_31475_31543[(2)] = null);

(statearr_31475_31543[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (17))){
var state_31425__$1 = state_31425;
var statearr_31476_31544 = state_31425__$1;
(statearr_31476_31544[(2)] = null);

(statearr_31476_31544[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (3))){
var inst_31423 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31425__$1,inst_31423);
} else {
if((state_val_31426 === (12))){
var inst_31352 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31477_31545 = state_31425__$1;
(statearr_31477_31545[(2)] = inst_31352);

(statearr_31477_31545[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (2))){
var state_31425__$1 = state_31425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31425__$1,(4),ch);
} else {
if((state_val_31426 === (23))){
var state_31425__$1 = state_31425;
var statearr_31478_31546 = state_31425__$1;
(statearr_31478_31546[(2)] = null);

(statearr_31478_31546[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (35))){
var inst_31407 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31479_31547 = state_31425__$1;
(statearr_31479_31547[(2)] = inst_31407);

(statearr_31479_31547[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (19))){
var inst_31324 = (state_31425[(7)]);
var inst_31328 = cljs.core.chunk_first.call(null,inst_31324);
var inst_31329 = cljs.core.chunk_rest.call(null,inst_31324);
var inst_31330 = cljs.core.count.call(null,inst_31328);
var inst_31302 = inst_31329;
var inst_31303 = inst_31328;
var inst_31304 = inst_31330;
var inst_31305 = (0);
var state_31425__$1 = (function (){var statearr_31480 = state_31425;
(statearr_31480[(13)] = inst_31302);

(statearr_31480[(14)] = inst_31303);

(statearr_31480[(16)] = inst_31304);

(statearr_31480[(17)] = inst_31305);

return statearr_31480;
})();
var statearr_31481_31548 = state_31425__$1;
(statearr_31481_31548[(2)] = null);

(statearr_31481_31548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (11))){
var inst_31302 = (state_31425[(13)]);
var inst_31324 = (state_31425[(7)]);
var inst_31324__$1 = cljs.core.seq.call(null,inst_31302);
var state_31425__$1 = (function (){var statearr_31482 = state_31425;
(statearr_31482[(7)] = inst_31324__$1);

return statearr_31482;
})();
if(inst_31324__$1){
var statearr_31483_31549 = state_31425__$1;
(statearr_31483_31549[(1)] = (16));

} else {
var statearr_31484_31550 = state_31425__$1;
(statearr_31484_31550[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (9))){
var inst_31354 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31485_31551 = state_31425__$1;
(statearr_31485_31551[(2)] = inst_31354);

(statearr_31485_31551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (5))){
var inst_31300 = cljs.core.deref.call(null,cs);
var inst_31301 = cljs.core.seq.call(null,inst_31300);
var inst_31302 = inst_31301;
var inst_31303 = null;
var inst_31304 = (0);
var inst_31305 = (0);
var state_31425__$1 = (function (){var statearr_31486 = state_31425;
(statearr_31486[(13)] = inst_31302);

(statearr_31486[(14)] = inst_31303);

(statearr_31486[(16)] = inst_31304);

(statearr_31486[(17)] = inst_31305);

return statearr_31486;
})();
var statearr_31487_31552 = state_31425__$1;
(statearr_31487_31552[(2)] = null);

(statearr_31487_31552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (14))){
var state_31425__$1 = state_31425;
var statearr_31488_31553 = state_31425__$1;
(statearr_31488_31553[(2)] = null);

(statearr_31488_31553[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (45))){
var inst_31415 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31489_31554 = state_31425__$1;
(statearr_31489_31554[(2)] = inst_31415);

(statearr_31489_31554[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (26))){
var inst_31357 = (state_31425[(29)]);
var inst_31411 = (state_31425[(2)]);
var inst_31412 = cljs.core.seq.call(null,inst_31357);
var state_31425__$1 = (function (){var statearr_31490 = state_31425;
(statearr_31490[(31)] = inst_31411);

return statearr_31490;
})();
if(inst_31412){
var statearr_31491_31555 = state_31425__$1;
(statearr_31491_31555[(1)] = (42));

} else {
var statearr_31492_31556 = state_31425__$1;
(statearr_31492_31556[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (16))){
var inst_31324 = (state_31425[(7)]);
var inst_31326 = cljs.core.chunked_seq_QMARK_.call(null,inst_31324);
var state_31425__$1 = state_31425;
if(inst_31326){
var statearr_31493_31557 = state_31425__$1;
(statearr_31493_31557[(1)] = (19));

} else {
var statearr_31494_31558 = state_31425__$1;
(statearr_31494_31558[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (38))){
var inst_31404 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31495_31559 = state_31425__$1;
(statearr_31495_31559[(2)] = inst_31404);

(statearr_31495_31559[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (30))){
var state_31425__$1 = state_31425;
var statearr_31496_31560 = state_31425__$1;
(statearr_31496_31560[(2)] = null);

(statearr_31496_31560[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (10))){
var inst_31303 = (state_31425[(14)]);
var inst_31305 = (state_31425[(17)]);
var inst_31313 = cljs.core._nth.call(null,inst_31303,inst_31305);
var inst_31314 = cljs.core.nth.call(null,inst_31313,(0),null);
var inst_31315 = cljs.core.nth.call(null,inst_31313,(1),null);
var state_31425__$1 = (function (){var statearr_31497 = state_31425;
(statearr_31497[(26)] = inst_31314);

return statearr_31497;
})();
if(cljs.core.truth_(inst_31315)){
var statearr_31498_31561 = state_31425__$1;
(statearr_31498_31561[(1)] = (13));

} else {
var statearr_31499_31562 = state_31425__$1;
(statearr_31499_31562[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (18))){
var inst_31350 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31500_31563 = state_31425__$1;
(statearr_31500_31563[(2)] = inst_31350);

(statearr_31500_31563[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (42))){
var state_31425__$1 = state_31425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31425__$1,(45),dchan);
} else {
if((state_val_31426 === (37))){
var inst_31393 = (state_31425[(23)]);
var inst_31384 = (state_31425[(25)]);
var inst_31293 = (state_31425[(11)]);
var inst_31393__$1 = cljs.core.first.call(null,inst_31384);
var inst_31394 = cljs.core.async.put_BANG_.call(null,inst_31393__$1,inst_31293,done);
var state_31425__$1 = (function (){var statearr_31501 = state_31425;
(statearr_31501[(23)] = inst_31393__$1);

return statearr_31501;
})();
if(cljs.core.truth_(inst_31394)){
var statearr_31502_31564 = state_31425__$1;
(statearr_31502_31564[(1)] = (39));

} else {
var statearr_31503_31565 = state_31425__$1;
(statearr_31503_31565[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (8))){
var inst_31304 = (state_31425[(16)]);
var inst_31305 = (state_31425[(17)]);
var inst_31307 = (inst_31305 < inst_31304);
var inst_31308 = inst_31307;
var state_31425__$1 = state_31425;
if(cljs.core.truth_(inst_31308)){
var statearr_31504_31566 = state_31425__$1;
(statearr_31504_31566[(1)] = (10));

} else {
var statearr_31505_31567 = state_31425__$1;
(statearr_31505_31567[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___31513,cs,m,dchan,dctr,done))
;
return ((function (switch__30032__auto__,c__30146__auto___31513,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30033__auto__ = null;
var cljs$core$async$mult_$_state_machine__30033__auto____0 = (function (){
var statearr_31509 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31509[(0)] = cljs$core$async$mult_$_state_machine__30033__auto__);

(statearr_31509[(1)] = (1));

return statearr_31509;
});
var cljs$core$async$mult_$_state_machine__30033__auto____1 = (function (state_31425){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_31425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e31510){if((e31510 instanceof Object)){
var ex__30036__auto__ = e31510;
var statearr_31511_31568 = state_31425;
(statearr_31511_31568[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31425);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31510;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31569 = state_31425;
state_31425 = G__31569;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30033__auto__ = function(state_31425){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30033__auto____1.call(this,state_31425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30033__auto____0;
cljs$core$async$mult_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30033__auto____1;
return cljs$core$async$mult_$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___31513,cs,m,dchan,dctr,done))
})();
var state__30148__auto__ = (function (){var statearr_31512 = f__30147__auto__.call(null);
(statearr_31512[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___31513);

return statearr_31512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___31513,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args31570 = [];
var len__28248__auto___31573 = arguments.length;
var i__28249__auto___31574 = (0);
while(true){
if((i__28249__auto___31574 < len__28248__auto___31573)){
args31570.push((arguments[i__28249__auto___31574]));

var G__31575 = (i__28249__auto___31574 + (1));
i__28249__auto___31574 = G__31575;
continue;
} else {
}
break;
}

var G__31572 = args31570.length;
switch (G__31572) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31570.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m,ch);
} else {
var m__27746__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m,ch);
} else {
var m__27746__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m);
} else {
var m__27746__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m,state_map);
} else {
var m__27746__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27745__auto__ = (((m == null))?null:m);
var m__27746__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,m,mode);
} else {
var m__27746__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28255__auto__ = [];
var len__28248__auto___31587 = arguments.length;
var i__28249__auto___31588 = (0);
while(true){
if((i__28249__auto___31588 < len__28248__auto___31587)){
args__28255__auto__.push((arguments[i__28249__auto___31588]));

var G__31589 = (i__28249__auto___31588 + (1));
i__28249__auto___31588 = G__31589;
continue;
} else {
}
break;
}

var argseq__28256__auto__ = ((((3) < args__28255__auto__.length))?(new cljs.core.IndexedSeq(args__28255__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28256__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31581){
var map__31582 = p__31581;
var map__31582__$1 = ((((!((map__31582 == null)))?((((map__31582.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31582.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31582):map__31582);
var opts = map__31582__$1;
var statearr_31584_31590 = state;
(statearr_31584_31590[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6747__auto__ = cljs.core.async.do_alts.call(null,((function (map__31582,map__31582__$1,opts){
return (function (val){
var statearr_31585_31591 = state;
(statearr_31585_31591[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31582,map__31582__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6747__auto__)){
var cb = temp__6747__auto__;
var statearr_31586_31592 = state;
(statearr_31586_31592[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31577){
var G__31578 = cljs.core.first.call(null,seq31577);
var seq31577__$1 = cljs.core.next.call(null,seq31577);
var G__31579 = cljs.core.first.call(null,seq31577__$1);
var seq31577__$2 = cljs.core.next.call(null,seq31577__$1);
var G__31580 = cljs.core.first.call(null,seq31577__$2);
var seq31577__$3 = cljs.core.next.call(null,seq31577__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31578,G__31579,G__31580,seq31577__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31760 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31760 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31761){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31761 = meta31761;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31762,meta31761__$1){
var self__ = this;
var _31762__$1 = this;
return (new cljs.core.async.t_cljs$core$async31760(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31761__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31762){
var self__ = this;
var _31762__$1 = this;
return self__.meta31761;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31761","meta31761",1819896155,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31760.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31760.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31760";

cljs.core.async.t_cljs$core$async31760.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async31760");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31760 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31760(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31761){
return (new cljs.core.async.t_cljs$core$async31760(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31761));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31760(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30146__auto___31927 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___31927,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___31927,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31864){
var state_val_31865 = (state_31864[(1)]);
if((state_val_31865 === (7))){
var inst_31779 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
var statearr_31866_31928 = state_31864__$1;
(statearr_31866_31928[(2)] = inst_31779);

(statearr_31866_31928[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (20))){
var inst_31791 = (state_31864[(7)]);
var state_31864__$1 = state_31864;
var statearr_31867_31929 = state_31864__$1;
(statearr_31867_31929[(2)] = inst_31791);

(statearr_31867_31929[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (27))){
var state_31864__$1 = state_31864;
var statearr_31868_31930 = state_31864__$1;
(statearr_31868_31930[(2)] = null);

(statearr_31868_31930[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (1))){
var inst_31766 = (state_31864[(8)]);
var inst_31766__$1 = calc_state.call(null);
var inst_31768 = (inst_31766__$1 == null);
var inst_31769 = cljs.core.not.call(null,inst_31768);
var state_31864__$1 = (function (){var statearr_31869 = state_31864;
(statearr_31869[(8)] = inst_31766__$1);

return statearr_31869;
})();
if(inst_31769){
var statearr_31870_31931 = state_31864__$1;
(statearr_31870_31931[(1)] = (2));

} else {
var statearr_31871_31932 = state_31864__$1;
(statearr_31871_31932[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (24))){
var inst_31815 = (state_31864[(9)]);
var inst_31824 = (state_31864[(10)]);
var inst_31838 = (state_31864[(11)]);
var inst_31838__$1 = inst_31815.call(null,inst_31824);
var state_31864__$1 = (function (){var statearr_31872 = state_31864;
(statearr_31872[(11)] = inst_31838__$1);

return statearr_31872;
})();
if(cljs.core.truth_(inst_31838__$1)){
var statearr_31873_31933 = state_31864__$1;
(statearr_31873_31933[(1)] = (29));

} else {
var statearr_31874_31934 = state_31864__$1;
(statearr_31874_31934[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (4))){
var inst_31782 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
if(cljs.core.truth_(inst_31782)){
var statearr_31875_31935 = state_31864__$1;
(statearr_31875_31935[(1)] = (8));

} else {
var statearr_31876_31936 = state_31864__$1;
(statearr_31876_31936[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (15))){
var inst_31809 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
if(cljs.core.truth_(inst_31809)){
var statearr_31877_31937 = state_31864__$1;
(statearr_31877_31937[(1)] = (19));

} else {
var statearr_31878_31938 = state_31864__$1;
(statearr_31878_31938[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (21))){
var inst_31814 = (state_31864[(12)]);
var inst_31814__$1 = (state_31864[(2)]);
var inst_31815 = cljs.core.get.call(null,inst_31814__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31816 = cljs.core.get.call(null,inst_31814__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31817 = cljs.core.get.call(null,inst_31814__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31864__$1 = (function (){var statearr_31879 = state_31864;
(statearr_31879[(9)] = inst_31815);

(statearr_31879[(12)] = inst_31814__$1);

(statearr_31879[(13)] = inst_31816);

return statearr_31879;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31864__$1,(22),inst_31817);
} else {
if((state_val_31865 === (31))){
var inst_31846 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
if(cljs.core.truth_(inst_31846)){
var statearr_31880_31939 = state_31864__$1;
(statearr_31880_31939[(1)] = (32));

} else {
var statearr_31881_31940 = state_31864__$1;
(statearr_31881_31940[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (32))){
var inst_31823 = (state_31864[(14)]);
var state_31864__$1 = state_31864;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31864__$1,(35),out,inst_31823);
} else {
if((state_val_31865 === (33))){
var inst_31814 = (state_31864[(12)]);
var inst_31791 = inst_31814;
var state_31864__$1 = (function (){var statearr_31882 = state_31864;
(statearr_31882[(7)] = inst_31791);

return statearr_31882;
})();
var statearr_31883_31941 = state_31864__$1;
(statearr_31883_31941[(2)] = null);

(statearr_31883_31941[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (13))){
var inst_31791 = (state_31864[(7)]);
var inst_31798 = inst_31791.cljs$lang$protocol_mask$partition0$;
var inst_31799 = (inst_31798 & (64));
var inst_31800 = inst_31791.cljs$core$ISeq$;
var inst_31801 = (cljs.core.PROTOCOL_SENTINEL === inst_31800);
var inst_31802 = (inst_31799) || (inst_31801);
var state_31864__$1 = state_31864;
if(cljs.core.truth_(inst_31802)){
var statearr_31884_31942 = state_31864__$1;
(statearr_31884_31942[(1)] = (16));

} else {
var statearr_31885_31943 = state_31864__$1;
(statearr_31885_31943[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (22))){
var inst_31823 = (state_31864[(14)]);
var inst_31824 = (state_31864[(10)]);
var inst_31822 = (state_31864[(2)]);
var inst_31823__$1 = cljs.core.nth.call(null,inst_31822,(0),null);
var inst_31824__$1 = cljs.core.nth.call(null,inst_31822,(1),null);
var inst_31825 = (inst_31823__$1 == null);
var inst_31826 = cljs.core._EQ_.call(null,inst_31824__$1,change);
var inst_31827 = (inst_31825) || (inst_31826);
var state_31864__$1 = (function (){var statearr_31886 = state_31864;
(statearr_31886[(14)] = inst_31823__$1);

(statearr_31886[(10)] = inst_31824__$1);

return statearr_31886;
})();
if(cljs.core.truth_(inst_31827)){
var statearr_31887_31944 = state_31864__$1;
(statearr_31887_31944[(1)] = (23));

} else {
var statearr_31888_31945 = state_31864__$1;
(statearr_31888_31945[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (36))){
var inst_31814 = (state_31864[(12)]);
var inst_31791 = inst_31814;
var state_31864__$1 = (function (){var statearr_31889 = state_31864;
(statearr_31889[(7)] = inst_31791);

return statearr_31889;
})();
var statearr_31890_31946 = state_31864__$1;
(statearr_31890_31946[(2)] = null);

(statearr_31890_31946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (29))){
var inst_31838 = (state_31864[(11)]);
var state_31864__$1 = state_31864;
var statearr_31891_31947 = state_31864__$1;
(statearr_31891_31947[(2)] = inst_31838);

(statearr_31891_31947[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (6))){
var state_31864__$1 = state_31864;
var statearr_31892_31948 = state_31864__$1;
(statearr_31892_31948[(2)] = false);

(statearr_31892_31948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (28))){
var inst_31834 = (state_31864[(2)]);
var inst_31835 = calc_state.call(null);
var inst_31791 = inst_31835;
var state_31864__$1 = (function (){var statearr_31893 = state_31864;
(statearr_31893[(15)] = inst_31834);

(statearr_31893[(7)] = inst_31791);

return statearr_31893;
})();
var statearr_31894_31949 = state_31864__$1;
(statearr_31894_31949[(2)] = null);

(statearr_31894_31949[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (25))){
var inst_31860 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
var statearr_31895_31950 = state_31864__$1;
(statearr_31895_31950[(2)] = inst_31860);

(statearr_31895_31950[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (34))){
var inst_31858 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
var statearr_31896_31951 = state_31864__$1;
(statearr_31896_31951[(2)] = inst_31858);

(statearr_31896_31951[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (17))){
var state_31864__$1 = state_31864;
var statearr_31897_31952 = state_31864__$1;
(statearr_31897_31952[(2)] = false);

(statearr_31897_31952[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (3))){
var state_31864__$1 = state_31864;
var statearr_31898_31953 = state_31864__$1;
(statearr_31898_31953[(2)] = false);

(statearr_31898_31953[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (12))){
var inst_31862 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31864__$1,inst_31862);
} else {
if((state_val_31865 === (2))){
var inst_31766 = (state_31864[(8)]);
var inst_31771 = inst_31766.cljs$lang$protocol_mask$partition0$;
var inst_31772 = (inst_31771 & (64));
var inst_31773 = inst_31766.cljs$core$ISeq$;
var inst_31774 = (cljs.core.PROTOCOL_SENTINEL === inst_31773);
var inst_31775 = (inst_31772) || (inst_31774);
var state_31864__$1 = state_31864;
if(cljs.core.truth_(inst_31775)){
var statearr_31899_31954 = state_31864__$1;
(statearr_31899_31954[(1)] = (5));

} else {
var statearr_31900_31955 = state_31864__$1;
(statearr_31900_31955[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (23))){
var inst_31823 = (state_31864[(14)]);
var inst_31829 = (inst_31823 == null);
var state_31864__$1 = state_31864;
if(cljs.core.truth_(inst_31829)){
var statearr_31901_31956 = state_31864__$1;
(statearr_31901_31956[(1)] = (26));

} else {
var statearr_31902_31957 = state_31864__$1;
(statearr_31902_31957[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (35))){
var inst_31849 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
if(cljs.core.truth_(inst_31849)){
var statearr_31903_31958 = state_31864__$1;
(statearr_31903_31958[(1)] = (36));

} else {
var statearr_31904_31959 = state_31864__$1;
(statearr_31904_31959[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (19))){
var inst_31791 = (state_31864[(7)]);
var inst_31811 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31791);
var state_31864__$1 = state_31864;
var statearr_31905_31960 = state_31864__$1;
(statearr_31905_31960[(2)] = inst_31811);

(statearr_31905_31960[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (11))){
var inst_31791 = (state_31864[(7)]);
var inst_31795 = (inst_31791 == null);
var inst_31796 = cljs.core.not.call(null,inst_31795);
var state_31864__$1 = state_31864;
if(inst_31796){
var statearr_31906_31961 = state_31864__$1;
(statearr_31906_31961[(1)] = (13));

} else {
var statearr_31907_31962 = state_31864__$1;
(statearr_31907_31962[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (9))){
var inst_31766 = (state_31864[(8)]);
var state_31864__$1 = state_31864;
var statearr_31908_31963 = state_31864__$1;
(statearr_31908_31963[(2)] = inst_31766);

(statearr_31908_31963[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (5))){
var state_31864__$1 = state_31864;
var statearr_31909_31964 = state_31864__$1;
(statearr_31909_31964[(2)] = true);

(statearr_31909_31964[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (14))){
var state_31864__$1 = state_31864;
var statearr_31910_31965 = state_31864__$1;
(statearr_31910_31965[(2)] = false);

(statearr_31910_31965[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (26))){
var inst_31824 = (state_31864[(10)]);
var inst_31831 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31824);
var state_31864__$1 = state_31864;
var statearr_31911_31966 = state_31864__$1;
(statearr_31911_31966[(2)] = inst_31831);

(statearr_31911_31966[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (16))){
var state_31864__$1 = state_31864;
var statearr_31912_31967 = state_31864__$1;
(statearr_31912_31967[(2)] = true);

(statearr_31912_31967[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (38))){
var inst_31854 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
var statearr_31913_31968 = state_31864__$1;
(statearr_31913_31968[(2)] = inst_31854);

(statearr_31913_31968[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (30))){
var inst_31815 = (state_31864[(9)]);
var inst_31824 = (state_31864[(10)]);
var inst_31816 = (state_31864[(13)]);
var inst_31841 = cljs.core.empty_QMARK_.call(null,inst_31815);
var inst_31842 = inst_31816.call(null,inst_31824);
var inst_31843 = cljs.core.not.call(null,inst_31842);
var inst_31844 = (inst_31841) && (inst_31843);
var state_31864__$1 = state_31864;
var statearr_31914_31969 = state_31864__$1;
(statearr_31914_31969[(2)] = inst_31844);

(statearr_31914_31969[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (10))){
var inst_31766 = (state_31864[(8)]);
var inst_31787 = (state_31864[(2)]);
var inst_31788 = cljs.core.get.call(null,inst_31787,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31789 = cljs.core.get.call(null,inst_31787,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31790 = cljs.core.get.call(null,inst_31787,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31791 = inst_31766;
var state_31864__$1 = (function (){var statearr_31915 = state_31864;
(statearr_31915[(16)] = inst_31789);

(statearr_31915[(7)] = inst_31791);

(statearr_31915[(17)] = inst_31788);

(statearr_31915[(18)] = inst_31790);

return statearr_31915;
})();
var statearr_31916_31970 = state_31864__$1;
(statearr_31916_31970[(2)] = null);

(statearr_31916_31970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (18))){
var inst_31806 = (state_31864[(2)]);
var state_31864__$1 = state_31864;
var statearr_31917_31971 = state_31864__$1;
(statearr_31917_31971[(2)] = inst_31806);

(statearr_31917_31971[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (37))){
var state_31864__$1 = state_31864;
var statearr_31918_31972 = state_31864__$1;
(statearr_31918_31972[(2)] = null);

(statearr_31918_31972[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31865 === (8))){
var inst_31766 = (state_31864[(8)]);
var inst_31784 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31766);
var state_31864__$1 = state_31864;
var statearr_31919_31973 = state_31864__$1;
(statearr_31919_31973[(2)] = inst_31784);

(statearr_31919_31973[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___31927,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30032__auto__,c__30146__auto___31927,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30033__auto__ = null;
var cljs$core$async$mix_$_state_machine__30033__auto____0 = (function (){
var statearr_31923 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31923[(0)] = cljs$core$async$mix_$_state_machine__30033__auto__);

(statearr_31923[(1)] = (1));

return statearr_31923;
});
var cljs$core$async$mix_$_state_machine__30033__auto____1 = (function (state_31864){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_31864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e31924){if((e31924 instanceof Object)){
var ex__30036__auto__ = e31924;
var statearr_31925_31974 = state_31864;
(statearr_31925_31974[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31864);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31924;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31975 = state_31864;
state_31864 = G__31975;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30033__auto__ = function(state_31864){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30033__auto____1.call(this,state_31864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30033__auto____0;
cljs$core$async$mix_$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30033__auto____1;
return cljs$core$async$mix_$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___31927,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30148__auto__ = (function (){var statearr_31926 = f__30147__auto__.call(null);
(statearr_31926[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___31927);

return statearr_31926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___31927,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27745__auto__ = (((p == null))?null:p);
var m__27746__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27746__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27745__auto__ = (((p == null))?null:p);
var m__27746__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,p,v,ch);
} else {
var m__27746__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31976 = [];
var len__28248__auto___31979 = arguments.length;
var i__28249__auto___31980 = (0);
while(true){
if((i__28249__auto___31980 < len__28248__auto___31979)){
args31976.push((arguments[i__28249__auto___31980]));

var G__31981 = (i__28249__auto___31980 + (1));
i__28249__auto___31980 = G__31981;
continue;
} else {
}
break;
}

var G__31978 = args31976.length;
switch (G__31978) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31976.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27745__auto__ = (((p == null))?null:p);
var m__27746__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,p);
} else {
var m__27746__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27745__auto__ = (((p == null))?null:p);
var m__27746__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27745__auto__)]);
if(!((m__27746__auto__ == null))){
return m__27746__auto__.call(null,p,v);
} else {
var m__27746__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27746__auto____$1 == null))){
return m__27746__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31984 = [];
var len__28248__auto___32109 = arguments.length;
var i__28249__auto___32110 = (0);
while(true){
if((i__28249__auto___32110 < len__28248__auto___32109)){
args31984.push((arguments[i__28249__auto___32110]));

var G__32111 = (i__28249__auto___32110 + (1));
i__28249__auto___32110 = G__32111;
continue;
} else {
}
break;
}

var G__31986 = args31984.length;
switch (G__31986) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31984.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27032__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27032__auto__)){
return or__27032__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27032__auto__,mults){
return (function (p1__31983_SHARP_){
if(cljs.core.truth_(p1__31983_SHARP_.call(null,topic))){
return p1__31983_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31983_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27032__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31987 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31987 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31988){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31988 = meta31988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31989,meta31988__$1){
var self__ = this;
var _31989__$1 = this;
return (new cljs.core.async.t_cljs$core$async31987(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31988__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31989){
var self__ = this;
var _31989__$1 = this;
return self__.meta31988;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6747__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6747__auto__)){
var m = temp__6747__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31988","meta31988",90173437,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31987.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31987.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31987";

cljs.core.async.t_cljs$core$async31987.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async31987");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31987 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31987(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31988){
return (new cljs.core.async.t_cljs$core$async31987(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31988));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31987(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30146__auto___32113 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32113,mults,ensure_mult,p){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32113,mults,ensure_mult,p){
return (function (state_32061){
var state_val_32062 = (state_32061[(1)]);
if((state_val_32062 === (7))){
var inst_32057 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
var statearr_32063_32114 = state_32061__$1;
(statearr_32063_32114[(2)] = inst_32057);

(statearr_32063_32114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (20))){
var state_32061__$1 = state_32061;
var statearr_32064_32115 = state_32061__$1;
(statearr_32064_32115[(2)] = null);

(statearr_32064_32115[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (1))){
var state_32061__$1 = state_32061;
var statearr_32065_32116 = state_32061__$1;
(statearr_32065_32116[(2)] = null);

(statearr_32065_32116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (24))){
var inst_32040 = (state_32061[(7)]);
var inst_32049 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32040);
var state_32061__$1 = state_32061;
var statearr_32066_32117 = state_32061__$1;
(statearr_32066_32117[(2)] = inst_32049);

(statearr_32066_32117[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (4))){
var inst_31992 = (state_32061[(8)]);
var inst_31992__$1 = (state_32061[(2)]);
var inst_31993 = (inst_31992__$1 == null);
var state_32061__$1 = (function (){var statearr_32067 = state_32061;
(statearr_32067[(8)] = inst_31992__$1);

return statearr_32067;
})();
if(cljs.core.truth_(inst_31993)){
var statearr_32068_32118 = state_32061__$1;
(statearr_32068_32118[(1)] = (5));

} else {
var statearr_32069_32119 = state_32061__$1;
(statearr_32069_32119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (15))){
var inst_32034 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
var statearr_32070_32120 = state_32061__$1;
(statearr_32070_32120[(2)] = inst_32034);

(statearr_32070_32120[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (21))){
var inst_32054 = (state_32061[(2)]);
var state_32061__$1 = (function (){var statearr_32071 = state_32061;
(statearr_32071[(9)] = inst_32054);

return statearr_32071;
})();
var statearr_32072_32121 = state_32061__$1;
(statearr_32072_32121[(2)] = null);

(statearr_32072_32121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (13))){
var inst_32016 = (state_32061[(10)]);
var inst_32018 = cljs.core.chunked_seq_QMARK_.call(null,inst_32016);
var state_32061__$1 = state_32061;
if(inst_32018){
var statearr_32073_32122 = state_32061__$1;
(statearr_32073_32122[(1)] = (16));

} else {
var statearr_32074_32123 = state_32061__$1;
(statearr_32074_32123[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (22))){
var inst_32046 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
if(cljs.core.truth_(inst_32046)){
var statearr_32075_32124 = state_32061__$1;
(statearr_32075_32124[(1)] = (23));

} else {
var statearr_32076_32125 = state_32061__$1;
(statearr_32076_32125[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (6))){
var inst_31992 = (state_32061[(8)]);
var inst_32042 = (state_32061[(11)]);
var inst_32040 = (state_32061[(7)]);
var inst_32040__$1 = topic_fn.call(null,inst_31992);
var inst_32041 = cljs.core.deref.call(null,mults);
var inst_32042__$1 = cljs.core.get.call(null,inst_32041,inst_32040__$1);
var state_32061__$1 = (function (){var statearr_32077 = state_32061;
(statearr_32077[(11)] = inst_32042__$1);

(statearr_32077[(7)] = inst_32040__$1);

return statearr_32077;
})();
if(cljs.core.truth_(inst_32042__$1)){
var statearr_32078_32126 = state_32061__$1;
(statearr_32078_32126[(1)] = (19));

} else {
var statearr_32079_32127 = state_32061__$1;
(statearr_32079_32127[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (25))){
var inst_32051 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
var statearr_32080_32128 = state_32061__$1;
(statearr_32080_32128[(2)] = inst_32051);

(statearr_32080_32128[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (17))){
var inst_32016 = (state_32061[(10)]);
var inst_32025 = cljs.core.first.call(null,inst_32016);
var inst_32026 = cljs.core.async.muxch_STAR_.call(null,inst_32025);
var inst_32027 = cljs.core.async.close_BANG_.call(null,inst_32026);
var inst_32028 = cljs.core.next.call(null,inst_32016);
var inst_32002 = inst_32028;
var inst_32003 = null;
var inst_32004 = (0);
var inst_32005 = (0);
var state_32061__$1 = (function (){var statearr_32081 = state_32061;
(statearr_32081[(12)] = inst_32003);

(statearr_32081[(13)] = inst_32004);

(statearr_32081[(14)] = inst_32027);

(statearr_32081[(15)] = inst_32002);

(statearr_32081[(16)] = inst_32005);

return statearr_32081;
})();
var statearr_32082_32129 = state_32061__$1;
(statearr_32082_32129[(2)] = null);

(statearr_32082_32129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (3))){
var inst_32059 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32061__$1,inst_32059);
} else {
if((state_val_32062 === (12))){
var inst_32036 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
var statearr_32083_32130 = state_32061__$1;
(statearr_32083_32130[(2)] = inst_32036);

(statearr_32083_32130[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (2))){
var state_32061__$1 = state_32061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32061__$1,(4),ch);
} else {
if((state_val_32062 === (23))){
var state_32061__$1 = state_32061;
var statearr_32084_32131 = state_32061__$1;
(statearr_32084_32131[(2)] = null);

(statearr_32084_32131[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (19))){
var inst_31992 = (state_32061[(8)]);
var inst_32042 = (state_32061[(11)]);
var inst_32044 = cljs.core.async.muxch_STAR_.call(null,inst_32042);
var state_32061__$1 = state_32061;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32061__$1,(22),inst_32044,inst_31992);
} else {
if((state_val_32062 === (11))){
var inst_32002 = (state_32061[(15)]);
var inst_32016 = (state_32061[(10)]);
var inst_32016__$1 = cljs.core.seq.call(null,inst_32002);
var state_32061__$1 = (function (){var statearr_32085 = state_32061;
(statearr_32085[(10)] = inst_32016__$1);

return statearr_32085;
})();
if(inst_32016__$1){
var statearr_32086_32132 = state_32061__$1;
(statearr_32086_32132[(1)] = (13));

} else {
var statearr_32087_32133 = state_32061__$1;
(statearr_32087_32133[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (9))){
var inst_32038 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
var statearr_32088_32134 = state_32061__$1;
(statearr_32088_32134[(2)] = inst_32038);

(statearr_32088_32134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (5))){
var inst_31999 = cljs.core.deref.call(null,mults);
var inst_32000 = cljs.core.vals.call(null,inst_31999);
var inst_32001 = cljs.core.seq.call(null,inst_32000);
var inst_32002 = inst_32001;
var inst_32003 = null;
var inst_32004 = (0);
var inst_32005 = (0);
var state_32061__$1 = (function (){var statearr_32089 = state_32061;
(statearr_32089[(12)] = inst_32003);

(statearr_32089[(13)] = inst_32004);

(statearr_32089[(15)] = inst_32002);

(statearr_32089[(16)] = inst_32005);

return statearr_32089;
})();
var statearr_32090_32135 = state_32061__$1;
(statearr_32090_32135[(2)] = null);

(statearr_32090_32135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (14))){
var state_32061__$1 = state_32061;
var statearr_32094_32136 = state_32061__$1;
(statearr_32094_32136[(2)] = null);

(statearr_32094_32136[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (16))){
var inst_32016 = (state_32061[(10)]);
var inst_32020 = cljs.core.chunk_first.call(null,inst_32016);
var inst_32021 = cljs.core.chunk_rest.call(null,inst_32016);
var inst_32022 = cljs.core.count.call(null,inst_32020);
var inst_32002 = inst_32021;
var inst_32003 = inst_32020;
var inst_32004 = inst_32022;
var inst_32005 = (0);
var state_32061__$1 = (function (){var statearr_32095 = state_32061;
(statearr_32095[(12)] = inst_32003);

(statearr_32095[(13)] = inst_32004);

(statearr_32095[(15)] = inst_32002);

(statearr_32095[(16)] = inst_32005);

return statearr_32095;
})();
var statearr_32096_32137 = state_32061__$1;
(statearr_32096_32137[(2)] = null);

(statearr_32096_32137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (10))){
var inst_32003 = (state_32061[(12)]);
var inst_32004 = (state_32061[(13)]);
var inst_32002 = (state_32061[(15)]);
var inst_32005 = (state_32061[(16)]);
var inst_32010 = cljs.core._nth.call(null,inst_32003,inst_32005);
var inst_32011 = cljs.core.async.muxch_STAR_.call(null,inst_32010);
var inst_32012 = cljs.core.async.close_BANG_.call(null,inst_32011);
var inst_32013 = (inst_32005 + (1));
var tmp32091 = inst_32003;
var tmp32092 = inst_32004;
var tmp32093 = inst_32002;
var inst_32002__$1 = tmp32093;
var inst_32003__$1 = tmp32091;
var inst_32004__$1 = tmp32092;
var inst_32005__$1 = inst_32013;
var state_32061__$1 = (function (){var statearr_32097 = state_32061;
(statearr_32097[(12)] = inst_32003__$1);

(statearr_32097[(13)] = inst_32004__$1);

(statearr_32097[(17)] = inst_32012);

(statearr_32097[(15)] = inst_32002__$1);

(statearr_32097[(16)] = inst_32005__$1);

return statearr_32097;
})();
var statearr_32098_32138 = state_32061__$1;
(statearr_32098_32138[(2)] = null);

(statearr_32098_32138[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (18))){
var inst_32031 = (state_32061[(2)]);
var state_32061__$1 = state_32061;
var statearr_32099_32139 = state_32061__$1;
(statearr_32099_32139[(2)] = inst_32031);

(statearr_32099_32139[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32062 === (8))){
var inst_32004 = (state_32061[(13)]);
var inst_32005 = (state_32061[(16)]);
var inst_32007 = (inst_32005 < inst_32004);
var inst_32008 = inst_32007;
var state_32061__$1 = state_32061;
if(cljs.core.truth_(inst_32008)){
var statearr_32100_32140 = state_32061__$1;
(statearr_32100_32140[(1)] = (10));

} else {
var statearr_32101_32141 = state_32061__$1;
(statearr_32101_32141[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32113,mults,ensure_mult,p))
;
return ((function (switch__30032__auto__,c__30146__auto___32113,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32105 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32105[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32105[(1)] = (1));

return statearr_32105;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32061){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32106){if((e32106 instanceof Object)){
var ex__30036__auto__ = e32106;
var statearr_32107_32142 = state_32061;
(statearr_32107_32142[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32106;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32143 = state_32061;
state_32061 = G__32143;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32113,mults,ensure_mult,p))
})();
var state__30148__auto__ = (function (){var statearr_32108 = f__30147__auto__.call(null);
(statearr_32108[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32113);

return statearr_32108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32113,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args32144 = [];
var len__28248__auto___32147 = arguments.length;
var i__28249__auto___32148 = (0);
while(true){
if((i__28249__auto___32148 < len__28248__auto___32147)){
args32144.push((arguments[i__28249__auto___32148]));

var G__32149 = (i__28249__auto___32148 + (1));
i__28249__auto___32148 = G__32149;
continue;
} else {
}
break;
}

var G__32146 = args32144.length;
switch (G__32146) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32144.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args32151 = [];
var len__28248__auto___32154 = arguments.length;
var i__28249__auto___32155 = (0);
while(true){
if((i__28249__auto___32155 < len__28248__auto___32154)){
args32151.push((arguments[i__28249__auto___32155]));

var G__32156 = (i__28249__auto___32155 + (1));
i__28249__auto___32155 = G__32156;
continue;
} else {
}
break;
}

var G__32153 = args32151.length;
switch (G__32153) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32151.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args32158 = [];
var len__28248__auto___32229 = arguments.length;
var i__28249__auto___32230 = (0);
while(true){
if((i__28249__auto___32230 < len__28248__auto___32229)){
args32158.push((arguments[i__28249__auto___32230]));

var G__32231 = (i__28249__auto___32230 + (1));
i__28249__auto___32230 = G__32231;
continue;
} else {
}
break;
}

var G__32160 = args32158.length;
switch (G__32160) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32158.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30146__auto___32233 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32233,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32233,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32199){
var state_val_32200 = (state_32199[(1)]);
if((state_val_32200 === (7))){
var state_32199__$1 = state_32199;
var statearr_32201_32234 = state_32199__$1;
(statearr_32201_32234[(2)] = null);

(statearr_32201_32234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (1))){
var state_32199__$1 = state_32199;
var statearr_32202_32235 = state_32199__$1;
(statearr_32202_32235[(2)] = null);

(statearr_32202_32235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (4))){
var inst_32163 = (state_32199[(7)]);
var inst_32165 = (inst_32163 < cnt);
var state_32199__$1 = state_32199;
if(cljs.core.truth_(inst_32165)){
var statearr_32203_32236 = state_32199__$1;
(statearr_32203_32236[(1)] = (6));

} else {
var statearr_32204_32237 = state_32199__$1;
(statearr_32204_32237[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (15))){
var inst_32195 = (state_32199[(2)]);
var state_32199__$1 = state_32199;
var statearr_32205_32238 = state_32199__$1;
(statearr_32205_32238[(2)] = inst_32195);

(statearr_32205_32238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (13))){
var inst_32188 = cljs.core.async.close_BANG_.call(null,out);
var state_32199__$1 = state_32199;
var statearr_32206_32239 = state_32199__$1;
(statearr_32206_32239[(2)] = inst_32188);

(statearr_32206_32239[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (6))){
var state_32199__$1 = state_32199;
var statearr_32207_32240 = state_32199__$1;
(statearr_32207_32240[(2)] = null);

(statearr_32207_32240[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (3))){
var inst_32197 = (state_32199[(2)]);
var state_32199__$1 = state_32199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32199__$1,inst_32197);
} else {
if((state_val_32200 === (12))){
var inst_32185 = (state_32199[(8)]);
var inst_32185__$1 = (state_32199[(2)]);
var inst_32186 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32185__$1);
var state_32199__$1 = (function (){var statearr_32208 = state_32199;
(statearr_32208[(8)] = inst_32185__$1);

return statearr_32208;
})();
if(cljs.core.truth_(inst_32186)){
var statearr_32209_32241 = state_32199__$1;
(statearr_32209_32241[(1)] = (13));

} else {
var statearr_32210_32242 = state_32199__$1;
(statearr_32210_32242[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (2))){
var inst_32162 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32163 = (0);
var state_32199__$1 = (function (){var statearr_32211 = state_32199;
(statearr_32211[(9)] = inst_32162);

(statearr_32211[(7)] = inst_32163);

return statearr_32211;
})();
var statearr_32212_32243 = state_32199__$1;
(statearr_32212_32243[(2)] = null);

(statearr_32212_32243[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (11))){
var inst_32163 = (state_32199[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32199,(10),Object,null,(9));
var inst_32172 = chs__$1.call(null,inst_32163);
var inst_32173 = done.call(null,inst_32163);
var inst_32174 = cljs.core.async.take_BANG_.call(null,inst_32172,inst_32173);
var state_32199__$1 = state_32199;
var statearr_32213_32244 = state_32199__$1;
(statearr_32213_32244[(2)] = inst_32174);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32199__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (9))){
var inst_32163 = (state_32199[(7)]);
var inst_32176 = (state_32199[(2)]);
var inst_32177 = (inst_32163 + (1));
var inst_32163__$1 = inst_32177;
var state_32199__$1 = (function (){var statearr_32214 = state_32199;
(statearr_32214[(10)] = inst_32176);

(statearr_32214[(7)] = inst_32163__$1);

return statearr_32214;
})();
var statearr_32215_32245 = state_32199__$1;
(statearr_32215_32245[(2)] = null);

(statearr_32215_32245[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (5))){
var inst_32183 = (state_32199[(2)]);
var state_32199__$1 = (function (){var statearr_32216 = state_32199;
(statearr_32216[(11)] = inst_32183);

return statearr_32216;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32199__$1,(12),dchan);
} else {
if((state_val_32200 === (14))){
var inst_32185 = (state_32199[(8)]);
var inst_32190 = cljs.core.apply.call(null,f,inst_32185);
var state_32199__$1 = state_32199;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32199__$1,(16),out,inst_32190);
} else {
if((state_val_32200 === (16))){
var inst_32192 = (state_32199[(2)]);
var state_32199__$1 = (function (){var statearr_32217 = state_32199;
(statearr_32217[(12)] = inst_32192);

return statearr_32217;
})();
var statearr_32218_32246 = state_32199__$1;
(statearr_32218_32246[(2)] = null);

(statearr_32218_32246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (10))){
var inst_32167 = (state_32199[(2)]);
var inst_32168 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32199__$1 = (function (){var statearr_32219 = state_32199;
(statearr_32219[(13)] = inst_32167);

return statearr_32219;
})();
var statearr_32220_32247 = state_32199__$1;
(statearr_32220_32247[(2)] = inst_32168);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32199__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32200 === (8))){
var inst_32181 = (state_32199[(2)]);
var state_32199__$1 = state_32199;
var statearr_32221_32248 = state_32199__$1;
(statearr_32221_32248[(2)] = inst_32181);

(statearr_32221_32248[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32233,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30032__auto__,c__30146__auto___32233,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32225 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32225[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32225[(1)] = (1));

return statearr_32225;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32199){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32226){if((e32226 instanceof Object)){
var ex__30036__auto__ = e32226;
var statearr_32227_32249 = state_32199;
(statearr_32227_32249[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32199);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32226;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32250 = state_32199;
state_32199 = G__32250;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32199){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32233,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30148__auto__ = (function (){var statearr_32228 = f__30147__auto__.call(null);
(statearr_32228[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32233);

return statearr_32228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32233,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args32252 = [];
var len__28248__auto___32310 = arguments.length;
var i__28249__auto___32311 = (0);
while(true){
if((i__28249__auto___32311 < len__28248__auto___32310)){
args32252.push((arguments[i__28249__auto___32311]));

var G__32312 = (i__28249__auto___32311 + (1));
i__28249__auto___32311 = G__32312;
continue;
} else {
}
break;
}

var G__32254 = args32252.length;
switch (G__32254) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32252.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30146__auto___32314 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32314,out){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32314,out){
return (function (state_32286){
var state_val_32287 = (state_32286[(1)]);
if((state_val_32287 === (7))){
var inst_32266 = (state_32286[(7)]);
var inst_32265 = (state_32286[(8)]);
var inst_32265__$1 = (state_32286[(2)]);
var inst_32266__$1 = cljs.core.nth.call(null,inst_32265__$1,(0),null);
var inst_32267 = cljs.core.nth.call(null,inst_32265__$1,(1),null);
var inst_32268 = (inst_32266__$1 == null);
var state_32286__$1 = (function (){var statearr_32288 = state_32286;
(statearr_32288[(7)] = inst_32266__$1);

(statearr_32288[(8)] = inst_32265__$1);

(statearr_32288[(9)] = inst_32267);

return statearr_32288;
})();
if(cljs.core.truth_(inst_32268)){
var statearr_32289_32315 = state_32286__$1;
(statearr_32289_32315[(1)] = (8));

} else {
var statearr_32290_32316 = state_32286__$1;
(statearr_32290_32316[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (1))){
var inst_32255 = cljs.core.vec.call(null,chs);
var inst_32256 = inst_32255;
var state_32286__$1 = (function (){var statearr_32291 = state_32286;
(statearr_32291[(10)] = inst_32256);

return statearr_32291;
})();
var statearr_32292_32317 = state_32286__$1;
(statearr_32292_32317[(2)] = null);

(statearr_32292_32317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (4))){
var inst_32256 = (state_32286[(10)]);
var state_32286__$1 = state_32286;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32286__$1,(7),inst_32256);
} else {
if((state_val_32287 === (6))){
var inst_32282 = (state_32286[(2)]);
var state_32286__$1 = state_32286;
var statearr_32293_32318 = state_32286__$1;
(statearr_32293_32318[(2)] = inst_32282);

(statearr_32293_32318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (3))){
var inst_32284 = (state_32286[(2)]);
var state_32286__$1 = state_32286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32286__$1,inst_32284);
} else {
if((state_val_32287 === (2))){
var inst_32256 = (state_32286[(10)]);
var inst_32258 = cljs.core.count.call(null,inst_32256);
var inst_32259 = (inst_32258 > (0));
var state_32286__$1 = state_32286;
if(cljs.core.truth_(inst_32259)){
var statearr_32295_32319 = state_32286__$1;
(statearr_32295_32319[(1)] = (4));

} else {
var statearr_32296_32320 = state_32286__$1;
(statearr_32296_32320[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (11))){
var inst_32256 = (state_32286[(10)]);
var inst_32275 = (state_32286[(2)]);
var tmp32294 = inst_32256;
var inst_32256__$1 = tmp32294;
var state_32286__$1 = (function (){var statearr_32297 = state_32286;
(statearr_32297[(11)] = inst_32275);

(statearr_32297[(10)] = inst_32256__$1);

return statearr_32297;
})();
var statearr_32298_32321 = state_32286__$1;
(statearr_32298_32321[(2)] = null);

(statearr_32298_32321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (9))){
var inst_32266 = (state_32286[(7)]);
var state_32286__$1 = state_32286;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32286__$1,(11),out,inst_32266);
} else {
if((state_val_32287 === (5))){
var inst_32280 = cljs.core.async.close_BANG_.call(null,out);
var state_32286__$1 = state_32286;
var statearr_32299_32322 = state_32286__$1;
(statearr_32299_32322[(2)] = inst_32280);

(statearr_32299_32322[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (10))){
var inst_32278 = (state_32286[(2)]);
var state_32286__$1 = state_32286;
var statearr_32300_32323 = state_32286__$1;
(statearr_32300_32323[(2)] = inst_32278);

(statearr_32300_32323[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32287 === (8))){
var inst_32266 = (state_32286[(7)]);
var inst_32265 = (state_32286[(8)]);
var inst_32267 = (state_32286[(9)]);
var inst_32256 = (state_32286[(10)]);
var inst_32270 = (function (){var cs = inst_32256;
var vec__32261 = inst_32265;
var v = inst_32266;
var c = inst_32267;
return ((function (cs,vec__32261,v,c,inst_32266,inst_32265,inst_32267,inst_32256,state_val_32287,c__30146__auto___32314,out){
return (function (p1__32251_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32251_SHARP_);
});
;})(cs,vec__32261,v,c,inst_32266,inst_32265,inst_32267,inst_32256,state_val_32287,c__30146__auto___32314,out))
})();
var inst_32271 = cljs.core.filterv.call(null,inst_32270,inst_32256);
var inst_32256__$1 = inst_32271;
var state_32286__$1 = (function (){var statearr_32301 = state_32286;
(statearr_32301[(10)] = inst_32256__$1);

return statearr_32301;
})();
var statearr_32302_32324 = state_32286__$1;
(statearr_32302_32324[(2)] = null);

(statearr_32302_32324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32314,out))
;
return ((function (switch__30032__auto__,c__30146__auto___32314,out){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32306 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32306[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32306[(1)] = (1));

return statearr_32306;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32286){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32307){if((e32307 instanceof Object)){
var ex__30036__auto__ = e32307;
var statearr_32308_32325 = state_32286;
(statearr_32308_32325[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32286);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32307;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32326 = state_32286;
state_32286 = G__32326;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32286){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32314,out))
})();
var state__30148__auto__ = (function (){var statearr_32309 = f__30147__auto__.call(null);
(statearr_32309[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32314);

return statearr_32309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32314,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args32327 = [];
var len__28248__auto___32376 = arguments.length;
var i__28249__auto___32377 = (0);
while(true){
if((i__28249__auto___32377 < len__28248__auto___32376)){
args32327.push((arguments[i__28249__auto___32377]));

var G__32378 = (i__28249__auto___32377 + (1));
i__28249__auto___32377 = G__32378;
continue;
} else {
}
break;
}

var G__32329 = args32327.length;
switch (G__32329) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32327.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30146__auto___32380 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32380,out){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32380,out){
return (function (state_32353){
var state_val_32354 = (state_32353[(1)]);
if((state_val_32354 === (7))){
var inst_32335 = (state_32353[(7)]);
var inst_32335__$1 = (state_32353[(2)]);
var inst_32336 = (inst_32335__$1 == null);
var inst_32337 = cljs.core.not.call(null,inst_32336);
var state_32353__$1 = (function (){var statearr_32355 = state_32353;
(statearr_32355[(7)] = inst_32335__$1);

return statearr_32355;
})();
if(inst_32337){
var statearr_32356_32381 = state_32353__$1;
(statearr_32356_32381[(1)] = (8));

} else {
var statearr_32357_32382 = state_32353__$1;
(statearr_32357_32382[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (1))){
var inst_32330 = (0);
var state_32353__$1 = (function (){var statearr_32358 = state_32353;
(statearr_32358[(8)] = inst_32330);

return statearr_32358;
})();
var statearr_32359_32383 = state_32353__$1;
(statearr_32359_32383[(2)] = null);

(statearr_32359_32383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (4))){
var state_32353__$1 = state_32353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32353__$1,(7),ch);
} else {
if((state_val_32354 === (6))){
var inst_32348 = (state_32353[(2)]);
var state_32353__$1 = state_32353;
var statearr_32360_32384 = state_32353__$1;
(statearr_32360_32384[(2)] = inst_32348);

(statearr_32360_32384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (3))){
var inst_32350 = (state_32353[(2)]);
var inst_32351 = cljs.core.async.close_BANG_.call(null,out);
var state_32353__$1 = (function (){var statearr_32361 = state_32353;
(statearr_32361[(9)] = inst_32350);

return statearr_32361;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32353__$1,inst_32351);
} else {
if((state_val_32354 === (2))){
var inst_32330 = (state_32353[(8)]);
var inst_32332 = (inst_32330 < n);
var state_32353__$1 = state_32353;
if(cljs.core.truth_(inst_32332)){
var statearr_32362_32385 = state_32353__$1;
(statearr_32362_32385[(1)] = (4));

} else {
var statearr_32363_32386 = state_32353__$1;
(statearr_32363_32386[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (11))){
var inst_32330 = (state_32353[(8)]);
var inst_32340 = (state_32353[(2)]);
var inst_32341 = (inst_32330 + (1));
var inst_32330__$1 = inst_32341;
var state_32353__$1 = (function (){var statearr_32364 = state_32353;
(statearr_32364[(8)] = inst_32330__$1);

(statearr_32364[(10)] = inst_32340);

return statearr_32364;
})();
var statearr_32365_32387 = state_32353__$1;
(statearr_32365_32387[(2)] = null);

(statearr_32365_32387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (9))){
var state_32353__$1 = state_32353;
var statearr_32366_32388 = state_32353__$1;
(statearr_32366_32388[(2)] = null);

(statearr_32366_32388[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (5))){
var state_32353__$1 = state_32353;
var statearr_32367_32389 = state_32353__$1;
(statearr_32367_32389[(2)] = null);

(statearr_32367_32389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (10))){
var inst_32345 = (state_32353[(2)]);
var state_32353__$1 = state_32353;
var statearr_32368_32390 = state_32353__$1;
(statearr_32368_32390[(2)] = inst_32345);

(statearr_32368_32390[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32354 === (8))){
var inst_32335 = (state_32353[(7)]);
var state_32353__$1 = state_32353;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32353__$1,(11),out,inst_32335);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32380,out))
;
return ((function (switch__30032__auto__,c__30146__auto___32380,out){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32372 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32372[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32372[(1)] = (1));

return statearr_32372;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32353){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32373){if((e32373 instanceof Object)){
var ex__30036__auto__ = e32373;
var statearr_32374_32391 = state_32353;
(statearr_32374_32391[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32373;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32392 = state_32353;
state_32353 = G__32392;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32353){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32380,out))
})();
var state__30148__auto__ = (function (){var statearr_32375 = f__30147__auto__.call(null);
(statearr_32375[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32380);

return statearr_32375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32380,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32400 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32400 = (function (f,ch,meta32401){
this.f = f;
this.ch = ch;
this.meta32401 = meta32401;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32402,meta32401__$1){
var self__ = this;
var _32402__$1 = this;
return (new cljs.core.async.t_cljs$core$async32400(self__.f,self__.ch,meta32401__$1));
});

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32402){
var self__ = this;
var _32402__$1 = this;
return self__.meta32401;
});

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32403 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32403 = (function (f,ch,meta32401,_,fn1,meta32404){
this.f = f;
this.ch = ch;
this.meta32401 = meta32401;
this._ = _;
this.fn1 = fn1;
this.meta32404 = meta32404;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32403.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32405,meta32404__$1){
var self__ = this;
var _32405__$1 = this;
return (new cljs.core.async.t_cljs$core$async32403(self__.f,self__.ch,self__.meta32401,self__._,self__.fn1,meta32404__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32403.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32405){
var self__ = this;
var _32405__$1 = this;
return self__.meta32404;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32403.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32403.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32403.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32403.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32393_SHARP_){
return f1.call(null,(((p1__32393_SHARP_ == null))?null:self__.f.call(null,p1__32393_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32403.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32401","meta32401",-502806695,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32400","cljs.core.async/t_cljs$core$async32400",547307620,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32404","meta32404",-1652655117,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32403.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32403.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32403";

cljs.core.async.t_cljs$core$async32403.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async32403");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32403 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32403(f__$1,ch__$1,meta32401__$1,___$2,fn1__$1,meta32404){
return (new cljs.core.async.t_cljs$core$async32403(f__$1,ch__$1,meta32401__$1,___$2,fn1__$1,meta32404));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32403(self__.f,self__.ch,self__.meta32401,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27020__auto__ = ret;
if(cljs.core.truth_(and__27020__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27020__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32400.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32400.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32401","meta32401",-502806695,null)], null);
});

cljs.core.async.t_cljs$core$async32400.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32400.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32400";

cljs.core.async.t_cljs$core$async32400.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async32400");
});

cljs.core.async.__GT_t_cljs$core$async32400 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32400(f__$1,ch__$1,meta32401){
return (new cljs.core.async.t_cljs$core$async32400(f__$1,ch__$1,meta32401));
});

}

return (new cljs.core.async.t_cljs$core$async32400(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32409 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32409 = (function (f,ch,meta32410){
this.f = f;
this.ch = ch;
this.meta32410 = meta32410;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32411,meta32410__$1){
var self__ = this;
var _32411__$1 = this;
return (new cljs.core.async.t_cljs$core$async32409(self__.f,self__.ch,meta32410__$1));
});

cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32411){
var self__ = this;
var _32411__$1 = this;
return self__.meta32410;
});

cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32409.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32410","meta32410",-1734245409,null)], null);
});

cljs.core.async.t_cljs$core$async32409.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32409.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32409";

cljs.core.async.t_cljs$core$async32409.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async32409");
});

cljs.core.async.__GT_t_cljs$core$async32409 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32409(f__$1,ch__$1,meta32410){
return (new cljs.core.async.t_cljs$core$async32409(f__$1,ch__$1,meta32410));
});

}

return (new cljs.core.async.t_cljs$core$async32409(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32415 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32415 = (function (p,ch,meta32416){
this.p = p;
this.ch = ch;
this.meta32416 = meta32416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32417,meta32416__$1){
var self__ = this;
var _32417__$1 = this;
return (new cljs.core.async.t_cljs$core$async32415(self__.p,self__.ch,meta32416__$1));
});

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32417){
var self__ = this;
var _32417__$1 = this;
return self__.meta32416;
});

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32415.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32415.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32416","meta32416",-884320320,null)], null);
});

cljs.core.async.t_cljs$core$async32415.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32415.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32415";

cljs.core.async.t_cljs$core$async32415.cljs$lang$ctorPrWriter = (function (this__27684__auto__,writer__27685__auto__,opt__27686__auto__){
return cljs.core._write.call(null,writer__27685__auto__,"cljs.core.async/t_cljs$core$async32415");
});

cljs.core.async.__GT_t_cljs$core$async32415 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32415(p__$1,ch__$1,meta32416){
return (new cljs.core.async.t_cljs$core$async32415(p__$1,ch__$1,meta32416));
});

}

return (new cljs.core.async.t_cljs$core$async32415(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args32418 = [];
var len__28248__auto___32462 = arguments.length;
var i__28249__auto___32463 = (0);
while(true){
if((i__28249__auto___32463 < len__28248__auto___32462)){
args32418.push((arguments[i__28249__auto___32463]));

var G__32464 = (i__28249__auto___32463 + (1));
i__28249__auto___32463 = G__32464;
continue;
} else {
}
break;
}

var G__32420 = args32418.length;
switch (G__32420) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32418.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30146__auto___32466 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32466,out){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32466,out){
return (function (state_32441){
var state_val_32442 = (state_32441[(1)]);
if((state_val_32442 === (7))){
var inst_32437 = (state_32441[(2)]);
var state_32441__$1 = state_32441;
var statearr_32443_32467 = state_32441__$1;
(statearr_32443_32467[(2)] = inst_32437);

(statearr_32443_32467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (1))){
var state_32441__$1 = state_32441;
var statearr_32444_32468 = state_32441__$1;
(statearr_32444_32468[(2)] = null);

(statearr_32444_32468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (4))){
var inst_32423 = (state_32441[(7)]);
var inst_32423__$1 = (state_32441[(2)]);
var inst_32424 = (inst_32423__$1 == null);
var state_32441__$1 = (function (){var statearr_32445 = state_32441;
(statearr_32445[(7)] = inst_32423__$1);

return statearr_32445;
})();
if(cljs.core.truth_(inst_32424)){
var statearr_32446_32469 = state_32441__$1;
(statearr_32446_32469[(1)] = (5));

} else {
var statearr_32447_32470 = state_32441__$1;
(statearr_32447_32470[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (6))){
var inst_32423 = (state_32441[(7)]);
var inst_32428 = p.call(null,inst_32423);
var state_32441__$1 = state_32441;
if(cljs.core.truth_(inst_32428)){
var statearr_32448_32471 = state_32441__$1;
(statearr_32448_32471[(1)] = (8));

} else {
var statearr_32449_32472 = state_32441__$1;
(statearr_32449_32472[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (3))){
var inst_32439 = (state_32441[(2)]);
var state_32441__$1 = state_32441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32441__$1,inst_32439);
} else {
if((state_val_32442 === (2))){
var state_32441__$1 = state_32441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32441__$1,(4),ch);
} else {
if((state_val_32442 === (11))){
var inst_32431 = (state_32441[(2)]);
var state_32441__$1 = state_32441;
var statearr_32450_32473 = state_32441__$1;
(statearr_32450_32473[(2)] = inst_32431);

(statearr_32450_32473[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (9))){
var state_32441__$1 = state_32441;
var statearr_32451_32474 = state_32441__$1;
(statearr_32451_32474[(2)] = null);

(statearr_32451_32474[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (5))){
var inst_32426 = cljs.core.async.close_BANG_.call(null,out);
var state_32441__$1 = state_32441;
var statearr_32452_32475 = state_32441__$1;
(statearr_32452_32475[(2)] = inst_32426);

(statearr_32452_32475[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (10))){
var inst_32434 = (state_32441[(2)]);
var state_32441__$1 = (function (){var statearr_32453 = state_32441;
(statearr_32453[(8)] = inst_32434);

return statearr_32453;
})();
var statearr_32454_32476 = state_32441__$1;
(statearr_32454_32476[(2)] = null);

(statearr_32454_32476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32442 === (8))){
var inst_32423 = (state_32441[(7)]);
var state_32441__$1 = state_32441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32441__$1,(11),out,inst_32423);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32466,out))
;
return ((function (switch__30032__auto__,c__30146__auto___32466,out){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32458 = [null,null,null,null,null,null,null,null,null];
(statearr_32458[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32458[(1)] = (1));

return statearr_32458;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32441){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32459){if((e32459 instanceof Object)){
var ex__30036__auto__ = e32459;
var statearr_32460_32477 = state_32441;
(statearr_32460_32477[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32459;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32478 = state_32441;
state_32441 = G__32478;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32441){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32466,out))
})();
var state__30148__auto__ = (function (){var statearr_32461 = f__30147__auto__.call(null);
(statearr_32461[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32466);

return statearr_32461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32466,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args32479 = [];
var len__28248__auto___32482 = arguments.length;
var i__28249__auto___32483 = (0);
while(true){
if((i__28249__auto___32483 < len__28248__auto___32482)){
args32479.push((arguments[i__28249__auto___32483]));

var G__32484 = (i__28249__auto___32483 + (1));
i__28249__auto___32483 = G__32484;
continue;
} else {
}
break;
}

var G__32481 = args32479.length;
switch (G__32481) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32479.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30146__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto__){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto__){
return (function (state_32651){
var state_val_32652 = (state_32651[(1)]);
if((state_val_32652 === (7))){
var inst_32647 = (state_32651[(2)]);
var state_32651__$1 = state_32651;
var statearr_32653_32694 = state_32651__$1;
(statearr_32653_32694[(2)] = inst_32647);

(statearr_32653_32694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (20))){
var inst_32617 = (state_32651[(7)]);
var inst_32628 = (state_32651[(2)]);
var inst_32629 = cljs.core.next.call(null,inst_32617);
var inst_32603 = inst_32629;
var inst_32604 = null;
var inst_32605 = (0);
var inst_32606 = (0);
var state_32651__$1 = (function (){var statearr_32654 = state_32651;
(statearr_32654[(8)] = inst_32604);

(statearr_32654[(9)] = inst_32603);

(statearr_32654[(10)] = inst_32605);

(statearr_32654[(11)] = inst_32606);

(statearr_32654[(12)] = inst_32628);

return statearr_32654;
})();
var statearr_32655_32695 = state_32651__$1;
(statearr_32655_32695[(2)] = null);

(statearr_32655_32695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (1))){
var state_32651__$1 = state_32651;
var statearr_32656_32696 = state_32651__$1;
(statearr_32656_32696[(2)] = null);

(statearr_32656_32696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (4))){
var inst_32592 = (state_32651[(13)]);
var inst_32592__$1 = (state_32651[(2)]);
var inst_32593 = (inst_32592__$1 == null);
var state_32651__$1 = (function (){var statearr_32657 = state_32651;
(statearr_32657[(13)] = inst_32592__$1);

return statearr_32657;
})();
if(cljs.core.truth_(inst_32593)){
var statearr_32658_32697 = state_32651__$1;
(statearr_32658_32697[(1)] = (5));

} else {
var statearr_32659_32698 = state_32651__$1;
(statearr_32659_32698[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (15))){
var state_32651__$1 = state_32651;
var statearr_32663_32699 = state_32651__$1;
(statearr_32663_32699[(2)] = null);

(statearr_32663_32699[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (21))){
var state_32651__$1 = state_32651;
var statearr_32664_32700 = state_32651__$1;
(statearr_32664_32700[(2)] = null);

(statearr_32664_32700[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (13))){
var inst_32604 = (state_32651[(8)]);
var inst_32603 = (state_32651[(9)]);
var inst_32605 = (state_32651[(10)]);
var inst_32606 = (state_32651[(11)]);
var inst_32613 = (state_32651[(2)]);
var inst_32614 = (inst_32606 + (1));
var tmp32660 = inst_32604;
var tmp32661 = inst_32603;
var tmp32662 = inst_32605;
var inst_32603__$1 = tmp32661;
var inst_32604__$1 = tmp32660;
var inst_32605__$1 = tmp32662;
var inst_32606__$1 = inst_32614;
var state_32651__$1 = (function (){var statearr_32665 = state_32651;
(statearr_32665[(14)] = inst_32613);

(statearr_32665[(8)] = inst_32604__$1);

(statearr_32665[(9)] = inst_32603__$1);

(statearr_32665[(10)] = inst_32605__$1);

(statearr_32665[(11)] = inst_32606__$1);

return statearr_32665;
})();
var statearr_32666_32701 = state_32651__$1;
(statearr_32666_32701[(2)] = null);

(statearr_32666_32701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (22))){
var state_32651__$1 = state_32651;
var statearr_32667_32702 = state_32651__$1;
(statearr_32667_32702[(2)] = null);

(statearr_32667_32702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (6))){
var inst_32592 = (state_32651[(13)]);
var inst_32601 = f.call(null,inst_32592);
var inst_32602 = cljs.core.seq.call(null,inst_32601);
var inst_32603 = inst_32602;
var inst_32604 = null;
var inst_32605 = (0);
var inst_32606 = (0);
var state_32651__$1 = (function (){var statearr_32668 = state_32651;
(statearr_32668[(8)] = inst_32604);

(statearr_32668[(9)] = inst_32603);

(statearr_32668[(10)] = inst_32605);

(statearr_32668[(11)] = inst_32606);

return statearr_32668;
})();
var statearr_32669_32703 = state_32651__$1;
(statearr_32669_32703[(2)] = null);

(statearr_32669_32703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (17))){
var inst_32617 = (state_32651[(7)]);
var inst_32621 = cljs.core.chunk_first.call(null,inst_32617);
var inst_32622 = cljs.core.chunk_rest.call(null,inst_32617);
var inst_32623 = cljs.core.count.call(null,inst_32621);
var inst_32603 = inst_32622;
var inst_32604 = inst_32621;
var inst_32605 = inst_32623;
var inst_32606 = (0);
var state_32651__$1 = (function (){var statearr_32670 = state_32651;
(statearr_32670[(8)] = inst_32604);

(statearr_32670[(9)] = inst_32603);

(statearr_32670[(10)] = inst_32605);

(statearr_32670[(11)] = inst_32606);

return statearr_32670;
})();
var statearr_32671_32704 = state_32651__$1;
(statearr_32671_32704[(2)] = null);

(statearr_32671_32704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (3))){
var inst_32649 = (state_32651[(2)]);
var state_32651__$1 = state_32651;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32651__$1,inst_32649);
} else {
if((state_val_32652 === (12))){
var inst_32637 = (state_32651[(2)]);
var state_32651__$1 = state_32651;
var statearr_32672_32705 = state_32651__$1;
(statearr_32672_32705[(2)] = inst_32637);

(statearr_32672_32705[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (2))){
var state_32651__$1 = state_32651;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32651__$1,(4),in$);
} else {
if((state_val_32652 === (23))){
var inst_32645 = (state_32651[(2)]);
var state_32651__$1 = state_32651;
var statearr_32673_32706 = state_32651__$1;
(statearr_32673_32706[(2)] = inst_32645);

(statearr_32673_32706[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (19))){
var inst_32632 = (state_32651[(2)]);
var state_32651__$1 = state_32651;
var statearr_32674_32707 = state_32651__$1;
(statearr_32674_32707[(2)] = inst_32632);

(statearr_32674_32707[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (11))){
var inst_32603 = (state_32651[(9)]);
var inst_32617 = (state_32651[(7)]);
var inst_32617__$1 = cljs.core.seq.call(null,inst_32603);
var state_32651__$1 = (function (){var statearr_32675 = state_32651;
(statearr_32675[(7)] = inst_32617__$1);

return statearr_32675;
})();
if(inst_32617__$1){
var statearr_32676_32708 = state_32651__$1;
(statearr_32676_32708[(1)] = (14));

} else {
var statearr_32677_32709 = state_32651__$1;
(statearr_32677_32709[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (9))){
var inst_32639 = (state_32651[(2)]);
var inst_32640 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32651__$1 = (function (){var statearr_32678 = state_32651;
(statearr_32678[(15)] = inst_32639);

return statearr_32678;
})();
if(cljs.core.truth_(inst_32640)){
var statearr_32679_32710 = state_32651__$1;
(statearr_32679_32710[(1)] = (21));

} else {
var statearr_32680_32711 = state_32651__$1;
(statearr_32680_32711[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (5))){
var inst_32595 = cljs.core.async.close_BANG_.call(null,out);
var state_32651__$1 = state_32651;
var statearr_32681_32712 = state_32651__$1;
(statearr_32681_32712[(2)] = inst_32595);

(statearr_32681_32712[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (14))){
var inst_32617 = (state_32651[(7)]);
var inst_32619 = cljs.core.chunked_seq_QMARK_.call(null,inst_32617);
var state_32651__$1 = state_32651;
if(inst_32619){
var statearr_32682_32713 = state_32651__$1;
(statearr_32682_32713[(1)] = (17));

} else {
var statearr_32683_32714 = state_32651__$1;
(statearr_32683_32714[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (16))){
var inst_32635 = (state_32651[(2)]);
var state_32651__$1 = state_32651;
var statearr_32684_32715 = state_32651__$1;
(statearr_32684_32715[(2)] = inst_32635);

(statearr_32684_32715[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32652 === (10))){
var inst_32604 = (state_32651[(8)]);
var inst_32606 = (state_32651[(11)]);
var inst_32611 = cljs.core._nth.call(null,inst_32604,inst_32606);
var state_32651__$1 = state_32651;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32651__$1,(13),out,inst_32611);
} else {
if((state_val_32652 === (18))){
var inst_32617 = (state_32651[(7)]);
var inst_32626 = cljs.core.first.call(null,inst_32617);
var state_32651__$1 = state_32651;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32651__$1,(20),out,inst_32626);
} else {
if((state_val_32652 === (8))){
var inst_32605 = (state_32651[(10)]);
var inst_32606 = (state_32651[(11)]);
var inst_32608 = (inst_32606 < inst_32605);
var inst_32609 = inst_32608;
var state_32651__$1 = state_32651;
if(cljs.core.truth_(inst_32609)){
var statearr_32685_32716 = state_32651__$1;
(statearr_32685_32716[(1)] = (10));

} else {
var statearr_32686_32717 = state_32651__$1;
(statearr_32686_32717[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto__))
;
return ((function (switch__30032__auto__,c__30146__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30033__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30033__auto____0 = (function (){
var statearr_32690 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32690[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30033__auto__);

(statearr_32690[(1)] = (1));

return statearr_32690;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30033__auto____1 = (function (state_32651){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32651);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32691){if((e32691 instanceof Object)){
var ex__30036__auto__ = e32691;
var statearr_32692_32718 = state_32651;
(statearr_32692_32718[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32651);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32691;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32719 = state_32651;
state_32651 = G__32719;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30033__auto__ = function(state_32651){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30033__auto____1.call(this,state_32651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30033__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30033__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto__))
})();
var state__30148__auto__ = (function (){var statearr_32693 = f__30147__auto__.call(null);
(statearr_32693[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto__);

return statearr_32693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto__))
);

return c__30146__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args32720 = [];
var len__28248__auto___32723 = arguments.length;
var i__28249__auto___32724 = (0);
while(true){
if((i__28249__auto___32724 < len__28248__auto___32723)){
args32720.push((arguments[i__28249__auto___32724]));

var G__32725 = (i__28249__auto___32724 + (1));
i__28249__auto___32724 = G__32725;
continue;
} else {
}
break;
}

var G__32722 = args32720.length;
switch (G__32722) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32720.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args32727 = [];
var len__28248__auto___32730 = arguments.length;
var i__28249__auto___32731 = (0);
while(true){
if((i__28249__auto___32731 < len__28248__auto___32730)){
args32727.push((arguments[i__28249__auto___32731]));

var G__32732 = (i__28249__auto___32731 + (1));
i__28249__auto___32731 = G__32732;
continue;
} else {
}
break;
}

var G__32729 = args32727.length;
switch (G__32729) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32727.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args32734 = [];
var len__28248__auto___32785 = arguments.length;
var i__28249__auto___32786 = (0);
while(true){
if((i__28249__auto___32786 < len__28248__auto___32785)){
args32734.push((arguments[i__28249__auto___32786]));

var G__32787 = (i__28249__auto___32786 + (1));
i__28249__auto___32786 = G__32787;
continue;
} else {
}
break;
}

var G__32736 = args32734.length;
switch (G__32736) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32734.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30146__auto___32789 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32789,out){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32789,out){
return (function (state_32760){
var state_val_32761 = (state_32760[(1)]);
if((state_val_32761 === (7))){
var inst_32755 = (state_32760[(2)]);
var state_32760__$1 = state_32760;
var statearr_32762_32790 = state_32760__$1;
(statearr_32762_32790[(2)] = inst_32755);

(statearr_32762_32790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32761 === (1))){
var inst_32737 = null;
var state_32760__$1 = (function (){var statearr_32763 = state_32760;
(statearr_32763[(7)] = inst_32737);

return statearr_32763;
})();
var statearr_32764_32791 = state_32760__$1;
(statearr_32764_32791[(2)] = null);

(statearr_32764_32791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32761 === (4))){
var inst_32740 = (state_32760[(8)]);
var inst_32740__$1 = (state_32760[(2)]);
var inst_32741 = (inst_32740__$1 == null);
var inst_32742 = cljs.core.not.call(null,inst_32741);
var state_32760__$1 = (function (){var statearr_32765 = state_32760;
(statearr_32765[(8)] = inst_32740__$1);

return statearr_32765;
})();
if(inst_32742){
var statearr_32766_32792 = state_32760__$1;
(statearr_32766_32792[(1)] = (5));

} else {
var statearr_32767_32793 = state_32760__$1;
(statearr_32767_32793[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32761 === (6))){
var state_32760__$1 = state_32760;
var statearr_32768_32794 = state_32760__$1;
(statearr_32768_32794[(2)] = null);

(statearr_32768_32794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32761 === (3))){
var inst_32757 = (state_32760[(2)]);
var inst_32758 = cljs.core.async.close_BANG_.call(null,out);
var state_32760__$1 = (function (){var statearr_32769 = state_32760;
(statearr_32769[(9)] = inst_32757);

return statearr_32769;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32760__$1,inst_32758);
} else {
if((state_val_32761 === (2))){
var state_32760__$1 = state_32760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32760__$1,(4),ch);
} else {
if((state_val_32761 === (11))){
var inst_32740 = (state_32760[(8)]);
var inst_32749 = (state_32760[(2)]);
var inst_32737 = inst_32740;
var state_32760__$1 = (function (){var statearr_32770 = state_32760;
(statearr_32770[(7)] = inst_32737);

(statearr_32770[(10)] = inst_32749);

return statearr_32770;
})();
var statearr_32771_32795 = state_32760__$1;
(statearr_32771_32795[(2)] = null);

(statearr_32771_32795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32761 === (9))){
var inst_32740 = (state_32760[(8)]);
var state_32760__$1 = state_32760;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32760__$1,(11),out,inst_32740);
} else {
if((state_val_32761 === (5))){
var inst_32737 = (state_32760[(7)]);
var inst_32740 = (state_32760[(8)]);
var inst_32744 = cljs.core._EQ_.call(null,inst_32740,inst_32737);
var state_32760__$1 = state_32760;
if(inst_32744){
var statearr_32773_32796 = state_32760__$1;
(statearr_32773_32796[(1)] = (8));

} else {
var statearr_32774_32797 = state_32760__$1;
(statearr_32774_32797[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32761 === (10))){
var inst_32752 = (state_32760[(2)]);
var state_32760__$1 = state_32760;
var statearr_32775_32798 = state_32760__$1;
(statearr_32775_32798[(2)] = inst_32752);

(statearr_32775_32798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32761 === (8))){
var inst_32737 = (state_32760[(7)]);
var tmp32772 = inst_32737;
var inst_32737__$1 = tmp32772;
var state_32760__$1 = (function (){var statearr_32776 = state_32760;
(statearr_32776[(7)] = inst_32737__$1);

return statearr_32776;
})();
var statearr_32777_32799 = state_32760__$1;
(statearr_32777_32799[(2)] = null);

(statearr_32777_32799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32789,out))
;
return ((function (switch__30032__auto__,c__30146__auto___32789,out){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32781 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32781[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32781[(1)] = (1));

return statearr_32781;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32760){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32782){if((e32782 instanceof Object)){
var ex__30036__auto__ = e32782;
var statearr_32783_32800 = state_32760;
(statearr_32783_32800[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32782;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32801 = state_32760;
state_32760 = G__32801;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32760){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32789,out))
})();
var state__30148__auto__ = (function (){var statearr_32784 = f__30147__auto__.call(null);
(statearr_32784[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32789);

return statearr_32784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32789,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args32802 = [];
var len__28248__auto___32872 = arguments.length;
var i__28249__auto___32873 = (0);
while(true){
if((i__28249__auto___32873 < len__28248__auto___32872)){
args32802.push((arguments[i__28249__auto___32873]));

var G__32874 = (i__28249__auto___32873 + (1));
i__28249__auto___32873 = G__32874;
continue;
} else {
}
break;
}

var G__32804 = args32802.length;
switch (G__32804) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32802.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30146__auto___32876 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32876,out){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32876,out){
return (function (state_32842){
var state_val_32843 = (state_32842[(1)]);
if((state_val_32843 === (7))){
var inst_32838 = (state_32842[(2)]);
var state_32842__$1 = state_32842;
var statearr_32844_32877 = state_32842__$1;
(statearr_32844_32877[(2)] = inst_32838);

(statearr_32844_32877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (1))){
var inst_32805 = (new Array(n));
var inst_32806 = inst_32805;
var inst_32807 = (0);
var state_32842__$1 = (function (){var statearr_32845 = state_32842;
(statearr_32845[(7)] = inst_32806);

(statearr_32845[(8)] = inst_32807);

return statearr_32845;
})();
var statearr_32846_32878 = state_32842__$1;
(statearr_32846_32878[(2)] = null);

(statearr_32846_32878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (4))){
var inst_32810 = (state_32842[(9)]);
var inst_32810__$1 = (state_32842[(2)]);
var inst_32811 = (inst_32810__$1 == null);
var inst_32812 = cljs.core.not.call(null,inst_32811);
var state_32842__$1 = (function (){var statearr_32847 = state_32842;
(statearr_32847[(9)] = inst_32810__$1);

return statearr_32847;
})();
if(inst_32812){
var statearr_32848_32879 = state_32842__$1;
(statearr_32848_32879[(1)] = (5));

} else {
var statearr_32849_32880 = state_32842__$1;
(statearr_32849_32880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (15))){
var inst_32832 = (state_32842[(2)]);
var state_32842__$1 = state_32842;
var statearr_32850_32881 = state_32842__$1;
(statearr_32850_32881[(2)] = inst_32832);

(statearr_32850_32881[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (13))){
var state_32842__$1 = state_32842;
var statearr_32851_32882 = state_32842__$1;
(statearr_32851_32882[(2)] = null);

(statearr_32851_32882[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (6))){
var inst_32807 = (state_32842[(8)]);
var inst_32828 = (inst_32807 > (0));
var state_32842__$1 = state_32842;
if(cljs.core.truth_(inst_32828)){
var statearr_32852_32883 = state_32842__$1;
(statearr_32852_32883[(1)] = (12));

} else {
var statearr_32853_32884 = state_32842__$1;
(statearr_32853_32884[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (3))){
var inst_32840 = (state_32842[(2)]);
var state_32842__$1 = state_32842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32842__$1,inst_32840);
} else {
if((state_val_32843 === (12))){
var inst_32806 = (state_32842[(7)]);
var inst_32830 = cljs.core.vec.call(null,inst_32806);
var state_32842__$1 = state_32842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32842__$1,(15),out,inst_32830);
} else {
if((state_val_32843 === (2))){
var state_32842__$1 = state_32842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32842__$1,(4),ch);
} else {
if((state_val_32843 === (11))){
var inst_32822 = (state_32842[(2)]);
var inst_32823 = (new Array(n));
var inst_32806 = inst_32823;
var inst_32807 = (0);
var state_32842__$1 = (function (){var statearr_32854 = state_32842;
(statearr_32854[(7)] = inst_32806);

(statearr_32854[(8)] = inst_32807);

(statearr_32854[(10)] = inst_32822);

return statearr_32854;
})();
var statearr_32855_32885 = state_32842__$1;
(statearr_32855_32885[(2)] = null);

(statearr_32855_32885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (9))){
var inst_32806 = (state_32842[(7)]);
var inst_32820 = cljs.core.vec.call(null,inst_32806);
var state_32842__$1 = state_32842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32842__$1,(11),out,inst_32820);
} else {
if((state_val_32843 === (5))){
var inst_32806 = (state_32842[(7)]);
var inst_32807 = (state_32842[(8)]);
var inst_32815 = (state_32842[(11)]);
var inst_32810 = (state_32842[(9)]);
var inst_32814 = (inst_32806[inst_32807] = inst_32810);
var inst_32815__$1 = (inst_32807 + (1));
var inst_32816 = (inst_32815__$1 < n);
var state_32842__$1 = (function (){var statearr_32856 = state_32842;
(statearr_32856[(12)] = inst_32814);

(statearr_32856[(11)] = inst_32815__$1);

return statearr_32856;
})();
if(cljs.core.truth_(inst_32816)){
var statearr_32857_32886 = state_32842__$1;
(statearr_32857_32886[(1)] = (8));

} else {
var statearr_32858_32887 = state_32842__$1;
(statearr_32858_32887[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (14))){
var inst_32835 = (state_32842[(2)]);
var inst_32836 = cljs.core.async.close_BANG_.call(null,out);
var state_32842__$1 = (function (){var statearr_32860 = state_32842;
(statearr_32860[(13)] = inst_32835);

return statearr_32860;
})();
var statearr_32861_32888 = state_32842__$1;
(statearr_32861_32888[(2)] = inst_32836);

(statearr_32861_32888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (10))){
var inst_32826 = (state_32842[(2)]);
var state_32842__$1 = state_32842;
var statearr_32862_32889 = state_32842__$1;
(statearr_32862_32889[(2)] = inst_32826);

(statearr_32862_32889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32843 === (8))){
var inst_32806 = (state_32842[(7)]);
var inst_32815 = (state_32842[(11)]);
var tmp32859 = inst_32806;
var inst_32806__$1 = tmp32859;
var inst_32807 = inst_32815;
var state_32842__$1 = (function (){var statearr_32863 = state_32842;
(statearr_32863[(7)] = inst_32806__$1);

(statearr_32863[(8)] = inst_32807);

return statearr_32863;
})();
var statearr_32864_32890 = state_32842__$1;
(statearr_32864_32890[(2)] = null);

(statearr_32864_32890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32876,out))
;
return ((function (switch__30032__auto__,c__30146__auto___32876,out){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32868 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32868[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32868[(1)] = (1));

return statearr_32868;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32842){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32869){if((e32869 instanceof Object)){
var ex__30036__auto__ = e32869;
var statearr_32870_32891 = state_32842;
(statearr_32870_32891[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32892 = state_32842;
state_32842 = G__32892;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32842){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32876,out))
})();
var state__30148__auto__ = (function (){var statearr_32871 = f__30147__auto__.call(null);
(statearr_32871[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32876);

return statearr_32871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32876,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args32893 = [];
var len__28248__auto___32967 = arguments.length;
var i__28249__auto___32968 = (0);
while(true){
if((i__28249__auto___32968 < len__28248__auto___32967)){
args32893.push((arguments[i__28249__auto___32968]));

var G__32969 = (i__28249__auto___32968 + (1));
i__28249__auto___32968 = G__32969;
continue;
} else {
}
break;
}

var G__32895 = args32893.length;
switch (G__32895) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32893.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30146__auto___32971 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30146__auto___32971,out){
return (function (){
var f__30147__auto__ = (function (){var switch__30032__auto__ = ((function (c__30146__auto___32971,out){
return (function (state_32937){
var state_val_32938 = (state_32937[(1)]);
if((state_val_32938 === (7))){
var inst_32933 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
var statearr_32939_32972 = state_32937__$1;
(statearr_32939_32972[(2)] = inst_32933);

(statearr_32939_32972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (1))){
var inst_32896 = [];
var inst_32897 = inst_32896;
var inst_32898 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32937__$1 = (function (){var statearr_32940 = state_32937;
(statearr_32940[(7)] = inst_32898);

(statearr_32940[(8)] = inst_32897);

return statearr_32940;
})();
var statearr_32941_32973 = state_32937__$1;
(statearr_32941_32973[(2)] = null);

(statearr_32941_32973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (4))){
var inst_32901 = (state_32937[(9)]);
var inst_32901__$1 = (state_32937[(2)]);
var inst_32902 = (inst_32901__$1 == null);
var inst_32903 = cljs.core.not.call(null,inst_32902);
var state_32937__$1 = (function (){var statearr_32942 = state_32937;
(statearr_32942[(9)] = inst_32901__$1);

return statearr_32942;
})();
if(inst_32903){
var statearr_32943_32974 = state_32937__$1;
(statearr_32943_32974[(1)] = (5));

} else {
var statearr_32944_32975 = state_32937__$1;
(statearr_32944_32975[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (15))){
var inst_32927 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
var statearr_32945_32976 = state_32937__$1;
(statearr_32945_32976[(2)] = inst_32927);

(statearr_32945_32976[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (13))){
var state_32937__$1 = state_32937;
var statearr_32946_32977 = state_32937__$1;
(statearr_32946_32977[(2)] = null);

(statearr_32946_32977[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (6))){
var inst_32897 = (state_32937[(8)]);
var inst_32922 = inst_32897.length;
var inst_32923 = (inst_32922 > (0));
var state_32937__$1 = state_32937;
if(cljs.core.truth_(inst_32923)){
var statearr_32947_32978 = state_32937__$1;
(statearr_32947_32978[(1)] = (12));

} else {
var statearr_32948_32979 = state_32937__$1;
(statearr_32948_32979[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (3))){
var inst_32935 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32937__$1,inst_32935);
} else {
if((state_val_32938 === (12))){
var inst_32897 = (state_32937[(8)]);
var inst_32925 = cljs.core.vec.call(null,inst_32897);
var state_32937__$1 = state_32937;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32937__$1,(15),out,inst_32925);
} else {
if((state_val_32938 === (2))){
var state_32937__$1 = state_32937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32937__$1,(4),ch);
} else {
if((state_val_32938 === (11))){
var inst_32901 = (state_32937[(9)]);
var inst_32905 = (state_32937[(10)]);
var inst_32915 = (state_32937[(2)]);
var inst_32916 = [];
var inst_32917 = inst_32916.push(inst_32901);
var inst_32897 = inst_32916;
var inst_32898 = inst_32905;
var state_32937__$1 = (function (){var statearr_32949 = state_32937;
(statearr_32949[(11)] = inst_32917);

(statearr_32949[(12)] = inst_32915);

(statearr_32949[(7)] = inst_32898);

(statearr_32949[(8)] = inst_32897);

return statearr_32949;
})();
var statearr_32950_32980 = state_32937__$1;
(statearr_32950_32980[(2)] = null);

(statearr_32950_32980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (9))){
var inst_32897 = (state_32937[(8)]);
var inst_32913 = cljs.core.vec.call(null,inst_32897);
var state_32937__$1 = state_32937;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32937__$1,(11),out,inst_32913);
} else {
if((state_val_32938 === (5))){
var inst_32898 = (state_32937[(7)]);
var inst_32901 = (state_32937[(9)]);
var inst_32905 = (state_32937[(10)]);
var inst_32905__$1 = f.call(null,inst_32901);
var inst_32906 = cljs.core._EQ_.call(null,inst_32905__$1,inst_32898);
var inst_32907 = cljs.core.keyword_identical_QMARK_.call(null,inst_32898,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32908 = (inst_32906) || (inst_32907);
var state_32937__$1 = (function (){var statearr_32951 = state_32937;
(statearr_32951[(10)] = inst_32905__$1);

return statearr_32951;
})();
if(cljs.core.truth_(inst_32908)){
var statearr_32952_32981 = state_32937__$1;
(statearr_32952_32981[(1)] = (8));

} else {
var statearr_32953_32982 = state_32937__$1;
(statearr_32953_32982[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (14))){
var inst_32930 = (state_32937[(2)]);
var inst_32931 = cljs.core.async.close_BANG_.call(null,out);
var state_32937__$1 = (function (){var statearr_32955 = state_32937;
(statearr_32955[(13)] = inst_32930);

return statearr_32955;
})();
var statearr_32956_32983 = state_32937__$1;
(statearr_32956_32983[(2)] = inst_32931);

(statearr_32956_32983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (10))){
var inst_32920 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
var statearr_32957_32984 = state_32937__$1;
(statearr_32957_32984[(2)] = inst_32920);

(statearr_32957_32984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32938 === (8))){
var inst_32897 = (state_32937[(8)]);
var inst_32901 = (state_32937[(9)]);
var inst_32905 = (state_32937[(10)]);
var inst_32910 = inst_32897.push(inst_32901);
var tmp32954 = inst_32897;
var inst_32897__$1 = tmp32954;
var inst_32898 = inst_32905;
var state_32937__$1 = (function (){var statearr_32958 = state_32937;
(statearr_32958[(7)] = inst_32898);

(statearr_32958[(14)] = inst_32910);

(statearr_32958[(8)] = inst_32897__$1);

return statearr_32958;
})();
var statearr_32959_32985 = state_32937__$1;
(statearr_32959_32985[(2)] = null);

(statearr_32959_32985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30146__auto___32971,out))
;
return ((function (switch__30032__auto__,c__30146__auto___32971,out){
return (function() {
var cljs$core$async$state_machine__30033__auto__ = null;
var cljs$core$async$state_machine__30033__auto____0 = (function (){
var statearr_32963 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32963[(0)] = cljs$core$async$state_machine__30033__auto__);

(statearr_32963[(1)] = (1));

return statearr_32963;
});
var cljs$core$async$state_machine__30033__auto____1 = (function (state_32937){
while(true){
var ret_value__30034__auto__ = (function (){try{while(true){
var result__30035__auto__ = switch__30032__auto__.call(null,state_32937);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30035__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30035__auto__;
}
break;
}
}catch (e32964){if((e32964 instanceof Object)){
var ex__30036__auto__ = e32964;
var statearr_32965_32986 = state_32937;
(statearr_32965_32986[(5)] = ex__30036__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32937);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32964;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32987 = state_32937;
state_32937 = G__32987;
continue;
} else {
return ret_value__30034__auto__;
}
break;
}
});
cljs$core$async$state_machine__30033__auto__ = function(state_32937){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30033__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30033__auto____1.call(this,state_32937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30033__auto____0;
cljs$core$async$state_machine__30033__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30033__auto____1;
return cljs$core$async$state_machine__30033__auto__;
})()
;})(switch__30032__auto__,c__30146__auto___32971,out))
})();
var state__30148__auto__ = (function (){var statearr_32966 = f__30147__auto__.call(null);
(statearr_32966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30146__auto___32971);

return statearr_32966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30148__auto__);
});})(c__30146__auto___32971,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map