import gnu.trove.list.TLinkableAdapter;

public final class Feature extends TLinkableAdapter<Feature> {
  public int index;
  public double value;

  public Feature (int i, double v) {
    index = i;
    value = v;
  }

  public final Feature clone () {
    return new Feature(index, value);
  }

  public final Feature negation () {
    return new Feature(index, -value);
  }

  public final String toString() {
    return index + "=" + value;
  }
}
