(ns sam-diff.schema
  (:require [schema.core :as s]))

;;; Note indexes are from the right of the string/sequence
(s/defschema diff-info
  (s/conditional
    #(= (:type %) :string)
    {:levenshtein                  s/Int
     :type                         (s/eq :string)
     :a                            s/Str
     (s/optional-key :inserted)    {s/Int [char]} ;; can be [[s/Char]] or [s/Char]
     (s/optional-key :deleted)     {s/Int char}}

    #(= (:type %) :atom)
    {:levenshtein                  s/Int
     :type                         (s/eq :atom)
     :a                            s/Any
     (s/optional-key :inserted)    s/Any
     (s/optional-key :deleted)     s/Any}

    #(= (:type %) :seq)
    {:levenshtein s/Int
     :type        (s/eq :seq)
     :a           [s/Any]
     (s/optional-key :inserted)    {s/Int [s/Any]} ;; can be [[s/Any]] or [s/Any]
     (s/optional-key :deleted)     {s/Int s/Any}
     (s/optional-key :modified)    {s/Int (s/recursive #'diff-info)}}

    #(= (:type %) :map)
    {:levenshtein s/Int
     :type        (s/eq :map)
     :a           {s/Any s/Any}
     (s/optional-key :inserted )   {s/Any s/Any} ;; note not a seq of any
     (s/optional-key :deleted )    {s/Any s/Any}
     (s/optional-key :modified)    {s/Any (s/recursive #'diff-info)}}

    #(= (:type %) :set)
    {:levenshtein s/Int
     :type        (s/eq :set)
     :a           #{s/Any}
     (s/optional-key :inserted)    #{s/Any}
     (s/optional-key :deleted)     #{s/Any}}))

(def diff-info-validator
  (s/validator diff-info))
