/*
 * Decompiled with CFR 0.152.
 */
package info.bowyer.sam_diff_java;

import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.RT;
import info.bowyer.sam_diff_java.CostAndType;
import info.bowyer.sam_diff_java.Diff;
import info.bowyer.sam_diff_java.DiffInfo;
import info.bowyer.sam_diff_java.Type;
import java.util.HashSet;
import java.util.Set;

public class SetDiff
implements Diff {
    @Override
    public DiffInfo diff(Object a, Object b, Diff diff, CostAndType costAndType) {
        Object item;
        IPersistentSet aSet = (IPersistentSet)a;
        IPersistentSet bSet = (IPersistentSet)b;
        ISeq aSeq = RT.seq((Object)a);
        HashSet<Object> inserted = new HashSet<Object>();
        HashSet<Object> deleted = new HashSet<Object>();
        int cost = 0;
        for (ISeq bSeq = RT.seq((Object)b); bSeq != null; bSeq = bSeq.next()) {
            item = bSeq.first();
            if (aSet.contains(item)) continue;
            inserted.add(item);
            cost += costAndType.get((Object)item).cost;
        }
        while (aSeq != null) {
            item = aSeq.first();
            if (!bSet.contains(item)) {
                deleted.add(item);
                cost += costAndType.get((Object)item).cost;
            }
            aSeq = aSeq.next();
        }
        return new SetDiffInfo(inserted, deleted, cost, aSet, bSet);
    }

    public static class SetDiffInfo
    implements DiffInfo {
        private final Set<Object> inserted;
        private final Set<Object> deleted;
        private final int distance;
        private final IPersistentSet a;
        private final IPersistentSet b;

        public SetDiffInfo(Set<Object> inserted, Set<Object> deleted, int distance, IPersistentSet a, IPersistentSet b) {
            this.inserted = inserted;
            this.deleted = deleted;
            this.distance = distance;
            this.a = a;
            this.b = b;
        }

        @Override
        public Type getType() {
            return Type.Set;
        }

        @Override
        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return "MapDiffInfo{, inserted=" + this.inserted + ", deleted=" + this.deleted + ", distance=" + this.distance + '}';
        }

        public IPersistentSet getA() {
            return this.a;
        }

        public IPersistentSet getB() {
            return this.b;
        }

        public Set<Object> getInserted() {
            return this.inserted;
        }

        public Set<Object> getDeleted() {
            return this.deleted;
        }
    }
}

