/*
 * Decompiled with CFR 0.152.
 */
package info.bowyer.sam_diff_java;

import info.bowyer.sam_diff_java.CostAndType;
import info.bowyer.sam_diff_java.Diff;
import info.bowyer.sam_diff_java.DiffInfo;
import info.bowyer.sam_diff_java.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MeyerString {
    public static int editDistance(String a, String b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        int i = 0;
        int n = a.length();
        int m = b.length();
        int max = n + m;
        int[] v = new int[2 * max + 1];
        for (int d = 0; d <= max; ++d) {
            int kMin = -d;
            if (kMin < -m) {
                kMin = -m;
                if ((d - m) % 2 != 0) {
                    // empty if block
                }
            }
            int kMax = Integer.min(n, d);
            for (int k = ++kMin; k <= kMax; k += 2) {
                int x = k == kMin || k != kMax && v[k - 1 + max] < v[k + 1 + max] ? v[k + 1 + max] : v[k - 1 + max] + 1;
                int y = x - k;
                ++i;
                while (x < n && y < m && a.charAt(x) == b.charAt(y)) {
                    ++x;
                    ++y;
                    ++i;
                }
                v[k + max] = x;
                if (x < n || y < m) continue;
                return d;
            }
        }
        return 0;
    }

    static boolean isOdd(int n) {
        return n % 2 != 0;
    }

    static boolean isEven(int n) {
        return n % 2 == 0;
    }

    static SnakeInfo getMiddleSnakeImpl(String a, String b, SnakeInfo result, int initX, int initY, int n, int m) {
        int \u03b4 = n - m;
        int forwardOffset = n + m;
        int backwardOffset = n + m - \u03b4;
        Arrays.fill(result.vForward, -1);
        Arrays.fill(result.vBackward, n + 2);
        result.vForward[forwardOffset + 0 + 1] = 0;
        result.vBackward[backwardOffset + \u03b4 + 1] = n + 1;
        for (int d = 0; d <= (n + m + 1) / 2; ++d) {
            int y;
            int x;
            int k;
            for (k = -d; k <= d; k += 2) {
                x = k == -d || k != d && result.vForward[k - 1 + forwardOffset] < result.vForward[k + 1 + forwardOffset] ? result.vForward[k + 1 + forwardOffset] : result.vForward[k - 1 + forwardOffset] + 1;
                y = x - k;
                ++result.i;
                int startX = x;
                int startY = y;
                while (x < n && y < m && a.charAt(initX + x) == b.charAt(initY + y)) {
                    ++x;
                    ++y;
                    ++result.i;
                }
                result.vForward[k + forwardOffset] = x;
                if (!MeyerString.isOdd(\u03b4) || d < 1 || k < \u03b4 - d - 1 || k > \u03b4 + d - 1 || result.vBackward[k + backwardOffset] > result.vForward[k + forwardOffset]) continue;
                result.distance = 2 * d - 1;
                result.x = initX + startX;
                result.y = initY + startY;
                result.u = initX + x;
                result.v = initY + y;
                return result;
            }
            for (k = -d + \u03b4; k <= d + \u03b4; k += 2) {
                x = k == -d + \u03b4 || k != d + \u03b4 && result.vBackward[k - 1 + backwardOffset] >= result.vBackward[k + 1 + backwardOffset] ? result.vBackward[k + 1 + backwardOffset] - 1 : result.vBackward[k - 1 + backwardOffset];
                y = x - k;
                ++result.i;
                int endX = x;
                int endY = y;
                while (x > 0 && y > 0 && a.charAt(initX + x - 1) == b.charAt(initY + y - 1)) {
                    --x;
                    --y;
                    ++result.i;
                }
                result.vBackward[k + backwardOffset] = x;
                if (!MeyerString.isEven(\u03b4) || k < -d || k > d || result.vBackward[k + backwardOffset] > result.vForward[k + forwardOffset]) continue;
                result.distance = 2 * d;
                result.x = initX + x;
                result.y = initY + y;
                result.u = initX + endX;
                result.v = initY + endY;
                return result;
            }
        }
        throw new RuntimeException("Error");
    }

    public static int bidirectionalEditDistance(String a, String b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        SnakeInfo snakeInfo = new SnakeInfo();
        int n = a.length();
        int m = b.length();
        int max = n + m;
        snakeInfo.vForward = new int[2 * max + 1];
        snakeInfo.vBackward = new int[2 * max + 1];
        int distance = MeyerString.getMiddleSnakeImpl((String)a, (String)b, (SnakeInfo)snakeInfo, (int)0, (int)0, (int)n, (int)m).distance;
        return distance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int diffsImpl(String a, String b, SnakeInfo snakeInfo, int startX, int startY, int endX, int endY, MeyerStringDiffInfo diffInfo) {
        int n = endX - startX;
        int m = endY - startY;
        if (n <= 0) {
            for (int j = startY + 1; j <= endY; ++j) {
                diffInfo.editInstructions.add(new EditInstruction(EditType.INSERT, startX, j));
            }
            return m;
        }
        if (m <= 0) {
            for (int i = startX + 1; i <= endX; ++i) {
                diffInfo.editInstructions.add(new EditInstruction(EditType.DELETE, i, startY));
            }
            return m;
        }
        MeyerString.getMiddleSnakeImpl(a, b, snakeInfo, startX, startY, n, m);
        int distance = snakeInfo.distance;
        int x = snakeInfo.x;
        int y = snakeInfo.y;
        int u = snakeInfo.u;
        int v = snakeInfo.v;
        if (distance > 1) {
            MeyerString.diffsImpl(a, b, snakeInfo, startX, startY, x, y, diffInfo);
            MeyerString.diffsImpl(a, b, snakeInfo, u, v, endX, endY, diffInfo);
            return distance;
        } else if (distance == 1) {
            if (m > n) {
                diffInfo.editInstructions.add(new EditInstruction(EditType.INSERT, x, y));
                return distance;
            } else {
                if (m >= n) throw new RuntimeException("Error");
                diffInfo.editInstructions.add(new EditInstruction(EditType.DELETE, x, y));
            }
            return distance;
        } else {
            if (distance != 0) return distance;
            throw new RuntimeException("Error");
        }
    }

    public static MeyerStringDiffInfo diff(String a, String b) {
        SnakeInfo snakeInfo = new SnakeInfo();
        int n = a.length();
        int m = b.length();
        int max = n + m;
        snakeInfo.vForward = new int[2 * max + 1];
        snakeInfo.vBackward = new int[2 * max + 1];
        MeyerStringDiffInfo diffInfo = new MeyerStringDiffInfo(a, b);
        int distance = MeyerString.diffsImpl(a, b, snakeInfo, 0, 0, n, m, diffInfo);
        diffInfo.setDistance(distance);
        return diffInfo;
    }

    public static class StringDiff
    implements Diff {
        @Override
        public DiffInfo diff(Object a, Object b, Diff _diff, CostAndType _costAndType) {
            return MeyerString.diff((String)a, (String)b);
        }
    }

    public static class MeyerStringDiffInfo
    implements DiffInfo {
        int distance;
        final List<EditInstruction> editInstructions;
        private final String a;
        private final String b;

        public MeyerStringDiffInfo(String a, String b) {
            this.a = a;
            this.b = b;
            this.editInstructions = new ArrayList<EditInstruction>();
        }

        @Override
        public Type getType() {
            return Type.MeyerString;
        }

        @Override
        public int getDistance() {
            return this.distance;
        }

        @Override
        public String getA() {
            return this.a;
        }

        @Override
        public String getB() {
            return this.b;
        }

        public List<EditInstruction> getEditInstructions() {
            return this.editInstructions;
        }

        public void setDistance(int distance) {
            this.distance = distance;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (EditInstruction instruction : this.editInstructions) {
                result.append(instruction.toString()).append("\n");
            }
            return "distance:" + this.distance + "\n" + result;
        }
    }

    public static class EditInstruction {
        final EditType type;
        final int x;
        final int y;

        public EditInstruction(EditType type, int x, int y) {
            this.type = type;
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "type: " + (Object)((Object)this.type) + " x: " + this.x + " y: " + this.y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public EditType getType() {
            return this.type;
        }
    }

    public static enum EditType {
        INSERT,
        DELETE;

    }

    public static class SnakeInfo {
        public int i;
        public int x;
        public int y;
        public int u;
        public int v;
        public int distance;
        public int[] vForward;
        public int[] vBackward;

        public String toString() {
            return "x:" + this.x + " y: " + this.y + " u:" + this.u + " v:" + this.v + " distance: " + this.distance;
        }
    }
}

