/*
 * Decompiled with CFR 0.152.
 */
package info.bowyer.sam_diff_java;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import info.bowyer.sam_diff_java.CostAndType;
import info.bowyer.sam_diff_java.Diff;
import info.bowyer.sam_diff_java.DiffInfo;
import info.bowyer.sam_diff_java.Type;
import java.util.HashMap;
import java.util.Map;

public class MapDiff
implements Diff {
    @Override
    public DiffInfo diff(Object a, Object b, Diff diff, CostAndType costAndType) {
        Object key;
        IMapEntry entry;
        IPersistentMap aMap = (IPersistentMap)a;
        IPersistentMap bMap = (IPersistentMap)b;
        HashMap<Object, DiffInfo> modified = new HashMap<Object, DiffInfo>();
        HashMap<Object, Object> inserted = new HashMap<Object, Object>();
        HashMap<Object, Object> deleted = new HashMap<Object, Object>();
        int cost = 0;
        for (Object obj : bMap) {
            entry = (IMapEntry)obj;
            key = entry.key();
            if (aMap.containsKey(key)) {
                DiffInfo diffInfo = diff.diff(aMap.valAt(key), bMap.valAt(key), diff, costAndType);
                if (diffInfo == null) continue;
                modified.put(key, diffInfo);
                cost += diffInfo.getDistance();
                continue;
            }
            Object bValue = entry.val();
            inserted.put(key, bValue);
            cost += costAndType.get((Object)bValue).cost;
        }
        for (Object obj : aMap) {
            entry = (IMapEntry)obj;
            key = entry.key();
            if (bMap.containsKey(key)) continue;
            Object aValue = entry.val();
            deleted.put(key, aValue);
            cost += costAndType.get((Object)aValue).cost;
        }
        return new MapDiffInfo(modified, inserted, deleted, cost, aMap, bMap);
    }

    public static class MapDiffInfo
    implements DiffInfo {
        private final Map<Object, DiffInfo> modified;
        private final Map<Object, Object> inserted;
        private final Map<Object, Object> deleted;
        private final int distance;
        private final IPersistentMap a;
        private final IPersistentMap b;

        public MapDiffInfo(Map<Object, DiffInfo> modified, Map<Object, Object> inserted, Map<Object, Object> deleted, int distance, IPersistentMap a, IPersistentMap b) {
            this.modified = modified;
            this.inserted = inserted;
            this.deleted = deleted;
            this.distance = distance;
            this.a = a;
            this.b = b;
        }

        @Override
        public Type getType() {
            return Type.Map;
        }

        @Override
        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return "MapDiffInfo{modified=" + this.modified + ", inserted=" + this.inserted + ", deleted=" + this.deleted + ", distance=" + this.distance + '}';
        }

        public IPersistentMap getA() {
            return this.a;
        }

        public IPersistentMap getB() {
            return this.b;
        }

        public Map<Object, DiffInfo> getModified() {
            return this.modified;
        }

        public Map<Object, Object> getInserted() {
            return this.inserted;
        }

        public Map<Object, Object> getDeleted() {
            return this.deleted;
        }
    }
}

