/*
 * Decompiled with CFR 0.152.
 */
package info.bowyer.sam_diff_java;

import clojure.lang.ISeq;
import clojure.lang.RT;
import info.bowyer.sam_diff_java.CostAndType;
import info.bowyer.sam_diff_java.Diff;
import info.bowyer.sam_diff_java.DiffInfo;
import info.bowyer.sam_diff_java.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;

public class DijkstraNonAtomicList {
    private static DijkstraNonAtomicListDiffInfo diff(Object aOriginal, Object bOriginal, List<Object> a, List<Object> b, Diff diff, CostAndType costAndType) {
        int targetX = a.size();
        int targetY = b.size();
        HashSet<QueueElement> reached = new HashSet<QueueElement>();
        PriorityQueue<QueueElement> priorityQueue = new PriorityQueue<QueueElement>();
        priorityQueue.add(new QueueElement(Direction.start, null, 0, 0, 0, null));
        while (true) {
            QueueElement next = (QueueElement)priorityQueue.poll();
            assert (next != null);
            int nextX = next.getX();
            int nextY = next.getY();
            int nextDistance = next.getDistance();
            if (next.getX() == targetX && next.getY() == targetY) {
                return new DijkstraNonAtomicListDiffInfo(next, aOriginal, bOriginal);
            }
            if (reached.contains(next)) continue;
            reached.add(next);
            if (nextX + 1 <= targetX && nextY + 1 <= targetY) {
                DiffInfo diffInfo = diff.diff(a.get(nextX), b.get(nextY), diff, costAndType);
                int cost = diffInfo == null ? 0 : diffInfo.getDistance();
                priorityQueue.add(new QueueElement(Direction.diagonal, next, nextX + 1, nextY + 1, nextDistance + cost, diffInfo));
            }
            if (nextX + 1 <= targetX) {
                int cost = costAndType.get((Object)a.get((int)nextX)).cost;
                priorityQueue.add(new QueueElement(Direction.horizontal, next, nextX + 1, nextY, nextDistance + cost, null));
            }
            if (nextY + 1 > targetY) continue;
            int cost = costAndType.get((Object)b.get((int)nextY)).cost;
            priorityQueue.add(new QueueElement(Direction.vertical, next, nextX, nextY + 1, nextDistance + cost, null));
        }
    }

    private static List<Object> seqToArryList(ISeq seq) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (seq != null) {
            list.add(seq.first());
            seq = seq.next();
        }
        return list;
    }

    public static class NonAtomicListDiff
    implements Diff {
        @Override
        public DiffInfo diff(Object a, Object b, Diff diff, CostAndType costAndType) {
            List aList = DijkstraNonAtomicList.seqToArryList(RT.seq((Object)a));
            List bList = DijkstraNonAtomicList.seqToArryList(RT.seq((Object)b));
            return DijkstraNonAtomicList.diff(a, b, aList, bList, diff, costAndType);
        }
    }

    public static class DijkstraNonAtomicListDiffInfo
    implements DiffInfo {
        private final QueueElement head;
        private final Object a;
        private final Object b;

        public DijkstraNonAtomicListDiffInfo(QueueElement head, Object a, Object b) {
            this.head = head;
            this.a = a;
            this.b = b;
        }

        @Override
        public Type getType() {
            return Type.DijkstraNonAtomicList;
        }

        @Override
        public int getDistance() {
            return this.head.getDistance();
        }

        @Override
        public Object getA() {
            return this.a;
        }

        @Override
        public Object getB() {
            return this.b;
        }

        public QueueElement getHead() {
            return this.head;
        }
    }

    public static class QueueElement
    implements Comparable<QueueElement> {
        private final Direction direction;
        private final QueueElement previousElement;
        private final int x;
        private final int y;
        private final int distance;
        private final DiffInfo diffInfo;

        QueueElement(Direction direction, QueueElement queueElement, int x, int y, int distance, DiffInfo diffInfo) {
            this.direction = direction;
            this.previousElement = queueElement;
            this.x = x;
            this.y = y;
            this.distance = distance;
            this.diffInfo = diffInfo;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getDistance() {
            return this.distance;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public QueueElement previousElement() {
            return this.previousElement;
        }

        public DiffInfo getDiffInfo() {
            return this.diffInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueueElement that = (QueueElement)o;
            return this.x == that.x && this.y == that.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        @Override
        public int compareTo(QueueElement o) {
            return Integer.compare(this.distance, o.distance);
        }

        public String toString() {
            return "x:" + this.x + " y: " + this.y + " distance: " + this.distance;
        }
    }

    public static enum Direction {
        start,
        horizontal,
        diagonal,
        vertical;

    }
}

