/*
 * Decompiled with CFR 0.152.
 */
package info.bowyer.sam_diff_java;

import info.bowyer.sam_diff_java.CostAndType;
import info.bowyer.sam_diff_java.Diff;
import info.bowyer.sam_diff_java.DiffInfo;
import java.util.Objects;

public class DiffStrategy
implements Diff {
    final Diff stringDiff;
    final Diff nonAtomicListDiff;
    final Diff atomDiff;
    final Diff mapDiff;
    final Diff setDiff;

    public DiffStrategy(Diff stringDiff, Diff nonAtomicListDiff, Diff atomDiff, Diff mapDiff, Diff setDiff) {
        this.stringDiff = stringDiff;
        this.nonAtomicListDiff = nonAtomicListDiff;
        this.atomDiff = atomDiff;
        this.mapDiff = mapDiff;
        this.setDiff = setDiff;
    }

    @Override
    public DiffInfo diff(Object a, Object b, Diff diff, CostAndType costAndType) {
        assert (diff == this);
        CostAndType.Type typeA = costAndType.get((Object)a).type;
        CostAndType.Type typeB = costAndType.get((Object)b).type;
        if (typeA == typeB && Objects.equals(a, b)) {
            return null;
        }
        if (typeA == CostAndType.Type.String && typeB == CostAndType.Type.String) {
            return this.stringDiff.diff(a, b, diff, costAndType);
        }
        if (typeA == CostAndType.Type.NonAtomicList && typeB == CostAndType.Type.NonAtomicList) {
            return this.nonAtomicListDiff.diff(a, b, diff, costAndType);
        }
        if (typeA == CostAndType.Type.Map && typeB == CostAndType.Type.Map) {
            return this.mapDiff.diff(a, b, diff, costAndType);
        }
        if (typeA == CostAndType.Type.Set && typeB == CostAndType.Type.Set) {
            return this.setDiff.diff(a, b, diff, costAndType);
        }
        return this.atomDiff.diff(a, b, diff, costAndType);
    }
}

