/*
 * Decompiled with CFR 0.152.
 */
package info.bowyer.sam_diff_java;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.RT;
import info.bowyer.sam_diff_java.CostAndType;
import java.util.HashMap;
import java.util.Map;

public class CostAndTypeImpl
implements CostAndType {
    Map<Object, CostAndType.Info> cache = new HashMap<Object, CostAndType.Info>();

    private static CostAndType.Type getType(Object o) {
        if (o instanceof String) {
            return CostAndType.Type.String;
        }
        if (o instanceof ISeq || o instanceof IPersistentVector) {
            return CostAndType.Type.NonAtomicList;
        }
        if (o instanceof IPersistentMap) {
            return CostAndType.Type.Map;
        }
        if (o instanceof IPersistentSet) {
            return CostAndType.Type.Set;
        }
        if (o == null) {
            return CostAndType.Type.Null;
        }
        return CostAndType.Type.Atom;
    }

    private int process(Object data) {
        CostAndType.Info info = this.cache.get(data);
        if (info != null) {
            return info.cost;
        }
        CostAndType.Type type = CostAndTypeImpl.getType(data);
        int cost = 0;
        switch (type) {
            case String: {
                cost = ((String)data).length();
                break;
            }
            case NonAtomicList: {
                for (ISeq seq = RT.seq((Object)data); seq != null; seq = seq.next()) {
                    cost += this.process(seq.first());
                }
                break;
            }
            case Map: {
                IPersistentMap map = (IPersistentMap)data;
                for (Object obj : map) {
                    IMapEntry entry = (IMapEntry)obj;
                    Object value = entry.val();
                    cost += this.process(value);
                }
                break;
            }
            case Set: {
                for (ISeq set = RT.seq((Object)data); set != null; set = set.next()) {
                    Object item = set.first();
                    cost += this.process(item);
                }
                break;
            }
            case Atom: {
                cost = 1;
                break;
            }
        }
        this.cache.put(data, new CostAndType.Info(cost, type));
        return cost;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, CostAndType.Info> entry : this.cache.entrySet()) {
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(" (");
            sb.append(entry.getValue().cost);
            sb.append(", ");
            sb.append((Object)entry.getValue().type);
            sb.append(")\n");
        }
        return sb.toString();
    }

    @Override
    public CostAndType.Info get(Object data) {
        CostAndType.Info result = this.cache.get(data);
        if (result == null) {
            throw new RuntimeException("No info for " + data);
        }
        return result;
    }

    public CostAndTypeImpl(Object a, Object b) {
        this.process(a);
        this.process(b);
    }
}

