/*
 * Decompiled with CFR 0.152.
 */
package info.bowyer.sam_diff_java;

import info.bowyer.sam_diff_java.CostAndType;
import info.bowyer.sam_diff_java.Diff;
import info.bowyer.sam_diff_java.DiffInfo;
import info.bowyer.sam_diff_java.Type;

public class Atom {

    public static class AtomDiff
    implements Diff {
        @Override
        public DiffInfo diff(Object a, Object b, Diff diff, CostAndType costAndType) {
            int aCost = costAndType.get((Object)a).cost;
            int bCost = costAndType.get((Object)b).cost;
            return new AtomDiffInfo(b, a, aCost + bCost);
        }
    }

    public static class AtomDiffInfo
    implements DiffInfo {
        private final Object inserted;
        private final Object deleted;
        private final int distance;

        public AtomDiffInfo(Object inserted, Object deleted, int distance) {
            this.inserted = inserted;
            this.deleted = deleted;
            this.distance = distance;
        }

        @Override
        public Type getType() {
            return Type.Atom;
        }

        @Override
        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return "AtomDiffInfo{inserted=" + this.inserted + ", deleted=" + this.deleted + ", distance=" + this.distance + '}';
        }

        @Override
        public Object getA() {
            return this.deleted;
        }

        @Override
        public Object getB() {
            return this.inserted;
        }

        public Object getInserted() {
            return this.inserted;
        }

        public Object getDeleted() {
            return this.deleted;
        }
    }
}

