/*
 * Decompiled with CFR 0.152.
 */
package rachbowyer;

import java.util.HashSet;
import java.util.Objects;
import java.util.PriorityQueue;
import rachbowyer.DiffInfo;
import rachbowyer.Type;

public class DijkstraString {
    private static DijkstraStringDiffInfo diff_impl(String a, String b) {
        int targetX = a.length();
        int targetY = b.length();
        HashSet<QueueElement> reached = new HashSet<QueueElement>();
        PriorityQueue<QueueElement> priorityQueue = new PriorityQueue<QueueElement>();
        priorityQueue.add(new QueueElement(Direction.start, null, 0, 0, 0));
        while (true) {
            QueueElement next = (QueueElement)priorityQueue.poll();
            assert (next != null);
            int nextX = next.getX();
            int nextY = next.getY();
            int nextDistance = next.getDistance();
            if (next.getX() == targetX && next.getY() == targetY) {
                return new DijkstraStringDiffInfo(next);
            }
            if (reached.contains(next)) continue;
            reached.add(next);
            if (nextX + 1 <= targetX && nextY + 1 <= targetY && a.charAt(nextX) == b.charAt(nextY)) {
                priorityQueue.add(new QueueElement(Direction.diagonal, next, nextX + 1, nextY + 1, nextDistance));
            }
            if (nextX + 1 <= targetX) {
                priorityQueue.add(new QueueElement(Direction.horizontal, next, nextX + 1, nextY, nextDistance + 1));
            }
            if (nextY + 1 > targetY) continue;
            priorityQueue.add(new QueueElement(Direction.vertical, next, nextX, nextY + 1, nextDistance + 1));
        }
    }

    public static DijkstraStringDiffInfo diff(String a, String b) {
        return DijkstraString.diff_impl(a, b);
    }

    public static class DijkstraStringDiffInfo
    implements DiffInfo {
        final QueueElement head;

        public DijkstraStringDiffInfo(QueueElement head) {
            this.head = head;
        }

        @Override
        public Type getType() {
            return Type.DijkstraString;
        }

        public QueueElement getHead() {
            return this.head;
        }
    }

    public static class QueueElement
    implements Comparable<QueueElement> {
        private final Direction direction;
        private final QueueElement previousElement;
        private final int x;
        private final int y;
        private final int distance;

        QueueElement(Direction direction, QueueElement queueElement, int x, int y, int distance) {
            this.direction = direction;
            this.previousElement = queueElement;
            this.x = x;
            this.y = y;
            this.distance = distance;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getDistance() {
            return this.distance;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public QueueElement previousElement() {
            return this.previousElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueueElement that = (QueueElement)o;
            return this.x == that.x && this.y == that.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        @Override
        public int compareTo(QueueElement o) {
            return Integer.compare(this.distance, o.distance);
        }

        public String toString() {
            return "x:" + this.x + " y: " + this.y + " distance: " + this.distance;
        }
    }

    public static enum Direction {
        start,
        horizontal,
        diagonal,
        vertical;

    }
}

