if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}

/**
 * @license
 * pixi.js - v2.2.9
 * Copyright (c) 2012-2014, Mat Groves
 * http://goodboydigital.com/
 *
 * Compiled: 2015-04-08
 *
 * pixi.js is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license.php
 */
(function(){var a=this,b=b||{};b.WEBGL_RENDERER=0,b.CANVAS_RENDERER=1,b.VERSION="v2.2.9",b.blendModes={NORMAL:0,ADD:1,MULTIPLY:2,SCREEN:3,OVERLAY:4,DARKEN:5,LIGHTEN:6,COLOR_DODGE:7,COLOR_BURN:8,HARD_LIGHT:9,SOFT_LIGHT:10,DIFFERENCE:11,EXCLUSION:12,HUE:13,SATURATION:14,COLOR:15,LUMINOSITY:16},b.scaleModes={DEFAULT:0,LINEAR:0,NEAREST:1},b._UID=0,"undefined"!=typeof Float32Array?(b.Float32Array=Float32Array,b.Uint16Array=Uint16Array,b.Uint32Array=Uint32Array,b.ArrayBuffer=ArrayBuffer):(b.Float32Array=Array,b.Uint16Array=Array),b.INTERACTION_FREQUENCY=30,b.AUTO_PREVENT_DEFAULT=!0,b.PI_2=2*Math.PI,b.RAD_TO_DEG=180/Math.PI,b.DEG_TO_RAD=Math.PI/180,b.RETINA_PREFIX="@2x",b.dontSayHello=!1,b.defaultRenderOptions={view:null,transparent:!1,antialias:!1,preserveDrawingBuffer:!1,resolution:1,clearBeforeRender:!0,autoResize:!1},b.sayHello=function(a){if(!b.dontSayHello){if(navigator.userAgent.toLowerCase().indexOf("chrome")>-1){var c=["%c %c %c Pixi.js "+b.VERSION+" - "+a+"  %c  %c  http://www.pixijs.com/  %c %c ♥%c♥%c♥ ","background: #ff66a5","background: #ff66a5","color: #ff66a5; background: #030307;","background: #ff66a5","background: #ffc3dc","background: #ff66a5","color: #ff2424; background: #fff","color: #ff2424; background: #fff","color: #ff2424; background: #fff"];console.log.apply(console,c)}else window.console&&console.log("Pixi.js "+b.VERSION+" - http://www.pixijs.com/");b.dontSayHello=!0}},b.Point=function(a,b){this.x=a||0,this.y=b||0},b.Point.prototype.clone=function(){return new b.Point(this.x,this.y)},b.Point.prototype.set=function(a,b){this.x=a||0,this.y=b||(0!==b?this.x:0)},b.Point.prototype.constructor=b.Point,b.Rectangle=function(a,b,c,d){this.x=a||0,this.y=b||0,this.width=c||0,this.height=d||0},b.Rectangle.prototype.clone=function(){return new b.Rectangle(this.x,this.y,this.width,this.height)},b.Rectangle.prototype.contains=function(a,b){if(this.width<=0||this.height<=0)return!1;var c=this.x;if(a>=c&&a<=c+this.width){var d=this.y;if(b>=d&&b<=d+this.height)return!0}return!1},b.Rectangle.prototype.constructor=b.Rectangle,b.EmptyRectangle=new b.Rectangle(0,0,0,0),b.Polygon=function(a){if(a instanceof Array||(a=Array.prototype.slice.call(arguments)),a[0]instanceof b.Point){for(var c=[],d=0,e=a.length;e>d;d++)c.push(a[d].x,a[d].y);a=c}this.closed=!0,this.points=a},b.Polygon.prototype.clone=function(){var a=this.points.slice();return new b.Polygon(a)},b.Polygon.prototype.contains=function(a,b){for(var c=!1,d=this.points.length/2,e=0,f=d-1;d>e;f=e++){var g=this.points[2*e],h=this.points[2*e+1],i=this.points[2*f],j=this.points[2*f+1],k=h>b!=j>b&&(i-g)*(b-h)/(j-h)+g>a;k&&(c=!c)}return c},b.Polygon.prototype.constructor=b.Polygon,b.Circle=function(a,b,c){this.x=a||0,this.y=b||0,this.radius=c||0},b.Circle.prototype.clone=function(){return new b.Circle(this.x,this.y,this.radius)},b.Circle.prototype.contains=function(a,b){if(this.radius<=0)return!1;var c=this.x-a,d=this.y-b,e=this.radius*this.radius;return c*=c,d*=d,e>=c+d},b.Circle.prototype.getBounds=function(){return new b.Rectangle(this.x-this.radius,this.y-this.radius,2*this.radius,2*this.radius)},b.Circle.prototype.constructor=b.Circle,b.Ellipse=function(a,b,c,d){this.x=a||0,this.y=b||0,this.width=c||0,this.height=d||0},b.Ellipse.prototype.clone=function(){return new b.Ellipse(this.x,this.y,this.width,this.height)},b.Ellipse.prototype.contains=function(a,b){if(this.width<=0||this.height<=0)return!1;var c=(a-this.x)/this.width,d=(b-this.y)/this.height;return c*=c,d*=d,1>=c+d},b.Ellipse.prototype.getBounds=function(){return new b.Rectangle(this.x-this.width,this.y-this.height,this.width,this.height)},b.Ellipse.prototype.constructor=b.Ellipse,b.RoundedRectangle=function(a,b,c,d,e){this.x=a||0,this.y=b||0,this.width=c||0,this.height=d||0,this.radius=e||20},b.RoundedRectangle.prototype.clone=function(){return new b.RoundedRectangle(this.x,this.y,this.width,this.height,this.radius)},b.RoundedRectangle.prototype.contains=function(a,b){if(this.width<=0||this.height<=0)return!1;var c=this.x;if(a>=c&&a<=c+this.width){var d=this.y;if(b>=d&&b<=d+this.height)return!0}return!1},b.RoundedRectangle.prototype.constructor=b.RoundedRectangle,b.Matrix=function(){this.a=1,this.b=0,this.c=0,this.d=1,this.tx=0,this.ty=0},b.Matrix.prototype.fromArray=function(a){this.a=a[0],this.b=a[1],this.c=a[3],this.d=a[4],this.tx=a[2],this.ty=a[5]},b.Matrix.prototype.toArray=function(a){this.array||(this.array=new b.Float32Array(9));var c=this.array;return a?(c[0]=this.a,c[1]=this.b,c[2]=0,c[3]=this.c,c[4]=this.d,c[5]=0,c[6]=this.tx,c[7]=this.ty,c[8]=1):(c[0]=this.a,c[1]=this.c,c[2]=this.tx,c[3]=this.b,c[4]=this.d,c[5]=this.ty,c[6]=0,c[7]=0,c[8]=1),c},b.Matrix.prototype.apply=function(a,c){return c=c||new b.Point,c.x=this.a*a.x+this.c*a.y+this.tx,c.y=this.b*a.x+this.d*a.y+this.ty,c},b.Matrix.prototype.applyInverse=function(a,c){c=c||new b.Point;var d=1/(this.a*this.d+this.c*-this.b);return c.x=this.d*d*a.x+-this.c*d*a.y+(this.ty*this.c-this.tx*this.d)*d,c.y=this.a*d*a.y+-this.b*d*a.x+(-this.ty*this.a+this.tx*this.b)*d,c},b.Matrix.prototype.translate=function(a,b){return this.tx+=a,this.ty+=b,this},b.Matrix.prototype.scale=function(a,b){return this.a*=a,this.d*=b,this.c*=a,this.b*=b,this.tx*=a,this.ty*=b,this},b.Matrix.prototype.rotate=function(a){var b=Math.cos(a),c=Math.sin(a),d=this.a,e=this.c,f=this.tx;return this.a=d*b-this.b*c,this.b=d*c+this.b*b,this.c=e*b-this.d*c,this.d=e*c+this.d*b,this.tx=f*b-this.ty*c,this.ty=f*c+this.ty*b,this},b.Matrix.prototype.append=function(a){var b=this.a,c=this.b,d=this.c,e=this.d;return this.a=a.a*b+a.b*d,this.b=a.a*c+a.b*e,this.c=a.c*b+a.d*d,this.d=a.c*c+a.d*e,this.tx=a.tx*b+a.ty*d+this.tx,this.ty=a.tx*c+a.ty*e+this.ty,this},b.Matrix.prototype.identity=function(){return this.a=1,this.b=0,this.c=0,this.d=1,this.tx=0,this.ty=0,this},b.identityMatrix=new b.Matrix,b.DisplayObject=function(){this.position=new b.Point,this.scale=new b.Point(1,1),this.pivot=new b.Point(0,0),this.rotation=0,this.alpha=1,this.visible=!0,this.hitArea=null,this.buttonMode=!1,this.renderable=!1,this.parent=null,this.stage=null,this.worldAlpha=1,this._interactive=!1,this.defaultCursor="pointer",this.worldTransform=new b.Matrix,this._sr=0,this._cr=1,this.filterArea=null,this._bounds=new b.Rectangle(0,0,1,1),this._currentBounds=null,this._mask=null,this._cacheAsBitmap=!1,this._cacheIsDirty=!1},b.DisplayObject.prototype.constructor=b.DisplayObject,Object.defineProperty(b.DisplayObject.prototype,"interactive",{get:function(){return this._interactive},set:function(a){this._interactive=a,this.stage&&(this.stage.dirty=!0)}}),Object.defineProperty(b.DisplayObject.prototype,"worldVisible",{get:function(){var a=this;do{if(!a.visible)return!1;a=a.parent}while(a);return!0}}),Object.defineProperty(b.DisplayObject.prototype,"mask",{get:function(){return this._mask},set:function(a){this._mask&&(this._mask.isMask=!1),this._mask=a,this._mask&&(this._mask.isMask=!0)}}),Object.defineProperty(b.DisplayObject.prototype,"filters",{get:function(){return this._filters},set:function(a){if(a){for(var b=[],c=0;c<a.length;c++)for(var d=a[c].passes,e=0;e<d.length;e++)b.push(d[e]);this._filterBlock={target:this,filterPasses:b}}this._filters=a}}),Object.defineProperty(b.DisplayObject.prototype,"cacheAsBitmap",{get:function(){return this._cacheAsBitmap},set:function(a){this._cacheAsBitmap!==a&&(a?this._generateCachedSprite():this._destroyCachedSprite(),this._cacheAsBitmap=a)}}),b.DisplayObject.prototype.updateTransform=function(){var a,c,d,e,f,g,h=this.parent.worldTransform,i=this.worldTransform;this.rotation%b.PI_2?(this.rotation!==this.rotationCache&&(this.rotationCache=this.rotation,this._sr=Math.sin(this.rotation),this._cr=Math.cos(this.rotation)),a=this._cr*this.scale.x,c=this._sr*this.scale.x,d=-this._sr*this.scale.y,e=this._cr*this.scale.y,f=this.position.x,g=this.position.y,(this.pivot.x||this.pivot.y)&&(f-=this.pivot.x*a+this.pivot.y*d,g-=this.pivot.x*c+this.pivot.y*e),i.a=a*h.a+c*h.c,i.b=a*h.b+c*h.d,i.c=d*h.a+e*h.c,i.d=d*h.b+e*h.d,i.tx=f*h.a+g*h.c+h.tx,i.ty=f*h.b+g*h.d+h.ty):(a=this.scale.x,e=this.scale.y,f=this.position.x-this.pivot.x*a,g=this.position.y-this.pivot.y*e,i.a=a*h.a,i.b=a*h.b,i.c=e*h.c,i.d=e*h.d,i.tx=f*h.a+g*h.c+h.tx,i.ty=f*h.b+g*h.d+h.ty),this.worldAlpha=this.alpha*this.parent.worldAlpha},b.DisplayObject.prototype.displayObjectUpdateTransform=b.DisplayObject.prototype.updateTransform,b.DisplayObject.prototype.getBounds=function(a){return a=a,b.EmptyRectangle},b.DisplayObject.prototype.getLocalBounds=function(){return this.getBounds(b.identityMatrix)},b.DisplayObject.prototype.setStageReference=function(a){this.stage=a,this._interactive&&(this.stage.dirty=!0)},b.DisplayObject.prototype.generateTexture=function(a,c,d){var e=this.getLocalBounds(),f=new b.RenderTexture(0|e.width,0|e.height,d,c,a);return b.DisplayObject._tempMatrix.tx=-e.x,b.DisplayObject._tempMatrix.ty=-e.y,f.render(this,b.DisplayObject._tempMatrix),f},b.DisplayObject.prototype.updateCache=function(){this._generateCachedSprite()},b.DisplayObject.prototype.toGlobal=function(a){return this.displayObjectUpdateTransform(),this.worldTransform.apply(a)},b.DisplayObject.prototype.toLocal=function(a,b){return b&&(a=b.toGlobal(a)),this.displayObjectUpdateTransform(),this.worldTransform.applyInverse(a)},b.DisplayObject.prototype._renderCachedSprite=function(a){this._cachedSprite.worldAlpha=this.worldAlpha,a.gl?b.Sprite.prototype._renderWebGL.call(this._cachedSprite,a):b.Sprite.prototype._renderCanvas.call(this._cachedSprite,a)},b.DisplayObject.prototype._generateCachedSprite=function(){this._cacheAsBitmap=!1;var a=this.getLocalBounds();if(this._cachedSprite)this._cachedSprite.texture.resize(0|a.width,0|a.height);else{var c=new b.RenderTexture(0|a.width,0|a.height);this._cachedSprite=new b.Sprite(c),this._cachedSprite.worldTransform=this.worldTransform}var d=this._filters;this._filters=null,this._cachedSprite.filters=d,b.DisplayObject._tempMatrix.tx=-a.x,b.DisplayObject._tempMatrix.ty=-a.y,this._cachedSprite.texture.render(this,b.DisplayObject._tempMatrix,!0),this._cachedSprite.anchor.x=-(a.x/a.width),this._cachedSprite.anchor.y=-(a.y/a.height),this._filters=d,this._cacheAsBitmap=!0},b.DisplayObject.prototype._destroyCachedSprite=function(){this._cachedSprite&&(this._cachedSprite.texture.destroy(!0),this._cachedSprite=null)},b.DisplayObject.prototype._renderWebGL=function(a){a=a},b.DisplayObject.prototype._renderCanvas=function(a){a=a},b.DisplayObject._tempMatrix=new b.Matrix,Object.defineProperty(b.DisplayObject.prototype,"x",{get:function(){return this.position.x},set:function(a){this.position.x=a}}),Object.defineProperty(b.DisplayObject.prototype,"y",{get:function(){return this.position.y},set:function(a){this.position.y=a}}),b.DisplayObjectContainer=function(){b.DisplayObject.call(this),this.children=[]},b.DisplayObjectContainer.prototype=Object.create(b.DisplayObject.prototype),b.DisplayObjectContainer.prototype.constructor=b.DisplayObjectContainer,Object.defineProperty(b.DisplayObjectContainer.prototype,"width",{get:function(){return this.scale.x*this.getLocalBounds().width},set:function(a){var b=this.getLocalBounds().width;this.scale.x=0!==b?a/b:1,this._width=a}}),Object.defineProperty(b.DisplayObjectContainer.prototype,"height",{get:function(){return this.scale.y*this.getLocalBounds().height},set:function(a){var b=this.getLocalBounds().height;this.scale.y=0!==b?a/b:1,this._height=a}}),b.DisplayObjectContainer.prototype.addChild=function(a){return this.addChildAt(a,this.children.length)},b.DisplayObjectContainer.prototype.addChildAt=function(a,b){if(b>=0&&b<=this.children.length)return a.parent&&a.parent.removeChild(a),a.parent=this,this.children.splice(b,0,a),this.stage&&a.setStageReference(this.stage),a;throw new Error(a+"addChildAt: The index "+b+" supplied is out of bounds "+this.children.length)},b.DisplayObjectContainer.prototype.swapChildren=function(a,b){if(a!==b){var c=this.getChildIndex(a),d=this.getChildIndex(b);if(0>c||0>d)throw new Error("swapChildren: Both the supplied DisplayObjects must be a child of the caller.");this.children[c]=b,this.children[d]=a}},b.DisplayObjectContainer.prototype.getChildIndex=function(a){var b=this.children.indexOf(a);if(-1===b)throw new Error("The supplied DisplayObject must be a child of the caller");return b},b.DisplayObjectContainer.prototype.setChildIndex=function(a,b){if(0>b||b>=this.children.length)throw new Error("The supplied index is out of bounds");var c=this.getChildIndex(a);this.children.splice(c,1),this.children.splice(b,0,a)},b.DisplayObjectContainer.prototype.getChildAt=function(a){if(0>a||a>=this.children.length)throw new Error("getChildAt: Supplied index "+a+" does not exist in the child list, or the supplied DisplayObject must be a child of the caller");return this.children[a]},b.DisplayObjectContainer.prototype.removeChild=function(a){var b=this.children.indexOf(a);if(-1!==b)return this.removeChildAt(b)},b.DisplayObjectContainer.prototype.removeChildAt=function(a){var b=this.getChildAt(a);return this.stage&&b.removeStageReference(),b.parent=void 0,this.children.splice(a,1),b},b.DisplayObjectContainer.prototype.removeChildren=function(a,b){var c=a||0,d="number"==typeof b?b:this.children.length,e=d-c;if(e>0&&d>=e){for(var f=this.children.splice(c,e),g=0;g<f.length;g++){var h=f[g];this.stage&&h.removeStageReference(),h.parent=void 0}return f}if(0===e&&0===this.children.length)return[];throw new Error("removeChildren: Range Error, numeric values are outside the acceptable range")},b.DisplayObjectContainer.prototype.updateTransform=function(){if(this.visible&&(this.displayObjectUpdateTransform(),!this._cacheAsBitmap))for(var a=0,b=this.children.length;b>a;a++)this.children[a].updateTransform()},b.DisplayObjectContainer.prototype.displayObjectContainerUpdateTransform=b.DisplayObjectContainer.prototype.updateTransform,b.DisplayObjectContainer.prototype.getBounds=function(){if(0===this.children.length)return b.EmptyRectangle;for(var a,c,d,e=1/0,f=1/0,g=-(1/0),h=-(1/0),i=!1,j=0,k=this.children.length;k>j;j++){var l=this.children[j];l.visible&&(i=!0,a=this.children[j].getBounds(),e=e<a.x?e:a.x,f=f<a.y?f:a.y,c=a.width+a.x,d=a.height+a.y,g=g>c?g:c,h=h>d?h:d)}if(!i)return b.EmptyRectangle;var m=this._bounds;return m.x=e,m.y=f,m.width=g-e,m.height=h-f,m},b.DisplayObjectContainer.prototype.getLocalBounds=function(){var a=this.worldTransform;this.worldTransform=b.identityMatrix;for(var c=0,d=this.children.length;d>c;c++)this.children[c].updateTransform();var e=this.getBounds();return this.worldTransform=a,e},b.DisplayObjectContainer.prototype.setStageReference=function(a){this.stage=a,this._interactive&&(this.stage.dirty=!0);for(var b=0,c=this.children.length;c>b;b++){var d=this.children[b];d.setStageReference(a)}},b.DisplayObjectContainer.prototype.removeStageReference=function(){for(var a=0,b=this.children.length;b>a;a++){var c=this.children[a];c.removeStageReference()}this._interactive&&(this.stage.dirty=!0),this.stage=null},b.DisplayObjectContainer.prototype._renderWebGL=function(a){if(this.visible&&!(this.alpha<=0)){if(this._cacheAsBitmap)return void this._renderCachedSprite(a);var b,c;if(this._mask||this._filters){for(this._filters&&(a.spriteBatch.flush(),a.filterManager.pushFilter(this._filterBlock)),this._mask&&(a.spriteBatch.stop(),a.maskManager.pushMask(this.mask,a),a.spriteBatch.start()),b=0,c=this.children.length;c>b;b++)this.children[b]._renderWebGL(a);a.spriteBatch.stop(),this._mask&&a.maskManager.popMask(this._mask,a),this._filters&&a.filterManager.popFilter(),a.spriteBatch.start()}else for(b=0,c=this.children.length;c>b;b++)this.children[b]._renderWebGL(a)}},b.DisplayObjectContainer.prototype._renderCanvas=function(a){if(this.visible!==!1&&0!==this.alpha){if(this._cacheAsBitmap)return void this._renderCachedSprite(a);this._mask&&a.maskManager.pushMask(this._mask,a);for(var b=0,c=this.children.length;c>b;b++){var d=this.children[b];d._renderCanvas(a)}this._mask&&a.maskManager.popMask(a)}},b.Sprite=function(a){b.DisplayObjectContainer.call(this),this.anchor=new b.Point,this.texture=a||b.Texture.emptyTexture,this._width=0,this._height=0,this.tint=16777215,this.blendMode=b.blendModes.NORMAL,this.shader=null,this.texture.baseTexture.hasLoaded?this.onTextureUpdate():this.texture.on("update",this.onTextureUpdate.bind(this)),this.renderable=!0},b.Sprite.prototype=Object.create(b.DisplayObjectContainer.prototype),b.Sprite.prototype.constructor=b.Sprite,Object.defineProperty(b.Sprite.prototype,"width",{get:function(){return this.scale.x*this.texture.frame.width},set:function(a){this.scale.x=a/this.texture.frame.width,this._width=a}}),Object.defineProperty(b.Sprite.prototype,"height",{get:function(){return this.scale.y*this.texture.frame.height},set:function(a){this.scale.y=a/this.texture.frame.height,this._height=a}}),b.Sprite.prototype.setTexture=function(a){this.texture=a,this.cachedTint=16777215},b.Sprite.prototype.onTextureUpdate=function(){this._width&&(this.scale.x=this._width/this.texture.frame.width),this._height&&(this.scale.y=this._height/this.texture.frame.height)},b.Sprite.prototype.getBounds=function(a){var b=this.texture.frame.width,c=this.texture.frame.height,d=b*(1-this.anchor.x),e=b*-this.anchor.x,f=c*(1-this.anchor.y),g=c*-this.anchor.y,h=a||this.worldTransform,i=h.a,j=h.b,k=h.c,l=h.d,m=h.tx,n=h.ty,o=-(1/0),p=-(1/0),q=1/0,r=1/0;if(0===j&&0===k)0>i&&(i*=-1),0>l&&(l*=-1),q=i*e+m,o=i*d+m,r=l*g+n,p=l*f+n;else{var s=i*e+k*g+m,t=l*g+j*e+n,u=i*d+k*g+m,v=l*g+j*d+n,w=i*d+k*f+m,x=l*f+j*d+n,y=i*e+k*f+m,z=l*f+j*e+n;q=q>s?s:q,q=q>u?u:q,q=q>w?w:q,q=q>y?y:q,r=r>t?t:r,r=r>v?v:r,r=r>x?x:r,r=r>z?z:r,o=s>o?s:o,o=u>o?u:o,o=w>o?w:o,o=y>o?y:o,p=t>p?t:p,p=v>p?v:p,p=x>p?x:p,p=z>p?z:p}var A=this._bounds;return A.x=q,A.width=o-q,A.y=r,A.height=p-r,this._currentBounds=A,A},b.Sprite.prototype._renderWebGL=function(a){if(this.visible&&!(this.alpha<=0)){var b,c;if(this._mask||this._filters){var d=a.spriteBatch;for(this._filters&&(d.flush(),a.filterManager.pushFilter(this._filterBlock)),this._mask&&(d.stop(),a.maskManager.pushMask(this.mask,a),d.start()),d.render(this),b=0,c=this.children.length;c>b;b++)this.children[b]._renderWebGL(a);d.stop(),this._mask&&a.maskManager.popMask(this._mask,a),this._filters&&a.filterManager.popFilter(),d.start()}else for(a.spriteBatch.render(this),b=0,c=this.children.length;c>b;b++)this.children[b]._renderWebGL(a)}},b.Sprite.prototype._renderCanvas=function(a){if(!(this.visible===!1||0===this.alpha||this.texture.crop.width<=0||this.texture.crop.height<=0)){if(this.blendMode!==a.currentBlendMode&&(a.currentBlendMode=this.blendMode,a.context.globalCompositeOperation=b.blendModesCanvas[a.currentBlendMode]),this._mask&&a.maskManager.pushMask(this._mask,a),this.texture.valid){var c=this.texture.baseTexture.resolution/a.resolution;a.context.globalAlpha=this.worldAlpha,a.smoothProperty&&a.scaleMode!==this.texture.baseTexture.scaleMode&&(a.scaleMode=this.texture.baseTexture.scaleMode,a.context[a.smoothProperty]=a.scaleMode===b.scaleModes.LINEAR);var d=this.texture.trim?this.texture.trim.x-this.anchor.x*this.texture.trim.width:this.anchor.x*-this.texture.frame.width,e=this.texture.trim?this.texture.trim.y-this.anchor.y*this.texture.trim.height:this.anchor.y*-this.texture.frame.height;a.roundPixels?(a.context.setTransform(this.worldTransform.a,this.worldTransform.b,this.worldTransform.c,this.worldTransform.d,this.worldTransform.tx*a.resolution|0,this.worldTransform.ty*a.resolution|0),d=0|d,e=0|e):a.context.setTransform(this.worldTransform.a,this.worldTransform.b,this.worldTransform.c,this.worldTransform.d,this.worldTransform.tx*a.resolution,this.worldTransform.ty*a.resolution),16777215!==this.tint?(this.cachedTint!==this.tint&&(this.cachedTint=this.tint,this.tintedTexture=b.CanvasTinter.getTintedTexture(this,this.tint)),a.context.drawImage(this.tintedTexture,0,0,this.texture.crop.width,this.texture.crop.height,d/c,e/c,this.texture.crop.width/c,this.texture.crop.height/c)):a.context.drawImage(this.texture.baseTexture.source,this.texture.crop.x,this.texture.crop.y,this.texture.crop.width,this.texture.crop.height,d/c,e/c,this.texture.crop.width/c,this.texture.crop.height/c)}for(var f=0,g=this.children.length;g>f;f++)this.children[f]._renderCanvas(a);this._mask&&a.maskManager.popMask(a)}},b.Sprite.fromFrame=function(a){var c=b.TextureCache[a];if(!c)throw new Error('The frameId "'+a+'" does not exist in the texture cache'+this);return new b.Sprite(c)},b.Sprite.fromImage=function(a,c,d){var e=b.Texture.fromImage(a,c,d);return new b.Sprite(e)},b.SpriteBatch=function(a){b.DisplayObjectContainer.call(this),this.textureThing=a,this.ready=!1},b.SpriteBatch.prototype=Object.create(b.DisplayObjectContainer.prototype),b.SpriteBatch.prototype.constructor=b.SpriteBatch,b.SpriteBatch.prototype.initWebGL=function(a){this.fastSpriteBatch=new b.WebGLFastSpriteBatch(a),this.ready=!0},b.SpriteBatch.prototype.updateTransform=function(){this.displayObjectUpdateTransform()},b.SpriteBatch.prototype._renderWebGL=function(a){!this.visible||this.alpha<=0||!this.children.length||(this.ready||this.initWebGL(a.gl),this.fastSpriteBatch.gl!==a.gl&&this.fastSpriteBatch.setContext(a.gl),a.spriteBatch.stop(),a.shaderManager.setShader(a.shaderManager.fastShader),this.fastSpriteBatch.begin(this,a),this.fastSpriteBatch.render(this),a.spriteBatch.start())},b.SpriteBatch.prototype._renderCanvas=function(a){if(this.visible&&!(this.alpha<=0)&&this.children.length){var b=a.context;b.globalAlpha=this.worldAlpha,this.displayObjectUpdateTransform();for(var c=this.worldTransform,d=!0,e=0;e<this.children.length;e++){var f=this.children[e];if(f.visible){var g=f.texture,h=g.frame;if(b.globalAlpha=this.worldAlpha*f.alpha,f.rotation%(2*Math.PI)===0)d&&(b.setTransform(c.a,c.b,c.c,c.d,c.tx,c.ty),d=!1),b.drawImage(g.baseTexture.source,h.x,h.y,h.width,h.height,f.anchor.x*-h.width*f.scale.x+f.position.x+.5|0,f.anchor.y*-h.height*f.scale.y+f.position.y+.5|0,h.width*f.scale.x,h.height*f.scale.y);else{d||(d=!0),f.displayObjectUpdateTransform();var i=f.worldTransform;a.roundPixels?b.setTransform(i.a,i.b,i.c,i.d,0|i.tx,0|i.ty):b.setTransform(i.a,i.b,i.c,i.d,i.tx,i.ty),b.drawImage(g.baseTexture.source,h.x,h.y,h.width,h.height,f.anchor.x*-h.width+.5|0,f.anchor.y*-h.height+.5|0,h.width,h.height)}}}}},b.MovieClip=function(a){b.Sprite.call(this,a[0]),this.textures=a,this.animationSpeed=1,this.loop=!0,this.onComplete=null,this.currentFrame=0,this.playing=!1},b.MovieClip.prototype=Object.create(b.Sprite.prototype),b.MovieClip.prototype.constructor=b.MovieClip,Object.defineProperty(b.MovieClip.prototype,"totalFrames",{get:function(){return this.textures.length}}),b.MovieClip.prototype.stop=function(){this.playing=!1},b.MovieClip.prototype.play=function(){this.playing=!0},b.MovieClip.prototype.gotoAndStop=function(a){this.playing=!1,this.currentFrame=a;var b=this.currentFrame+.5|0;this.setTexture(this.textures[b%this.textures.length])},b.MovieClip.prototype.gotoAndPlay=function(a){this.currentFrame=a,this.playing=!0},b.MovieClip.prototype.updateTransform=function(){if(this.displayObjectContainerUpdateTransform(),this.playing){this.currentFrame+=this.animationSpeed;var a=this.currentFrame+.5|0;this.currentFrame=this.currentFrame%this.textures.length,this.loop||a<this.textures.length?this.setTexture(this.textures[a%this.textures.length]):a>=this.textures.length&&(this.gotoAndStop(this.textures.length-1),this.onComplete&&this.onComplete())}},b.MovieClip.fromFrames=function(a){for(var c=[],d=0;d<a.length;d++)c.push(new b.Texture.fromFrame(a[d]));return new b.MovieClip(c)},b.MovieClip.fromImages=function(a){for(var c=[],d=0;d<a.length;d++)c.push(new b.Texture.fromImage(a[d]));return new b.MovieClip(c)},b.FilterBlock=function(){this.visible=!0,this.renderable=!0},b.FilterBlock.prototype.constructor=b.FilterBlock,b.Text=function(a,c){this.canvas=document.createElement("canvas"),this.context=this.canvas.getContext("2d"),this.resolution=1,b.Sprite.call(this,b.Texture.fromCanvas(this.canvas)),this.setText(a),this.setStyle(c)},b.Text.prototype=Object.create(b.Sprite.prototype),b.Text.prototype.constructor=b.Text,Object.defineProperty(b.Text.prototype,"width",{get:function(){return this.dirty&&(this.updateText(),this.dirty=!1),this.scale.x*this.texture.frame.width},set:function(a){this.scale.x=a/this.texture.frame.width,this._width=a}}),Object.defineProperty(b.Text.prototype,"height",{get:function(){return this.dirty&&(this.updateText(),this.dirty=!1),this.scale.y*this.texture.frame.height},set:function(a){this.scale.y=a/this.texture.frame.height,this._height=a}}),b.Text.prototype.setStyle=function(a){a=a||{},a.font=a.font||"bold 20pt Arial",a.fill=a.fill||"black",a.align=a.align||"left",a.stroke=a.stroke||"black",a.strokeThickness=a.strokeThickness||0,a.wordWrap=a.wordWrap||!1,a.wordWrapWidth=a.wordWrapWidth||100,a.dropShadow=a.dropShadow||!1,a.dropShadowAngle=a.dropShadowAngle||Math.PI/6,a.dropShadowDistance=a.dropShadowDistance||4,a.dropShadowColor=a.dropShadowColor||"black",a.lineJoin=a.lineJoin||"miter",a.lineHeight=a.lineHeight||!1,this.style=a,this.dirty=!0},b.Text.prototype.setText=function(a){this.text=a.toString()||" ",this.dirty=!0},b.Text.prototype.updateText=function(){this.texture.baseTexture.resolution=this.resolution,this.context.font=this.style.font;var a=this.text;this.style.wordWrap&&(a=this.wordWrap(this.text));for(var b=a.split(/(?:\r\n|\r|\n)/),c=[],d=0,e=this.determineFontProperties(this.style.font),f=0;f<b.length;f++){var g=this.context.measureText(b[f]).width;c[f]=g,d=Math.max(d,g)}var h=d+this.style.strokeThickness;this.style.dropShadow&&(h+=this.style.dropShadowDistance),this.canvas.width=(h+this.context.lineWidth)*this.resolution;var i=this.style.lineHeight||e.fontSize+this.style.strokeThickness,j=i*b.length;this.style.dropShadow&&(j+=this.style.dropShadowDistance),this.canvas.height=j*this.resolution,this.context.scale(this.resolution,this.resolution),navigator.isCocoonJS&&this.context.clearRect(0,0,this.canvas.width,this.canvas.height),this.context.font=this.style.font,this.context.strokeStyle=this.style.stroke,this.context.lineWidth=this.style.strokeThickness,this.context.textBaseline="alphabetic",this.context.lineJoin=this.style.lineJoin;var k,l;if(this.style.dropShadow){this.context.fillStyle=this.style.dropShadowColor;var m=Math.sin(this.style.dropShadowAngle)*this.style.dropShadowDistance,n=Math.cos(this.style.dropShadowAngle)*this.style.dropShadowDistance;for(f=0;f<b.length;f++)k=this.style.strokeThickness/2,l=this.style.strokeThickness/2+f*i+e.ascent,"right"===this.style.align?k+=d-c[f]:"center"===this.style.align&&(k+=(d-c[f])/2),this.style.fill&&this.context.fillText(b[f],k+m,l+n)}for(this.context.fillStyle=this.style.fill,f=0;f<b.length;f++)k=this.style.strokeThickness/2,l=this.style.strokeThickness/2+f*i+e.ascent,"right"===this.style.align?k+=d-c[f]:"center"===this.style.align&&(k+=(d-c[f])/2),this.style.stroke&&this.style.strokeThickness&&this.context.strokeText(b[f],k,l),this.style.fill&&this.context.fillText(b[f],k,l);this.updateTexture()},b.Text.prototype.updateTexture=function(){this.texture.baseTexture.width=this.canvas.width,this.texture.baseTexture.height=this.canvas.height,this.texture.crop.width=this.texture.frame.width=this.canvas.width,this.texture.crop.height=this.texture.frame.height=this.canvas.height,this._width=this.canvas.width,this._height=this.canvas.height,this.texture.baseTexture.dirty()},b.Text.prototype._renderWebGL=function(a){this.dirty&&(this.resolution=a.resolution,this.updateText(),this.dirty=!1),b.Sprite.prototype._renderWebGL.call(this,a)},b.Text.prototype._renderCanvas=function(a){this.dirty&&(this.resolution=a.resolution,this.updateText(),this.dirty=!1),b.Sprite.prototype._renderCanvas.call(this,a)},b.Text.prototype.determineFontProperties=function(a){var c=b.Text.fontPropertiesCache[a];if(!c){c={};var d=b.Text.fontPropertiesCanvas,e=b.Text.fontPropertiesContext;e.font=a;var f=Math.ceil(e.measureText("|Mq").width),g=Math.ceil(e.measureText("M").width),h=2*g;g=1.4*g|0,d.width=f,d.height=h,e.fillStyle="#f00",e.fillRect(0,0,f,h),e.font=a,e.textBaseline="alphabetic",e.fillStyle="#000",e.fillText("|MÉq",0,g);var i,j,k=e.getImageData(0,0,f,h).data,l=k.length,m=4*f,n=0,o=!1;for(i=0;g>i;i++){for(j=0;m>j;j+=4)if(255!==k[n+j]){o=!0;break}if(o)break;n+=m}for(c.ascent=g-i,n=l-m,o=!1,i=h;i>g;i--){for(j=0;m>j;j+=4)if(255!==k[n+j]){o=!0;break}if(o)break;n-=m}c.descent=i-g,c.descent+=6,c.fontSize=c.ascent+c.descent,b.Text.fontPropertiesCache[a]=c}return c},b.Text.prototype.wordWrap=function(a){for(var b="",c=a.split("\n"),d=0;d<c.length;d++){for(var e=this.style.wordWrapWidth,f=c[d].split(" "),g=0;g<f.length;g++){var h=this.context.measureText(f[g]).width,i=h+this.context.measureText(" ").width;0===g||i>e?(g>0&&(b+="\n"),b+=f[g],e=this.style.wordWrapWidth-h):(e-=i,b+=" "+f[g])}d<c.length-1&&(b+="\n")}return b},b.Text.prototype.getBounds=function(a){return this.dirty&&(this.updateText(),this.dirty=!1),b.Sprite.prototype.getBounds.call(this,a)},b.Text.prototype.destroy=function(a){this.context=null,this.canvas=null,this.texture.destroy(void 0===a?!0:a)},b.Text.fontPropertiesCache={},b.Text.fontPropertiesCanvas=document.createElement("canvas"),b.Text.fontPropertiesContext=b.Text.fontPropertiesCanvas.getContext("2d"),b.BitmapText=function(a,c){b.DisplayObjectContainer.call(this),this.textWidth=0,this.textHeight=0,this._pool=[],this.setText(a),this.setStyle(c),this.updateText(),this.dirty=!1},b.BitmapText.prototype=Object.create(b.DisplayObjectContainer.prototype),b.BitmapText.prototype.constructor=b.BitmapText,b.BitmapText.prototype.setText=function(a){this.text=a||" ",this.dirty=!0},b.BitmapText.prototype.setStyle=function(a){a=a||{},a.align=a.align||"left",this.style=a;var c=a.font.split(" ");this.fontName=c[c.length-1],this.fontSize=c.length>=2?parseInt(c[c.length-2],10):b.BitmapText.fonts[this.fontName].size,this.dirty=!0,this.tint=a.tint},b.BitmapText.prototype.updateText=function(){for(var a=b.BitmapText.fonts[this.fontName],c=new b.Point,d=null,e=[],f=0,g=[],h=0,i=this.fontSize/a.size,j=0;j<this.text.length;j++){var k=this.text.charCodeAt(j);if(/(?:\r\n|\r|\n)/.test(this.text.charAt(j)))g.push(c.x),f=Math.max(f,c.x),h++,c.x=0,c.y+=a.lineHeight,d=null;else{var l=a.chars[k];l&&(d&&l.kerning[d]&&(c.x+=l.kerning[d]),e.push({texture:l.texture,line:h,charCode:k,position:new b.Point(c.x+l.xOffset,c.y+l.yOffset)}),c.x+=l.xAdvance,d=k)}}g.push(c.x),f=Math.max(f,c.x);var m=[];for(j=0;h>=j;j++){var n=0;"right"===this.style.align?n=f-g[j]:"center"===this.style.align&&(n=(f-g[j])/2),m.push(n)}var o=this.children.length,p=e.length,q=this.tint||16777215;for(j=0;p>j;j++){var r=o>j?this.children[j]:this._pool.pop();r?r.setTexture(e[j].texture):r=new b.Sprite(e[j].texture),r.position.x=(e[j].position.x+m[e[j].line])*i,r.position.y=e[j].position.y*i,r.scale.x=r.scale.y=i,r.tint=q,r.parent||this.addChild(r)}for(;this.children.length>p;){var s=this.getChildAt(this.children.length-1);this._pool.push(s),this.removeChild(s)}this.textWidth=f*i,this.textHeight=(c.y+a.lineHeight)*i},b.BitmapText.prototype.updateTransform=function(){this.dirty&&(this.updateText(),this.dirty=!1),b.DisplayObjectContainer.prototype.updateTransform.call(this)},b.BitmapText.fonts={},b.InteractionData=function(){this.global=new b.Point,this.target=null,this.originalEvent=null},b.InteractionData.prototype.getLocalPosition=function(a,c,d){var e=a.worldTransform,f=d?d:this.global,g=e.a,h=e.c,i=e.tx,j=e.b,k=e.d,l=e.ty,m=1/(g*k+h*-j);return c=c||new b.Point,c.x=k*m*f.x+-h*m*f.y+(l*h-i*k)*m,c.y=g*m*f.y+-j*m*f.x+(-l*g+i*j)*m,c},b.InteractionData.prototype.constructor=b.InteractionData,b.InteractionManager=function(a){this.stage=a,this.mouse=new b.InteractionData,this.touches={},this.tempPoint=new b.Point,this.mouseoverEnabled=!0,this.pool=[],this.interactiveItems=[],this.interactionDOMElement=null,this.onMouseMove=this.onMouseMove.bind(this),this.onMouseDown=this.onMouseDown.bind(this),this.onMouseOut=this.onMouseOut.bind(this),this.onMouseUp=this.onMouseUp.bind(this),this.onTouchStart=this.onTouchStart.bind(this),this.onTouchEnd=this.onTouchEnd.bind(this),
this.onTouchCancel=this.onTouchCancel.bind(this),this.onTouchMove=this.onTouchMove.bind(this),this.last=0,this.currentCursorStyle="inherit",this.mouseOut=!1,this.resolution=1,this._tempPoint=new b.Point},b.InteractionManager.prototype.constructor=b.InteractionManager,b.InteractionManager.prototype.collectInteractiveSprite=function(a,b){for(var c=a.children,d=c.length,e=d-1;e>=0;e--){var f=c[e];f._interactive?(b.interactiveChildren=!0,this.interactiveItems.push(f),f.children.length>0&&this.collectInteractiveSprite(f,f)):(f.__iParent=null,f.children.length>0&&this.collectInteractiveSprite(f,b))}},b.InteractionManager.prototype.setTarget=function(a){this.target=a,this.resolution=a.resolution,null===this.interactionDOMElement&&this.setTargetDomElement(a.view)},b.InteractionManager.prototype.setTargetDomElement=function(a){this.removeEvents(),window.navigator.msPointerEnabled&&(a.style["-ms-content-zooming"]="none",a.style["-ms-touch-action"]="none"),this.interactionDOMElement=a,a.addEventListener("mousemove",this.onMouseMove,!0),a.addEventListener("mousedown",this.onMouseDown,!0),a.addEventListener("mouseout",this.onMouseOut,!0),a.addEventListener("touchstart",this.onTouchStart,!0),a.addEventListener("touchend",this.onTouchEnd,!0),a.addEventListener("touchleave",this.onTouchCancel,!0),a.addEventListener("touchcancel",this.onTouchCancel,!0),a.addEventListener("touchmove",this.onTouchMove,!0),window.addEventListener("mouseup",this.onMouseUp,!0)},b.InteractionManager.prototype.removeEvents=function(){this.interactionDOMElement&&(this.interactionDOMElement.style["-ms-content-zooming"]="",this.interactionDOMElement.style["-ms-touch-action"]="",this.interactionDOMElement.removeEventListener("mousemove",this.onMouseMove,!0),this.interactionDOMElement.removeEventListener("mousedown",this.onMouseDown,!0),this.interactionDOMElement.removeEventListener("mouseout",this.onMouseOut,!0),this.interactionDOMElement.removeEventListener("touchstart",this.onTouchStart,!0),this.interactionDOMElement.removeEventListener("touchend",this.onTouchEnd,!0),this.interactionDOMElement.removeEventListener("touchleave",this.onTouchCancel,!0),this.interactionDOMElement.removeEventListener("touchcancel",this.onTouchCancel,!0),this.interactionDOMElement.removeEventListener("touchmove",this.onTouchMove,!0),this.interactionDOMElement=null,window.removeEventListener("mouseup",this.onMouseUp,!0))},b.InteractionManager.prototype.update=function(){if(this.target){var a=Date.now(),c=a-this.last;if(c=c*b.INTERACTION_FREQUENCY/1e3,!(1>c)){this.last=a;var d=0;this.dirty&&this.rebuildInteractiveGraph();var e=this.interactiveItems.length,f="inherit",g=!1;for(d=0;e>d;d++){var h=this.interactiveItems[d];h.__hit=this.hitTest(h,this.mouse),this.mouse.target=h,h.__hit&&!g?(h.buttonMode&&(f=h.defaultCursor),h.interactiveChildren||(g=!0),h.__isOver||(h.mouseover&&h.mouseover(this.mouse),h.__isOver=!0)):h.__isOver&&(h.mouseout&&h.mouseout(this.mouse),h.__isOver=!1)}this.currentCursorStyle!==f&&(this.currentCursorStyle=f,this.interactionDOMElement.style.cursor=f)}}},b.InteractionManager.prototype.rebuildInteractiveGraph=function(){this.dirty=!1;for(var a=this.interactiveItems.length,b=0;a>b;b++)this.interactiveItems[b].interactiveChildren=!1;this.interactiveItems=[],this.stage.interactive&&this.interactiveItems.push(this.stage),this.collectInteractiveSprite(this.stage,this.stage)},b.InteractionManager.prototype.onMouseMove=function(a){this.dirty&&this.rebuildInteractiveGraph(),this.mouse.originalEvent=a;var b=this.interactionDOMElement.getBoundingClientRect();this.mouse.global.x=(a.clientX-b.left)*(this.target.width/b.width)/this.resolution,this.mouse.global.y=(a.clientY-b.top)*(this.target.height/b.height)/this.resolution;for(var c=this.interactiveItems.length,d=0;c>d;d++){var e=this.interactiveItems[d];e.mousemove&&e.mousemove(this.mouse)}},b.InteractionManager.prototype.onMouseDown=function(a){this.dirty&&this.rebuildInteractiveGraph(),this.mouse.originalEvent=a,b.AUTO_PREVENT_DEFAULT&&this.mouse.originalEvent.preventDefault();for(var c=this.interactiveItems.length,d=this.mouse.originalEvent,e=2===d.button||3===d.which,f=e?"rightdown":"mousedown",g=e?"rightclick":"click",h=e?"__rightIsDown":"__mouseIsDown",i=e?"__isRightDown":"__isDown",j=0;c>j;j++){var k=this.interactiveItems[j];if((k[f]||k[g])&&(k[h]=!0,k.__hit=this.hitTest(k,this.mouse),k.__hit&&(k[f]&&k[f](this.mouse),k[i]=!0,!k.interactiveChildren)))break}},b.InteractionManager.prototype.onMouseOut=function(a){this.dirty&&this.rebuildInteractiveGraph(),this.mouse.originalEvent=a;var b=this.interactiveItems.length;this.interactionDOMElement.style.cursor="inherit";for(var c=0;b>c;c++){var d=this.interactiveItems[c];d.__isOver&&(this.mouse.target=d,d.mouseout&&d.mouseout(this.mouse),d.__isOver=!1)}this.mouseOut=!0,this.mouse.global.x=-1e4,this.mouse.global.y=-1e4},b.InteractionManager.prototype.onMouseUp=function(a){this.dirty&&this.rebuildInteractiveGraph(),this.mouse.originalEvent=a;for(var b=this.interactiveItems.length,c=!1,d=this.mouse.originalEvent,e=2===d.button||3===d.which,f=e?"rightup":"mouseup",g=e?"rightclick":"click",h=e?"rightupoutside":"mouseupoutside",i=e?"__isRightDown":"__isDown",j=0;b>j;j++){var k=this.interactiveItems[j];(k[g]||k[f]||k[h])&&(k.__hit=this.hitTest(k,this.mouse),k.__hit&&!c?(k[f]&&k[f](this.mouse),k[i]&&k[g]&&k[g](this.mouse),k.interactiveChildren||(c=!0)):k[i]&&k[h]&&k[h](this.mouse),k[i]=!1)}},b.InteractionManager.prototype.hitTest=function(a,c){var d=c.global;if(!a.worldVisible)return!1;a.worldTransform.applyInverse(d,this._tempPoint);var e,f=this._tempPoint.x,g=this._tempPoint.y;if(c.target=a,a.hitArea&&a.hitArea.contains)return a.hitArea.contains(f,g);if(a instanceof b.Sprite){var h,i=a.texture.frame.width,j=a.texture.frame.height,k=-i*a.anchor.x;if(f>k&&k+i>f&&(h=-j*a.anchor.y,g>h&&h+j>g))return!0}else if(a instanceof b.Graphics){var l=a.graphicsData;for(e=0;e<l.length;e++){var m=l[e];if(m.fill&&m.shape&&m.shape.contains(f,g))return!0}}var n=a.children.length;for(e=0;n>e;e++){var o=a.children[e],p=this.hitTest(o,c);if(p)return c.target=a,!0}return!1},b.InteractionManager.prototype.onTouchMove=function(a){this.dirty&&this.rebuildInteractiveGraph();for(var b,c,d=this.interactionDOMElement.getBoundingClientRect(),e=a.changedTouches,f=e.length,g=this.target.width/d.width,h=this.target.height/d.height,i=navigator.isCocoonJS&&!d.left&&!d.top&&!a.target.style.width&&!a.target.style.height,j=0;f>j;j++)c=e[j],i?(c.globalX=c.clientX,c.globalY=c.clientY):(c.globalX=(c.clientX-d.left)*g/this.resolution,c.globalY=(c.clientY-d.top)*h/this.resolution);for(var k=0;f>k;k++){c=e[k],b=this.touches[c.identifier],b.originalEvent=a,i?(b.global.x=c.clientX,b.global.y=c.clientY):(c.globalX=b.global.x=(c.clientX-d.left)*g/this.resolution,c.globalY=b.global.y=(c.clientY-d.top)*h/this.resolution);for(var l=0;l<this.interactiveItems.length;l++){var m=this.interactiveItems[l];m.touchmove&&m.__touchData&&m.__touchData[c.identifier]&&m.touchmove(b)}}},b.InteractionManager.prototype.onTouchStart=function(a){this.dirty&&this.rebuildInteractiveGraph();var c=this.interactionDOMElement.getBoundingClientRect();b.AUTO_PREVENT_DEFAULT&&a.preventDefault();for(var d,e=a.changedTouches,f=e.length,g=this.target.width/c.width,h=this.target.height/c.height,i=navigator.isCocoonJS&&!c.left&&!c.top&&!a.target.style.width&&!a.target.style.height,j=0;f>j;j++)d=e[j],i?(d.globalX=d.clientX,d.globalY=d.clientY):(d.globalX=(d.clientX-c.left)*g/this.resolution,d.globalY=(d.clientY-c.top)*h/this.resolution);for(var k=0;f>k;k++){d=e[k];var l=this.pool.pop();l||(l=new b.InteractionData),l.originalEvent=a,this.touches[d.identifier]=l,i?(l.global.x=d.clientX,l.global.y=d.clientY):(l.global.x=(d.clientX-c.left)*g/this.resolution,l.global.y=(d.clientY-c.top)*h/this.resolution);for(var m=this.interactiveItems.length,n=0;m>n;n++){var o=this.interactiveItems[n];if((o.touchstart||o.tap)&&(o.__hit=this.hitTest(o,l),o.__hit&&(o.touchstart&&o.touchstart(l),o.__isDown=!0,o.__touchData=o.__touchData||{},o.__touchData[d.identifier]=l,!o.interactiveChildren)))break}}},b.InteractionManager.prototype.onTouchEnd=function(a){this.dirty&&this.rebuildInteractiveGraph();for(var b,c=this.interactionDOMElement.getBoundingClientRect(),d=a.changedTouches,e=d.length,f=this.target.width/c.width,g=this.target.height/c.height,h=navigator.isCocoonJS&&!c.left&&!c.top&&!a.target.style.width&&!a.target.style.height,i=0;e>i;i++)b=d[i],h?(b.globalX=b.clientX,b.globalY=b.clientY):(b.globalX=(b.clientX-c.left)*f/this.resolution,b.globalY=(b.clientY-c.top)*g/this.resolution);for(var j=0;e>j;j++){b=d[j];var k=this.touches[b.identifier],l=!1;h?(k.global.x=b.clientX,k.global.y=b.clientY):(k.global.x=(b.clientX-c.left)*f/this.resolution,k.global.y=(b.clientY-c.top)*g/this.resolution);for(var m=this.interactiveItems.length,n=0;m>n;n++){var o=this.interactiveItems[n];o.__touchData&&o.__touchData[b.identifier]&&(o.__hit=this.hitTest(o,o.__touchData[b.identifier]),k.originalEvent=a,(o.touchend||o.tap)&&(o.__hit&&!l?(o.touchend&&o.touchend(k),o.__isDown&&o.tap&&o.tap(k),o.interactiveChildren||(l=!0)):o.__isDown&&o.touchendoutside&&o.touchendoutside(k),o.__isDown=!1),o.__touchData[b.identifier]=null)}this.pool.push(k),this.touches[b.identifier]=null}},b.InteractionManager.prototype.onTouchCancel=function(a){this.dirty&&this.rebuildInteractiveGraph();for(var b,c=this.interactionDOMElement.getBoundingClientRect(),d=a.changedTouches,e=d.length,f=this.target.width/c.width,g=this.target.height/c.height,h=navigator.isCocoonJS&&!c.left&&!c.top&&!a.target.style.width&&!a.target.style.height,i=0;e>i;i++)b=d[i],h?(b.globalX=b.clientX,b.globalY=b.clientY):(b.globalX=(b.clientX-c.left)*f/this.resolution,b.globalY=(b.clientY-c.top)*g/this.resolution);for(var j=0;e>j;j++){b=d[j];var k=this.touches[b.identifier],l=!1;h?(k.global.x=b.clientX,k.global.y=b.clientY):(k.global.x=(b.clientX-c.left)*f/this.resolution,k.global.y=(b.clientY-c.top)*g/this.resolution);for(var m=this.interactiveItems.length,n=0;m>n;n++){var o=this.interactiveItems[n];o.__touchData&&o.__touchData[b.identifier]&&(o.__hit=this.hitTest(o,o.__touchData[b.identifier]),k.originalEvent=a,o.touchcancel&&!l&&(o.touchcancel(k),o.interactiveChildren||(l=!0)),o.__isDown=!1,o.__touchData[b.identifier]=null)}this.pool.push(k),this.touches[b.identifier]=null}},b.Stage=function(a){b.DisplayObjectContainer.call(this),this.worldTransform=new b.Matrix,this.interactive=!0,this.interactionManager=new b.InteractionManager(this),this.dirty=!0,this.stage=this,this.stage.hitArea=new b.Rectangle(0,0,1e5,1e5),this.setBackgroundColor(a)},b.Stage.prototype=Object.create(b.DisplayObjectContainer.prototype),b.Stage.prototype.constructor=b.Stage,b.Stage.prototype.setInteractionDelegate=function(a){this.interactionManager.setTargetDomElement(a)},b.Stage.prototype.updateTransform=function(){this.worldAlpha=1;for(var a=0,b=this.children.length;b>a;a++)this.children[a].updateTransform();this.dirty&&(this.dirty=!1,this.interactionManager.dirty=!0),this.interactive&&this.interactionManager.update()},b.Stage.prototype.setBackgroundColor=function(a){this.backgroundColor=a||0,this.backgroundColorSplit=b.hex2rgb(this.backgroundColor);var c=this.backgroundColor.toString(16);c="000000".substr(0,6-c.length)+c,this.backgroundColorString="#"+c},b.Stage.prototype.getMousePosition=function(){return this.interactionManager.mouse.global},function(a){for(var b=0,c=["ms","moz","webkit","o"],d=0;d<c.length&&!a.requestAnimationFrame;++d)a.requestAnimationFrame=a[c[d]+"RequestAnimationFrame"],a.cancelAnimationFrame=a[c[d]+"CancelAnimationFrame"]||a[c[d]+"CancelRequestAnimationFrame"];a.requestAnimationFrame||(a.requestAnimationFrame=function(c){var d=(new Date).getTime(),e=Math.max(0,16-(d-b)),f=a.setTimeout(function(){c(d+e)},e);return b=d+e,f}),a.cancelAnimationFrame||(a.cancelAnimationFrame=function(a){clearTimeout(a)}),a.requestAnimFrame=a.requestAnimationFrame}(this),b.hex2rgb=function(a){return[(a>>16&255)/255,(a>>8&255)/255,(255&a)/255]},b.rgb2hex=function(a){return(255*a[0]<<16)+(255*a[1]<<8)+255*a[2]},"function"!=typeof Function.prototype.bind&&(Function.prototype.bind=function(){return function(a){function b(){for(var d=arguments.length,f=new Array(d);d--;)f[d]=arguments[d];return f=e.concat(f),c.apply(this instanceof b?this:a,f)}var c=this,d=arguments.length-1,e=[];if(d>0)for(e.length=d;d--;)e[d]=arguments[d+1];if("function"!=typeof c)throw new TypeError;return b.prototype=function f(a){return a&&(f.prototype=a),this instanceof f?void 0:new f}(c.prototype),b}}()),b.AjaxRequest=function(){var a=["Msxml2.XMLHTTP.6.0","Msxml2.XMLHTTP.3.0","Microsoft.XMLHTTP"];if(!window.ActiveXObject)return window.XMLHttpRequest?new window.XMLHttpRequest:!1;for(var b=0;b<a.length;b++)try{return new window.ActiveXObject(a[b])}catch(c){}},b.canUseNewCanvasBlendModes=function(){if("undefined"==typeof document)return!1;var a=document.createElement("canvas");a.width=1,a.height=1;var b=a.getContext("2d");return b.fillStyle="#000",b.fillRect(0,0,1,1),b.globalCompositeOperation="multiply",b.fillStyle="#fff",b.fillRect(0,0,1,1),0===b.getImageData(0,0,1,1).data[0]},b.getNextPowerOfTwo=function(a){if(a>0&&0===(a&a-1))return a;for(var b=1;a>b;)b<<=1;return b},b.isPowerOfTwo=function(a,b){return a>0&&0===(a&a-1)&&b>0&&0===(b&b-1)},b.EventTarget={call:function(a){a&&(a=a.prototype||a,b.EventTarget.mixin(a))},mixin:function(a){a.listeners=function(a){return this._listeners=this._listeners||{},this._listeners[a]?this._listeners[a].slice():[]},a.emit=a.dispatchEvent=function(a,c){if(this._listeners=this._listeners||{},"object"==typeof a&&(c=a,a=a.type),c&&c.__isEventObject===!0||(c=new b.Event(this,a,c)),this._listeners&&this._listeners[a]){var d,e=this._listeners[a].slice(0),f=e.length,g=e[0];for(d=0;f>d;g=e[++d])if(g.call(this,c),c.stoppedImmediate)return this;if(c.stopped)return this}return this.parent&&this.parent.emit&&this.parent.emit.call(this.parent,a,c),this},a.on=a.addEventListener=function(a,b){return this._listeners=this._listeners||{},(this._listeners[a]=this._listeners[a]||[]).push(b),this},a.once=function(a,b){function c(){b.apply(d.off(a,c),arguments)}this._listeners=this._listeners||{};var d=this;return c._originalHandler=b,this.on(a,c)},a.off=a.removeEventListener=function(a,b){if(this._listeners=this._listeners||{},!this._listeners[a])return this;for(var c=this._listeners[a],d=b?c.length:0;d-->0;)(c[d]===b||c[d]._originalHandler===b)&&c.splice(d,1);return 0===c.length&&delete this._listeners[a],this},a.removeAllListeners=function(a){return this._listeners=this._listeners||{},this._listeners[a]?(delete this._listeners[a],this):this}}},b.Event=function(a,b,c){this.__isEventObject=!0,this.stopped=!1,this.stoppedImmediate=!1,this.target=a,this.type=b,this.data=c,this.content=c,this.timeStamp=Date.now()},b.Event.prototype.stopPropagation=function(){this.stopped=!0},b.Event.prototype.stopImmediatePropagation=function(){this.stoppedImmediate=!0},b.autoDetectRenderer=function(a,c,d){a||(a=800),c||(c=600);var e=function(){try{var a=document.createElement("canvas");return!!window.WebGLRenderingContext&&(a.getContext("webgl")||a.getContext("experimental-webgl"))}catch(b){return!1}}();return e?new b.WebGLRenderer(a,c,d):new b.CanvasRenderer(a,c,d)},b.autoDetectRecommendedRenderer=function(a,c,d){a||(a=800),c||(c=600);var e=function(){try{var a=document.createElement("canvas");return!!window.WebGLRenderingContext&&(a.getContext("webgl")||a.getContext("experimental-webgl"))}catch(b){return!1}}(),f=/Android/i.test(navigator.userAgent);return e&&!f?new b.WebGLRenderer(a,c,d):new b.CanvasRenderer(a,c,d)},b.PolyK={},b.PolyK.Triangulate=function(a){var c=!0,d=a.length>>1;if(3>d)return[];for(var e=[],f=[],g=0;d>g;g++)f.push(g);g=0;for(var h=d;h>3;){var i=f[(g+0)%h],j=f[(g+1)%h],k=f[(g+2)%h],l=a[2*i],m=a[2*i+1],n=a[2*j],o=a[2*j+1],p=a[2*k],q=a[2*k+1],r=!1;if(b.PolyK._convex(l,m,n,o,p,q,c)){r=!0;for(var s=0;h>s;s++){var t=f[s];if(t!==i&&t!==j&&t!==k&&b.PolyK._PointInTriangle(a[2*t],a[2*t+1],l,m,n,o,p,q)){r=!1;break}}}if(r)e.push(i,j,k),f.splice((g+1)%h,1),h--,g=0;else if(g++>3*h){if(!c)return null;for(e=[],f=[],g=0;d>g;g++)f.push(g);g=0,h=d,c=!1}}return e.push(f[0],f[1],f[2]),e},b.PolyK._PointInTriangle=function(a,b,c,d,e,f,g,h){var i=g-c,j=h-d,k=e-c,l=f-d,m=a-c,n=b-d,o=i*i+j*j,p=i*k+j*l,q=i*m+j*n,r=k*k+l*l,s=k*m+l*n,t=1/(o*r-p*p),u=(r*q-p*s)*t,v=(o*s-p*q)*t;return u>=0&&v>=0&&1>u+v},b.PolyK._convex=function(a,b,c,d,e,f,g){return(b-d)*(e-c)+(c-a)*(f-d)>=0===g},b.initDefaultShaders=function(){},b.CompileVertexShader=function(a,c){return b._CompileShader(a,c,a.VERTEX_SHADER)},b.CompileFragmentShader=function(a,c){return b._CompileShader(a,c,a.FRAGMENT_SHADER)},b._CompileShader=function(a,b,c){var d=b.join("\n"),e=a.createShader(c);return a.shaderSource(e,d),a.compileShader(e),a.getShaderParameter(e,a.COMPILE_STATUS)?e:(window.console.log(a.getShaderInfoLog(e)),null)},b.compileProgram=function(a,c,d){var e=b.CompileFragmentShader(a,d),f=b.CompileVertexShader(a,c),g=a.createProgram();return a.attachShader(g,f),a.attachShader(g,e),a.linkProgram(g),a.getProgramParameter(g,a.LINK_STATUS)||window.console.log("Could not initialise shaders"),g},b.PixiShader=function(a){this._UID=b._UID++,this.gl=a,this.program=null,this.fragmentSrc=["precision lowp float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord) * vColor ;","}"],this.textureCount=0,this.firstRun=!0,this.dirty=!0,this.attributes=[],this.init()},b.PixiShader.prototype.constructor=b.PixiShader,b.PixiShader.prototype.init=function(){var a=this.gl,c=b.compileProgram(a,this.vertexSrc||b.PixiShader.defaultVertexSrc,this.fragmentSrc);a.useProgram(c),this.uSampler=a.getUniformLocation(c,"uSampler"),this.projectionVector=a.getUniformLocation(c,"projectionVector"),this.offsetVector=a.getUniformLocation(c,"offsetVector"),this.dimensions=a.getUniformLocation(c,"dimensions"),this.aVertexPosition=a.getAttribLocation(c,"aVertexPosition"),this.aTextureCoord=a.getAttribLocation(c,"aTextureCoord"),this.colorAttribute=a.getAttribLocation(c,"aColor"),-1===this.colorAttribute&&(this.colorAttribute=2),this.attributes=[this.aVertexPosition,this.aTextureCoord,this.colorAttribute];for(var d in this.uniforms)this.uniforms[d].uniformLocation=a.getUniformLocation(c,d);this.initUniforms(),this.program=c},b.PixiShader.prototype.initUniforms=function(){this.textureCount=1;var a,b=this.gl;for(var c in this.uniforms){a=this.uniforms[c];var d=a.type;"sampler2D"===d?(a._init=!1,null!==a.value&&this.initSampler2D(a)):"mat2"===d||"mat3"===d||"mat4"===d?(a.glMatrix=!0,a.glValueLength=1,"mat2"===d?a.glFunc=b.uniformMatrix2fv:"mat3"===d?a.glFunc=b.uniformMatrix3fv:"mat4"===d&&(a.glFunc=b.uniformMatrix4fv)):(a.glFunc=b["uniform"+d],a.glValueLength="2f"===d||"2i"===d?2:"3f"===d||"3i"===d?3:"4f"===d||"4i"===d?4:1)}},b.PixiShader.prototype.initSampler2D=function(a){if(a.value&&a.value.baseTexture&&a.value.baseTexture.hasLoaded){var b=this.gl;if(b.activeTexture(b["TEXTURE"+this.textureCount]),b.bindTexture(b.TEXTURE_2D,a.value.baseTexture._glTextures[b.id]),a.textureData){var c=a.textureData,d=c.magFilter?c.magFilter:b.LINEAR,e=c.minFilter?c.minFilter:b.LINEAR,f=c.wrapS?c.wrapS:b.CLAMP_TO_EDGE,g=c.wrapT?c.wrapT:b.CLAMP_TO_EDGE,h=c.luminance?b.LUMINANCE:b.RGBA;if(c.repeat&&(f=b.REPEAT,g=b.REPEAT),b.pixelStorei(b.UNPACK_FLIP_Y_WEBGL,!!c.flipY),c.width){var i=c.width?c.width:512,j=c.height?c.height:2,k=c.border?c.border:0;b.texImage2D(b.TEXTURE_2D,0,h,i,j,k,h,b.UNSIGNED_BYTE,null)}else b.texImage2D(b.TEXTURE_2D,0,h,b.RGBA,b.UNSIGNED_BYTE,a.value.baseTexture.source);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,d),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,e),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,f),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,g)}b.uniform1i(a.uniformLocation,this.textureCount),a._init=!0,this.textureCount++}},b.PixiShader.prototype.syncUniforms=function(){this.textureCount=1;var a,c=this.gl;for(var d in this.uniforms)a=this.uniforms[d],1===a.glValueLength?a.glMatrix===!0?a.glFunc.call(c,a.uniformLocation,a.transpose,a.value):a.glFunc.call(c,a.uniformLocation,a.value):2===a.glValueLength?a.glFunc.call(c,a.uniformLocation,a.value.x,a.value.y):3===a.glValueLength?a.glFunc.call(c,a.uniformLocation,a.value.x,a.value.y,a.value.z):4===a.glValueLength?a.glFunc.call(c,a.uniformLocation,a.value.x,a.value.y,a.value.z,a.value.w):"sampler2D"===a.type&&(a._init?(c.activeTexture(c["TEXTURE"+this.textureCount]),a.value.baseTexture._dirty[c.id]?b.instances[c.id].updateTexture(a.value.baseTexture):c.bindTexture(c.TEXTURE_2D,a.value.baseTexture._glTextures[c.id]),c.uniform1i(a.uniformLocation,this.textureCount),this.textureCount++):this.initSampler2D(a))},b.PixiShader.prototype.destroy=function(){this.gl.deleteProgram(this.program),this.uniforms=null,this.gl=null,this.attributes=null},b.PixiShader.defaultVertexSrc=["attribute vec2 aVertexPosition;","attribute vec2 aTextureCoord;","attribute vec4 aColor;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","varying vec2 vTextureCoord;","varying vec4 vColor;","const vec2 center = vec2(-1.0, 1.0);","void main(void) {","   gl_Position = vec4( ((aVertexPosition + offsetVector) / projectionVector) + center , 0.0, 1.0);","   vTextureCoord = aTextureCoord;","   vColor = vec4(aColor.rgb * aColor.a, aColor.a);","}"],b.PixiFastShader=function(a){this._UID=b._UID++,this.gl=a,this.program=null,this.fragmentSrc=["precision lowp float;","varying vec2 vTextureCoord;","varying float vColor;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord) * vColor ;","}"],this.vertexSrc=["attribute vec2 aVertexPosition;","attribute vec2 aPositionCoord;","attribute vec2 aScale;","attribute float aRotation;","attribute vec2 aTextureCoord;","attribute float aColor;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","uniform mat3 uMatrix;","varying vec2 vTextureCoord;","varying float vColor;","const vec2 center = vec2(-1.0, 1.0);","void main(void) {","   vec2 v;","   vec2 sv = aVertexPosition * aScale;","   v.x = (sv.x) * cos(aRotation) - (sv.y) * sin(aRotation);","   v.y = (sv.x) * sin(aRotation) + (sv.y) * cos(aRotation);","   v = ( uMatrix * vec3(v + aPositionCoord , 1.0) ).xy ;","   gl_Position = vec4( ( v / projectionVector) + center , 0.0, 1.0);","   vTextureCoord = aTextureCoord;","   vColor = aColor;","}"],this.textureCount=0,this.init()},b.PixiFastShader.prototype.constructor=b.PixiFastShader,b.PixiFastShader.prototype.init=function(){var a=this.gl,c=b.compileProgram(a,this.vertexSrc,this.fragmentSrc);a.useProgram(c),this.uSampler=a.getUniformLocation(c,"uSampler"),this.projectionVector=a.getUniformLocation(c,"projectionVector"),this.offsetVector=a.getUniformLocation(c,"offsetVector"),this.dimensions=a.getUniformLocation(c,"dimensions"),this.uMatrix=a.getUniformLocation(c,"uMatrix"),this.aVertexPosition=a.getAttribLocation(c,"aVertexPosition"),this.aPositionCoord=a.getAttribLocation(c,"aPositionCoord"),this.aScale=a.getAttribLocation(c,"aScale"),this.aRotation=a.getAttribLocation(c,"aRotation"),this.aTextureCoord=a.getAttribLocation(c,"aTextureCoord"),this.colorAttribute=a.getAttribLocation(c,"aColor"),-1===this.colorAttribute&&(this.colorAttribute=2),this.attributes=[this.aVertexPosition,this.aPositionCoord,this.aScale,this.aRotation,this.aTextureCoord,this.colorAttribute],this.program=c},b.PixiFastShader.prototype.destroy=function(){this.gl.deleteProgram(this.program),this.uniforms=null,this.gl=null,this.attributes=null},b.StripShader=function(a){this._UID=b._UID++,this.gl=a,this.program=null,this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","uniform float alpha;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y)) * alpha;","}"],this.vertexSrc=["attribute vec2 aVertexPosition;","attribute vec2 aTextureCoord;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","varying vec2 vTextureCoord;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, v.y / -projectionVector.y + 1.0 , 0.0, 1.0);","   vTextureCoord = aTextureCoord;","}"],this.init()},b.StripShader.prototype.constructor=b.StripShader,b.StripShader.prototype.init=function(){var a=this.gl,c=b.compileProgram(a,this.vertexSrc,this.fragmentSrc);a.useProgram(c),this.uSampler=a.getUniformLocation(c,"uSampler"),this.projectionVector=a.getUniformLocation(c,"projectionVector"),this.offsetVector=a.getUniformLocation(c,"offsetVector"),this.colorAttribute=a.getAttribLocation(c,"aColor"),this.aVertexPosition=a.getAttribLocation(c,"aVertexPosition"),this.aTextureCoord=a.getAttribLocation(c,"aTextureCoord"),this.attributes=[this.aVertexPosition,this.aTextureCoord],this.translationMatrix=a.getUniformLocation(c,"translationMatrix"),this.alpha=a.getUniformLocation(c,"alpha"),this.program=c},b.StripShader.prototype.destroy=function(){this.gl.deleteProgram(this.program),this.uniforms=null,this.gl=null,this.attribute=null},b.PrimitiveShader=function(a){this._UID=b._UID++,this.gl=a,this.program=null,this.fragmentSrc=["precision mediump float;","varying vec4 vColor;","void main(void) {","   gl_FragColor = vColor;","}"],this.vertexSrc=["attribute vec2 aVertexPosition;","attribute vec4 aColor;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","uniform float alpha;","uniform float flipY;","uniform vec3 tint;","varying vec4 vColor;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, (v.y / projectionVector.y * -flipY) + flipY , 0.0, 1.0);","   vColor = aColor * vec4(tint * alpha, alpha);","}"],this.init()},b.PrimitiveShader.prototype.constructor=b.PrimitiveShader,b.PrimitiveShader.prototype.init=function(){var a=this.gl,c=b.compileProgram(a,this.vertexSrc,this.fragmentSrc);a.useProgram(c),this.projectionVector=a.getUniformLocation(c,"projectionVector"),this.offsetVector=a.getUniformLocation(c,"offsetVector"),this.tintColor=a.getUniformLocation(c,"tint"),this.flipY=a.getUniformLocation(c,"flipY"),this.aVertexPosition=a.getAttribLocation(c,"aVertexPosition"),this.colorAttribute=a.getAttribLocation(c,"aColor"),this.attributes=[this.aVertexPosition,this.colorAttribute],this.translationMatrix=a.getUniformLocation(c,"translationMatrix"),this.alpha=a.getUniformLocation(c,"alpha"),this.program=c},b.PrimitiveShader.prototype.destroy=function(){this.gl.deleteProgram(this.program),this.uniforms=null,this.gl=null,this.attributes=null},b.ComplexPrimitiveShader=function(a){this._UID=b._UID++,this.gl=a,this.program=null,this.fragmentSrc=["precision mediump float;","varying vec4 vColor;","void main(void) {","   gl_FragColor = vColor;","}"],this.vertexSrc=["attribute vec2 aVertexPosition;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","uniform vec3 tint;","uniform float alpha;","uniform vec3 color;","uniform float flipY;","varying vec4 vColor;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, (v.y / projectionVector.y * -flipY) + flipY , 0.0, 1.0);","   vColor = vec4(color * alpha * tint, alpha);","}"],this.init()},b.ComplexPrimitiveShader.prototype.constructor=b.ComplexPrimitiveShader,b.ComplexPrimitiveShader.prototype.init=function(){var a=this.gl,c=b.compileProgram(a,this.vertexSrc,this.fragmentSrc);a.useProgram(c),this.projectionVector=a.getUniformLocation(c,"projectionVector"),this.offsetVector=a.getUniformLocation(c,"offsetVector"),this.tintColor=a.getUniformLocation(c,"tint"),this.color=a.getUniformLocation(c,"color"),this.flipY=a.getUniformLocation(c,"flipY"),this.aVertexPosition=a.getAttribLocation(c,"aVertexPosition"),this.attributes=[this.aVertexPosition,this.colorAttribute],this.translationMatrix=a.getUniformLocation(c,"translationMatrix"),this.alpha=a.getUniformLocation(c,"alpha"),this.program=c},b.ComplexPrimitiveShader.prototype.destroy=function(){this.gl.deleteProgram(this.program),this.uniforms=null,this.gl=null,this.attribute=null},b.WebGLGraphics=function(){},b.WebGLGraphics.renderGraphics=function(a,c){var d,e=c.gl,f=c.projection,g=c.offset,h=c.shaderManager.primitiveShader;a.dirty&&b.WebGLGraphics.updateGraphics(a,e);for(var i=a._webGL[e.id],j=0;j<i.data.length;j++)1===i.data[j].mode?(d=i.data[j],c.stencilManager.pushStencil(a,d,c),e.drawElements(e.TRIANGLE_FAN,4,e.UNSIGNED_SHORT,2*(d.indices.length-4)),c.stencilManager.popStencil(a,d,c)):(d=i.data[j],c.shaderManager.setShader(h),h=c.shaderManager.primitiveShader,e.uniformMatrix3fv(h.translationMatrix,!1,a.worldTransform.toArray(!0)),e.uniform1f(h.flipY,1),e.uniform2f(h.projectionVector,f.x,-f.y),e.uniform2f(h.offsetVector,-g.x,-g.y),e.uniform3fv(h.tintColor,b.hex2rgb(a.tint)),e.uniform1f(h.alpha,a.worldAlpha),e.bindBuffer(e.ARRAY_BUFFER,d.buffer),e.vertexAttribPointer(h.aVertexPosition,2,e.FLOAT,!1,24,0),e.vertexAttribPointer(h.colorAttribute,4,e.FLOAT,!1,24,8),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,d.indexBuffer),e.drawElements(e.TRIANGLE_STRIP,d.indices.length,e.UNSIGNED_SHORT,0))},b.WebGLGraphics.updateGraphics=function(a,c){var d=a._webGL[c.id];d||(d=a._webGL[c.id]={lastIndex:0,data:[],gl:c}),a.dirty=!1;var e;if(a.clearDirty){for(a.clearDirty=!1,e=0;e<d.data.length;e++){var f=d.data[e];f.reset(),b.WebGLGraphics.graphicsDataPool.push(f)}d.data=[],d.lastIndex=0}var g;for(e=d.lastIndex;e<a.graphicsData.length;e++){var h=a.graphicsData[e];if(h.type===b.Graphics.POLY){if(h.points=h.shape.points.slice(),h.shape.closed&&(h.points[0]!==h.points[h.points.length-2]||h.points[1]!==h.points[h.points.length-1])&&h.points.push(h.points[0],h.points[1]),h.fill&&h.points.length>=6)if(h.points.length<12){g=b.WebGLGraphics.switchMode(d,0);var i=b.WebGLGraphics.buildPoly(h,g);i||(g=b.WebGLGraphics.switchMode(d,1),b.WebGLGraphics.buildComplexPoly(h,g))}else g=b.WebGLGraphics.switchMode(d,1),b.WebGLGraphics.buildComplexPoly(h,g);h.lineWidth>0&&(g=b.WebGLGraphics.switchMode(d,0),b.WebGLGraphics.buildLine(h,g))}else g=b.WebGLGraphics.switchMode(d,0),h.type===b.Graphics.RECT?b.WebGLGraphics.buildRectangle(h,g):h.type===b.Graphics.CIRC||h.type===b.Graphics.ELIP?b.WebGLGraphics.buildCircle(h,g):h.type===b.Graphics.RREC&&b.WebGLGraphics.buildRoundedRectangle(h,g);d.lastIndex++}for(e=0;e<d.data.length;e++)g=d.data[e],g.dirty&&g.upload()},b.WebGLGraphics.switchMode=function(a,c){var d;return a.data.length?(d=a.data[a.data.length-1],(d.mode!==c||1===c)&&(d=b.WebGLGraphics.graphicsDataPool.pop()||new b.WebGLGraphicsData(a.gl),d.mode=c,a.data.push(d))):(d=b.WebGLGraphics.graphicsDataPool.pop()||new b.WebGLGraphicsData(a.gl),d.mode=c,a.data.push(d)),d.dirty=!0,d},b.WebGLGraphics.buildRectangle=function(a,c){var d=a.shape,e=d.x,f=d.y,g=d.width,h=d.height;if(a.fill){var i=b.hex2rgb(a.fillColor),j=a.fillAlpha,k=i[0]*j,l=i[1]*j,m=i[2]*j,n=c.points,o=c.indices,p=n.length/6;n.push(e,f),n.push(k,l,m,j),n.push(e+g,f),n.push(k,l,m,j),n.push(e,f+h),n.push(k,l,m,j),n.push(e+g,f+h),n.push(k,l,m,j),o.push(p,p,p+1,p+2,p+3,p+3)}if(a.lineWidth){var q=a.points;a.points=[e,f,e+g,f,e+g,f+h,e,f+h,e,f],b.WebGLGraphics.buildLine(a,c),a.points=q}},b.WebGLGraphics.buildRoundedRectangle=function(a,c){var d=a.shape,e=d.x,f=d.y,g=d.width,h=d.height,i=d.radius,j=[];if(j.push(e,f+i),j=j.concat(b.WebGLGraphics.quadraticBezierCurve(e,f+h-i,e,f+h,e+i,f+h)),j=j.concat(b.WebGLGraphics.quadraticBezierCurve(e+g-i,f+h,e+g,f+h,e+g,f+h-i)),j=j.concat(b.WebGLGraphics.quadraticBezierCurve(e+g,f+i,e+g,f,e+g-i,f)),j=j.concat(b.WebGLGraphics.quadraticBezierCurve(e+i,f,e,f,e,f+i)),a.fill){var k=b.hex2rgb(a.fillColor),l=a.fillAlpha,m=k[0]*l,n=k[1]*l,o=k[2]*l,p=c.points,q=c.indices,r=p.length/6,s=b.PolyK.Triangulate(j),t=0;

for(t=0;t<s.length;t+=3)q.push(s[t]+r),q.push(s[t]+r),q.push(s[t+1]+r),q.push(s[t+2]+r),q.push(s[t+2]+r);for(t=0;t<j.length;t++)p.push(j[t],j[++t],m,n,o,l)}if(a.lineWidth){var u=a.points;a.points=j,b.WebGLGraphics.buildLine(a,c),a.points=u}},b.WebGLGraphics.quadraticBezierCurve=function(a,b,c,d,e,f){function g(a,b,c){var d=b-a;return a+d*c}for(var h,i,j,k,l,m,n=20,o=[],p=0,q=0;n>=q;q++)p=q/n,h=g(a,c,p),i=g(b,d,p),j=g(c,e,p),k=g(d,f,p),l=g(h,j,p),m=g(i,k,p),o.push(l,m);return o},b.WebGLGraphics.buildCircle=function(a,c){var d,e,f=a.shape,g=f.x,h=f.y;a.type===b.Graphics.CIRC?(d=f.radius,e=f.radius):(d=f.width,e=f.height);var i=40,j=2*Math.PI/i,k=0;if(a.fill){var l=b.hex2rgb(a.fillColor),m=a.fillAlpha,n=l[0]*m,o=l[1]*m,p=l[2]*m,q=c.points,r=c.indices,s=q.length/6;for(r.push(s),k=0;i+1>k;k++)q.push(g,h,n,o,p,m),q.push(g+Math.sin(j*k)*d,h+Math.cos(j*k)*e,n,o,p,m),r.push(s++,s++);r.push(s-1)}if(a.lineWidth){var t=a.points;for(a.points=[],k=0;i+1>k;k++)a.points.push(g+Math.sin(j*k)*d,h+Math.cos(j*k)*e);b.WebGLGraphics.buildLine(a,c),a.points=t}},b.WebGLGraphics.buildLine=function(a,c){var d=0,e=a.points;if(0!==e.length){if(a.lineWidth%2)for(d=0;d<e.length;d++)e[d]+=.5;var f=new b.Point(e[0],e[1]),g=new b.Point(e[e.length-2],e[e.length-1]);if(f.x===g.x&&f.y===g.y){e=e.slice(),e.pop(),e.pop(),g=new b.Point(e[e.length-2],e[e.length-1]);var h=g.x+.5*(f.x-g.x),i=g.y+.5*(f.y-g.y);e.unshift(h,i),e.push(h,i)}var j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G=c.points,H=c.indices,I=e.length/2,J=e.length,K=G.length/6,L=a.lineWidth/2,M=b.hex2rgb(a.lineColor),N=a.lineAlpha,O=M[0]*N,P=M[1]*N,Q=M[2]*N;for(l=e[0],m=e[1],n=e[2],o=e[3],r=-(m-o),s=l-n,F=Math.sqrt(r*r+s*s),r/=F,s/=F,r*=L,s*=L,G.push(l-r,m-s,O,P,Q,N),G.push(l+r,m+s,O,P,Q,N),d=1;I-1>d;d++)l=e[2*(d-1)],m=e[2*(d-1)+1],n=e[2*d],o=e[2*d+1],p=e[2*(d+1)],q=e[2*(d+1)+1],r=-(m-o),s=l-n,F=Math.sqrt(r*r+s*s),r/=F,s/=F,r*=L,s*=L,t=-(o-q),u=n-p,F=Math.sqrt(t*t+u*u),t/=F,u/=F,t*=L,u*=L,x=-s+m-(-s+o),y=-r+n-(-r+l),z=(-r+l)*(-s+o)-(-r+n)*(-s+m),A=-u+q-(-u+o),B=-t+n-(-t+p),C=(-t+p)*(-u+o)-(-t+n)*(-u+q),D=x*B-A*y,Math.abs(D)<.1?(D+=10.1,G.push(n-r,o-s,O,P,Q,N),G.push(n+r,o+s,O,P,Q,N)):(j=(y*C-B*z)/D,k=(A*z-x*C)/D,E=(j-n)*(j-n)+(k-o)+(k-o),E>19600?(v=r-t,w=s-u,F=Math.sqrt(v*v+w*w),v/=F,w/=F,v*=L,w*=L,G.push(n-v,o-w),G.push(O,P,Q,N),G.push(n+v,o+w),G.push(O,P,Q,N),G.push(n-v,o-w),G.push(O,P,Q,N),J++):(G.push(j,k),G.push(O,P,Q,N),G.push(n-(j-n),o-(k-o)),G.push(O,P,Q,N)));for(l=e[2*(I-2)],m=e[2*(I-2)+1],n=e[2*(I-1)],o=e[2*(I-1)+1],r=-(m-o),s=l-n,F=Math.sqrt(r*r+s*s),r/=F,s/=F,r*=L,s*=L,G.push(n-r,o-s),G.push(O,P,Q,N),G.push(n+r,o+s),G.push(O,P,Q,N),H.push(K),d=0;J>d;d++)H.push(K++);H.push(K-1)}},b.WebGLGraphics.buildComplexPoly=function(a,c){var d=a.points.slice();if(!(d.length<6)){var e=c.indices;c.points=d,c.alpha=a.fillAlpha,c.color=b.hex2rgb(a.fillColor);for(var f,g,h=1/0,i=-(1/0),j=1/0,k=-(1/0),l=0;l<d.length;l+=2)f=d[l],g=d[l+1],h=h>f?f:h,i=f>i?f:i,j=j>g?g:j,k=g>k?g:k;d.push(h,j,i,j,i,k,h,k);var m=d.length/2;for(l=0;m>l;l++)e.push(l)}},b.WebGLGraphics.buildPoly=function(a,c){var d=a.points;if(!(d.length<6)){var e=c.points,f=c.indices,g=d.length/2,h=b.hex2rgb(a.fillColor),i=a.fillAlpha,j=h[0]*i,k=h[1]*i,l=h[2]*i,m=b.PolyK.Triangulate(d);if(!m)return!1;var n=e.length/6,o=0;for(o=0;o<m.length;o+=3)f.push(m[o]+n),f.push(m[o]+n),f.push(m[o+1]+n),f.push(m[o+2]+n),f.push(m[o+2]+n);for(o=0;g>o;o++)e.push(d[2*o],d[2*o+1],j,k,l,i);return!0}},b.WebGLGraphics.graphicsDataPool=[],b.WebGLGraphicsData=function(a){this.gl=a,this.color=[0,0,0],this.points=[],this.indices=[],this.buffer=a.createBuffer(),this.indexBuffer=a.createBuffer(),this.mode=1,this.alpha=1,this.dirty=!0},b.WebGLGraphicsData.prototype.reset=function(){this.points=[],this.indices=[]},b.WebGLGraphicsData.prototype.upload=function(){var a=this.gl;this.glPoints=new b.Float32Array(this.points),a.bindBuffer(a.ARRAY_BUFFER,this.buffer),a.bufferData(a.ARRAY_BUFFER,this.glPoints,a.STATIC_DRAW),this.glIndicies=new b.Uint16Array(this.indices),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.indexBuffer),a.bufferData(a.ELEMENT_ARRAY_BUFFER,this.glIndicies,a.STATIC_DRAW),this.dirty=!1},b.glContexts=[],b.instances=[],b.WebGLRenderer=function(a,c,d){if(d)for(var e in b.defaultRenderOptions)"undefined"==typeof d[e]&&(d[e]=b.defaultRenderOptions[e]);else d=b.defaultRenderOptions;b.defaultRenderer||(b.sayHello("webGL"),b.defaultRenderer=this),this.type=b.WEBGL_RENDERER,this.resolution=d.resolution,this.transparent=d.transparent,this.autoResize=d.autoResize||!1,this.preserveDrawingBuffer=d.preserveDrawingBuffer,this.clearBeforeRender=d.clearBeforeRender,this.width=a||800,this.height=c||600,this.view=d.view||document.createElement("canvas"),this.contextLostBound=this.handleContextLost.bind(this),this.contextRestoredBound=this.handleContextRestored.bind(this),this.view.addEventListener("webglcontextlost",this.contextLostBound,!1),this.view.addEventListener("webglcontextrestored",this.contextRestoredBound,!1),this._contextOptions={alpha:this.transparent,antialias:d.antialias,premultipliedAlpha:this.transparent&&"notMultiplied"!==this.transparent,stencil:!0,preserveDrawingBuffer:d.preserveDrawingBuffer},this.projection=new b.Point,this.offset=new b.Point(0,0),this.shaderManager=new b.WebGLShaderManager,this.spriteBatch=new b.WebGLSpriteBatch,this.maskManager=new b.WebGLMaskManager,this.filterManager=new b.WebGLFilterManager,this.stencilManager=new b.WebGLStencilManager,this.blendModeManager=new b.WebGLBlendModeManager,this.renderSession={},this.renderSession.gl=this.gl,this.renderSession.drawCount=0,this.renderSession.shaderManager=this.shaderManager,this.renderSession.maskManager=this.maskManager,this.renderSession.filterManager=this.filterManager,this.renderSession.blendModeManager=this.blendModeManager,this.renderSession.spriteBatch=this.spriteBatch,this.renderSession.stencilManager=this.stencilManager,this.renderSession.renderer=this,this.renderSession.resolution=this.resolution,this.initContext(),this.mapBlendModes()},b.WebGLRenderer.prototype.constructor=b.WebGLRenderer,b.WebGLRenderer.prototype.initContext=function(){var a=this.view.getContext("webgl",this._contextOptions)||this.view.getContext("experimental-webgl",this._contextOptions);if(this.gl=a,!a)throw new Error("This browser does not support webGL. Try using the canvas renderer");this.glContextId=a.id=b.WebGLRenderer.glContextId++,b.glContexts[this.glContextId]=a,b.instances[this.glContextId]=this,a.disable(a.DEPTH_TEST),a.disable(a.CULL_FACE),a.enable(a.BLEND),this.shaderManager.setContext(a),this.spriteBatch.setContext(a),this.maskManager.setContext(a),this.filterManager.setContext(a),this.blendModeManager.setContext(a),this.stencilManager.setContext(a),this.renderSession.gl=this.gl,this.resize(this.width,this.height)},b.WebGLRenderer.prototype.render=function(a){if(!this.contextLost){this.__stage!==a&&(a.interactive&&a.interactionManager.removeEvents(),this.__stage=a),a.updateTransform();var b=this.gl;a._interactive?a._interactiveEventsAdded||(a._interactiveEventsAdded=!0,a.interactionManager.setTarget(this)):a._interactiveEventsAdded&&(a._interactiveEventsAdded=!1,a.interactionManager.setTarget(this)),b.viewport(0,0,this.width,this.height),b.bindFramebuffer(b.FRAMEBUFFER,null),this.clearBeforeRender&&(this.transparent?b.clearColor(0,0,0,0):b.clearColor(a.backgroundColorSplit[0],a.backgroundColorSplit[1],a.backgroundColorSplit[2],1),b.clear(b.COLOR_BUFFER_BIT)),this.renderDisplayObject(a,this.projection)}},b.WebGLRenderer.prototype.renderDisplayObject=function(a,c,d){this.renderSession.blendModeManager.setBlendMode(b.blendModes.NORMAL),this.renderSession.drawCount=0,this.renderSession.flipY=d?-1:1,this.renderSession.projection=c,this.renderSession.offset=this.offset,this.spriteBatch.begin(this.renderSession),this.filterManager.begin(this.renderSession,d),a._renderWebGL(this.renderSession),this.spriteBatch.end()},b.WebGLRenderer.prototype.resize=function(a,b){this.width=a*this.resolution,this.height=b*this.resolution,this.view.width=this.width,this.view.height=this.height,this.autoResize&&(this.view.style.width=this.width/this.resolution+"px",this.view.style.height=this.height/this.resolution+"px"),this.gl.viewport(0,0,this.width,this.height),this.projection.x=this.width/2/this.resolution,this.projection.y=-this.height/2/this.resolution},b.WebGLRenderer.prototype.updateTexture=function(a){if(a.hasLoaded){var c=this.gl;return a._glTextures[c.id]||(a._glTextures[c.id]=c.createTexture()),c.bindTexture(c.TEXTURE_2D,a._glTextures[c.id]),c.pixelStorei(c.UNPACK_PREMULTIPLY_ALPHA_WEBGL,a.premultipliedAlpha),c.texImage2D(c.TEXTURE_2D,0,c.RGBA,c.RGBA,c.UNSIGNED_BYTE,a.source),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,a.scaleMode===b.scaleModes.LINEAR?c.LINEAR:c.NEAREST),a.mipmap&&b.isPowerOfTwo(a.width,a.height)?(c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,a.scaleMode===b.scaleModes.LINEAR?c.LINEAR_MIPMAP_LINEAR:c.NEAREST_MIPMAP_NEAREST),c.generateMipmap(c.TEXTURE_2D)):c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,a.scaleMode===b.scaleModes.LINEAR?c.LINEAR:c.NEAREST),a._powerOf2?(c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.REPEAT),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.REPEAT)):(c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE)),a._dirty[c.id]=!1,a._glTextures[c.id]}},b.WebGLRenderer.prototype.handleContextLost=function(a){a.preventDefault(),this.contextLost=!0},b.WebGLRenderer.prototype.handleContextRestored=function(){this.initContext();for(var a in b.TextureCache){var c=b.TextureCache[a].baseTexture;c._glTextures=[]}this.contextLost=!1},b.WebGLRenderer.prototype.destroy=function(){this.view.removeEventListener("webglcontextlost",this.contextLostBound),this.view.removeEventListener("webglcontextrestored",this.contextRestoredBound),b.glContexts[this.glContextId]=null,this.projection=null,this.offset=null,this.shaderManager.destroy(),this.spriteBatch.destroy(),this.maskManager.destroy(),this.filterManager.destroy(),this.shaderManager=null,this.spriteBatch=null,this.maskManager=null,this.filterManager=null,this.gl=null,this.renderSession=null},b.WebGLRenderer.prototype.mapBlendModes=function(){var a=this.gl;b.blendModesWebGL||(b.blendModesWebGL=[],b.blendModesWebGL[b.blendModes.NORMAL]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.ADD]=[a.SRC_ALPHA,a.DST_ALPHA],b.blendModesWebGL[b.blendModes.MULTIPLY]=[a.DST_COLOR,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.SCREEN]=[a.SRC_ALPHA,a.ONE],b.blendModesWebGL[b.blendModes.OVERLAY]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.DARKEN]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.LIGHTEN]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.COLOR_DODGE]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.COLOR_BURN]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.HARD_LIGHT]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.SOFT_LIGHT]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.DIFFERENCE]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.EXCLUSION]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.HUE]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.SATURATION]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.COLOR]=[a.ONE,a.ONE_MINUS_SRC_ALPHA],b.blendModesWebGL[b.blendModes.LUMINOSITY]=[a.ONE,a.ONE_MINUS_SRC_ALPHA])},b.WebGLRenderer.glContextId=0,b.WebGLBlendModeManager=function(){this.currentBlendMode=99999},b.WebGLBlendModeManager.prototype.constructor=b.WebGLBlendModeManager,b.WebGLBlendModeManager.prototype.setContext=function(a){this.gl=a},b.WebGLBlendModeManager.prototype.setBlendMode=function(a){if(this.currentBlendMode===a)return!1;this.currentBlendMode=a;var c=b.blendModesWebGL[this.currentBlendMode];return this.gl.blendFunc(c[0],c[1]),!0},b.WebGLBlendModeManager.prototype.destroy=function(){this.gl=null},b.WebGLMaskManager=function(){},b.WebGLMaskManager.prototype.constructor=b.WebGLMaskManager,b.WebGLMaskManager.prototype.setContext=function(a){this.gl=a},b.WebGLMaskManager.prototype.pushMask=function(a,c){var d=c.gl;a.dirty&&b.WebGLGraphics.updateGraphics(a,d),a._webGL[d.id].data.length&&c.stencilManager.pushStencil(a,a._webGL[d.id].data[0],c)},b.WebGLMaskManager.prototype.popMask=function(a,b){var c=this.gl;b.stencilManager.popStencil(a,a._webGL[c.id].data[0],b)},b.WebGLMaskManager.prototype.destroy=function(){this.gl=null},b.WebGLStencilManager=function(){this.stencilStack=[],this.reverse=!0,this.count=0},b.WebGLStencilManager.prototype.setContext=function(a){this.gl=a},b.WebGLStencilManager.prototype.pushStencil=function(a,b,c){var d=this.gl;this.bindGraphics(a,b,c),0===this.stencilStack.length&&(d.enable(d.STENCIL_TEST),d.clear(d.STENCIL_BUFFER_BIT),this.reverse=!0,this.count=0),this.stencilStack.push(b);var e=this.count;d.colorMask(!1,!1,!1,!1),d.stencilFunc(d.ALWAYS,0,255),d.stencilOp(d.KEEP,d.KEEP,d.INVERT),1===b.mode?(d.drawElements(d.TRIANGLE_FAN,b.indices.length-4,d.UNSIGNED_SHORT,0),this.reverse?(d.stencilFunc(d.EQUAL,255-e,255),d.stencilOp(d.KEEP,d.KEEP,d.DECR)):(d.stencilFunc(d.EQUAL,e,255),d.stencilOp(d.KEEP,d.KEEP,d.INCR)),d.drawElements(d.TRIANGLE_FAN,4,d.UNSIGNED_SHORT,2*(b.indices.length-4)),this.reverse?d.stencilFunc(d.EQUAL,255-(e+1),255):d.stencilFunc(d.EQUAL,e+1,255),this.reverse=!this.reverse):(this.reverse?(d.stencilFunc(d.EQUAL,e,255),d.stencilOp(d.KEEP,d.KEEP,d.INCR)):(d.stencilFunc(d.EQUAL,255-e,255),d.stencilOp(d.KEEP,d.KEEP,d.DECR)),d.drawElements(d.TRIANGLE_STRIP,b.indices.length,d.UNSIGNED_SHORT,0),this.reverse?d.stencilFunc(d.EQUAL,e+1,255):d.stencilFunc(d.EQUAL,255-(e+1),255)),d.colorMask(!0,!0,!0,!0),d.stencilOp(d.KEEP,d.KEEP,d.KEEP),this.count++},b.WebGLStencilManager.prototype.bindGraphics=function(a,c,d){this._currentGraphics=a;var e,f=this.gl,g=d.projection,h=d.offset;1===c.mode?(e=d.shaderManager.complexPrimitiveShader,d.shaderManager.setShader(e),f.uniform1f(e.flipY,d.flipY),f.uniformMatrix3fv(e.translationMatrix,!1,a.worldTransform.toArray(!0)),f.uniform2f(e.projectionVector,g.x,-g.y),f.uniform2f(e.offsetVector,-h.x,-h.y),f.uniform3fv(e.tintColor,b.hex2rgb(a.tint)),f.uniform3fv(e.color,c.color),f.uniform1f(e.alpha,a.worldAlpha*c.alpha),f.bindBuffer(f.ARRAY_BUFFER,c.buffer),f.vertexAttribPointer(e.aVertexPosition,2,f.FLOAT,!1,8,0),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,c.indexBuffer)):(e=d.shaderManager.primitiveShader,d.shaderManager.setShader(e),f.uniformMatrix3fv(e.translationMatrix,!1,a.worldTransform.toArray(!0)),f.uniform1f(e.flipY,d.flipY),f.uniform2f(e.projectionVector,g.x,-g.y),f.uniform2f(e.offsetVector,-h.x,-h.y),f.uniform3fv(e.tintColor,b.hex2rgb(a.tint)),f.uniform1f(e.alpha,a.worldAlpha),f.bindBuffer(f.ARRAY_BUFFER,c.buffer),f.vertexAttribPointer(e.aVertexPosition,2,f.FLOAT,!1,24,0),f.vertexAttribPointer(e.colorAttribute,4,f.FLOAT,!1,24,8),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,c.indexBuffer))},b.WebGLStencilManager.prototype.popStencil=function(a,b,c){var d=this.gl;if(this.stencilStack.pop(),this.count--,0===this.stencilStack.length)d.disable(d.STENCIL_TEST);else{var e=this.count;this.bindGraphics(a,b,c),d.colorMask(!1,!1,!1,!1),1===b.mode?(this.reverse=!this.reverse,this.reverse?(d.stencilFunc(d.EQUAL,255-(e+1),255),d.stencilOp(d.KEEP,d.KEEP,d.INCR)):(d.stencilFunc(d.EQUAL,e+1,255),d.stencilOp(d.KEEP,d.KEEP,d.DECR)),d.drawElements(d.TRIANGLE_FAN,4,d.UNSIGNED_SHORT,2*(b.indices.length-4)),d.stencilFunc(d.ALWAYS,0,255),d.stencilOp(d.KEEP,d.KEEP,d.INVERT),d.drawElements(d.TRIANGLE_FAN,b.indices.length-4,d.UNSIGNED_SHORT,0),this.reverse?d.stencilFunc(d.EQUAL,e,255):d.stencilFunc(d.EQUAL,255-e,255)):(this.reverse?(d.stencilFunc(d.EQUAL,e+1,255),d.stencilOp(d.KEEP,d.KEEP,d.DECR)):(d.stencilFunc(d.EQUAL,255-(e+1),255),d.stencilOp(d.KEEP,d.KEEP,d.INCR)),d.drawElements(d.TRIANGLE_STRIP,b.indices.length,d.UNSIGNED_SHORT,0),this.reverse?d.stencilFunc(d.EQUAL,e,255):d.stencilFunc(d.EQUAL,255-e,255)),d.colorMask(!0,!0,!0,!0),d.stencilOp(d.KEEP,d.KEEP,d.KEEP)}},b.WebGLStencilManager.prototype.destroy=function(){this.stencilStack=null,this.gl=null},b.WebGLShaderManager=function(){this.maxAttibs=10,this.attribState=[],this.tempAttribState=[];for(var a=0;a<this.maxAttibs;a++)this.attribState[a]=!1;this.stack=[]},b.WebGLShaderManager.prototype.constructor=b.WebGLShaderManager,b.WebGLShaderManager.prototype.setContext=function(a){this.gl=a,this.primitiveShader=new b.PrimitiveShader(a),this.complexPrimitiveShader=new b.ComplexPrimitiveShader(a),this.defaultShader=new b.PixiShader(a),this.fastShader=new b.PixiFastShader(a),this.stripShader=new b.StripShader(a),this.setShader(this.defaultShader)},b.WebGLShaderManager.prototype.setAttribs=function(a){var b;for(b=0;b<this.tempAttribState.length;b++)this.tempAttribState[b]=!1;for(b=0;b<a.length;b++){var c=a[b];this.tempAttribState[c]=!0}var d=this.gl;for(b=0;b<this.attribState.length;b++)this.attribState[b]!==this.tempAttribState[b]&&(this.attribState[b]=this.tempAttribState[b],this.tempAttribState[b]?d.enableVertexAttribArray(b):d.disableVertexAttribArray(b))},b.WebGLShaderManager.prototype.setShader=function(a){return this._currentId===a._UID?!1:(this._currentId=a._UID,this.currentShader=a,this.gl.useProgram(a.program),this.setAttribs(a.attributes),!0)},b.WebGLShaderManager.prototype.destroy=function(){this.attribState=null,this.tempAttribState=null,this.primitiveShader.destroy(),this.complexPrimitiveShader.destroy(),this.defaultShader.destroy(),this.fastShader.destroy(),this.stripShader.destroy(),this.gl=null},b.WebGLSpriteBatch=function(){this.vertSize=5,this.size=2e3;var a=4*this.size*4*this.vertSize,c=6*this.size;this.vertices=new b.ArrayBuffer(a),this.positions=new b.Float32Array(this.vertices),this.colors=new b.Uint32Array(this.vertices),this.indices=new b.Uint16Array(c),this.lastIndexCount=0;for(var d=0,e=0;c>d;d+=6,e+=4)this.indices[d+0]=e+0,this.indices[d+1]=e+1,this.indices[d+2]=e+2,this.indices[d+3]=e+0,this.indices[d+4]=e+2,this.indices[d+5]=e+3;this.drawing=!1,this.currentBatchSize=0,this.currentBaseTexture=null,this.dirty=!0,this.textures=[],this.blendModes=[],this.shaders=[],this.sprites=[],this.defaultShader=new b.AbstractFilter(["precision lowp float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord) * vColor ;","}"])},b.WebGLSpriteBatch.prototype.setContext=function(a){this.gl=a,this.vertexBuffer=a.createBuffer(),this.indexBuffer=a.createBuffer(),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.indexBuffer),a.bufferData(a.ELEMENT_ARRAY_BUFFER,this.indices,a.STATIC_DRAW),a.bindBuffer(a.ARRAY_BUFFER,this.vertexBuffer),a.bufferData(a.ARRAY_BUFFER,this.vertices,a.DYNAMIC_DRAW),this.currentBlendMode=99999;var c=new b.PixiShader(a);c.fragmentSrc=this.defaultShader.fragmentSrc,c.uniforms={},c.init(),this.defaultShader.shaders[a.id]=c},b.WebGLSpriteBatch.prototype.begin=function(a){this.renderSession=a,this.shader=this.renderSession.shaderManager.defaultShader,this.start()},b.WebGLSpriteBatch.prototype.end=function(){this.flush()},b.WebGLSpriteBatch.prototype.render=function(a){var b=a.texture;this.currentBatchSize>=this.size&&(this.flush(),this.currentBaseTexture=b.baseTexture);var c=b._uvs;if(c){var d,e,f,g,h=a.anchor.x,i=a.anchor.y;if(b.trim){var j=b.trim;e=j.x-h*j.width,d=e+b.crop.width,g=j.y-i*j.height,f=g+b.crop.height}else d=b.frame.width*(1-h),e=b.frame.width*-h,f=b.frame.height*(1-i),g=b.frame.height*-i;var k=4*this.currentBatchSize*this.vertSize,l=b.baseTexture.resolution,m=a.worldTransform,n=m.a/l,o=m.b/l,p=m.c/l,q=m.d/l,r=m.tx,s=m.ty,t=this.colors,u=this.positions;this.renderSession.roundPixels?(u[k]=n*e+p*g+r|0,u[k+1]=q*g+o*e+s|0,u[k+5]=n*d+p*g+r|0,u[k+6]=q*g+o*d+s|0,u[k+10]=n*d+p*f+r|0,u[k+11]=q*f+o*d+s|0,u[k+15]=n*e+p*f+r|0,u[k+16]=q*f+o*e+s|0):(u[k]=n*e+p*g+r,u[k+1]=q*g+o*e+s,u[k+5]=n*d+p*g+r,u[k+6]=q*g+o*d+s,u[k+10]=n*d+p*f+r,u[k+11]=q*f+o*d+s,u[k+15]=n*e+p*f+r,u[k+16]=q*f+o*e+s),u[k+2]=c.x0,u[k+3]=c.y0,u[k+7]=c.x1,u[k+8]=c.y1,u[k+12]=c.x2,u[k+13]=c.y2,u[k+17]=c.x3,u[k+18]=c.y3;var v=a.tint;t[k+4]=t[k+9]=t[k+14]=t[k+19]=(v>>16)+(65280&v)+((255&v)<<16)+(255*a.worldAlpha<<24),this.sprites[this.currentBatchSize++]=a}},b.WebGLSpriteBatch.prototype.renderTilingSprite=function(a){var c=a.tilingTexture;this.currentBatchSize>=this.size&&(this.flush(),this.currentBaseTexture=c.baseTexture),a._uvs||(a._uvs=new b.TextureUvs);var d=a._uvs;a.tilePosition.x%=c.baseTexture.width*a.tileScaleOffset.x,a.tilePosition.y%=c.baseTexture.height*a.tileScaleOffset.y;var e=a.tilePosition.x/(c.baseTexture.width*a.tileScaleOffset.x),f=a.tilePosition.y/(c.baseTexture.height*a.tileScaleOffset.y),g=a.width/c.baseTexture.width/(a.tileScale.x*a.tileScaleOffset.x),h=a.height/c.baseTexture.height/(a.tileScale.y*a.tileScaleOffset.y);d.x0=0-e,d.y0=0-f,d.x1=1*g-e,d.y1=0-f,d.x2=1*g-e,d.y2=1*h-f,d.x3=0-e,d.y3=1*h-f;var i=a.tint,j=(i>>16)+(65280&i)+((255&i)<<16)+(255*a.alpha<<24),k=this.positions,l=this.colors,m=a.width,n=a.height,o=a.anchor.x,p=a.anchor.y,q=m*(1-o),r=m*-o,s=n*(1-p),t=n*-p,u=4*this.currentBatchSize*this.vertSize,v=c.baseTexture.resolution,w=a.worldTransform,x=w.a/v,y=w.b/v,z=w.c/v,A=w.d/v,B=w.tx,C=w.ty;k[u++]=x*r+z*t+B,k[u++]=A*t+y*r+C,k[u++]=d.x0,k[u++]=d.y0,l[u++]=j,k[u++]=x*q+z*t+B,k[u++]=A*t+y*q+C,k[u++]=d.x1,k[u++]=d.y1,l[u++]=j,k[u++]=x*q+z*s+B,k[u++]=A*s+y*q+C,k[u++]=d.x2,k[u++]=d.y2,l[u++]=j,k[u++]=x*r+z*s+B,k[u++]=A*s+y*r+C,k[u++]=d.x3,k[u++]=d.y3,l[u++]=j,this.sprites[this.currentBatchSize++]=a},b.WebGLSpriteBatch.prototype.flush=function(){if(0!==this.currentBatchSize){var a,c=this.gl;if(this.dirty){this.dirty=!1,c.activeTexture(c.TEXTURE0),c.bindBuffer(c.ARRAY_BUFFER,this.vertexBuffer),c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,this.indexBuffer),a=this.defaultShader.shaders[c.id];var d=4*this.vertSize;c.vertexAttribPointer(a.aVertexPosition,2,c.FLOAT,!1,d,0),c.vertexAttribPointer(a.aTextureCoord,2,c.FLOAT,!1,d,8),c.vertexAttribPointer(a.colorAttribute,4,c.UNSIGNED_BYTE,!0,d,16)}if(this.currentBatchSize>.5*this.size)c.bufferSubData(c.ARRAY_BUFFER,0,this.vertices);else{var e=this.positions.subarray(0,4*this.currentBatchSize*this.vertSize);c.bufferSubData(c.ARRAY_BUFFER,0,e)}for(var f,g,h,i,j=0,k=0,l=null,m=this.renderSession.blendModeManager.currentBlendMode,n=null,o=!1,p=!1,q=0,r=this.currentBatchSize;r>q;q++){if(i=this.sprites[q],f=i.texture.baseTexture,g=i.blendMode,h=i.shader||this.defaultShader,o=m!==g,p=n!==h,(l!==f||o||p)&&(this.renderBatch(l,j,k),k=q,j=0,l=f,o&&(m=g,this.renderSession.blendModeManager.setBlendMode(m)),p)){n=h,a=n.shaders[c.id],a||(a=new b.PixiShader(c),a.fragmentSrc=n.fragmentSrc,a.uniforms=n.uniforms,a.init(),n.shaders[c.id]=a),this.renderSession.shaderManager.setShader(a),a.dirty&&a.syncUniforms();var s=this.renderSession.projection;c.uniform2f(a.projectionVector,s.x,s.y);var t=this.renderSession.offset;c.uniform2f(a.offsetVector,t.x,t.y)}j++}this.renderBatch(l,j,k),this.currentBatchSize=0}},b.WebGLSpriteBatch.prototype.renderBatch=function(a,b,c){if(0!==b){var d=this.gl;a._dirty[d.id]?this.renderSession.renderer.updateTexture(a):d.bindTexture(d.TEXTURE_2D,a._glTextures[d.id]),d.drawElements(d.TRIANGLES,6*b,d.UNSIGNED_SHORT,6*c*2),this.renderSession.drawCount++}},b.WebGLSpriteBatch.prototype.stop=function(){this.flush(),this.dirty=!0},b.WebGLSpriteBatch.prototype.start=function(){this.dirty=!0},b.WebGLSpriteBatch.prototype.destroy=function(){this.vertices=null,this.indices=null,this.gl.deleteBuffer(this.vertexBuffer),this.gl.deleteBuffer(this.indexBuffer),this.currentBaseTexture=null,this.gl=null},b.WebGLFastSpriteBatch=function(a){this.vertSize=10,this.maxSize=6e3,this.size=this.maxSize;var c=4*this.size*this.vertSize,d=6*this.maxSize;this.vertices=new b.Float32Array(c),this.indices=new b.Uint16Array(d),this.vertexBuffer=null,this.indexBuffer=null,this.lastIndexCount=0;for(var e=0,f=0;d>e;e+=6,f+=4)this.indices[e+0]=f+0,this.indices[e+1]=f+1,this.indices[e+2]=f+2,this.indices[e+3]=f+0,this.indices[e+4]=f+2,this.indices[e+5]=f+3;this.drawing=!1,this.currentBatchSize=0,this.currentBaseTexture=null,this.currentBlendMode=0,this.renderSession=null,this.shader=null,this.matrix=null,this.setContext(a)},b.WebGLFastSpriteBatch.prototype.constructor=b.WebGLFastSpriteBatch,b.WebGLFastSpriteBatch.prototype.setContext=function(a){this.gl=a,this.vertexBuffer=a.createBuffer(),this.indexBuffer=a.createBuffer(),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.indexBuffer),a.bufferData(a.ELEMENT_ARRAY_BUFFER,this.indices,a.STATIC_DRAW),a.bindBuffer(a.ARRAY_BUFFER,this.vertexBuffer),a.bufferData(a.ARRAY_BUFFER,this.vertices,a.DYNAMIC_DRAW)},b.WebGLFastSpriteBatch.prototype.begin=function(a,b){this.renderSession=b,this.shader=this.renderSession.shaderManager.fastShader,this.matrix=a.worldTransform.toArray(!0),this.start()},b.WebGLFastSpriteBatch.prototype.end=function(){this.flush()},b.WebGLFastSpriteBatch.prototype.render=function(a){var b=a.children,c=b[0];if(c.texture._uvs){this.currentBaseTexture=c.texture.baseTexture,c.blendMode!==this.renderSession.blendModeManager.currentBlendMode&&(this.flush(),this.renderSession.blendModeManager.setBlendMode(c.blendMode));for(var d=0,e=b.length;e>d;d++)this.renderSprite(b[d]);this.flush()}},b.WebGLFastSpriteBatch.prototype.renderSprite=function(a){if(a.visible&&(a.texture.baseTexture===this.currentBaseTexture||(this.flush(),this.currentBaseTexture=a.texture.baseTexture,a.texture._uvs))){var b,c,d,e,f,g,h,i,j=this.vertices;if(b=a.texture._uvs,c=a.texture.frame.width,d=a.texture.frame.height,a.texture.trim){var k=a.texture.trim;f=k.x-a.anchor.x*k.width,e=f+a.texture.crop.width,h=k.y-a.anchor.y*k.height,g=h+a.texture.crop.height}else e=a.texture.frame.width*(1-a.anchor.x),f=a.texture.frame.width*-a.anchor.x,g=a.texture.frame.height*(1-a.anchor.y),h=a.texture.frame.height*-a.anchor.y;i=4*this.currentBatchSize*this.vertSize,j[i++]=f,j[i++]=h,j[i++]=a.position.x,j[i++]=a.position.y,j[i++]=a.scale.x,j[i++]=a.scale.y,j[i++]=a.rotation,j[i++]=b.x0,j[i++]=b.y1,j[i++]=a.alpha,j[i++]=e,j[i++]=h,j[i++]=a.position.x,j[i++]=a.position.y,j[i++]=a.scale.x,j[i++]=a.scale.y,j[i++]=a.rotation,j[i++]=b.x1,j[i++]=b.y1,j[i++]=a.alpha,j[i++]=e,j[i++]=g,j[i++]=a.position.x,j[i++]=a.position.y,j[i++]=a.scale.x,j[i++]=a.scale.y,j[i++]=a.rotation,j[i++]=b.x2,j[i++]=b.y2,j[i++]=a.alpha,j[i++]=f,j[i++]=g,j[i++]=a.position.x,j[i++]=a.position.y,j[i++]=a.scale.x,j[i++]=a.scale.y,j[i++]=a.rotation,j[i++]=b.x3,j[i++]=b.y3,j[i++]=a.alpha,this.currentBatchSize++,this.currentBatchSize>=this.size&&this.flush()}},b.WebGLFastSpriteBatch.prototype.flush=function(){if(0!==this.currentBatchSize){var a=this.gl;if(this.currentBaseTexture._glTextures[a.id]||this.renderSession.renderer.updateTexture(this.currentBaseTexture,a),a.bindTexture(a.TEXTURE_2D,this.currentBaseTexture._glTextures[a.id]),this.currentBatchSize>.5*this.size)a.bufferSubData(a.ARRAY_BUFFER,0,this.vertices);else{var b=this.vertices.subarray(0,4*this.currentBatchSize*this.vertSize);a.bufferSubData(a.ARRAY_BUFFER,0,b)}a.drawElements(a.TRIANGLES,6*this.currentBatchSize,a.UNSIGNED_SHORT,0),this.currentBatchSize=0,this.renderSession.drawCount++}},b.WebGLFastSpriteBatch.prototype.stop=function(){this.flush()},b.WebGLFastSpriteBatch.prototype.start=function(){var a=this.gl;a.activeTexture(a.TEXTURE0),a.bindBuffer(a.ARRAY_BUFFER,this.vertexBuffer),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.indexBuffer);var b=this.renderSession.projection;a.uniform2f(this.shader.projectionVector,b.x,b.y),a.uniformMatrix3fv(this.shader.uMatrix,!1,this.matrix);var c=4*this.vertSize;a.vertexAttribPointer(this.shader.aVertexPosition,2,a.FLOAT,!1,c,0),a.vertexAttribPointer(this.shader.aPositionCoord,2,a.FLOAT,!1,c,8),a.vertexAttribPointer(this.shader.aScale,2,a.FLOAT,!1,c,16),a.vertexAttribPointer(this.shader.aRotation,1,a.FLOAT,!1,c,24),a.vertexAttribPointer(this.shader.aTextureCoord,2,a.FLOAT,!1,c,28),a.vertexAttribPointer(this.shader.colorAttribute,1,a.FLOAT,!1,c,36)},b.WebGLFilterManager=function(){this.filterStack=[],this.offsetX=0,this.offsetY=0},b.WebGLFilterManager.prototype.constructor=b.WebGLFilterManager,b.WebGLFilterManager.prototype.setContext=function(a){this.gl=a,this.texturePool=[],this.initShaderBuffers()},b.WebGLFilterManager.prototype.begin=function(a,b){this.renderSession=a,this.defaultShader=a.shaderManager.defaultShader;var c=this.renderSession.projection;this.width=2*c.x,this.height=2*-c.y,this.buffer=b},b.WebGLFilterManager.prototype.pushFilter=function(a){var c=this.gl,d=this.renderSession.projection,e=this.renderSession.offset;a._filterArea=a.target.filterArea||a.target.getBounds(),this.filterStack.push(a);var f=a.filterPasses[0];this.offsetX+=a._filterArea.x,this.offsetY+=a._filterArea.y;var g=this.texturePool.pop();g?g.resize(this.width,this.height):g=new b.FilterTexture(this.gl,this.width,this.height),c.bindTexture(c.TEXTURE_2D,g.texture);var h=a._filterArea,i=f.padding;h.x-=i,h.y-=i,h.width+=2*i,h.height+=2*i,h.x<0&&(h.x=0),h.width>this.width&&(h.width=this.width),h.y<0&&(h.y=0),h.height>this.height&&(h.height=this.height),c.bindFramebuffer(c.FRAMEBUFFER,g.frameBuffer),c.viewport(0,0,h.width,h.height),d.x=h.width/2,d.y=-h.height/2,e.x=-h.x,e.y=-h.y,c.colorMask(!0,!0,!0,!0),c.clearColor(0,0,0,0),c.clear(c.COLOR_BUFFER_BIT),a._glFilterTexture=g},b.WebGLFilterManager.prototype.popFilter=function(){var a=this.gl,c=this.filterStack.pop(),d=c._filterArea,e=c._glFilterTexture,f=this.renderSession.projection,g=this.renderSession.offset;if(c.filterPasses.length>1){a.viewport(0,0,d.width,d.height),a.bindBuffer(a.ARRAY_BUFFER,this.vertexBuffer),this.vertexArray[0]=0,this.vertexArray[1]=d.height,this.vertexArray[2]=d.width,this.vertexArray[3]=d.height,this.vertexArray[4]=0,this.vertexArray[5]=0,this.vertexArray[6]=d.width,this.vertexArray[7]=0,a.bufferSubData(a.ARRAY_BUFFER,0,this.vertexArray),a.bindBuffer(a.ARRAY_BUFFER,this.uvBuffer),this.uvArray[2]=d.width/this.width,this.uvArray[5]=d.height/this.height,this.uvArray[6]=d.width/this.width,this.uvArray[7]=d.height/this.height,a.bufferSubData(a.ARRAY_BUFFER,0,this.uvArray);var h=e,i=this.texturePool.pop();i||(i=new b.FilterTexture(this.gl,this.width,this.height)),i.resize(this.width,this.height),a.bindFramebuffer(a.FRAMEBUFFER,i.frameBuffer),a.clear(a.COLOR_BUFFER_BIT),a.disable(a.BLEND);for(var j=0;j<c.filterPasses.length-1;j++){var k=c.filterPasses[j];a.bindFramebuffer(a.FRAMEBUFFER,i.frameBuffer),a.activeTexture(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,h.texture),this.applyFilterPass(k,d,d.width,d.height);var l=h;h=i,i=l}a.enable(a.BLEND),e=h,this.texturePool.push(i)}var m=c.filterPasses[c.filterPasses.length-1];this.offsetX-=d.x,this.offsetY-=d.y;var n=this.width,o=this.height,p=0,q=0,r=this.buffer;if(0===this.filterStack.length)a.colorMask(!0,!0,!0,!0);else{var s=this.filterStack[this.filterStack.length-1];d=s._filterArea,n=d.width,o=d.height,p=d.x,q=d.y,r=s._glFilterTexture.frameBuffer}f.x=n/2,f.y=-o/2,g.x=p,g.y=q,d=c._filterArea;var t=d.x-p,u=d.y-q;a.bindBuffer(a.ARRAY_BUFFER,this.vertexBuffer),this.vertexArray[0]=t,this.vertexArray[1]=u+d.height,this.vertexArray[2]=t+d.width,this.vertexArray[3]=u+d.height,this.vertexArray[4]=t,this.vertexArray[5]=u,this.vertexArray[6]=t+d.width,this.vertexArray[7]=u,a.bufferSubData(a.ARRAY_BUFFER,0,this.vertexArray),a.bindBuffer(a.ARRAY_BUFFER,this.uvBuffer),this.uvArray[2]=d.width/this.width,this.uvArray[5]=d.height/this.height,this.uvArray[6]=d.width/this.width,this.uvArray[7]=d.height/this.height,a.bufferSubData(a.ARRAY_BUFFER,0,this.uvArray),a.viewport(0,0,n*this.renderSession.resolution,o*this.renderSession.resolution),a.bindFramebuffer(a.FRAMEBUFFER,r),a.activeTexture(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,e.texture),this.applyFilterPass(m,d,n,o),this.texturePool.push(e),c._glFilterTexture=null},b.WebGLFilterManager.prototype.applyFilterPass=function(a,c,d,e){var f=this.gl,g=a.shaders[f.id];g||(g=new b.PixiShader(f),g.fragmentSrc=a.fragmentSrc,g.uniforms=a.uniforms,g.init(),a.shaders[f.id]=g),this.renderSession.shaderManager.setShader(g),
f.uniform2f(g.projectionVector,d/2,-e/2),f.uniform2f(g.offsetVector,0,0),a.uniforms.dimensions&&(a.uniforms.dimensions.value[0]=this.width,a.uniforms.dimensions.value[1]=this.height,a.uniforms.dimensions.value[2]=this.vertexArray[0],a.uniforms.dimensions.value[3]=this.vertexArray[5]),g.syncUniforms(),f.bindBuffer(f.ARRAY_BUFFER,this.vertexBuffer),f.vertexAttribPointer(g.aVertexPosition,2,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,this.uvBuffer),f.vertexAttribPointer(g.aTextureCoord,2,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,this.colorBuffer),f.vertexAttribPointer(g.colorAttribute,2,f.FLOAT,!1,0,0),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,this.indexBuffer),f.drawElements(f.TRIANGLES,6,f.UNSIGNED_SHORT,0),this.renderSession.drawCount++},b.WebGLFilterManager.prototype.initShaderBuffers=function(){var a=this.gl;this.vertexBuffer=a.createBuffer(),this.uvBuffer=a.createBuffer(),this.colorBuffer=a.createBuffer(),this.indexBuffer=a.createBuffer(),this.vertexArray=new b.Float32Array([0,0,1,0,0,1,1,1]),a.bindBuffer(a.ARRAY_BUFFER,this.vertexBuffer),a.bufferData(a.ARRAY_BUFFER,this.vertexArray,a.STATIC_DRAW),this.uvArray=new b.Float32Array([0,0,1,0,0,1,1,1]),a.bindBuffer(a.ARRAY_BUFFER,this.uvBuffer),a.bufferData(a.ARRAY_BUFFER,this.uvArray,a.STATIC_DRAW),this.colorArray=new b.Float32Array([1,16777215,1,16777215,1,16777215,1,16777215]),a.bindBuffer(a.ARRAY_BUFFER,this.colorBuffer),a.bufferData(a.ARRAY_BUFFER,this.colorArray,a.STATIC_DRAW),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.indexBuffer),a.bufferData(a.ELEMENT_ARRAY_BUFFER,new Uint16Array([0,1,2,1,3,2]),a.STATIC_DRAW)},b.WebGLFilterManager.prototype.destroy=function(){var a=this.gl;this.filterStack=null,this.offsetX=0,this.offsetY=0;for(var b=0;b<this.texturePool.length;b++)this.texturePool[b].destroy();this.texturePool=null,a.deleteBuffer(this.vertexBuffer),a.deleteBuffer(this.uvBuffer),a.deleteBuffer(this.colorBuffer),a.deleteBuffer(this.indexBuffer)},b.FilterTexture=function(a,c,d,e){this.gl=a,this.frameBuffer=a.createFramebuffer(),this.texture=a.createTexture(),e=e||b.scaleModes.DEFAULT,a.bindTexture(a.TEXTURE_2D,this.texture),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,e===b.scaleModes.LINEAR?a.LINEAR:a.NEAREST),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,e===b.scaleModes.LINEAR?a.LINEAR:a.NEAREST),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.bindFramebuffer(a.FRAMEBUFFER,this.frameBuffer),a.bindFramebuffer(a.FRAMEBUFFER,this.frameBuffer),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,this.texture,0),this.renderBuffer=a.createRenderbuffer(),a.bindRenderbuffer(a.RENDERBUFFER,this.renderBuffer),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_STENCIL_ATTACHMENT,a.RENDERBUFFER,this.renderBuffer),this.resize(c,d)},b.FilterTexture.prototype.constructor=b.FilterTexture,b.FilterTexture.prototype.clear=function(){var a=this.gl;a.clearColor(0,0,0,0),a.clear(a.COLOR_BUFFER_BIT)},b.FilterTexture.prototype.resize=function(a,b){if(this.width!==a||this.height!==b){this.width=a,this.height=b;var c=this.gl;c.bindTexture(c.TEXTURE_2D,this.texture),c.texImage2D(c.TEXTURE_2D,0,c.RGBA,a,b,0,c.RGBA,c.UNSIGNED_BYTE,null),c.bindRenderbuffer(c.RENDERBUFFER,this.renderBuffer),c.renderbufferStorage(c.RENDERBUFFER,c.DEPTH_STENCIL,a,b)}},b.FilterTexture.prototype.destroy=function(){var a=this.gl;a.deleteFramebuffer(this.frameBuffer),a.deleteTexture(this.texture),this.frameBuffer=null,this.texture=null},b.CanvasBuffer=function(a,b){this.width=a,this.height=b,this.canvas=document.createElement("canvas"),this.context=this.canvas.getContext("2d"),this.canvas.width=a,this.canvas.height=b},b.CanvasBuffer.prototype.constructor=b.CanvasBuffer,b.CanvasBuffer.prototype.clear=function(){this.context.setTransform(1,0,0,1,0,0),this.context.clearRect(0,0,this.width,this.height)},b.CanvasBuffer.prototype.resize=function(a,b){this.width=this.canvas.width=a,this.height=this.canvas.height=b},b.CanvasMaskManager=function(){},b.CanvasMaskManager.prototype.constructor=b.CanvasMaskManager,b.CanvasMaskManager.prototype.pushMask=function(a,c){var d=c.context;d.save();var e=a.alpha,f=a.worldTransform,g=c.resolution;d.setTransform(f.a*g,f.b*g,f.c*g,f.d*g,f.tx*g,f.ty*g),b.CanvasGraphics.renderGraphicsMask(a,d),d.clip(),a.worldAlpha=e},b.CanvasMaskManager.prototype.popMask=function(a){a.context.restore()},b.CanvasTinter=function(){},b.CanvasTinter.getTintedTexture=function(a,c){var d=a.texture;c=b.CanvasTinter.roundColor(c);var e="#"+("00000"+(0|c).toString(16)).substr(-6);if(d.tintCache=d.tintCache||{},d.tintCache[e])return d.tintCache[e];var f=b.CanvasTinter.canvas||document.createElement("canvas");if(b.CanvasTinter.tintMethod(d,c,f),b.CanvasTinter.convertTintToImage){var g=new Image;g.src=f.toDataURL(),d.tintCache[e]=g}else d.tintCache[e]=f,b.CanvasTinter.canvas=null;return f},b.CanvasTinter.tintWithMultiply=function(a,b,c){var d=c.getContext("2d"),e=a.crop;c.width=e.width,c.height=e.height,d.fillStyle="#"+("00000"+(0|b).toString(16)).substr(-6),d.fillRect(0,0,e.width,e.height),d.globalCompositeOperation="multiply",d.drawImage(a.baseTexture.source,e.x,e.y,e.width,e.height,0,0,e.width,e.height),d.globalCompositeOperation="destination-atop",d.drawImage(a.baseTexture.source,e.x,e.y,e.width,e.height,0,0,e.width,e.height)},b.CanvasTinter.tintWithOverlay=function(a,b,c){var d=c.getContext("2d"),e=a.crop;c.width=e.width,c.height=e.height,d.globalCompositeOperation="copy",d.fillStyle="#"+("00000"+(0|b).toString(16)).substr(-6),d.fillRect(0,0,e.width,e.height),d.globalCompositeOperation="destination-atop",d.drawImage(a.baseTexture.source,e.x,e.y,e.width,e.height,0,0,e.width,e.height)},b.CanvasTinter.tintWithPerPixel=function(a,c,d){var e=d.getContext("2d"),f=a.crop;d.width=f.width,d.height=f.height,e.globalCompositeOperation="copy",e.drawImage(a.baseTexture.source,f.x,f.y,f.width,f.height,0,0,f.width,f.height);for(var g=b.hex2rgb(c),h=g[0],i=g[1],j=g[2],k=e.getImageData(0,0,f.width,f.height),l=k.data,m=0;m<l.length;m+=4)l[m+0]*=h,l[m+1]*=i,l[m+2]*=j;e.putImageData(k,0,0)},b.CanvasTinter.roundColor=function(a){var c=b.CanvasTinter.cacheStepsPerColorChannel,d=b.hex2rgb(a);return d[0]=Math.min(255,d[0]/c*c),d[1]=Math.min(255,d[1]/c*c),d[2]=Math.min(255,d[2]/c*c),b.rgb2hex(d)},b.CanvasTinter.cacheStepsPerColorChannel=8,b.CanvasTinter.convertTintToImage=!1,b.CanvasTinter.canUseMultiply=b.canUseNewCanvasBlendModes(),b.CanvasTinter.tintMethod=b.CanvasTinter.canUseMultiply?b.CanvasTinter.tintWithMultiply:b.CanvasTinter.tintWithPerPixel,b.CanvasRenderer=function(a,c,d){if(d)for(var e in b.defaultRenderOptions)"undefined"==typeof d[e]&&(d[e]=b.defaultRenderOptions[e]);else d=b.defaultRenderOptions;b.defaultRenderer||(b.sayHello("Canvas"),b.defaultRenderer=this),this.type=b.CANVAS_RENDERER,this.resolution=d.resolution,this.clearBeforeRender=d.clearBeforeRender,this.transparent=d.transparent,this.autoResize=d.autoResize||!1,this.width=a||800,this.height=c||600,this.width*=this.resolution,this.height*=this.resolution,this.view=d.view||document.createElement("canvas"),this.context=this.view.getContext("2d",{alpha:this.transparent}),this.refresh=!0,this.view.width=this.width*this.resolution,this.view.height=this.height*this.resolution,this.count=0,this.maskManager=new b.CanvasMaskManager,this.renderSession={context:this.context,maskManager:this.maskManager,scaleMode:null,smoothProperty:null,roundPixels:!1},this.mapBlendModes(),this.resize(a,c),"imageSmoothingEnabled"in this.context?this.renderSession.smoothProperty="imageSmoothingEnabled":"webkitImageSmoothingEnabled"in this.context?this.renderSession.smoothProperty="webkitImageSmoothingEnabled":"mozImageSmoothingEnabled"in this.context?this.renderSession.smoothProperty="mozImageSmoothingEnabled":"oImageSmoothingEnabled"in this.context?this.renderSession.smoothProperty="oImageSmoothingEnabled":"msImageSmoothingEnabled"in this.context&&(this.renderSession.smoothProperty="msImageSmoothingEnabled")},b.CanvasRenderer.prototype.constructor=b.CanvasRenderer,b.CanvasRenderer.prototype.render=function(a){a.updateTransform(),this.context.setTransform(1,0,0,1,0,0),this.context.globalAlpha=1,this.renderSession.currentBlendMode=b.blendModes.NORMAL,this.context.globalCompositeOperation=b.blendModesCanvas[b.blendModes.NORMAL],navigator.isCocoonJS&&this.view.screencanvas&&(this.context.fillStyle="black",this.context.clear()),this.clearBeforeRender&&(this.transparent?this.context.clearRect(0,0,this.width,this.height):(this.context.fillStyle=a.backgroundColorString,this.context.fillRect(0,0,this.width,this.height))),this.renderDisplayObject(a),a.interactive&&(a._interactiveEventsAdded||(a._interactiveEventsAdded=!0,a.interactionManager.setTarget(this)))},b.CanvasRenderer.prototype.destroy=function(a){"undefined"==typeof a&&(a=!0),a&&this.view.parent&&this.view.parent.removeChild(this.view),this.view=null,this.context=null,this.maskManager=null,this.renderSession=null},b.CanvasRenderer.prototype.resize=function(a,b){this.width=a*this.resolution,this.height=b*this.resolution,this.view.width=this.width,this.view.height=this.height,this.autoResize&&(this.view.style.width=this.width/this.resolution+"px",this.view.style.height=this.height/this.resolution+"px")},b.CanvasRenderer.prototype.renderDisplayObject=function(a,b){this.renderSession.context=b||this.context,this.renderSession.resolution=this.resolution,a._renderCanvas(this.renderSession)},b.CanvasRenderer.prototype.mapBlendModes=function(){b.blendModesCanvas||(b.blendModesCanvas=[],b.canUseNewCanvasBlendModes()?(b.blendModesCanvas[b.blendModes.NORMAL]="source-over",b.blendModesCanvas[b.blendModes.ADD]="lighter",b.blendModesCanvas[b.blendModes.MULTIPLY]="multiply",b.blendModesCanvas[b.blendModes.SCREEN]="screen",b.blendModesCanvas[b.blendModes.OVERLAY]="overlay",b.blendModesCanvas[b.blendModes.DARKEN]="darken",b.blendModesCanvas[b.blendModes.LIGHTEN]="lighten",b.blendModesCanvas[b.blendModes.COLOR_DODGE]="color-dodge",b.blendModesCanvas[b.blendModes.COLOR_BURN]="color-burn",b.blendModesCanvas[b.blendModes.HARD_LIGHT]="hard-light",b.blendModesCanvas[b.blendModes.SOFT_LIGHT]="soft-light",b.blendModesCanvas[b.blendModes.DIFFERENCE]="difference",b.blendModesCanvas[b.blendModes.EXCLUSION]="exclusion",b.blendModesCanvas[b.blendModes.HUE]="hue",b.blendModesCanvas[b.blendModes.SATURATION]="saturation",b.blendModesCanvas[b.blendModes.COLOR]="color",b.blendModesCanvas[b.blendModes.LUMINOSITY]="luminosity"):(b.blendModesCanvas[b.blendModes.NORMAL]="source-over",b.blendModesCanvas[b.blendModes.ADD]="lighter",b.blendModesCanvas[b.blendModes.MULTIPLY]="source-over",b.blendModesCanvas[b.blendModes.SCREEN]="source-over",b.blendModesCanvas[b.blendModes.OVERLAY]="source-over",b.blendModesCanvas[b.blendModes.DARKEN]="source-over",b.blendModesCanvas[b.blendModes.LIGHTEN]="source-over",b.blendModesCanvas[b.blendModes.COLOR_DODGE]="source-over",b.blendModesCanvas[b.blendModes.COLOR_BURN]="source-over",b.blendModesCanvas[b.blendModes.HARD_LIGHT]="source-over",b.blendModesCanvas[b.blendModes.SOFT_LIGHT]="source-over",b.blendModesCanvas[b.blendModes.DIFFERENCE]="source-over",b.blendModesCanvas[b.blendModes.EXCLUSION]="source-over",b.blendModesCanvas[b.blendModes.HUE]="source-over",b.blendModesCanvas[b.blendModes.SATURATION]="source-over",b.blendModesCanvas[b.blendModes.COLOR]="source-over",b.blendModesCanvas[b.blendModes.LUMINOSITY]="source-over"))},b.CanvasGraphics=function(){},b.CanvasGraphics.renderGraphics=function(a,c){var d=a.worldAlpha;a.dirty&&(this.updateGraphicsTint(a),a.dirty=!1);for(var e=0;e<a.graphicsData.length;e++){var f=a.graphicsData[e],g=f.shape,h=f._fillTint,i=f._lineTint;if(c.lineWidth=f.lineWidth,f.type===b.Graphics.POLY){c.beginPath();var j=g.points;c.moveTo(j[0],j[1]);for(var k=1;k<j.length/2;k++)c.lineTo(j[2*k],j[2*k+1]);g.closed&&c.lineTo(j[0],j[1]),j[0]===j[j.length-2]&&j[1]===j[j.length-1]&&c.closePath(),f.fill&&(c.globalAlpha=f.fillAlpha*d,c.fillStyle="#"+("00000"+(0|h).toString(16)).substr(-6),c.fill()),f.lineWidth&&(c.globalAlpha=f.lineAlpha*d,c.strokeStyle="#"+("00000"+(0|i).toString(16)).substr(-6),c.stroke())}else if(f.type===b.Graphics.RECT)(f.fillColor||0===f.fillColor)&&(c.globalAlpha=f.fillAlpha*d,c.fillStyle="#"+("00000"+(0|h).toString(16)).substr(-6),c.fillRect(g.x,g.y,g.width,g.height)),f.lineWidth&&(c.globalAlpha=f.lineAlpha*d,c.strokeStyle="#"+("00000"+(0|i).toString(16)).substr(-6),c.strokeRect(g.x,g.y,g.width,g.height));else if(f.type===b.Graphics.CIRC)c.beginPath(),c.arc(g.x,g.y,g.radius,0,2*Math.PI),c.closePath(),f.fill&&(c.globalAlpha=f.fillAlpha*d,c.fillStyle="#"+("00000"+(0|h).toString(16)).substr(-6),c.fill()),f.lineWidth&&(c.globalAlpha=f.lineAlpha*d,c.strokeStyle="#"+("00000"+(0|i).toString(16)).substr(-6),c.stroke());else if(f.type===b.Graphics.ELIP){var l=2*g.width,m=2*g.height,n=g.x-l/2,o=g.y-m/2;c.beginPath();var p=.5522848,q=l/2*p,r=m/2*p,s=n+l,t=o+m,u=n+l/2,v=o+m/2;c.moveTo(n,v),c.bezierCurveTo(n,v-r,u-q,o,u,o),c.bezierCurveTo(u+q,o,s,v-r,s,v),c.bezierCurveTo(s,v+r,u+q,t,u,t),c.bezierCurveTo(u-q,t,n,v+r,n,v),c.closePath(),f.fill&&(c.globalAlpha=f.fillAlpha*d,c.fillStyle="#"+("00000"+(0|h).toString(16)).substr(-6),c.fill()),f.lineWidth&&(c.globalAlpha=f.lineAlpha*d,c.strokeStyle="#"+("00000"+(0|i).toString(16)).substr(-6),c.stroke())}else if(f.type===b.Graphics.RREC){var w=g.x,x=g.y,y=g.width,z=g.height,A=g.radius,B=Math.min(y,z)/2|0;A=A>B?B:A,c.beginPath(),c.moveTo(w,x+A),c.lineTo(w,x+z-A),c.quadraticCurveTo(w,x+z,w+A,x+z),c.lineTo(w+y-A,x+z),c.quadraticCurveTo(w+y,x+z,w+y,x+z-A),c.lineTo(w+y,x+A),c.quadraticCurveTo(w+y,x,w+y-A,x),c.lineTo(w+A,x),c.quadraticCurveTo(w,x,w,x+A),c.closePath(),(f.fillColor||0===f.fillColor)&&(c.globalAlpha=f.fillAlpha*d,c.fillStyle="#"+("00000"+(0|h).toString(16)).substr(-6),c.fill()),f.lineWidth&&(c.globalAlpha=f.lineAlpha*d,c.strokeStyle="#"+("00000"+(0|i).toString(16)).substr(-6),c.stroke())}}},b.CanvasGraphics.renderGraphicsMask=function(a,c){var d=a.graphicsData.length;if(0!==d){d>1&&(d=1,window.console.log("Pixi.js warning: masks in canvas can only mask using the first path in the graphics object"));for(var e=0;1>e;e++){var f=a.graphicsData[e],g=f.shape;if(f.type===b.Graphics.POLY){c.beginPath();var h=g.points;c.moveTo(h[0],h[1]);for(var i=1;i<h.length/2;i++)c.lineTo(h[2*i],h[2*i+1]);h[0]===h[h.length-2]&&h[1]===h[h.length-1]&&c.closePath()}else if(f.type===b.Graphics.RECT)c.beginPath(),c.rect(g.x,g.y,g.width,g.height),c.closePath();else if(f.type===b.Graphics.CIRC)c.beginPath(),c.arc(g.x,g.y,g.radius,0,2*Math.PI),c.closePath();else if(f.type===b.Graphics.ELIP){var j=2*g.width,k=2*g.height,l=g.x-j/2,m=g.y-k/2;c.beginPath();var n=.5522848,o=j/2*n,p=k/2*n,q=l+j,r=m+k,s=l+j/2,t=m+k/2;c.moveTo(l,t),c.bezierCurveTo(l,t-p,s-o,m,s,m),c.bezierCurveTo(s+o,m,q,t-p,q,t),c.bezierCurveTo(q,t+p,s+o,r,s,r),c.bezierCurveTo(s-o,r,l,t+p,l,t),c.closePath()}else if(f.type===b.Graphics.RREC){var u=g.points,v=u[0],w=u[1],x=u[2],y=u[3],z=u[4],A=Math.min(x,y)/2|0;z=z>A?A:z,c.beginPath(),c.moveTo(v,w+z),c.lineTo(v,w+y-z),c.quadraticCurveTo(v,w+y,v+z,w+y),c.lineTo(v+x-z,w+y),c.quadraticCurveTo(v+x,w+y,v+x,w+y-z),c.lineTo(v+x,w+z),c.quadraticCurveTo(v+x,w,v+x-z,w),c.lineTo(v+z,w),c.quadraticCurveTo(v,w,v,w+z),c.closePath()}}}},b.CanvasGraphics.updateGraphicsTint=function(a){if(16777215!==a.tint)for(var b=(a.tint>>16&255)/255,c=(a.tint>>8&255)/255,d=(255&a.tint)/255,e=0;e<a.graphicsData.length;e++){var f=a.graphicsData[e],g=0|f.fillColor,h=0|f.lineColor;f._fillTint=((g>>16&255)/255*b*255<<16)+((g>>8&255)/255*c*255<<8)+(255&g)/255*d*255,f._lineTint=((h>>16&255)/255*b*255<<16)+((h>>8&255)/255*c*255<<8)+(255&h)/255*d*255}},b.Graphics=function(){b.DisplayObjectContainer.call(this),this.renderable=!0,this.fillAlpha=1,this.lineWidth=0,this.lineColor=0,this.graphicsData=[],this.tint=16777215,this.blendMode=b.blendModes.NORMAL,this.currentPath=null,this._webGL=[],this.isMask=!1,this.boundsPadding=0,this._localBounds=new b.Rectangle(0,0,1,1),this.dirty=!0,this.webGLDirty=!1,this.cachedSpriteDirty=!1},b.Graphics.prototype=Object.create(b.DisplayObjectContainer.prototype),b.Graphics.prototype.constructor=b.Graphics,Object.defineProperty(b.Graphics.prototype,"cacheAsBitmap",{get:function(){return this._cacheAsBitmap},set:function(a){this._cacheAsBitmap=a,this._cacheAsBitmap?this._generateCachedSprite():(this.destroyCachedSprite(),this.dirty=!0)}}),b.Graphics.prototype.lineStyle=function(a,c,d){if(this.lineWidth=a||0,this.lineColor=c||0,this.lineAlpha=void 0===d?1:d,this.currentPath){if(this.currentPath.shape.points.length)return this.drawShape(new b.Polygon(this.currentPath.shape.points.slice(-2))),this;this.currentPath.lineWidth=this.lineWidth,this.currentPath.lineColor=this.lineColor,this.currentPath.lineAlpha=this.lineAlpha}return this},b.Graphics.prototype.moveTo=function(a,c){return this.drawShape(new b.Polygon([a,c])),this},b.Graphics.prototype.lineTo=function(a,b){return this.currentPath.shape.points.push(a,b),this.dirty=!0,this},b.Graphics.prototype.quadraticCurveTo=function(a,b,c,d){this.currentPath?0===this.currentPath.shape.points.length&&(this.currentPath.shape.points=[0,0]):this.moveTo(0,0);var e,f,g=20,h=this.currentPath.shape.points;0===h.length&&this.moveTo(0,0);for(var i=h[h.length-2],j=h[h.length-1],k=0,l=1;g>=l;l++)k=l/g,e=i+(a-i)*k,f=j+(b-j)*k,h.push(e+(a+(c-a)*k-e)*k,f+(b+(d-b)*k-f)*k);return this.dirty=!0,this},b.Graphics.prototype.bezierCurveTo=function(a,b,c,d,e,f){this.currentPath?0===this.currentPath.shape.points.length&&(this.currentPath.shape.points=[0,0]):this.moveTo(0,0);for(var g,h,i,j,k,l=20,m=this.currentPath.shape.points,n=m[m.length-2],o=m[m.length-1],p=0,q=1;l>=q;q++)p=q/l,g=1-p,h=g*g,i=h*g,j=p*p,k=j*p,m.push(i*n+3*h*p*a+3*g*j*c+k*e,i*o+3*h*p*b+3*g*j*d+k*f);return this.dirty=!0,this},b.Graphics.prototype.arcTo=function(a,b,c,d,e){this.currentPath?0===this.currentPath.shape.points.length&&this.currentPath.shape.points.push(a,b):this.moveTo(a,b);var f=this.currentPath.shape.points,g=f[f.length-2],h=f[f.length-1],i=h-b,j=g-a,k=d-b,l=c-a,m=Math.abs(i*l-j*k);if(1e-8>m||0===e)(f[f.length-2]!==a||f[f.length-1]!==b)&&f.push(a,b);else{var n=i*i+j*j,o=k*k+l*l,p=i*k+j*l,q=e*Math.sqrt(n)/m,r=e*Math.sqrt(o)/m,s=q*p/n,t=r*p/o,u=q*l+r*j,v=q*k+r*i,w=j*(r+s),x=i*(r+s),y=l*(q+t),z=k*(q+t),A=Math.atan2(x-v,w-u),B=Math.atan2(z-v,y-u);this.arc(u+a,v+b,e,A,B,j*k>l*i)}return this.dirty=!0,this},b.Graphics.prototype.arc=function(a,b,c,d,e,f){if(f=f||!1,d===e)return this;!f&&d>=e?e+=2*Math.PI:f&&e>=d&&(d+=2*Math.PI);var g=f?-1*(d-e):e-d,h=Math.abs(g)/(2*Math.PI)*40;if(0===g)return this;var i=a+Math.cos(d)*c,j=b+Math.sin(d)*c;f&&this.filling?this.moveTo(a,b):this.moveTo(i,j);for(var k=this.currentPath.shape.points,l=g/(2*h),m=2*l,n=Math.cos(l),o=Math.sin(l),p=h-1,q=p%1/p,r=0;p>=r;r++){var s=r+q*r,t=l+d+m*s,u=Math.cos(t),v=-Math.sin(t);k.push((n*u+o*v)*c+a,(n*-v+o*u)*c+b)}return this.dirty=!0,this},b.Graphics.prototype.beginFill=function(a,b){return this.filling=!0,this.fillColor=a||0,this.fillAlpha=void 0===b?1:b,this.currentPath&&this.currentPath.shape.points.length<=2&&(this.currentPath.fill=this.filling,this.currentPath.fillColor=this.fillColor,this.currentPath.fillAlpha=this.fillAlpha),this},b.Graphics.prototype.endFill=function(){return this.filling=!1,this.fillColor=null,this.fillAlpha=1,this},b.Graphics.prototype.drawRect=function(a,c,d,e){return this.drawShape(new b.Rectangle(a,c,d,e)),this},b.Graphics.prototype.drawRoundedRect=function(a,c,d,e,f){return this.drawShape(new b.RoundedRectangle(a,c,d,e,f)),this},b.Graphics.prototype.drawCircle=function(a,c,d){return this.drawShape(new b.Circle(a,c,d)),this},b.Graphics.prototype.drawEllipse=function(a,c,d,e){return this.drawShape(new b.Ellipse(a,c,d,e)),this},b.Graphics.prototype.drawPolygon=function(a){return a instanceof Array||(a=Array.prototype.slice.call(arguments)),this.drawShape(new b.Polygon(a)),this},b.Graphics.prototype.clear=function(){return this.lineWidth=0,this.filling=!1,this.dirty=!0,this.clearDirty=!0,this.graphicsData=[],this},b.Graphics.prototype.generateTexture=function(a,c){a=a||1;var d=this.getBounds(),e=new b.CanvasBuffer(d.width*a,d.height*a),f=b.Texture.fromCanvas(e.canvas,c);return f.baseTexture.resolution=a,e.context.scale(a,a),e.context.translate(-d.x,-d.y),b.CanvasGraphics.renderGraphics(this,e.context),f},b.Graphics.prototype._renderWebGL=function(a){if(this.visible!==!1&&0!==this.alpha&&this.isMask!==!0){if(this._cacheAsBitmap)return(this.dirty||this.cachedSpriteDirty)&&(this._generateCachedSprite(),this.updateCachedSpriteTexture(),this.cachedSpriteDirty=!1,this.dirty=!1),this._cachedSprite.worldAlpha=this.worldAlpha,void b.Sprite.prototype._renderWebGL.call(this._cachedSprite,a);if(a.spriteBatch.stop(),a.blendModeManager.setBlendMode(this.blendMode),this._mask&&a.maskManager.pushMask(this._mask,a),this._filters&&a.filterManager.pushFilter(this._filterBlock),this.blendMode!==a.spriteBatch.currentBlendMode){a.spriteBatch.currentBlendMode=this.blendMode;var c=b.blendModesWebGL[a.spriteBatch.currentBlendMode];a.spriteBatch.gl.blendFunc(c[0],c[1])}if(this.webGLDirty&&(this.dirty=!0,this.webGLDirty=!1),b.WebGLGraphics.renderGraphics(this,a),this.children.length){a.spriteBatch.start();for(var d=0,e=this.children.length;e>d;d++)this.children[d]._renderWebGL(a);a.spriteBatch.stop()}this._filters&&a.filterManager.popFilter(),this._mask&&a.maskManager.popMask(this.mask,a),a.drawCount++,a.spriteBatch.start()}},b.Graphics.prototype._renderCanvas=function(a){if(this.visible!==!1&&0!==this.alpha&&this.isMask!==!0){if(this._cacheAsBitmap)return(this.dirty||this.cachedSpriteDirty)&&(this._generateCachedSprite(),this.updateCachedSpriteTexture(),this.cachedSpriteDirty=!1,this.dirty=!1),this._cachedSprite.alpha=this.alpha,void b.Sprite.prototype._renderCanvas.call(this._cachedSprite,a);var c=a.context,d=this.worldTransform;this.blendMode!==a.currentBlendMode&&(a.currentBlendMode=this.blendMode,c.globalCompositeOperation=b.blendModesCanvas[a.currentBlendMode]),this._mask&&a.maskManager.pushMask(this._mask,a);var e=a.resolution;c.setTransform(d.a*e,d.b*e,d.c*e,d.d*e,d.tx*e,d.ty*e),b.CanvasGraphics.renderGraphics(this,c);for(var f=0,g=this.children.length;g>f;f++)this.children[f]._renderCanvas(a);this._mask&&a.maskManager.popMask(a)}},b.Graphics.prototype.getBounds=function(a){if(this.isMask)return b.EmptyRectangle;this.dirty&&(this.updateLocalBounds(),this.webGLDirty=!0,this.cachedSpriteDirty=!0,this.dirty=!1);var c=this._localBounds,d=c.x,e=c.width+c.x,f=c.y,g=c.height+c.y,h=a||this.worldTransform,i=h.a,j=h.b,k=h.c,l=h.d,m=h.tx,n=h.ty,o=i*e+k*g+m,p=l*g+j*e+n,q=i*d+k*g+m,r=l*g+j*d+n,s=i*d+k*f+m,t=l*f+j*d+n,u=i*e+k*f+m,v=l*f+j*e+n,w=o,x=p,y=o,z=p;return y=y>q?q:y,y=y>s?s:y,y=y>u?u:y,z=z>r?r:z,z=z>t?t:z,z=z>v?v:z,w=q>w?q:w,w=s>w?s:w,w=u>w?u:w,x=r>x?r:x,x=t>x?t:x,x=v>x?v:x,this._bounds.x=y,this._bounds.width=w-y,this._bounds.y=z,this._bounds.height=x-z,this._bounds},b.Graphics.prototype.updateLocalBounds=function(){var a=1/0,c=-(1/0),d=1/0,e=-(1/0);if(this.graphicsData.length)for(var f,g,h,i,j,k,l=0;l<this.graphicsData.length;l++){var m=this.graphicsData[l],n=m.type,o=m.lineWidth;if(f=m.shape,n===b.Graphics.RECT||n===b.Graphics.RREC)h=f.x-o/2,i=f.y-o/2,j=f.width+o,k=f.height+o,a=a>h?h:a,c=h+j>c?h+j:c,d=d>i?i:d,e=i+k>e?i+k:e;else if(n===b.Graphics.CIRC)h=f.x,i=f.y,j=f.radius+o/2,k=f.radius+o/2,a=a>h-j?h-j:a,c=h+j>c?h+j:c,d=d>i-k?i-k:d,e=i+k>e?i+k:e;else if(n===b.Graphics.ELIP)h=f.x,i=f.y,j=f.width+o/2,k=f.height+o/2,a=a>h-j?h-j:a,c=h+j>c?h+j:c,d=d>i-k?i-k:d,e=i+k>e?i+k:e;else{g=f.points;for(var p=0;p<g.length;p+=2)h=g[p],i=g[p+1],a=a>h-o?h-o:a,c=h+o>c?h+o:c,d=d>i-o?i-o:d,e=i+o>e?i+o:e}}else a=0,c=0,d=0,e=0;var q=this.boundsPadding;this._localBounds.x=a-q,this._localBounds.width=c-a+2*q,this._localBounds.y=d-q,this._localBounds.height=e-d+2*q},b.Graphics.prototype._generateCachedSprite=function(){var a=this.getLocalBounds();if(this._cachedSprite)this._cachedSprite.buffer.resize(a.width,a.height);else{var c=new b.CanvasBuffer(a.width,a.height),d=b.Texture.fromCanvas(c.canvas);this._cachedSprite=new b.Sprite(d),this._cachedSprite.buffer=c,this._cachedSprite.worldTransform=this.worldTransform}this._cachedSprite.anchor.x=-(a.x/a.width),this._cachedSprite.anchor.y=-(a.y/a.height),this._cachedSprite.buffer.context.translate(-a.x,-a.y),this.worldAlpha=1,b.CanvasGraphics.renderGraphics(this,this._cachedSprite.buffer.context),this._cachedSprite.alpha=this.alpha},b.Graphics.prototype.updateCachedSpriteTexture=function(){var a=this._cachedSprite,b=a.texture,c=a.buffer.canvas;b.baseTexture.width=c.width,b.baseTexture.height=c.height,b.crop.width=b.frame.width=c.width,b.crop.height=b.frame.height=c.height,a._width=c.width,a._height=c.height,b.baseTexture.dirty()},b.Graphics.prototype.destroyCachedSprite=function(){this._cachedSprite.texture.destroy(!0),this._cachedSprite=null},b.Graphics.prototype.drawShape=function(a){this.currentPath&&this.currentPath.shape.points.length<=2&&this.graphicsData.pop(),this.currentPath=null;var c=new b.GraphicsData(this.lineWidth,this.lineColor,this.lineAlpha,this.fillColor,this.fillAlpha,this.filling,a);return this.graphicsData.push(c),c.type===b.Graphics.POLY&&(c.shape.closed=this.filling,this.currentPath=c),this.dirty=!0,c},b.GraphicsData=function(a,b,c,d,e,f,g){this.lineWidth=a,this.lineColor=b,this.lineAlpha=c,this._lineTint=b,this.fillColor=d,this.fillAlpha=e,this._fillTint=d,this.fill=f,this.shape=g,this.type=g.type},b.Graphics.POLY=0,b.Graphics.RECT=1,b.Graphics.CIRC=2,b.Graphics.ELIP=3,b.Graphics.RREC=4,b.Polygon.prototype.type=b.Graphics.POLY,b.Rectangle.prototype.type=b.Graphics.RECT,b.Circle.prototype.type=b.Graphics.CIRC,b.Ellipse.prototype.type=b.Graphics.ELIP,b.RoundedRectangle.prototype.type=b.Graphics.RREC,b.Strip=function(a){b.DisplayObjectContainer.call(this),this.texture=a,this.uvs=new b.Float32Array([0,1,1,1,1,0,0,1]),this.vertices=new b.Float32Array([0,0,100,0,100,100,0,100]),this.colors=new b.Float32Array([1,1,1,1]),this.indices=new b.Uint16Array([0,1,2,3]),this.dirty=!0,this.blendMode=b.blendModes.NORMAL,this.canvasPadding=0,this.drawMode=b.Strip.DrawModes.TRIANGLE_STRIP},b.Strip.prototype=Object.create(b.DisplayObjectContainer.prototype),b.Strip.prototype.constructor=b.Strip,b.Strip.prototype._renderWebGL=function(a){!this.visible||this.alpha<=0||(a.spriteBatch.stop(),this._vertexBuffer||this._initWebGL(a),a.shaderManager.setShader(a.shaderManager.stripShader),this._renderStrip(a),a.spriteBatch.start())},b.Strip.prototype._initWebGL=function(a){var b=a.gl;this._vertexBuffer=b.createBuffer(),this._indexBuffer=b.createBuffer(),this._uvBuffer=b.createBuffer(),this._colorBuffer=b.createBuffer(),b.bindBuffer(b.ARRAY_BUFFER,this._vertexBuffer),b.bufferData(b.ARRAY_BUFFER,this.vertices,b.DYNAMIC_DRAW),b.bindBuffer(b.ARRAY_BUFFER,this._uvBuffer),b.bufferData(b.ARRAY_BUFFER,this.uvs,b.STATIC_DRAW),b.bindBuffer(b.ARRAY_BUFFER,this._colorBuffer),b.bufferData(b.ARRAY_BUFFER,this.colors,b.STATIC_DRAW),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this._indexBuffer),b.bufferData(b.ELEMENT_ARRAY_BUFFER,this.indices,b.STATIC_DRAW)},b.Strip.prototype._renderStrip=function(a){var c=a.gl,d=a.projection,e=a.offset,f=a.shaderManager.stripShader,g=this.drawMode===b.Strip.DrawModes.TRIANGLE_STRIP?c.TRIANGLE_STRIP:c.TRIANGLES;a.blendModeManager.setBlendMode(this.blendMode),c.uniformMatrix3fv(f.translationMatrix,!1,this.worldTransform.toArray(!0)),c.uniform2f(f.projectionVector,d.x,-d.y),c.uniform2f(f.offsetVector,-e.x,-e.y),c.uniform1f(f.alpha,this.worldAlpha),this.dirty?(this.dirty=!1,c.bindBuffer(c.ARRAY_BUFFER,this._vertexBuffer),c.bufferData(c.ARRAY_BUFFER,this.vertices,c.STATIC_DRAW),c.vertexAttribPointer(f.aVertexPosition,2,c.FLOAT,!1,0,0),c.bindBuffer(c.ARRAY_BUFFER,this._uvBuffer),c.bufferData(c.ARRAY_BUFFER,this.uvs,c.STATIC_DRAW),c.vertexAttribPointer(f.aTextureCoord,2,c.FLOAT,!1,0,0),c.activeTexture(c.TEXTURE0),this.texture.baseTexture._dirty[c.id]?a.renderer.updateTexture(this.texture.baseTexture):c.bindTexture(c.TEXTURE_2D,this.texture.baseTexture._glTextures[c.id]),c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,this._indexBuffer),c.bufferData(c.ELEMENT_ARRAY_BUFFER,this.indices,c.STATIC_DRAW)):(c.bindBuffer(c.ARRAY_BUFFER,this._vertexBuffer),c.bufferSubData(c.ARRAY_BUFFER,0,this.vertices),c.vertexAttribPointer(f.aVertexPosition,2,c.FLOAT,!1,0,0),c.bindBuffer(c.ARRAY_BUFFER,this._uvBuffer),c.vertexAttribPointer(f.aTextureCoord,2,c.FLOAT,!1,0,0),c.activeTexture(c.TEXTURE0),this.texture.baseTexture._dirty[c.id]?a.renderer.updateTexture(this.texture.baseTexture):c.bindTexture(c.TEXTURE_2D,this.texture.baseTexture._glTextures[c.id]),c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,this._indexBuffer)),c.drawElements(g,this.indices.length,c.UNSIGNED_SHORT,0)},b.Strip.prototype._renderCanvas=function(a){var c=a.context,d=this.worldTransform;a.roundPixels?c.setTransform(d.a,d.b,d.c,d.d,0|d.tx,0|d.ty):c.setTransform(d.a,d.b,d.c,d.d,d.tx,d.ty),this.drawMode===b.Strip.DrawModes.TRIANGLE_STRIP?this._renderCanvasTriangleStrip(c):this._renderCanvasTriangles(c)},b.Strip.prototype._renderCanvasTriangleStrip=function(a){var b=this.vertices,c=this.uvs,d=b.length/2;this.count++;for(var e=0;d-2>e;e++){var f=2*e;this._renderCanvasDrawTriangle(a,b,c,f,f+2,f+4)}},b.Strip.prototype._renderCanvasTriangles=function(a){var b=this.vertices,c=this.uvs,d=this.indices,e=d.length;this.count++;for(var f=0;e>f;f+=3){var g=2*d[f],h=2*d[f+1],i=2*d[f+2];this._renderCanvasDrawTriangle(a,b,c,g,h,i)}},b.Strip.prototype._renderCanvasDrawTriangle=function(a,b,c,d,e,f){var g=this.texture.baseTexture.source,h=this.texture.width,i=this.texture.height,j=b[d],k=b[e],l=b[f],m=b[d+1],n=b[e+1],o=b[f+1],p=c[d]*h,q=c[e]*h,r=c[f]*h,s=c[d+1]*i,t=c[e+1]*i,u=c[f+1]*i;if(this.canvasPadding>0){var v=this.canvasPadding/this.worldTransform.a,w=this.canvasPadding/this.worldTransform.d,x=(j+k+l)/3,y=(m+n+o)/3,z=j-x,A=m-y,B=Math.sqrt(z*z+A*A);j=x+z/B*(B+v),m=y+A/B*(B+w),z=k-x,A=n-y,B=Math.sqrt(z*z+A*A),k=x+z/B*(B+v),n=y+A/B*(B+w),z=l-x,A=o-y,B=Math.sqrt(z*z+A*A),l=x+z/B*(B+v),o=y+A/B*(B+w)}a.save(),a.beginPath(),a.moveTo(j,m),a.lineTo(k,n),a.lineTo(l,o),a.closePath(),a.clip();var C=p*t+s*r+q*u-t*r-s*q-p*u,D=j*t+s*l+k*u-t*l-s*k-j*u,E=p*k+j*r+q*l-k*r-j*q-p*l,F=p*t*l+s*k*r+j*q*u-j*t*r-s*q*l-p*k*u,G=m*t+s*o+n*u-t*o-s*n-m*u,H=p*n+m*r+q*o-n*r-m*q-p*o,I=p*t*o+s*n*r+m*q*u-m*t*r-s*q*o-p*n*u;a.transform(D/C,G/C,E/C,H/C,F/C,I/C),a.drawImage(g,0,0),a.restore()},b.Strip.prototype.renderStripFlat=function(a){var b=this.context,c=a.vertices,d=c.length/2;this.count++,b.beginPath();for(var e=1;d-2>e;e++){var f=2*e,g=c[f],h=c[f+2],i=c[f+4],j=c[f+1],k=c[f+3],l=c[f+5];b.moveTo(g,j),b.lineTo(h,k),b.lineTo(i,l)}b.fillStyle="#FF0000",b.fill(),b.closePath()},b.Strip.prototype.onTextureUpdate=function(){this.updateFrame=!0},b.Strip.prototype.getBounds=function(a){for(var c=a||this.worldTransform,d=c.a,e=c.b,f=c.c,g=c.d,h=c.tx,i=c.ty,j=-(1/0),k=-(1/0),l=1/0,m=1/0,n=this.vertices,o=0,p=n.length;p>o;o+=2){var q=n[o],r=n[o+1],s=d*q+f*r+h,t=g*r+e*q+i;l=l>s?s:l,m=m>t?t:m,j=s>j?s:j,k=t>k?t:k}if(l===-(1/0)||k===1/0)return b.EmptyRectangle;var u=this._bounds;return u.x=l,u.width=j-l,u.y=m,u.height=k-m,this._currentBounds=u,u},b.Strip.DrawModes={TRIANGLE_STRIP:0,TRIANGLES:1},b.Rope=function(a,c){b.Strip.call(this,a),this.points=c,this.vertices=new b.Float32Array(4*c.length),this.uvs=new b.Float32Array(4*c.length),this.colors=new b.Float32Array(2*c.length),this.indices=new b.Uint16Array(2*c.length),this.refresh()},b.Rope.prototype=Object.create(b.Strip.prototype),b.Rope.prototype.constructor=b.Rope,b.Rope.prototype.refresh=function(){var a=this.points;if(!(a.length<1)){var b=this.uvs,c=a[0],d=this.indices,e=this.colors;this.count-=.2,b[0]=0,b[1]=0,b[2]=0,b[3]=1,e[0]=1,e[1]=1,d[0]=0,d[1]=1;for(var f,g,h,i=a.length,j=1;i>j;j++)f=a[j],g=4*j,h=j/(i-1),j%2?(b[g]=h,b[g+1]=0,b[g+2]=h,b[g+3]=1):(b[g]=h,b[g+1]=0,b[g+2]=h,b[g+3]=1),g=2*j,e[g]=1,e[g+1]=1,g=2*j,d[g]=g,d[g+1]=g+1,c=f}},b.Rope.prototype.updateTransform=function(){var a=this.points;if(!(a.length<1)){var c,d=a[0],e={x:0,y:0};this.count-=.2;for(var f,g,h,i,j,k=this.vertices,l=a.length,m=0;l>m;m++)f=a[m],
g=4*m,c=m<a.length-1?a[m+1]:f,e.y=-(c.x-d.x),e.x=c.y-d.y,h=10*(1-m/(l-1)),h>1&&(h=1),i=Math.sqrt(e.x*e.x+e.y*e.y),j=this.texture.height/2,e.x/=i,e.y/=i,e.x*=j,e.y*=j,k[g]=f.x+e.x,k[g+1]=f.y+e.y,k[g+2]=f.x-e.x,k[g+3]=f.y-e.y,d=f;b.DisplayObjectContainer.prototype.updateTransform.call(this)}},b.Rope.prototype.setTexture=function(a){this.texture=a},b.TilingSprite=function(a,c,d){b.Sprite.call(this,a),this._width=c||100,this._height=d||100,this.tileScale=new b.Point(1,1),this.tileScaleOffset=new b.Point(1,1),this.tilePosition=new b.Point(0,0),this.renderable=!0,this.tint=16777215,this.blendMode=b.blendModes.NORMAL},b.TilingSprite.prototype=Object.create(b.Sprite.prototype),b.TilingSprite.prototype.constructor=b.TilingSprite,Object.defineProperty(b.TilingSprite.prototype,"width",{get:function(){return this._width},set:function(a){this._width=a}}),Object.defineProperty(b.TilingSprite.prototype,"height",{get:function(){return this._height},set:function(a){this._height=a}}),b.TilingSprite.prototype.setTexture=function(a){this.texture!==a&&(this.texture=a,this.refreshTexture=!0,this.cachedTint=16777215)},b.TilingSprite.prototype._renderWebGL=function(a){if(this.visible!==!1&&0!==this.alpha){var b,c;for(this._mask&&(a.spriteBatch.stop(),a.maskManager.pushMask(this.mask,a),a.spriteBatch.start()),this._filters&&(a.spriteBatch.flush(),a.filterManager.pushFilter(this._filterBlock)),!this.tilingTexture||this.refreshTexture?(this.generateTilingTexture(!0),this.tilingTexture&&this.tilingTexture.needsUpdate&&(a.renderer.updateTexture(this.tilingTexture.baseTexture),this.tilingTexture.needsUpdate=!1)):a.spriteBatch.renderTilingSprite(this),b=0,c=this.children.length;c>b;b++)this.children[b]._renderWebGL(a);a.spriteBatch.stop(),this._filters&&a.filterManager.popFilter(),this._mask&&a.maskManager.popMask(this._mask,a),a.spriteBatch.start()}},b.TilingSprite.prototype._renderCanvas=function(a){if(this.visible!==!1&&0!==this.alpha){var c=a.context;this._mask&&a.maskManager.pushMask(this._mask,a),c.globalAlpha=this.worldAlpha;var d,e,f=this.worldTransform,g=a.resolution;if(c.setTransform(f.a*g,f.b*g,f.c*g,f.d*g,f.tx*g,f.ty*g),!this.__tilePattern||this.refreshTexture){if(this.generateTilingTexture(!1),!this.tilingTexture)return;this.__tilePattern=c.createPattern(this.tilingTexture.baseTexture.source,"repeat")}this.blendMode!==a.currentBlendMode&&(a.currentBlendMode=this.blendMode,c.globalCompositeOperation=b.blendModesCanvas[a.currentBlendMode]);var h=this.tilePosition,i=this.tileScale;for(h.x%=this.tilingTexture.baseTexture.width,h.y%=this.tilingTexture.baseTexture.height,c.scale(i.x,i.y),c.translate(h.x+this.anchor.x*-this._width,h.y+this.anchor.y*-this._height),c.fillStyle=this.__tilePattern,c.fillRect(-h.x,-h.y,this._width/i.x,this._height/i.y),c.scale(1/i.x,1/i.y),c.translate(-h.x+this.anchor.x*this._width,-h.y+this.anchor.y*this._height),this._mask&&a.maskManager.popMask(a),d=0,e=this.children.length;e>d;d++)this.children[d]._renderCanvas(a)}},b.TilingSprite.prototype.getBounds=function(){var a=this._width,b=this._height,c=a*(1-this.anchor.x),d=a*-this.anchor.x,e=b*(1-this.anchor.y),f=b*-this.anchor.y,g=this.worldTransform,h=g.a,i=g.b,j=g.c,k=g.d,l=g.tx,m=g.ty,n=h*d+j*f+l,o=k*f+i*d+m,p=h*c+j*f+l,q=k*f+i*c+m,r=h*c+j*e+l,s=k*e+i*c+m,t=h*d+j*e+l,u=k*e+i*d+m,v=-(1/0),w=-(1/0),x=1/0,y=1/0;x=x>n?n:x,x=x>p?p:x,x=x>r?r:x,x=x>t?t:x,y=y>o?o:y,y=y>q?q:y,y=y>s?s:y,y=y>u?u:y,v=n>v?n:v,v=p>v?p:v,v=r>v?r:v,v=t>v?t:v,w=o>w?o:w,w=q>w?q:w,w=s>w?s:w,w=u>w?u:w;var z=this._bounds;return z.x=x,z.width=v-x,z.y=y,z.height=w-y,this._currentBounds=z,z},b.TilingSprite.prototype.onTextureUpdate=function(){},b.TilingSprite.prototype.generateTilingTexture=function(a){if(this.texture.baseTexture.hasLoaded){var c,d,e=this.originalTexture||this.texture,f=e.frame,g=f.width!==e.baseTexture.width||f.height!==e.baseTexture.height,h=!1;if(a?(c=b.getNextPowerOfTwo(f.width),d=b.getNextPowerOfTwo(f.height),(f.width!==c||f.height!==d||e.baseTexture.width!==c||e.baseTexture.height||d)&&(h=!0)):g&&(e.trim?(c=e.trim.width,d=e.trim.height):(c=f.width,d=f.height),h=!0),h){var i;this.tilingTexture&&this.tilingTexture.isTiling?(i=this.tilingTexture.canvasBuffer,i.resize(c,d),this.tilingTexture.baseTexture.width=c,this.tilingTexture.baseTexture.height=d,this.tilingTexture.needsUpdate=!0):(i=new b.CanvasBuffer(c,d),this.tilingTexture=b.Texture.fromCanvas(i.canvas),this.tilingTexture.canvasBuffer=i,this.tilingTexture.isTiling=!0),i.context.drawImage(e.baseTexture.source,e.crop.x,e.crop.y,e.crop.width,e.crop.height,0,0,c,d),this.tileScaleOffset.x=f.width/c,this.tileScaleOffset.y=f.height/d}else this.tilingTexture&&this.tilingTexture.isTiling&&this.tilingTexture.destroy(!0),this.tileScaleOffset.x=1,this.tileScaleOffset.y=1,this.tilingTexture=e;this.refreshTexture=!1,this.originalTexture=this.texture,this.texture=this.tilingTexture,this.tilingTexture.baseTexture._powerOf2=!0}},b.TilingSprite.prototype.destroy=function(){b.Sprite.prototype.destroy.call(this),this.tileScale=null,this.tileScaleOffset=null,this.tilePosition=null,this.tilingTexture&&(this.tilingTexture.destroy(!0),this.tilingTexture=null)};var c={radDeg:180/Math.PI,degRad:Math.PI/180,temp:[],Float32Array:"undefined"==typeof Float32Array?Array:Float32Array,Uint16Array:"undefined"==typeof Uint16Array?Array:Uint16Array};c.BoneData=function(a,b){this.name=a,this.parent=b},c.BoneData.prototype={length:0,x:0,y:0,rotation:0,scaleX:1,scaleY:1,inheritScale:!0,inheritRotation:!0,flipX:!1,flipY:!1},c.SlotData=function(a,b){this.name=a,this.boneData=b},c.SlotData.prototype={r:1,g:1,b:1,a:1,attachmentName:null,additiveBlending:!1},c.IkConstraintData=function(a){this.name=a,this.bones=[]},c.IkConstraintData.prototype={target:null,bendDirection:1,mix:1},c.Bone=function(a,b,c){this.data=a,this.skeleton=b,this.parent=c,this.setToSetupPose()},c.Bone.yDown=!1,c.Bone.prototype={x:0,y:0,rotation:0,rotationIK:0,scaleX:1,scaleY:1,flipX:!1,flipY:!1,m00:0,m01:0,worldX:0,m10:0,m11:0,worldY:0,worldRotation:0,worldScaleX:1,worldScaleY:1,worldFlipX:!1,worldFlipY:!1,updateWorldTransform:function(){var a=this.parent;if(a)this.worldX=this.x*a.m00+this.y*a.m01+a.worldX,this.worldY=this.x*a.m10+this.y*a.m11+a.worldY,this.data.inheritScale?(this.worldScaleX=a.worldScaleX*this.scaleX,this.worldScaleY=a.worldScaleY*this.scaleY):(this.worldScaleX=this.scaleX,this.worldScaleY=this.scaleY),this.worldRotation=this.data.inheritRotation?a.worldRotation+this.rotationIK:this.rotationIK,this.worldFlipX=a.worldFlipX!=this.flipX,this.worldFlipY=a.worldFlipY!=this.flipY;else{var b=this.skeleton.flipX,d=this.skeleton.flipY;this.worldX=b?-this.x:this.x,this.worldY=d!=c.Bone.yDown?-this.y:this.y,this.worldScaleX=this.scaleX,this.worldScaleY=this.scaleY,this.worldRotation=this.rotationIK,this.worldFlipX=b!=this.flipX,this.worldFlipY=d!=this.flipY}var e=this.worldRotation*c.degRad,f=Math.cos(e),g=Math.sin(e);this.worldFlipX?(this.m00=-f*this.worldScaleX,this.m01=g*this.worldScaleY):(this.m00=f*this.worldScaleX,this.m01=-g*this.worldScaleY),this.worldFlipY!=c.Bone.yDown?(this.m10=-g*this.worldScaleX,this.m11=-f*this.worldScaleY):(this.m10=g*this.worldScaleX,this.m11=f*this.worldScaleY)},setToSetupPose:function(){var a=this.data;this.x=a.x,this.y=a.y,this.rotation=a.rotation,this.rotationIK=this.rotation,this.scaleX=a.scaleX,this.scaleY=a.scaleY,this.flipX=a.flipX,this.flipY=a.flipY},worldToLocal:function(a){var b=a[0]-this.worldX,d=a[1]-this.worldY,e=this.m00,f=this.m10,g=this.m01,h=this.m11;this.worldFlipX!=(this.worldFlipY!=c.Bone.yDown)&&(e=-e,h=-h);var i=1/(e*h-g*f);a[0]=b*e*i-d*g*i,a[1]=d*h*i-b*f*i},localToWorld:function(a){var b=a[0],c=a[1];a[0]=b*this.m00+c*this.m01+this.worldX,a[1]=b*this.m10+c*this.m11+this.worldY}},c.Slot=function(a,b){this.data=a,this.bone=b,this.setToSetupPose()},c.Slot.prototype={r:1,g:1,b:1,a:1,_attachmentTime:0,attachment:null,attachmentVertices:[],setAttachment:function(a){this.attachment=a,this._attachmentTime=this.bone.skeleton.time,this.attachmentVertices.length=0},setAttachmentTime:function(a){this._attachmentTime=this.bone.skeleton.time-a},getAttachmentTime:function(){return this.bone.skeleton.time-this._attachmentTime},setToSetupPose:function(){var a=this.data;this.r=a.r,this.g=a.g,this.b=a.b,this.a=a.a;for(var b=this.bone.skeleton.data.slots,c=0,d=b.length;d>c;c++)if(b[c]==a){this.setAttachment(a.attachmentName?this.bone.skeleton.getAttachmentBySlotIndex(c,a.attachmentName):null);break}}},c.IkConstraint=function(a,b){this.data=a,this.mix=a.mix,this.bendDirection=a.bendDirection,this.bones=[];for(var c=0,d=a.bones.length;d>c;c++)this.bones.push(b.findBone(a.bones[c].name));this.target=b.findBone(a.target.name)},c.IkConstraint.prototype={apply:function(){var a=this.target,b=this.bones;switch(b.length){case 1:c.IkConstraint.apply1(b[0],a.worldX,a.worldY,this.mix);break;case 2:c.IkConstraint.apply2(b[0],b[1],a.worldX,a.worldY,this.bendDirection,this.mix)}}},c.IkConstraint.apply1=function(a,b,d,e){var f=a.data.inheritRotation&&a.parent?a.parent.worldRotation:0,g=a.rotation,h=Math.atan2(d-a.worldY,b-a.worldX)*c.radDeg-f;a.rotationIK=g+(h-g)*e},c.IkConstraint.apply2=function(a,b,d,e,f,g){var h=b.rotation,i=a.rotation;if(!g)return b.rotationIK=h,void(a.rotationIK=i);var j,k,l=c.temp,m=a.parent;m?(l[0]=d,l[1]=e,m.worldToLocal(l),d=(l[0]-a.x)*m.worldScaleX,e=(l[1]-a.y)*m.worldScaleY):(d-=a.x,e-=a.y),b.parent==a?(j=b.x,k=b.y):(l[0]=b.x,l[1]=b.y,b.parent.localToWorld(l),a.worldToLocal(l),j=l[0],k=l[1]);var n=j*a.worldScaleX,o=k*a.worldScaleY,p=Math.atan2(o,n),q=Math.sqrt(n*n+o*o),r=b.data.length*b.worldScaleX,s=2*q*r;if(1e-4>s)return void(b.rotationIK=h+(Math.atan2(e,d)*c.radDeg-i-h)*g);var t=(d*d+e*e-q*q-r*r)/s;-1>t?t=-1:t>1&&(t=1);var u=Math.acos(t)*f,v=q+r*t,w=r*Math.sin(u),x=Math.atan2(e*v-d*w,d*v+e*w),y=(x-p)*c.radDeg-i;y>180?y-=360:-180>y&&(y+=360),a.rotationIK=i+y*g,y=(u+p)*c.radDeg-h,y>180?y-=360:-180>y&&(y+=360),b.rotationIK=h+(y+a.worldRotation-b.parent.worldRotation)*g},c.Skin=function(a){this.name=a,this.attachments={}},c.Skin.prototype={addAttachment:function(a,b,c){this.attachments[a+":"+b]=c},getAttachment:function(a,b){return this.attachments[a+":"+b]},_attachAll:function(a,b){for(var c in b.attachments){var d=c.indexOf(":"),e=parseInt(c.substring(0,d)),f=c.substring(d+1),g=a.slots[e];if(g.attachment&&g.attachment.name==f){var h=this.getAttachment(e,f);h&&g.setAttachment(h)}}}},c.Animation=function(a,b,c){this.name=a,this.timelines=b,this.duration=c},c.Animation.prototype={apply:function(a,b,c,d,e){d&&0!=this.duration&&(c%=this.duration,b%=this.duration);for(var f=this.timelines,g=0,h=f.length;h>g;g++)f[g].apply(a,b,c,e,1)},mix:function(a,b,c,d,e,f){d&&0!=this.duration&&(c%=this.duration,b%=this.duration);for(var g=this.timelines,h=0,i=g.length;i>h;h++)g[h].apply(a,b,c,e,f)}},c.Animation.binarySearch=function(a,b,c){var d=0,e=Math.floor(a.length/c)-2;if(!e)return c;for(var f=e>>>1;;){if(a[(f+1)*c]<=b?d=f+1:e=f,d==e)return(d+1)*c;f=d+e>>>1}},c.Animation.binarySearch1=function(a,b){var c=0,d=a.length-2;if(!d)return 1;for(var e=d>>>1;;){if(a[e+1]<=b?c=e+1:d=e,c==d)return c+1;e=c+d>>>1}},c.Animation.linearSearch=function(a,b,c){for(var d=0,e=a.length-c;e>=d;d+=c)if(a[d]>b)return d;return-1},c.Curves=function(a){this.curves=[]},c.Curves.prototype={setLinear:function(a){this.curves[19*a]=0},setStepped:function(a){this.curves[19*a]=1},setCurve:function(a,b,c,d,e){var f=.1,g=f*f,h=g*f,i=3*f,j=3*g,k=6*g,l=6*h,m=2*-b+d,n=2*-c+e,o=3*(b-d)+1,p=3*(c-e)+1,q=b*i+m*j+o*h,r=c*i+n*j+p*h,s=m*k+o*l,t=n*k+p*l,u=o*l,v=p*l,w=19*a,x=this.curves;x[w++]=2;for(var y=q,z=r,A=w+19-1;A>w;w+=2)x[w]=y,x[w+1]=z,q+=s,r+=t,s+=u,t+=v,y+=q,z+=r},getCurvePercent:function(a,b){b=0>b?0:b>1?1:b;var c=this.curves,d=19*a,e=c[d];if(0===e)return b;if(1==e)return 0;d++;for(var f=0,g=d,h=d+19-1;h>d;d+=2)if(f=c[d],f>=b){var i,j;return d==g?(i=0,j=0):(i=c[d-2],j=c[d-1]),j+(c[d+1]-j)*(b-i)/(f-i)}var k=c[d-1];return k+(1-k)*(b-f)/(1-f)}},c.RotateTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=2*a},c.RotateTimeline.prototype={boneIndex:0,getFrameCount:function(){return this.frames.length/2},setFrame:function(a,b,c){a*=2,this.frames[a]=b,this.frames[a+1]=c},apply:function(a,b,d,e,f){var g=this.frames;if(!(d<g[0])){var h=a.bones[this.boneIndex];if(d>=g[g.length-2]){for(var i=h.data.rotation+g[g.length-1]-h.rotation;i>180;)i-=360;for(;-180>i;)i+=360;return void(h.rotation+=i*f)}var j=c.Animation.binarySearch(g,d,2),k=g[j-1],l=g[j],m=1-(d-l)/(g[j-2]-l);m=this.curves.getCurvePercent(j/2-1,m);for(var i=g[j+1]-k;i>180;)i-=360;for(;-180>i;)i+=360;for(i=h.data.rotation+(k+i*m)-h.rotation;i>180;)i-=360;for(;-180>i;)i+=360;h.rotation+=i*f}}},c.TranslateTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=3*a},c.TranslateTimeline.prototype={boneIndex:0,getFrameCount:function(){return this.frames.length/3},setFrame:function(a,b,c,d){a*=3,this.frames[a]=b,this.frames[a+1]=c,this.frames[a+2]=d},apply:function(a,b,d,e,f){var g=this.frames;if(!(d<g[0])){var h=a.bones[this.boneIndex];if(d>=g[g.length-3])return h.x+=(h.data.x+g[g.length-2]-h.x)*f,void(h.y+=(h.data.y+g[g.length-1]-h.y)*f);var i=c.Animation.binarySearch(g,d,3),j=g[i-2],k=g[i-1],l=g[i],m=1-(d-l)/(g[i+-3]-l);m=this.curves.getCurvePercent(i/3-1,m),h.x+=(h.data.x+j+(g[i+1]-j)*m-h.x)*f,h.y+=(h.data.y+k+(g[i+2]-k)*m-h.y)*f}}},c.ScaleTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=3*a},c.ScaleTimeline.prototype={boneIndex:0,getFrameCount:function(){return this.frames.length/3},setFrame:function(a,b,c,d){a*=3,this.frames[a]=b,this.frames[a+1]=c,this.frames[a+2]=d},apply:function(a,b,d,e,f){var g=this.frames;if(!(d<g[0])){var h=a.bones[this.boneIndex];if(d>=g[g.length-3])return h.scaleX+=(h.data.scaleX*g[g.length-2]-h.scaleX)*f,void(h.scaleY+=(h.data.scaleY*g[g.length-1]-h.scaleY)*f);var i=c.Animation.binarySearch(g,d,3),j=g[i-2],k=g[i-1],l=g[i],m=1-(d-l)/(g[i+-3]-l);m=this.curves.getCurvePercent(i/3-1,m),h.scaleX+=(h.data.scaleX*(j+(g[i+1]-j)*m)-h.scaleX)*f,h.scaleY+=(h.data.scaleY*(k+(g[i+2]-k)*m)-h.scaleY)*f}}},c.ColorTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=5*a},c.ColorTimeline.prototype={slotIndex:0,getFrameCount:function(){return this.frames.length/5},setFrame:function(a,b,c,d,e,f){a*=5,this.frames[a]=b,this.frames[a+1]=c,this.frames[a+2]=d,this.frames[a+3]=e,this.frames[a+4]=f},apply:function(a,b,d,e,f){var g=this.frames;if(!(d<g[0])){var h,i,j,k;if(d>=g[g.length-5]){var l=g.length-1;h=g[l-3],i=g[l-2],j=g[l-1],k=g[l]}else{var m=c.Animation.binarySearch(g,d,5),n=g[m-4],o=g[m-3],p=g[m-2],q=g[m-1],r=g[m],s=1-(d-r)/(g[m-5]-r);s=this.curves.getCurvePercent(m/5-1,s),h=n+(g[m+1]-n)*s,i=o+(g[m+2]-o)*s,j=p+(g[m+3]-p)*s,k=q+(g[m+4]-q)*s}var t=a.slots[this.slotIndex];1>f?(t.r+=(h-t.r)*f,t.g+=(i-t.g)*f,t.b+=(j-t.b)*f,t.a+=(k-t.a)*f):(t.r=h,t.g=i,t.b=j,t.a=k)}}},c.AttachmentTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=a,this.attachmentNames=[],this.attachmentNames.length=a},c.AttachmentTimeline.prototype={slotIndex:0,getFrameCount:function(){return this.frames.length},setFrame:function(a,b,c){this.frames[a]=b,this.attachmentNames[a]=c},apply:function(a,b,d,e,f){var g=this.frames;if(d<g[0])return void(b>d&&this.apply(a,b,Number.MAX_VALUE,null,0));b>d&&(b=-1);var h=d>=g[g.length-1]?g.length-1:c.Animation.binarySearch1(g,d)-1;if(!(g[h]<b)){var i=this.attachmentNames[h];a.slots[this.slotIndex].setAttachment(i?a.getAttachmentBySlotIndex(this.slotIndex,i):null)}}},c.EventTimeline=function(a){this.frames=[],this.frames.length=a,this.events=[],this.events.length=a},c.EventTimeline.prototype={getFrameCount:function(){return this.frames.length},setFrame:function(a,b,c){this.frames[a]=b,this.events[a]=c},apply:function(a,b,d,e,f){if(e){var g=this.frames,h=g.length;if(b>d)this.apply(a,b,Number.MAX_VALUE,e,f),b=-1;else if(b>=g[h-1])return;if(!(d<g[0])){var i;if(b<g[0])i=0;else{i=c.Animation.binarySearch1(g,b);for(var j=g[i];i>0&&g[i-1]==j;)i--}for(var k=this.events;h>i&&d>=g[i];i++)e.push(k[i])}}}},c.DrawOrderTimeline=function(a){this.frames=[],this.frames.length=a,this.drawOrders=[],this.drawOrders.length=a},c.DrawOrderTimeline.prototype={getFrameCount:function(){return this.frames.length},setFrame:function(a,b,c){this.frames[a]=b,this.drawOrders[a]=c},apply:function(a,b,d,e,f){var g=this.frames;if(!(d<g[0])){var h;h=d>=g[g.length-1]?g.length-1:c.Animation.binarySearch1(g,d)-1;var i=a.drawOrder,j=(a.slots,this.drawOrders[h]);if(j)for(var k=0,l=j.length;l>k;k++)i[k]=j[k]}}},c.FfdTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=a,this.frameVertices=[],this.frameVertices.length=a},c.FfdTimeline.prototype={slotIndex:0,attachment:0,getFrameCount:function(){return this.frames.length},setFrame:function(a,b,c){this.frames[a]=b,this.frameVertices[a]=c},apply:function(a,b,d,e,f){var g=a.slots[this.slotIndex];if(g.attachment==this.attachment){var h=this.frames;if(!(d<h[0])){var i=this.frameVertices,j=i[0].length,k=g.attachmentVertices;if(k.length!=j&&(f=1),k.length=j,d>=h[h.length-1]){var l=i[h.length-1];if(1>f)for(var m=0;j>m;m++)k[m]+=(l[m]-k[m])*f;else for(var m=0;j>m;m++)k[m]=l[m]}else{var n=c.Animation.binarySearch1(h,d),o=h[n],p=1-(d-o)/(h[n-1]-o);p=this.curves.getCurvePercent(n-1,0>p?0:p>1?1:p);var q=i[n-1],r=i[n];if(1>f)for(var m=0;j>m;m++){var s=q[m];k[m]+=(s+(r[m]-s)*p-k[m])*f}else for(var m=0;j>m;m++){var s=q[m];k[m]=s+(r[m]-s)*p}}}}}},c.IkConstraintTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=3*a},c.IkConstraintTimeline.prototype={ikConstraintIndex:0,getFrameCount:function(){return this.frames.length/3},setFrame:function(a,b,c,d){a*=3,this.frames[a]=b,this.frames[a+1]=c,this.frames[a+2]=d},apply:function(a,b,d,e,f){var g=this.frames;if(!(d<g[0])){var h=a.ikConstraints[this.ikConstraintIndex];if(d>=g[g.length-3])return h.mix+=(g[g.length-2]-h.mix)*f,void(h.bendDirection=g[g.length-1]);var i=c.Animation.binarySearch(g,d,3),j=g[i+-2],k=g[i],l=1-(d-k)/(g[i+-3]-k);l=this.curves.getCurvePercent(i/3-1,l);var m=j+(g[i+1]-j)*l;h.mix+=(m-h.mix)*f,h.bendDirection=g[i+-1]}}},c.FlipXTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=2*a},c.FlipXTimeline.prototype={boneIndex:0,getFrameCount:function(){return this.frames.length/2},setFrame:function(a,b,c){a*=2,this.frames[a]=b,this.frames[a+1]=c?1:0},apply:function(a,b,d,e,f){var g=this.frames;if(d<g[0])return void(b>d&&this.apply(a,b,Number.MAX_VALUE,null,0));b>d&&(b=-1);var h=(d>=g[g.length-2]?g.length:c.Animation.binarySearch(g,d,2))-2;g[h]<b||(a.bones[this.boneIndex].flipX=0!=g[h+1])}},c.FlipYTimeline=function(a){this.curves=new c.Curves(a),this.frames=[],this.frames.length=2*a},c.FlipYTimeline.prototype={boneIndex:0,getFrameCount:function(){return this.frames.length/2},setFrame:function(a,b,c){a*=2,this.frames[a]=b,this.frames[a+1]=c?1:0},apply:function(a,b,d,e,f){var g=this.frames;if(d<g[0])return void(b>d&&this.apply(a,b,Number.MAX_VALUE,null,0));b>d&&(b=-1);var h=(d>=g[g.length-2]?g.length:c.Animation.binarySearch(g,d,2))-2;g[h]<b||(a.bones[this.boneIndex].flipY=0!=g[h+1])}},c.SkeletonData=function(){this.bones=[],this.slots=[],this.skins=[],this.events=[],this.animations=[],this.ikConstraints=[]},c.SkeletonData.prototype={name:null,defaultSkin:null,width:0,height:0,version:null,hash:null,findBone:function(a){for(var b=this.bones,c=0,d=b.length;d>c;c++)if(b[c].name==a)return b[c];return null},findBoneIndex:function(a){for(var b=this.bones,c=0,d=b.length;d>c;c++)if(b[c].name==a)return c;return-1},findSlot:function(a){for(var b=this.slots,c=0,d=b.length;d>c;c++)if(b[c].name==a)return slot[c];return null},findSlotIndex:function(a){for(var b=this.slots,c=0,d=b.length;d>c;c++)if(b[c].name==a)return c;return-1},findSkin:function(a){for(var b=this.skins,c=0,d=b.length;d>c;c++)if(b[c].name==a)return b[c];return null},findEvent:function(a){for(var b=this.events,c=0,d=b.length;d>c;c++)if(b[c].name==a)return b[c];return null},findAnimation:function(a){for(var b=this.animations,c=0,d=b.length;d>c;c++)if(b[c].name==a)return b[c];return null},findIkConstraint:function(a){for(var b=this.ikConstraints,c=0,d=b.length;d>c;c++)if(b[c].name==a)return b[c];return null}},c.Skeleton=function(a){this.data=a,this.bones=[];for(var b=0,d=a.bones.length;d>b;b++){var e=a.bones[b],f=e.parent?this.bones[a.bones.indexOf(e.parent)]:null;this.bones.push(new c.Bone(e,this,f))}this.slots=[],this.drawOrder=[];for(var b=0,d=a.slots.length;d>b;b++){var g=a.slots[b],h=this.bones[a.bones.indexOf(g.boneData)],i=new c.Slot(g,h);this.slots.push(i),this.drawOrder.push(b)}this.ikConstraints=[];for(var b=0,d=a.ikConstraints.length;d>b;b++)this.ikConstraints.push(new c.IkConstraint(a.ikConstraints[b],this));this.boneCache=[],this.updateCache()},c.Skeleton.prototype={x:0,y:0,skin:null,r:1,g:1,b:1,a:1,time:0,flipX:!1,flipY:!1,updateCache:function(){var a=this.ikConstraints,b=a.length,c=b+1,d=this.boneCache;d.length>c&&(d.length=c);for(var e=0,f=d.length;f>e;e++)d[e].length=0;for(;d.length<c;)d[d.length]=[];var g=d[0],h=this.bones;a:for(var e=0,f=h.length;f>e;e++){var i=h[e],j=i;do{for(var k=0;b>k;k++)for(var l=a[k],m=l.bones[0],n=l.bones[l.bones.length-1];;){if(j==n){d[k].push(i),d[k+1].push(i);continue a}if(n==m)break;n=n.parent}j=j.parent}while(j);g[g.length]=i}},updateWorldTransform:function(){for(var a=this.bones,b=0,c=a.length;c>b;b++){var d=a[b];d.rotationIK=d.rotation}for(var b=0,e=this.boneCache.length-1;;){for(var f=this.boneCache[b],g=0,h=f.length;h>g;g++)f[g].updateWorldTransform();if(b==e)break;this.ikConstraints[b].apply(),b++}},setToSetupPose:function(){this.setBonesToSetupPose(),this.setSlotsToSetupPose()},setBonesToSetupPose:function(){for(var a=this.bones,b=0,c=a.length;c>b;b++)a[b].setToSetupPose();for(var d=this.ikConstraints,b=0,c=d.length;c>b;b++){var e=d[b];e.bendDirection=e.data.bendDirection,e.mix=e.data.mix}},setSlotsToSetupPose:function(){for(var a=this.slots,b=0,c=a.length;c>b;b++)a[b].setToSetupPose(b);this.resetDrawOrder()},getRootBone:function(){return this.bones.length?this.bones[0]:null},findBone:function(a){for(var b=this.bones,c=0,d=b.length;d>c;c++)if(b[c].data.name==a)return b[c];return null},findBoneIndex:function(a){for(var b=this.bones,c=0,d=b.length;d>c;c++)if(b[c].data.name==a)return c;return-1},findSlot:function(a){for(var b=this.slots,c=0,d=b.length;d>c;c++)if(b[c].data.name==a)return b[c];return null},findSlotIndex:function(a){for(var b=this.slots,c=0,d=b.length;d>c;c++)if(b[c].data.name==a)return c;return-1},setSkinByName:function(a){var b=this.data.findSkin(a);if(!b)throw"Skin not found: "+a;this.setSkin(b)},setSkin:function(a){if(a)if(this.skin)a._attachAll(this,this.skin);else for(var b=this.slots,c=0,d=b.length;d>c;c++){var e=b[c],f=e.data.attachmentName;if(f){var g=a.getAttachment(c,f);g&&e.setAttachment(g)}}this.skin=a},getAttachmentBySlotName:function(a,b){return this.getAttachmentBySlotIndex(this.data.findSlotIndex(a),b)},getAttachmentBySlotIndex:function(a,b){if(this.skin){var c=this.skin.getAttachment(a,b);if(c)return c}return this.data.defaultSkin?this.data.defaultSkin.getAttachment(a,b):null},setAttachment:function(a,b){for(var c=this.slots,d=0,e=c.length;e>d;d++){var f=c[d];if(f.data.name==a){var g=null;if(b&&(g=this.getAttachmentBySlotIndex(d,b),!g))throw"Attachment not found: "+b+", for slot: "+a;return void f.setAttachment(g)}}throw"Slot not found: "+a},findIkConstraint:function(a){for(var b=this.ikConstraints,c=0,d=b.length;d>c;c++)if(b[c].data.name==a)return b[c];return null},update:function(a){this.time+=a},resetDrawOrder:function(){for(var a=0,b=this.drawOrder.length;b>a;a++)this.drawOrder[a]=a}},c.EventData=function(a){this.name=a},c.EventData.prototype={intValue:0,floatValue:0,stringValue:null},c.Event=function(a){this.data=a},c.Event.prototype={intValue:0,floatValue:0,stringValue:null},c.AttachmentType={region:0,boundingbox:1,mesh:2,skinnedmesh:3},c.RegionAttachment=function(a){this.name=a,this.offset=[],this.offset.length=8,this.uvs=[],this.uvs.length=8},c.RegionAttachment.prototype={type:c.AttachmentType.region,x:0,y:0,rotation:0,scaleX:1,scaleY:1,width:0,height:0,r:1,g:1,b:1,a:1,path:null,rendererObject:null,regionOffsetX:0,regionOffsetY:0,regionWidth:0,regionHeight:0,regionOriginalWidth:0,regionOriginalHeight:0,setUVs:function(a,b,c,d,e){var f=this.uvs;e?(f[2]=a,f[3]=d,f[4]=a,f[5]=b,f[6]=c,f[7]=b,f[0]=c,f[1]=d):(f[0]=a,f[1]=d,f[2]=a,f[3]=b,f[4]=c,f[5]=b,f[6]=c,f[7]=d)},updateOffset:function(){var a=this.width/this.regionOriginalWidth*this.scaleX,b=this.height/this.regionOriginalHeight*this.scaleY,d=-this.width/2*this.scaleX+this.regionOffsetX*a,e=-this.height/2*this.scaleY+this.regionOffsetY*b,f=d+this.regionWidth*a,g=e+this.regionHeight*b,h=this.rotation*c.degRad,i=Math.cos(h),j=Math.sin(h),k=d*i+this.x,l=d*j,m=e*i+this.y,n=e*j,o=f*i+this.x,p=f*j,q=g*i+this.y,r=g*j,s=this.offset;s[0]=k-n,s[1]=m+l,s[2]=k-r,s[3]=q+l,s[4]=o-r,s[5]=q+p,s[6]=o-n,s[7]=m+p},computeVertices:function(a,b,c,d){a+=c.worldX,b+=c.worldY;var e=c.m00,f=c.m01,g=c.m10,h=c.m11,i=this.offset;d[0]=i[0]*e+i[1]*f+a,d[1]=i[0]*g+i[1]*h+b,d[2]=i[2]*e+i[3]*f+a,d[3]=i[2]*g+i[3]*h+b,d[4]=i[4]*e+i[5]*f+a,d[5]=i[4]*g+i[5]*h+b,d[6]=i[6]*e+i[7]*f+a,d[7]=i[6]*g+i[7]*h+b}},c.MeshAttachment=function(a){this.name=a},c.MeshAttachment.prototype={type:c.AttachmentType.mesh,vertices:null,uvs:null,regionUVs:null,triangles:null,hullLength:0,r:1,g:1,b:1,a:1,path:null,rendererObject:null,regionU:0,regionV:0,regionU2:0,regionV2:0,regionRotate:!1,regionOffsetX:0,regionOffsetY:0,regionWidth:0,regionHeight:0,regionOriginalWidth:0,regionOriginalHeight:0,edges:null,width:0,height:0,updateUVs:function(){var a=this.regionU2-this.regionU,b=this.regionV2-this.regionV,d=this.regionUVs.length;if(this.uvs&&this.uvs.length==d||(this.uvs=new c.Float32Array(d)),this.regionRotate)for(var e=0;d>e;e+=2)this.uvs[e]=this.regionU+this.regionUVs[e+1]*a,this.uvs[e+1]=this.regionV+b-this.regionUVs[e]*b;else for(var e=0;d>e;e+=2)this.uvs[e]=this.regionU+this.regionUVs[e]*a,this.uvs[e+1]=this.regionV+this.regionUVs[e+1]*b},computeWorldVertices:function(a,b,c,d){var e=c.bone;a+=e.worldX,b+=e.worldY;var f=e.m00,g=e.m01,h=e.m10,i=e.m11,j=this.vertices,k=j.length;c.attachmentVertices.length==k&&(j=c.attachmentVertices);for(var l=0;k>l;l+=2){var m=j[l],n=j[l+1];d[l]=m*f+n*g+a,d[l+1]=m*h+n*i+b}}},c.SkinnedMeshAttachment=function(a){this.name=a},c.SkinnedMeshAttachment.prototype={type:c.AttachmentType.skinnedmesh,bones:null,weights:null,uvs:null,regionUVs:null,triangles:null,hullLength:0,r:1,g:1,b:1,a:1,path:null,rendererObject:null,regionU:0,regionV:0,regionU2:0,regionV2:0,regionRotate:!1,regionOffsetX:0,regionOffsetY:0,regionWidth:0,regionHeight:0,regionOriginalWidth:0,regionOriginalHeight:0,edges:null,width:0,height:0,updateUVs:function(a,b,d,e,f){var g=this.regionU2-this.regionU,h=this.regionV2-this.regionV,i=this.regionUVs.length;if(this.uvs&&this.uvs.length==i||(this.uvs=new c.Float32Array(i)),this.regionRotate)for(var j=0;i>j;j+=2)this.uvs[j]=this.regionU+this.regionUVs[j+1]*g,this.uvs[j+1]=this.regionV+h-this.regionUVs[j]*h;else for(var j=0;i>j;j+=2)this.uvs[j]=this.regionU+this.regionUVs[j]*g,this.uvs[j+1]=this.regionV+this.regionUVs[j+1]*h},computeWorldVertices:function(a,b,c,d){var e,f,g,h,i,j,k,l=c.bone.skeleton.bones,m=this.weights,n=this.bones,o=0,p=0,q=0,r=0,s=n.length;if(c.attachmentVertices.length)for(var t=c.attachmentVertices;s>p;o+=2){for(f=0,g=0,e=n[p++]+p;e>p;p++,q+=3,r+=2)h=l[n[p]],i=m[q]+t[r],j=m[q+1]+t[r+1],k=m[q+2],f+=(i*h.m00+j*h.m01+h.worldX)*k,g+=(i*h.m10+j*h.m11+h.worldY)*k;d[o]=f+a,d[o+1]=g+b}else for(;s>p;o+=2){for(f=0,g=0,e=n[p++]+p;e>p;p++,q+=3)h=l[n[p]],i=m[q],j=m[q+1],k=m[q+2],f+=(i*h.m00+j*h.m01+h.worldX)*k,g+=(i*h.m10+j*h.m11+h.worldY)*k;d[o]=f+a,d[o+1]=g+b}}},c.BoundingBoxAttachment=function(a){this.name=a,this.vertices=[]},c.BoundingBoxAttachment.prototype={type:c.AttachmentType.boundingbox,computeWorldVertices:function(a,b,c,d){a+=c.worldX,b+=c.worldY;for(var e=c.m00,f=c.m01,g=c.m10,h=c.m11,i=this.vertices,j=0,k=i.length;k>j;j+=2){var l=i[j],m=i[j+1];d[j]=l*e+m*f+a,d[j+1]=l*g+m*h+b}}},c.AnimationStateData=function(a){this.skeletonData=a,this.animationToMixTime={}},c.AnimationStateData.prototype={defaultMix:0,setMixByName:function(a,b,c){var d=this.skeletonData.findAnimation(a);if(!d)throw"Animation not found: "+a;var e=this.skeletonData.findAnimation(b);if(!e)throw"Animation not found: "+b;this.setMix(d,e,c)},setMix:function(a,b,c){this.animationToMixTime[a.name+":"+b.name]=c},getMix:function(a,b){var c=a.name+":"+b.name;return this.animationToMixTime.hasOwnProperty(c)?this.animationToMixTime[c]:this.defaultMix}},c.TrackEntry=function(){},c.TrackEntry.prototype={next:null,previous:null,animation:null,loop:!1,delay:0,time:0,lastTime:-1,endTime:0,timeScale:1,mixTime:0,mixDuration:0,mix:1,onStart:null,onEnd:null,onComplete:null,onEvent:null},c.AnimationState=function(a){this.data=a,this.tracks=[],this.events=[]},c.AnimationState.prototype={onStart:null,onEnd:null,onComplete:null,onEvent:null,timeScale:1,update:function(a){a*=this.timeScale;for(var b=0;b<this.tracks.length;b++){var c=this.tracks[b];if(c){if(c.time+=a*c.timeScale,c.previous){var d=a*c.previous.timeScale;c.previous.time+=d,c.mixTime+=d}var e=c.next;e?(e.time=c.lastTime-e.delay,e.time>=0&&this.setCurrent(b,e)):!c.loop&&c.lastTime>=c.endTime&&this.clearTrack(b)}}},apply:function(a){a.resetDrawOrder();for(var b=0;b<this.tracks.length;b++){var c=this.tracks[b];if(c){this.events.length=0;var d=c.time,e=c.lastTime,f=c.endTime,g=c.loop;!g&&d>f&&(d=f);var h=c.previous;if(h){var i=h.time;!h.loop&&i>h.endTime&&(i=h.endTime),h.animation.apply(a,i,i,h.loop,null);var j=c.mixTime/c.mixDuration*c.mix;j>=1&&(j=1,c.previous=null),c.animation.mix(a,c.lastTime,d,g,this.events,j)}else 1==c.mix?c.animation.apply(a,c.lastTime,d,g,this.events):c.animation.mix(a,c.lastTime,d,g,this.events,c.mix);for(var k=0,l=this.events.length;l>k;k++){var m=this.events[k];c.onEvent&&c.onEvent(b,m),this.onEvent&&this.onEvent(b,m)}if(g?e%f>d%f:f>e&&d>=f){var n=Math.floor(d/f);c.onComplete&&c.onComplete(b,n),this.onComplete&&this.onComplete(b,n)}c.lastTime=c.time}}},clearTracks:function(){for(var a=0,b=this.tracks.length;b>a;a++)this.clearTrack(a);this.tracks.length=0},clearTrack:function(a){if(!(a>=this.tracks.length)){var b=this.tracks[a];b&&(b.onEnd&&b.onEnd(a),this.onEnd&&this.onEnd(a),this.tracks[a]=null)}},_expandToIndex:function(a){if(a<this.tracks.length)return this.tracks[a];for(;a>=this.tracks.length;)this.tracks.push(null);return null},setCurrent:function(a,b){var c=this._expandToIndex(a);if(c){var d=c.previous;c.previous=null,c.onEnd&&c.onEnd(a),this.onEnd&&this.onEnd(a),b.mixDuration=this.data.getMix(c.animation,b.animation),b.mixDuration>0&&(b.mixTime=0,b.previous=d&&c.mixTime/c.mixDuration<.5?d:c)}this.tracks[a]=b,b.onStart&&b.onStart(a),this.onStart&&this.onStart(a)},setAnimationByName:function(a,b,c){var d=this.data.skeletonData.findAnimation(b);if(!d)throw"Animation not found: "+b;return this.setAnimation(a,d,c)},setAnimation:function(a,b,d){var e=new c.TrackEntry;return e.animation=b,e.loop=d,e.endTime=b.duration,this.setCurrent(a,e),e},addAnimationByName:function(a,b,c,d){var e=this.data.skeletonData.findAnimation(b);if(!e)throw"Animation not found: "+b;return this.addAnimation(a,e,c,d)},addAnimation:function(a,b,d,e){var f=new c.TrackEntry;f.animation=b,f.loop=d,f.endTime=b.duration;var g=this._expandToIndex(a);if(g){for(;g.next;)g=g.next;g.next=f}else this.tracks[a]=f;return 0>=e&&(g?e+=g.endTime-this.data.getMix(g.animation,b):e=0),f.delay=e,f},getCurrent:function(a){return a>=this.tracks.length?null:this.tracks[a]}},c.SkeletonJson=function(a){this.attachmentLoader=a},c.SkeletonJson.prototype={scale:1,readSkeletonData:function(a,b){var d=new c.SkeletonData;d.name=b;var e=a.skeleton;e&&(d.hash=e.hash,d.version=e.spine,d.width=e.width||0,d.height=e.height||0);for(var f=a.bones,g=0,h=f.length;h>g;g++){var i=f[g],j=null;if(i.parent&&(j=d.findBone(i.parent),!j))throw"Parent bone not found: "+i.parent;var k=new c.BoneData(i.name,j);

k.length=(i.length||0)*this.scale,k.x=(i.x||0)*this.scale,k.y=(i.y||0)*this.scale,k.rotation=i.rotation||0,k.scaleX=i.hasOwnProperty("scaleX")?i.scaleX:1,k.scaleY=i.hasOwnProperty("scaleY")?i.scaleY:1,k.inheritScale=i.hasOwnProperty("inheritScale")?i.inheritScale:!0,k.inheritRotation=i.hasOwnProperty("inheritRotation")?i.inheritRotation:!0,d.bones.push(k)}var l=a.ik;if(l)for(var g=0,h=l.length;h>g;g++){for(var m=l[g],n=new c.IkConstraintData(m.name),f=m.bones,o=0,p=f.length;p>o;o++){var q=d.findBone(f[o]);if(!q)throw"IK bone not found: "+f[o];n.bones.push(q)}if(n.target=d.findBone(m.target),!n.target)throw"Target bone not found: "+m.target;n.bendDirection=!m.hasOwnProperty("bendPositive")||m.bendPositive?1:-1,n.mix=m.hasOwnProperty("mix")?m.mix:1,d.ikConstraints.push(n)}for(var r=a.slots,g=0,h=r.length;h>g;g++){var s=r[g],k=d.findBone(s.bone);if(!k)throw"Slot bone not found: "+s.bone;var t=new c.SlotData(s.name,k),u=s.color;u&&(t.r=this.toColor(u,0),t.g=this.toColor(u,1),t.b=this.toColor(u,2),t.a=this.toColor(u,3)),t.attachmentName=s.attachment,t.additiveBlending=s.additive&&"true"==s.additive,d.slots.push(t)}var v=a.skins;for(var w in v)if(v.hasOwnProperty(w)){var x=v[w],y=new c.Skin(w);for(var z in x)if(x.hasOwnProperty(z)){var A=d.findSlotIndex(z),B=x[z];for(var C in B)if(B.hasOwnProperty(C)){var D=this.readAttachment(y,C,B[C]);D&&y.addAttachment(A,C,D)}}d.skins.push(y),"default"==y.name&&(d.defaultSkin=y)}var E=a.events;for(var F in E)if(E.hasOwnProperty(F)){var G=E[F],H=new c.EventData(F);H.intValue=G["int"]||0,H.floatValue=G["float"]||0,H.stringValue=G.string||null,d.events.push(H)}var I=a.animations;for(var J in I)I.hasOwnProperty(J)&&this.readAnimation(J,I[J],d);return d},readAttachment:function(a,b,d){b=d.name||b;var e=c.AttachmentType[d.type||"region"],f=d.path||b,g=this.scale;if(e==c.AttachmentType.region){var h=this.attachmentLoader.newRegionAttachment(a,b,f);if(!h)return null;h.path=f,h.x=(d.x||0)*g,h.y=(d.y||0)*g,h.scaleX=d.hasOwnProperty("scaleX")?d.scaleX:1,h.scaleY=d.hasOwnProperty("scaleY")?d.scaleY:1,h.rotation=d.rotation||0,h.width=(d.width||0)*g,h.height=(d.height||0)*g;var i=d.color;return i&&(h.r=this.toColor(i,0),h.g=this.toColor(i,1),h.b=this.toColor(i,2),h.a=this.toColor(i,3)),h.updateOffset(),h}if(e==c.AttachmentType.mesh){var j=this.attachmentLoader.newMeshAttachment(a,b,f);return j?(j.path=f,j.vertices=this.getFloatArray(d,"vertices",g),j.triangles=this.getIntArray(d,"triangles"),j.regionUVs=this.getFloatArray(d,"uvs",1),j.updateUVs(),i=d.color,i&&(j.r=this.toColor(i,0),j.g=this.toColor(i,1),j.b=this.toColor(i,2),j.a=this.toColor(i,3)),j.hullLength=2*(d.hull||0),d.edges&&(j.edges=this.getIntArray(d,"edges")),j.width=(d.width||0)*g,j.height=(d.height||0)*g,j):null}if(e==c.AttachmentType.skinnedmesh){var j=this.attachmentLoader.newSkinnedMeshAttachment(a,b,f);if(!j)return null;j.path=f;for(var k=this.getFloatArray(d,"uvs",1),l=this.getFloatArray(d,"vertices",1),m=[],n=[],o=0,p=l.length;p>o;){var q=0|l[o++];n[n.length]=q;for(var r=o+4*q;r>o;)n[n.length]=l[o],m[m.length]=l[o+1]*g,m[m.length]=l[o+2]*g,m[m.length]=l[o+3],o+=4}return j.bones=n,j.weights=m,j.triangles=this.getIntArray(d,"triangles"),j.regionUVs=k,j.updateUVs(),i=d.color,i&&(j.r=this.toColor(i,0),j.g=this.toColor(i,1),j.b=this.toColor(i,2),j.a=this.toColor(i,3)),j.hullLength=2*(d.hull||0),d.edges&&(j.edges=this.getIntArray(d,"edges")),j.width=(d.width||0)*g,j.height=(d.height||0)*g,j}if(e==c.AttachmentType.boundingbox){for(var s=this.attachmentLoader.newBoundingBoxAttachment(a,b),l=d.vertices,o=0,p=l.length;p>o;o++)s.vertices.push(l[o]*g);return s}throw"Unknown attachment type: "+e},readAnimation:function(a,b,d){var e=[],f=0,g=b.slots;for(var h in g)if(g.hasOwnProperty(h)){var i=g[h],j=d.findSlotIndex(h);for(var k in i)if(i.hasOwnProperty(k)){var l=i[k];if("color"==k){var m=new c.ColorTimeline(l.length);m.slotIndex=j;for(var n=0,o=0,p=l.length;p>o;o++){var q=l[o],r=q.color,s=this.toColor(r,0),t=this.toColor(r,1),u=this.toColor(r,2),v=this.toColor(r,3);m.setFrame(n,q.time,s,t,u,v),this.readCurve(m,n,q),n++}e.push(m),f=Math.max(f,m.frames[5*m.getFrameCount()-5])}else{if("attachment"!=k)throw"Invalid timeline type for a slot: "+k+" ("+h+")";var m=new c.AttachmentTimeline(l.length);m.slotIndex=j;for(var n=0,o=0,p=l.length;p>o;o++){var q=l[o];m.setFrame(n++,q.time,q.name)}e.push(m),f=Math.max(f,m.frames[m.getFrameCount()-1])}}}var w=b.bones;for(var x in w)if(w.hasOwnProperty(x)){var y=d.findBoneIndex(x);if(-1==y)throw"Bone not found: "+x;var z=w[x];for(var k in z)if(z.hasOwnProperty(k)){var l=z[k];if("rotate"==k){var m=new c.RotateTimeline(l.length);m.boneIndex=y;for(var n=0,o=0,p=l.length;p>o;o++){var q=l[o];m.setFrame(n,q.time,q.angle),this.readCurve(m,n,q),n++}e.push(m),f=Math.max(f,m.frames[2*m.getFrameCount()-2])}else if("translate"==k||"scale"==k){var m,A=1;"scale"==k?m=new c.ScaleTimeline(l.length):(m=new c.TranslateTimeline(l.length),A=this.scale),m.boneIndex=y;for(var n=0,o=0,p=l.length;p>o;o++){var q=l[o],B=(q.x||0)*A,C=(q.y||0)*A;m.setFrame(n,q.time,B,C),this.readCurve(m,n,q),n++}e.push(m),f=Math.max(f,m.frames[3*m.getFrameCount()-3])}else{if("flipX"!=k&&"flipY"!=k)throw"Invalid timeline type for a bone: "+k+" ("+x+")";var B="flipX"==k,m=B?new c.FlipXTimeline(l.length):new c.FlipYTimeline(l.length);m.boneIndex=y;for(var D=B?"x":"y",n=0,o=0,p=l.length;p>o;o++){var q=l[o];m.setFrame(n,q.time,q[D]||!1),n++}e.push(m),f=Math.max(f,m.frames[2*m.getFrameCount()-2])}}}var E=b.ik;for(var F in E)if(E.hasOwnProperty(F)){var G=d.findIkConstraint(F),l=E[F],m=new c.IkConstraintTimeline(l.length);m.ikConstraintIndex=d.ikConstraints.indexOf(G);for(var n=0,o=0,p=l.length;p>o;o++){var q=l[o],H=q.hasOwnProperty("mix")?q.mix:1,I=!q.hasOwnProperty("bendPositive")||q.bendPositive?1:-1;m.setFrame(n,q.time,H,I),this.readCurve(m,n,q),n++}e.push(m),f=Math.max(f,m.frames[3*m.getFrameCount()-3])}var J=b.ffd;for(var K in J){var L=d.findSkin(K),i=J[K];for(h in i){var j=d.findSlotIndex(h),M=i[h];for(var N in M){var l=M[N],m=new c.FfdTimeline(l.length),O=L.getAttachment(j,N);if(!O)throw"FFD attachment not found: "+N;m.slotIndex=j,m.attachment=O;var P,Q=O.type==c.AttachmentType.mesh;P=Q?O.vertices.length:O.weights.length/3*2;for(var n=0,o=0,p=l.length;p>o;o++){var R,q=l[o];if(q.vertices){var S=q.vertices,R=[];R.length=P;var T=q.offset||0,U=S.length;if(1==this.scale)for(var V=0;U>V;V++)R[V+T]=S[V];else for(var V=0;U>V;V++)R[V+T]=S[V]*this.scale;if(Q)for(var W=O.vertices,V=0,U=R.length;U>V;V++)R[V]+=W[V]}else Q?R=O.vertices:(R=[],R.length=P);m.setFrame(n,q.time,R),this.readCurve(m,n,q),n++}e[e.length]=m,f=Math.max(f,m.frames[m.getFrameCount()-1])}}}var X=b.drawOrder;if(X||(X=b.draworder),X){for(var m=new c.DrawOrderTimeline(X.length),Y=d.slots.length,n=0,o=0,p=X.length;p>o;o++){var Z=X[o],$=null;if(Z.offsets){$=[],$.length=Y;for(var V=Y-1;V>=0;V--)$[V]=-1;var _=Z.offsets,aa=[];aa.length=Y-_.length;for(var ba=0,ca=0,V=0,U=_.length;U>V;V++){var da=_[V],j=d.findSlotIndex(da.slot);if(-1==j)throw"Slot not found: "+da.slot;for(;ba!=j;)aa[ca++]=ba++;$[ba+da.offset]=ba++}for(;Y>ba;)aa[ca++]=ba++;for(var V=Y-1;V>=0;V--)-1==$[V]&&($[V]=aa[--ca])}m.setFrame(n++,Z.time,$)}e.push(m),f=Math.max(f,m.frames[m.getFrameCount()-1])}var ea=b.events;if(ea){for(var m=new c.EventTimeline(ea.length),n=0,o=0,p=ea.length;p>o;o++){var fa=ea[o],ga=d.findEvent(fa.name);if(!ga)throw"Event not found: "+fa.name;var ha=new c.Event(ga);ha.intValue=fa.hasOwnProperty("int")?fa["int"]:ga.intValue,ha.floatValue=fa.hasOwnProperty("float")?fa["float"]:ga.floatValue,ha.stringValue=fa.hasOwnProperty("string")?fa.string:ga.stringValue,m.setFrame(n++,fa.time,ha)}e.push(m),f=Math.max(f,m.frames[m.getFrameCount()-1])}d.animations.push(new c.Animation(a,e,f))},readCurve:function(a,b,c){var d=c.curve;d?"stepped"==d?a.curves.setStepped(b):d instanceof Array&&a.curves.setCurve(b,d[0],d[1],d[2],d[3]):a.curves.setLinear(b)},toColor:function(a,b){if(8!=a.length)throw"Color hexidecimal length must be 8, recieved: "+a;return parseInt(a.substring(2*b,2*b+2),16)/255},getFloatArray:function(a,b,d){var e=a[b],f=new c.Float32Array(e.length),g=0,h=e.length;if(1==d)for(;h>g;g++)f[g]=e[g];else for(;h>g;g++)f[g]=e[g]*d;return f},getIntArray:function(a,b){for(var d=a[b],e=new c.Uint16Array(d.length),f=0,g=d.length;g>f;f++)e[f]=0|d[f];return e}},c.Atlas=function(a,b){this.textureLoader=b,this.pages=[],this.regions=[];var d=new c.AtlasReader(a),e=[];e.length=4;for(var f=null;;){var g=d.readLine();if(null===g)break;if(g=d.trim(g),g.length)if(f){var h=new c.AtlasRegion;h.name=g,h.page=f,h.rotate="true"==d.readValue(),d.readTuple(e);var i=parseInt(e[0]),j=parseInt(e[1]);d.readTuple(e);var k=parseInt(e[0]),l=parseInt(e[1]);h.u=i/f.width,h.v=j/f.height,h.rotate?(h.u2=(i+l)/f.width,h.v2=(j+k)/f.height):(h.u2=(i+k)/f.width,h.v2=(j+l)/f.height),h.x=i,h.y=j,h.width=Math.abs(k),h.height=Math.abs(l),4==d.readTuple(e)&&(h.splits=[parseInt(e[0]),parseInt(e[1]),parseInt(e[2]),parseInt(e[3])],4==d.readTuple(e)&&(h.pads=[parseInt(e[0]),parseInt(e[1]),parseInt(e[2]),parseInt(e[3])],d.readTuple(e))),h.originalWidth=parseInt(e[0]),h.originalHeight=parseInt(e[1]),d.readTuple(e),h.offsetX=parseInt(e[0]),h.offsetY=parseInt(e[1]),h.index=parseInt(d.readValue()),this.regions.push(h)}else{f=new c.AtlasPage,f.name=g,2==d.readTuple(e)&&(f.width=parseInt(e[0]),f.height=parseInt(e[1]),d.readTuple(e)),f.format=c.Atlas.Format[e[0]],d.readTuple(e),f.minFilter=c.Atlas.TextureFilter[e[0]],f.magFilter=c.Atlas.TextureFilter[e[1]];var m=d.readValue();f.uWrap=c.Atlas.TextureWrap.clampToEdge,f.vWrap=c.Atlas.TextureWrap.clampToEdge,"x"==m?f.uWrap=c.Atlas.TextureWrap.repeat:"y"==m?f.vWrap=c.Atlas.TextureWrap.repeat:"xy"==m&&(f.uWrap=f.vWrap=c.Atlas.TextureWrap.repeat),b.load(f,g,this),this.pages.push(f)}else f=null}},c.Atlas.prototype={findRegion:function(a){for(var b=this.regions,c=0,d=b.length;d>c;c++)if(b[c].name==a)return b[c];return null},dispose:function(){for(var a=this.pages,b=0,c=a.length;c>b;b++)this.textureLoader.unload(a[b].rendererObject)},updateUVs:function(a){for(var b=this.regions,c=0,d=b.length;d>c;c++){var e=b[c];e.page==a&&(e.u=e.x/a.width,e.v=e.y/a.height,e.rotate?(e.u2=(e.x+e.height)/a.width,e.v2=(e.y+e.width)/a.height):(e.u2=(e.x+e.width)/a.width,e.v2=(e.y+e.height)/a.height))}}},c.Atlas.Format={alpha:0,intensity:1,luminanceAlpha:2,rgb565:3,rgba4444:4,rgb888:5,rgba8888:6},c.Atlas.TextureFilter={nearest:0,linear:1,mipMap:2,mipMapNearestNearest:3,mipMapLinearNearest:4,mipMapNearestLinear:5,mipMapLinearLinear:6},c.Atlas.TextureWrap={mirroredRepeat:0,clampToEdge:1,repeat:2},c.AtlasPage=function(){},c.AtlasPage.prototype={name:null,format:null,minFilter:null,magFilter:null,uWrap:null,vWrap:null,rendererObject:null,width:0,height:0},c.AtlasRegion=function(){},c.AtlasRegion.prototype={page:null,name:null,x:0,y:0,width:0,height:0,u:0,v:0,u2:0,v2:0,offsetX:0,offsetY:0,originalWidth:0,originalHeight:0,index:0,rotate:!1,splits:null,pads:null},c.AtlasReader=function(a){this.lines=a.split(/\r\n|\r|\n/)},c.AtlasReader.prototype={index:0,trim:function(a){return a.replace(/^\s+|\s+$/g,"")},readLine:function(){return this.index>=this.lines.length?null:this.lines[this.index++]},readValue:function(){var a=this.readLine(),b=a.indexOf(":");if(-1==b)throw"Invalid line: "+a;return this.trim(a.substring(b+1))},readTuple:function(a){var b=this.readLine(),c=b.indexOf(":");if(-1==c)throw"Invalid line: "+b;for(var d=0,e=c+1;3>d;d++){var f=b.indexOf(",",e);if(-1==f)break;a[d]=this.trim(b.substr(e,f-e)),e=f+1}return a[d]=this.trim(b.substring(e)),d+1}},c.AtlasAttachmentLoader=function(a){this.atlas=a},c.AtlasAttachmentLoader.prototype={newRegionAttachment:function(a,b,d){var e=this.atlas.findRegion(d);if(!e)throw"Region not found in atlas: "+d+" (region attachment: "+b+")";var f=new c.RegionAttachment(b);return f.rendererObject=e,f.setUVs(e.u,e.v,e.u2,e.v2,e.rotate),f.regionOffsetX=e.offsetX,f.regionOffsetY=e.offsetY,f.regionWidth=e.width,f.regionHeight=e.height,f.regionOriginalWidth=e.originalWidth,f.regionOriginalHeight=e.originalHeight,f},newMeshAttachment:function(a,b,d){var e=this.atlas.findRegion(d);if(!e)throw"Region not found in atlas: "+d+" (mesh attachment: "+b+")";var f=new c.MeshAttachment(b);return f.rendererObject=e,f.regionU=e.u,f.regionV=e.v,f.regionU2=e.u2,f.regionV2=e.v2,f.regionRotate=e.rotate,f.regionOffsetX=e.offsetX,f.regionOffsetY=e.offsetY,f.regionWidth=e.width,f.regionHeight=e.height,f.regionOriginalWidth=e.originalWidth,f.regionOriginalHeight=e.originalHeight,f},newSkinnedMeshAttachment:function(a,b,d){var e=this.atlas.findRegion(d);if(!e)throw"Region not found in atlas: "+d+" (skinned mesh attachment: "+b+")";var f=new c.SkinnedMeshAttachment(b);return f.rendererObject=e,f.regionU=e.u,f.regionV=e.v,f.regionU2=e.u2,f.regionV2=e.v2,f.regionRotate=e.rotate,f.regionOffsetX=e.offsetX,f.regionOffsetY=e.offsetY,f.regionWidth=e.width,f.regionHeight=e.height,f.regionOriginalWidth=e.originalWidth,f.regionOriginalHeight=e.originalHeight,f},newBoundingBoxAttachment:function(a,b){return new c.BoundingBoxAttachment(b)}},c.SkeletonBounds=function(){this.polygonPool=[],this.polygons=[],this.boundingBoxes=[]},c.SkeletonBounds.prototype={minX:0,minY:0,maxX:0,maxY:0,update:function(a,b){var d=a.slots,e=d.length,f=a.x,g=a.y,h=this.boundingBoxes,i=this.polygonPool,j=this.polygons;h.length=0;for(var k=0,l=j.length;l>k;k++)i.push(j[k]);j.length=0;for(var k=0;e>k;k++){var m=d[k],n=m.attachment;if(n.type==c.AttachmentType.boundingbox){h.push(n);var o,p=i.length;p>0?(o=i[p-1],i.splice(p-1,1)):o=[],j.push(o),o.length=n.vertices.length,n.computeWorldVertices(f,g,m.bone,o)}}b&&this.aabbCompute()},aabbCompute:function(){for(var a=this.polygons,b=Number.MAX_VALUE,c=Number.MAX_VALUE,d=Number.MIN_VALUE,e=Number.MIN_VALUE,f=0,g=a.length;g>f;f++)for(var h=a[f],i=0,j=h.length;j>i;i+=2){var k=h[i],l=h[i+1];b=Math.min(b,k),c=Math.min(c,l),d=Math.max(d,k),e=Math.max(e,l)}this.minX=b,this.minY=c,this.maxX=d,this.maxY=e},aabbContainsPoint:function(a,b){return a>=this.minX&&a<=this.maxX&&b>=this.minY&&b<=this.maxY},aabbIntersectsSegment:function(a,b,c,d){var e=this.minX,f=this.minY,g=this.maxX,h=this.maxY;if(e>=a&&e>=c||f>=b&&f>=d||a>=g&&c>=g||b>=h&&d>=h)return!1;var i=(d-b)/(c-a),j=i*(e-a)+b;if(j>f&&h>j)return!0;if(j=i*(g-a)+b,j>f&&h>j)return!0;var k=(f-b)/i+a;return k>e&&g>k?!0:(k=(h-b)/i+a,k>e&&g>k?!0:!1)},aabbIntersectsSkeleton:function(a){return this.minX<a.maxX&&this.maxX>a.minX&&this.minY<a.maxY&&this.maxY>a.minY},containsPoint:function(a,b){for(var c=this.polygons,d=0,e=c.length;e>d;d++)if(this.polygonContainsPoint(c[d],a,b))return this.boundingBoxes[d];return null},intersectsSegment:function(a,b,c,d){for(var e=this.polygons,f=0,g=e.length;g>f;f++)if(e[f].intersectsSegment(a,b,c,d))return this.boundingBoxes[f];return null},polygonContainsPoint:function(a,b,c){for(var d=a.length,e=d-2,f=!1,g=0;d>g;g+=2){var h=a[g+1],i=a[e+1];if(c>h&&i>=c||c>i&&h>=c){var j=a[g];j+(c-h)/(i-h)*(a[e]-j)<b&&(f=!f)}e=g}return f},polygonIntersectsSegment:function(a,b,c,d,e){for(var f=a.length,g=b-d,h=c-e,i=b*e-c*d,j=a[f-2],k=a[f-1],l=0;f>l;l+=2){var m=a[l],n=a[l+1],o=j*n-k*m,p=j-m,q=k-n,r=g*q-h*p,s=(i*p-g*o)/r;if((s>=j&&m>=s||s>=m&&j>=s)&&(s>=b&&d>=s||s>=d&&b>=s)){var t=(i*q-h*o)/r;if((t>=k&&n>=t||t>=n&&k>=t)&&(t>=c&&e>=t||t>=e&&c>=t))return!0}j=m,k=n}return!1},getPolygon:function(a){var b=this.boundingBoxes.indexOf(a);return-1==b?null:this.polygons[b]},getWidth:function(){return this.maxX-this.minX},getHeight:function(){return this.maxY-this.minY}},c.Bone.yDown=!0,b.AnimCache={},b.SpineTextureLoader=function(a,c){b.EventTarget.call(this),this.basePath=a,this.crossorigin=c,this.loadingCount=0},b.SpineTextureLoader.prototype=b.SpineTextureLoader,b.SpineTextureLoader.prototype.load=function(a,c){if(a.rendererObject=b.BaseTexture.fromImage(this.basePath+"/"+c,this.crossorigin),!a.rendererObject.hasLoaded){var d=this;++d.loadingCount,a.rendererObject.addEventListener("loaded",function(){--d.loadingCount,d.dispatchEvent({type:"loadedBaseTexture",content:d})})}},b.SpineTextureLoader.prototype.unload=function(a){a.destroy(!0)},b.Spine=function(a){if(b.DisplayObjectContainer.call(this),this.spineData=b.AnimCache[a],!this.spineData)throw new Error("Spine data must be preloaded using PIXI.SpineLoader or PIXI.AssetLoader: "+a);this.skeleton=new c.Skeleton(this.spineData),this.skeleton.updateWorldTransform(),this.stateData=new c.AnimationStateData(this.spineData),this.state=new c.AnimationState(this.stateData),this.slotContainers=[];for(var d=0,e=this.skeleton.slots.length;e>d;d++){var f=this.skeleton.slots[d],g=f.attachment,h=new b.DisplayObjectContainer;if(this.slotContainers.push(h),this.addChild(h),g instanceof c.RegionAttachment){var i=g.rendererObject.name,j=this.createSprite(f,g);f.currentSprite=j,f.currentSpriteName=i,h.addChild(j)}else{if(!(g instanceof c.MeshAttachment))continue;var k=this.createMesh(f,g);f.currentMesh=k,f.currentMeshName=g.name,h.addChild(k)}}this.autoUpdate=!0},b.Spine.prototype=Object.create(b.DisplayObjectContainer.prototype),b.Spine.prototype.constructor=b.Spine,Object.defineProperty(b.Spine.prototype,"autoUpdate",{get:function(){return this.updateTransform===b.Spine.prototype.autoUpdateTransform},set:function(a){this.updateTransform=a?b.Spine.prototype.autoUpdateTransform:b.DisplayObjectContainer.prototype.updateTransform}}),b.Spine.prototype.update=function(a){this.state.update(a),this.state.apply(this.skeleton),this.skeleton.updateWorldTransform();for(var d=this.skeleton.drawOrder,e=this.skeleton.slots,f=0,g=d.length;g>f;f++)this.children[f]=this.slotContainers[d[f]];for(f=0,g=e.length;g>f;f++){var h=e[f],i=h.attachment,j=this.slotContainers[f];if(i){var k=i.type;if(k===c.AttachmentType.region){if(i.rendererObject&&(!h.currentSpriteName||h.currentSpriteName!==i.name)){var l=i.rendererObject.name;if(void 0!==h.currentSprite&&(h.currentSprite.visible=!1),h.sprites=h.sprites||{},void 0!==h.sprites[l])h.sprites[l].visible=!0;else{var m=this.createSprite(h,i);j.addChild(m)}h.currentSprite=h.sprites[l],h.currentSpriteName=l}var n=h.bone;j.position.x=n.worldX+i.x*n.m00+i.y*n.m01,j.position.y=n.worldY+i.x*n.m10+i.y*n.m11,j.scale.x=n.worldScaleX,j.scale.y=n.worldScaleY,j.rotation=-(h.bone.worldRotation*c.degRad),h.currentSprite.tint=b.rgb2hex([h.r,h.g,h.b])}else{if(k!==c.AttachmentType.skinnedmesh){j.visible=!1;continue}if(!h.currentMeshName||h.currentMeshName!==i.name){var o=i.name;if(void 0!==h.currentMesh&&(h.currentMesh.visible=!1),h.meshes=h.meshes||{},void 0!==h.meshes[o])h.meshes[o].visible=!0;else{var p=this.createMesh(h,i);j.addChild(p)}h.currentMesh=h.meshes[o],h.currentMeshName=o}i.computeWorldVertices(h.bone.skeleton.x,h.bone.skeleton.y,h,h.currentMesh.vertices)}j.visible=!0,j.alpha=h.a}else j.visible=!1}},b.Spine.prototype.autoUpdateTransform=function(){this.lastTime=this.lastTime||Date.now();var a=.001*(Date.now()-this.lastTime);this.lastTime=Date.now(),this.update(a),b.DisplayObjectContainer.prototype.updateTransform.call(this)},b.Spine.prototype.createSprite=function(a,d){var e=d.rendererObject,f=e.page.rendererObject,g=new b.Rectangle(e.x,e.y,e.rotate?e.height:e.width,e.rotate?e.width:e.height),h=new b.Texture(f,g),i=new b.Sprite(h),j=e.rotate?.5*Math.PI:0;return i.scale.set(e.width/e.originalWidth*d.scaleX,e.height/e.originalHeight*d.scaleY),i.rotation=j-d.rotation*c.degRad,i.anchor.x=i.anchor.y=.5,i.alpha=d.a,a.sprites=a.sprites||{},a.sprites[e.name]=i,i},b.Spine.prototype.createMesh=function(a,c){var d=c.rendererObject,e=d.page.rendererObject,f=new b.Texture(e),g=new b.Strip(f);return g.drawMode=b.Strip.DrawModes.TRIANGLES,g.canvasPadding=1.5,g.vertices=new b.Float32Array(c.uvs.length),g.uvs=c.uvs,g.indices=c.triangles,g.alpha=c.a,a.meshes=a.meshes||{},a.meshes[c.name]=g,g},b.BaseTextureCache={},b.BaseTextureCacheIdGenerator=0,b.BaseTexture=function(a,c){if(this.resolution=1,this.width=100,this.height=100,this.scaleMode=c||b.scaleModes.DEFAULT,this.hasLoaded=!1,this.source=a,this._UID=b._UID++,this.premultipliedAlpha=!0,this._glTextures=[],this.mipmap=!1,this._dirty=[!0,!0,!0,!0],a){if((this.source.complete||this.source.getContext)&&this.source.width&&this.source.height)this.hasLoaded=!0,this.width=this.source.naturalWidth||this.source.width,this.height=this.source.naturalHeight||this.source.height,this.dirty();else{var d=this;this.source.onload=function(){d.hasLoaded=!0,d.width=d.source.naturalWidth||d.source.width,d.height=d.source.naturalHeight||d.source.height,d.dirty(),d.dispatchEvent({type:"loaded",content:d})},this.source.onerror=function(){d.dispatchEvent({type:"error",content:d})}}this.imageUrl=null,this._powerOf2=!1}},b.BaseTexture.prototype.constructor=b.BaseTexture,b.EventTarget.mixin(b.BaseTexture.prototype),b.BaseTexture.prototype.destroy=function(){this.imageUrl?(delete b.BaseTextureCache[this.imageUrl],delete b.TextureCache[this.imageUrl],this.imageUrl=null,navigator.isCocoonJS||(this.source.src="")):this.source&&this.source._pixiId&&delete b.BaseTextureCache[this.source._pixiId],this.source=null,this.unloadFromGPU()},b.BaseTexture.prototype.updateSourceImage=function(a){this.hasLoaded=!1,this.source.src=null,this.source.src=a},b.BaseTexture.prototype.dirty=function(){for(var a=0;a<this._glTextures.length;a++)this._dirty[a]=!0},b.BaseTexture.prototype.unloadFromGPU=function(){this.dirty();for(var a=this._glTextures.length-1;a>=0;a--){var c=this._glTextures[a],d=b.glContexts[a];d&&c&&d.deleteTexture(c)}this._glTextures.length=0,this.dirty()},b.BaseTexture.fromImage=function(a,c,d){var e=b.BaseTextureCache[a];if(void 0===c&&-1===a.indexOf("data:")&&(c=!0),!e){var f=new Image;c&&(f.crossOrigin=""),f.src=a,e=new b.BaseTexture(f,d),e.imageUrl=a,b.BaseTextureCache[a]=e,-1!==a.indexOf(b.RETINA_PREFIX+".")&&(e.resolution=2)}return e},b.BaseTexture.fromCanvas=function(a,c){a._pixiId||(a._pixiId="canvas_"+b.TextureCacheIdGenerator++);var d=b.BaseTextureCache[a._pixiId];return d||(d=new b.BaseTexture(a,c),b.BaseTextureCache[a._pixiId]=d),d},b.TextureCache={},b.FrameCache={},b.TextureCacheIdGenerator=0,b.Texture=function(a,c,d,e){this.noFrame=!1,c||(this.noFrame=!0,c=new b.Rectangle(0,0,1,1)),a instanceof b.Texture&&(a=a.baseTexture),this.baseTexture=a,this.frame=c,this.trim=e,this.valid=!1,this.requiresUpdate=!1,this._uvs=null,this.width=0,this.height=0,this.crop=d||new b.Rectangle(0,0,1,1),a.hasLoaded?(this.noFrame&&(c=new b.Rectangle(0,0,a.width,a.height)),this.setFrame(c)):a.addEventListener("loaded",this.onBaseTextureLoaded.bind(this))},b.Texture.prototype.constructor=b.Texture,b.EventTarget.mixin(b.Texture.prototype),b.Texture.prototype.onBaseTextureLoaded=function(){var a=this.baseTexture;a.removeEventListener("loaded",this.onLoaded),this.noFrame&&(this.frame=new b.Rectangle(0,0,a.width,a.height)),this.setFrame(this.frame),this.dispatchEvent({type:"update",content:this})},b.Texture.prototype.destroy=function(a){a&&this.baseTexture.destroy(),this.valid=!1},b.Texture.prototype.setFrame=function(a){if(this.noFrame=!1,this.frame=a,this.width=a.width,this.height=a.height,this.crop.x=a.x,this.crop.y=a.y,this.crop.width=a.width,this.crop.height=a.height,!this.trim&&(a.x+a.width>this.baseTexture.width||a.y+a.height>this.baseTexture.height))throw new Error("Texture Error: frame does not fit inside the base Texture dimensions "+this);this.valid=a&&a.width&&a.height&&this.baseTexture.source&&this.baseTexture.hasLoaded,this.trim&&(this.width=this.trim.width,this.height=this.trim.height,this.frame.width=this.trim.width,this.frame.height=this.trim.height),this.valid&&this._updateUvs()},b.Texture.prototype._updateUvs=function(){this._uvs||(this._uvs=new b.TextureUvs);var a=this.crop,c=this.baseTexture.width,d=this.baseTexture.height;this._uvs.x0=a.x/c,this._uvs.y0=a.y/d,this._uvs.x1=(a.x+a.width)/c,this._uvs.y1=a.y/d,this._uvs.x2=(a.x+a.width)/c,this._uvs.y2=(a.y+a.height)/d,this._uvs.x3=a.x/c,this._uvs.y3=(a.y+a.height)/d},b.Texture.fromImage=function(a,c,d){var e=b.TextureCache[a];return e||(e=new b.Texture(b.BaseTexture.fromImage(a,c,d)),b.TextureCache[a]=e),e},b.Texture.fromFrame=function(a){var c=b.TextureCache[a];if(!c)throw new Error('The frameId "'+a+'" does not exist in the texture cache ');return c},b.Texture.fromCanvas=function(a,c){var d=b.BaseTexture.fromCanvas(a,c);return new b.Texture(d)},b.Texture.addTextureToCache=function(a,c){b.TextureCache[c]=a},b.Texture.removeTextureFromCache=function(a){var c=b.TextureCache[a];return delete b.TextureCache[a],delete b.BaseTextureCache[a],c},b.TextureUvs=function(){this.x0=0,this.y0=0,this.x1=0,this.y1=0,this.x2=0,this.y2=0,this.x3=0,this.y3=0},b.Texture.emptyTexture=new b.Texture(new b.BaseTexture),b.RenderTexture=function(a,c,d,e,f){if(this.width=a||100,this.height=c||100,this.resolution=f||1,this.frame=new b.Rectangle(0,0,this.width*this.resolution,this.height*this.resolution),this.crop=new b.Rectangle(0,0,this.width*this.resolution,this.height*this.resolution),this.baseTexture=new b.BaseTexture,this.baseTexture.width=this.width*this.resolution,this.baseTexture.height=this.height*this.resolution,this.baseTexture._glTextures=[],this.baseTexture.resolution=this.resolution,this.baseTexture.scaleMode=e||b.scaleModes.DEFAULT,this.baseTexture.hasLoaded=!0,b.Texture.call(this,this.baseTexture,new b.Rectangle(0,0,this.width*this.resolution,this.height*this.resolution)),this.renderer=d||b.defaultRenderer,this.renderer.type===b.WEBGL_RENDERER){var g=this.renderer.gl;this.baseTexture._dirty[g.id]=!1,this.textureBuffer=new b.FilterTexture(g,this.width,this.height,this.baseTexture.scaleMode),this.baseTexture._glTextures[g.id]=this.textureBuffer.texture,this.render=this.renderWebGL,this.projection=new b.Point(.5*this.width,.5*-this.height)}else this.render=this.renderCanvas,this.textureBuffer=new b.CanvasBuffer(this.width*this.resolution,this.height*this.resolution),this.baseTexture.source=this.textureBuffer.canvas;this.valid=!0,this._updateUvs()},b.RenderTexture.prototype=Object.create(b.Texture.prototype),b.RenderTexture.prototype.constructor=b.RenderTexture,b.RenderTexture.prototype.resize=function(a,c,d){(a!==this.width||c!==this.height)&&(this.valid=a>0&&c>0,this.width=a,this.height=c,this.frame.width=this.crop.width=a*this.resolution,this.frame.height=this.crop.height=c*this.resolution,d&&(this.baseTexture.width=this.width*this.resolution,this.baseTexture.height=this.height*this.resolution),this.renderer.type===b.WEBGL_RENDERER&&(this.projection.x=this.width/2,this.projection.y=-this.height/2),this.valid&&this.textureBuffer.resize(this.width,this.height))},b.RenderTexture.prototype.clear=function(){this.valid&&(this.renderer.type===b.WEBGL_RENDERER&&this.renderer.gl.bindFramebuffer(this.renderer.gl.FRAMEBUFFER,this.textureBuffer.frameBuffer),this.textureBuffer.clear())},b.RenderTexture.prototype.renderWebGL=function(a,b,c){if(this.valid){var d=a.worldTransform;d.identity(),d.translate(0,2*this.projection.y),b&&d.append(b),d.scale(1,-1),a.worldAlpha=1;for(var e=a.children,f=0,g=e.length;g>f;f++)e[f].updateTransform();var h=this.renderer.gl;h.viewport(0,0,this.width*this.resolution,this.height*this.resolution),h.bindFramebuffer(h.FRAMEBUFFER,this.textureBuffer.frameBuffer),c&&this.textureBuffer.clear(),this.renderer.spriteBatch.dirty=!0,this.renderer.renderDisplayObject(a,this.projection,this.textureBuffer.frameBuffer),this.renderer.spriteBatch.dirty=!0}},b.RenderTexture.prototype.renderCanvas=function(a,b,c){if(this.valid){var d=a.worldTransform;d.identity(),b&&d.append(b),a.worldAlpha=1;for(var e=a.children,f=0,g=e.length;g>f;f++)e[f].updateTransform();c&&this.textureBuffer.clear();var h=this.textureBuffer.context,i=this.renderer.resolution;this.renderer.resolution=this.resolution,this.renderer.renderDisplayObject(a,h),this.renderer.resolution=i}},b.RenderTexture.prototype.getImage=function(){var a=new Image;return a.src=this.getBase64(),a},b.RenderTexture.prototype.getBase64=function(){return this.getCanvas().toDataURL()},b.RenderTexture.prototype.getCanvas=function(){if(this.renderer.type===b.WEBGL_RENDERER){var a=this.renderer.gl,c=this.textureBuffer.width,d=this.textureBuffer.height,e=new Uint8Array(4*c*d);a.bindFramebuffer(a.FRAMEBUFFER,this.textureBuffer.frameBuffer),a.readPixels(0,0,c,d,a.RGBA,a.UNSIGNED_BYTE,e),a.bindFramebuffer(a.FRAMEBUFFER,null);var f=new b.CanvasBuffer(c,d),g=f.context.getImageData(0,0,c,d);return g.data.set(e),f.context.putImageData(g,0,0),f.canvas}return this.textureBuffer.canvas},b.RenderTexture.tempMatrix=new b.Matrix,b.VideoTexture=function(a,c){if(!a)throw new Error("No video source element specified.");(a.readyState===a.HAVE_ENOUGH_DATA||a.readyState===a.HAVE_FUTURE_DATA)&&a.width&&a.height&&(a.complete=!0),b.BaseTexture.call(this,a,c),this.autoUpdate=!1,this.updateBound=this._onUpdate.bind(this),a.complete||(this._onCanPlay=this.onCanPlay.bind(this),a.addEventListener("canplay",this._onCanPlay),a.addEventListener("canplaythrough",this._onCanPlay),a.addEventListener("play",this.onPlayStart.bind(this)),a.addEventListener("pause",this.onPlayStop.bind(this)))},b.VideoTexture.prototype=Object.create(b.BaseTexture.prototype),b.VideoTexture.constructor=b.VideoTexture,b.VideoTexture.prototype._onUpdate=function(){this.autoUpdate&&(window.requestAnimationFrame(this.updateBound),this.dirty())},b.VideoTexture.prototype.onPlayStart=function(){this.autoUpdate||(window.requestAnimationFrame(this.updateBound),this.autoUpdate=!0)},b.VideoTexture.prototype.onPlayStop=function(){this.autoUpdate=!1},b.VideoTexture.prototype.onCanPlay=function(){"canplaythrough"===event.type&&(this.hasLoaded=!0,this.source&&(this.source.removeEventListener("canplay",this._onCanPlay),this.source.removeEventListener("canplaythrough",this._onCanPlay),this.width=this.source.videoWidth,this.height=this.source.videoHeight,this.__loaded||(this.__loaded=!0,this.dispatchEvent({type:"loaded",content:this}))))},b.VideoTexture.prototype.destroy=function(){this.source&&this.source._pixiId&&(b.BaseTextureCache[this.source._pixiId]=null,delete b.BaseTextureCache[this.source._pixiId],this.source._pixiId=null,delete this.source._pixiId),b.BaseTexture.prototype.destroy.call(this)},b.VideoTexture.baseTextureFromVideo=function(a,c){a._pixiId||(a._pixiId="video_"+b.TextureCacheIdGenerator++);var d=b.BaseTextureCache[a._pixiId];return d||(d=new b.VideoTexture(a,c),b.BaseTextureCache[a._pixiId]=d),d},b.VideoTexture.textureFromVideo=function(a,c){var d=b.VideoTexture.baseTextureFromVideo(a,c);return new b.Texture(d)},b.VideoTexture.fromUrl=function(a,c){var d=document.createElement("video");return d.src=a,d.autoPlay=!0,d.play(),b.VideoTexture.textureFromVideo(d,c)},b.AssetLoader=function(a,c){this.assetURLs=a,this.crossorigin=c,this.loadersByType={jpg:b.ImageLoader,jpeg:b.ImageLoader,png:b.ImageLoader,gif:b.ImageLoader,webp:b.ImageLoader,json:b.JsonLoader,atlas:b.AtlasLoader,anim:b.SpineLoader,xml:b.BitmapFontLoader,fnt:b.BitmapFontLoader}},b.EventTarget.mixin(b.AssetLoader.prototype),b.AssetLoader.prototype.constructor=b.AssetLoader,b.AssetLoader.prototype._getDataType=function(a){var b="data:",c=a.slice(0,b.length).toLowerCase();if(c===b){var d=a.slice(b.length),e=d.indexOf(",");if(-1===e)return null;var f=d.slice(0,e).split(";")[0];return f&&"text/plain"!==f.toLowerCase()?f.split("/").pop().toLowerCase():"txt"}return null},b.AssetLoader.prototype.load=function(){function a(a){b.onAssetLoaded(a.data.content)}var b=this;this.loadCount=this.assetURLs.length;for(var c=0;c<this.assetURLs.length;c++){var d=this.assetURLs[c],e=this._getDataType(d);e||(e=d.split("?").shift().split(".").pop().toLowerCase());var f=this.loadersByType[e];if(!f)throw new Error(e+" is an unsupported file type");var g=new f(d,this.crossorigin);g.on("loaded",a),g.load()}},b.AssetLoader.prototype.onAssetLoaded=function(a){this.loadCount--,this.emit("onProgress",{content:this,loader:a,loaded:this.assetURLs.length-this.loadCount,total:this.assetURLs.length}),this.onProgress&&this.onProgress(a),this.loadCount||(this.emit("onComplete",{content:this}),this.onComplete&&this.onComplete())},b.JsonLoader=function(a,b){this.url=a,this.crossorigin=b,this.baseUrl=a.replace(/[^\/]*$/,""),
this.loaded=!1},b.JsonLoader.prototype.constructor=b.JsonLoader,b.EventTarget.mixin(b.JsonLoader.prototype),b.JsonLoader.prototype.load=function(){window.XDomainRequest&&this.crossorigin?(this.ajaxRequest=new window.XDomainRequest,this.ajaxRequest.timeout=3e3,this.ajaxRequest.onerror=this.onError.bind(this),this.ajaxRequest.ontimeout=this.onError.bind(this),this.ajaxRequest.onprogress=function(){},this.ajaxRequest.onload=this.onJSONLoaded.bind(this)):(this.ajaxRequest=window.XMLHttpRequest?new window.XMLHttpRequest:new window.ActiveXObject("Microsoft.XMLHTTP"),this.ajaxRequest.onreadystatechange=this.onReadyStateChanged.bind(this)),this.ajaxRequest.open("GET",this.url,!0),this.ajaxRequest.send()},b.JsonLoader.prototype.onReadyStateChanged=function(){4!==this.ajaxRequest.readyState||200!==this.ajaxRequest.status&&-1!==window.location.href.indexOf("http")||this.onJSONLoaded()},b.JsonLoader.prototype.onJSONLoaded=function(){if(!this.ajaxRequest.responseText)return void this.onError();if(this.json=JSON.parse(this.ajaxRequest.responseText),this.json.frames&&this.json.meta&&this.json.meta.image){var a=this.json.meta.image;-1===a.indexOf("data:")&&(a=this.baseUrl+a);var d=new b.ImageLoader(a,this.crossorigin),e=this.json.frames;this.texture=d.texture.baseTexture,d.addEventListener("loaded",this.onLoaded.bind(this));for(var f in e){var g=e[f].frame;if(g){var h=new b.Rectangle(g.x,g.y,g.w,g.h),i=h.clone(),j=null;if(e[f].trimmed){var k=e[f].sourceSize,l=e[f].spriteSourceSize;j=new b.Rectangle(l.x,l.y,k.w,k.h)}b.TextureCache[f]=new b.Texture(this.texture,h,i,j)}}d.load()}else if(this.json.bones)if(b.AnimCache[this.url])this.onLoaded();else{var m=this.url.substr(0,this.url.lastIndexOf("."))+".atlas",n=new b.JsonLoader(m,this.crossorigin),o=this;n.onJSONLoaded=function(){if(!this.ajaxRequest.responseText)return void this.onError();var a=new b.SpineTextureLoader(this.url.substring(0,this.url.lastIndexOf("/"))),d=new c.Atlas(this.ajaxRequest.responseText,a),e=new c.AtlasAttachmentLoader(d),f=new c.SkeletonJson(e),g=f.readSkeletonData(o.json);b.AnimCache[o.url]=g,o.spine=g,o.spineAtlas=d,o.spineAtlasLoader=n,a.loadingCount>0?a.addEventListener("loadedBaseTexture",function(a){a.content.content.loadingCount<=0&&o.onLoaded()}):o.onLoaded()},n.load()}else this.onLoaded()},b.JsonLoader.prototype.onLoaded=function(){this.loaded=!0,this.dispatchEvent({type:"loaded",content:this})},b.JsonLoader.prototype.onError=function(){this.dispatchEvent({type:"error",content:this})},b.AtlasLoader=function(a,b){this.url=a,this.baseUrl=a.replace(/[^\/]*$/,""),this.crossorigin=b,this.loaded=!1},b.AtlasLoader.constructor=b.AtlasLoader,b.EventTarget.mixin(b.AtlasLoader.prototype),b.AtlasLoader.prototype.load=function(){this.ajaxRequest=new b.AjaxRequest,this.ajaxRequest.onreadystatechange=this.onAtlasLoaded.bind(this),this.ajaxRequest.open("GET",this.url,!0),this.ajaxRequest.overrideMimeType&&this.ajaxRequest.overrideMimeType("application/json"),this.ajaxRequest.send(null)},b.AtlasLoader.prototype.onAtlasLoaded=function(){if(4===this.ajaxRequest.readyState)if(200===this.ajaxRequest.status||-1===window.location.href.indexOf("http")){this.atlas={meta:{image:[]},frames:[]};var a=this.ajaxRequest.responseText.split(/\r?\n/),c=-3,d=0,e=null,f=!1,g=0,h=0,i=this.onLoaded.bind(this);for(g=0;g<a.length;g++)if(a[g]=a[g].replace(/^\s+|\s+$/g,""),""===a[g]&&(f=g+1),a[g].length>0){if(f===g)this.atlas.meta.image.push(a[g]),d=this.atlas.meta.image.length-1,this.atlas.frames.push({}),c=-3;else if(c>0)if(c%7===1)null!=e&&(this.atlas.frames[d][e.name]=e),e={name:a[g],frame:{}};else{var j=a[g].split(" ");if(c%7===3)e.frame.x=Number(j[1].replace(",","")),e.frame.y=Number(j[2]);else if(c%7===4)e.frame.w=Number(j[1].replace(",","")),e.frame.h=Number(j[2]);else if(c%7===5){var k={x:0,y:0,w:Number(j[1].replace(",","")),h:Number(j[2])};k.w>e.frame.w||k.h>e.frame.h?(e.trimmed=!0,e.realSize=k):e.trimmed=!1}}c++}if(null!=e&&(this.atlas.frames[d][e.name]=e),this.atlas.meta.image.length>0){for(this.images=[],h=0;h<this.atlas.meta.image.length;h++){var l=this.baseUrl+this.atlas.meta.image[h],m=this.atlas.frames[h];this.images.push(new b.ImageLoader(l,this.crossorigin));for(g in m){var n=m[g].frame;n&&(b.TextureCache[g]=new b.Texture(this.images[h].texture.baseTexture,{x:n.x,y:n.y,width:n.w,height:n.h}),m[g].trimmed&&(b.TextureCache[g].realSize=m[g].realSize,b.TextureCache[g].trim.x=0,b.TextureCache[g].trim.y=0))}}for(this.currentImageId=0,h=0;h<this.images.length;h++)this.images[h].on("loaded",i);this.images[this.currentImageId].load()}else this.onLoaded()}else this.onError()},b.AtlasLoader.prototype.onLoaded=function(){this.images.length-1>this.currentImageId?(this.currentImageId++,this.images[this.currentImageId].load()):(this.loaded=!0,this.emit("loaded",{content:this}))},b.AtlasLoader.prototype.onError=function(){this.emit("error",{content:this})},b.SpriteSheetLoader=function(a,b){this.url=a,this.crossorigin=b,this.baseUrl=a.replace(/[^\/]*$/,""),this.texture=null,this.frames={}},b.SpriteSheetLoader.prototype.constructor=b.SpriteSheetLoader,b.EventTarget.mixin(b.SpriteSheetLoader.prototype),b.SpriteSheetLoader.prototype.load=function(){var a=this,c=new b.JsonLoader(this.url,this.crossorigin);c.on("loaded",function(b){a.json=b.data.content.json,a.onLoaded()}),c.load()},b.SpriteSheetLoader.prototype.onLoaded=function(){this.emit("loaded",{content:this})},b.ImageLoader=function(a,c){this.texture=b.Texture.fromImage(a,c),this.frames=[]},b.ImageLoader.prototype.constructor=b.ImageLoader,b.EventTarget.mixin(b.ImageLoader.prototype),b.ImageLoader.prototype.load=function(){this.texture.baseTexture.hasLoaded?this.onLoaded():this.texture.baseTexture.on("loaded",this.onLoaded.bind(this))},b.ImageLoader.prototype.onLoaded=function(){this.emit("loaded",{content:this})},b.ImageLoader.prototype.loadFramedSpriteSheet=function(a,c,d){this.frames=[];for(var e=Math.floor(this.texture.width/a),f=Math.floor(this.texture.height/c),g=0,h=0;f>h;h++)for(var i=0;e>i;i++,g++){var j=new b.Texture(this.texture.baseTexture,{x:i*a,y:h*c,width:a,height:c});this.frames.push(j),d&&(b.TextureCache[d+"-"+g]=j)}this.load()},b.BitmapFontLoader=function(a,b){this.url=a,this.crossorigin=b,this.baseUrl=a.replace(/[^\/]*$/,""),this.texture=null},b.BitmapFontLoader.prototype.constructor=b.BitmapFontLoader,b.EventTarget.mixin(b.BitmapFontLoader.prototype),b.BitmapFontLoader.prototype.load=function(){this.ajaxRequest=new b.AjaxRequest,this.ajaxRequest.onreadystatechange=this.onXMLLoaded.bind(this),this.ajaxRequest.open("GET",this.url,!0),this.ajaxRequest.overrideMimeType&&this.ajaxRequest.overrideMimeType("application/xml"),this.ajaxRequest.send(null)},b.BitmapFontLoader.prototype.onXMLLoaded=function(){if(4===this.ajaxRequest.readyState&&(200===this.ajaxRequest.status||-1===window.location.protocol.indexOf("http"))){var a=this.ajaxRequest.responseXML;if(!a||/MSIE 9/i.test(navigator.userAgent)||navigator.isCocoonJS)if("function"==typeof window.DOMParser){var c=new DOMParser;a=c.parseFromString(this.ajaxRequest.responseText,"text/xml")}else{var d=document.createElement("div");d.innerHTML=this.ajaxRequest.responseText,a=d}var e=this.baseUrl+a.getElementsByTagName("page")[0].getAttribute("file"),f=new b.ImageLoader(e,this.crossorigin);this.texture=f.texture.baseTexture;var g={},h=a.getElementsByTagName("info")[0],i=a.getElementsByTagName("common")[0];g.font=h.getAttribute("face"),g.size=parseInt(h.getAttribute("size"),10),g.lineHeight=parseInt(i.getAttribute("lineHeight"),10),g.chars={};for(var j=a.getElementsByTagName("char"),k=0;k<j.length;k++){var l=parseInt(j[k].getAttribute("id"),10),m=new b.Rectangle(parseInt(j[k].getAttribute("x"),10),parseInt(j[k].getAttribute("y"),10),parseInt(j[k].getAttribute("width"),10),parseInt(j[k].getAttribute("height"),10));g.chars[l]={xOffset:parseInt(j[k].getAttribute("xoffset"),10),yOffset:parseInt(j[k].getAttribute("yoffset"),10),xAdvance:parseInt(j[k].getAttribute("xadvance"),10),kerning:{},texture:b.TextureCache[l]=new b.Texture(this.texture,m)}}var n=a.getElementsByTagName("kerning");for(k=0;k<n.length;k++){var o=parseInt(n[k].getAttribute("first"),10),p=parseInt(n[k].getAttribute("second"),10),q=parseInt(n[k].getAttribute("amount"),10);g.chars[p].kerning[o]=q}b.BitmapText.fonts[g.font]=g,f.addEventListener("loaded",this.onLoaded.bind(this)),f.load()}},b.BitmapFontLoader.prototype.onLoaded=function(){this.emit("loaded",{content:this})},b.SpineLoader=function(a,b){this.url=a,this.crossorigin=b,this.loaded=!1},b.SpineLoader.prototype.constructor=b.SpineLoader,b.EventTarget.mixin(b.SpineLoader.prototype),b.SpineLoader.prototype.load=function(){var a=this,c=new b.JsonLoader(this.url,this.crossorigin);c.on("loaded",function(b){a.json=b.data.content.json,a.onLoaded()}),c.load()},b.SpineLoader.prototype.onLoaded=function(){this.loaded=!0,this.emit("loaded",{content:this})},b.AbstractFilter=function(a,b){this.passes=[this],this.shaders=[],this.dirty=!0,this.padding=0,this.uniforms=b||{},this.fragmentSrc=a||[]},b.AbstractFilter.prototype.constructor=b.AbstractFilter,b.AbstractFilter.prototype.syncUniforms=function(){for(var a=0,b=this.shaders.length;b>a;a++)this.shaders[a].dirty=!0},b.AlphaMaskFilter=function(a){b.AbstractFilter.call(this),this.passes=[this],a.baseTexture._powerOf2=!0,this.uniforms={mask:{type:"sampler2D",value:a},mapDimensions:{type:"2f",value:{x:1,y:5112}},dimensions:{type:"4fv",value:[0,0,0,0]}},a.baseTexture.hasLoaded?(this.uniforms.mask.value.x=a.width,this.uniforms.mask.value.y=a.height):(this.boundLoadedFunction=this.onTextureLoaded.bind(this),a.baseTexture.on("loaded",this.boundLoadedFunction)),this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform sampler2D mask;","uniform sampler2D uSampler;","uniform vec2 offset;","uniform vec4 dimensions;","uniform vec2 mapDimensions;","void main(void) {","   vec2 mapCords = vTextureCoord.xy;","   mapCords += (dimensions.zw + offset)/ dimensions.xy ;","   mapCords.y *= -1.0;","   mapCords.y += 1.0;","   mapCords *= dimensions.xy / mapDimensions;","   vec4 original =  texture2D(uSampler, vTextureCoord);","   float maskAlpha =  texture2D(mask, mapCords).r;","   original *= maskAlpha;","   gl_FragColor =  original;","}"]},b.AlphaMaskFilter.prototype=Object.create(b.AbstractFilter.prototype),b.AlphaMaskFilter.prototype.constructor=b.AlphaMaskFilter,b.AlphaMaskFilter.prototype.onTextureLoaded=function(){this.uniforms.mapDimensions.value.x=this.uniforms.mask.value.width,this.uniforms.mapDimensions.value.y=this.uniforms.mask.value.height,this.uniforms.mask.value.baseTexture.off("loaded",this.boundLoadedFunction)},Object.defineProperty(b.AlphaMaskFilter.prototype,"map",{get:function(){return this.uniforms.mask.value},set:function(a){this.uniforms.mask.value=a}}),b.ColorMatrixFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={matrix:{type:"mat4",value:[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform float invert;","uniform mat4 matrix;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord) * matrix;","}"]},b.ColorMatrixFilter.prototype=Object.create(b.AbstractFilter.prototype),b.ColorMatrixFilter.prototype.constructor=b.ColorMatrixFilter,Object.defineProperty(b.ColorMatrixFilter.prototype,"matrix",{get:function(){return this.uniforms.matrix.value},set:function(a){this.uniforms.matrix.value=a}}),b.GrayFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={gray:{type:"1f",value:1}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform sampler2D uSampler;","uniform float gray;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord);","   gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(0.2126*gl_FragColor.r + 0.7152*gl_FragColor.g + 0.0722*gl_FragColor.b), gray);","}"]},b.GrayFilter.prototype=Object.create(b.AbstractFilter.prototype),b.GrayFilter.prototype.constructor=b.GrayFilter,Object.defineProperty(b.GrayFilter.prototype,"gray",{get:function(){return this.uniforms.gray.value},set:function(a){this.uniforms.gray.value=a}}),b.DisplacementFilter=function(a){b.AbstractFilter.call(this),this.passes=[this],a.baseTexture._powerOf2=!0,this.uniforms={displacementMap:{type:"sampler2D",value:a},scale:{type:"2f",value:{x:30,y:30}},offset:{type:"2f",value:{x:0,y:0}},mapDimensions:{type:"2f",value:{x:1,y:5112}},dimensions:{type:"4fv",value:[0,0,0,0]}},a.baseTexture.hasLoaded?(this.uniforms.mapDimensions.value.x=a.width,this.uniforms.mapDimensions.value.y=a.height):(this.boundLoadedFunction=this.onTextureLoaded.bind(this),a.baseTexture.on("loaded",this.boundLoadedFunction)),this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform sampler2D displacementMap;","uniform sampler2D uSampler;","uniform vec2 scale;","uniform vec2 offset;","uniform vec4 dimensions;","uniform vec2 mapDimensions;","void main(void) {","   vec2 mapCords = vTextureCoord.xy;","   mapCords += (dimensions.zw + offset)/ dimensions.xy ;","   mapCords.y *= -1.0;","   mapCords.y += 1.0;","   vec2 matSample = texture2D(displacementMap, mapCords).xy;","   matSample -= 0.5;","   matSample *= scale;","   matSample /= mapDimensions;","   gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.x + matSample.x, vTextureCoord.y + matSample.y));","   gl_FragColor.rgb = mix( gl_FragColor.rgb, gl_FragColor.rgb, 1.0);","   vec2 cord = vTextureCoord;","}"]},b.DisplacementFilter.prototype=Object.create(b.AbstractFilter.prototype),b.DisplacementFilter.prototype.constructor=b.DisplacementFilter,b.DisplacementFilter.prototype.onTextureLoaded=function(){this.uniforms.mapDimensions.value.x=this.uniforms.displacementMap.value.width,this.uniforms.mapDimensions.value.y=this.uniforms.displacementMap.value.height,this.uniforms.displacementMap.value.baseTexture.off("loaded",this.boundLoadedFunction)},Object.defineProperty(b.DisplacementFilter.prototype,"map",{get:function(){return this.uniforms.displacementMap.value},set:function(a){this.uniforms.displacementMap.value=a}}),Object.defineProperty(b.DisplacementFilter.prototype,"scale",{get:function(){return this.uniforms.scale.value},set:function(a){this.uniforms.scale.value=a}}),Object.defineProperty(b.DisplacementFilter.prototype,"offset",{get:function(){return this.uniforms.offset.value},set:function(a){this.uniforms.offset.value=a}}),b.PixelateFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={invert:{type:"1f",value:0},dimensions:{type:"4fv",value:new b.Float32Array([1e4,100,10,10])},pixelSize:{type:"2f",value:{x:10,y:10}}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform vec2 testDim;","uniform vec4 dimensions;","uniform vec2 pixelSize;","uniform sampler2D uSampler;","void main(void) {","   vec2 coord = vTextureCoord;","   vec2 size = dimensions.xy/pixelSize;","   vec2 color = floor( ( vTextureCoord * size ) ) / size + pixelSize/dimensions.xy * 0.5;","   gl_FragColor = texture2D(uSampler, color);","}"]},b.PixelateFilter.prototype=Object.create(b.AbstractFilter.prototype),b.PixelateFilter.prototype.constructor=b.PixelateFilter,Object.defineProperty(b.PixelateFilter.prototype,"size",{get:function(){return this.uniforms.pixelSize.value},set:function(a){this.dirty=!0,this.uniforms.pixelSize.value=a}}),b.BlurXFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={blur:{type:"1f",value:1/512}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform float blur;","uniform sampler2D uSampler;","void main(void) {","   vec4 sum = vec4(0.0);","   sum += texture2D(uSampler, vec2(vTextureCoord.x - 4.0*blur, vTextureCoord.y)) * 0.05;","   sum += texture2D(uSampler, vec2(vTextureCoord.x - 3.0*blur, vTextureCoord.y)) * 0.09;","   sum += texture2D(uSampler, vec2(vTextureCoord.x - 2.0*blur, vTextureCoord.y)) * 0.12;","   sum += texture2D(uSampler, vec2(vTextureCoord.x - blur, vTextureCoord.y)) * 0.15;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y)) * 0.16;","   sum += texture2D(uSampler, vec2(vTextureCoord.x + blur, vTextureCoord.y)) * 0.15;","   sum += texture2D(uSampler, vec2(vTextureCoord.x + 2.0*blur, vTextureCoord.y)) * 0.12;","   sum += texture2D(uSampler, vec2(vTextureCoord.x + 3.0*blur, vTextureCoord.y)) * 0.09;","   sum += texture2D(uSampler, vec2(vTextureCoord.x + 4.0*blur, vTextureCoord.y)) * 0.05;","   gl_FragColor = sum;","}"]},b.BlurXFilter.prototype=Object.create(b.AbstractFilter.prototype),b.BlurXFilter.prototype.constructor=b.BlurXFilter,Object.defineProperty(b.BlurXFilter.prototype,"blur",{get:function(){return this.uniforms.blur.value/(1/7e3)},set:function(a){this.dirty=!0,this.uniforms.blur.value=1/7e3*a}}),b.BlurYFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={blur:{type:"1f",value:1/512}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform float blur;","uniform sampler2D uSampler;","void main(void) {","   vec4 sum = vec4(0.0);","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y - 4.0*blur)) * 0.05;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y - 3.0*blur)) * 0.09;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y - 2.0*blur)) * 0.12;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y - blur)) * 0.15;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y)) * 0.16;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y + blur)) * 0.15;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y + 2.0*blur)) * 0.12;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y + 3.0*blur)) * 0.09;","   sum += texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y + 4.0*blur)) * 0.05;","   gl_FragColor = sum;","}"]},b.BlurYFilter.prototype=Object.create(b.AbstractFilter.prototype),b.BlurYFilter.prototype.constructor=b.BlurYFilter,Object.defineProperty(b.BlurYFilter.prototype,"blur",{get:function(){return this.uniforms.blur.value/(1/7e3)},set:function(a){this.uniforms.blur.value=1/7e3*a}}),b.BlurFilter=function(){this.blurXFilter=new b.BlurXFilter,this.blurYFilter=new b.BlurYFilter,this.passes=[this.blurXFilter,this.blurYFilter]},b.BlurFilter.prototype=Object.create(b.AbstractFilter.prototype),b.BlurFilter.prototype.constructor=b.BlurFilter,Object.defineProperty(b.BlurFilter.prototype,"blur",{get:function(){return this.blurXFilter.blur},set:function(a){this.blurXFilter.blur=this.blurYFilter.blur=a}}),Object.defineProperty(b.BlurFilter.prototype,"blurX",{get:function(){return this.blurXFilter.blur},set:function(a){this.blurXFilter.blur=a}}),Object.defineProperty(b.BlurFilter.prototype,"blurY",{get:function(){return this.blurYFilter.blur},set:function(a){this.blurYFilter.blur=a}}),b.InvertFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={invert:{type:"1f",value:1}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform float invert;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord);","   gl_FragColor.rgb = mix( (vec3(1)-gl_FragColor.rgb) * gl_FragColor.a, gl_FragColor.rgb, 1.0 - invert);","}"]},b.InvertFilter.prototype=Object.create(b.AbstractFilter.prototype),b.InvertFilter.prototype.constructor=b.InvertFilter,Object.defineProperty(b.InvertFilter.prototype,"invert",{get:function(){return this.uniforms.invert.value},set:function(a){this.uniforms.invert.value=a}}),b.SepiaFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={sepia:{type:"1f",value:1}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform float sepia;","uniform sampler2D uSampler;","const mat3 sepiaMatrix = mat3(0.3588, 0.7044, 0.1368, 0.2990, 0.5870, 0.1140, 0.2392, 0.4696, 0.0912);","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord);","   gl_FragColor.rgb = mix( gl_FragColor.rgb, gl_FragColor.rgb * sepiaMatrix, sepia);","}"]},b.SepiaFilter.prototype=Object.create(b.AbstractFilter.prototype),b.SepiaFilter.prototype.constructor=b.SepiaFilter,Object.defineProperty(b.SepiaFilter.prototype,"sepia",{get:function(){return this.uniforms.sepia.value},set:function(a){this.uniforms.sepia.value=a}}),b.TwistFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={radius:{type:"1f",value:.5},angle:{type:"1f",value:5},offset:{type:"2f",value:{x:.5,y:.5}}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform vec4 dimensions;","uniform sampler2D uSampler;","uniform float radius;","uniform float angle;","uniform vec2 offset;","void main(void) {","   vec2 coord = vTextureCoord - offset;","   float distance = length(coord);","   if (distance < radius) {","       float ratio = (radius - distance) / radius;","       float angleMod = ratio * ratio * angle;","       float s = sin(angleMod);","       float c = cos(angleMod);","       coord = vec2(coord.x * c - coord.y * s, coord.x * s + coord.y * c);","   }","   gl_FragColor = texture2D(uSampler, coord+offset);","}"]},b.TwistFilter.prototype=Object.create(b.AbstractFilter.prototype),b.TwistFilter.prototype.constructor=b.TwistFilter,Object.defineProperty(b.TwistFilter.prototype,"offset",{get:function(){return this.uniforms.offset.value},set:function(a){this.dirty=!0,this.uniforms.offset.value=a}}),Object.defineProperty(b.TwistFilter.prototype,"radius",{get:function(){return this.uniforms.radius.value},set:function(a){this.dirty=!0,this.uniforms.radius.value=a}}),Object.defineProperty(b.TwistFilter.prototype,"angle",{get:function(){return this.uniforms.angle.value},set:function(a){this.dirty=!0,this.uniforms.angle.value=a}}),b.ColorStepFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={step:{type:"1f",value:5}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform sampler2D uSampler;","uniform float step;","void main(void) {","   vec4 color = texture2D(uSampler, vTextureCoord);","   color = floor(color * step) / step;","   gl_FragColor = color;","}"]},b.ColorStepFilter.prototype=Object.create(b.AbstractFilter.prototype),b.ColorStepFilter.prototype.constructor=b.ColorStepFilter,Object.defineProperty(b.ColorStepFilter.prototype,"step",{get:function(){return this.uniforms.step.value},set:function(a){this.uniforms.step.value=a}}),b.DotScreenFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={scale:{type:"1f",value:1},angle:{type:"1f",value:5},dimensions:{type:"4fv",value:[0,0,0,0]}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform vec4 dimensions;","uniform sampler2D uSampler;","uniform float angle;","uniform float scale;","float pattern() {","   float s = sin(angle), c = cos(angle);","   vec2 tex = vTextureCoord * dimensions.xy;","   vec2 point = vec2(","       c * tex.x - s * tex.y,","       s * tex.x + c * tex.y","   ) * scale;","   return (sin(point.x) * sin(point.y)) * 4.0;","}","void main() {","   vec4 color = texture2D(uSampler, vTextureCoord);","   float average = (color.r + color.g + color.b) / 3.0;","   gl_FragColor = vec4(vec3(average * 10.0 - 5.0 + pattern()), color.a);","}"]},b.DotScreenFilter.prototype=Object.create(b.AbstractFilter.prototype),b.DotScreenFilter.prototype.constructor=b.DotScreenFilter,Object.defineProperty(b.DotScreenFilter.prototype,"scale",{get:function(){return this.uniforms.scale.value},set:function(a){this.dirty=!0,this.uniforms.scale.value=a}}),Object.defineProperty(b.DotScreenFilter.prototype,"angle",{get:function(){return this.uniforms.angle.value},set:function(a){this.dirty=!0,this.uniforms.angle.value=a}}),b.CrossHatchFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={blur:{type:"1f",value:1/512}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform float blur;","uniform sampler2D uSampler;","void main(void) {","    float lum = length(texture2D(uSampler, vTextureCoord.xy).rgb);","    gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);","    if (lum < 1.00) {","        if (mod(gl_FragCoord.x + gl_FragCoord.y, 10.0) == 0.0) {","            gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);","        }","    }","    if (lum < 0.75) {","        if (mod(gl_FragCoord.x - gl_FragCoord.y, 10.0) == 0.0) {","            gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);","        }","    }","    if (lum < 0.50) {","        if (mod(gl_FragCoord.x + gl_FragCoord.y - 5.0, 10.0) == 0.0) {","            gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);","        }","    }","    if (lum < 0.3) {","        if (mod(gl_FragCoord.x - gl_FragCoord.y - 5.0, 10.0) == 0.0) {","            gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);","        }","    }","}"]},b.CrossHatchFilter.prototype=Object.create(b.AbstractFilter.prototype),b.CrossHatchFilter.prototype.constructor=b.CrossHatchFilter,Object.defineProperty(b.CrossHatchFilter.prototype,"blur",{get:function(){return this.uniforms.blur.value/(1/7e3)},set:function(a){this.uniforms.blur.value=1/7e3*a}}),b.RGBSplitFilter=function(){b.AbstractFilter.call(this),this.passes=[this],this.uniforms={red:{type:"2f",value:{x:20,y:20}},green:{type:"2f",value:{x:-20,y:20}},blue:{type:"2f",value:{x:20,y:-20}},dimensions:{type:"4fv",value:[0,0,0,0]}},this.fragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform vec2 red;","uniform vec2 green;","uniform vec2 blue;","uniform vec4 dimensions;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor.r = texture2D(uSampler, vTextureCoord + red/dimensions.xy).r;","   gl_FragColor.g = texture2D(uSampler, vTextureCoord + green/dimensions.xy).g;","   gl_FragColor.b = texture2D(uSampler, vTextureCoord + blue/dimensions.xy).b;","   gl_FragColor.a = texture2D(uSampler, vTextureCoord).a;","}"]},b.RGBSplitFilter.prototype=Object.create(b.AbstractFilter.prototype),b.RGBSplitFilter.prototype.constructor=b.RGBSplitFilter,Object.defineProperty(b.RGBSplitFilter.prototype,"red",{get:function(){return this.uniforms.red.value},set:function(a){this.uniforms.red.value=a}}),Object.defineProperty(b.RGBSplitFilter.prototype,"green",{get:function(){return this.uniforms.green.value},set:function(a){this.uniforms.green.value=a}}),Object.defineProperty(b.RGBSplitFilter.prototype,"blue",{get:function(){return this.uniforms.blue.value},set:function(a){this.uniforms.blue.value=a}}),"undefined"!=typeof exports?("undefined"!=typeof module&&module.exports&&(exports=module.exports=b),exports.PIXI=b):"undefined"!=typeof define&&define.amd?define(b):a.PIXI=b}).call(this);
;(function(){
var h,ba=this;function ca(a,b){var c=a.split("."),d=ba;c[0]in d||!d.execScript||d.execScript("var "+c[0]);for(var e;c.length&&(e=c.shift());)c.length||void 0===b?d=d[e]?d[e]:d[e]={}:d[e]=b}
function w(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";
else if("function"==b&&"undefined"==typeof a.call)return"object";return b}var da="closure_uid_"+(1E9*Math.random()>>>0),ea=0;var ga=String.prototype.trim?function(a){return a.trim()}:function(a){return a.replace(/^[\s\xa0]+|[\s\xa0]+$/g,"")};function ia(a){return Array.prototype.join.call(arguments,"")}function ka(a,b){return a<b?-1:a>b?1:0};function la(a,b){for(var c in a)b.call(void 0,a[c],c,a)}function ma(a){var b=arguments.length;if(1==b&&"array"==w(arguments[0]))return ma.apply(null,arguments[0]);for(var c={},d=0;d<b;d++)c[arguments[d]]=!0;return c};function na(a,b){null!=a&&this.append.apply(this,arguments)}h=na.prototype;h.La="";h.set=function(a){this.La=""+a};h.append=function(a,b,c){this.La+=a;if(null!=b)for(var d=1;d<arguments.length;d++)this.La+=arguments[d];return this};h.clear=function(){this.La=""};h.toString=function(){return this.La};if("undefined"===typeof pa)var pa=function(){throw Error("No *print-fn* fn set for evaluation environment");};var ra=!0,ta=null;if("undefined"===typeof ua)var ua=null;function wa(){return new xa(null,5,[ya,!0,za,!0,Aa,!1,Ba,!1,Ca,null],null)}function y(a){return null!=a&&!1!==a}function Da(a){return null==a}function Ea(a){return a instanceof Array}function Fa(a){return y(a)?!1:!0}function z(a,b){return a[w(null==b?null:b)]?!0:a._?!0:!1}
function A(a,b){var c=null==b?null:b.constructor,c=y(y(c)?c.Lb:c)?c.Jb:w(b);return Error(["No protocol method ",a," defined for type ",c,": ",b].join(""))}function Ga(a){var b=a.Jb;return y(b)?b:""+C(a)}var Ha="undefined"!==typeof Symbol&&"function"===w(Symbol)?Symbol.iterator:"@@iterator";function Ia(a){for(var b=a.length,c=Array(b),d=0;;)if(d<b)c[d]=a[d],d+=1;else break;return c}
function Ja(){switch(arguments.length){case 1:return La(arguments[0]);case 2:return La(arguments[1]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function Ma(a){return La(a)}function La(a){function b(a,b){a.push(b);return a}var c=[];return Na?Na(b,c,a):Oa.call(null,b,c,a)}
var Pa={},Ra={},Sa=function Sa(b){if(b?b.ia:b)return b.ia(b);var c;c=Sa[w(null==b?null:b)];if(!c&&(c=Sa._,!c))throw A("ICounted.-count",b);return c.call(null,b)},Ta=function Ta(b){if(b?b.ja:b)return b.ja(b);var c;c=Ta[w(null==b?null:b)];if(!c&&(c=Ta._,!c))throw A("IEmptyableCollection.-empty",b);return c.call(null,b)},Ua=function Ua(b,c){if(b?b.ga:b)return b.ga(b,c);var d;d=Ua[w(null==b?null:b)];if(!d&&(d=Ua._,!d))throw A("ICollection.-conj",b);return d.call(null,b,c)},Va={},D=function D(){switch(arguments.length){case 2:return D.b(arguments[0],
arguments[1]);case 3:return D.i(arguments[0],arguments[1],arguments[2]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}};D.b=function(a,b){if(a?a.J:a)return a.J(a,b);var c;c=D[w(null==a?null:a)];if(!c&&(c=D._,!c))throw A("IIndexed.-nth",a);return c.call(null,a,b)};D.i=function(a,b,c){if(a?a.va:a)return a.va(a,b,c);var d;d=D[w(null==a?null:a)];if(!d&&(d=D._,!d))throw A("IIndexed.-nth",a);return d.call(null,a,b,c)};D.C=3;
var Wa={},Xa=function Xa(b){if(b?b.oa:b)return b.oa(b);var c;c=Xa[w(null==b?null:b)];if(!c&&(c=Xa._,!c))throw A("ISeq.-first",b);return c.call(null,b)},Ya=function Ya(b){if(b?b.ua:b)return b.ua(b);var c;c=Ya[w(null==b?null:b)];if(!c&&(c=Ya._,!c))throw A("ISeq.-rest",b);return c.call(null,b)},Za={},ab={},cb=function cb(){switch(arguments.length){case 2:return cb.b(arguments[0],arguments[1]);case 3:return cb.i(arguments[0],arguments[1],arguments[2]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));
}};cb.b=function(a,b){if(a?a.O:a)return a.O(a,b);var c;c=cb[w(null==a?null:a)];if(!c&&(c=cb._,!c))throw A("ILookup.-lookup",a);return c.call(null,a,b)};cb.i=function(a,b,c){if(a?a.K:a)return a.K(a,b,c);var d;d=cb[w(null==a?null:a)];if(!d&&(d=cb._,!d))throw A("ILookup.-lookup",a);return d.call(null,a,b,c)};cb.C=3;
var db=function db(b,c){if(b?b.rb:b)return b.rb(b,c);var d;d=db[w(null==b?null:b)];if(!d&&(d=db._,!d))throw A("IAssociative.-contains-key?",b);return d.call(null,b,c)},eb=function eb(b,c,d){if(b?b.Ua:b)return b.Ua(b,c,d);var e;e=eb[w(null==b?null:b)];if(!e&&(e=eb._,!e))throw A("IAssociative.-assoc",b);return e.call(null,b,c,d)},fb={},gb=function gb(b,c){if(b?b.vb:b)return b.vb(b,c);var d;d=gb[w(null==b?null:b)];if(!d&&(d=gb._,!d))throw A("IMap.-dissoc",b);return d.call(null,b,c)},hb={},ib=function ib(b){if(b?
b.wb:b)return b.wb();var c;c=ib[w(null==b?null:b)];if(!c&&(c=ib._,!c))throw A("IMapEntry.-key",b);return c.call(null,b)},jb=function jb(b){if(b?b.xb:b)return b.xb();var c;c=jb[w(null==b?null:b)];if(!c&&(c=jb._,!c))throw A("IMapEntry.-val",b);return c.call(null,b)},kb={},lb=function lb(b){if(b?b.$a:b)return b.$a(b);var c;c=lb[w(null==b?null:b)];if(!c&&(c=lb._,!c))throw A("IStack.-peek",b);return c.call(null,b)},mb=function mb(b){if(b?b.ab:b)return b.ab(b);var c;c=mb[w(null==b?null:b)];if(!c&&(c=mb._,
!c))throw A("IStack.-pop",b);return c.call(null,b)},nb={},ob=function ob(b,c,d){if(b?b.yb:b)return b.yb(b,c,d);var e;e=ob[w(null==b?null:b)];if(!e&&(e=ob._,!e))throw A("IVector.-assoc-n",b);return e.call(null,b,c,d)},pb=function pb(b){if(b?b.Va:b)return b.Va(b);var c;c=pb[w(null==b?null:b)];if(!c&&(c=pb._,!c))throw A("IDeref.-deref",b);return c.call(null,b)},qb={},rb=function rb(b){if(b?b.P:b)return b.P(b);var c;c=rb[w(null==b?null:b)];if(!c&&(c=rb._,!c))throw A("IMeta.-meta",b);return c.call(null,
b)},sb={},tb=function tb(b,c){if(b?b.fa:b)return b.fa(b,c);var d;d=tb[w(null==b?null:b)];if(!d&&(d=tb._,!d))throw A("IWithMeta.-with-meta",b);return d.call(null,b,c)},ub={},vb=function vb(){switch(arguments.length){case 2:return vb.b(arguments[0],arguments[1]);case 3:return vb.i(arguments[0],arguments[1],arguments[2]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}};
vb.b=function(a,b){if(a?a.ma:a)return a.ma(a,b);var c;c=vb[w(null==a?null:a)];if(!c&&(c=vb._,!c))throw A("IReduce.-reduce",a);return c.call(null,a,b)};vb.i=function(a,b,c){if(a?a.na:a)return a.na(a,b,c);var d;d=vb[w(null==a?null:a)];if(!d&&(d=vb._,!d))throw A("IReduce.-reduce",a);return d.call(null,a,b,c)};vb.C=3;
var xb=function xb(b,c){if(b?b.w:b)return b.w(b,c);var d;d=xb[w(null==b?null:b)];if(!d&&(d=xb._,!d))throw A("IEquiv.-equiv",b);return d.call(null,b,c)},yb=function yb(b){if(b?b.N:b)return b.N(b);var c;c=yb[w(null==b?null:b)];if(!c&&(c=yb._,!c))throw A("IHash.-hash",b);return c.call(null,b)},zb={},Ab=function Ab(b){if(b?b.ha:b)return b.ha(b);var c;c=Ab[w(null==b?null:b)];if(!c&&(c=Ab._,!c))throw A("ISeqable.-seq",b);return c.call(null,b)},Bb={},Cb={},Db=function Db(b){if(b?b.mb:b)return b.mb(b);var c;
c=Db[w(null==b?null:b)];if(!c&&(c=Db._,!c))throw A("IReversible.-rseq",b);return c.call(null,b)},Eb=function Eb(b,c){if(b?b.Ib:b)return b.Ib(0,c);var d;d=Eb[w(null==b?null:b)];if(!d&&(d=Eb._,!d))throw A("IWriter.-write",b);return d.call(null,b,c)},Fb={},Gb=function Gb(b,c,d){if(b?b.L:b)return b.L(b,c,d);var e;e=Gb[w(null==b?null:b)];if(!e&&(e=Gb._,!e))throw A("IPrintWithWriter.-pr-writer",b);return e.call(null,b,c,d)},Hb=function Hb(b){if(b?b.Eb:b)return b.Eb();var c;c=Hb[w(null==b?null:b)];if(!c&&
(c=Hb._,!c))throw A("IPending.-realized?",b);return c.call(null,b)},Ib=function Ib(b,c,d){if(b?b.Hb:b)return b.Hb(0,c,d);var e;e=Ib[w(null==b?null:b)];if(!e&&(e=Ib._,!e))throw A("IWatchable.-notify-watches",b);return e.call(null,b,c,d)},Jb=function Jb(b){if(b?b.Oa:b)return b.Oa(b);var c;c=Jb[w(null==b?null:b)];if(!c&&(c=Jb._,!c))throw A("IEditableCollection.-as-transient",b);return c.call(null,b)},Kb=function Kb(b,c){if(b?b.cb:b)return b.cb(b,c);var d;d=Kb[w(null==b?null:b)];if(!d&&(d=Kb._,!d))throw A("ITransientCollection.-conj!",
b);return d.call(null,b,c)},Lb=function Lb(b){if(b?b.eb:b)return b.eb(b);var c;c=Lb[w(null==b?null:b)];if(!c&&(c=Lb._,!c))throw A("ITransientCollection.-persistent!",b);return c.call(null,b)},Mb=function Mb(b,c,d){if(b?b.bb:b)return b.bb(b,c,d);var e;e=Mb[w(null==b?null:b)];if(!e&&(e=Mb._,!e))throw A("ITransientAssociative.-assoc!",b);return e.call(null,b,c,d)},Nb=function Nb(b,c,d){if(b?b.Fb:b)return b.Fb(0,c,d);var e;e=Nb[w(null==b?null:b)];if(!e&&(e=Nb._,!e))throw A("ITransientVector.-assoc-n!",
b);return e.call(null,b,c,d)},Ob=function Ob(b){if(b?b.Bb:b)return b.Bb();var c;c=Ob[w(null==b?null:b)];if(!c&&(c=Ob._,!c))throw A("IChunk.-drop-first",b);return c.call(null,b)},Pb=function Pb(b){if(b?b.tb:b)return b.tb(b);var c;c=Pb[w(null==b?null:b)];if(!c&&(c=Pb._,!c))throw A("IChunkedSeq.-chunked-first",b);return c.call(null,b)},Qb=function Qb(b){if(b?b.ub:b)return b.ub(b);var c;c=Qb[w(null==b?null:b)];if(!c&&(c=Qb._,!c))throw A("IChunkedSeq.-chunked-rest",b);return c.call(null,b)},Rb=function Rb(b){if(b?
b.sb:b)return b.sb(b);var c;c=Rb[w(null==b?null:b)];if(!c&&(c=Rb._,!c))throw A("IChunkedNext.-chunked-next",b);return c.call(null,b)},Sb=function Sb(b){if(b?b.Xa:b)return b.Xa(b);var c;c=Sb[w(null==b?null:b)];if(!c&&(c=Sb._,!c))throw A("INamed.-name",b);return c.call(null,b)},Tb=function Tb(b){if(b?b.Ya:b)return b.Ya(b);var c;c=Tb[w(null==b?null:b)];if(!c&&(c=Tb._,!c))throw A("INamed.-namespace",b);return c.call(null,b)},Ub=function Ub(b,c){if(b?b.Tb:b)return b.Tb(b,c);var d;d=Ub[w(null==b?null:b)];
if(!d&&(d=Ub._,!d))throw A("IReset.-reset!",b);return d.call(null,b,c)},Vb=function Vb(){switch(arguments.length){case 2:return Vb.b(arguments[0],arguments[1]);case 3:return Vb.i(arguments[0],arguments[1],arguments[2]);case 4:return Vb.B(arguments[0],arguments[1],arguments[2],arguments[3]);case 5:return Vb.G(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}};
Vb.b=function(a,b){if(a?a.Ub:a)return a.Ub(a,b);var c;c=Vb[w(null==a?null:a)];if(!c&&(c=Vb._,!c))throw A("ISwap.-swap!",a);return c.call(null,a,b)};Vb.i=function(a,b,c){if(a?a.Vb:a)return a.Vb(a,b,c);var d;d=Vb[w(null==a?null:a)];if(!d&&(d=Vb._,!d))throw A("ISwap.-swap!",a);return d.call(null,a,b,c)};Vb.B=function(a,b,c,d){if(a?a.Wb:a)return a.Wb(a,b,c,d);var e;e=Vb[w(null==a?null:a)];if(!e&&(e=Vb._,!e))throw A("ISwap.-swap!",a);return e.call(null,a,b,c,d)};
Vb.G=function(a,b,c,d,e){if(a?a.Xb:a)return a.Xb(a,b,c,d,e);var f;f=Vb[w(null==a?null:a)];if(!f&&(f=Vb._,!f))throw A("ISwap.-swap!",a);return f.call(null,a,b,c,d,e)};Vb.C=5;var Wb=function Wb(b,c){if(b?b.Gb:b)return b.Gb(0,c);var d;d=Wb[w(null==b?null:b)];if(!d&&(d=Wb._,!d))throw A("IVolatile.-vreset!",b);return d.call(null,b,c)},Xb=function Xb(b){if(b?b.kb:b)return b.kb(b);var c;c=Xb[w(null==b?null:b)];if(!c&&(c=Xb._,!c))throw A("IIterable.-iterator",b);return c.call(null,b)};
function Yb(a){this.fc=a;this.m=1073741824;this.D=0}Yb.prototype.Ib=function(a,b){return this.fc.append(b)};function Zb(a){var b=new na;a.L(null,new Yb(b),wa());return""+C(b)}var $b="undefined"!==typeof Math.imul&&0!==Math.imul(4294967295,5)?function(a,b){return Math.imul(a,b)}:function(a,b){var c=a&65535,d=b&65535;return c*d+((a>>>16&65535)*d+c*(b>>>16&65535)<<16>>>0)|0};function ac(a){a=$b(a|0,-862048943);return $b(a<<15|a>>>-15,461845907)}
function bc(a,b){var c=(a|0)^(b|0);return $b(c<<13|c>>>-13,5)+-430675100|0}function cc(a,b){var c=(a|0)^b,c=$b(c^c>>>16,-2048144789),c=$b(c^c>>>13,-1028477387);return c^c>>>16}function dc(a){var b;a:{b=1;for(var c=0;;)if(b<a.length){var d=b+2,c=bc(c,ac(a.charCodeAt(b-1)|a.charCodeAt(b)<<16));b=d}else{b=c;break a}}b=1===(a.length&1)?b^ac(a.charCodeAt(a.length-1)):b;return cc(b,$b(2,a.length))}var ec={},fc=0;
function gc(a){255<fc&&(ec={},fc=0);var b=ec[a];if("number"!==typeof b){a:if(null!=a)if(b=a.length,0<b)for(var c=0,d=0;;)if(c<b)var e=c+1,d=$b(31,d)+a.charCodeAt(c),c=e;else{b=d;break a}else b=0;else b=0;ec[a]=b;fc+=1}return a=b}function hc(a){a&&(a.m&4194304||a.kc)?a=a.N(null):"number"===typeof a?a=Math.floor(a)%2147483647:!0===a?a=1:!1===a?a=0:"string"===typeof a?(a=gc(a),0!==a&&(a=ac(a),a=bc(0,a),a=cc(a,4))):a=a instanceof Date?a.valueOf():null==a?0:yb(a);return a}
function ic(a,b){return a^b+2654435769+(a<<6)+(a>>2)}function G(a,b,c,d,e){this.Ta=a;this.name=b;this.Ka=c;this.Na=d;this.la=e;this.m=2154168321;this.D=4096}h=G.prototype;h.toString=function(){return this.Ka};h.equiv=function(a){return this.w(null,a)};h.w=function(a,b){return b instanceof G?this.Ka===b.Ka:!1};
h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return cb.i(c,this,null);case 3:return cb.i(c,this,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return cb.i(c,this,null)};a.i=function(a,c,d){return cb.i(c,this,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return cb.i(a,this,null)};h.b=function(a,b){return cb.i(a,this,b)};h.P=function(){return this.la};
h.fa=function(a,b){return new G(this.Ta,this.name,this.Ka,this.Na,b)};h.N=function(){var a=this.Na;return null!=a?a:this.Na=a=ic(dc(this.name),gc(this.Ta))};h.Xa=function(){return this.name};h.Ya=function(){return this.Ta};h.L=function(a,b){return Eb(b,this.Ka)};function jc(){var a=[C("cljs.test"),C("/"),C("report")].join("");return new G("cljs.test","report",a,null,null)}function kc(a,b,c){this.g=a;this.gc=b;this.la=c;this.m=163841;this.D=0}h=kc.prototype;
h.Va=function(){return this.g.f?this.g.f():this.g.call(null)};h.P=function(){return this.la};h.Ab=!0;
h.call=function(){function a(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F,Q){a=this;a=a.g.f?a.g.f():a.g.call(null);return lc.Ca?lc.Ca(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F,Q):lc.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F,Q)}function b(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F)}function c(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,
k,l,m,n,p,q,r,t,v,x,u,B,E)}function d(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B)}function e(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u)}function f(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x)}function g(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v){a=this;return(a.g.f?
a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v)}function k(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t)}function l(a,b,c,d,e,f,g,k,l,m,n,p,q,r){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q,r)}function m(a,b,c,d,e,f,g,k,l,m,n,p,q){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n,p,q)}function n(a,b,c,d,e,f,g,k,l,m,n,p){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,
b,c,d,e,f,g,k,l,m,n,p)}function p(a,b,c,d,e,f,g,k,l,m,n){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m,n)}function q(a,b,c,d,e,f,g,k,l,m){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l,m)}function r(a,b,c,d,e,f,g,k,l){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k,l)}function t(a,b,c,d,e,f,g,k){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f,g,k)}function v(a,b,c,d,e,f,g){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,
b,c,d,e,f,g)}function x(a,b,c,d,e,f){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e,f)}function B(a,b,c,d,e){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d,e)}function E(a,b,c,d){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c,d)}function F(a,b,c){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b,c)}function Q(a,b){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null,b)}function ha(a){a=this;return(a.g.f?a.g.f():a.g.call(null)).call(null)}var u=null,u=
function(Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u,Ka,Qa,bb,wb,mc,vd){switch(arguments.length){case 1:return ha.call(this,Y);case 2:return Q.call(this,Y,H);case 3:return F.call(this,Y,H,J);case 4:return E.call(this,Y,H,J,K);case 5:return B.call(this,Y,H,J,K,L);case 6:return x.call(this,Y,H,J,K,L,O);case 7:return v.call(this,Y,H,J,K,L,O,S);case 8:return t.call(this,Y,H,J,K,L,O,S,V);case 9:return r.call(this,Y,H,J,K,L,O,S,V,aa);case 10:return q.call(this,Y,H,J,K,L,O,S,V,aa,sa);case 11:return p.call(this,
Y,H,J,K,L,O,S,V,aa,sa,fa);case 12:return n.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja);case 13:return m.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa);case 14:return l.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa);case 15:return k.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va);case 16:return g.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u);case 17:return f.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u,Ka);case 18:return e.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u,Ka,Qa);case 19:return d.call(this,
Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u,Ka,Qa,bb);case 20:return c.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u,Ka,Qa,bb,wb);case 21:return b.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u,Ka,Qa,bb,wb,mc);case 22:return a.call(this,Y,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,u,Ka,Qa,bb,wb,mc,vd)}throw Error("Invalid arity: "+arguments.length);};u.a=ha;u.b=Q;u.i=F;u.B=E;u.G=B;u.M=x;u.ca=v;u.da=t;u.ea=r;u.S=q;u.T=p;u.U=n;u.V=m;u.W=l;u.X=k;u.Y=g;u.Z=f;u.$=e;u.aa=d;u.ba=c;u.Wa=b;u.Ca=a;return u}();
h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.f=function(){return(this.g.f?this.g.f():this.g.call(null)).call(null)};h.a=function(a){return(this.g.f?this.g.f():this.g.call(null)).call(null,a)};h.b=function(a,b){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b)};h.i=function(a,b,c){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c)};h.B=function(a,b,c,d){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d)};
h.G=function(a,b,c,d,e){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e)};h.M=function(a,b,c,d,e,f){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f)};h.ca=function(a,b,c,d,e,f,g){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g)};h.da=function(a,b,c,d,e,f,g,k){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k)};h.ea=function(a,b,c,d,e,f,g,k,l){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l)};
h.S=function(a,b,c,d,e,f,g,k,l,m){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m)};h.T=function(a,b,c,d,e,f,g,k,l,m,n){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n)};h.U=function(a,b,c,d,e,f,g,k,l,m,n,p){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p)};h.V=function(a,b,c,d,e,f,g,k,l,m,n,p,q){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q)};
h.W=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r)};h.X=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t)};h.Y=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v)};
h.Z=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x)};h.$=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B)};h.aa=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E)};
h.ba=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F){return(this.g.f?this.g.f():this.g.call(null)).call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F)};h.Wa=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q){var ha=this.g.f?this.g.f():this.g.call(null);return lc.Ca?lc.Ca(ha,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q):lc.call(null,ha,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q)};
function I(a){if(null==a)return null;if(a&&(a.m&8388608||a.mc))return a.ha(null);if(Ea(a)||"string"===typeof a)return 0===a.length?null:new M(a,0);if(z(zb,a))return Ab(a);throw Error([C(a),C(" is not ISeqable")].join(""));}function N(a){if(null==a)return null;if(a&&(a.m&64||a.Za))return a.oa(null);a=I(a);return null==a?null:Xa(a)}function nc(a){return null!=a?a&&(a.m&64||a.Za)?a.ua(null):(a=I(a))?Ya(a):oc:oc}function P(a){return null==a?null:a&&(a.m&128||a.lb)?a.ra(null):I(nc(a))}
var pc=function pc(){switch(arguments.length){case 1:return pc.a(arguments[0]);case 2:return pc.b(arguments[0],arguments[1]);default:return pc.o(arguments[0],arguments[1],new M(Array.prototype.slice.call(arguments,2),0))}};pc.a=function(){return!0};pc.b=function(a,b){return null==a?null==b:a===b||xb(a,b)};pc.o=function(a,b,c){for(;;)if(pc.b(a,b))if(P(c))a=b,b=N(c),c=P(c);else return pc.b(b,N(c));else return!1};pc.A=function(a){var b=N(a),c=P(a);a=N(c);c=P(c);return pc.o(b,a,c)};pc.C=2;
function qc(a){this.F=a}qc.prototype.next=function(){if(null!=this.F){var a=N(this.F);this.F=P(this.F);return{value:a,done:!1}}return{value:null,done:!0}};function rc(a){return new qc(I(a))}function sc(a,b){var c=ac(a),c=bc(0,c);return cc(c,b)}function tc(a){var b=0,c=1;for(a=I(a);;)if(null!=a)b+=1,c=$b(31,c)+hc(N(a))|0,a=P(a);else return sc(c,b)}var uc=sc(1,0);function vc(a){var b=0,c=0;for(a=I(a);;)if(null!=a)b+=1,c=c+hc(N(a))|0,a=P(a);else return sc(c,b)}var wc=sc(0,0);Ra["null"]=!0;
Sa["null"]=function(){return 0};Date.prototype.w=function(a,b){return b instanceof Date&&this.valueOf()===b.valueOf()};xb.number=function(a,b){return a===b};Pa["function"]=!0;qb["function"]=!0;rb["function"]=function(){return null};yb._=function(a){return a[da]||(a[da]=++ea)};function xc(a){return a+1}function R(a){return pb(a)}function yc(a,b){var c=Sa(a);if(0===c)return b.f?b.f():b.call(null);for(var d=D.b(a,0),e=1;;)if(e<c)var f=D.b(a,e),d=b.b?b.b(d,f):b.call(null,d,f),e=e+1;else return d}
function zc(a,b,c){var d=Sa(a),e=c;for(c=0;;)if(c<d){var f=D.b(a,c),e=b.b?b.b(e,f):b.call(null,e,f);c+=1}else return e}function Ac(a,b){var c=a.length;if(0===a.length)return b.f?b.f():b.call(null);for(var d=a[0],e=1;;)if(e<c)var f=a[e],d=b.b?b.b(d,f):b.call(null,d,f),e=e+1;else return d}function Bc(a,b,c){var d=a.length,e=c;for(c=0;;)if(c<d){var f=a[c],e=b.b?b.b(e,f):b.call(null,e,f);c+=1}else return e}
function Cc(a,b,c,d){for(var e=a.length;;)if(d<e){var f=a[d];c=b.b?b.b(c,f):b.call(null,c,f);d+=1}else return c}function Dc(a){return a?a.m&2||a.Nb?!0:a.m?!1:z(Ra,a):z(Ra,a)}function Ec(a){return a?a.m&16||a.Cb?!0:a.m?!1:z(Va,a):z(Va,a)}function Fc(a,b){this.c=a;this.u=b}Fc.prototype.zb=function(){return this.u<this.c.length};Fc.prototype.next=function(){var a=this.c[this.u];this.u+=1;return a};function M(a,b){this.c=a;this.u=b;this.m=166199550;this.D=8192}h=M.prototype;h.toString=function(){return Zb(this)};
h.equiv=function(a){return this.w(null,a)};h.J=function(a,b){var c=b+this.u;return c<this.c.length?this.c[c]:null};h.va=function(a,b,c){a=b+this.u;return a<this.c.length?this.c[a]:c};h.kb=function(){return new Fc(this.c,this.u)};h.ra=function(){return this.u+1<this.c.length?new M(this.c,this.u+1):null};h.ia=function(){var a=this.c.length-this.u;return 0>a?0:a};h.mb=function(){var a=Sa(this);return 0<a?new Gc(this,a-1,null):null};h.N=function(){return tc(this)};
h.w=function(a,b){return Hc.b?Hc.b(this,b):Hc.call(null,this,b)};h.ja=function(){return oc};h.ma=function(a,b){return Cc(this.c,b,this.c[this.u],this.u+1)};h.na=function(a,b,c){return Cc(this.c,b,c,this.u)};h.oa=function(){return this.c[this.u]};h.ua=function(){return this.u+1<this.c.length?new M(this.c,this.u+1):oc};h.ha=function(){return this.u<this.c.length?this:null};h.ga=function(a,b){return T.b?T.b(b,this):T.call(null,b,this)};M.prototype[Ha]=function(){return rc(this)};
function Ic(a,b){return b<a.length?new M(a,b):null}function U(){switch(arguments.length){case 1:return Ic(arguments[0],0);case 2:return Ic(arguments[0],arguments[1]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function Gc(a,b,c){this.jb=a;this.u=b;this.s=c;this.m=32374990;this.D=8192}h=Gc.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};
h.ra=function(){return 0<this.u?new Gc(this.jb,this.u-1,null):null};h.ia=function(){return this.u+1};h.N=function(){return tc(this)};h.w=function(a,b){return Hc.b?Hc.b(this,b):Hc.call(null,this,b)};h.ja=function(){var a=this.s;return Jc.b?Jc.b(oc,a):Jc.call(null,oc,a)};h.ma=function(a,b){return Kc?Kc(b,this):Lc.call(null,b,this)};h.na=function(a,b,c){return Mc?Mc(b,c,this):Lc.call(null,b,c,this)};h.oa=function(){return D.b(this.jb,this.u)};
h.ua=function(){return 0<this.u?new Gc(this.jb,this.u-1,null):oc};h.ha=function(){return this};h.fa=function(a,b){return new Gc(this.jb,this.u,b)};h.ga=function(a,b){return T.b?T.b(b,this):T.call(null,b,this)};Gc.prototype[Ha]=function(){return rc(this)};function Nc(a){return N(P(a))}xb._=function(a,b){return a===b};
var Oc=function Oc(){switch(arguments.length){case 0:return Oc.f();case 1:return Oc.a(arguments[0]);case 2:return Oc.b(arguments[0],arguments[1]);default:return Oc.o(arguments[0],arguments[1],new M(Array.prototype.slice.call(arguments,2),0))}};Oc.f=function(){return Pc};Oc.a=function(a){return a};Oc.b=function(a,b){return null!=a?Ua(a,b):Ua(oc,b)};Oc.o=function(a,b,c){for(;;)if(y(c))a=Oc.b(a,b),b=N(c),c=P(c);else return Oc.b(a,b)};Oc.A=function(a){var b=N(a),c=P(a);a=N(c);c=P(c);return Oc.o(b,a,c)};
Oc.C=2;function Qc(a){if(null!=a)if(a&&(a.m&2||a.Nb))a=a.ia(null);else if(Ea(a))a=a.length;else if("string"===typeof a)a=a.length;else if(z(Ra,a))a=Sa(a);else a:{a=I(a);for(var b=0;;){if(Dc(a)){a=b+Sa(a);break a}a=P(a);b+=1}}else a=0;return a}function Rc(a,b){for(var c=null;;){if(null==a)return c;if(0===b)return I(a)?N(a):c;if(Ec(a))return D.i(a,b,c);if(I(a)){var d=P(a),e=b-1;a=d;b=e}else return c}}
function Sc(a,b){if("number"!==typeof b)throw Error("index argument to nth must be a number");if(null==a)return a;if(a&&(a.m&16||a.Cb))return a.J(null,b);if(Ea(a)||"string"===typeof a)return b<a.length?a[b]:null;if(z(Va,a))return D.b(a,b);if(a?a.m&64||a.Za||(a.m?0:z(Wa,a)):z(Wa,a)){var c;a:{c=a;for(var d=b;;){if(null==c)throw Error("Index out of bounds");if(0===d){if(I(c)){c=N(c);break a}throw Error("Index out of bounds");}if(Ec(c)){c=D.b(c,d);break a}if(I(c))c=P(c),--d;else throw Error("Index out of bounds");
}}return c}throw Error([C("nth not supported on this type "),C(Ga(null==a?null:a.constructor))].join(""));}
function Tc(a,b){if("number"!==typeof b)throw Error("index argument to nth must be a number.");if(null==a)return null;if(a&&(a.m&16||a.Cb))return a.va(null,b,null);if(Ea(a)||"string"===typeof a)return b<a.length?a[b]:null;if(z(Va,a))return D.b(a,b);if(a?a.m&64||a.Za||(a.m?0:z(Wa,a)):z(Wa,a))return Rc(a,b);throw Error([C("nth not supported on this type "),C(Ga(null==a?null:a.constructor))].join(""));}
function Uc(a,b){return null==a?null:a&&(a.m&256||a.Db)?a.O(null,b):Ea(a)?b<a.length?a[b|0]:null:"string"===typeof a?b<a.length?a[b|0]:null:z(ab,a)?cb.b(a,b):null}function Vc(a,b,c){return null!=a?a&&(a.m&256||a.Db)?a.K(null,b,c):Ea(a)?b<a.length?a[b]:c:"string"===typeof a?b<a.length?a[b]:c:z(ab,a)?cb.i(a,b,c):c:c}
var Wc=function Wc(){switch(arguments.length){case 3:return Wc.i(arguments[0],arguments[1],arguments[2]);default:return Wc.o(arguments[0],arguments[1],arguments[2],new M(Array.prototype.slice.call(arguments,3),0))}};Wc.i=function(a,b,c){return null!=a?eb(a,b,c):Xc([b],[c])};Wc.o=function(a,b,c,d){for(;;)if(a=Wc.i(a,b,c),y(d))b=N(d),c=Nc(d),d=P(P(d));else return a};Wc.A=function(a){var b=N(a),c=P(a);a=N(c);var d=P(c),c=N(d),d=P(d);return Wc.o(b,a,c,d)};Wc.C=3;
var Yc=function Yc(){switch(arguments.length){case 1:return Yc.a(arguments[0]);case 2:return Yc.b(arguments[0],arguments[1]);default:return Yc.o(arguments[0],arguments[1],new M(Array.prototype.slice.call(arguments,2),0))}};Yc.a=function(a){return a};Yc.b=function(a,b){return null==a?null:gb(a,b)};Yc.o=function(a,b,c){for(;;){if(null==a)return null;a=Yc.b(a,b);if(y(c))b=N(c),c=P(c);else return a}};Yc.A=function(a){var b=N(a),c=P(a);a=N(c);c=P(c);return Yc.o(b,a,c)};Yc.C=2;
function Zc(a){var b="function"==w(a);return y(b)?b:a?y(y(null)?null:a.Ab)?!0:a.$b?!1:z(Pa,a):z(Pa,a)}function $c(a,b){this.h=a;this.s=b;this.m=393217;this.D=0}h=$c.prototype;h.P=function(){return this.s};h.fa=function(a,b){return new $c(this.h,b)};h.Ab=!0;
h.call=function(){function a(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F,Q){a=this.h;return lc.Ca?lc.Ca(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F,Q):lc.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F,Q)}function b(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F){a=this;return a.h.ba?a.h.ba(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E,F)}function c(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E){a=this;return a.h.aa?a.h.aa(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E):
a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B,E)}function d(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B){a=this;return a.h.$?a.h.$(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u,B)}function e(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u){a=this;return a.h.Z?a.h.Z(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,u)}function f(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x){a=this;return a.h.Y?a.h.Y(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x):a.h.call(null,b,c,d,e,
f,g,k,l,m,n,p,q,r,t,v,x)}function g(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v){a=this;return a.h.X?a.h.X(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v)}function k(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t){a=this;return a.h.W?a.h.W(b,c,d,e,f,g,k,l,m,n,p,q,r,t):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t)}function l(a,b,c,d,e,f,g,k,l,m,n,p,q,r){a=this;return a.h.V?a.h.V(b,c,d,e,f,g,k,l,m,n,p,q,r):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r)}function m(a,b,c,d,e,f,g,k,l,m,n,p,q){a=this;return a.h.U?
a.h.U(b,c,d,e,f,g,k,l,m,n,p,q):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p,q)}function n(a,b,c,d,e,f,g,k,l,m,n,p){a=this;return a.h.T?a.h.T(b,c,d,e,f,g,k,l,m,n,p):a.h.call(null,b,c,d,e,f,g,k,l,m,n,p)}function p(a,b,c,d,e,f,g,k,l,m,n){a=this;return a.h.S?a.h.S(b,c,d,e,f,g,k,l,m,n):a.h.call(null,b,c,d,e,f,g,k,l,m,n)}function q(a,b,c,d,e,f,g,k,l,m){a=this;return a.h.ea?a.h.ea(b,c,d,e,f,g,k,l,m):a.h.call(null,b,c,d,e,f,g,k,l,m)}function r(a,b,c,d,e,f,g,k,l){a=this;return a.h.da?a.h.da(b,c,d,e,f,g,k,l):a.h.call(null,
b,c,d,e,f,g,k,l)}function t(a,b,c,d,e,f,g,k){a=this;return a.h.ca?a.h.ca(b,c,d,e,f,g,k):a.h.call(null,b,c,d,e,f,g,k)}function v(a,b,c,d,e,f,g){a=this;return a.h.M?a.h.M(b,c,d,e,f,g):a.h.call(null,b,c,d,e,f,g)}function x(a,b,c,d,e,f){a=this;return a.h.G?a.h.G(b,c,d,e,f):a.h.call(null,b,c,d,e,f)}function B(a,b,c,d,e){a=this;return a.h.B?a.h.B(b,c,d,e):a.h.call(null,b,c,d,e)}function E(a,b,c,d){a=this;return a.h.i?a.h.i(b,c,d):a.h.call(null,b,c,d)}function F(a,b,c){a=this;return a.h.b?a.h.b(b,c):a.h.call(null,
b,c)}function Q(a,b){a=this;return a.h.a?a.h.a(b):a.h.call(null,b)}function ha(a){a=this;return a.h.f?a.h.f():a.h.call(null)}var u=null,u=function(Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb,mc,vd){switch(arguments.length){case 1:return ha.call(this,Y);case 2:return Q.call(this,Y,H);case 3:return F.call(this,Y,H,J);case 4:return E.call(this,Y,H,J,K);case 5:return B.call(this,Y,H,J,K,L);case 6:return x.call(this,Y,H,J,K,L,O);case 7:return v.call(this,Y,H,J,K,L,O,S);case 8:return t.call(this,
Y,H,J,K,L,O,S,V);case 9:return r.call(this,Y,H,J,K,L,O,S,V,aa);case 10:return q.call(this,Y,H,J,K,L,O,S,V,aa,u);case 11:return p.call(this,Y,H,J,K,L,O,S,V,aa,u,fa);case 12:return n.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja);case 13:return m.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa);case 14:return l.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa);case 15:return k.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va);case 16:return g.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a);case 17:return f.call(this,Y,H,J,
K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a,Ka);case 18:return e.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a,Ka,Qa);case 19:return d.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a,Ka,Qa,bb);case 20:return c.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb);case 21:return b.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb,mc);case 22:return a.call(this,Y,H,J,K,L,O,S,V,aa,u,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb,mc,vd)}throw Error("Invalid arity: "+arguments.length);};u.a=ha;u.b=Q;u.i=F;
u.B=E;u.G=B;u.M=x;u.ca=v;u.da=t;u.ea=r;u.S=q;u.T=p;u.U=n;u.V=m;u.W=l;u.X=k;u.Y=g;u.Z=f;u.$=e;u.aa=d;u.ba=c;u.Wa=b;u.Ca=a;return u}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.f=function(){return this.h.f?this.h.f():this.h.call(null)};h.a=function(a){return this.h.a?this.h.a(a):this.h.call(null,a)};h.b=function(a,b){return this.h.b?this.h.b(a,b):this.h.call(null,a,b)};h.i=function(a,b,c){return this.h.i?this.h.i(a,b,c):this.h.call(null,a,b,c)};
h.B=function(a,b,c,d){return this.h.B?this.h.B(a,b,c,d):this.h.call(null,a,b,c,d)};h.G=function(a,b,c,d,e){return this.h.G?this.h.G(a,b,c,d,e):this.h.call(null,a,b,c,d,e)};h.M=function(a,b,c,d,e,f){return this.h.M?this.h.M(a,b,c,d,e,f):this.h.call(null,a,b,c,d,e,f)};h.ca=function(a,b,c,d,e,f,g){return this.h.ca?this.h.ca(a,b,c,d,e,f,g):this.h.call(null,a,b,c,d,e,f,g)};h.da=function(a,b,c,d,e,f,g,k){return this.h.da?this.h.da(a,b,c,d,e,f,g,k):this.h.call(null,a,b,c,d,e,f,g,k)};
h.ea=function(a,b,c,d,e,f,g,k,l){return this.h.ea?this.h.ea(a,b,c,d,e,f,g,k,l):this.h.call(null,a,b,c,d,e,f,g,k,l)};h.S=function(a,b,c,d,e,f,g,k,l,m){return this.h.S?this.h.S(a,b,c,d,e,f,g,k,l,m):this.h.call(null,a,b,c,d,e,f,g,k,l,m)};h.T=function(a,b,c,d,e,f,g,k,l,m,n){return this.h.T?this.h.T(a,b,c,d,e,f,g,k,l,m,n):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n)};h.U=function(a,b,c,d,e,f,g,k,l,m,n,p){return this.h.U?this.h.U(a,b,c,d,e,f,g,k,l,m,n,p):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p)};
h.V=function(a,b,c,d,e,f,g,k,l,m,n,p,q){return this.h.V?this.h.V(a,b,c,d,e,f,g,k,l,m,n,p,q):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q)};h.W=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r){return this.h.W?this.h.W(a,b,c,d,e,f,g,k,l,m,n,p,q,r):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r)};h.X=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t){return this.h.X?this.h.X(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t)};
h.Y=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v){return this.h.Y?this.h.Y(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v)};h.Z=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x){return this.h.Z?this.h.Z(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x)};h.$=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B){return this.h.$?this.h.$(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B)};
h.aa=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E){return this.h.aa?this.h.aa(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E)};h.ba=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F){return this.h.ba?this.h.ba(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F):this.h.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F)};
h.Wa=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q){var ha=this.h;return lc.Ca?lc.Ca(ha,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q):lc.call(null,ha,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q)};function Jc(a,b){return Zc(a)&&!(a?a.m&262144||a.qc||(a.m?0:z(sb,a)):z(sb,a))?new $c(a,b):null==a?null:tb(a,b)}function ad(a){var b=null!=a;return(b?a?a.m&131072||a.Qb||(a.m?0:z(qb,a)):z(qb,a):b)?rb(a):null}function bd(a){return null==a?!1:a?a.m&4096||a.oc?!0:a.m?!1:z(kb,a):z(kb,a)}
function cd(a){return null==a?!1:a?a.m&1024||a.Ob?!0:a.m?!1:z(fb,a):z(fb,a)}function dd(a){return a?a.m&16384||a.pc?!0:a.m?!1:z(nb,a):z(nb,a)}function ed(a){return a?a.D&512||a.ic?!0:!1:!1}function fd(a){var b=[];la(a,function(a,b){return function(a,c){return b.push(c)}}(a,b));return b}function gd(a,b,c,d,e){for(;0!==e;)c[d]=a[b],d+=1,--e,b+=1}var hd={};function id(a){return null==a?!1:a?a.m&64||a.Za?!0:a.m?!1:z(Wa,a):z(Wa,a)}function jd(a){return y(a)?!0:!1}
function kd(a,b){return Vc(a,b,hd)===hd?!1:!0}function Lc(){switch(arguments.length){case 2:return Kc(arguments[0],arguments[1]);case 3:return Mc(arguments[0],arguments[1],arguments[2]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function Kc(a,b){var c=I(b);if(c){var d=N(c),c=P(c);return Na?Na(a,d,c):Oa.call(null,a,d,c)}return a.f?a.f():a.call(null)}function Mc(a,b,c){for(c=I(c);;)if(c){var d=N(c);b=a.b?a.b(b,d):a.call(null,b,d);c=P(c)}else return b}
function Oa(){switch(arguments.length){case 2:return ld(arguments[0],arguments[1]);case 3:return Na(arguments[0],arguments[1],arguments[2]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function ld(a,b){return b&&(b.m&524288||b.Sb)?b.ma(null,a):Ea(b)?Ac(b,a):"string"===typeof b?Ac(b,a):z(ub,b)?vb.b(b,a):Kc(a,b)}function Na(a,b,c){return c&&(c.m&524288||c.Sb)?c.na(null,a,b):Ea(c)?Bc(c,a,b):"string"===typeof c?Bc(c,a,b):z(ub,c)?vb.i(c,a,b):Mc(a,b,c)}
function md(a){return a}var nd=function nd(){switch(arguments.length){case 0:return nd.f();case 1:return nd.a(arguments[0]);case 2:return nd.b(arguments[0],arguments[1]);default:return nd.o(arguments[0],arguments[1],new M(Array.prototype.slice.call(arguments,2),0))}};nd.f=function(){return 0};nd.a=function(a){return a};nd.b=function(a,b){return a+b};nd.o=function(a,b,c){return Na(nd,a+b,c)};nd.A=function(a){var b=N(a),c=P(a);a=N(c);c=P(c);return nd.o(b,a,c)};nd.C=2;
function od(a){a=(a-a%2)/2;return 0<=a?Math.floor(a):Math.ceil(a)}function pd(a){a-=a>>1&1431655765;a=(a&858993459)+(a>>2&858993459);return 16843009*(a+(a>>4)&252645135)>>24}function qd(a){var b=1;for(a=I(a);;)if(a&&0<b)--b,a=P(a);else return a}var C=function C(){switch(arguments.length){case 0:return C.f();case 1:return C.a(arguments[0]);default:return C.o(arguments[0],new M(Array.prototype.slice.call(arguments,1),0))}};C.f=function(){return""};C.a=function(a){return null==a?"":ia(a)};
C.o=function(a,b){for(var c=new na(""+C(a)),d=b;;)if(y(d))c=c.append(""+C(N(d))),d=P(d);else return c.toString()};C.A=function(a){var b=N(a);a=P(a);return C.o(b,a)};C.C=1;function Hc(a,b){var c;if(b?b.m&16777216||b.nc||(b.m?0:z(Bb,b)):z(Bb,b))if(Dc(a)&&Dc(b)&&Qc(a)!==Qc(b))c=!1;else a:{c=I(a);for(var d=I(b);;){if(null==c){c=null==d;break a}if(null!=d&&pc.b(N(c),N(d)))c=P(c),d=P(d);else{c=!1;break a}}}else c=null;return jd(c)}
function rd(a,b,c,d,e){this.s=a;this.first=b;this.Fa=c;this.count=d;this.v=e;this.m=65937646;this.D=8192}h=rd.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};h.ra=function(){return 1===this.count?null:this.Fa};h.ia=function(){return this.count};h.$a=function(){return this.first};h.ab=function(){return Ya(this)};h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){return Hc(this,b)};
h.ja=function(){return tb(oc,this.s)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return this.first};h.ua=function(){return 1===this.count?oc:this.Fa};h.ha=function(){return this};h.fa=function(a,b){return new rd(b,this.first,this.Fa,this.count,this.v)};h.ga=function(a,b){return new rd(this.s,b,this,this.count+1,null)};rd.prototype[Ha]=function(){return rc(this)};function sd(a){this.s=a;this.m=65937614;this.D=8192}h=sd.prototype;h.toString=function(){return Zb(this)};
h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};h.ra=function(){return null};h.ia=function(){return 0};h.$a=function(){return null};h.ab=function(){throw Error("Can't pop empty list");};h.N=function(){return uc};h.w=function(a,b){return Hc(this,b)};h.ja=function(){return this};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return null};h.ua=function(){return oc};h.ha=function(){return null};h.fa=function(a,b){return new sd(b)};
h.ga=function(a,b){return new rd(this.s,b,null,1,null)};var oc=new sd(null);sd.prototype[Ha]=function(){return rc(this)};function td(a){return(a?a.m&134217728||a.lc||(a.m?0:z(Cb,a)):z(Cb,a))?Db(a):Na(Oc,oc,a)}
function ud(){a:{var a=0<arguments.length?new M(Array.prototype.slice.call(arguments,0),0):null,b;if(a instanceof M&&0===a.u)b=a.c;else b:for(b=[];;)if(null!=a)b.push(a.oa(null)),a=a.ra(null);else break b;for(var a=b.length,c=oc;;)if(0<a)var d=a-1,c=c.ga(null,b[a-1]),a=d;else break a}return c}function wd(a,b,c,d){this.s=a;this.first=b;this.Fa=c;this.v=d;this.m=65929452;this.D=8192}h=wd.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};
h.ra=function(){return null==this.Fa?null:I(this.Fa)};h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(oc,this.s)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return this.first};h.ua=function(){return null==this.Fa?oc:this.Fa};h.ha=function(){return this};h.fa=function(a,b){return new wd(b,this.first,this.Fa,this.v)};h.ga=function(a,b){return new wd(null,b,this,this.v)};
wd.prototype[Ha]=function(){return rc(this)};function T(a,b){var c=null==b;return(c?c:b&&(b.m&64||b.Za))?new wd(null,a,b,null):new wd(null,a,I(b),null)}function W(a,b,c,d){this.Ta=a;this.name=b;this.ya=c;this.Na=d;this.m=2153775105;this.D=4096}h=W.prototype;h.toString=function(){return[C(":"),C(this.ya)].join("")};h.equiv=function(a){return this.w(null,a)};h.w=function(a,b){return b instanceof W?this.ya===b.ya:!1};
h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return Uc(c,this);case 3:return Vc(c,this,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return Uc(c,this)};a.i=function(a,c,d){return Vc(c,this,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return Uc(a,this)};h.b=function(a,b){return Vc(a,this,b)};
h.N=function(){var a=this.Na;return null!=a?a:this.Na=a=ic(dc(this.name),gc(this.Ta))+2654435769|0};h.Xa=function(){return this.name};h.Ya=function(){return this.Ta};h.L=function(a,b){return Eb(b,[C(":"),C(this.ya)].join(""))};function xd(a){if(a&&(a.D&4096||a.Rb))return a.Ya(null);throw Error([C("Doesn't support namespace: "),C(a)].join(""));}
var yd=function yd(){switch(arguments.length){case 1:return yd.a(arguments[0]);case 2:return yd.b(arguments[0],arguments[1]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}};yd.a=function(a){if(a instanceof W)return a;if(a instanceof G)return new W(xd(a),zd.a?zd.a(a):zd.call(null,a),a.Ka,null);if("string"===typeof a){var b=a.split("/");return 2===b.length?new W(b[0],b[1],a,null):new W(null,b[0],a,null)}return null};
yd.b=function(a,b){return new W(a,b,[C(y(a)?[C(a),C("/")].join(""):null),C(b)].join(""),null)};yd.C=2;function Ad(a,b,c,d){this.s=a;this.Qa=b;this.F=c;this.v=d;this.m=32374988;this.D=0}h=Ad.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};function Bd(a){null!=a.Qa&&(a.F=a.Qa.f?a.Qa.f():a.Qa.call(null),a.Qa=null);return a.F}h.P=function(){return this.s};h.ra=function(){Ab(this);return null==this.F?null:P(this.F)};
h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(oc,this.s)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){Ab(this);return null==this.F?null:N(this.F)};h.ua=function(){Ab(this);return null!=this.F?nc(this.F):oc};h.ha=function(){Bd(this);if(null==this.F)return null;for(var a=this.F;;)if(a instanceof Ad)a=Bd(a);else return this.F=a,I(this.F)};
h.fa=function(a,b){return new Ad(b,this.Qa,this.F,this.v)};h.ga=function(a,b){return T(b,this)};Ad.prototype[Ha]=function(){return rc(this)};function Cd(a,b){this.qb=a;this.end=b;this.m=2;this.D=0}Cd.prototype.add=function(a){this.qb[this.end]=a;return this.end+=1};Cd.prototype.ta=function(){var a=new Dd(this.qb,0,this.end);this.qb=null;return a};Cd.prototype.ia=function(){return this.end};function Ed(a){return new Cd(Array(a),0)}
function Dd(a,b,c){this.c=a;this.ka=b;this.end=c;this.m=524306;this.D=0}h=Dd.prototype;h.ia=function(){return this.end-this.ka};h.J=function(a,b){return this.c[this.ka+b]};h.va=function(a,b,c){return 0<=b&&b<this.end-this.ka?this.c[this.ka+b]:c};h.Bb=function(){if(this.ka===this.end)throw Error("-drop-first of empty chunk");return new Dd(this.c,this.ka+1,this.end)};h.ma=function(a,b){return Cc(this.c,b,this.c[this.ka],this.ka+1)};h.na=function(a,b,c){return Cc(this.c,b,c,this.ka)};
function Fd(a,b,c,d){this.ta=a;this.Da=b;this.s=c;this.v=d;this.m=31850732;this.D=1536}h=Fd.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};h.ra=function(){if(1<Sa(this.ta))return new Fd(Ob(this.ta),this.Da,this.s,null);var a=Ab(this.Da);return null==a?null:a};h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(oc,this.s)};
h.oa=function(){return D.b(this.ta,0)};h.ua=function(){return 1<Sa(this.ta)?new Fd(Ob(this.ta),this.Da,this.s,null):null==this.Da?oc:this.Da};h.ha=function(){return this};h.tb=function(){return this.ta};h.ub=function(){return null==this.Da?oc:this.Da};h.fa=function(a,b){return new Fd(this.ta,this.Da,b,this.v)};h.ga=function(a,b){return T(b,this)};h.sb=function(){return null==this.Da?null:this.Da};Fd.prototype[Ha]=function(){return rc(this)};
function Gd(a,b){return 0===Sa(a)?b:new Fd(a,b,null,null)}function Hd(a,b){a.add(b)}function Id(a){for(var b=[];;)if(I(a))b.push(N(a)),a=P(a);else return b}function Jd(a,b){if(Dc(a))return Qc(a);for(var c=a,d=b,e=0;;)if(0<d&&I(c))c=P(c),--d,e+=1;else return e}
var Kd=function Kd(b){return null==b?null:null==P(b)?I(N(b)):T(N(b),Kd(P(b)))},Ld=function Ld(){switch(arguments.length){case 0:return Ld.f();case 1:return Ld.a(arguments[0]);case 2:return Ld.b(arguments[0],arguments[1]);default:return Ld.o(arguments[0],arguments[1],new M(Array.prototype.slice.call(arguments,2),0))}};Ld.f=function(){return new Ad(null,function(){return null},null,null)};Ld.a=function(a){return new Ad(null,function(){return a},null,null)};
Ld.b=function(a,b){return new Ad(null,function(){var c=I(a);return c?ed(c)?Gd(Pb(c),Ld.b(Qb(c),b)):T(N(c),Ld.b(nc(c),b)):b},null,null)};Ld.o=function(a,b,c){return function e(a,b){return new Ad(null,function(){var c=I(a);return c?ed(c)?Gd(Pb(c),e(Qb(c),b)):T(N(c),e(nc(c),b)):y(b)?e(N(b),P(b)):null},null,null)}(Ld.b(a,b),c)};Ld.A=function(a){var b=N(a),c=P(a);a=N(c);c=P(c);return Ld.o(b,a,c)};Ld.C=2;function Md(a){return Lb(a)}
var Nd=function Nd(){switch(arguments.length){case 0:return Nd.f();case 1:return Nd.a(arguments[0]);case 2:return Nd.b(arguments[0],arguments[1]);default:return Nd.o(arguments[0],arguments[1],new M(Array.prototype.slice.call(arguments,2),0))}};Nd.f=function(){return Jb(Pc)};Nd.a=function(a){return a};Nd.b=function(a,b){return Kb(a,b)};Nd.o=function(a,b,c){for(;;)if(a=Kb(a,b),y(c))b=N(c),c=P(c);else return a};Nd.A=function(a){var b=N(a),c=P(a);a=N(c);c=P(c);return Nd.o(b,a,c)};Nd.C=2;
function Od(a,b,c){var d=I(c);if(0===b)return a.f?a.f():a.call(null);c=Xa(d);var e=Ya(d);if(1===b)return a.a?a.a(c):a.a?a.a(c):a.call(null,c);var d=Xa(e),f=Ya(e);if(2===b)return a.b?a.b(c,d):a.b?a.b(c,d):a.call(null,c,d);var e=Xa(f),g=Ya(f);if(3===b)return a.i?a.i(c,d,e):a.i?a.i(c,d,e):a.call(null,c,d,e);var f=Xa(g),k=Ya(g);if(4===b)return a.B?a.B(c,d,e,f):a.B?a.B(c,d,e,f):a.call(null,c,d,e,f);var g=Xa(k),l=Ya(k);if(5===b)return a.G?a.G(c,d,e,f,g):a.G?a.G(c,d,e,f,g):a.call(null,c,d,e,f,g);var k=Xa(l),
m=Ya(l);if(6===b)return a.M?a.M(c,d,e,f,g,k):a.M?a.M(c,d,e,f,g,k):a.call(null,c,d,e,f,g,k);var l=Xa(m),n=Ya(m);if(7===b)return a.ca?a.ca(c,d,e,f,g,k,l):a.ca?a.ca(c,d,e,f,g,k,l):a.call(null,c,d,e,f,g,k,l);var m=Xa(n),p=Ya(n);if(8===b)return a.da?a.da(c,d,e,f,g,k,l,m):a.da?a.da(c,d,e,f,g,k,l,m):a.call(null,c,d,e,f,g,k,l,m);var n=Xa(p),q=Ya(p);if(9===b)return a.ea?a.ea(c,d,e,f,g,k,l,m,n):a.ea?a.ea(c,d,e,f,g,k,l,m,n):a.call(null,c,d,e,f,g,k,l,m,n);var p=Xa(q),r=Ya(q);if(10===b)return a.S?a.S(c,d,e,f,
g,k,l,m,n,p):a.S?a.S(c,d,e,f,g,k,l,m,n,p):a.call(null,c,d,e,f,g,k,l,m,n,p);var q=Xa(r),t=Ya(r);if(11===b)return a.T?a.T(c,d,e,f,g,k,l,m,n,p,q):a.T?a.T(c,d,e,f,g,k,l,m,n,p,q):a.call(null,c,d,e,f,g,k,l,m,n,p,q);var r=Xa(t),v=Ya(t);if(12===b)return a.U?a.U(c,d,e,f,g,k,l,m,n,p,q,r):a.U?a.U(c,d,e,f,g,k,l,m,n,p,q,r):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r);var t=Xa(v),x=Ya(v);if(13===b)return a.V?a.V(c,d,e,f,g,k,l,m,n,p,q,r,t):a.V?a.V(c,d,e,f,g,k,l,m,n,p,q,r,t):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t);var v=
Xa(x),B=Ya(x);if(14===b)return a.W?a.W(c,d,e,f,g,k,l,m,n,p,q,r,t,v):a.W?a.W(c,d,e,f,g,k,l,m,n,p,q,r,t,v):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t,v);var x=Xa(B),E=Ya(B);if(15===b)return a.X?a.X(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x):a.X?a.X(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x);var B=Xa(E),F=Ya(E);if(16===b)return a.Y?a.Y(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B):a.Y?a.Y(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B);var E=Xa(F),Q=Ya(F);if(17===b)return a.Z?
a.Z(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E):a.Z?a.Z(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E);var F=Xa(Q),ha=Ya(Q);if(18===b)return a.$?a.$(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F):a.$?a.$(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F);Q=Xa(ha);ha=Ya(ha);if(19===b)return a.aa?a.aa(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q):a.aa?a.aa(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q);var u=Xa(ha);
Ya(ha);if(20===b)return a.ba?a.ba(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q,u):a.ba?a.ba(c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q,u):a.call(null,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q,u);throw Error("Only up to 20 arguments supported on functions");}
function lc(){switch(arguments.length){case 2:return Pd(arguments[0],arguments[1]);case 3:return Qd(arguments[0],arguments[1],arguments[2]);case 4:return Rd(arguments[0],arguments[1],arguments[2],arguments[3]);case 5:return Sd(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);default:return Td(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],new M(Array.prototype.slice.call(arguments,5),0))}}
function Pd(a,b){var c=a.C;if(a.A){var d=Jd(b,c+1);return d<=c?Od(a,d,b):a.A(b)}return a.apply(a,Id(b))}function Qd(a,b,c){b=T(b,c);c=a.C;if(a.A){var d=Jd(b,c+1);return d<=c?Od(a,d,b):a.A(b)}return a.apply(a,Id(b))}function Rd(a,b,c,d){b=T(b,T(c,d));c=a.C;return a.A?(d=Jd(b,c+1),d<=c?Od(a,d,b):a.A(b)):a.apply(a,Id(b))}function Sd(a,b,c,d,e){b=T(b,T(c,T(d,e)));c=a.C;return a.A?(d=Jd(b,c+1),d<=c?Od(a,d,b):a.A(b)):a.apply(a,Id(b))}
function Td(a,b,c,d,e,f){b=T(b,T(c,T(d,T(e,Kd(f)))));c=a.C;return a.A?(d=Jd(b,c+1),d<=c?Od(a,d,b):a.A(b)):a.apply(a,Id(b))}function Ud(a,b){for(;;){if(null==I(b))return!0;var c;c=N(b);c=a.a?a.a(c):a.call(null,c);if(y(c)){c=a;var d=P(b);a=c;b=d}else return!1}}function Vd(a,b){for(;;)if(I(b)){var c;c=N(b);c=a.a?a.a(c):a.call(null,c);if(y(c))return c;c=a;var d=P(b);a=c;b=d}else return null}
function Wd(a){return function(){function b(b,c){return Fa(a.b?a.b(b,c):a.call(null,b,c))}function c(b){return Fa(a.a?a.a(b):a.call(null,b))}function d(){return Fa(a.f?a.f():a.call(null))}var e=null,f=function(){function b(a,d,e){var f=null;if(2<arguments.length){for(var f=0,g=Array(arguments.length-2);f<g.length;)g[f]=arguments[f+2],++f;f=new M(g,0)}return c.call(this,a,d,f)}function c(b,d,e){return Fa(Rd(a,b,d,e))}b.C=2;b.A=function(a){var b=N(a);a=P(a);var d=N(a);a=nc(a);return c(b,d,a)};b.o=c;
return b}(),e=function(a,e,l){switch(arguments.length){case 0:return d.call(this);case 1:return c.call(this,a);case 2:return b.call(this,a,e);default:var m=null;if(2<arguments.length){for(var m=0,n=Array(arguments.length-2);m<n.length;)n[m]=arguments[m+2],++m;m=new M(n,0)}return f.o(a,e,m)}throw Error("Invalid arity: "+arguments.length);};e.C=2;e.A=f.A;e.f=d;e.a=c;e.b=b;e.o=f.o;return e}()}
var Xd=function Xd(){switch(arguments.length){case 0:return Xd.f();case 1:return Xd.a(arguments[0]);case 2:return Xd.b(arguments[0],arguments[1]);case 3:return Xd.i(arguments[0],arguments[1],arguments[2]);default:return Xd.o(arguments[0],arguments[1],arguments[2],new M(Array.prototype.slice.call(arguments,3),0))}};Xd.f=function(){return md};Xd.a=function(a){return a};
Xd.b=function(a,b){return function(){function c(c,d,e){c=b.i?b.i(c,d,e):b.call(null,c,d,e);return a.a?a.a(c):a.call(null,c)}function d(c,d){var e=b.b?b.b(c,d):b.call(null,c,d);return a.a?a.a(e):a.call(null,e)}function e(c){c=b.a?b.a(c):b.call(null,c);return a.a?a.a(c):a.call(null,c)}function f(){var c=b.f?b.f():b.call(null);return a.a?a.a(c):a.call(null,c)}var g=null,k=function(){function c(a,b,e,f){var g=null;if(3<arguments.length){for(var g=0,k=Array(arguments.length-3);g<k.length;)k[g]=arguments[g+
3],++g;g=new M(k,0)}return d.call(this,a,b,e,g)}function d(c,e,f,g){c=Sd(b,c,e,f,g);return a.a?a.a(c):a.call(null,c)}c.C=3;c.A=function(a){var b=N(a);a=P(a);var c=N(a);a=P(a);var e=N(a);a=nc(a);return d(b,c,e,a)};c.o=d;return c}(),g=function(a,b,g,p){switch(arguments.length){case 0:return f.call(this);case 1:return e.call(this,a);case 2:return d.call(this,a,b);case 3:return c.call(this,a,b,g);default:var q=null;if(3<arguments.length){for(var q=0,r=Array(arguments.length-3);q<r.length;)r[q]=arguments[q+
3],++q;q=new M(r,0)}return k.o(a,b,g,q)}throw Error("Invalid arity: "+arguments.length);};g.C=3;g.A=k.A;g.f=f;g.a=e;g.b=d;g.i=c;g.o=k.o;return g}()};
Xd.i=function(a,b,c){return function(){function d(d,e,f){d=c.i?c.i(d,e,f):c.call(null,d,e,f);d=b.a?b.a(d):b.call(null,d);return a.a?a.a(d):a.call(null,d)}function e(d,e){var f;f=c.b?c.b(d,e):c.call(null,d,e);f=b.a?b.a(f):b.call(null,f);return a.a?a.a(f):a.call(null,f)}function f(d){d=c.a?c.a(d):c.call(null,d);d=b.a?b.a(d):b.call(null,d);return a.a?a.a(d):a.call(null,d)}function g(){var d;d=c.f?c.f():c.call(null);d=b.a?b.a(d):b.call(null,d);return a.a?a.a(d):a.call(null,d)}var k=null,l=function(){function d(a,
b,c,f){var g=null;if(3<arguments.length){for(var g=0,k=Array(arguments.length-3);g<k.length;)k[g]=arguments[g+3],++g;g=new M(k,0)}return e.call(this,a,b,c,g)}function e(d,f,g,k){d=Sd(c,d,f,g,k);d=b.a?b.a(d):b.call(null,d);return a.a?a.a(d):a.call(null,d)}d.C=3;d.A=function(a){var b=N(a);a=P(a);var c=N(a);a=P(a);var d=N(a);a=nc(a);return e(b,c,d,a)};d.o=e;return d}(),k=function(a,b,c,k){switch(arguments.length){case 0:return g.call(this);case 1:return f.call(this,a);case 2:return e.call(this,a,b);
case 3:return d.call(this,a,b,c);default:var r=null;if(3<arguments.length){for(var r=0,t=Array(arguments.length-3);r<t.length;)t[r]=arguments[r+3],++r;r=new M(t,0)}return l.o(a,b,c,r)}throw Error("Invalid arity: "+arguments.length);};k.C=3;k.A=l.A;k.f=g;k.a=f;k.b=e;k.i=d;k.o=l.o;return k}()};
Xd.o=function(a,b,c,d){return function(a){return function(){function b(a){var d=null;if(0<arguments.length){for(var d=0,e=Array(arguments.length-0);d<e.length;)e[d]=arguments[d+0],++d;d=new M(e,0)}return c.call(this,d)}function c(b){b=Pd(N(a),b);for(var d=P(a);;)if(d)b=N(d).call(null,b),d=P(d);else return b}b.C=0;b.A=function(a){a=I(a);return c(a)};b.o=c;return b}()}(td(T(a,T(b,T(c,d)))))};Xd.A=function(a){var b=N(a),c=P(a);a=N(c);var d=P(c),c=N(d),d=P(d);return Xd.o(b,a,c,d)};Xd.C=3;
function Yd(a,b){return function(){function c(c,d,e){return a.B?a.B(b,c,d,e):a.call(null,b,c,d,e)}function d(c,d){return a.i?a.i(b,c,d):a.call(null,b,c,d)}function e(c){return a.b?a.b(b,c):a.call(null,b,c)}function f(){return a.a?a.a(b):a.call(null,b)}var g=null,k=function(){function c(a,b,e,f){var g=null;if(3<arguments.length){for(var g=0,k=Array(arguments.length-3);g<k.length;)k[g]=arguments[g+3],++g;g=new M(k,0)}return d.call(this,a,b,e,g)}function d(c,e,f,g){return Td(a,b,c,e,f,U([g],0))}c.C=
3;c.A=function(a){var b=N(a);a=P(a);var c=N(a);a=P(a);var e=N(a);a=nc(a);return d(b,c,e,a)};c.o=d;return c}(),g=function(a,b,g,p){switch(arguments.length){case 0:return f.call(this);case 1:return e.call(this,a);case 2:return d.call(this,a,b);case 3:return c.call(this,a,b,g);default:var q=null;if(3<arguments.length){for(var q=0,r=Array(arguments.length-3);q<r.length;)r[q]=arguments[q+3],++q;q=new M(r,0)}return k.o(a,b,g,q)}throw Error("Invalid arity: "+arguments.length);};g.C=3;g.A=k.A;g.f=f;g.a=e;
g.b=d;g.i=c;g.o=k.o;return g}()}
function Zd(){return function(){function a(a,b,c){a=null==a?0:a;return xc.i?xc.i(a,b,c):xc.call(null,a)}function b(a,b){var c=null==a?0:a;return xc.b?xc.b(c,b):xc.call(null,c)}function c(a){a=null==a?0:a;return xc.a?xc.a(a):xc.call(null,a)}var d=null,e=function(){function a(c,d,e,f){var p=null;if(3<arguments.length){for(var p=0,q=Array(arguments.length-3);p<q.length;)q[p]=arguments[p+3],++p;p=new M(q,0)}return b.call(this,c,d,e,p)}function b(a,c,d,e){return Sd(xc,null==a?0:a,c,d,e)}a.C=3;a.A=function(a){var c=
N(a);a=P(a);var d=N(a);a=P(a);var e=N(a);a=nc(a);return b(c,d,e,a)};a.o=b;return a}(),d=function(d,g,k,l){switch(arguments.length){case 1:return c.call(this,d);case 2:return b.call(this,d,g);case 3:return a.call(this,d,g,k);default:var m=null;if(3<arguments.length){for(var m=0,n=Array(arguments.length-3);m<n.length;)n[m]=arguments[m+3],++m;m=new M(n,0)}return e.o(d,g,k,m)}throw Error("Invalid arity: "+arguments.length);};d.C=3;d.A=e.A;d.a=c;d.b=b;d.i=a;d.o=e.o;return d}()}
function $d(a,b){return new Ad(null,function(){var c=I(b);if(c){if(ed(c)){for(var d=Pb(c),e=Qc(d),f=Ed(e),g=0;;)if(g<e){var k=function(){var b=D.b(d,g);return a.a?a.a(b):a.call(null,b)}();null!=k&&f.add(k);g+=1}else break;return Gd(f.ta(),$d(a,Qb(c)))}e=function(){var b=N(c);return a.a?a.a(b):a.call(null,b)}();return null==e?$d(a,nc(c)):T(e,$d(a,nc(c)))}return null},null,null)}function ae(a,b,c,d){this.state=a;this.s=b;this.hc=c;this.Mb=d;this.D=16386;this.m=6455296}h=ae.prototype;
h.equiv=function(a){return this.w(null,a)};h.w=function(a,b){return this===b};h.Va=function(){return this.state};h.P=function(){return this.s};h.Hb=function(a,b,c){for(var d=I(this.Mb),e=null,f=0,g=0;;)if(g<f){a=e.J(null,g);var k=Tc(a,0);a=Tc(a,1);var l=b,m=c;a.B?a.B(k,this,l,m):a.call(null,k,this,l,m);g+=1}else if(a=I(d))d=a,ed(d)?(e=Pb(d),d=Qb(d),a=e,f=Qc(e),e=a):(a=N(d),k=Tc(a,0),a=Tc(a,1),e=k,f=b,g=c,a.B?a.B(e,this,f,g):a.call(null,e,this,f,g),d=P(d),e=null,f=0),g=0;else return null};
h.N=function(){return this[da]||(this[da]=++ea)};function be(){switch(arguments.length){case 1:return ce(arguments[0]);default:var a=arguments[0],b=new M(Array.prototype.slice.call(arguments,1),0),c=id(b)?Pd(de,b):b,b=Uc(c,Aa),c=Uc(c,ee);return new ae(a,b,c,null)}}function ce(a){return new ae(a,null,null,null)}
function fe(a,b){if(a instanceof ae){var c=a.hc;if(null!=c&&!y(c.a?c.a(b):c.call(null,b)))throw Error([C("Assert failed: "),C("Validator rejected reference state"),C("\n"),C(function(){var a=ud(new G(null,"validate","validate",1439230700,null),new G(null,"new-value","new-value",-1567397401,null));return ge.a?ge.a(a):ge.call(null,a)}())].join(""));c=a.state;a.state=b;null!=a.Mb&&Ib(a,c,b);return b}return Ub(a,b)}
var he=function he(){switch(arguments.length){case 2:return he.b(arguments[0],arguments[1]);case 3:return he.i(arguments[0],arguments[1],arguments[2]);case 4:return he.B(arguments[0],arguments[1],arguments[2],arguments[3]);default:return he.o(arguments[0],arguments[1],arguments[2],arguments[3],new M(Array.prototype.slice.call(arguments,4),0))}};he.b=function(a,b){var c;a instanceof ae?(c=a.state,c=b.a?b.a(c):b.call(null,c),c=fe(a,c)):c=Vb.b(a,b);return c};
he.i=function(a,b,c){if(a instanceof ae){var d=a.state;b=b.b?b.b(d,c):b.call(null,d,c);a=fe(a,b)}else a=Vb.i(a,b,c);return a};he.B=function(a,b,c,d){if(a instanceof ae){var e=a.state;b=b.i?b.i(e,c,d):b.call(null,e,c,d);a=fe(a,b)}else a=Vb.B(a,b,c,d);return a};he.o=function(a,b,c,d,e){return a instanceof ae?fe(a,Sd(b,a.state,c,d,e)):Vb.G(a,b,c,d,e)};he.A=function(a){var b=N(a),c=P(a);a=N(c);var d=P(c),c=N(d),e=P(d),d=N(e),e=P(e);return he.o(b,a,c,d,e)};he.C=4;
function ie(a){this.state=a;this.m=32768;this.D=0}ie.prototype.Gb=function(a,b){return this.state=b};ie.prototype.Va=function(){return this.state};
var je=function je(){switch(arguments.length){case 1:return je.a(arguments[0]);case 2:return je.b(arguments[0],arguments[1]);case 3:return je.i(arguments[0],arguments[1],arguments[2]);case 4:return je.B(arguments[0],arguments[1],arguments[2],arguments[3]);default:return je.o(arguments[0],arguments[1],arguments[2],arguments[3],new M(Array.prototype.slice.call(arguments,4),0))}};
je.a=function(a){return function(b){return function(){function c(c,d){var e=a.a?a.a(d):a.call(null,d);return b.b?b.b(c,e):b.call(null,c,e)}function d(a){return b.a?b.a(a):b.call(null,a)}function e(){return b.f?b.f():b.call(null)}var f=null,g=function(){function c(a,b,e){var f=null;if(2<arguments.length){for(var f=0,g=Array(arguments.length-2);f<g.length;)g[f]=arguments[f+2],++f;f=new M(g,0)}return d.call(this,a,b,f)}function d(c,e,f){e=Qd(a,e,f);return b.b?b.b(c,e):b.call(null,c,e)}c.C=2;c.A=function(a){var b=
N(a);a=P(a);var c=N(a);a=nc(a);return d(b,c,a)};c.o=d;return c}(),f=function(a,b,f){switch(arguments.length){case 0:return e.call(this);case 1:return d.call(this,a);case 2:return c.call(this,a,b);default:var n=null;if(2<arguments.length){for(var n=0,p=Array(arguments.length-2);n<p.length;)p[n]=arguments[n+2],++n;n=new M(p,0)}return g.o(a,b,n)}throw Error("Invalid arity: "+arguments.length);};f.C=2;f.A=g.A;f.f=e;f.a=d;f.b=c;f.o=g.o;return f}()}};
je.b=function(a,b){return new Ad(null,function(){var c=I(b);if(c){if(ed(c)){for(var d=Pb(c),e=Qc(d),f=Ed(e),g=0;;)if(g<e)Hd(f,function(){var b=D.b(d,g);return a.a?a.a(b):a.call(null,b)}()),g+=1;else break;return Gd(f.ta(),je.b(a,Qb(c)))}return T(function(){var b=N(c);return a.a?a.a(b):a.call(null,b)}(),je.b(a,nc(c)))}return null},null,null)};
je.i=function(a,b,c){return new Ad(null,function(){var d=I(b),e=I(c);if(d&&e){var f=T,g;g=N(d);var k=N(e);g=a.b?a.b(g,k):a.call(null,g,k);d=f(g,je.i(a,nc(d),nc(e)))}else d=null;return d},null,null)};je.B=function(a,b,c,d){return new Ad(null,function(){var e=I(b),f=I(c),g=I(d);if(e&&f&&g){var k=T,l;l=N(e);var m=N(f),n=N(g);l=a.i?a.i(l,m,n):a.call(null,l,m,n);e=k(l,je.B(a,nc(e),nc(f),nc(g)))}else e=null;return e},null,null)};
je.o=function(a,b,c,d,e){var f=function k(a){return new Ad(null,function(){var b=je.b(I,a);return Ud(md,b)?T(je.b(N,b),k(je.b(nc,b))):null},null,null)};return je.b(function(){return function(b){return Pd(a,b)}}(f),f(Oc.o(e,d,U([c,b],0))))};je.A=function(a){var b=N(a),c=P(a);a=N(c);var d=P(c),c=N(d),e=P(d),d=N(e),e=P(e);return je.o(b,a,c,d,e)};je.C=4;function ke(a,b){return new Ad(null,function(){if(0<a){var c=I(b);return c?T(N(c),ke(a-1,nc(c))):null}return null},null,null)}
function le(a,b){return new Ad(null,function(c){return function(){return c(a,b)}}(function(a,b){for(;;){var e=I(b);if(0<a&&e){var f=a-1,e=nc(e);a=f;b=e}else return e}}),null,null)}function me(a){return new Ad(null,function(){return T(a,me(a))},null,null)}var ne=function ne(){switch(arguments.length){case 2:return ne.b(arguments[0],arguments[1]);default:return ne.o(arguments[0],arguments[1],new M(Array.prototype.slice.call(arguments,2),0))}};
ne.b=function(a,b){return new Ad(null,function(){var c=I(a),d=I(b);return c&&d?T(N(c),T(N(d),ne.b(nc(c),nc(d)))):null},null,null)};ne.o=function(a,b,c){return new Ad(null,function(){var d=je.b(I,Oc.o(c,b,U([a],0)));return Ud(md,d)?Ld.b(je.b(N,d),Pd(ne,je.b(nc,d))):null},null,null)};ne.A=function(a){var b=N(a),c=P(a);a=N(c);c=P(c);return ne.o(b,a,c)};ne.C=2;function oe(){var a=td(pe.a(qe()));return le(1,ne.b(me(" "),a))}function re(a,b){return Pd(Ld,Qd(je,a,b))}
function se(a,b){return new Ad(null,function(){var c=I(b);if(c){if(ed(c)){for(var d=Pb(c),e=Qc(d),f=Ed(e),g=0;;)if(g<e){var k;k=D.b(d,g);k=a.a?a.a(k):a.call(null,k);y(k)&&(k=D.b(d,g),f.add(k));g+=1}else break;return Gd(f.ta(),se(a,Qb(c)))}d=N(c);c=nc(c);return y(a.a?a.a(d):a.call(null,d))?T(d,se(a,c)):se(a,c)}return null},null,null)}function te(a,b){return se(Wd(a),b)}
function ue(a,b,c){return new Ad(null,function(){var d=I(c);if(d){var e=ke(a,d);return a===Qc(e)?T(e,ue(a,b,le(b,d))):null}return null},null,null)}function ve(a,b){var c;a:{c=hd;for(var d=a,e=I(b);;)if(e){var f=d;if(f?f.m&256||f.Db||(f.m?0:z(ab,f)):z(ab,f)){d=Vc(d,N(e),c);if(c===d){c=null;break a}e=P(e)}else{c=null;break a}}else{c=d;break a}}return c}
var we=function we(){switch(arguments.length){case 3:return we.i(arguments[0],arguments[1],arguments[2]);case 4:return we.B(arguments[0],arguments[1],arguments[2],arguments[3]);case 5:return we.G(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);case 6:return we.M(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);default:return we.o(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],new M(Array.prototype.slice.call(arguments,
6),0))}};we.i=function(a,b,c){var d=Tc(b,0);b=qd(b);return y(b)?Wc.i(a,d,we.i(Uc(a,d),b,c)):Wc.i(a,d,function(){var b=Uc(a,d);return c.a?c.a(b):c.call(null,b)}())};we.B=function(a,b,c,d){var e=Tc(b,0);b=qd(b);return y(b)?Wc.i(a,e,we.B(Uc(a,e),b,c,d)):Wc.i(a,e,function(){var b=Uc(a,e);return c.b?c.b(b,d):c.call(null,b,d)}())};we.G=function(a,b,c,d,e){var f=Tc(b,0);b=qd(b);return y(b)?Wc.i(a,f,we.G(Uc(a,f),b,c,d,e)):Wc.i(a,f,function(){var b=Uc(a,f);return c.i?c.i(b,d,e):c.call(null,b,d,e)}())};
we.M=function(a,b,c,d,e,f){var g=Tc(b,0);b=qd(b);return y(b)?Wc.i(a,g,we.M(Uc(a,g),b,c,d,e,f)):Wc.i(a,g,function(){var b=Uc(a,g);return c.B?c.B(b,d,e,f):c.call(null,b,d,e,f)}())};we.o=function(a,b,c,d,e,f,g){var k=Tc(b,0);b=qd(b);return y(b)?Wc.i(a,k,Td(we,Uc(a,k),b,c,d,U([e,f,g],0))):Wc.i(a,k,Td(c,Uc(a,k),d,e,f,U([g],0)))};we.A=function(a){var b=N(a),c=P(a);a=N(c);var d=P(c),c=N(d),e=P(d),d=N(e),f=P(e),e=N(f),g=P(f),f=N(g),g=P(g);return we.o(b,a,c,d,e,f,g)};we.C=6;
function xe(a,b){this.H=a;this.c=b}function ye(a){return new xe(a,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])}function ze(a){return new xe(a.H,Ia(a.c))}function Ae(a){a=a.l;return 32>a?0:a-1>>>5<<5}function Be(a,b,c){for(;;){if(0===b)return c;var d=ye(a);d.c[0]=c;c=d;b-=5}}
var Ce=function Ce(b,c,d,e){var f=ze(d),g=b.l-1>>>c&31;5===c?f.c[g]=e:(d=d.c[g],b=null!=d?Ce(b,c-5,d,e):Be(null,c-5,e),f.c[g]=b);return f};function De(a,b){throw Error([C("No item "),C(a),C(" in vector of length "),C(b)].join(""));}function Ee(a,b){if(b>=Ae(a))return a.qa;for(var c=a.root,d=a.shift;;)if(0<d)var e=d-5,c=c.c[b>>>d&31],d=e;else return c.c}function Fe(a,b){return 0<=b&&b<a.l?Ee(a,b):De(b,a.l)}
var Ge=function Ge(b,c,d,e,f){var g=ze(d);if(0===c)g.c[e&31]=f;else{var k=e>>>c&31;b=Ge(b,c-5,d.c[k],e,f);g.c[k]=b}return g},He=function He(b,c,d){var e=b.l-2>>>c&31;if(5<c){b=He(b,c-5,d.c[e]);if(null==b&&0===e)return null;d=ze(d);d.c[e]=b;return d}if(0===e)return null;d=ze(d);d.c[e]=null;return d};function Ie(a,b,c,d,e,f){this.u=a;this.pb=b;this.c=c;this.Ba=d;this.start=e;this.end=f}Ie.prototype.zb=function(){return this.u<this.end};
Ie.prototype.next=function(){32===this.u-this.pb&&(this.c=Ee(this.Ba,this.u),this.pb+=32);var a=this.c[this.u&31];this.u+=1;return a};function X(a,b,c,d,e,f){this.s=a;this.l=b;this.shift=c;this.root=d;this.qa=e;this.v=f;this.m=167668511;this.D=8196}h=X.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.O=function(a,b){return cb.i(this,b,null)};h.K=function(a,b,c){return"number"===typeof b?D.i(this,b,c):c};h.J=function(a,b){return Fe(this,b)[b&31]};
h.va=function(a,b,c){return 0<=b&&b<this.l?Ee(this,b)[b&31]:c};h.yb=function(a,b,c){if(0<=b&&b<this.l)return Ae(this)<=b?(a=Ia(this.qa),a[b&31]=c,new X(this.s,this.l,this.shift,this.root,a,null)):new X(this.s,this.l,this.shift,Ge(this,this.shift,this.root,b,c),this.qa,null);if(b===this.l)return Ua(this,c);throw Error([C("Index "),C(b),C(" out of bounds  [0,"),C(this.l),C("]")].join(""));};h.kb=function(){var a=this.l;return new Ie(0,0,0<Qc(this)?Ee(this,0):null,this,0,a)};h.P=function(){return this.s};
h.ia=function(){return this.l};h.wb=function(){return D.b(this,0)};h.xb=function(){return D.b(this,1)};h.$a=function(){return 0<this.l?D.b(this,this.l-1):null};
h.ab=function(){if(0===this.l)throw Error("Can't pop empty vector");if(1===this.l)return tb(Pc,this.s);if(1<this.l-Ae(this))return new X(this.s,this.l-1,this.shift,this.root,this.qa.slice(0,-1),null);var a=Ee(this,this.l-2),b=He(this,this.shift,this.root),b=null==b?Z:b,c=this.l-1;return 5<this.shift&&null==b.c[1]?new X(this.s,c,this.shift-5,b.c[0],a,null):new X(this.s,c,this.shift,b,a,null)};h.mb=function(){return 0<this.l?new Gc(this,this.l-1,null):null};
h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){if(b instanceof X)if(this.l===Qc(b))for(var c=Xb(this),d=Xb(b);;)if(y(c.zb())){var e=c.next(),f=d.next();if(!pc.b(e,f))return!1}else return!0;else return!1;else return Hc(this,b)};h.Oa=function(){var a=this;return new Je(a.l,a.shift,function(){var b=a.root;return Ke.a?Ke.a(b):Ke.call(null,b)}(),function(){var b=a.qa;return Le.a?Le.a(b):Le.call(null,b)}())};h.ja=function(){return Jc(Pc,this.s)};
h.ma=function(a,b){return yc(this,b)};h.na=function(a,b,c){a=0;for(var d=c;;)if(a<this.l){var e=Ee(this,a);c=e.length;a:for(var f=0;;)if(f<c)var g=e[f],d=b.b?b.b(d,g):b.call(null,d,g),f=f+1;else{e=d;break a}a+=c;d=e}else return d};h.Ua=function(a,b,c){if("number"===typeof b)return ob(this,b,c);throw Error("Vector's key for assoc must be a number.");};
h.ha=function(){if(0===this.l)return null;if(32>=this.l)return new M(this.qa,0);var a;a:{a=this.root;for(var b=this.shift;;)if(0<b)b-=5,a=a.c[0];else{a=a.c;break a}}return Me?Me(this,a,0,0):Ne.call(null,this,a,0,0)};h.fa=function(a,b){return new X(b,this.l,this.shift,this.root,this.qa,this.v)};
h.ga=function(a,b){if(32>this.l-Ae(this)){for(var c=this.qa.length,d=Array(c+1),e=0;;)if(e<c)d[e]=this.qa[e],e+=1;else break;d[c]=b;return new X(this.s,this.l+1,this.shift,this.root,d,null)}c=(d=this.l>>>5>1<<this.shift)?this.shift+5:this.shift;d?(d=ye(null),d.c[0]=this.root,e=Be(null,this.shift,new xe(null,this.qa)),d.c[1]=e):d=Ce(this,this.shift,this.root,new xe(null,this.qa));return new X(this.s,this.l+1,c,d,[b],null)};
h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.J(null,c);case 3:return this.va(null,c,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return this.J(null,c)};a.i=function(a,c,d){return this.va(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return this.J(null,a)};h.b=function(a,b){return this.va(null,a,b)};
var Z=new xe(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]),Pc=new X(null,0,5,Z,[],uc);X.prototype[Ha]=function(){return rc(this)};function Oe(a){if(Ea(a))a:{var b=a.length;if(32>b)a=new X(null,b,5,Z,a,null);else for(var c=32,d=(new X(null,32,5,Z,a.slice(0,32),null)).Oa(null);;)if(c<b)var e=c+1,d=Nd.b(d,a[c]),c=e;else{a=Lb(d);break a}}else a=Lb(Na(Kb,Jb(Pc),a));return a}
function Pe(a,b,c,d,e,f){this.xa=a;this.node=b;this.u=c;this.ka=d;this.s=e;this.v=f;this.m=32375020;this.D=1536}h=Pe.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};h.ra=function(){if(this.ka+1<this.node.length){var a;a=this.xa;var b=this.node,c=this.u,d=this.ka+1;a=Me?Me(a,b,c,d):Ne.call(null,a,b,c,d);return null==a?null:a}return Rb(this)};h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};
h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(Pc,this.s)};h.ma=function(a,b){var c;c=this.xa;var d=this.u+this.ka,e=Qc(this.xa);c=Qe?Qe(c,d,e):Re.call(null,c,d,e);return yc(c,b)};h.na=function(a,b,c){a=this.xa;var d=this.u+this.ka,e=Qc(this.xa);a=Qe?Qe(a,d,e):Re.call(null,a,d,e);return zc(a,b,c)};h.oa=function(){return this.node[this.ka]};
h.ua=function(){if(this.ka+1<this.node.length){var a;a=this.xa;var b=this.node,c=this.u,d=this.ka+1;a=Me?Me(a,b,c,d):Ne.call(null,a,b,c,d);return null==a?oc:a}return Qb(this)};h.ha=function(){return this};h.tb=function(){var a=this.node;return new Dd(a,this.ka,a.length)};h.ub=function(){var a=this.u+this.node.length;if(a<Sa(this.xa)){var b=this.xa,c=Ee(this.xa,a);return Me?Me(b,c,a,0):Ne.call(null,b,c,a,0)}return oc};
h.fa=function(a,b){var c=this.xa,d=this.node,e=this.u,f=this.ka;return Se?Se(c,d,e,f,b):Ne.call(null,c,d,e,f,b)};h.ga=function(a,b){return T(b,this)};h.sb=function(){var a=this.u+this.node.length;if(a<Sa(this.xa)){var b=this.xa,c=Ee(this.xa,a);return Me?Me(b,c,a,0):Ne.call(null,b,c,a,0)}return null};Pe.prototype[Ha]=function(){return rc(this)};
function Ne(){switch(arguments.length){case 3:var a=arguments[0],b=arguments[1],c=arguments[2];return new Pe(a,Fe(a,b),b,c,null,null);case 4:return Me(arguments[0],arguments[1],arguments[2],arguments[3]);case 5:return Se(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function Me(a,b,c,d){return new Pe(a,b,c,d,null,null)}function Se(a,b,c,d,e){return new Pe(a,b,c,d,e,null)}
function Te(a,b,c,d,e){this.s=a;this.Ba=b;this.start=c;this.end=d;this.v=e;this.m=167666463;this.D=8192}h=Te.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.O=function(a,b){return cb.i(this,b,null)};h.K=function(a,b,c){return"number"===typeof b?D.i(this,b,c):c};h.J=function(a,b){return 0>b||this.end<=this.start+b?De(b,this.end-this.start):D.b(this.Ba,this.start+b)};h.va=function(a,b,c){return 0>b||this.end<=this.start+b?c:D.i(this.Ba,this.start+b,c)};
h.yb=function(a,b,c){var d=this.start+b;a=this.s;c=Wc.i(this.Ba,d,c);b=this.start;var e=this.end,d=d+1,d=e>d?e:d;return Ue.G?Ue.G(a,c,b,d,null):Ue.call(null,a,c,b,d,null)};h.P=function(){return this.s};h.ia=function(){return this.end-this.start};h.$a=function(){return D.b(this.Ba,this.end-1)};h.ab=function(){if(this.start===this.end)throw Error("Can't pop empty vector");var a=this.s,b=this.Ba,c=this.start,d=this.end-1;return Ue.G?Ue.G(a,b,c,d,null):Ue.call(null,a,b,c,d,null)};
h.mb=function(){return this.start!==this.end?new Gc(this,this.end-this.start-1,null):null};h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(Pc,this.s)};h.ma=function(a,b){return yc(this,b)};h.na=function(a,b,c){return zc(this,b,c)};h.Ua=function(a,b,c){if("number"===typeof b)return ob(this,b,c);throw Error("Subvec's key for assoc must be a number.");};
h.ha=function(){var a=this;return function(b){return function d(e){return e===a.end?null:T(D.b(a.Ba,e),new Ad(null,function(){return function(){return d(e+1)}}(b),null,null))}}(this)(a.start)};h.fa=function(a,b){var c=this.Ba,d=this.start,e=this.end,f=this.v;return Ue.G?Ue.G(b,c,d,e,f):Ue.call(null,b,c,d,e,f)};h.ga=function(a,b){var c=this.s,d=ob(this.Ba,this.end,b),e=this.start,f=this.end+1;return Ue.G?Ue.G(c,d,e,f,null):Ue.call(null,c,d,e,f,null)};
h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.J(null,c);case 3:return this.va(null,c,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return this.J(null,c)};a.i=function(a,c,d){return this.va(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return this.J(null,a)};h.b=function(a,b){return this.va(null,a,b)};Te.prototype[Ha]=function(){return rc(this)};
function Ue(a,b,c,d,e){for(;;)if(b instanceof Te)c=b.start+c,d=b.start+d,b=b.Ba;else{var f=Qc(b);if(0>c||0>d||c>f||d>f)throw Error("Index out of bounds");return new Te(a,b,c,d,e)}}function Re(){switch(arguments.length){case 2:var a=arguments[0];return Qe(a,arguments[1],Qc(a));case 3:return Qe(arguments[0],arguments[1],arguments[2]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function Qe(a,b,c){return Ue(null,a,b,c,null)}
function Ve(a,b){return a===b.H?b:new xe(a,Ia(b.c))}function Ke(a){return new xe({},Ia(a.c))}function Le(a){var b=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];gd(a,0,b,0,a.length);return b}var We=function We(b,c,d,e){d=Ve(b.root.H,d);var f=b.l-1>>>c&31;if(5===c)b=e;else{var g=d.c[f];b=null!=g?We(b,c-5,g,e):Be(b.root.H,c-5,e)}d.c[f]=b;return d};
function Je(a,b,c,d){this.l=a;this.shift=b;this.root=c;this.qa=d;this.D=88;this.m=275}h=Je.prototype;
h.cb=function(a,b){if(this.root.H){if(32>this.l-Ae(this))this.qa[this.l&31]=b;else{var c=new xe(this.root.H,this.qa),d=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];d[0]=b;this.qa=d;if(this.l>>>5>1<<this.shift){var d=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null],e=this.shift+
5;d[0]=this.root;d[1]=Be(this.root.H,this.shift,c);this.root=new xe(this.root.H,d);this.shift=e}else this.root=We(this,this.shift,this.root,c)}this.l+=1;return this}throw Error("conj! after persistent!");};h.eb=function(){if(this.root.H){this.root.H=null;var a=this.l-Ae(this),b=Array(a);gd(this.qa,0,b,0,a);return new X(null,this.l,this.shift,this.root,b,null)}throw Error("persistent! called twice");};
h.bb=function(a,b,c){if("number"===typeof b)return Nb(this,b,c);throw Error("TransientVector's key for assoc! must be a number.");};
h.Fb=function(a,b,c){var d=this;if(d.root.H){if(0<=b&&b<d.l)return Ae(this)<=b?d.qa[b&31]=c:(a=function(){return function f(a,k){var l=Ve(d.root.H,k);if(0===a)l.c[b&31]=c;else{var m=b>>>a&31,n=f(a-5,l.c[m]);l.c[m]=n}return l}}(this).call(null,d.shift,d.root),d.root=a),this;if(b===d.l)return Kb(this,c);throw Error([C("Index "),C(b),C(" out of bounds for TransientVector of length"),C(d.l)].join(""));}throw Error("assoc! after persistent!");};
h.ia=function(){if(this.root.H)return this.l;throw Error("count after persistent!");};h.J=function(a,b){if(this.root.H)return Fe(this,b)[b&31];throw Error("nth after persistent!");};h.va=function(a,b,c){return 0<=b&&b<this.l?D.b(this,b):c};h.O=function(a,b){return cb.i(this,b,null)};h.K=function(a,b,c){return"number"===typeof b?D.i(this,b,c):c};
h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.O(null,c);case 3:return this.K(null,c,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return this.O(null,c)};a.i=function(a,c,d){return this.K(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return this.O(null,a)};h.b=function(a,b){return this.K(null,a,b)};function Xe(){this.m=2097152;this.D=0}
Xe.prototype.equiv=function(a){return this.w(null,a)};Xe.prototype.w=function(){return!1};var Ye=new Xe;function Ze(a,b){return jd(cd(b)?Qc(a)===Qc(b)?Ud(md,je.b(function(a){return pc.b(Vc(b,N(a),Ye),Nc(a))},a)):null:null)}function $e(a){this.F=a}$e.prototype.next=function(){if(null!=this.F){var a=N(this.F),b=Tc(a,0),a=Tc(a,1);this.F=P(this.F);return{value:[b,a],done:!1}}return{value:null,done:!0}};function af(a){return new $e(I(a))}function bf(a){this.F=a}
bf.prototype.next=function(){if(null!=this.F){var a=N(this.F);this.F=P(this.F);return{value:[a,a],done:!1}}return{value:null,done:!0}};
function cf(a,b){var c;if(b instanceof W)a:{c=a.length;for(var d=b.ya,e=0;;){if(c<=e){c=-1;break a}var f=a[e];if(f instanceof W&&d===f.ya){c=e;break a}e+=2}}else if(c="string"==typeof b,y(y(c)?c:"number"===typeof b))a:for(c=a.length,d=0;;){if(c<=d){c=-1;break a}if(b===a[d]){c=d;break a}d+=2}else if(b instanceof G)a:for(c=a.length,d=b.Ka,e=0;;){if(c<=e){c=-1;break a}f=a[e];if(f instanceof G&&d===f.Ka){c=e;break a}e+=2}else if(null==b)a:for(c=a.length,d=0;;){if(c<=d){c=-1;break a}if(null==a[d]){c=d;
break a}d+=2}else a:for(c=a.length,d=0;;){if(c<=d){c=-1;break a}if(pc.b(b,a[d])){c=d;break a}d+=2}return c}function df(a,b,c){this.c=a;this.u=b;this.la=c;this.m=32374990;this.D=0}h=df.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.la};h.ra=function(){return this.u<this.c.length-2?new df(this.c,this.u+2,this.la):null};h.ia=function(){return(this.c.length-this.u)/2};h.N=function(){return tc(this)};
h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(oc,this.la)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return new X(null,2,5,Z,[this.c[this.u],this.c[this.u+1]],null)};h.ua=function(){return this.u<this.c.length-2?new df(this.c,this.u+2,this.la):oc};h.ha=function(){return this};h.fa=function(a,b){return new df(this.c,this.u,b)};h.ga=function(a,b){return T(b,this)};df.prototype[Ha]=function(){return rc(this)};
function ef(a,b,c){this.c=a;this.u=b;this.l=c}ef.prototype.zb=function(){return this.u<this.l};ef.prototype.next=function(){var a=new X(null,2,5,Z,[this.c[this.u],this.c[this.u+1]],null);this.u+=2;return a};function xa(a,b,c,d){this.s=a;this.l=b;this.c=c;this.v=d;this.m=16647951;this.D=8196}h=xa.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.keys=function(){return rc(ff.a?ff.a(this):ff.call(null,this))};h.entries=function(){return af(I(this))};
h.values=function(){return rc(gf.a?gf.a(this):gf.call(null,this))};h.has=function(a){return kd(this,a)};h.get=function(a,b){return this.K(null,a,b)};h.forEach=function(a){for(var b=I(this),c=null,d=0,e=0;;)if(e<d){var f=c.J(null,e),g=Tc(f,0),f=Tc(f,1);a.b?a.b(f,g):a.call(null,f,g);e+=1}else if(b=I(b))ed(b)?(c=Pb(b),b=Qb(b),g=c,d=Qc(c),c=g):(c=N(b),g=Tc(c,0),c=f=Tc(c,1),a.b?a.b(c,g):a.call(null,c,g),b=P(b),c=null,d=0),e=0;else return null};h.O=function(a,b){return cb.i(this,b,null)};
h.K=function(a,b,c){a=cf(this.c,b);return-1===a?c:this.c[a+1]};h.kb=function(){return new ef(this.c,0,2*this.l)};h.P=function(){return this.s};h.ia=function(){return this.l};h.N=function(){var a=this.v;return null!=a?a:this.v=a=vc(this)};h.w=function(a,b){if(b&&(b.m&1024||b.Ob)){var c=this.c.length;if(this.l===b.ia(null))for(var d=0;;)if(d<c){var e=b.K(null,this.c[d],hd);if(e!==hd)if(pc.b(this.c[d+1],e))d+=2;else return!1;else return!1}else return!0;else return!1}else return Ze(this,b)};
h.Oa=function(){return new hf({},this.c.length,Ia(this.c))};h.ja=function(){return tb(jf,this.s)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.vb=function(a,b){if(0<=cf(this.c,b)){var c=this.c.length,d=c-2;if(0===d)return Ta(this);for(var d=Array(d),e=0,f=0;;){if(e>=c)return new xa(this.s,this.l-1,d,null);pc.b(b,this.c[e])||(d[f]=this.c[e],d[f+1]=this.c[e+1],f+=2);e+=2}}else return this};
h.Ua=function(a,b,c){a=cf(this.c,b);if(-1===a){if(this.l<kf){a=this.c;for(var d=a.length,e=Array(d+2),f=0;;)if(f<d)e[f]=a[f],f+=1;else break;e[d]=b;e[d+1]=c;return new xa(this.s,this.l+1,e,null)}a=lf;a=null!=a?a&&(a.D&4||a.jc)?Jc(Md(Na(Kb,Jb(a),this)),ad(a)):Na(Ua,a,this):Na(Oc,oc,this);return tb(eb(a,b,c),this.s)}if(c===this.c[a+1])return this;b=Ia(this.c);b[a+1]=c;return new xa(this.s,this.l,b,null)};h.rb=function(a,b){return-1!==cf(this.c,b)};
h.ha=function(){var a=this.c;return 0<=a.length-2?new df(a,0,null):null};h.fa=function(a,b){return new xa(b,this.l,this.c,this.v)};h.ga=function(a,b){if(dd(b))return eb(this,D.b(b,0),D.b(b,1));for(var c=this,d=I(b);;){if(null==d)return c;var e=N(d);if(dd(e))c=eb(c,D.b(e,0),D.b(e,1)),d=P(d);else throw Error("conj on a map takes map entries or seqables of map entries");}};
h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.O(null,c);case 3:return this.K(null,c,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return this.O(null,c)};a.i=function(a,c,d){return this.K(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return this.O(null,a)};h.b=function(a,b){return this.K(null,a,b)};var jf=new xa(null,0,[],wc),kf=8;xa.prototype[Ha]=function(){return rc(this)};
function hf(a,b,c){this.Pa=a;this.Sa=b;this.c=c;this.m=258;this.D=56}h=hf.prototype;h.ia=function(){if(y(this.Pa))return od(this.Sa);throw Error("count after persistent!");};h.O=function(a,b){return cb.i(this,b,null)};h.K=function(a,b,c){if(y(this.Pa))return a=cf(this.c,b),-1===a?c:this.c[a+1];throw Error("lookup after persistent!");};
h.cb=function(a,b){if(y(this.Pa)){if(b?b.m&2048||b.Pb||(b.m?0:z(hb,b)):z(hb,b))return Mb(this,mf.a?mf.a(b):mf.call(null,b),nf.a?nf.a(b):nf.call(null,b));for(var c=I(b),d=this;;){var e=N(c);if(y(e))var f=e,c=P(c),d=Mb(d,function(){var a=f;return mf.a?mf.a(a):mf.call(null,a)}(),function(){var a=f;return nf.a?nf.a(a):nf.call(null,a)}());else return d}}else throw Error("conj! after persistent!");};
h.eb=function(){if(y(this.Pa))return this.Pa=!1,new xa(null,od(this.Sa),this.c,null);throw Error("persistent! called twice");};h.bb=function(a,b,c){if(y(this.Pa)){a=cf(this.c,b);if(-1===a){if(this.Sa+2<=2*kf)return this.Sa+=2,this.c.push(b),this.c.push(c),this;a=this.Sa;var d=this.c;a=of.b?of.b(a,d):of.call(null,a,d);return Mb(a,b,c)}c!==this.c[a+1]&&(this.c[a+1]=c);return this}throw Error("assoc! after persistent!");};
function of(a,b){for(var c=Jb(lf),d=0;;)if(d<a)c=Mb(c,b[d],b[d+1]),d+=2;else return c}function pf(){this.g=!1}function qf(a,b){return a===b?!0:a===b||a instanceof W&&b instanceof W&&a.ya===b.ya?!0:pc.b(a,b)}function rf(a,b,c){a=Ia(a);a[b]=c;return a}function sf(a,b){var c=Array(a.length-2);gd(a,0,c,0,2*b);gd(a,2*(b+1),c,2*b,c.length-2*b);return c}function tf(a,b,c,d){a=a.Ma(b);a.c[c]=d;return a}function uf(a,b,c){this.H=a;this.I=b;this.c=c}h=uf.prototype;
h.Ma=function(a){if(a===this.H)return this;var b=pd(this.I),c=Array(0>b?4:2*(b+1));gd(this.c,0,c,0,2*b);return new uf(a,this.I,c)};h.fb=function(){var a=this.c;return vf?vf(a):wf.call(null,a)};h.Ia=function(a,b,c,d){var e=1<<(b>>>a&31);if(0===(this.I&e))return d;var f=pd(this.I&e-1),e=this.c[2*f],f=this.c[2*f+1];return null==e?f.Ia(a+5,b,c,d):qf(c,e)?f:d};
h.Aa=function(a,b,c,d,e,f){var g=1<<(c>>>b&31),k=pd(this.I&g-1);if(0===(this.I&g)){var l=pd(this.I);if(2*l<this.c.length){a=this.Ma(a);b=a.c;f.g=!0;a:for(c=2*(l-k),f=2*k+(c-1),l=2*(k+1)+(c-1);;){if(0===c)break a;b[l]=b[f];--l;--c;--f}b[2*k]=d;b[2*k+1]=e;a.I|=g;return a}if(16<=l){k=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];k[c>>>b&31]=xf.Aa(a,b+5,c,d,e,f);for(e=d=0;;)if(32>d)0!==
(this.I>>>d&1)&&(k[d]=null!=this.c[e]?xf.Aa(a,b+5,hc(this.c[e]),this.c[e],this.c[e+1],f):this.c[e+1],e+=2),d+=1;else break;return new yf(a,l+1,k)}b=Array(2*(l+4));gd(this.c,0,b,0,2*k);b[2*k]=d;b[2*k+1]=e;gd(this.c,2*k,b,2*(k+1),2*(l-k));f.g=!0;a=this.Ma(a);a.c=b;a.I|=g;return a}l=this.c[2*k];g=this.c[2*k+1];if(null==l)return l=g.Aa(a,b+5,c,d,e,f),l===g?this:tf(this,a,2*k+1,l);if(qf(d,l))return e===g?this:tf(this,a,2*k+1,e);f.g=!0;f=b+5;d=zf?zf(a,f,l,g,c,d,e):Af.call(null,a,f,l,g,c,d,e);e=2*k;k=2*
k+1;a=this.Ma(a);a.c[e]=null;a.c[k]=d;return a};
h.za=function(a,b,c,d,e){var f=1<<(b>>>a&31),g=pd(this.I&f-1);if(0===(this.I&f)){var k=pd(this.I);if(16<=k){g=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];g[b>>>a&31]=xf.za(a+5,b,c,d,e);for(d=c=0;;)if(32>c)0!==(this.I>>>c&1)&&(g[c]=null!=this.c[d]?xf.za(a+5,hc(this.c[d]),this.c[d],this.c[d+1],e):this.c[d+1],d+=2),c+=1;else break;return new yf(null,k+1,g)}a=Array(2*(k+1));gd(this.c,
0,a,0,2*g);a[2*g]=c;a[2*g+1]=d;gd(this.c,2*g,a,2*(g+1),2*(k-g));e.g=!0;return new uf(null,this.I|f,a)}var l=this.c[2*g],f=this.c[2*g+1];if(null==l)return k=f.za(a+5,b,c,d,e),k===f?this:new uf(null,this.I,rf(this.c,2*g+1,k));if(qf(c,l))return d===f?this:new uf(null,this.I,rf(this.c,2*g+1,d));e.g=!0;e=this.I;k=this.c;a+=5;a=Bf?Bf(a,l,f,b,c,d):Af.call(null,a,l,f,b,c,d);c=2*g;g=2*g+1;d=Ia(k);d[c]=null;d[g]=a;return new uf(null,e,d)};
h.gb=function(a,b,c){var d=1<<(b>>>a&31);if(0===(this.I&d))return this;var e=pd(this.I&d-1),f=this.c[2*e],g=this.c[2*e+1];return null==f?(a=g.gb(a+5,b,c),a===g?this:null!=a?new uf(null,this.I,rf(this.c,2*e+1,a)):this.I===d?null:new uf(null,this.I^d,sf(this.c,e))):qf(c,f)?new uf(null,this.I^d,sf(this.c,e)):this};var xf=new uf(null,0,[]);function yf(a,b,c){this.H=a;this.l=b;this.c=c}h=yf.prototype;h.Ma=function(a){return a===this.H?this:new yf(a,this.l,Ia(this.c))};
h.fb=function(){var a=this.c;return Cf?Cf(a):Df.call(null,a)};h.Ia=function(a,b,c,d){var e=this.c[b>>>a&31];return null!=e?e.Ia(a+5,b,c,d):d};h.Aa=function(a,b,c,d,e,f){var g=c>>>b&31,k=this.c[g];if(null==k)return a=tf(this,a,g,xf.Aa(a,b+5,c,d,e,f)),a.l+=1,a;b=k.Aa(a,b+5,c,d,e,f);return b===k?this:tf(this,a,g,b)};
h.za=function(a,b,c,d,e){var f=b>>>a&31,g=this.c[f];if(null==g)return new yf(null,this.l+1,rf(this.c,f,xf.za(a+5,b,c,d,e)));a=g.za(a+5,b,c,d,e);return a===g?this:new yf(null,this.l,rf(this.c,f,a))};
h.gb=function(a,b,c){var d=b>>>a&31,e=this.c[d];if(null!=e){a=e.gb(a+5,b,c);if(a===e)d=this;else if(null==a)if(8>=this.l)a:{e=this.c;a=e.length;b=Array(2*(this.l-1));c=0;for(var f=1,g=0;;)if(c<a)c!==d&&null!=e[c]&&(b[f]=e[c],f+=2,g|=1<<c),c+=1;else{d=new uf(null,g,b);break a}}else d=new yf(null,this.l-1,rf(this.c,d,a));else d=new yf(null,this.l,rf(this.c,d,a));return d}return this};function Ef(a,b,c){b*=2;for(var d=0;;)if(d<b){if(qf(c,a[d]))return d;d+=2}else return-1}
function Ff(a,b,c,d){this.H=a;this.Ea=b;this.l=c;this.c=d}h=Ff.prototype;h.Ma=function(a){if(a===this.H)return this;var b=Array(2*(this.l+1));gd(this.c,0,b,0,2*this.l);return new Ff(a,this.Ea,this.l,b)};h.fb=function(){var a=this.c;return vf?vf(a):wf.call(null,a)};h.Ia=function(a,b,c,d){a=Ef(this.c,this.l,c);return 0>a?d:qf(c,this.c[a])?this.c[a+1]:d};
h.Aa=function(a,b,c,d,e,f){if(c===this.Ea){b=Ef(this.c,this.l,d);if(-1===b){if(this.c.length>2*this.l)return b=2*this.l,c=2*this.l+1,a=this.Ma(a),a.c[b]=d,a.c[c]=e,f.g=!0,a.l+=1,a;c=this.c.length;b=Array(c+2);gd(this.c,0,b,0,c);b[c]=d;b[c+1]=e;f.g=!0;d=this.l+1;a===this.H?(this.c=b,this.l=d,a=this):a=new Ff(this.H,this.Ea,d,b);return a}return this.c[b+1]===e?this:tf(this,a,b+1,e)}return(new uf(a,1<<(this.Ea>>>b&31),[null,this,null,null])).Aa(a,b,c,d,e,f)};
h.za=function(a,b,c,d,e){return b===this.Ea?(a=Ef(this.c,this.l,c),-1===a?(a=2*this.l,b=Array(a+2),gd(this.c,0,b,0,a),b[a]=c,b[a+1]=d,e.g=!0,new Ff(null,this.Ea,this.l+1,b)):pc.b(this.c[a],d)?this:new Ff(null,this.Ea,this.l,rf(this.c,a+1,d))):(new uf(null,1<<(this.Ea>>>a&31),[null,this])).za(a,b,c,d,e)};h.gb=function(a,b,c){a=Ef(this.c,this.l,c);return-1===a?this:1===this.l?null:new Ff(null,this.Ea,this.l-1,sf(this.c,od(a)))};
function Af(){switch(arguments.length){case 6:return Bf(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);case 7:return zf(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function Bf(a,b,c,d,e,f){var g=hc(b);if(g===d)return new Ff(null,g,2,[b,c,e,f]);var k=new pf;return xf.za(a,g,b,c,k).za(a,d,e,f,k)}
function zf(a,b,c,d,e,f,g){var k=hc(c);if(k===e)return new Ff(null,k,2,[c,d,f,g]);var l=new pf;return xf.Aa(a,b,k,c,d,l).Aa(a,b,e,f,g,l)}function Gf(a,b,c,d,e){this.s=a;this.Ja=b;this.u=c;this.F=d;this.v=e;this.m=32374860;this.D=0}h=Gf.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(oc,this.s)};
h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return null==this.F?new X(null,2,5,Z,[this.Ja[this.u],this.Ja[this.u+1]],null):N(this.F)};h.ua=function(){if(null==this.F){var a=this.Ja,b=this.u+2;return Hf?Hf(a,b,null):wf.call(null,a,b,null)}var a=this.Ja,b=this.u,c=P(this.F);return Hf?Hf(a,b,c):wf.call(null,a,b,c)};h.ha=function(){return this};h.fa=function(a,b){return new Gf(b,this.Ja,this.u,this.F,this.v)};h.ga=function(a,b){return T(b,this)};
Gf.prototype[Ha]=function(){return rc(this)};function wf(){switch(arguments.length){case 1:return vf(arguments[0]);case 3:return Hf(arguments[0],arguments[1],arguments[2]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function vf(a){return Hf(a,0,null)}
function Hf(a,b,c){if(null==c)for(c=a.length;;)if(b<c){if(null!=a[b])return new Gf(null,a,b,null,null);var d=a[b+1];if(y(d)&&(d=d.fb(),y(d)))return new Gf(null,a,b+2,d,null);b+=2}else return null;else return new Gf(null,a,b,c,null)}function If(a,b,c,d,e){this.s=a;this.Ja=b;this.u=c;this.F=d;this.v=e;this.m=32374860;this.D=0}h=If.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.s};
h.N=function(){var a=this.v;return null!=a?a:this.v=a=tc(this)};h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(oc,this.s)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return N(this.F)};h.ua=function(){var a=this.Ja,b=this.u,c=P(this.F);return Jf?Jf(null,a,b,c):Df.call(null,null,a,b,c)};h.ha=function(){return this};h.fa=function(a,b){return new If(b,this.Ja,this.u,this.F,this.v)};h.ga=function(a,b){return T(b,this)};
If.prototype[Ha]=function(){return rc(this)};function Df(){switch(arguments.length){case 1:return Cf(arguments[0]);case 4:return Jf(arguments[0],arguments[1],arguments[2],arguments[3]);default:throw Error([C("Invalid arity: "),C(arguments.length)].join(""));}}function Cf(a){return Jf(null,a,0,null)}function Jf(a,b,c,d){if(null==d)for(d=b.length;;)if(c<d){var e=b[c];if(y(e)&&(e=e.fb(),y(e)))return new If(a,b,c+1,e,null);c+=1}else return null;else return new If(a,b,c,d,null)}
function Kf(a,b,c,d,e,f){this.s=a;this.l=b;this.root=c;this.sa=d;this.wa=e;this.v=f;this.m=16123663;this.D=8196}h=Kf.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.keys=function(){return rc(ff.a?ff.a(this):ff.call(null,this))};h.entries=function(){return af(I(this))};h.values=function(){return rc(gf.a?gf.a(this):gf.call(null,this))};h.has=function(a){return kd(this,a)};h.get=function(a,b){return this.K(null,a,b)};
h.forEach=function(a){for(var b=I(this),c=null,d=0,e=0;;)if(e<d){var f=c.J(null,e),g=Tc(f,0),f=Tc(f,1);a.b?a.b(f,g):a.call(null,f,g);e+=1}else if(b=I(b))ed(b)?(c=Pb(b),b=Qb(b),g=c,d=Qc(c),c=g):(c=N(b),g=Tc(c,0),c=f=Tc(c,1),a.b?a.b(c,g):a.call(null,c,g),b=P(b),c=null,d=0),e=0;else return null};h.O=function(a,b){return cb.i(this,b,null)};h.K=function(a,b,c){return null==b?this.sa?this.wa:c:null==this.root?c:this.root.Ia(0,hc(b),b,c)};h.P=function(){return this.s};h.ia=function(){return this.l};
h.N=function(){var a=this.v;return null!=a?a:this.v=a=vc(this)};h.w=function(a,b){return Ze(this,b)};h.Oa=function(){return new Lf({},this.root,this.l,this.sa,this.wa)};h.ja=function(){return tb(lf,this.s)};h.vb=function(a,b){if(null==b)return this.sa?new Kf(this.s,this.l-1,this.root,!1,null,null):this;if(null==this.root)return this;var c=this.root.gb(0,hc(b),b);return c===this.root?this:new Kf(this.s,this.l-1,c,this.sa,this.wa,null)};
h.Ua=function(a,b,c){if(null==b)return this.sa&&c===this.wa?this:new Kf(this.s,this.sa?this.l:this.l+1,this.root,!0,c,null);a=new pf;b=(null==this.root?xf:this.root).za(0,hc(b),b,c,a);return b===this.root?this:new Kf(this.s,a.g?this.l+1:this.l,b,this.sa,this.wa,null)};h.rb=function(a,b){return null==b?this.sa:null==this.root?!1:this.root.Ia(0,hc(b),b,hd)!==hd};h.ha=function(){if(0<this.l){var a=null!=this.root?this.root.fb():null;return this.sa?T(new X(null,2,5,Z,[null,this.wa],null),a):a}return null};
h.fa=function(a,b){return new Kf(b,this.l,this.root,this.sa,this.wa,this.v)};h.ga=function(a,b){if(dd(b))return eb(this,D.b(b,0),D.b(b,1));for(var c=this,d=I(b);;){if(null==d)return c;var e=N(d);if(dd(e))c=eb(c,D.b(e,0),D.b(e,1)),d=P(d);else throw Error("conj on a map takes map entries or seqables of map entries");}};
h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.O(null,c);case 3:return this.K(null,c,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return this.O(null,c)};a.i=function(a,c,d){return this.K(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return this.O(null,a)};h.b=function(a,b){return this.K(null,a,b)};var lf=new Kf(null,0,null,!1,null,wc);
function Xc(a,b){for(var c=a.length,d=0,e=Jb(lf);;)if(d<c)var f=d+1,e=e.bb(null,a[d],b[d]),d=f;else return Lb(e)}Kf.prototype[Ha]=function(){return rc(this)};function Lf(a,b,c,d,e){this.H=a;this.root=b;this.count=c;this.sa=d;this.wa=e;this.m=258;this.D=56}
function Mf(a,b){if(a.H){if(b?b.m&2048||b.Pb||(b.m?0:z(hb,b)):z(hb,b))return Nf(a,mf.a?mf.a(b):mf.call(null,b),nf.a?nf.a(b):nf.call(null,b));for(var c=I(b),d=a;;){var e=N(c);if(y(e))var f=e,c=P(c),d=Nf(d,function(){var a=f;return mf.a?mf.a(a):mf.call(null,a)}(),function(){var a=f;return nf.a?nf.a(a):nf.call(null,a)}());else return d}}else throw Error("conj! after persistent");}
function Nf(a,b,c){if(a.H){if(null==b)a.wa!==c&&(a.wa=c),a.sa||(a.count+=1,a.sa=!0);else{var d=new pf;b=(null==a.root?xf:a.root).Aa(a.H,0,hc(b),b,c,d);b!==a.root&&(a.root=b);d.g&&(a.count+=1)}return a}throw Error("assoc! after persistent!");}h=Lf.prototype;h.ia=function(){if(this.H)return this.count;throw Error("count after persistent!");};h.O=function(a,b){return null==b?this.sa?this.wa:null:null==this.root?null:this.root.Ia(0,hc(b),b)};
h.K=function(a,b,c){return null==b?this.sa?this.wa:c:null==this.root?c:this.root.Ia(0,hc(b),b,c)};h.cb=function(a,b){return Mf(this,b)};h.eb=function(){var a;if(this.H)this.H=null,a=new Kf(null,this.count,this.root,this.sa,this.wa,null);else throw Error("persistent! called twice");return a};h.bb=function(a,b,c){return Nf(this,b,c)};var de=function de(){return de.o(0<arguments.length?new M(Array.prototype.slice.call(arguments,0),0):null)};
de.o=function(a){for(var b=I(a),c=Jb(lf);;)if(b){a=P(P(b));var d=N(b),b=Nc(b),c=Mb(c,d,b),b=a}else return Lb(c)};de.C=0;de.A=function(a){return de.o(I(a))};function Of(a,b){this.pa=a;this.la=b;this.m=32374988;this.D=0}h=Of.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.la};h.ra=function(){var a=this.pa,a=(a?a.m&128||a.lb||(a.m?0:z(Za,a)):z(Za,a))?this.pa.ra(null):P(this.pa);return null==a?null:new Of(a,this.la)};h.N=function(){return tc(this)};
h.w=function(a,b){return Hc(this,b)};h.ja=function(){return Jc(oc,this.la)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return this.pa.oa(null).wb()};h.ua=function(){var a=this.pa,a=(a?a.m&128||a.lb||(a.m?0:z(Za,a)):z(Za,a))?this.pa.ra(null):P(this.pa);return null!=a?new Of(a,this.la):oc};h.ha=function(){return this};h.fa=function(a,b){return new Of(this.pa,b)};h.ga=function(a,b){return T(b,this)};Of.prototype[Ha]=function(){return rc(this)};
function ff(a){return(a=I(a))?new Of(a,null):null}function mf(a){return ib(a)}function Pf(a,b){this.pa=a;this.la=b;this.m=32374988;this.D=0}h=Pf.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.P=function(){return this.la};h.ra=function(){var a=this.pa,a=(a?a.m&128||a.lb||(a.m?0:z(Za,a)):z(Za,a))?this.pa.ra(null):P(this.pa);return null==a?null:new Pf(a,this.la)};h.N=function(){return tc(this)};h.w=function(a,b){return Hc(this,b)};
h.ja=function(){return Jc(oc,this.la)};h.ma=function(a,b){return Kc(b,this)};h.na=function(a,b,c){return Mc(b,c,this)};h.oa=function(){return this.pa.oa(null).xb()};h.ua=function(){var a=this.pa,a=(a?a.m&128||a.lb||(a.m?0:z(Za,a)):z(Za,a))?this.pa.ra(null):P(this.pa);return null!=a?new Pf(a,this.la):oc};h.ha=function(){return this};h.fa=function(a,b){return new Pf(this.pa,b)};h.ga=function(a,b){return T(b,this)};Pf.prototype[Ha]=function(){return rc(this)};
function gf(a){return(a=I(a))?new Pf(a,null):null}function nf(a){return jb(a)}var Qf=function Qf(){return Qf.o(0<arguments.length?new M(Array.prototype.slice.call(arguments,0),0):null)};Qf.o=function(a){return y(Vd(md,a))?ld(function(a,c){return Oc.b(y(a)?a:jf,c)},a):null};Qf.C=0;Qf.A=function(a){return Qf.o(I(a))};var Rf=function Rf(){return Rf.o(arguments[0],1<arguments.length?new M(Array.prototype.slice.call(arguments,1),0):null)};
Rf.o=function(a,b){return y(Vd(md,b))?ld(function(a){return function(b,e){return Na(a,y(b)?b:jf,I(e))}}(function(b,d){var e=N(d),f=Nc(d);return kd(b,e)?Wc.i(b,e,function(){var d=Uc(b,e);return a.b?a.b(d,f):a.call(null,d,f)}()):Wc.i(b,e,f)}),b):null};Rf.C=1;Rf.A=function(a){var b=N(a);a=P(a);return Rf.o(b,a)};function Sf(a,b,c){this.s=a;this.Ra=b;this.v=c;this.m=15077647;this.D=8196}h=Sf.prototype;h.toString=function(){return Zb(this)};h.equiv=function(a){return this.w(null,a)};h.keys=function(){return rc(I(this))};
h.entries=function(){var a=I(this);return new bf(I(a))};h.values=function(){return rc(I(this))};h.has=function(a){return kd(this,a)};h.forEach=function(a){for(var b=I(this),c=null,d=0,e=0;;)if(e<d){var f=c.J(null,e),g=Tc(f,0),f=Tc(f,1);a.b?a.b(f,g):a.call(null,f,g);e+=1}else if(b=I(b))ed(b)?(c=Pb(b),b=Qb(b),g=c,d=Qc(c),c=g):(c=N(b),g=Tc(c,0),c=f=Tc(c,1),a.b?a.b(c,g):a.call(null,c,g),b=P(b),c=null,d=0),e=0;else return null};h.O=function(a,b){return cb.i(this,b,null)};
h.K=function(a,b,c){return db(this.Ra,b)?b:c};h.P=function(){return this.s};h.ia=function(){return Sa(this.Ra)};h.N=function(){var a=this.v;return null!=a?a:this.v=a=vc(this)};h.w=function(a,b){return bd(b)&&Qc(this)===Qc(b)&&Ud(function(a){return function(b){return kd(a,b)}}(this),b)};h.Oa=function(){return new Tf(Jb(this.Ra))};h.ja=function(){return Jc(Uf,this.s)};h.ha=function(){return ff(this.Ra)};h.fa=function(a,b){return new Sf(b,this.Ra,this.v)};
h.ga=function(a,b){return new Sf(this.s,Wc.i(this.Ra,b,null),null)};h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.O(null,c);case 3:return this.K(null,c,d)}throw Error("Invalid arity: "+arguments.length);};a.b=function(a,c){return this.O(null,c)};a.i=function(a,c,d){return this.K(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return this.O(null,a)};h.b=function(a,b){return this.K(null,a,b)};
var Uf=new Sf(null,jf,wc);Sf.prototype[Ha]=function(){return rc(this)};function Tf(a){this.Ga=a;this.D=136;this.m=259}h=Tf.prototype;h.cb=function(a,b){this.Ga=Mb(this.Ga,b,null);return this};h.eb=function(){return new Sf(null,Lb(this.Ga),null)};h.ia=function(){return Qc(this.Ga)};h.O=function(a,b){return cb.i(this,b,null)};h.K=function(a,b,c){return cb.i(this.Ga,b,hd)===hd?c:b};
h.call=function(){function a(a,b,c){return cb.i(this.Ga,b,hd)===hd?c:b}function b(a,b){return cb.i(this.Ga,b,hd)===hd?null:b}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error("Invalid arity: "+arguments.length);};c.b=b;c.i=a;return c}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.a=function(a){return cb.i(this.Ga,a,hd)===hd?null:a};h.b=function(a,b){return cb.i(this.Ga,a,hd)===hd?b:a};
function Vf(a){return function c(a,e){return new Ad(null,function(){return function(a,d){for(;;){var e=a,l=Tc(e,0);if(e=I(e))if(kd(d,l))l=nc(e),e=d,a=l,d=e;else return T(l,c(nc(e),Oc.b(d,l)));else return null}}.call(null,a,e)},null,null)}(a,Uf)}function zd(a){if(a&&(a.D&4096||a.Rb))return a.Xa(null);if("string"===typeof a)return a;throw Error([C("Doesn't support name: "),C(a)].join(""));}
function Wf(a,b,c,d,e,f,g){var k=ta;ta=null==ta?null:ta-1;try{if(null!=ta&&0>ta)return Eb(a,"#");Eb(a,c);if(0===Ca.a(f))I(g)&&Eb(a,function(){var a=Xf.a(f);return y(a)?a:"..."}());else{if(I(g)){var l=N(g);b.i?b.i(l,a,f):b.call(null,l,a,f)}for(var m=P(g),n=Ca.a(f)-1;;)if(!m||null!=n&&0===n){I(m)&&0===n&&(Eb(a,d),Eb(a,function(){var a=Xf.a(f);return y(a)?a:"..."}()));break}else{Eb(a,d);var p=N(m);c=a;g=f;b.i?b.i(p,c,g):b.call(null,p,c,g);var q=P(m);c=n-1;m=q;n=c}}return Eb(a,e)}finally{ta=k}}
function Yf(a,b){for(var c=I(b),d=null,e=0,f=0;;)if(f<e){var g=d.J(null,f);Eb(a,g);f+=1}else if(c=I(c))d=c,ed(d)?(c=Pb(d),e=Qb(d),d=c,g=Qc(c),c=e,e=g):(g=N(d),Eb(a,g),c=P(d),d=null,e=0),f=0;else return null}function Zf(a){pa.a?pa.a(a):pa.call(null,a);return null}var $f={'"':'\\"',"\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};function ag(a){return[C('"'),C(a.replace(RegExp('[\\\\"\b\f\n\r\t]',"g"),function(a){return $f[a]})),C('"')].join("")}
function bg(a,b,c){if(null==a)return Eb(b,"nil");if(void 0===a)return Eb(b,"#\x3cundefined\x3e");if(y(function(){var b=Uc(c,Aa);return y(b)?(b=a?a.m&131072||a.Qb?!0:a.m?!1:z(qb,a):z(qb,a))?ad(a):b:b}())){Eb(b,"^");var d=ad(a);cg.i?cg.i(d,b,c):cg.call(null,d,b,c);Eb(b," ")}return null==a?Eb(b,"nil"):a.Lb?a.Zb(b):a&&(a.m&2147483648||a.R)?a.L(null,b,c):(null==a?null:a.constructor)===Boolean||"number"===typeof a?Eb(b,""+C(a)):null!=a&&a.constructor===Object?(Eb(b,"#js "),d=je.b(function(b){return new X(null,
2,5,Z,[yd.a(b),a[b]],null)},fd(a)),dg.B?dg.B(d,cg,b,c):dg.call(null,d,cg,b,c)):Ea(a)?Wf(b,cg,"#js ["," ","]",c,a):y("string"==typeof a)?y(za.a(c))?Eb(b,ag(a)):Eb(b,a):Zc(a)?Yf(b,U(["#\x3c",""+C(a),"\x3e"],0)):a instanceof Date?(d=function(a,b){for(var c=""+C(a);;)if(Qc(c)<b)c=[C("0"),C(c)].join("");else return c},Yf(b,U(['#inst "',""+C(a.getUTCFullYear()),"-",d(a.getUTCMonth()+1,2),"-",d(a.getUTCDate(),2),"T",d(a.getUTCHours(),2),":",d(a.getUTCMinutes(),2),":",d(a.getUTCSeconds(),2),".",d(a.getUTCMilliseconds(),
3),"-",'00:00"'],0))):y(a instanceof RegExp)?Yf(b,U(['#"',a.source,'"'],0)):(a?a.m&2147483648||a.R||(a.m?0:z(Fb,a)):z(Fb,a))?Gb(a,b,c):Yf(b,U(["#\x3c",""+C(a),"\x3e"],0))}function cg(a,b,c){var d=eg.a(c);return y(d)?(c=Wc.i(c,fg,bg),d.i?d.i(a,b,c):d.call(null,a,b,c)):bg(a,b,c)}
function gg(a,b){var c;if(null==a||Fa(I(a)))c="";else{c=C;var d=new na;a:{var e=new Yb(d);cg(N(a),e,b);for(var f=I(P(a)),g=null,k=0,l=0;;)if(l<k){var m=g.J(null,l);Eb(e," ");cg(m,e,b);l+=1}else if(f=I(f))g=f,ed(g)?(f=Pb(g),k=Qb(g),g=f,m=Qc(f),f=k,k=m):(m=N(g),Eb(e," "),cg(m,e,b),f=P(g),g=null,k=0),l=0;else break a}c=""+c(d)}return c}function hg(){var a=wa();Zf("\n");return Uc(a,ya),null}function ge(){return ig(0<arguments.length?new M(Array.prototype.slice.call(arguments,0),0):null)}
function ig(a){return gg(a,wa())}var jg=function(){function a(a){var d=null;if(0<arguments.length){for(var d=0,e=Array(arguments.length-0);d<e.length;)e[d]=arguments[d+0],++d;d=new M(e,0)}return b.call(this,d)}function b(a){var b=Wc.i(wa(),za,!1);return Zf(gg(a,b))}a.C=0;a.A=function(a){a=I(a);return b(a)};a.o=b;return a}();function kg(a){var b=Wc.i(wa(),za,!1);Zf(gg(a,b));return y(ra)?hg():null}
function dg(a,b,c,d){return Wf(c,function(a,c,d){var k=ib(a);b.i?b.i(k,c,d):b.call(null,k,c,d);Eb(c," ");a=jb(a);return b.i?b.i(a,c,d):b.call(null,a,c,d)},"{",", ","}",d,I(a))}ie.prototype.R=!0;ie.prototype.L=function(a,b,c){Eb(b,"#\x3cVolatile: ");cg(this.state,b,c);return Eb(b,"\x3e")};kc.prototype.R=!0;kc.prototype.L=function(a,b,c){Eb(b,"#'");return cg(this.gc,b,c)};M.prototype.R=!0;M.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};Ad.prototype.R=!0;
Ad.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};Gf.prototype.R=!0;Gf.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};df.prototype.R=!0;df.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};Pe.prototype.R=!0;Pe.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};wd.prototype.R=!0;wd.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};Gc.prototype.R=!0;Gc.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};
Kf.prototype.R=!0;Kf.prototype.L=function(a,b,c){return dg(this,cg,b,c)};If.prototype.R=!0;If.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};Te.prototype.R=!0;Te.prototype.L=function(a,b,c){return Wf(b,cg,"["," ","]",c,this)};Sf.prototype.R=!0;Sf.prototype.L=function(a,b,c){return Wf(b,cg,"#{"," ","}",c,this)};Fd.prototype.R=!0;Fd.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};ae.prototype.R=!0;
ae.prototype.L=function(a,b,c){Eb(b,"#\x3cAtom: ");cg(this.state,b,c);return Eb(b,"\x3e")};Pf.prototype.R=!0;Pf.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};X.prototype.R=!0;X.prototype.L=function(a,b,c){return Wf(b,cg,"["," ","]",c,this)};sd.prototype.R=!0;sd.prototype.L=function(a,b){return Eb(b,"()")};xa.prototype.R=!0;xa.prototype.L=function(a,b,c){return dg(this,cg,b,c)};Of.prototype.R=!0;Of.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};rd.prototype.R=!0;
rd.prototype.L=function(a,b,c){return Wf(b,cg,"("," ",")",c,this)};function lg(a,b){this.Ha=a;this.value=b;this.m=32768;this.D=1}lg.prototype.Va=function(){y(this.Ha)&&(this.value=this.Ha.f?this.Ha.f():this.Ha.call(null),this.Ha=null);return this.value};lg.prototype.Eb=function(){return Fa(this.Ha)};function mg(a,b){return Md(Na(function(b,d){var e=a.a?a.a(d):a.call(null,d),f=Oc.b(Vc(b,e,Pc),d);return Mb(b,e,f)},Jb(jf),b))}var ng=null;
function og(){if(null==ng){var a=new xa(null,3,[pg,jf,qg,jf,rg,jf],null);ng=ce?ce(a):be.call(null,a)}return ng}function sg(a,b,c){var d=pc.b(b,c);if(!d&&!(d=kd(rg.a(a).call(null,b),c))&&(d=dd(c))&&(d=dd(b)))if(d=Qc(c)===Qc(b))for(var e=!0,f=0;;)if(e&&f!==Qc(c))e=sg(a,function(){var a=f;return b.a?b.a(a):b.call(null,a)}(),function(){var a=f;return c.a?c.a(a):c.call(null,a)}()),f=d=f+1;else return e;else return d;else return d}
function tg(a){var b;b=og();b=R.a?R.a(b):R.call(null,b);a=Uc(pg.a(b),a);return I(a)?a:null}function ug(a,b,c,d){he.b(a,function(){return R.a?R.a(b):R.call(null,b)});he.b(c,function(){return R.a?R.a(d):R.call(null,d)})}
var vg=function vg(b,c,d){var e=(R.a?R.a(d):R.call(null,d)).call(null,b),e=y(y(e)?e.a?e.a(c):e.call(null,c):e)?!0:null;if(y(e))return e;e=function(){for(var e=tg(c);;)if(0<Qc(e))vg(b,N(e),d),e=nc(e);else return null}();if(y(e))return e;e=function(){for(var e=tg(b);;)if(0<Qc(e))vg(N(e),c,d),e=nc(e);else return null}();return y(e)?e:!1};function wg(a,b,c){c=vg(a,b,c);if(y(c))a=c;else{c=sg;var d;d=og();d=R.a?R.a(d):R.call(null,d);a=c(d,a,b)}return a}
var xg=function xg(b,c,d,e,f,g,k){var l=Na(function(e,g){var k=Tc(g,0);Tc(g,1);if(sg(R.a?R.a(d):R.call(null,d),c,k)){var l;l=(l=null==e)?l:wg(k,N(e),f);l=y(l)?g:e;if(!y(wg(N(l),k,f)))throw Error([C("Multiple methods in multimethod '"),C(b),C("' match dispatch value: "),C(c),C(" -\x3e "),C(k),C(" and "),C(N(l)),C(", and neither is preferred")].join(""));return l}return e},null,R.a?R.a(e):R.call(null,e));if(y(l)){if(pc.b(R.a?R.a(k):R.call(null,k),R.a?R.a(d):R.call(null,d)))return he.B(g,Wc,c,Nc(l)),
Nc(l);ug(g,e,k,d);return xg(b,c,d,e,f,g,k)}return null};function yg(a,b){throw Error([C("No method in multimethod '"),C(a),C("' for dispatch value: "),C(b)].join(""));}function zg(a,b,c,d,e,f,g,k){this.name=a;this.j=b;this.bc=c;this.nb=d;this.hb=e;this.ec=f;this.ob=g;this.ib=k;this.m=4194305;this.D=4352}h=zg.prototype;
h.call=function(){function a(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E,F,Q){a=this;var ha=Td(a.j,b,c,d,e,U([f,g,k,l,m,n,p,q,r,t,v,u,x,B,E,F,Q],0)),dh=Ag(this,ha);y(dh)||yg(a.name,ha);return Td(dh,b,c,d,e,U([f,g,k,l,m,n,p,q,r,t,v,u,x,B,E,F,Q],0))}function b(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E,F){a=this;var Q=a.j.ba?a.j.ba(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E,F):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E,F),ha=Ag(this,Q);y(ha)||yg(a.name,Q);return ha.ba?ha.ba(b,c,d,e,f,g,k,l,m,n,p,q,r,t,
v,u,x,B,E,F):ha.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E,F)}function c(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E){a=this;var F=a.j.aa?a.j.aa(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E),Q=Ag(this,F);y(Q)||yg(a.name,F);return Q.aa?Q.aa(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E):Q.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B,E)}function d(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B){a=this;var E=a.j.$?a.j.$(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B):a.j.call(null,
b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B),F=Ag(this,E);y(F)||yg(a.name,E);return F.$?F.$(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B):F.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x,B)}function e(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x){a=this;var B=a.j.Z?a.j.Z(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x),E=Ag(this,B);y(E)||yg(a.name,B);return E.Z?E.Z(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x):E.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u,x)}function f(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u){a=
this;var x=a.j.Y?a.j.Y(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u),B=Ag(this,x);y(B)||yg(a.name,x);return B.Y?B.Y(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u):B.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,u)}function g(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v){a=this;var u=a.j.X?a.j.X(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v),x=Ag(this,u);y(x)||yg(a.name,u);return x.X?x.X(b,c,d,e,f,g,k,l,m,n,p,q,r,t,v):x.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v)}function k(a,
b,c,d,e,f,g,k,l,m,n,p,q,r,t){a=this;var v=a.j.W?a.j.W(b,c,d,e,f,g,k,l,m,n,p,q,r,t):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t),u=Ag(this,v);y(u)||yg(a.name,v);return u.W?u.W(b,c,d,e,f,g,k,l,m,n,p,q,r,t):u.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r,t)}function l(a,b,c,d,e,f,g,k,l,m,n,p,q,r){a=this;var t=a.j.V?a.j.V(b,c,d,e,f,g,k,l,m,n,p,q,r):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r),v=Ag(this,t);y(v)||yg(a.name,t);return v.V?v.V(b,c,d,e,f,g,k,l,m,n,p,q,r):v.call(null,b,c,d,e,f,g,k,l,m,n,p,q,r)}function m(a,
b,c,d,e,f,g,k,l,m,n,p,q){a=this;var r=a.j.U?a.j.U(b,c,d,e,f,g,k,l,m,n,p,q):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,q),t=Ag(this,r);y(t)||yg(a.name,r);return t.U?t.U(b,c,d,e,f,g,k,l,m,n,p,q):t.call(null,b,c,d,e,f,g,k,l,m,n,p,q)}function n(a,b,c,d,e,f,g,k,l,m,n,p){a=this;var q=a.j.T?a.j.T(b,c,d,e,f,g,k,l,m,n,p):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p),r=Ag(this,q);y(r)||yg(a.name,q);return r.T?r.T(b,c,d,e,f,g,k,l,m,n,p):r.call(null,b,c,d,e,f,g,k,l,m,n,p)}function p(a,b,c,d,e,f,g,k,l,m,n){a=this;var p=a.j.S?
a.j.S(b,c,d,e,f,g,k,l,m,n):a.j.call(null,b,c,d,e,f,g,k,l,m,n),q=Ag(this,p);y(q)||yg(a.name,p);return q.S?q.S(b,c,d,e,f,g,k,l,m,n):q.call(null,b,c,d,e,f,g,k,l,m,n)}function q(a,b,c,d,e,f,g,k,l,m){a=this;var n=a.j.ea?a.j.ea(b,c,d,e,f,g,k,l,m):a.j.call(null,b,c,d,e,f,g,k,l,m),p=Ag(this,n);y(p)||yg(a.name,n);return p.ea?p.ea(b,c,d,e,f,g,k,l,m):p.call(null,b,c,d,e,f,g,k,l,m)}function r(a,b,c,d,e,f,g,k,l){a=this;var m=a.j.da?a.j.da(b,c,d,e,f,g,k,l):a.j.call(null,b,c,d,e,f,g,k,l),n=Ag(this,m);y(n)||yg(a.name,
m);return n.da?n.da(b,c,d,e,f,g,k,l):n.call(null,b,c,d,e,f,g,k,l)}function t(a,b,c,d,e,f,g,k){a=this;var l=a.j.ca?a.j.ca(b,c,d,e,f,g,k):a.j.call(null,b,c,d,e,f,g,k),m=Ag(this,l);y(m)||yg(a.name,l);return m.ca?m.ca(b,c,d,e,f,g,k):m.call(null,b,c,d,e,f,g,k)}function v(a,b,c,d,e,f,g){a=this;var k=a.j.M?a.j.M(b,c,d,e,f,g):a.j.call(null,b,c,d,e,f,g),l=Ag(this,k);y(l)||yg(a.name,k);return l.M?l.M(b,c,d,e,f,g):l.call(null,b,c,d,e,f,g)}function x(a,b,c,d,e,f){a=this;var g=a.j.G?a.j.G(b,c,d,e,f):a.j.call(null,
b,c,d,e,f),k=Ag(this,g);y(k)||yg(a.name,g);return k.G?k.G(b,c,d,e,f):k.call(null,b,c,d,e,f)}function B(a,b,c,d,e){a=this;var f=a.j.B?a.j.B(b,c,d,e):a.j.call(null,b,c,d,e),g=Ag(this,f);y(g)||yg(a.name,f);return g.B?g.B(b,c,d,e):g.call(null,b,c,d,e)}function E(a,b,c,d){a=this;var e=a.j.i?a.j.i(b,c,d):a.j.call(null,b,c,d),f=Ag(this,e);y(f)||yg(a.name,e);return f.i?f.i(b,c,d):f.call(null,b,c,d)}function F(a,b,c){a=this;var d=a.j.b?a.j.b(b,c):a.j.call(null,b,c),e=Ag(this,d);y(e)||yg(a.name,d);return e.b?
e.b(b,c):e.call(null,b,c)}function Q(a,b){a=this;var c=a.j.a?a.j.a(b):a.j.call(null,b),d=Ag(this,c);y(d)||yg(a.name,c);return d.a?d.a(b):d.call(null,b)}function ha(a){a=this;var b=a.j.f?a.j.f():a.j.call(null),c=Ag(this,b);y(c)||yg(a.name,b);return c.f?c.f():c.call(null)}var u=null,u=function(u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb,mc,vd){switch(arguments.length){case 1:return ha.call(this,u);case 2:return Q.call(this,u,H);case 3:return F.call(this,u,H,J);case 4:return E.call(this,u,H,
J,K);case 5:return B.call(this,u,H,J,K,L);case 6:return x.call(this,u,H,J,K,L,O);case 7:return v.call(this,u,H,J,K,L,O,S);case 8:return t.call(this,u,H,J,K,L,O,S,V);case 9:return r.call(this,u,H,J,K,L,O,S,V,aa);case 10:return q.call(this,u,H,J,K,L,O,S,V,aa,sa);case 11:return p.call(this,u,H,J,K,L,O,S,V,aa,sa,fa);case 12:return n.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja);case 13:return m.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa);case 14:return l.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa);case 15:return k.call(this,
u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va);case 16:return g.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a);case 17:return f.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a,Ka);case 18:return e.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a,Ka,Qa);case 19:return d.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a,Ka,Qa,bb);case 20:return c.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb);case 21:return b.call(this,u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb,mc);case 22:return a.call(this,
u,H,J,K,L,O,S,V,aa,sa,fa,ja,oa,qa,va,$a,Ka,Qa,bb,wb,mc,vd)}throw Error("Invalid arity: "+arguments.length);};u.a=ha;u.b=Q;u.i=F;u.B=E;u.G=B;u.M=x;u.ca=v;u.da=t;u.ea=r;u.S=q;u.T=p;u.U=n;u.V=m;u.W=l;u.X=k;u.Y=g;u.Z=f;u.$=e;u.aa=d;u.ba=c;u.Wa=b;u.Ca=a;return u}();h.apply=function(a,b){return this.call.apply(this,[this].concat(Ia(b)))};h.f=function(){var a=this.j.f?this.j.f():this.j.call(null),b=Ag(this,a);y(b)||yg(this.name,a);return b.f?b.f():b.call(null)};
h.a=function(a){var b=this.j.a?this.j.a(a):this.j.call(null,a),c=Ag(this,b);y(c)||yg(this.name,b);return c.a?c.a(a):c.call(null,a)};h.b=function(a,b){var c=this.j.b?this.j.b(a,b):this.j.call(null,a,b),d=Ag(this,c);y(d)||yg(this.name,c);return d.b?d.b(a,b):d.call(null,a,b)};h.i=function(a,b,c){var d=this.j.i?this.j.i(a,b,c):this.j.call(null,a,b,c),e=Ag(this,d);y(e)||yg(this.name,d);return e.i?e.i(a,b,c):e.call(null,a,b,c)};
h.B=function(a,b,c,d){var e=this.j.B?this.j.B(a,b,c,d):this.j.call(null,a,b,c,d),f=Ag(this,e);y(f)||yg(this.name,e);return f.B?f.B(a,b,c,d):f.call(null,a,b,c,d)};h.G=function(a,b,c,d,e){var f=this.j.G?this.j.G(a,b,c,d,e):this.j.call(null,a,b,c,d,e),g=Ag(this,f);y(g)||yg(this.name,f);return g.G?g.G(a,b,c,d,e):g.call(null,a,b,c,d,e)};
h.M=function(a,b,c,d,e,f){var g=this.j.M?this.j.M(a,b,c,d,e,f):this.j.call(null,a,b,c,d,e,f),k=Ag(this,g);y(k)||yg(this.name,g);return k.M?k.M(a,b,c,d,e,f):k.call(null,a,b,c,d,e,f)};h.ca=function(a,b,c,d,e,f,g){var k=this.j.ca?this.j.ca(a,b,c,d,e,f,g):this.j.call(null,a,b,c,d,e,f,g),l=Ag(this,k);y(l)||yg(this.name,k);return l.ca?l.ca(a,b,c,d,e,f,g):l.call(null,a,b,c,d,e,f,g)};
h.da=function(a,b,c,d,e,f,g,k){var l=this.j.da?this.j.da(a,b,c,d,e,f,g,k):this.j.call(null,a,b,c,d,e,f,g,k),m=Ag(this,l);y(m)||yg(this.name,l);return m.da?m.da(a,b,c,d,e,f,g,k):m.call(null,a,b,c,d,e,f,g,k)};h.ea=function(a,b,c,d,e,f,g,k,l){var m=this.j.ea?this.j.ea(a,b,c,d,e,f,g,k,l):this.j.call(null,a,b,c,d,e,f,g,k,l),n=Ag(this,m);y(n)||yg(this.name,m);return n.ea?n.ea(a,b,c,d,e,f,g,k,l):n.call(null,a,b,c,d,e,f,g,k,l)};
h.S=function(a,b,c,d,e,f,g,k,l,m){var n=this.j.S?this.j.S(a,b,c,d,e,f,g,k,l,m):this.j.call(null,a,b,c,d,e,f,g,k,l,m),p=Ag(this,n);y(p)||yg(this.name,n);return p.S?p.S(a,b,c,d,e,f,g,k,l,m):p.call(null,a,b,c,d,e,f,g,k,l,m)};h.T=function(a,b,c,d,e,f,g,k,l,m,n){var p=this.j.T?this.j.T(a,b,c,d,e,f,g,k,l,m,n):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n),q=Ag(this,p);y(q)||yg(this.name,p);return q.T?q.T(a,b,c,d,e,f,g,k,l,m,n):q.call(null,a,b,c,d,e,f,g,k,l,m,n)};
h.U=function(a,b,c,d,e,f,g,k,l,m,n,p){var q=this.j.U?this.j.U(a,b,c,d,e,f,g,k,l,m,n,p):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p),r=Ag(this,q);y(r)||yg(this.name,q);return r.U?r.U(a,b,c,d,e,f,g,k,l,m,n,p):r.call(null,a,b,c,d,e,f,g,k,l,m,n,p)};h.V=function(a,b,c,d,e,f,g,k,l,m,n,p,q){var r=this.j.V?this.j.V(a,b,c,d,e,f,g,k,l,m,n,p,q):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q),t=Ag(this,r);y(t)||yg(this.name,r);return t.V?t.V(a,b,c,d,e,f,g,k,l,m,n,p,q):t.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q)};
h.W=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r){var t=this.j.W?this.j.W(a,b,c,d,e,f,g,k,l,m,n,p,q,r):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r),v=Ag(this,t);y(v)||yg(this.name,t);return v.W?v.W(a,b,c,d,e,f,g,k,l,m,n,p,q,r):v.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r)};
h.X=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t){var v=this.j.X?this.j.X(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t),x=Ag(this,v);y(x)||yg(this.name,v);return x.X?x.X(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t):x.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t)};
h.Y=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v){var x=this.j.Y?this.j.Y(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v),B=Ag(this,x);y(B)||yg(this.name,x);return B.Y?B.Y(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v):B.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v)};
h.Z=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x){var B=this.j.Z?this.j.Z(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x),E=Ag(this,B);y(E)||yg(this.name,B);return E.Z?E.Z(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x):E.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x)};
h.$=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B){var E=this.j.$?this.j.$(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B),F=Ag(this,E);y(F)||yg(this.name,E);return F.$?F.$(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B):F.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B)};
h.aa=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E){var F=this.j.aa?this.j.aa(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E),Q=Ag(this,F);y(Q)||yg(this.name,F);return Q.aa?Q.aa(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E):Q.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E)};
h.ba=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F){var Q=this.j.ba?this.j.ba(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F),ha=Ag(this,Q);y(ha)||yg(this.name,Q);return ha.ba?ha.ba(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F):ha.call(null,a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F)};
h.Wa=function(a,b,c,d,e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q){var ha=Td(this.j,a,b,c,d,U([e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q],0)),u=Ag(this,ha);y(u)||yg(this.name,ha);return Td(u,a,b,c,d,U([e,f,g,k,l,m,n,p,q,r,t,v,x,B,E,F,Q],0))};function Bg(a,b){var c=Cg;he.B(c.hb,Wc,a,b);ug(c.ob,c.hb,c.ib,c.nb)}
function Ag(a,b){pc.b(function(){var b=a.ib;return R.a?R.a(b):R.call(null,b)}(),function(){var b=a.nb;return R.a?R.a(b):R.call(null,b)}())||ug(a.ob,a.hb,a.ib,a.nb);var c=function(){var b=a.ob;return R.a?R.a(b):R.call(null,b)}().call(null,b);if(y(c))return c;c=xg(a.name,b,a.nb,a.hb,a.ec,a.ob,a.ib);return y(c)?c:function(){var b=a.hb;return R.a?R.a(b):R.call(null,b)}().call(null,a.bc)}h.Xa=function(){return Sb(this.name)};h.Ya=function(){return Tb(this.name)};
h.N=function(){return this[da]||(this[da]=++ea)};var Dg=new W(null,"y","y",-1757859776),Eg=new W(null,"shift","shift",997140064),Fg=new W(null,"async","async",1050769601),Gg=new W(null,"down","down",1565245570),Hg=new W(null,"testing-vars","testing-vars",-2114769150),Ig=new W(null,"space","space",348133475),Jg=new W(null,"home","home",-74557309),Kg=new W(null,"insert","insert",1286475395),Lg=new W(null,"fn","fn",-1175266204),Mg=new W(null,"f8","f8",-2141475484),Ng=new W(null,"begin-test-var","begin-test-var",-908571100),Aa=new W(null,"meta","meta",
1499536964),Og=new W(null,"f1","f1",1714532389),Ba=new W(null,"dup","dup",556298533),pe=new W(null,"testing-contexts","testing-contexts",-1485646523),Pg=new W(null,"f10","f10",627525541),Qg=new W(null,"report-counters","report-counters",-1702609242),Rg=new W(null,"alt","alt",-3214426),Sg=new W(null,"script","script",-1304443801),Tg=new W(null,"top","top",-1856271961),Ug=new W(null,"esc","esc",-1671924121),ee=new W(null,"validator","validator",-1966190681),Vg=new W(null,"default","default",-1987822328),
Wg=new W(null,"ns","ns",441598760),Xg=new W(null,"name","name",1843675177),Yg=new W(null,"each-fixtures","each-fixtures",802243977),Zg=new W(null,"comma","comma",1699024745),$g=new W(null,"file","file",-1269645878),ah=new W(null,"end-column","end-column",1425389514),bh=new W(null,"numlock","numlock",-1383996470),ch=new W(null,"width","width",-384071477),eh=new W(null,"f5","f5",1587057387),fh=new W(null,"pageup","pageup",1714543403),gh=new W(null,"type","type",1174270348),hh=new W(null,"delete","delete",
-1768633620),ih=new W(null,"src","src",-1651076051),fg=new W(null,"fallback-impl","fallback-impl",-1501286995),jh=new W(null,"source","source",-433931539),ya=new W(null,"flush-on-newline","flush-on-newline",-151457939),kh=new W(null,"/","/",1282502798),lh=new W(null,"sync","sync",-624148946),mh=new W(null,"up","up",-269712113),qg=new W(null,"descendants","descendants",1824886031),nh=new W(null,"canvas","canvas",-1798817489),oh=new W(null,"renderer","renderer",336841071),ph=new W("cljs.test","async-disabled",
"cljs.test/async-disabled",-772095377),qh=new W(null,"column","column",2078222095),rh=new W(null,"enter","enter",1792452624),rg=new W(null,"ancestors","ancestors",-776045424),sh=new W(null,"backtick","backtick",44770640),za=new W(null,"readably","readably",1129599760),th=new W(null,"summary","summary",380847952),Xf=new W(null,"more-marker","more-marker",-14717935),uh=new W(null,"end-test-var","end-test-var",984198545),vh=new W(null,"f11","f11",-1417398799),wh=new W(null,"fail","fail",1706214930),
xh=new W(null,"after","after",594996914),yh=new W(null,"reporter","reporter",-805360621),zh=new W(null,"line","line",212345235),Ah=new W(null,".",".",335144435),Bh=new W(null,"var","var",-769682797),Ch=new W(null,"end-run-tests","end-run-tests",267300563),Dh=new W(null,"f3","f3",1954829043),Eh=new W(null,"quote","quote",-262615245),Ca=new W(null,"print-length","print-length",1931866356),Fh=new W(null,"f2","f2",396168596),Gh=new W(null,"col","col",-1959363084),Hh=new W(null,"control","control",1892578036),
Ih=new W(null,"squareleft","squareleft",-1212370731),pg=new W(null,"parents","parents",-2027538891),Jh=new W(null,"expected","expected",1583670997),Kh=new W(null,"scrolllock","scrolllock",-960203019),Lh=new W(null,"f12","f12",853352790),Mh=new W(null,"capslock","capslock",442493366),Nh=new W("cljs.test","default","cljs.test/default",-1581405322),Oh=new W(null,"source-map","source-map",1706252311),Ph=new W(null,"end-line","end-line",1837326455),Qh=new W(null,"right","right",-452581833),Rh=new W(null,
"begin-test-ns","begin-test-ns",-1701237033),Sh=new W(null,"pagedown","pagedown",-2069718984),Th=new W(null,"position","position",-2011731912),Uh=new W(null,"pause","pause",-2095325672),Vh=new W(null,"error","error",-978969032),Wh=new W(null,"backspace","backspace",-696007848),Xh=new W(null,"f7","f7",356150168),Yh=new W(null,"x","x",2099068185),Zh=new W(null,"pass","pass",1574159993),$h=new W(null,"engine","engine",1459054265),ai=new W(null,"f9","f9",704633338),bi=new W(null,"end","end",-268185958),
ci=new W(null,"arglists","arglists",1661989754),di=new W(null,"hierarchy","hierarchy",-1053470341),ei=new W(null,"actual","actual",107306363),fi=new W(null,"tab","tab",-559583621),eg=new W(null,"alt-impl","alt-impl",670969595),gi=new W(null,"doc","doc",1913296891),hi=new W(null,"before","before",-1633692388),ii=new W(null,"f6","f6",2103080604),ji=new W(null,"auto","auto",-566279492),ki=new W(null,"f4","f4",990968764),li=new W(null,"expand","expand",595248157),mi=new W(null,"end-test-ns","end-test-ns",
1620675645),ni=new W(null,"map","map",1371690461),oi=new W(null,"test","test",577538877),pi=new W("cljs.test","block?","cljs.test/block?",686379965),qi=new W(null,"none","none",1333468478),ri=new W(null,"message","message",-406056002),si=new W(null,"backslash","backslash",1790786526),ti=new W(null,"height","height",1025178622),ui=new W(null,"left","left",-399115937),vi=new W(null,"squareright","squareright",1890515359),wi=new W(null,"once-fixtures","once-fixtures",1253947167);function xi(a){return a instanceof W?[C(function(){var b=xd(a);return null==b?null:[C(b),C("/")].join("")}()),C(zd(a))].join(""):a}
function yi(a,b){var c=Qc(b);if("number"!==typeof c||!Fa(isNaN(c))||Infinity===c||parseFloat(c)!==parseInt(c,10))throw Error([C("Argument must be an integer: "),C(c)].join(""));if(0!==(c&1))throw Error([C("Assert failed: "),C(ig(U([ud(new G(null,"even?","even?",-1827825394,null),ud(new G(null,"count","count",-514511684,null),new G(null,"kvs","kvs",-1695980277,null)))],0)))].join(""));for(var c=a.style,d=I(ue(2,2,b)),e=null,f=0,g=0;;)if(g<f){var k=e.J(null,g),l=Tc(k,0),k=Tc(k,1);c.setProperty(xi(l),
k);g+=1}else if(d=I(d))ed(d)?(f=Pb(d),d=Qb(d),e=f,f=Qc(f)):(f=N(d),e=Tc(f,0),f=Tc(f,1),c.setProperty(xi(e),f),d=P(d),e=null,f=0),g=0;else break}function zi(a,b,c){b=xi(b);return y(c)?(Zc(c)?a[b]=c:a.setAttribute(b,c),a):null};var Ai,Bi=function Bi(b,c,d){if(b?b.Yb:b)return b.Yb(b,c,d);var e;e=Bi[w(null==b?null:b)];if(!e&&(e=Bi._,!e))throw A("WritePort.put!",b);return e.call(null,b,c,d)};var Ci;a:{var Di=ba.navigator;if(Di){var Ei=Di.userAgent;if(Ei){Ci=Ei;break a}}Ci=""};function Fi(){return-1!=Ci.indexOf("Edge")};for(var Gi=Array(1),Hi=0;;)if(Hi<Gi.length)Gi[Hi]=null,Hi+=1;else break;var Ji=function Ii(b){"undefined"===typeof Ai&&(Ai=function(b,d,e){this.cc=b;this.Ha=d;this.dc=e;this.m=393216;this.D=0},Ai.prototype.fa=function(b,d){return new Ai(this.cc,this.Ha,d)},Ai.prototype.P=function(){return this.dc},Ai.sc=function(){return new X(null,3,5,Z,[new G(null,"fn-handler","fn-handler",648785851,null),new G(null,"f","f",43394975,null),new G(null,"meta15223","meta15223",-37624016,null)],null)},Ai.Lb=!0,Ai.Jb="cljs.core.async/t15222",Ai.Zb=function(b){return Eb(b,"cljs.core.async/t15222")});
return new Ai(Ii,b,jf)}(function(){return null});function Ki(a,b){var c=Bi(a,b,Ji);y(c)&&(R.a?R.a(c):R.call(null,c))};var Li=document.createElement(xi(Sg)),Mi=zi(zi(zi(Li,ih,[C(pc.b("https:",document.location.protocol)?"https":"http"),C("://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js")].join("")),gh,"text/javascript"),Fg,"true"),Ni=document.getElementsByTagName("script")[0],Oi=Ni.parentNode;if(!y(Oi))throw Error([C("Assert failed: "),C("Target element must have a parent"),C("\n"),C(ig(U([new G(null,"p","p",1791580836,null)],0)))].join(""));Oi.insertBefore(Mi,Ni);function Pi(a){this.length=a.length||a;for(var b=0;b<this.length;b++)this[b]=a[b]||0}Pi.prototype.BYTES_PER_ELEMENT=4;Pi.prototype.set=function(a,b){b=b||0;for(var c=0;c<a.length&&b+c<this.length;c++)this[b+c]=a[c]};Pi.prototype.toString=Array.prototype.join;"undefined"==typeof Float32Array&&(Pi.BYTES_PER_ELEMENT=4,Pi.prototype.BYTES_PER_ELEMENT=Pi.prototype.BYTES_PER_ELEMENT,Pi.prototype.set=Pi.prototype.set,Pi.prototype.toString=Pi.prototype.toString,ca("Float32Array",Pi));var Qi=-1!=Ci.indexOf("Opera")||-1!=Ci.indexOf("OPR"),Ri=-1!=Ci.indexOf("Edge")||-1!=Ci.indexOf("Trident")||-1!=Ci.indexOf("MSIE"),Si=-1!=Ci.indexOf("Gecko")&&!(-1!=Ci.toLowerCase().indexOf("webkit")&&!Fi())&&!(-1!=Ci.indexOf("Trident")||-1!=Ci.indexOf("MSIE"))&&!Fi(),Ti=-1!=Ci.toLowerCase().indexOf("webkit")&&!Fi();
function Ui(){var a=Ci;if(Si)return/rv\:([^\);]+)(\)|;)/.exec(a);if(Ri&&Fi())return/Edge\/([\d\.]+)/.exec(a);if(Ri)return/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(a);if(Ti)return/WebKit\/(\S+)/.exec(a)}function Vi(){var a=ba.document;return a?a.documentMode:void 0}var Wi=function(){if(Qi&&ba.opera){var a=ba.opera.version;return"function"==w(a)?a():a}var a="",b=Ui();b&&(a=b?b[1]:"");return Ri&&!Fi()&&(b=Vi(),b>parseFloat(a))?String(b):a}(),Xi={};
function Yi(a){if(!Xi[a]){for(var b=0,c=ga(String(Wi)).split("."),d=ga(String(a)).split("."),e=Math.max(c.length,d.length),f=0;0==b&&f<e;f++){var g=c[f]||"",k=d[f]||"",l=RegExp("(\\d*)(\\D*)","g"),m=RegExp("(\\d*)(\\D*)","g");do{var n=l.exec(g)||["","",""],p=m.exec(k)||["","",""];if(0==n[0].length&&0==p[0].length)break;b=ka(0==n[1].length?0:parseInt(n[1],10),0==p[1].length?0:parseInt(p[1],10))||ka(0==n[2].length,0==p[2].length)||ka(n[2],p[2])}while(0==b)}Xi[a]=0<=b}}
var Zi=ba.document,$i=Vi(),aj=!Zi||!Ri||!$i&&Fi()?void 0:$i||("CSS1Compat"==Zi.compatMode?parseInt(Wi,10):5);var bj;if(!(bj=!Si&&!Ri)){var cj;if(cj=Ri)cj=Ri&&(Fi()||9<=aj);bj=cj}bj||Si&&Yi("1.9.1");Ri&&Yi("9");ma("area base br col command embed hr img input keygen link meta param source track wbr".split(" "));function dj(a){this.length=a.length||a;for(var b=0;b<this.length;b++)this[b]=a[b]||0}dj.prototype.BYTES_PER_ELEMENT=8;dj.prototype.set=function(a,b){b=b||0;for(var c=0;c<a.length&&b+c<this.length;c++)this[b+c]=a[c]};dj.prototype.toString=Array.prototype.join;if("undefined"==typeof Float64Array){try{dj.BYTES_PER_ELEMENT=8}catch(ej){}dj.prototype.BYTES_PER_ELEMENT=dj.prototype.BYTES_PER_ELEMENT;dj.prototype.set=dj.prototype.set;dj.prototype.toString=dj.prototype.toString;ca("Float64Array",dj)};function fj(){return new xa(null,4,[Qg,new xa(null,4,[oi,0,Zh,0,wh,0,Vh,0],null),Hg,oc,pe,oc,yh,Nh],null)}var gj=null;function qe(){var a=gj;return y(a)?a:fj()}function hj(){return gj=Sd(we,qe(),arguments[0],arguments[1],2<arguments.length?new M(Array.prototype.slice.call(arguments,2),0):null)}function ij(){var a=qe();gj=null;return a}
function jj(a){var b=id(a)?Pd(de,a):a,c=Uc(b,$g),d=Uc(b,zh),e=Uc(b,qh);return[C(td(je.b(function(){return function(a){return Xg.a(ad(a))}}(a,b,c,d,e),Hg.a(qe())))),C(" ("),C(c),C(":"),C(d),C(y(e)?[C(":"),C(e)].join(""):null),C(")")].join("")}function kj(a){return y(Qg.a(qe()))?hj(new X(null,2,5,Z,[Qg,a],null),Zd()):null}
if("undefined"===typeof Cg)var Cg=function(){var a=ce?ce(jf):be.call(null,jf),b=ce?ce(jf):be.call(null,jf),c=ce?ce(jf):be.call(null,jf),d=ce?ce(jf):be.call(null,jf),e=Vc(jf,di,og());return new zg(jc(),function(){return function(a){return new X(null,2,5,Z,[yh.a(qe()),gh.a(a)],null)}}(a,b,c,d,e),Vg,e,a,b,c,d)}();Bg(Vg,function(){return null});Bg(new X(null,2,5,Z,[Nh,Zh],null),function(){return kj(Zh)});
Bg(new X(null,2,5,Z,[Nh,wh],null),function(a){kj(wh);kg(U(["\nFAIL in",jj(a)],0));I(pe.a(qe()))&&kg(U([Pd(C,oe())],0));var b=ri.a(a);y(b)&&kg(U([b],0));kg(U(["expected:",ig(U([Jh.a(a)],0))],0));return kg(U(["  actual:",ig(U([ei.a(a)],0))],0))});
Bg(new X(null,2,5,Z,[Nh,Vh],null),function(a){kj(Vh);kg(U(["\nERROR in",jj(a)],0));I(pe.a(qe()))&&kg(U([Pd(C,oe())],0));var b=ri.a(a);y(b)&&kg(U([b],0));kg(U(["expected:",ig(U([Jh.a(a)],0))],0));jg.o(U(["  actual: "],0));a=U([ei.a(a)],0);Zf(gg(a,wa()));return y(ra)?hg():null});Bg(new X(null,2,5,Z,[Nh,th],null),function(a){kg(U(["\nRan",oi.a(a),"tests containing",Zh.a(a)+wh.a(a)+Vh.a(a),"assertions."],0));return kg(U([wh.a(a),"failures,",Vh.a(a),"errors."],0))});
Bg(new X(null,2,5,Z,[Nh,Rh],null),function(a){return kg(U(["\nTesting",zd(Wg.a(a))],0))});Bg(new X(null,2,5,Z,[Nh,mi],null),function(){return null});Bg(new X(null,2,5,Z,[Nh,Ng],null),function(){return null});Bg(new X(null,2,5,Z,[Nh,uh],null),function(){return null});Bg(new X(null,2,5,Z,[Nh,Ch],null),function(){return null});function lj(a){var b=a.split(":"),c=Qc(b);return new X(null,2,5,Z,[function(){var a=Sc(b,c-2);return parseInt(a)}(),function(){var a=Sc(b,c-1);return parseInt(a)}()],null)}
function mj(a,b,c){var d=new X(null,3,5,Z,[a,b,c],null),e=Oh.a(qe());if(y(e)){var f=ve(e,new X(null,2,5,Z,[a,b-1],null));return y(f)?Oe(je.b(N(function(){var a=Uc(f,c-1);return y(a)?a:Nc(N(f))}()),new X(null,3,5,Z,[jh,zh,Gh],null))):d}return d}
function nj(a,b){var c;if(c="string"===typeof a.stack){c=a.stack;if(null==c)c=null;else{var d=/\n|\r\n/;c=pc.b(""+C(d),"/(?:)/")?Oc.b(Oe(T("",je.b(C,I(c)))),""):Oe((""+C(c)).split(d));if(pc.b(0,0))b:for(;;)if(pc.b("",null==c?null:lb(c)))c=null==c?null:mb(c);else break b}c=null==c?null:Uc(c,b);c=null==c?null:ga(c)}if(y(c)){a:for(d=c.split("/out/");;){var e=P(d);if(null!=e)d=e;else{d=N(d);break a}}d=N(d.split(":"));e=lj(c);c=Tc(e,0);e=Tc(e,1);e=mj(d,c,e);c=Tc(e,0);d=Tc(e,1);e=Tc(e,2);return new xa(null,
3,[$g,c,zh,d,qh,e],null)}return new xa(null,2,[$g,a.fileName,zh,a.lineNumber],null)}function oj(a){var b=function(){switch(gh.a(a)instanceof W?gh.a(a).ya:null){case "fail":return Qf.o(U([nj(Error(),4),a],0));case "error":return Qf.o(U([nj(ei.a(a),0),a],0));default:return a}}();return Cg.a?Cg.a(b):Cg.call(null,b)}var pj={};function qj(a){return a?y(y(null)?null:a.rc)?!0:a.$b?!1:z(pj,a):z(pj,a)}
var rj=function rj(b){for(;;){var c=I(b);if(c){var d=c,e=N(d),f=e.f?e.f():e.call(null);if(y(qj(f))){var g=function(){return function(b,c){return function(){return Hb(c)?kg(U(["WARNING: Async test called done more than one time."],0)):R.a?R.a(c):R.call(null,c)}}(b,new lg(function(b){return function(){return rj(nc(b))}}(b,f,e,d,c),null),f,e,d,c)}();return f.a?f.a(g):f.call(null,g)}b=function(){var c=nc(b);return y(pi.a(ad(f)))?Ld.b(f,c):c}()}else return null}};
function sj(a){if(null==a)a=null;else{var b=Jc,c;c=ad(a);c=Wc.i?Wc.i(c,pi,!0):Wc.call(null,c,pi,!0);a=b(a,c)}return a}
function tj(a,b){if(!(a instanceof kc))throw Error([C("Assert failed: "),C(ig(U([ud(new G(null,"instance?","instance?",1075939923,null),new G(null,"Var","Var",-1833791616,null),new G(null,"v","v",1661996586,null))],0)))].join(""));return new X(null,2,5,Z,[function(){var c=new X(null,1,5,Z,[Hg],null),d=U([a],0);gj=Sd(we,qe(),c,Oc,d);hj(new X(null,2,5,Z,[Qg,oi],null),xc);oj(new xa(null,2,[gh,Ng,Bh,a],null));try{return b.f?b.f():b.call(null)}catch(e){switch(e instanceof W?e.ya:null){case "cljs.test/async-disabled":throw"Async tests require fixtures to be specified as maps.  Testing aborted.";
default:return oj(new xa(null,4,[gh,Vh,ri,"Uncaught exception, not in assertion.",Jh,null,ei,e],null))}}},function(){oj(new xa(null,2,[gh,uh,Bh,a],null));return hj(new X(null,1,5,Z,[Hg],null),nc)}],null)}function uj(a){var b=oi.a(ad(a));return y(b)?tj(a,b):null}function vj(a){return a.f?a.f():a.call(null)}function wj(a,b){return function(c){function d(){return b.a?b.a(c):b.call(null,c)}return a.a?a.a(d):a.call(null,d)}}function xj(a,b){return Ld.o($d(hi,a),b,U([td($d(xh,a))],0))}
function yj(a,b){var c=Vf(te(new Sf(null,new xa(null,1,[qi,null],null),null),je.b(function(a){return null==a||Fa(I(a))?qi:Ud(cd,a)?ni:Ud(Zc,a)?Lg:null},new X(null,2,5,Z,[a,b],null)))),d=Tc(c,0);if(!Fa(Vd(Da,c)))throw Error([C("Assert failed: "),C("Fixtures may not be of mixed types"),C("\n"),C(ig(U([ud(new G(null,"not-any?","not-any?",-2114707554,null),new G(null,"nil?","nil?",1612038930,null),new G(null,"types","types",-2064405130,null))],0)))].join(""));if(!(2>Qc(c)))throw Error([C("Assert failed: "),
C("fixtures specified in :once and :each must be of the same type"),C("\n"),C(ig(U([ud(new G(null,"\x3e","\x3e",1085014381,null),2,ud(new G(null,"count","count",-514511684,null),new G(null,"types","types",-2064405130,null)))],0)))].join(""));return(new xa(null,2,[ni,Fg,Lg,lh],null)).call(null,d,Fg)}function zj(a){return function(){var b=a.f?a.f():a.call(null);if(y(qj(b)))throw ph;return b}}
function Aj(a){return je.b(function(a){var c=Tc(a,0),d=Tc(a,1);return function(a,b,c){return function(){return sj(function(){var d=qe(),l=ve(d,new X(null,2,5,Z,[wi,b],null)),m=ve(d,new X(null,2,5,Z,[Yg,b],null)),n=yj(l,m)instanceof W?yj(l,m).ya:null;switch(n){case "async":return xj(l,re(Xd.b(Yd(xj,m),uj),U([se(Xd.b(oi,ad),c)],0)));case "sync":var p=Na(wj,vj,m);return new X(null,1,5,Z,[function(a,b,c,d,e,f,g,k){return function(){return Na(wj,vj,d).call(null,function(a,b,c,d,e,f,g,k){return function(){for(var l=
I(k),m=null,n=0,p=0;;)if(p<n){var q=m.J(null,p),r=oi.a(ad(q));y(r)&&(r=function(a,b,c,d,e,f,g){return function(){return rj(tj(g,zj(e)))}}(l,m,n,p,r,r,q,a,b,c,d,e,f,g,k),a.a?a.a(r):a.call(null,r));p+=1}else{var t=I(l);if(t){r=t;if(ed(r))l=Pb(r),p=Qb(r),m=l,n=Qc(l),l=p;else{var q=N(r),v=oi.a(ad(q));y(v)&&(l=function(a,b,c,d,e,f,g){return function(){return rj(tj(g,zj(e)))}}(l,m,n,p,v,v,q,r,t,a,b,c,d,e,f,g,k),a.a?a.a(l):a.call(null,l));l=P(r);m=null;n=0}p=0}else return null}}}(a,b,c,d,e,f,g,k))}}(p,n,
d,l,m,a,b,c)],null);default:throw Error([C("No matching clause: "),C(yj(l,m))].join(""));}}())}}(a,c,d)},mg(Xd.b(Wg,ad),a))};if("undefined"===typeof Bj)var Bj=!0;var Cj=ce?ce(jf):be.call(null,jf);
Qf.o(U([Xc([Eg,Gg,Ig,Jg,Kg,Mg,Og,Pg,Rg,Ug,Zg,bh,eh,fh,hh,kh,mh,rh,sh,vh,Ah,Dh,Eh,Fh,Hh,Ih,Kh,Lh,Mh,Qh,Sh,Uh,Wh,Xh,ai,bi,fi,ii,ki,si,ui,vi],[16,40,32,36,45,119,112,121,18,27,188,144,116,33,46,191,38,13,192,122,190,114,222,113,17,219,145,123,20,39,34,19,8,118,120,35,9,117,115,220,37,221]),function Dj(b){return new Ad(null,function(){for(;;){var c=I(b);if(c){if(ed(c)){var d=Pb(c),e=Qc(d),f=Ed(e);a:for(var g=0;;)if(g<e){var k=D.b(d,g),k=new X(null,2,5,Z,[yd.a(""+C(k)),k.charCodeAt(0)-32],null);f.add(k);
g+=1}else{d=!0;break a}return d?Gd(f.ta(),Dj(Qb(c))):Gd(f.ta(),null)}f=N(c);return T(new X(null,2,5,Z,[yd.a(""+C(f)),f.charCodeAt(0)-32],null),Dj(nc(c)))}return null}},null,null)}("0123456789abcdefghijklmnopqrstuvwxyz"),function Ej(b){return new Ad(null,function(){for(;;){var c=I(b);if(c){if(ed(c)){var d=Pb(c),e=Qc(d),f=Ed(e);a:for(var g=0;;)if(g<e){var k=D.b(d,g);f.add(new X(null,2,5,Z,[k,k.charCodeAt(0)-32],null));g+=1}else{d=!0;break a}return d?Gd(f.ta(),Ej(Qb(c))):Gd(f.ta(),null)}f=N(c);return T(new X(null,
2,5,Z,[f,f.charCodeAt(0)-32],null),Ej(nc(c)))}return null}},null,null)}("0123456789abcdefghijklmnopqrstuvwxyz,.;'[]-\x3d`/\\")],0));
var Fj=y(window.requestAnimationFrame)?function(a){return window.requestAnimationFrame(a)}:y(window.webkitRequestAnimationFrame)?function(a){return window.webkitRequestAnimationFrame(a)}:y(window.mozRequestAnimationFrame)?function(a){return window.mozRequestAnimationFrame(a)}:y(window.oRequestAnimationFrame)?function(a){return window.oRequestAnimationFrame(a)}:y(window.msRequestAnimationFrame)?function(a){return window.msRequestAnimationFrame(a)}:function(a){return window.setTimeout(a,1E3/60)},Gj=
ce?ce(Uf):be.call(null,Uf),Hj=ce?ce(Uf):be.call(null,Uf),Ij=function Ij(){Fj.a?Fj.a(Ij):Fj.call(null,Ij);for(var b=I(R.a?R.a(Hj):R.call(null,Hj)),c=null,d=0,e=0;;)if(e<d){var f=c.J(null,e);Ki(f,!0);e+=1}else if(b=I(b))c=b,ed(c)?(b=Pb(c),d=Qb(c),c=b,f=Qc(b),b=d,d=f):(f=N(c),Ki(f,!0),b=P(c),c=null,d=0),e=0;else return null};
window.addEventListener("keydown",function(a){he.b(Cj,function(b){return Wc.i(b,a.keyCode,!0)});return y(function(){if(y(Bj)){var b=a.ctrlKey;return y(b)?a.shiftKey:b}return Bj}())?!1:a.preventDefault()});window.addEventListener("keyup",function(a){he.b(Cj,function(b){return Yc.b(b,a.keyCode)});a.preventDefault();return!0});Fj.a?Fj.a(Ij):Fj.call(null,Ij);
window.addEventListener("resize",function(){for(var a=new X(null,2,5,Z,[window.innerWidth,window.innerHeight],null),b=I(R.a?R.a(Gj):R.call(null,Gj)),c=null,d=0,e=0;;)if(e<d){var f=c.J(null,e);Ki(f,a);e+=1}else if(b=I(b))c=b,ed(c)?(b=Pb(c),d=Qb(c),c=b,f=Qc(b),b=d,d=f):(f=N(c),Ki(f,a),b=P(c),c=null,d=0),e=0;else return null});function Jj(a){var b=id(a)?Pd(de,a):a,c=Vc(b,li,!1),d=Vc(b,Yh,0),e=Vc(b,Dg,0),f=Vc(b,ch,800),g=Vc(b,ti,600);a=Uc(b,nh);var k=Vc(b,$h,ji),l=window.innerWidth,b=window.innerHeight,m=y(c)?l:f,n=y(c)?b:g,p={view:a,transparent:!1,antialias:!1,preserveDrawingBuffer:!1,resolution:1,clearBeforeRender:!0,autoResize:!1,imageSmoothingEnabled:!1},f=function(){switch(k instanceof W?k.ya:null){case "webgl":return new PIXI.WebGLRenderer(m,n,p);case "canvas":return new PIXI.CanvasRenderer(m,n,p);default:return new PIXI.autoDetectRenderer(m,
n,p)}}(),g=f.view,q=g.width,r=g.height;y(a)||(yi(g,U([ui,y(c)?0:d,Tg,y(c)?0:e,Th,"absolute"],0)),document.body.appendChild(g));d=y(c)?l:q;c=y(c)?b:r;Math.round(d/2);Math.round(c/2);f.resize(d,c);return new xa(null,2,[oh,f,nh,y(a)?a:g],null)};function Kj(a,b){return b<a.length?T(a[b],new Ad(null,function(){return Kj(a,b+1)},null,null)):null}var Lj=function Lj(){return rj(uj(Lj.ac))};
Lj.Kb=function(){try{var a=Ua(Ua(oc,nh),$h),b=Pd(Jj,a);y(b)?oj(new xa(null,4,[gh,Zh,Jh,ud(new G("canvas","make","canvas/make",-1481494558,null),$h,nh),ei,T(Jj,a),ri,null],null)):oj(new xa(null,4,[gh,wh,Jh,ud(new G("canvas","make","canvas/make",-1481494558,null),$h,nh),ei,Ua(Ua(oc,T(new G("canvas","make","canvas/make",-1481494558,null),a)),new G(null,"not","not",1044554643,null)),ri,null],null))}catch(c){oj(new xa(null,4,[gh,Vh,Jh,ud(new G("canvas","make","canvas/make",-1481494558,null),$h,nh),ei,
c,ri,null],null))}try{var d=Ua(Ua(oc,ji),$h),e=Pd(Jj,d);y(e)?oj(new xa(null,4,[gh,Zh,Jh,ud(new G("canvas","make","canvas/make",-1481494558,null),$h,ji),ei,T(Jj,d),ri,null],null)):oj(new xa(null,4,[gh,wh,Jh,ud(new G("canvas","make","canvas/make",-1481494558,null),$h,ji),ei,Ua(Ua(oc,T(new G("canvas","make","canvas/make",-1481494558,null),d)),new G(null,"not","not",1044554643,null)),ri,null],null))}catch(f){oj(new xa(null,4,[gh,Vh,Jh,ud(new G("canvas","make","canvas/make",-1481494558,null),$h,ji),ei,
f,ri,null],null))}a:for(var a=document,a=a.querySelectorAll&&a.querySelector?a.querySelectorAll("CANVAS"):a.getElementsByTagName("CANVAS"),a=Kj(a,0),a=I(a),b=null,g=e=0;;)if(g<e)(d=b.J(null,g))&&d.parentNode&&d.parentNode.removeChild(d),g+=1;else if(a=I(a))b=a,ed(b)?(a=Pb(b),e=Qb(b),b=a,d=Qc(a),a=e,e=d):((d=N(b))&&d.parentNode&&d.parentNode.removeChild(d),a=P(b),b=null,e=0),g=0;else break a;return null};
Lj.ac=new kc(function(){return Lj},new G("infinitelives.pixi.canvas-test","make","infinitelives.pixi.canvas-test/make",1375686724,null),Xc([Wg,Xg,$g,ah,qh,zh,Ph,ci,gi,oi],[new G(null,"infinitelives.pixi.canvas-test","infinitelives.pixi.canvas-test",-2140988248,null),new G(null,"make","make",356488202,null),"test/infinitelives/pixi/canvas_test.cljs",14,1,21,21,oc,null,y(Lj)?Lj.Kb:null]));if("undefined"===typeof Mj)var Mj=ce?ce(jf):be.call(null,jf);ra=!1;pa=function(){function a(a){var d=null;if(0<arguments.length){for(var d=0,e=Array(arguments.length-0);d<e.length;)e[d]=arguments[d+0],++d;d=new M(e,0)}return b.call(this,d)}function b(a){return console.log.apply(console,Ma?La(a):Ja.call(null,a))}a.C=0;a.A=function(a){a=I(a);return b(a)};a.o=b;return a}();
ca("infinitelives.test.run",function(){return rj(function(){var a=fj(),b=new ie(new xa(null,5,[gh,th,wh,0,Vh,0,Zh,0,oi,0],null));return Ld.o(Ld.b(new X(null,2,5,Z,[function(a,b){return function(){gj=a;oj(new xa(null,2,[Wg,new G(null,"infinitelives.pixi.texture-test","infinitelives.pixi.texture-test",-121768925,null),gh,Rh],null));return sj(function(){var e=qe();return Ld.o(new X(null,1,5,Z,[function(a){return function(){null==a&&(gj=fj());return null}}(e,a,b)],null),Aj(Pc),U([new X(null,1,5,Z,[function(a){return function(){return null==
a?gj=null:null}}(e,a,b)],null)],0))}())}}(a,b),function(){return function(){return oj(new xa(null,2,[Wg,new G(null,"infinitelives.pixi.texture-test","infinitelives.pixi.texture-test",-121768925,null),gh,mi],null))}}(a,b)],null),new X(null,1,5,Z,[function(a,b){return function(){return Wb(b,Yd(Rf,nd).call(null,pb(b),Qg.a(ij())))}}(a,b)],null)),Ld.b(new X(null,2,5,Z,[function(a,b){return function(){gj=a;oj(new xa(null,2,[Wg,new G(null,"infinitelives.pixi.canvas-test","infinitelives.pixi.canvas-test",
-2140988248,null),gh,Rh],null));return sj(function(){var e=qe();return Ld.o(new X(null,1,5,Z,[function(a){return function(){null==a&&(gj=fj());return null}}(e,a,b)],null),Aj(new X(null,1,5,Z,[new kc(function(){return Lj},new G("infinitelives.pixi.canvas-test","make","infinitelives.pixi.canvas-test/make",1375686724,null),Xc([Wg,Xg,$g,ah,qh,zh,Ph,ci,gi,oi],[new G(null,"infinitelives.pixi.canvas-test","infinitelives.pixi.canvas-test",-2140988248,null),new G(null,"make","make",356488202,null),"test/infinitelives/pixi/canvas_test.cljs",
14,1,21,21,oc,null,y(Lj)?Lj.Kb:null]))],null)),U([new X(null,1,5,Z,[function(a){return function(){return null==a?gj=null:null}}(e,a,b)],null)],0))}())}}(a,b),function(){return function(){return oj(new xa(null,2,[Wg,new G(null,"infinitelives.pixi.canvas-test","infinitelives.pixi.canvas-test",-2140988248,null),gh,mi],null))}}(a,b)],null),new X(null,1,5,Z,[function(a,b){return function(){return Wb(b,Yd(Rf,nd).call(null,pb(b),Qg.a(ij())))}}(a,b)],null)),U([Ld.b(new X(null,2,5,Z,[function(a,b){return function(){gj=
a;oj(new xa(null,2,[Wg,new G(null,"infinitelives.pixi.resources-test","infinitelives.pixi.resources-test",-861381833,null),gh,Rh],null));return sj(function(){var e=qe();return Ld.o(new X(null,1,5,Z,[function(a){return function(){null==a&&(gj=fj());return null}}(e,a,b)],null),Aj(Pc),U([new X(null,1,5,Z,[function(a){return function(){return null==a?gj=null:null}}(e,a,b)],null)],0))}())}}(a,b),function(){return function(){return oj(new xa(null,2,[Wg,new G(null,"infinitelives.pixi.resources-test","infinitelives.pixi.resources-test",
-861381833,null),gh,mi],null))}}(a,b)],null),new X(null,1,5,Z,[function(a,b){return function(){return Wb(b,Yd(Rf,nd).call(null,pb(b),Qg.a(ij())))}}(a,b)],null)),new X(null,1,5,Z,[function(a,b){return function(){gj=a;oj(R.a?R.a(b):R.call(null,b));var e=Wc.i(R.a?R.a(b):R.call(null,b),gh,Ch);Cg.a?Cg.a(e):Cg.call(null,e);return gj=null}}(a,b)],null)],0))}())});var Nj=y(window.requestAnimationFrame)?function(a){return window.requestAnimationFrame(a)}:y(window.webkitRequestAnimationFrame)?function(a){return window.webkitRequestAnimationFrame(a)}:y(window.mozRequestAnimationFrame)?function(a){return window.mozRequestAnimationFrame(a)}:y(window.oRequestAnimationFrame)?function(a){return window.oRequestAnimationFrame(a)}:y(window.msRequestAnimationFrame)?function(a){return window.msRequestAnimationFrame(a)}:function(a){return window.setTimeout(a,1E3/60)},Oj=
ce?ce(Uf):be.call(null,Uf),Pj=ce?ce(Uf):be.call(null,Uf),Qj=function Qj(){Nj.a?Nj.a(Qj):Nj.call(null,Qj);for(var b=I(R.a?R.a(Pj):R.call(null,Pj)),c=null,d=0,e=0;;)if(e<d){var f=c.J(null,e);Ki(f,!0);e+=1}else if(b=I(b))c=b,ed(c)?(b=Pb(c),d=Qb(c),c=b,f=Qc(b),b=d,d=f):(f=N(c),Ki(f,!0),b=P(c),c=null,d=0),e=0;else return null};Nj.a?Nj.a(Qj):Nj.call(null,Qj);
window.addEventListener("resize",function(){for(var a=new X(null,2,5,Z,[window.innerWidth,window.innerHeight],null),b=I(R.a?R.a(Oj):R.call(null,Oj)),c=null,d=0,e=0;;)if(e<d){var f=c.J(null,e);Ki(f,a);e+=1}else if(b=I(b))c=b,ed(c)?(b=Pb(c),d=Qb(c),c=b,f=Qc(b),b=d,d=f):(f=N(c),Ki(f,a),b=P(c),c=null,d=0),e=0;else return null});
})();
