/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleFFT_1D {
    private int n;
    private int nBluestein;
    private int[] ip;
    private double[] w;
    private int nw;
    private int nc;
    private double[] wtable;
    private double[] wtable_r;
    private double[] bk1;
    private double[] bk2;
    private Plans plan;
    private static final int[] factors = new int[]{4, 2, 3, 5};
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;

    public DoubleFFT_1D(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.n = n;
        if (!ConcurrencyUtils.isPowerOf2((int)n)) {
            if (DoubleFFT_1D.getReminder(n, factors) >= 211) {
                this.plan = Plans.BLUESTEIN;
                this.nBluestein = ConcurrencyUtils.nextPow2((int)(n * 2 - 1));
                this.bk1 = new double[2 * this.nBluestein];
                this.bk2 = new double[2 * this.nBluestein];
                this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)this.nBluestein + 0.5) / Math.log(2.0)) / 2))];
                this.w = new double[this.nBluestein];
                int n2 = 2 * this.nBluestein;
                this.nw = this.ip[0];
                if (n2 > this.nw << 2) {
                    this.nw = n2 >> 2;
                    this.makewt(this.nw);
                }
                this.nc = this.ip[1];
                if (this.nBluestein > this.nc << 2) {
                    this.nc = this.nBluestein >> 2;
                    this.makect(this.nc, this.w, this.nw);
                }
                this.bluesteini();
            } else {
                this.plan = Plans.MIXED_RADIX;
                this.wtable = new double[4 * n + 15];
                this.wtable_r = new double[2 * n + 15];
                this.cffti();
                this.rffti();
            }
        } else {
            this.plan = Plans.SPLIT_RADIX;
            this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)n + 0.5) / Math.log(2.0)) / 2))];
            this.w = new double[n];
            int n3 = 2 * n;
            this.nw = this.ip[0];
            if (n3 > this.nw << 2) {
                this.nw = n3 >> 2;
                this.makewt(this.nw);
            }
            this.nc = this.ip[1];
            if (n > this.nc << 2) {
                this.nc = n >> 2;
                this.makect(this.nc, this.w, this.nw);
            }
        }
    }

    public void complexForward(double[] dArray) {
        this.complexForward(dArray, 0);
    }

    public void complexForward(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.cftbsub(2 * this.n, dArray, n, this.ip, this.nw, this.w);
                break;
            }
            case MIXED_RADIX: {
                this.cfftf(dArray, n, -1);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_complex(dArray, n, -1);
            }
        }
    }

    public void complexInverse(double[] dArray, boolean bl) {
        this.complexInverse(dArray, 0, bl);
    }

    public void complexInverse(double[] dArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.cftfsub(2 * this.n, dArray, n, this.ip, this.nw, this.w);
                break;
            }
            case MIXED_RADIX: {
                this.cfftf(dArray, n, 1);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_complex(dArray, n, 1);
            }
        }
        if (bl) {
            this.scale(this.n, dArray, n, true);
        }
    }

    public void realForward(double[] dArray) {
        this.realForward(dArray, 0);
    }

    public void realForward(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.n > 4) {
                    this.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
                    this.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
                } else if (this.n == 4) {
                    this.cftx020(dArray, n);
                }
                double d = dArray[n] - dArray[n + 1];
                int n2 = n;
                dArray[n2] = dArray[n2] + dArray[n + 1];
                dArray[n + 1] = d;
                break;
            }
            case MIXED_RADIX: {
                this.rfftf(dArray, n);
                for (int i = this.n - 1; i >= 2; --i) {
                    int n3 = n + i;
                    double d = dArray[n3];
                    dArray[n3] = dArray[n3 - 1];
                    dArray[n3 - 1] = d;
                }
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_forward(dArray, n);
            }
        }
    }

    public void realForwardFull(double[] dArray) {
        this.realForwardFull(dArray, 0);
    }

    public void realForwardFull(final double[] dArray, final int n) {
        final int n2 = 2 * this.n;
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.realForward(dArray, n);
                int n3 = ConcurrencyUtils.getNumberOfThreads();
                if (n3 > 1 && this.n / 2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    Future[] futureArray = new Future[n3];
                    int n4 = this.n / 2 / n3;
                    for (int i = 0; i < n3; ++i) {
                        final int n5 = i * n4;
                        final int n6 = i == n3 - 1 ? this.n / 2 : n5 + n4;
                        futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                            public void run() {
                                for (int i = n5; i < n6; ++i) {
                                    int n3 = 2 * i;
                                    int n22 = n + (n2 - n3) % n2;
                                    dArray[n22] = dArray[n + n3];
                                    dArray[n22 + 1] = -dArray[n + n3 + 1];
                                }
                            }
                        });
                    }
                    ConcurrencyUtils.waitForCompletion((Future[])futureArray);
                } else {
                    for (int i = 0; i < this.n / 2; ++i) {
                        int n7 = 2 * i;
                        int n8 = n + (n2 - n7) % n2;
                        dArray[n8] = dArray[n + n7];
                        dArray[n8 + 1] = -dArray[n + n7 + 1];
                    }
                }
                dArray[n + this.n] = -dArray[n + 1];
                dArray[n + 1] = 0.0;
                break;
            }
            case MIXED_RADIX: {
                int n9;
                int n10;
                this.rfftf(dArray, n);
                int n11 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                for (n10 = 1; n10 < n11; ++n10) {
                    n9 = n + n2 - 2 * n10;
                    int n12 = n + 2 * n10;
                    dArray[n9 + 1] = -dArray[n12];
                    dArray[n9] = dArray[n12 - 1];
                }
                for (n10 = 1; n10 < this.n; ++n10) {
                    n9 = n + this.n - n10;
                    double d = dArray[n9 + 1];
                    dArray[n9 + 1] = dArray[n9];
                    dArray[n9] = d;
                }
                dArray[n + 1] = 0.0;
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_full(dArray, n, -1);
            }
        }
    }

    public void realInverse(double[] dArray, boolean bl) {
        this.realInverse(dArray, 0, bl);
    }

    public void realInverse(double[] dArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                dArray[n + 1] = 0.5 * (dArray[n] - dArray[n + 1]);
                int n2 = n;
                dArray[n2] = dArray[n2] - dArray[n + 1];
                if (this.n > 4) {
                    this.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
                    this.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
                } else if (this.n == 4) {
                    this.cftxc020(dArray, n);
                }
                if (!bl) break;
                this.scale(this.n / 2, dArray, n, false);
                break;
            }
            case MIXED_RADIX: {
                for (int i = 2; i < this.n; ++i) {
                    int n3 = n + i;
                    double d = dArray[n3 - 1];
                    dArray[n3 - 1] = dArray[n3];
                    dArray[n3] = d;
                }
                this.rfftb(dArray, n);
                if (!bl) break;
                this.scale(this.n, dArray, n, false);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse(dArray, n);
                if (!bl) break;
                this.scale(this.n, dArray, n, false);
            }
        }
    }

    public void realInverseFull(double[] dArray, boolean bl) {
        this.realInverseFull(dArray, 0, bl);
    }

    public void realInverseFull(final double[] dArray, final int n, boolean bl) {
        final int n2 = 2 * this.n;
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.realInverse2(dArray, n, bl);
                int n3 = ConcurrencyUtils.getNumberOfThreads();
                if (n3 > 1 && this.n / 2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    Future[] futureArray = new Future[n3];
                    int n4 = this.n / 2 / n3;
                    for (int i = 0; i < n3; ++i) {
                        final int n5 = i * n4;
                        final int n6 = i == n3 - 1 ? this.n / 2 : n5 + n4;
                        futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                            public void run() {
                                for (int i = n5; i < n6; ++i) {
                                    int n3 = 2 * i;
                                    int n22 = n + (n2 - n3) % n2;
                                    dArray[n22] = dArray[n + n3];
                                    dArray[n22 + 1] = -dArray[n + n3 + 1];
                                }
                            }
                        });
                    }
                    ConcurrencyUtils.waitForCompletion((Future[])futureArray);
                } else {
                    for (int i = 0; i < this.n / 2; ++i) {
                        int n7 = 2 * i;
                        int n8 = n + (n2 - n7) % n2;
                        dArray[n8] = dArray[n + n7];
                        dArray[n8 + 1] = -dArray[n + n7 + 1];
                    }
                }
                dArray[n + this.n] = -dArray[n + 1];
                dArray[n + 1] = 0.0;
                break;
            }
            case MIXED_RADIX: {
                int n9;
                int n10;
                this.rfftf(dArray, n);
                if (bl) {
                    this.scale(this.n, dArray, n, false);
                }
                int n11 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                for (n10 = 1; n10 < n11; ++n10) {
                    n9 = n + 2 * n10;
                    int n12 = n + n2 - 2 * n10;
                    dArray[n9] = -dArray[n9];
                    dArray[n12 + 1] = -dArray[n9];
                    dArray[n12] = dArray[n9 - 1];
                }
                for (n10 = 1; n10 < this.n; ++n10) {
                    n9 = n + this.n - n10;
                    double d = dArray[n9 + 1];
                    dArray[n9 + 1] = dArray[n9];
                    dArray[n9] = d;
                }
                dArray[n + 1] = 0.0;
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_full(dArray, n, 1);
                if (!bl) break;
                this.scale(this.n, dArray, n, true);
            }
        }
    }

    protected void realInverse2(double[] dArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.n > 4) {
                    this.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
                    this.rftbsub(this.n, dArray, n, this.nc, this.w, this.nw);
                } else if (this.n == 4) {
                    this.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
                }
                double d = dArray[n] - dArray[n + 1];
                int n2 = n;
                dArray[n2] = dArray[n2] + dArray[n + 1];
                dArray[n + 1] = d;
                if (!bl) break;
                this.scale(this.n, dArray, n, false);
                break;
            }
            case MIXED_RADIX: {
                int n3;
                int n4;
                this.rfftf(dArray, n);
                for (n4 = this.n - 1; n4 >= 2; --n4) {
                    n3 = n + n4;
                    double d = dArray[n3];
                    dArray[n3] = dArray[n3 - 1];
                    dArray[n3 - 1] = d;
                }
                if (bl) {
                    this.scale(this.n, dArray, n, false);
                }
                if (this.n % 2 == 0) {
                    n4 = this.n / 2;
                    for (n3 = 1; n3 < n4; ++n3) {
                        int n5 = n + 2 * n3 + 1;
                        dArray[n5] = -dArray[n5];
                    }
                } else {
                    n4 = (this.n - 1) / 2;
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n6 = n + 2 * n3 + 1;
                        dArray[n6] = -dArray[n6];
                    }
                }
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse2(dArray, n);
                if (!bl) break;
                this.scale(this.n, dArray, n, false);
            }
        }
    }

    private static int getReminder(int n, int[] nArray) {
        int n2 = n;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive integer");
        }
        for (int i = 0; i < nArray.length && n2 != 1; ++i) {
            int n3 = nArray[i];
            while (n2 % n3 == 0) {
                n2 /= n3;
            }
        }
        return n2;
    }

    void cffti(int n, int n2) {
        int n3;
        int n4;
        if (n == 1) {
            return;
        }
        int n5 = 2 * n;
        int n6 = 4 * n;
        int n7 = 0;
        int n8 = n;
        int n9 = 0;
        int n10 = 0;
        block0: while (true) {
            n7 = ++n10 <= 4 ? factors[n10 - 1] : (n7 += 2);
            do {
                int n11;
                int n12;
                if ((n12 = n8 - n7 * (n11 = n8 / n7)) != 0) continue block0;
                this.wtable[n2 + ++n9 + 1 + n6] = n7;
                n8 = n11;
                if (n7 != 2 || n9 == 1) continue;
                for (n4 = 2; n4 <= n9; ++n4) {
                    int n13 = n9 - n4 + 2;
                    n3 = n13 + n6;
                    this.wtable[n2 + n3 + 1] = this.wtable[n2 + n3];
                }
                this.wtable[n2 + 2 + n6] = 2.0;
            } while (n8 != 1);
            break;
        }
        this.wtable[n2 + n6] = n;
        this.wtable[n2 + 1 + n6] = n9;
        double d = Math.PI * 2 / (double)n;
        n4 = 1;
        int n14 = 1;
        for (int i = 1; i <= n9; ++i) {
            int n15 = (int)this.wtable[n2 + i + 1 + n6];
            int n16 = 0;
            int n17 = n14 * n15;
            int n18 = n / n17;
            int n19 = n18 + n18 + 2;
            int n20 = n15 - 1;
            for (n10 = 1; n10 <= n20; ++n10) {
                int n21 = n4;
                this.wtable[n2 + n4 - 1 + n5] = 1.0;
                this.wtable[n2 + n4 + n5] = 0.0;
                double d2 = 0.0;
                double d3 = (double)(n16 += n14) * d;
                for (int j = 4; j <= n19; j += 2) {
                    double d4 = (d2 += 1.0) * d3;
                    n3 = (n4 += 2) + n5;
                    this.wtable[n2 + n3 - 1] = Math.cos(d4);
                    this.wtable[n2 + n3] = Math.sin(d4);
                }
                if (n15 <= 5) continue;
                n3 = n21 + n5;
                int n22 = n4 + n5;
                this.wtable[n2 + n3 - 1] = this.wtable[n2 + n22 - 1];
                this.wtable[n2 + n3] = this.wtable[n2 + n22];
            }
            n14 = n17;
        }
    }

    void cffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 4 * this.n;
        int n5 = 0;
        int n6 = this.n;
        int n7 = 0;
        int n8 = 0;
        block0: while (true) {
            n5 = ++n8 <= 4 ? factors[n8 - 1] : (n5 += 2);
            do {
                int n9;
                int n10;
                if ((n10 = n6 - n5 * (n9 = n6 / n5)) != 0) continue block0;
                this.wtable[++n7 + 1 + n4] = n5;
                n6 = n9;
                if (n5 != 2 || n7 == 1) continue;
                for (n2 = 2; n2 <= n7; ++n2) {
                    int n11 = n7 - n2 + 2;
                    n = n11 + n4;
                    this.wtable[n + 1] = this.wtable[n];
                }
                this.wtable[2 + n4] = 2.0;
            } while (n6 != 1);
            break;
        }
        this.wtable[n4] = this.n;
        this.wtable[1 + n4] = n7;
        double d = Math.PI * 2 / (double)this.n;
        n2 = 1;
        int n12 = 1;
        for (int i = 1; i <= n7; ++i) {
            int n13 = (int)this.wtable[i + 1 + n4];
            int n14 = 0;
            int n15 = n12 * n13;
            int n16 = this.n / n15;
            int n17 = n16 + n16 + 2;
            int n18 = n13 - 1;
            for (n8 = 1; n8 <= n18; ++n8) {
                int n19 = n2;
                this.wtable[n2 - 1 + n3] = 1.0;
                this.wtable[n2 + n3] = 0.0;
                double d2 = 0.0;
                double d3 = (double)(n14 += n12) * d;
                for (int j = 4; j <= n17; j += 2) {
                    double d4 = (d2 += 1.0) * d3;
                    n = (n2 += 2) + n3;
                    this.wtable[n - 1] = Math.cos(d4);
                    this.wtable[n] = Math.sin(d4);
                }
                if (n13 <= 5) continue;
                n = n19 + n3;
                int n20 = n2 + n3;
                this.wtable[n - 1] = this.wtable[n20 - 1];
                this.wtable[n] = this.wtable[n20];
            }
            n12 = n15;
        }
    }

    void rffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 0;
        int n5 = this.n;
        int n6 = 0;
        int n7 = 0;
        block0: while (true) {
            n4 = ++n7 <= 4 ? factors[n7 - 1] : (n4 += 2);
            do {
                int n8;
                int n9;
                if ((n9 = n5 - n4 * (n8 = n5 / n4)) != 0) continue block0;
                this.wtable_r[++n6 + 1 + n3] = n4;
                n5 = n8;
                if (n4 != 2 || n6 == 1) continue;
                for (n2 = 2; n2 <= n6; ++n2) {
                    int n10 = n6 - n2 + 2;
                    n = n10 + n3;
                    this.wtable_r[n + 1] = this.wtable_r[n];
                }
                this.wtable_r[2 + n3] = 2.0;
            } while (n5 != 1);
            break;
        }
        this.wtable_r[n3] = this.n;
        this.wtable_r[1 + n3] = n6;
        double d = Math.PI * 2 / (double)this.n;
        int n11 = 0;
        int n12 = n6 - 1;
        int n13 = 1;
        if (n12 == 0) {
            return;
        }
        for (int i = 1; i <= n12; ++i) {
            int n14 = (int)this.wtable_r[i + 1 + n3];
            int n15 = 0;
            int n16 = n13 * n14;
            int n17 = this.n / n16;
            int n18 = n14 - 1;
            for (n7 = 1; n7 <= n18; ++n7) {
                n2 = n11;
                double d2 = (double)(n15 += n13) * d;
                double d3 = 0.0;
                for (int j = 3; j <= n17; j += 2) {
                    double d4 = (d3 += 1.0) * d2;
                    n = (n2 += 2) + this.n;
                    this.wtable_r[n - 2] = Math.cos(d4);
                    this.wtable_r[n - 1] = Math.sin(d4);
                }
                n11 += n17;
            }
            n13 = n16;
        }
    }

    private void bluesteini() {
        int n = 0;
        double d = Math.PI / (double)this.n;
        this.bk1[0] = 1.0;
        this.bk1[1] = 0.0;
        for (int i = 1; i < this.n; ++i) {
            if ((n += 2 * i - 1) >= 2 * this.n) {
                n -= 2 * this.n;
            }
            double d2 = d * (double)n;
            this.bk1[2 * i] = Math.cos(d2);
            this.bk1[2 * i + 1] = Math.sin(d2);
        }
        double d3 = 1.0 / (double)this.nBluestein;
        this.bk2[0] = this.bk1[0] * d3;
        this.bk2[1] = this.bk1[1] * d3;
        for (int i = 2; i < 2 * this.n; i += 2) {
            this.bk2[i] = this.bk1[i] * d3;
            this.bk2[i + 1] = this.bk1[i + 1] * d3;
            this.bk2[2 * this.nBluestein - i] = this.bk2[i];
            this.bk2[2 * this.nBluestein - i + 1] = this.bk2[i + 1];
        }
        this.cftbsub(2 * this.nBluestein, this.bk2, 0, this.ip, this.nw, this.w);
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            double d2 = d * 2.0;
            double d3 = Math.cos(d * (double)n3);
            this.w[0] = 1.0;
            this.w[1] = d3;
            if (n3 == 4) {
                this.w[2] = Math.cos(d2);
                this.w[3] = Math.sin(d2);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = 0.5 / Math.cos(d2);
                this.w[3] = 0.5 / Math.cos(d * 6.0);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    double d4 = d * (double)n2;
                    double d5 = 3.0 * d4;
                    this.w[n2] = Math.cos(d4);
                    this.w[n2 + 1] = Math.sin(d4);
                    this.w[n2 + 2] = Math.cos(d5);
                    this.w[n2 + 3] = -Math.sin(d5);
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                double d6;
                double d7;
                int n5 = n4 + n3;
                this.w[n5] = 1.0;
                this.w[n5 + 1] = d3;
                if ((n3 >>= 1) == 4) {
                    d7 = this.w[n4 + 4];
                    d6 = this.w[n4 + 5];
                    this.w[n5 + 2] = d7;
                    this.w[n5 + 3] = d6;
                } else if (n3 > 4) {
                    d7 = this.w[n4 + 4];
                    double d8 = this.w[n4 + 6];
                    this.w[n5 + 2] = 0.5 / d7;
                    this.w[n5 + 3] = 0.5 / d8;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        d7 = this.w[n6];
                        d6 = this.w[n6 + 1];
                        d8 = this.w[n6 + 2];
                        double d9 = this.w[n6 + 3];
                        this.w[n7] = d7;
                        this.w[n7 + 1] = d6;
                        this.w[n7 + 2] = d8;
                        this.w[n7 + 3] = d9;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, double[] dArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            dArray[n2] = Math.cos(d * (double)n3);
            dArray[n2 + n3] = 0.5 * dArray[n2];
            for (int i = 1; i < n3; ++i) {
                double d2 = d * (double)i;
                dArray[n2 + i] = 0.5 * Math.cos(d2);
                dArray[n2 + n - i] = 0.5 * Math.sin(d2);
            }
        }
    }

    private void bluestein_complex(final double[] dArray, final int n, final int n2) {
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6;
            n3 = 2;
            if (n3 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            int n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                dArray2[n8] = dArray[n3] * DoubleFFT_1D.this.bk1[n8] - dArray[n42] * DoubleFFT_1D.this.bk1[n22];
                                dArray2[n22] = dArray[n3] * DoubleFFT_1D.this.bk1[n22] + dArray[n42] * DoubleFFT_1D.this.bk1[n8];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                dArray2[n9] = dArray[n6] * DoubleFFT_1D.this.bk1[n9] + dArray[n7] * DoubleFFT_1D.this.bk1[n52];
                                dArray2[n52] = -dArray[n6] * DoubleFFT_1D.this.bk1[n52] + dArray[n7] * DoubleFFT_1D.this.bk1[n9];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n7 = this.nBluestein / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.nBluestein : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n22] + dArray2[n22] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n22] * DoubleFFT_1D.this.bk2[n22];
                                dArray2[n22] = d;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                double d = dArray2[n] * DoubleFFT_1D.this.bk2[n3] + dArray2[n3] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] - dArray2[n3] * DoubleFFT_1D.this.bk2[n3];
                                dArray2[n3] = d;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                dArray[n3] = DoubleFFT_1D.this.bk1[n8] * dArray2[n8] - DoubleFFT_1D.this.bk1[n22] * dArray2[n22];
                                dArray[n42] = DoubleFFT_1D.this.bk1[n22] * dArray2[n8] + DoubleFFT_1D.this.bk1[n8] * dArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                dArray[n6] = DoubleFFT_1D.this.bk1[n9] * dArray2[n9] + DoubleFFT_1D.this.bk1[n52] * dArray2[n52];
                                dArray[n7] = -DoubleFFT_1D.this.bk1[n52] * dArray2[n9] + DoubleFFT_1D.this.bk1[n9] * dArray2[n52];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n11;
                    n8 = n + n10;
                    dArray2[n11] = dArray[n9] * this.bk1[n11] - dArray[n8] * this.bk1[n10];
                    dArray2[n10] = dArray[n9] * this.bk1[n10] + dArray[n8] * this.bk1[n11];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n11;
                    n8 = n + n10;
                    dArray2[n11] = dArray[n9] * this.bk1[n11] + dArray[n8] * this.bk1[n10];
                    dArray2[n10] = -dArray[n9] * this.bk1[n10] + dArray[n8] * this.bk1[n11];
                }
            }
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    double d = -dArray2[n11] * this.bk2[n10] + dArray2[n10] * this.bk2[n11];
                    dArray2[n11] = dArray2[n11] * this.bk2[n11] + dArray2[n10] * this.bk2[n10];
                    dArray2[n10] = d;
                }
            } else {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    double d = dArray2[n11] * this.bk2[n10] + dArray2[n10] * this.bk2[n11];
                    dArray2[n11] = dArray2[n11] * this.bk2[n11] - dArray2[n10] * this.bk2[n10];
                    dArray2[n10] = d;
                }
            }
            this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    int n13 = n + n11;
                    n8 = n + n10;
                    dArray[n13] = this.bk1[n11] * dArray2[n11] - this.bk1[n10] * dArray2[n10];
                    dArray[n8] = this.bk1[n10] * dArray2[n11] + this.bk1[n11] * dArray2[n10];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    int n14 = n + n11;
                    n8 = n + n10;
                    dArray[n14] = this.bk1[n11] * dArray2[n11] + this.bk1[n10] * dArray2[n10];
                    dArray[n8] = -this.bk1[n10] * dArray2[n11] + this.bk1[n11] * dArray2[n10];
                }
            }
        }
    }

    private void bluestein_real_full(final double[] dArray, final int n, final int n2) {
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6;
            n3 = 2;
            if (n3 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            int n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                int n3 = n + i;
                                dArray2[n6] = dArray[n3] * DoubleFFT_1D.this.bk1[n6];
                                dArray2[n22] = dArray[n3] * DoubleFFT_1D.this.bk1[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n42 = n7 + 1;
                                int n52 = n + i;
                                dArray2[n7] = dArray[n52] * DoubleFFT_1D.this.bk1[n7];
                                dArray2[n42] = -dArray[n52] * DoubleFFT_1D.this.bk1[n42];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n7 = this.nBluestein / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.nBluestein : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n22] + dArray2[n22] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n22] * DoubleFFT_1D.this.bk2[n22];
                                dArray2[n22] = d;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                double d = dArray2[n] * DoubleFFT_1D.this.bk2[n3] + dArray2[n3] * DoubleFFT_1D.this.bk2[n];
                                dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] - dArray2[n3] * DoubleFFT_1D.this.bk2[n3];
                                dArray2[n3] = d;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                dArray[n + n6] = DoubleFFT_1D.this.bk1[n6] * dArray2[n6] - DoubleFFT_1D.this.bk1[n22] * dArray2[n22];
                                dArray[n + n22] = DoubleFFT_1D.this.bk1[n22] * dArray2[n6] + DoubleFFT_1D.this.bk1[n6] * dArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n3 = n7 + 1;
                                dArray[n + n7] = DoubleFFT_1D.this.bk1[n7] * dArray2[n7] + DoubleFFT_1D.this.bk1[n3] * dArray2[n3];
                                dArray[n + n3] = -DoubleFFT_1D.this.bk1[n3] * dArray2[n7] + DoubleFFT_1D.this.bk1[n7] * dArray2[n3];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            if (n2 > 0) {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    n8 = n + n11;
                    dArray2[n10] = dArray[n8] * this.bk1[n10];
                    dArray2[n9] = dArray[n8] * this.bk1[n9];
                }
            } else {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    n8 = n + n11;
                    dArray2[n10] = dArray[n8] * this.bk1[n10];
                    dArray2[n9] = -dArray[n8] * this.bk1[n9];
                }
            }
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n11 = 0; n11 < this.nBluestein; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    double d = -dArray2[n10] * this.bk2[n9] + dArray2[n9] * this.bk2[n10];
                    dArray2[n10] = dArray2[n10] * this.bk2[n10] + dArray2[n9] * this.bk2[n9];
                    dArray2[n9] = d;
                }
            } else {
                for (n11 = 0; n11 < this.nBluestein; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    double d = dArray2[n10] * this.bk2[n9] + dArray2[n9] * this.bk2[n10];
                    dArray2[n10] = dArray2[n10] * this.bk2[n10] - dArray2[n9] * this.bk2[n9];
                    dArray2[n9] = d;
                }
            }
            this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    dArray[n + n10] = this.bk1[n10] * dArray2[n10] - this.bk1[n9] * dArray2[n9];
                    dArray[n + n9] = this.bk1[n9] * dArray2[n10] + this.bk1[n10] * dArray2[n9];
                }
            } else {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    dArray[n + n10] = this.bk1[n10] * dArray2[n10] + this.bk1[n9] * dArray2[n9];
                    dArray[n + n9] = -this.bk1[n9] * dArray2[n10] + this.bk1[n10] * dArray2[n9];
                }
            }
        }
    }

    private void bluestein_real_forward(final double[] dArray, final int n) {
        int n2;
        int n3;
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            n4 = 2;
            if (n4 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n4 = 4;
            }
            Future[] futureArray = new Future[n4];
            n3 = this.n / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.n : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            dArray2[n4] = dArray[n3] * DoubleFFT_1D.this.bk1[n4];
                            dArray2[n2] = -dArray[n3] * DoubleFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n3 = this.nBluestein / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.nBluestein : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            double d = dArray2[n] * DoubleFFT_1D.this.bk2[n2] + dArray2[n2] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] - dArray2[n2] * DoubleFFT_1D.this.bk2[n2];
                            dArray2[n2] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n7;
            for (n7 = 0; n7 < this.n; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                int n8 = n + n7;
                dArray2[n3] = dArray[n8] * this.bk1[n3];
                dArray2[n2] = -dArray[n8] * this.bk1[n2];
            }
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n7 = 0; n7 < this.nBluestein; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                double d = dArray2[n3] * this.bk2[n2] + dArray2[n2] * this.bk2[n3];
                dArray2[n3] = dArray2[n3] * this.bk2[n3] - dArray2[n2] * this.bk2[n2];
                dArray2[n2] = d;
            }
        }
        this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            dArray[n] = this.bk1[0] * dArray2[0] + this.bk1[1] * dArray2[1];
            dArray[n + 1] = this.bk1[this.n] * dArray2[this.n] + this.bk1[this.n + 1] * dArray2[this.n + 1];
            for (int i = 1; i < this.n / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                dArray[n + n3] = this.bk1[n3] * dArray2[n3] + this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = -this.bk1[n2] * dArray2[n3] + this.bk1[n3] * dArray2[n2];
            }
        } else {
            dArray[n] = this.bk1[0] * dArray2[0] + this.bk1[1] * dArray2[1];
            dArray[n + 1] = -this.bk1[this.n] * dArray2[this.n - 1] + this.bk1[this.n - 1] * dArray2[this.n];
            for (int i = 1; i < (this.n - 1) / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                dArray[n + n3] = this.bk1[n3] * dArray2[n3] + this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = -this.bk1[n2] * dArray2[n3] + this.bk1[n3] * dArray2[n2];
            }
            dArray[n + this.n - 1] = this.bk1[this.n - 1] * dArray2[this.n - 1] + this.bk1[this.n] * dArray2[this.n];
        }
    }

    private void bluestein_real_inverse(final double[] dArray, final int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        final double[] dArray2 = new double[2 * this.nBluestein];
        if (this.n % 2 == 0) {
            dArray2[0] = dArray[n] * this.bk1[0];
            dArray2[1] = dArray[n] * this.bk1[1];
            for (n6 = 1; n6 < this.n / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                dArray2[n5] = dArray[n3] * this.bk1[n5] - dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] + dArray[n2] * this.bk1[n5];
            }
            dArray2[this.n] = dArray[n + 1] * this.bk1[this.n];
            dArray2[this.n + 1] = dArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = this.n / 2 + 1; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                dArray2[n5] = dArray[n3] * this.bk1[n5] + dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] - dArray[n2] * this.bk1[n5];
            }
        } else {
            dArray2[0] = dArray[n] * this.bk1[0];
            dArray2[1] = dArray[n] * this.bk1[1];
            for (n6 = 1; n6 < (this.n - 1) / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                dArray2[n5] = dArray[n3] * this.bk1[n5] - dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] + dArray[n2] * this.bk1[n5];
            }
            dArray2[this.n - 1] = dArray[n + this.n - 1] * this.bk1[this.n - 1] - dArray[n + 1] * this.bk1[this.n];
            dArray2[this.n] = dArray[n + this.n - 1] * this.bk1[this.n] + dArray[n + 1] * this.bk1[this.n - 1];
            dArray2[this.n + 1] = dArray[n + this.n - 1] * this.bk1[this.n + 1] + dArray[n + 1] * this.bk1[this.n + 2];
            dArray2[this.n + 2] = dArray[n + this.n - 1] * this.bk1[this.n + 2] - dArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = (this.n - 1) / 2 + 2; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                dArray2[n5] = dArray[n3] * this.bk1[n5] + dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] - dArray[n2] * this.bk1[n5];
            }
        }
        this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n7;
            n6 = 2;
            if (n6 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n6 = 4;
            }
            Future[] futureArray = new Future[n6];
            n4 = this.nBluestein / n6;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = n3 * n4;
                n7 = n3 == n6 - 1 ? this.nBluestein : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n2; i < n7; ++i) {
                            int n = 2 * i;
                            int n22 = n + 1;
                            double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n22] + dArray2[n22] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n22] * DoubleFFT_1D.this.bk2[n22];
                            dArray2[n22] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n4 = this.n / n6;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = n3 * n4;
                n7 = n3 == n6 - 1 ? this.n : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n2; i < n7; ++i) {
                            int n3 = 2 * i;
                            int n22 = n3 + 1;
                            dArray[n + i] = DoubleFFT_1D.this.bk1[n3] * dArray2[n3] - DoubleFFT_1D.this.bk1[n22] * dArray2[n22];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            for (n5 = 0; n5 < this.nBluestein; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                double d = -dArray2[n4] * this.bk2[n3] + dArray2[n3] * this.bk2[n4];
                dArray2[n4] = dArray2[n4] * this.bk2[n4] + dArray2[n3] * this.bk2[n3];
                dArray2[n3] = d;
            }
            this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n5 = 0; n5 < this.n; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                dArray[n + n5] = this.bk1[n4] * dArray2[n4] - this.bk1[n3] * dArray2[n3];
            }
        }
    }

    private void bluestein_real_inverse2(final double[] dArray, final int n) {
        int n2;
        int n3;
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            n4 = 2;
            if (n4 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n4 = 4;
            }
            Future[] futureArray = new Future[n4];
            n3 = this.n / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.n : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            dArray2[n4] = dArray[n3] * DoubleFFT_1D.this.bk1[n4];
                            dArray2[n2] = dArray[n3] * DoubleFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n3 = this.nBluestein / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.nBluestein : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n2] + dArray2[n2] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n2] * DoubleFFT_1D.this.bk2[n2];
                            dArray2[n2] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n7;
            for (n7 = 0; n7 < this.n; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                int n8 = n + n7;
                dArray2[n3] = dArray[n8] * this.bk1[n3];
                dArray2[n2] = dArray[n8] * this.bk1[n2];
            }
            this.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n7 = 0; n7 < this.nBluestein; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                double d = -dArray2[n3] * this.bk2[n2] + dArray2[n2] * this.bk2[n3];
                dArray2[n3] = dArray2[n3] * this.bk2[n3] + dArray2[n2] * this.bk2[n2];
                dArray2[n2] = d;
            }
        }
        this.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            dArray[n] = this.bk1[0] * dArray2[0] - this.bk1[1] * dArray2[1];
            dArray[n + 1] = this.bk1[this.n] * dArray2[this.n] - this.bk1[this.n + 1] * dArray2[this.n + 1];
            for (int i = 1; i < this.n / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                dArray[n + n3] = this.bk1[n3] * dArray2[n3] - this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = this.bk1[n2] * dArray2[n3] + this.bk1[n3] * dArray2[n2];
            }
        } else {
            dArray[n] = this.bk1[0] * dArray2[0] - this.bk1[1] * dArray2[1];
            dArray[n + 1] = this.bk1[this.n] * dArray2[this.n - 1] + this.bk1[this.n - 1] * dArray2[this.n];
            for (int i = 1; i < (this.n - 1) / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                dArray[n + n3] = this.bk1[n3] * dArray2[n3] - this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = this.bk1[n2] * dArray2[n3] + this.bk1[n3] * dArray2[n2];
            }
            dArray[n + this.n - 1] = this.bk1[this.n - 1] * dArray2[this.n - 1] - this.bk1[this.n] * dArray2[this.n];
        }
    }

    void rfftf(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        double[] dArray2 = new double[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 1;
        int n5 = this.n;
        int n6 = n2 - 1;
        for (int i = 1; i <= n3; ++i) {
            int n7 = n3 - i;
            int n8 = (int)this.wtable_r[n7 + 2 + n2];
            int n9 = n5 / n8;
            int n10 = this.n / n5;
            int n11 = n10 * n9;
            n6 -= (n8 - 1) * n10;
            n4 = 1 - n4;
            switch (n8) {
                case 2: {
                    if (n4 == 0) {
                        this.radf2(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf2(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radf3(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf3(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radf4(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf4(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radf5(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf5(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                default: {
                    if (n10 == 1) {
                        n4 = 1 - n4;
                    }
                    if (n4 == 0) {
                        this.radfg(n10, n8, n9, n11, dArray, n, dArray2, 0, n6);
                        n4 = 1;
                        break;
                    }
                    this.radfg(n10, n8, n9, n11, dArray2, 0, dArray, n, n6);
                    n4 = 0;
                }
            }
            n5 = n9;
        }
        if (n4 == 1) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, this.n);
    }

    void rfftb(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        double[] dArray2 = new double[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 0;
        int n5 = 1;
        int n6 = this.n;
        for (int i = 1; i <= n3; ++i) {
            int n7 = (int)this.wtable_r[i + 1 + n2];
            int n8 = n7 * n5;
            int n9 = this.n / n8;
            int n10 = n9 * n5;
            switch (n7) {
                case 2: {
                    if (n4 == 0) {
                        this.radb2(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb2(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radb3(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb3(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radb4(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb4(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radb5(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb5(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                default: {
                    if (n4 == 0) {
                        this.radbg(n9, n7, n5, n10, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radbg(n9, n7, n5, n10, dArray2, 0, dArray, n, n6);
                    }
                    if (n9 != 1) break;
                    n4 = 1 - n4;
                }
            }
            n5 = n8;
            n6 += (n7 - 1) * n9;
        }
        if (n4 == 0) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, this.n);
    }

    void radf2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n5;
        int n13 = n2 * n;
        int n14 = 2 * n;
        for (n11 = 0; n11 < n2; ++n11) {
            n10 = n4 + n11 * n14;
            n9 = n10 + n14 - 1;
            n8 = n3 + n11 * n;
            n7 = n8 + n13;
            double d = dArray[n8];
            double d2 = dArray[n7];
            dArray2[n10] = d + d2;
            dArray2[n9] = d - d2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n11 = 0; n11 < n2; ++n11) {
                n14 = n11 * n;
                n6 = 2 * n14;
                int n15 = n6 + n;
                int n16 = n14 + n13;
                for (int i = 2; i < n; i += 2) {
                    int n17 = n - i;
                    n10 = i - 1 + n12;
                    n9 = n4 + i + n6;
                    n8 = n4 + n17 + n15;
                    n7 = n3 + i + n14;
                    int n18 = n3 + i + n16;
                    double d = dArray[n7 - 1];
                    double d3 = dArray[n7];
                    double d4 = dArray[n18 - 1];
                    double d5 = dArray[n18];
                    double d6 = this.wtable_r[n10 - 1];
                    double d7 = this.wtable_r[n10];
                    double d8 = d6 * d4 + d7 * d5;
                    double d9 = d6 * d5 - d7 * d4;
                    dArray2[n9] = d3 + d9;
                    dArray2[n9 - 1] = d + d8;
                    dArray2[n8] = d9 - d3;
                    dArray2[n8 - 1] = d - d8;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        n6 = 2 * n14;
        for (n11 = 0; n11 < n2; ++n11) {
            n14 = n11 * n;
            n10 = n4 + n6 + n;
            n9 = n3 + n - 1 + n14;
            dArray2[n10] = -dArray[n9 + n13];
            dArray2[n10 - 1] = dArray[n9];
        }
    }

    void radb2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n10 + n;
            n8 = n4 + n11;
            n7 = n3 + n10;
            n6 = n3 + n - 1 + n9;
            double d = dArray[n7];
            double d2 = dArray[n6];
            dArray2[n8] = d + d2;
            dArray2[n8 + n14] = d - d2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n12 * n;
                n10 = 2 * n11;
                n9 = n10 + n;
                n8 = n11 + n14;
                for (int i = 2; i < n; i += 2) {
                    int n15 = n - i;
                    n7 = i - 1 + n13;
                    n6 = n4 + i;
                    int n16 = n3 + i;
                    int n17 = n3 + n15;
                    double d = this.wtable_r[n7 - 1];
                    double d3 = this.wtable_r[n7];
                    int n18 = n16 + n10;
                    int n19 = n17 + n9;
                    int n20 = n6 + n11;
                    int n21 = n6 + n8;
                    double d4 = dArray[n18 - 1] - dArray[n19 - 1];
                    double d5 = dArray[n18] + dArray[n19];
                    double d6 = dArray[n18];
                    double d7 = dArray[n18 - 1];
                    double d8 = dArray[n19];
                    double d9 = dArray[n19 - 1];
                    dArray2[n20 - 1] = d7 + d9;
                    dArray2[n20] = d6 - d8;
                    dArray2[n21 - 1] = d * d4 - d3 * d5;
                    dArray2[n21] = d * d5 + d3 * d4;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n4 + n - 1 + n11;
            n8 = n3 + n10 + n;
            dArray2[n9] = 2.0 * dArray[n8 - 1];
            dArray2[n9 + n14] = -2.0 * dArray[n8];
        }
    }

    void radf3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n13 + n;
        int n15 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n15;
            n9 = (3 * n12 + 1) * n;
            n8 = n3 + n11;
            n7 = n8 + n15;
            n6 = n8 + n10;
            double d2 = dArray[n8];
            double d3 = dArray[n7];
            double d4 = dArray[n6];
            d = d3 + d4;
            dArray2[n4 + 3 * n11] = d2 + d;
            dArray2[n4 + n9 + n] = 0.8660254037844387 * (d4 - d3);
            dArray2[n4 + n - 1 + n9] = d2 + -0.5 * d;
        }
        if (n == 1) {
            return;
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 3 * n11;
            n9 = n11 + n15;
            n8 = n9 + n15;
            n7 = n10 + n;
            n6 = n7 + n;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = i - 1 + n13;
                int n18 = i - 1 + n14;
                double d5 = this.wtable_r[n17 - 1];
                double d6 = this.wtable_r[n17];
                double d7 = this.wtable_r[n18 - 1];
                double d8 = this.wtable_r[n18];
                int n19 = n3 + i;
                int n20 = n4 + i;
                int n21 = n4 + n16;
                int n22 = n19 + n11;
                int n23 = n19 + n9;
                int n24 = n19 + n8;
                double d9 = dArray[n22 - 1];
                double d10 = dArray[n22];
                double d11 = dArray[n23 - 1];
                double d12 = dArray[n23];
                double d13 = dArray[n24 - 1];
                double d14 = dArray[n24];
                double d15 = d5 * d11 + d6 * d12;
                double d16 = d5 * d12 - d6 * d11;
                double d17 = d7 * d13 + d8 * d14;
                double d18 = d7 * d14 - d8 * d13;
                d = d15 + d17;
                double d19 = d16 + d18;
                double d20 = d9 + -0.5 * d;
                double d21 = d10 + -0.5 * d19;
                double d22 = 0.8660254037844387 * (d16 - d18);
                double d23 = 0.8660254037844387 * (d17 - d15);
                int n25 = n20 + n10;
                int n26 = n21 + n7;
                int n27 = n20 + n6;
                dArray2[n25 - 1] = d9 + d;
                dArray2[n25] = d10 + d19;
                dArray2[n26 - 1] = d20 - d22;
                dArray2[n26] = d23 - d21;
                dArray2[n27 - 1] = d20 + d22;
                dArray2[n27] = d21 + d23;
            }
        }
    }

    void radb3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n5;
        int n11 = n10 + n;
        for (n9 = 0; n9 < n2; ++n9) {
            n8 = n9 * n;
            n7 = n3 + 3 * n8;
            n6 = n7 + 2 * n;
            double d4 = dArray[n7];
            d3 = 2.0 * dArray[n6 - 1];
            d2 = d4 + -0.5 * d3;
            d = 1.7320508075688774 * dArray[n6];
            dArray2[n4 + n8] = d4 + d3;
            dArray2[n4 + (n9 + n2) * n] = d2 - d;
            dArray2[n4 + (n9 + 2 * n2) * n] = d2 + d;
        }
        if (n == 1) {
            return;
        }
        n9 = n2 * n;
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n8 * n;
            n6 = 3 * n7;
            int n12 = n6 + n;
            int n13 = n12 + n;
            int n14 = n7 + n9;
            int n15 = n14 + n9;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = n3 + i;
                int n18 = n3 + n16;
                int n19 = n4 + i;
                int n20 = n17 + n6;
                int n21 = n17 + n13;
                int n22 = n18 + n12;
                double d5 = dArray[n20 - 1];
                double d6 = dArray[n20];
                double d7 = dArray[n21 - 1];
                double d8 = dArray[n21];
                double d9 = dArray[n22 - 1];
                double d10 = dArray[n22];
                d3 = d7 + d9;
                d2 = d5 + -0.5 * d3;
                double d11 = d8 - d10;
                double d12 = d6 + -0.5 * d11;
                double d13 = 0.8660254037844387 * (d7 - d9);
                d = 0.8660254037844387 * (d8 + d10);
                double d14 = d2 - d;
                double d15 = d2 + d;
                double d16 = d12 + d13;
                double d17 = d12 - d13;
                int n23 = i - 1 + n10;
                int n24 = i - 1 + n11;
                double d18 = this.wtable_r[n23 - 1];
                double d19 = this.wtable_r[n23];
                double d20 = this.wtable_r[n24 - 1];
                double d21 = this.wtable_r[n24];
                int n25 = n19 + n7;
                int n26 = n19 + n14;
                int n27 = n19 + n15;
                dArray2[n25 - 1] = d5 + d3;
                dArray2[n25] = d6 + d11;
                dArray2[n26 - 1] = d18 * d14 - d19 * d16;
                dArray2[n26] = d18 * d16 + d19 * d14;
                dArray2[n27 - 1] = d20 * d15 - d21 * d17;
                dArray2[n27] = d20 * d17 + d21 * d15;
            }
        }
    }

    void radf4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        int n6;
        int n7;
        int n8;
        int n9;
        double d2;
        double d3;
        double d4;
        double d5;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = n5;
        int n18 = n5 + n;
        int n19 = n18 + n;
        int n20 = n2 * n;
        for (n16 = 0; n16 < n2; ++n16) {
            n15 = n16 * n;
            n14 = 4 * n15;
            n13 = n15 + n20;
            n12 = n13 + n20;
            n11 = n12 + n20;
            n10 = n14 + n;
            double d6 = dArray[n3 + n15];
            double d7 = dArray[n3 + n13];
            d5 = dArray[n3 + n12];
            d4 = dArray[n3 + n11];
            d3 = d7 + d4;
            d2 = d6 + d5;
            n9 = n4 + n14;
            n8 = n4 + n10 + n;
            dArray2[n9] = d3 + d2;
            dArray2[n8 - 1 + n + n] = d2 - d3;
            dArray2[n8 - 1] = d6 - d5;
            dArray2[n8] = d4 - d7;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n16 = 0; n16 < n2; ++n16) {
                n15 = n16 * n;
                n14 = n15 + n20;
                n13 = n14 + n20;
                n12 = n13 + n20;
                n11 = 4 * n15;
                n10 = n11 + n;
                int n21 = n10 + n;
                n7 = n21 + n;
                for (int i = 2; i < n; i += 2) {
                    int n22 = n - i;
                    int n23 = i - 1 + n17;
                    n6 = i - 1 + n18;
                    int n24 = i - 1 + n19;
                    double d8 = this.wtable_r[n23 - 1];
                    double d9 = this.wtable_r[n23];
                    double d10 = this.wtable_r[n6 - 1];
                    double d11 = this.wtable_r[n6];
                    double d12 = this.wtable_r[n24 - 1];
                    double d13 = this.wtable_r[n24];
                    int n25 = n3 + i;
                    int n26 = n4 + i;
                    int n27 = n4 + n22;
                    n9 = n25 + n15;
                    n8 = n25 + n14;
                    int n28 = n25 + n13;
                    int n29 = n25 + n12;
                    double d14 = dArray[n9 - 1];
                    double d15 = dArray[n9];
                    double d16 = dArray[n8 - 1];
                    double d17 = dArray[n8];
                    double d18 = dArray[n28 - 1];
                    double d19 = dArray[n28];
                    double d20 = dArray[n29 - 1];
                    double d21 = dArray[n29];
                    double d22 = d8 * d16 + d9 * d17;
                    double d23 = d8 * d17 - d9 * d16;
                    double d24 = d10 * d18 + d11 * d19;
                    double d25 = d10 * d19 - d11 * d18;
                    double d26 = d12 * d20 + d13 * d21;
                    double d27 = d12 * d21 - d13 * d20;
                    d3 = d22 + d26;
                    double d28 = d26 - d22;
                    d = d23 + d27;
                    double d29 = d23 - d27;
                    double d30 = d15 + d25;
                    double d31 = d15 - d25;
                    d2 = d14 + d24;
                    double d32 = d14 - d24;
                    int n30 = n26 + n11;
                    int n31 = n27 + n10;
                    int n32 = n26 + n21;
                    int n33 = n27 + n7;
                    dArray2[n30 - 1] = d3 + d2;
                    dArray2[n33 - 1] = d2 - d3;
                    dArray2[n30] = d + d30;
                    dArray2[n33] = d - d30;
                    dArray2[n32 - 1] = d29 + d32;
                    dArray2[n31 - 1] = d32 - d29;
                    dArray2[n32] = d28 + d31;
                    dArray2[n31] = d28 - d31;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n16 = 0; n16 < n2; ++n16) {
            n15 = n16 * n;
            n14 = 4 * n15;
            n13 = n15 + n20;
            n12 = n13 + n20;
            n11 = n12 + n20;
            n10 = n14 + n;
            int n34 = n10 + n;
            n7 = n34 + n;
            int n35 = n3 + n;
            n6 = n4 + n;
            d5 = dArray[n35 - 1 + n15];
            d4 = dArray[n35 - 1 + n13];
            double d33 = dArray[n35 - 1 + n12];
            double d34 = dArray[n35 - 1 + n11];
            d = -0.7071067811865476 * (d4 + d34);
            d3 = 0.7071067811865476 * (d4 - d34);
            dArray2[n6 - 1 + n14] = d3 + d5;
            dArray2[n6 - 1 + n34] = d5 - d3;
            dArray2[n4 + n10] = d - d33;
            dArray2[n4 + n7] = d + d33;
        }
    }

    void radb4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        int n6;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16 = n5;
        int n17 = n16 + n;
        int n18 = n17 + n;
        int n19 = n2 * n;
        for (n15 = 0; n15 < n2; ++n15) {
            n14 = n15 * n;
            n13 = 4 * n14;
            n12 = n14 + n19;
            n11 = n12 + n19;
            n10 = n11 + n19;
            n9 = n13 + n;
            n8 = n9 + n;
            n7 = n8 + n;
            double d10 = dArray[n3 + n13];
            d9 = dArray[n3 + n8];
            d8 = dArray[n3 + n - 1 + n7];
            d7 = dArray[n3 + n - 1 + n9];
            d6 = d10 - d8;
            d5 = d10 + d8;
            d4 = d7 + d7;
            d3 = d9 + d9;
            dArray2[n4 + n14] = d5 + d4;
            dArray2[n4 + n12] = d6 - d3;
            dArray2[n4 + n11] = d5 - d4;
            dArray2[n4 + n10] = d6 + d3;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n15 = 0; n15 < n2; ++n15) {
                n14 = n15 * n;
                n13 = n14 + n19;
                n12 = n13 + n19;
                n11 = n12 + n19;
                n10 = 4 * n14;
                n9 = n10 + n;
                n8 = n9 + n;
                n7 = n8 + n;
                for (int i = 2; i < n; i += 2) {
                    int n20 = n - i;
                    int n21 = i - 1 + n16;
                    n6 = i - 1 + n17;
                    int n22 = i - 1 + n18;
                    double d11 = this.wtable_r[n21 - 1];
                    double d12 = this.wtable_r[n21];
                    double d13 = this.wtable_r[n6 - 1];
                    double d14 = this.wtable_r[n6];
                    double d15 = this.wtable_r[n22 - 1];
                    double d16 = this.wtable_r[n22];
                    int n23 = n3 + i;
                    int n24 = n3 + n20;
                    int n25 = n4 + i;
                    int n26 = n23 + n10;
                    int n27 = n24 + n9;
                    int n28 = n23 + n8;
                    int n29 = n24 + n7;
                    double d17 = dArray[n26 - 1];
                    double d18 = dArray[n26];
                    double d19 = dArray[n27 - 1];
                    double d20 = dArray[n27];
                    double d21 = dArray[n28 - 1];
                    double d22 = dArray[n28];
                    double d23 = dArray[n29 - 1];
                    double d24 = dArray[n29];
                    d2 = d18 + d24;
                    d = d18 - d24;
                    double d25 = d22 - d20;
                    d3 = d22 + d20;
                    d6 = d17 - d23;
                    d5 = d17 + d23;
                    double d26 = d21 - d19;
                    d4 = d21 + d19;
                    double d27 = d5 - d4;
                    double d28 = d - d25;
                    double d29 = d6 - d3;
                    double d30 = d6 + d3;
                    double d31 = d2 + d26;
                    double d32 = d2 - d26;
                    int n30 = n25 + n14;
                    int n31 = n25 + n13;
                    int n32 = n25 + n12;
                    int n33 = n25 + n11;
                    dArray2[n30 - 1] = d5 + d4;
                    dArray2[n30] = d + d25;
                    dArray2[n31 - 1] = d11 * d29 - d12 * d31;
                    dArray2[n31] = d11 * d31 + d12 * d29;
                    dArray2[n32 - 1] = d13 * d27 - d14 * d28;
                    dArray2[n32] = d13 * d28 + d14 * d27;
                    dArray2[n33 - 1] = d15 * d30 - d16 * d32;
                    dArray2[n33] = d15 * d32 + d16 * d30;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n15 = 0; n15 < n2; ++n15) {
            n14 = n15 * n;
            n13 = 4 * n14;
            n12 = n14 + n19;
            n11 = n12 + n19;
            n10 = n11 + n19;
            n9 = n13 + n;
            n8 = n9 + n;
            n7 = n8 + n;
            int n34 = n3 + n;
            n6 = n4 + n;
            d9 = dArray[n34 - 1 + n13];
            d8 = dArray[n34 - 1 + n8];
            d7 = dArray[n3 + n9];
            double d33 = dArray[n3 + n7];
            d2 = d7 + d33;
            d = d33 - d7;
            d6 = d9 - d8;
            d5 = d9 + d8;
            dArray2[n6 - 1 + n14] = d5 + d5;
            dArray2[n6 - 1 + n12] = 1.4142135623730951 * (d6 - d2);
            dArray2[n6 - 1 + n11] = d + d;
            dArray2[n6 - 1 + n10] = -1.4142135623730951 * (d6 + d2);
        }
    }

    void radf5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n4 + n - 1;
            double d5 = dArray[n3 + n16];
            double d6 = dArray[n3 + n10];
            double d7 = dArray[n3 + n9];
            double d8 = dArray[n3 + n8];
            double d9 = dArray[n3 + n7];
            d4 = d9 + d6;
            d3 = d9 - d6;
            d2 = d8 + d7;
            d = d8 - d7;
            dArray2[n4 + n15] = d5 + d4 + d2;
            dArray2[n6 + n14] = d5 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
            dArray2[n4 + n13] = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
            dArray2[n6 + n12] = d5 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
            dArray2[n4 + n11] = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                n6 = i - 1 + n18;
                int n23 = i - 1 + n19;
                int n24 = i - 1 + n20;
                int n25 = i - 1 + n21;
                double d10 = this.wtable_r[n6 - 1];
                double d11 = this.wtable_r[n6];
                double d12 = this.wtable_r[n23 - 1];
                double d13 = this.wtable_r[n23];
                double d14 = this.wtable_r[n24 - 1];
                double d15 = this.wtable_r[n24];
                double d16 = this.wtable_r[n25 - 1];
                double d17 = this.wtable_r[n25];
                int n26 = n - i;
                int n27 = n3 + i;
                int n28 = n4 + i;
                int n29 = n4 + n26;
                int n30 = n27 + n16;
                int n31 = n27 + n10;
                int n32 = n27 + n9;
                int n33 = n27 + n8;
                int n34 = n27 + n7;
                double d18 = dArray[n30 - 1];
                double d19 = dArray[n30];
                double d20 = dArray[n31 - 1];
                double d21 = dArray[n31];
                double d22 = dArray[n32 - 1];
                double d23 = dArray[n32];
                double d24 = dArray[n33 - 1];
                double d25 = dArray[n33];
                double d26 = dArray[n34 - 1];
                double d27 = dArray[n34];
                double d28 = d10 * d20 + d11 * d21;
                double d29 = d10 * d21 - d11 * d20;
                double d30 = d12 * d22 + d13 * d23;
                double d31 = d12 * d23 - d13 * d22;
                double d32 = d14 * d24 + d15 * d25;
                double d33 = d14 * d25 - d15 * d24;
                double d34 = d16 * d26 + d17 * d27;
                double d35 = d16 * d27 - d17 * d26;
                d4 = d28 + d34;
                d3 = d34 - d28;
                double d36 = d29 - d35;
                double d37 = d29 + d35;
                d2 = d30 + d32;
                d = d32 - d30;
                double d38 = d31 - d33;
                double d39 = d31 + d33;
                double d40 = d18 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
                double d41 = d19 + 0.30901699437494745 * d37 + -0.8090169943749473 * d39;
                double d42 = d18 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
                double d43 = d19 + -0.8090169943749473 * d37 + 0.30901699437494745 * d39;
                double d44 = 0.9510565162951535 * d36 + 0.5877852522924732 * d38;
                double d45 = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
                double d46 = 0.5877852522924732 * d36 - 0.9510565162951535 * d38;
                double d47 = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
                int n35 = n28 + n15;
                int n36 = n29 + n14;
                int n37 = n28 + n13;
                int n38 = n29 + n12;
                int n39 = n28 + n11;
                dArray2[n35 - 1] = d18 + d4 + d2;
                dArray2[n35] = d19 + d37 + d39;
                dArray2[n37 - 1] = d40 + d44;
                dArray2[n36 - 1] = d40 - d44;
                dArray2[n37] = d41 + d45;
                dArray2[n36] = d45 - d41;
                dArray2[n39 - 1] = d42 + d46;
                dArray2[n38 - 1] = d42 - d46;
                dArray2[n39] = d43 + d47;
                dArray2[n38] = d47 - d43;
            }
        }
    }

    void radb5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n3 + n - 1;
            double d9 = dArray[n3 + n15];
            d8 = 2.0 * dArray[n3 + n13];
            d7 = 2.0 * dArray[n3 + n11];
            d6 = 2.0 * dArray[n6 + n14];
            d5 = 2.0 * dArray[n6 + n12];
            d4 = d9 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
            d3 = d9 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
            d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
            d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
            dArray2[n4 + n16] = d9 + d6 + d5;
            dArray2[n4 + n10] = d4 - d2;
            dArray2[n4 + n9] = d3 - d;
            dArray2[n4 + n8] = d3 + d;
            dArray2[n4 + n7] = d4 + d2;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                int n23 = n - i;
                n6 = i - 1 + n18;
                int n24 = i - 1 + n19;
                int n25 = i - 1 + n20;
                int n26 = i - 1 + n21;
                double d10 = this.wtable_r[n6 - 1];
                double d11 = this.wtable_r[n6];
                double d12 = this.wtable_r[n24 - 1];
                double d13 = this.wtable_r[n24];
                double d14 = this.wtable_r[n25 - 1];
                double d15 = this.wtable_r[n25];
                double d16 = this.wtable_r[n26 - 1];
                double d17 = this.wtable_r[n26];
                int n27 = n3 + i;
                int n28 = n3 + n23;
                int n29 = n4 + i;
                int n30 = n27 + n15;
                int n31 = n28 + n14;
                int n32 = n27 + n13;
                int n33 = n28 + n12;
                int n34 = n27 + n11;
                double d18 = dArray[n30 - 1];
                double d19 = dArray[n30];
                double d20 = dArray[n31 - 1];
                double d21 = dArray[n31];
                double d22 = dArray[n32 - 1];
                double d23 = dArray[n32];
                double d24 = dArray[n33 - 1];
                double d25 = dArray[n33];
                double d26 = dArray[n34 - 1];
                double d27 = dArray[n34];
                d8 = d23 + d21;
                double d28 = d23 - d21;
                d7 = d27 + d25;
                double d29 = d27 - d25;
                double d30 = d22 - d20;
                d6 = d22 + d20;
                double d31 = d26 - d24;
                d5 = d26 + d24;
                d4 = d18 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
                double d32 = d19 + 0.30901699437494745 * d28 + -0.8090169943749473 * d29;
                d3 = d18 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
                double d33 = d19 + -0.8090169943749473 * d28 + 0.30901699437494745 * d29;
                double d34 = 0.9510565162951535 * d30 + 0.5877852522924732 * d31;
                d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
                double d35 = 0.5877852522924732 * d30 - 0.9510565162951535 * d31;
                d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
                double d36 = d3 - d;
                double d37 = d3 + d;
                double d38 = d33 + d35;
                double d39 = d33 - d35;
                double d40 = d4 + d2;
                double d41 = d4 - d2;
                double d42 = d32 - d34;
                double d43 = d32 + d34;
                int n35 = n29 + n16;
                int n36 = n29 + n10;
                int n37 = n29 + n9;
                int n38 = n29 + n8;
                int n39 = n29 + n7;
                dArray2[n35 - 1] = d18 + d6 + d5;
                dArray2[n35] = d19 + d28 + d29;
                dArray2[n36 - 1] = d10 * d41 - d11 * d43;
                dArray2[n36] = d10 * d43 + d11 * d41;
                dArray2[n37 - 1] = d12 * d36 - d13 * d38;
                dArray2[n37] = d12 * d38 + d13 * d36;
                dArray2[n38 - 1] = d14 * d37 - d15 * d39;
                dArray2[n38] = d14 * d39 + d15 * d37;
                dArray2[n39 - 1] = d16 * d40 - d17 * d42;
                dArray2[n39] = d16 * d42 + d17 * d40;
            }
        }
    }

    void radfg(int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7) {
        int n8;
        double d;
        double d2;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = n7;
        double d3 = Math.PI * 2 / (double)n2;
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        int n21 = (n2 + 1) / 2;
        int n22 = (n - 1) / 2;
        if (n != 1) {
            double d6;
            double d7;
            double d8;
            int n23;
            double d9;
            double d10;
            int n24;
            int n25;
            for (n19 = 0; n19 < n4; ++n19) {
                dArray2[n6 + n19] = dArray[n5 + n19];
            }
            for (n19 = 1; n19 < n2; ++n19) {
                n18 = n19 * n3 * n;
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n + n18;
                    dArray2[n6 + n16] = dArray[n5 + n16];
                }
            }
            if (n22 <= n3) {
                n25 = -n;
                for (n19 = 1; n19 < n2; ++n19) {
                    n24 = (n25 += n) - 1;
                    n18 = n19 * n3 * n;
                    for (n17 = 2; n17 < n; n17 += 2) {
                        n16 = (n24 += 2) + n20;
                        n15 = n5 + n17;
                        n14 = n6 + n17;
                        d10 = this.wtable_r[n16 - 1];
                        d9 = this.wtable_r[n16];
                        for (n13 = 0; n13 < n3; ++n13) {
                            n12 = n13 * n + n18;
                            n23 = n14 + n12;
                            n11 = n15 + n12;
                            d8 = dArray[n11 - 1];
                            double d11 = dArray[n11];
                            dArray2[n23 - 1] = d10 * d8 + d9 * d11;
                            dArray2[n23] = d10 * d11 - d9 * d8;
                        }
                    }
                }
            } else {
                n25 = -n;
                for (n19 = 1; n19 < n2; ++n19) {
                    n25 += n;
                    n18 = n19 * n3 * n;
                    for (n17 = 0; n17 < n3; ++n17) {
                        n24 = n25 - 1;
                        n16 = n17 * n + n18;
                        for (n15 = 2; n15 < n; n15 += 2) {
                            n14 = (n24 += 2) + n20;
                            d10 = this.wtable_r[n14 - 1];
                            d9 = this.wtable_r[n14];
                            n13 = n6 + n15 + n16;
                            n12 = n5 + n15 + n16;
                            double d12 = dArray[n12 - 1];
                            d8 = dArray[n12];
                            dArray2[n13 - 1] = d10 * d12 + d9 * d8;
                            dArray2[n13] = d10 * d8 - d9 * d12;
                        }
                    }
                }
            }
            if (n22 >= n3) {
                for (n19 = 1; n19 < n21; ++n19) {
                    n10 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n10 * n3 * n;
                    for (n16 = 0; n16 < n3; ++n16) {
                        n15 = n16 * n + n18;
                        n14 = n16 * n + n17;
                        for (n13 = 2; n13 < n; n13 += 2) {
                            n12 = n5 + n13;
                            n23 = n6 + n13;
                            n11 = n12 + n15;
                            int n26 = n12 + n14;
                            n9 = n23 + n15;
                            int n27 = n23 + n14;
                            d7 = dArray2[n9 - 1];
                            d6 = dArray2[n9];
                            d2 = dArray2[n27 - 1];
                            d = dArray2[n27];
                            dArray[n11 - 1] = d7 + d2;
                            dArray[n11] = d6 + d;
                            dArray[n26 - 1] = d6 - d;
                            dArray[n26] = d2 - d7;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n21; ++n19) {
                    n10 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n10 * n3 * n;
                    for (n16 = 2; n16 < n; n16 += 2) {
                        n15 = n5 + n16;
                        n14 = n6 + n16;
                        for (n13 = 0; n13 < n3; ++n13) {
                            n12 = n13 * n + n18;
                            n23 = n13 * n + n17;
                            n11 = n15 + n12;
                            int n28 = n15 + n23;
                            n9 = n14 + n12;
                            int n29 = n14 + n23;
                            d7 = dArray2[n9 - 1];
                            d6 = dArray2[n9];
                            d2 = dArray2[n29 - 1];
                            d = dArray2[n29];
                            dArray[n11 - 1] = d7 + d2;
                            dArray[n11] = d6 + d;
                            dArray[n28 - 1] = d6 - d;
                            dArray[n28] = d2 - d7;
                        }
                    }
                }
            }
        } else {
            System.arraycopy(dArray2, n6, dArray, n5, n4);
        }
        for (n19 = 1; n19 < n21; ++n19) {
            n10 = n2 - n19;
            n18 = n19 * n3 * n;
            n17 = n10 * n3 * n;
            for (n16 = 0; n16 < n3; ++n16) {
                n15 = n16 * n + n18;
                n14 = n16 * n + n17;
                n13 = n6 + n15;
                n12 = n6 + n14;
                double d13 = dArray2[n13];
                double d14 = dArray2[n12];
                dArray[n5 + n15] = d13 + d14;
                dArray[n5 + n14] = d14 - d13;
            }
        }
        double d15 = 1.0;
        double d16 = 0.0;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n21; ++n18) {
            int n30 = n2 - n18;
            double d17 = d4 * d15 - d5 * d16;
            d16 = d4 * d16 + d5 * d15;
            d15 = d17;
            n17 = n18 * n4;
            n16 = n30 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                n14 = n6 + n15;
                n13 = n5 + n15;
                dArray2[n14 + n17] = dArray[n13] + d15 * dArray[n13 + n4];
                dArray2[n14 + n16] = d16 * dArray[n13 + n19];
            }
            double d18 = d15;
            double d19 = d16;
            double d20 = d15;
            double d21 = d16;
            for (n15 = 2; n15 < n21; ++n15) {
                n10 = n2 - n15;
                double d22 = d18 * d20 - d19 * d21;
                d21 = d18 * d21 + d19 * d20;
                d20 = d22;
                n14 = n15 * n4;
                n13 = n10 * n4;
                for (n12 = 0; n12 < n4; ++n12) {
                    int n31 = n6 + n12;
                    n11 = n5 + n12;
                    int n32 = n31 + n17;
                    dArray2[n32] = dArray2[n32] + d20 * dArray[n11 + n14];
                    int n33 = n31 + n16;
                    dArray2[n33] = dArray2[n33] + d21 * dArray[n11 + n13];
                }
            }
        }
        for (n18 = 1; n18 < n21; ++n18) {
            n17 = n18 * n4;
            for (n16 = 0; n16 < n4; ++n16) {
                int n34 = n6 + n16;
                dArray2[n34] = dArray2[n34] + dArray[n5 + n16 + n17];
            }
        }
        if (n >= n3) {
            for (n18 = 0; n18 < n3; ++n18) {
                n17 = n18 * n;
                n16 = n17 * n2;
                for (n15 = 0; n15 < n; ++n15) {
                    dArray[n5 + n15 + n16] = dArray2[n6 + n15 + n17];
                }
            }
        } else {
            for (n18 = 0; n18 < n; ++n18) {
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n;
                    dArray[n5 + n18 + n16 * n2] = dArray2[n6 + n18 + n16];
                }
            }
        }
        n18 = n2 * n;
        for (n17 = 1; n17 < n21; ++n17) {
            n10 = n2 - n17;
            n8 = 2 * n17;
            n16 = n17 * n3 * n;
            n15 = n10 * n3 * n;
            n14 = n8 * n;
            for (n13 = 0; n13 < n3; ++n13) {
                n12 = n13 * n;
                int n35 = n12 + n16;
                n11 = n12 + n15;
                int n36 = n13 * n18;
                dArray[n5 + n - 1 + n14 - n + n36] = dArray2[n6 + n35];
                dArray[n5 + n14 + n36] = dArray2[n6 + n11];
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n17 = 1; n17 < n21; ++n17) {
                n10 = n2 - n17;
                n8 = 2 * n17;
                n16 = n17 * n3 * n;
                n15 = n10 * n3 * n;
                n14 = n8 * n;
                for (n13 = 0; n13 < n3; ++n13) {
                    n12 = n13 * n18;
                    int n37 = n13 * n;
                    for (n11 = 2; n11 < n; n11 += 2) {
                        int n38 = n - n11;
                        int n39 = n5 + n11;
                        n9 = n5 + n38;
                        int n40 = n6 + n11;
                        int n41 = n39 + n14 + n12;
                        int n42 = n9 + n14 - n + n12;
                        int n43 = n40 + n37 + n16;
                        int n44 = n40 + n37 + n15;
                        d2 = dArray2[n43 - 1];
                        d = dArray2[n43];
                        double d23 = dArray2[n44 - 1];
                        double d24 = dArray2[n44];
                        dArray[n41 - 1] = d2 + d23;
                        dArray[n42 - 1] = d2 - d23;
                        dArray[n41] = d + d24;
                        dArray[n42] = d24 - d;
                    }
                }
            }
        } else {
            for (n17 = 1; n17 < n21; ++n17) {
                n10 = n2 - n17;
                n8 = 2 * n17;
                n16 = n17 * n3 * n;
                n15 = n10 * n3 * n;
                n14 = n8 * n;
                for (n13 = 2; n13 < n; n13 += 2) {
                    int n45 = n - n13;
                    n12 = n5 + n13;
                    int n46 = n5 + n45;
                    n11 = n6 + n13;
                    for (int i = 0; i < n3; ++i) {
                        n9 = i * n18;
                        int n47 = i * n;
                        int n48 = n12 + n14 + n9;
                        int n49 = n46 + n14 - n + n9;
                        int n50 = n11 + n47 + n16;
                        int n51 = n11 + n47 + n15;
                        d2 = dArray2[n50 - 1];
                        d = dArray2[n50];
                        double d25 = dArray2[n51 - 1];
                        double d26 = dArray2[n51];
                        dArray[n48 - 1] = d2 + d25;
                        dArray[n49 - 1] = d2 - d25;
                        dArray[n48] = d + d26;
                        dArray[n49] = d26 - d;
                    }
                }
            }
        }
    }

    void radbg(int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7) {
        double d;
        double d2;
        int n8;
        int n9;
        double d3;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21 = n7;
        double d4 = Math.PI * 2 / (double)n2;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        int n22 = (n - 1) / 2;
        int n23 = (n2 + 1) / 2;
        int n24 = n2 * n;
        if (n >= n3) {
            for (n20 = 0; n20 < n3; ++n20) {
                n19 = n20 * n;
                n18 = n20 * n24;
                for (n17 = 0; n17 < n; ++n17) {
                    dArray2[n6 + n17 + n19] = dArray[n5 + n17 + n18];
                }
            }
        } else {
            for (n20 = 0; n20 < n; ++n20) {
                n19 = n6 + n20;
                n18 = n5 + n20;
                for (n17 = 0; n17 < n3; ++n17) {
                    dArray2[n19 + n17 * n] = dArray[n18 + n17 * n24];
                }
            }
        }
        n20 = n5 + n - 1;
        for (n19 = 1; n19 < n23; ++n19) {
            n16 = n2 - n19;
            int n25 = 2 * n19;
            n18 = n19 * n3 * n;
            n17 = n16 * n3 * n;
            n15 = n25 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n13 * n2;
                n11 = n20 + n15 + n12 - n;
                n10 = n5 + n15 + n12;
                double d7 = dArray[n11];
                d3 = dArray[n10];
                dArray2[n6 + n13 + n18] = d7 + d7;
                dArray2[n6 + n13 + n17] = d3 + d3;
            }
        }
        if (n != 1) {
            double d8;
            double d9;
            double d10;
            double d11;
            int n26;
            int n27;
            int n28;
            int n29;
            if (n22 >= n3) {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 0; n14 < n3; ++n14) {
                        n13 = n14 * n + n18;
                        n12 = n14 * n + n17;
                        n11 = n14 * n2 * n + n15;
                        for (n10 = 2; n10 < n; n10 += 2) {
                            n29 = n - n10;
                            int n30 = n6 + n10;
                            n9 = n5 + n29;
                            int n31 = n5 + n10;
                            n8 = n30 + n13;
                            n28 = n30 + n12;
                            n27 = n31 + n11;
                            n26 = n9 + n11 - n;
                            d11 = dArray[n27 - 1];
                            d10 = dArray[n27];
                            d9 = dArray[n26 - 1];
                            d8 = dArray[n26];
                            dArray2[n8 - 1] = d11 + d9;
                            dArray2[n28 - 1] = d11 - d9;
                            dArray2[n8] = d10 - d8;
                            dArray2[n28] = d10 + d8;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 2; n14 < n; n14 += 2) {
                        n29 = n - n14;
                        n13 = n6 + n14;
                        n12 = n5 + n29;
                        n11 = n5 + n14;
                        for (n10 = 0; n10 < n3; ++n10) {
                            int n32 = n10 * n + n18;
                            n9 = n10 * n + n17;
                            int n33 = n10 * n2 * n + n15;
                            n8 = n13 + n32;
                            n28 = n13 + n9;
                            n27 = n11 + n33;
                            n26 = n12 + n33 - n;
                            d11 = dArray[n27 - 1];
                            d10 = dArray[n27];
                            d9 = dArray[n26 - 1];
                            d8 = dArray[n26];
                            dArray2[n8 - 1] = d11 + d9;
                            dArray2[n28 - 1] = d11 - d9;
                            dArray2[n8] = d10 - d8;
                            dArray2[n28] = d10 + d8;
                        }
                    }
                }
            }
        }
        double d12 = 1.0;
        double d13 = 0.0;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n23; ++n18) {
            int n34 = n2 - n18;
            double d14 = d5 * d12 - d6 * d13;
            d13 = d5 * d13 + d6 * d12;
            d12 = d14;
            n17 = n18 * n4;
            n15 = n34 * n4;
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                dArray[n13 + n17] = dArray2[n12] + d12 * dArray2[n12 + n4];
                dArray[n13 + n15] = d13 * dArray2[n12 + n19];
            }
            double d15 = d12;
            double d16 = d13;
            double d17 = d12;
            double d18 = d13;
            for (n14 = 2; n14 < n23; ++n14) {
                n16 = n2 - n14;
                double d19 = d15 * d17 - d16 * d18;
                d18 = d15 * d18 + d16 * d17;
                d17 = d19;
                n13 = n14 * n4;
                n12 = n16 * n4;
                for (n11 = 0; n11 < n4; ++n11) {
                    n10 = n5 + n11;
                    int n35 = n6 + n11;
                    int n36 = n10 + n17;
                    dArray[n36] = dArray[n36] + d17 * dArray2[n35 + n13];
                    int n37 = n10 + n15;
                    dArray[n37] = dArray[n37] + d18 * dArray2[n35 + n12];
                }
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n17 = n18 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n38 = n14 = n6 + n15;
                dArray2[n38] = dArray2[n38] + dArray2[n14 + n17];
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n16 = n2 - n18;
            n17 = n18 * n3 * n;
            n15 = n16 * n3 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13;
                n11 = n5 + n13 + n17;
                n10 = n5 + n13 + n15;
                double d20 = dArray[n11];
                d3 = dArray[n10];
                dArray2[n12 + n17] = d20 - d3;
                dArray2[n12 + n15] = d20 + d3;
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    n13 = n14 * n;
                    for (n12 = 2; n12 < n; n12 += 2) {
                        n11 = n6 + n12;
                        n10 = n5 + n12;
                        int n39 = n11 + n13 + n17;
                        n9 = n11 + n13 + n15;
                        int n40 = n10 + n13 + n17;
                        n8 = n10 + n13 + n15;
                        double d21 = dArray[n40 - 1];
                        double d22 = dArray[n40];
                        d2 = dArray[n8 - 1];
                        d = dArray[n8];
                        dArray2[n39 - 1] = d21 - d;
                        dArray2[n9 - 1] = d21 + d;
                        dArray2[n39] = d22 + d2;
                        dArray2[n9] = d22 - d2;
                    }
                }
            }
        } else {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 2; n14 < n; n14 += 2) {
                    n13 = n6 + n14;
                    n12 = n5 + n14;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n;
                        int n41 = n13 + n10 + n17;
                        n9 = n13 + n10 + n15;
                        int n42 = n12 + n10 + n17;
                        n8 = n12 + n10 + n15;
                        double d23 = dArray[n42 - 1];
                        double d24 = dArray[n42];
                        d2 = dArray[n8 - 1];
                        d = dArray[n8];
                        dArray2[n41 - 1] = d23 - d;
                        dArray2[n9 - 1] = d23 + d;
                        dArray2[n41] = d24 + d2;
                        dArray2[n9] = d24 - d2;
                    }
                }
            }
        }
        System.arraycopy(dArray2, n6, dArray, n5, n4);
        for (n18 = 1; n18 < n2; ++n18) {
            n17 = n18 * n3 * n;
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = n15 * n + n17;
                dArray[n5 + n14] = dArray2[n6 + n14];
            }
        }
        if (n22 <= n3) {
            int n43 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                int n44 = (n43 += n) - 1;
                n17 = n18 * n3 * n;
                for (n15 = 2; n15 < n; n15 += 2) {
                    n14 = (n44 += 2) + n21;
                    double d25 = this.wtable_r[n14 - 1];
                    double d26 = this.wtable_r[n14];
                    n13 = n5 + n15;
                    n12 = n6 + n15;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n + n17;
                        int n45 = n13 + n10;
                        n9 = n12 + n10;
                        double d27 = dArray2[n9 - 1];
                        double d28 = dArray2[n9];
                        dArray[n45 - 1] = d25 * d27 - d26 * d28;
                        dArray[n45] = d25 * d28 + d26 * d27;
                    }
                }
            }
        } else {
            int n46 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                n46 += n;
                n17 = n18 * n3 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    int n47 = n46 - 1;
                    n14 = n15 * n + n17;
                    for (n13 = 2; n13 < n; n13 += 2) {
                        n12 = (n47 += 2) + n21;
                        double d29 = this.wtable_r[n12 - 1];
                        double d30 = this.wtable_r[n12];
                        n11 = n5 + n13;
                        n10 = n6 + n13;
                        int n48 = n11 + n14;
                        n9 = n10 + n14;
                        double d31 = dArray2[n9 - 1];
                        double d32 = dArray2[n9];
                        dArray[n48 - 1] = d29 * d31 - d30 * d32;
                        dArray[n48] = d29 * d32 + d30 * d31;
                    }
                }
            }
        }
    }

    void cfftf(double[] dArray, int n, int n2) {
        int[] nArray = new int[1];
        int n3 = 2 * this.n;
        double[] dArray2 = new double[n3];
        int n4 = n3;
        int n5 = 4 * this.n;
        nArray[0] = 0;
        int n6 = (int)this.wtable[1 + n5];
        int n7 = 0;
        int n8 = 1;
        int n9 = n4;
        for (int i = 2; i <= n6 + 1; ++i) {
            int n10 = (int)this.wtable[i + n5];
            int n11 = n10 * n8;
            int n12 = this.n / n11;
            int n13 = n12 + n12;
            int n14 = n13 * n8;
            switch (n10) {
                case 4: {
                    if (n7 == 0) {
                        this.passf4(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf4(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 2: {
                    if (n7 == 0) {
                        this.passf2(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf2(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 3: {
                    if (n7 == 0) {
                        this.passf3(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf3(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 5: {
                    if (n7 == 0) {
                        this.passf5(n13, n8, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passf5(n13, n8, dArray2, 0, dArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                default: {
                    if (n7 == 0) {
                        this.passfg(nArray, n13, n10, n8, n14, dArray, n, dArray2, 0, n9, n2);
                    } else {
                        this.passfg(nArray, n13, n10, n8, n14, dArray2, 0, dArray, n, n9, n2);
                    }
                    if (nArray[0] == 0) break;
                    n7 = 1 - n7;
                }
            }
            n8 = n11;
            n9 += (n10 - 1) * n13;
        }
        if (n7 == 0) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, n3);
    }

    void passf2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n * n2;
        if (n <= 2) {
            for (int i = 0; i < n2; ++i) {
                int n9 = i * n;
                int n10 = n3 + 2 * n9;
                int n11 = n10 + n;
                double d = dArray[n10];
                double d2 = dArray[n10 + 1];
                double d3 = dArray[n11];
                double d4 = dArray[n11 + 1];
                int n12 = n4 + n9;
                int n13 = n12 + n8;
                dArray2[n12] = d + d3;
                dArray2[n12 + 1] = d2 + d4;
                dArray2[n13] = d - d3;
                dArray2[n13 + 1] = d2 - d4;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n - 1; j += 2) {
                    int n14 = i * n;
                    int n15 = n3 + j + 2 * n14;
                    int n16 = n15 + n;
                    double d = dArray[n15];
                    double d5 = dArray[n15 + 1];
                    double d6 = dArray[n16];
                    double d7 = dArray[n16 + 1];
                    int n17 = j + n7;
                    double d8 = this.wtable[n17];
                    double d9 = (double)n6 * this.wtable[n17 + 1];
                    double d10 = d - d6;
                    double d11 = d5 - d7;
                    int n18 = n4 + j + n14;
                    int n19 = n18 + n8;
                    dArray2[n18] = d + d6;
                    dArray2[n18 + 1] = d5 + d7;
                    dArray2[n19] = d8 * d10 - d9 * d11;
                    dArray2[n19 + 1] = d8 * d11 + d9 * d10;
                }
            }
        }
    }

    void passf3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n10 = n3 + (3 * i - 2) * n;
                int n11 = n10 + n;
                int n12 = n10 - n;
                double d = dArray[n10];
                double d2 = dArray[n10 + 1];
                double d3 = dArray[n11];
                double d4 = dArray[n11 + 1];
                double d5 = dArray[n12];
                double d6 = dArray[n12 + 1];
                double d7 = d + d3;
                double d8 = d5 + -0.5 * d7;
                double d9 = d2 + d4;
                double d10 = d6 + -0.5 * d9;
                double d11 = (double)n6 * 0.8660254037844387 * (d - d3);
                double d12 = (double)n6 * 0.8660254037844387 * (d2 - d4);
                int n13 = n4 + (i - 1) * n;
                int n14 = n13 + n9;
                int n15 = n14 + n9;
                dArray2[n13] = dArray[n12] + d7;
                dArray2[n13 + 1] = d6 + d9;
                dArray2[n14] = d8 - d12;
                dArray2[n14 + 1] = d10 + d11;
                dArray2[n15] = d8 + d12;
                dArray2[n15 + 1] = d10 - d11;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n16 = n3 + (3 * i - 2) * n;
                int n17 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n18 = j + n16;
                    int n19 = n18 + n;
                    int n20 = n18 - n;
                    double d = dArray[n18];
                    double d13 = dArray[n18 + 1];
                    double d14 = dArray[n19];
                    double d15 = dArray[n19 + 1];
                    double d16 = dArray[n20];
                    double d17 = dArray[n20 + 1];
                    double d18 = d + d14;
                    double d19 = d16 + -0.5 * d18;
                    double d20 = d13 + d15;
                    double d21 = d17 + -0.5 * d20;
                    double d22 = (double)n6 * 0.8660254037844387 * (d - d14);
                    double d23 = (double)n6 * 0.8660254037844387 * (d13 - d15);
                    double d24 = d19 - d23;
                    double d25 = d19 + d23;
                    double d26 = d21 + d22;
                    double d27 = d21 - d22;
                    int n21 = j + n7;
                    int n22 = j + n8;
                    double d28 = this.wtable[n21];
                    double d29 = (double)n6 * this.wtable[n21 + 1];
                    double d30 = this.wtable[n22];
                    double d31 = (double)n6 * this.wtable[n22 + 1];
                    int n23 = j + n17;
                    int n24 = n23 + n9;
                    int n25 = n24 + n9;
                    dArray2[n23] = d16 + d18;
                    dArray2[n23 + 1] = d17 + d20;
                    dArray2[n24] = d28 * d24 - d29 * d26;
                    dArray2[n24 + 1] = d28 * d26 + d29 * d24;
                    dArray2[n25] = d30 * d25 - d31 * d27;
                    dArray2[n25 + 1] = d30 * d27 + d31 * d25;
                }
            }
        }
    }

    void passf4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n2 * n;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                int n11 = i * n;
                int n12 = n3 + 4 * n11 + 1;
                int n13 = n12 + n;
                int n14 = n13 + n;
                int n15 = n14 + n;
                double d = dArray[n12 - 1];
                double d2 = dArray[n12];
                double d3 = dArray[n13 - 1];
                double d4 = dArray[n13];
                double d5 = dArray[n14 - 1];
                double d6 = dArray[n14];
                double d7 = dArray[n15 - 1];
                double d8 = dArray[n15];
                double d9 = d2 - d6;
                double d10 = d2 + d6;
                double d11 = d8 - d4;
                double d12 = d4 + d8;
                double d13 = d - d5;
                double d14 = d + d5;
                double d15 = d3 - d7;
                double d16 = d3 + d7;
                int n16 = n4 + n11;
                int n17 = n16 + n10;
                int n18 = n17 + n10;
                int n19 = n18 + n10;
                dArray2[n16] = d14 + d16;
                dArray2[n16 + 1] = d10 + d12;
                dArray2[n17] = d13 + (double)n6 * d11;
                dArray2[n17 + 1] = d9 + (double)n6 * d15;
                dArray2[n18] = d14 - d16;
                dArray2[n18 + 1] = d10 - d12;
                dArray2[n19] = d13 - (double)n6 * d11;
                dArray2[n19 + 1] = d9 - (double)n6 * d15;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n20 = i * n;
                int n21 = n3 + 1 + 4 * n20;
                for (int j = 0; j < n - 1; j += 2) {
                    int n22 = j + n21;
                    int n23 = n22 + n;
                    int n24 = n23 + n;
                    int n25 = n24 + n;
                    double d = dArray[n22 - 1];
                    double d17 = dArray[n22];
                    double d18 = dArray[n23 - 1];
                    double d19 = dArray[n23];
                    double d20 = dArray[n24 - 1];
                    double d21 = dArray[n24];
                    double d22 = dArray[n25 - 1];
                    double d23 = dArray[n25];
                    double d24 = d17 - d21;
                    double d25 = d17 + d21;
                    double d26 = d19 + d23;
                    double d27 = d23 - d19;
                    double d28 = d - d20;
                    double d29 = d + d20;
                    double d30 = d18 - d22;
                    double d31 = d18 + d22;
                    double d32 = d29 - d31;
                    double d33 = d25 - d26;
                    double d34 = d28 + (double)n6 * d27;
                    double d35 = d28 - (double)n6 * d27;
                    double d36 = d24 + (double)n6 * d30;
                    double d37 = d24 - (double)n6 * d30;
                    int n26 = j + n7;
                    int n27 = j + n8;
                    int n28 = j + n9;
                    double d38 = this.wtable[n26];
                    double d39 = (double)n6 * this.wtable[n26 + 1];
                    double d40 = this.wtable[n27];
                    double d41 = (double)n6 * this.wtable[n27 + 1];
                    double d42 = this.wtable[n28];
                    double d43 = (double)n6 * this.wtable[n28 + 1];
                    int n29 = n4 + j + n20;
                    int n30 = n29 + n10;
                    int n31 = n30 + n10;
                    int n32 = n31 + n10;
                    dArray2[n29] = d29 + d31;
                    dArray2[n29 + 1] = d25 + d26;
                    dArray2[n30] = d38 * d34 - d39 * d36;
                    dArray2[n30 + 1] = d38 * d36 + d39 * d34;
                    dArray2[n31] = d40 * d32 - d41 * d33;
                    dArray2[n31 + 1] = d40 * d33 + d41 * d32;
                    dArray2[n32] = d42 * d35 - d43 * d37;
                    dArray2[n32 + 1] = d42 * d37 + d43 * d35;
                }
            }
        }
    }

    void passf5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n9 + n;
        int n11 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n12 = n3 + (5 * i - 4) * n + 1;
                int n13 = n12 + n;
                int n14 = n12 - n;
                int n15 = n13 + n;
                int n16 = n15 + n;
                double d = dArray[n12 - 1];
                double d2 = dArray[n12];
                double d3 = dArray[n13 - 1];
                double d4 = dArray[n13];
                double d5 = dArray[n14 - 1];
                double d6 = dArray[n14];
                double d7 = dArray[n15 - 1];
                double d8 = dArray[n15];
                double d9 = dArray[n16 - 1];
                double d10 = dArray[n16];
                double d11 = d2 - d10;
                double d12 = d2 + d10;
                double d13 = d4 - d8;
                double d14 = d4 + d8;
                double d15 = d - d9;
                double d16 = d + d9;
                double d17 = d3 - d7;
                double d18 = d3 + d7;
                double d19 = d5 + 0.30901699437494745 * d16 + -0.8090169943749473 * d18;
                double d20 = d6 + 0.30901699437494745 * d12 + -0.8090169943749473 * d14;
                double d21 = d5 + -0.8090169943749473 * d16 + 0.30901699437494745 * d18;
                double d22 = d6 + -0.8090169943749473 * d12 + 0.30901699437494745 * d14;
                double d23 = (double)n6 * (0.9510565162951535 * d15 + 0.5877852522924732 * d17);
                double d24 = (double)n6 * (0.9510565162951535 * d11 + 0.5877852522924732 * d13);
                double d25 = (double)n6 * (0.5877852522924732 * d15 - 0.9510565162951535 * d17);
                double d26 = (double)n6 * (0.5877852522924732 * d11 - 0.9510565162951535 * d13);
                int n17 = n4 + (i - 1) * n;
                int n18 = n17 + n11;
                int n19 = n18 + n11;
                int n20 = n19 + n11;
                int n21 = n20 + n11;
                dArray2[n17] = d5 + d16 + d18;
                dArray2[n17 + 1] = d6 + d12 + d14;
                dArray2[n18] = d19 - d24;
                dArray2[n18 + 1] = d20 + d23;
                dArray2[n19] = d21 - d26;
                dArray2[n19 + 1] = d22 + d25;
                dArray2[n20] = d21 + d26;
                dArray2[n20 + 1] = d22 - d25;
                dArray2[n21] = d19 + d24;
                dArray2[n21 + 1] = d20 - d23;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n22 = n3 + 1 + (i * 5 - 4) * n;
                int n23 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n24 = j + n22;
                    int n25 = n24 + n;
                    int n26 = n24 - n;
                    int n27 = n25 + n;
                    int n28 = n27 + n;
                    double d = dArray[n24 - 1];
                    double d27 = dArray[n24];
                    double d28 = dArray[n25 - 1];
                    double d29 = dArray[n25];
                    double d30 = dArray[n26 - 1];
                    double d31 = dArray[n26];
                    double d32 = dArray[n27 - 1];
                    double d33 = dArray[n27];
                    double d34 = dArray[n28 - 1];
                    double d35 = dArray[n28];
                    double d36 = d27 - d35;
                    double d37 = d27 + d35;
                    double d38 = d29 - d33;
                    double d39 = d29 + d33;
                    double d40 = d - d34;
                    double d41 = d + d34;
                    double d42 = d28 - d32;
                    double d43 = d28 + d32;
                    double d44 = d30 + 0.30901699437494745 * d41 + -0.8090169943749473 * d43;
                    double d45 = d31 + 0.30901699437494745 * d37 + -0.8090169943749473 * d39;
                    double d46 = d30 + -0.8090169943749473 * d41 + 0.30901699437494745 * d43;
                    double d47 = d31 + -0.8090169943749473 * d37 + 0.30901699437494745 * d39;
                    double d48 = (double)n6 * (0.9510565162951535 * d40 + 0.5877852522924732 * d42);
                    double d49 = (double)n6 * (0.9510565162951535 * d36 + 0.5877852522924732 * d38);
                    double d50 = (double)n6 * (0.5877852522924732 * d40 - 0.9510565162951535 * d42);
                    double d51 = (double)n6 * (0.5877852522924732 * d36 - 0.9510565162951535 * d38);
                    double d52 = d46 - d51;
                    double d53 = d46 + d51;
                    double d54 = d47 + d50;
                    double d55 = d47 - d50;
                    double d56 = d44 + d49;
                    double d57 = d44 - d49;
                    double d58 = d45 - d48;
                    double d59 = d45 + d48;
                    int n29 = j + n7;
                    int n30 = j + n8;
                    int n31 = j + n9;
                    int n32 = j + n10;
                    double d60 = this.wtable[n29];
                    double d61 = (double)n6 * this.wtable[n29 + 1];
                    double d62 = this.wtable[n30];
                    double d63 = (double)n6 * this.wtable[n30 + 1];
                    double d64 = this.wtable[n31];
                    double d65 = (double)n6 * this.wtable[n31 + 1];
                    double d66 = this.wtable[n32];
                    double d67 = (double)n6 * this.wtable[n32 + 1];
                    int n33 = j + n23;
                    int n34 = n33 + n11;
                    int n35 = n34 + n11;
                    int n36 = n35 + n11;
                    int n37 = n36 + n11;
                    dArray2[n33] = d30 + d41 + d43;
                    dArray2[n33 + 1] = d31 + d37 + d39;
                    dArray2[n34] = d60 * d57 - d61 * d59;
                    dArray2[n34 + 1] = d60 * d59 + d61 * d57;
                    dArray2[n35] = d62 * d52 - d63 * d54;
                    dArray2[n35 + 1] = d62 * d54 + d63 * d52;
                    dArray2[n36] = d64 * d53 - d65 * d55;
                    dArray2[n36 + 1] = d64 * d55 + d65 * d53;
                    dArray2[n37] = d66 * d56 - d67 * d58;
                    dArray2[n37 + 1] = d66 * d58 + d67 * d56;
                }
            }
        }
    }

    void passfg(int[] nArray, int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7, int n8) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = n7;
        int n21 = n / 2;
        int n22 = (n2 + 1) / 2;
        int n23 = n2 * n;
        if (n >= n3) {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n;
                n16 = n18 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    n14 = n15 * n;
                    n13 = n14 + n17 * n3;
                    n12 = n14 + n16 * n3;
                    n11 = n14 * n2;
                    for (n10 = 0; n10 < n; ++n10) {
                        n9 = n6 + n10;
                        double d6 = dArray[n5 + n10 + n17 + n11];
                        d5 = dArray[n5 + n10 + n16 + n11];
                        dArray2[n9 + n13] = d6 + d5;
                        dArray2[n9 + n12] = d6 - d5;
                    }
                }
            }
            for (n19 = 0; n19 < n3; ++n19) {
                n17 = n19 * n;
                n16 = n17 * n2;
                for (n15 = 0; n15 < n; ++n15) {
                    dArray2[n6 + n15 + n17] = dArray[n5 + n15 + n16];
                }
            }
        } else {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n3 * n;
                n16 = n18 * n3 * n;
                n15 = n19 * n;
                n14 = n18 * n;
                for (n13 = 0; n13 < n; ++n13) {
                    for (n12 = 0; n12 < n3; ++n12) {
                        n11 = n12 * n;
                        n10 = n11 * n2;
                        n9 = n6 + n13;
                        int n24 = n5 + n13;
                        d4 = dArray[n24 + n15 + n10];
                        d3 = dArray[n24 + n14 + n10];
                        dArray2[n9 + n11 + n17] = d4 + d3;
                        dArray2[n9 + n11 + n16] = d4 - d3;
                    }
                }
            }
            for (n19 = 0; n19 < n; ++n19) {
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n;
                    dArray2[n6 + n19 + n16] = dArray[n5 + n19 + n16 * n2];
                }
            }
        }
        int n25 = 2 - n;
        int n26 = 0;
        n19 = (n2 - 1) * n4;
        for (int i = 1; i < n22; ++i) {
            int n27 = n2 - i;
            n17 = i * n4;
            n16 = n27 * n4;
            n15 = (n25 += n) + n20;
            d2 = this.wtable[n15 - 2];
            d = (double)n8 * this.wtable[n15 - 1];
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                dArray[n13 + n17] = dArray2[n12] + d2 * dArray2[n12 + n4];
                dArray[n13 + n16] = d * dArray2[n12 + n19];
            }
            int n28 = n25;
            n26 += n;
            for (n14 = 2; n14 < n22; ++n14) {
                n18 = n2 - n14;
                if ((n28 += n26) > n23) {
                    n28 -= n23;
                }
                n13 = n28 + n20;
                double d7 = this.wtable[n13 - 2];
                double d8 = (double)n8 * this.wtable[n13 - 1];
                n12 = n14 * n4;
                n11 = n18 * n4;
                for (n10 = 0; n10 < n4; ++n10) {
                    n9 = n5 + n10;
                    int n29 = n6 + n10;
                    int n30 = n9 + n17;
                    dArray[n30] = dArray[n30] + d7 * dArray2[n29 + n12];
                    int n31 = n9 + n16;
                    dArray[n31] = dArray[n31] + d8 * dArray2[n29 + n11];
                }
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n16 = n17 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n32 = n14 = n6 + n15;
                dArray2[n32] = dArray2[n32] + dArray2[n14 + n16];
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n18 = n2 - n17;
            n16 = n17 * n4;
            n15 = n18 * n4;
            for (n14 = 1; n14 < n4; n14 += 2) {
                n13 = n6 + n14;
                n12 = n5 + n14;
                n11 = n12 + n16;
                n10 = n12 + n15;
                double d9 = dArray[n11 - 1];
                d4 = dArray[n11];
                d3 = dArray[n10 - 1];
                double d10 = dArray[n10];
                int n33 = n13 + n16;
                int n34 = n13 + n15;
                dArray2[n33 - 1] = d9 - d10;
                dArray2[n34 - 1] = d9 + d10;
                dArray2[n33] = d4 + d3;
                dArray2[n34] = d4 - d3;
            }
        }
        nArray[0] = 1;
        if (n == 2) {
            return;
        }
        nArray[0] = 0;
        System.arraycopy(dArray2, n6, dArray, n5, n4);
        n17 = n3 * n;
        for (n16 = 1; n16 < n2; ++n16) {
            n15 = n16 * n17;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13 + n15;
                n11 = n5 + n13 + n15;
                dArray[n11] = dArray2[n12];
                dArray[n11 + 1] = dArray2[n12 + 1];
            }
        }
        if (n21 <= n3) {
            int n35 = 0;
            for (n16 = 1; n16 < n2; ++n16) {
                n35 += 2;
                n15 = n16 * n3 * n;
                for (n14 = 3; n14 < n; n14 += 2) {
                    n13 = (n35 += 2) + n20 - 1;
                    d2 = this.wtable[n13 - 1];
                    d = (double)n8 * this.wtable[n13];
                    n12 = n5 + n14;
                    n11 = n6 + n14;
                    for (n10 = 0; n10 < n3; ++n10) {
                        int n36 = n10 * n + n15;
                        int n37 = n12 + n36;
                        int n38 = n11 + n36;
                        d5 = dArray2[n38 - 1];
                        double d11 = dArray2[n38];
                        dArray[n37 - 1] = d2 * d5 - d * d11;
                        dArray[n37] = d2 * d11 + d * d5;
                    }
                }
            }
        } else {
            int n39 = 2 - n;
            for (n16 = 1; n16 < n2; ++n16) {
                n39 += n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    int n40 = n39;
                    n13 = n14 * n + n15;
                    for (n12 = 3; n12 < n; n12 += 2) {
                        n11 = (n40 += 2) - 1 + n20;
                        d2 = this.wtable[n11 - 1];
                        d = (double)n8 * this.wtable[n11];
                        n10 = n5 + n12 + n13;
                        int n41 = n6 + n12 + n13;
                        double d12 = dArray2[n41 - 1];
                        d5 = dArray2[n41];
                        dArray[n10 - 1] = d2 * d12 - d * d5;
                        dArray[n10] = d2 * d5 + d * d12;
                    }
                }
            }
        }
    }

    private void cftfsub(int n, double[] dArray, int n2, int[] nArray, int n3, double[] dArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftf1st(n, dArray, n2, dArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, dArray, n2, n3, dArray2);
                } else if (n > 512) {
                    this.cftrec4(n, dArray, n2, n3, dArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, dArray, n2, n3, dArray2);
                } else {
                    this.cftfx41(n, dArray, n2, n3, dArray2);
                }
                this.bitrv2(n, nArray, dArray, n2);
            } else if (n == 32) {
                this.cftf161(dArray, n2, dArray2, n3 - 8);
                this.bitrv216(dArray, n2);
            } else {
                this.cftf081(dArray, n2, dArray2, 0);
                this.bitrv208(dArray, n2);
            }
        } else if (n == 8) {
            this.cftf040(dArray, n2);
        } else if (n == 4) {
            this.cftxb020(dArray, n2);
        }
    }

    private void cftbsub(int n, double[] dArray, int n2, int[] nArray, int n3, double[] dArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftb1st(n, dArray, n2, dArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, dArray, n2, n3, dArray2);
                } else if (n > 512) {
                    this.cftrec4(n, dArray, n2, n3, dArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, dArray, n2, n3, dArray2);
                } else {
                    this.cftfx41(n, dArray, n2, n3, dArray2);
                }
                this.bitrv2conj(n, nArray, dArray, n2);
            } else if (n == 32) {
                this.cftf161(dArray, n2, dArray2, n3 - 8);
                this.bitrv216neg(dArray, n2);
            } else {
                this.cftf081(dArray, n2, dArray2, 0);
                this.bitrv208neg(dArray, n2);
            }
        } else if (n == 8) {
            this.cftb040(dArray, n2);
        } else if (n == 4) {
            this.cftxb020(dArray, n2);
        }
    }

    private void bitrv2(int n, int[] nArray, double[] dArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d5;
                double d6;
                double d7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                d7 = dArray[n13];
                d6 = dArray[n13 + 1];
                d5 = dArray[n12];
                d = dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                d7 = dArray[n13];
                d6 = dArray[n13 + 1];
                d5 = dArray[n12];
                d = dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
            }
        }
    }

    private void bitrv2conj(int n, int[] nArray, double[] dArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                dArray[n8 - 1] = -dArray[n8 - 1];
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                dArray[n7 + 3] = -dArray[n7 + 3];
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                dArray[n8 - 1] = -dArray[n8 - 1];
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                dArray[n7 + 3] = -dArray[n7 + 3];
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d5;
                double d6;
                double d7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                dArray[n13 - 1] = -dArray[n13 - 1];
                d7 = dArray[n13];
                d6 = -dArray[n13 + 1];
                d5 = dArray[n12];
                d = -dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
                dArray[n12 + 3] = -dArray[n12 + 3];
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                dArray[n13 - 1] = -dArray[n13 - 1];
                d7 = dArray[n13];
                d6 = -dArray[n13 + 1];
                d5 = dArray[n12];
                d = -dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
                dArray[n12 + 3] = -dArray[n12 + 3];
            }
        }
    }

    private void bitrv216(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 14];
        double d12 = dArray[n + 15];
        double d13 = dArray[n + 16];
        double d14 = dArray[n + 17];
        double d15 = dArray[n + 20];
        double d16 = dArray[n + 21];
        double d17 = dArray[n + 22];
        double d18 = dArray[n + 23];
        double d19 = dArray[n + 24];
        double d20 = dArray[n + 25];
        double d21 = dArray[n + 26];
        double d22 = dArray[n + 27];
        double d23 = dArray[n + 28];
        double d24 = dArray[n + 29];
        dArray[n + 2] = d13;
        dArray[n + 3] = d14;
        dArray[n + 4] = d7;
        dArray[n + 5] = d8;
        dArray[n + 6] = d19;
        dArray[n + 7] = d20;
        dArray[n + 8] = d3;
        dArray[n + 9] = d4;
        dArray[n + 10] = d15;
        dArray[n + 11] = d16;
        dArray[n + 14] = d23;
        dArray[n + 15] = d24;
        dArray[n + 16] = d;
        dArray[n + 17] = d2;
        dArray[n + 20] = d9;
        dArray[n + 21] = d10;
        dArray[n + 22] = d21;
        dArray[n + 23] = d22;
        dArray[n + 24] = d5;
        dArray[n + 25] = d6;
        dArray[n + 26] = d17;
        dArray[n + 27] = d18;
        dArray[n + 28] = d11;
        dArray[n + 29] = d12;
    }

    private void bitrv216neg(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 12];
        double d12 = dArray[n + 13];
        double d13 = dArray[n + 14];
        double d14 = dArray[n + 15];
        double d15 = dArray[n + 16];
        double d16 = dArray[n + 17];
        double d17 = dArray[n + 18];
        double d18 = dArray[n + 19];
        double d19 = dArray[n + 20];
        double d20 = dArray[n + 21];
        double d21 = dArray[n + 22];
        double d22 = dArray[n + 23];
        double d23 = dArray[n + 24];
        double d24 = dArray[n + 25];
        double d25 = dArray[n + 26];
        double d26 = dArray[n + 27];
        double d27 = dArray[n + 28];
        double d28 = dArray[n + 29];
        double d29 = dArray[n + 30];
        double d30 = dArray[n + 31];
        dArray[n + 2] = d29;
        dArray[n + 3] = d30;
        dArray[n + 4] = d13;
        dArray[n + 5] = d14;
        dArray[n + 6] = d21;
        dArray[n + 7] = d22;
        dArray[n + 8] = d5;
        dArray[n + 9] = d6;
        dArray[n + 10] = d25;
        dArray[n + 11] = d26;
        dArray[n + 12] = d9;
        dArray[n + 13] = d10;
        dArray[n + 14] = d17;
        dArray[n + 15] = d18;
        dArray[n + 16] = d;
        dArray[n + 17] = d2;
        dArray[n + 18] = d27;
        dArray[n + 19] = d28;
        dArray[n + 20] = d11;
        dArray[n + 21] = d12;
        dArray[n + 22] = d19;
        dArray[n + 23] = d20;
        dArray[n + 24] = d3;
        dArray[n + 25] = d4;
        dArray[n + 26] = d23;
        dArray[n + 27] = d24;
        dArray[n + 28] = d7;
        dArray[n + 29] = d8;
        dArray[n + 30] = d15;
        dArray[n + 31] = d16;
    }

    private void bitrv208(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 6];
        double d4 = dArray[n + 7];
        double d5 = dArray[n + 8];
        double d6 = dArray[n + 9];
        double d7 = dArray[n + 12];
        double d8 = dArray[n + 13];
        dArray[n + 2] = d5;
        dArray[n + 3] = d6;
        dArray[n + 6] = d7;
        dArray[n + 7] = d8;
        dArray[n + 8] = d;
        dArray[n + 9] = d2;
        dArray[n + 12] = d3;
        dArray[n + 13] = d4;
    }

    private void bitrv208neg(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 12];
        double d12 = dArray[n + 13];
        double d13 = dArray[n + 14];
        double d14 = dArray[n + 15];
        dArray[n + 2] = d13;
        dArray[n + 3] = d14;
        dArray[n + 4] = d5;
        dArray[n + 5] = d6;
        dArray[n + 6] = d9;
        dArray[n + 7] = d10;
        dArray[n + 8] = d;
        dArray[n + 9] = d2;
        dArray[n + 10] = d11;
        dArray[n + 11] = d12;
        dArray[n + 12] = d3;
        dArray[n + 13] = d4;
        dArray[n + 14] = d7;
        dArray[n + 15] = d8;
    }

    private void cftf1st(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d5 = dArray[n2] + dArray[n12];
        double d6 = dArray[n2 + 1] + dArray[n12 + 1];
        double d7 = dArray[n2] - dArray[n12];
        double d8 = dArray[n2 + 1] - dArray[n12 + 1];
        double d9 = dArray[n11] + dArray[n13];
        double d10 = dArray[n11 + 1] + dArray[n13 + 1];
        double d11 = dArray[n11] - dArray[n13];
        double d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d5 + d9;
        dArray[n2 + 1] = d6 + d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 - d10;
        dArray[n12] = d7 - d12;
        dArray[n12 + 1] = d8 + d11;
        dArray[n13] = d7 + d12;
        dArray[n13 + 1] = d8 - d11;
        double d13 = dArray2[n3 + 1];
        double d14 = dArray2[n3 + 2];
        double d15 = dArray2[n3 + 3];
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            d4 = d14 * (d16 + dArray2[n15]);
            d3 = d14 * (d17 + dArray2[n15 + 1]);
            d2 = d15 * (d18 + dArray2[n15 + 2]);
            d = d15 * (d19 + dArray2[n15 + 3]);
            d16 = dArray2[n15];
            d17 = dArray2[n15 + 1];
            d18 = dArray2[n15 + 2];
            d19 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d5 = dArray[n16] + dArray[n12];
            d6 = dArray[n16 + 1] + dArray[n12 + 1];
            d7 = dArray[n16] - dArray[n12];
            d8 = dArray[n16 + 1] - dArray[n12 + 1];
            double d20 = dArray[n16 + 2] + dArray[n12 + 2];
            double d21 = dArray[n16 + 3] + dArray[n12 + 3];
            double d22 = dArray[n16 + 2] - dArray[n12 + 2];
            double d23 = dArray[n16 + 3] - dArray[n12 + 3];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            double d24 = dArray[n11 + 2] + dArray[n13 + 2];
            double d25 = dArray[n11 + 3] + dArray[n13 + 3];
            double d26 = dArray[n11 + 2] - dArray[n13 + 2];
            double d27 = dArray[n11 + 3] - dArray[n13 + 3];
            dArray[n16] = d5 + d9;
            dArray[n16 + 1] = d6 + d10;
            dArray[n16 + 2] = d20 + d24;
            dArray[n16 + 3] = d21 + d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 - d10;
            dArray[n11 + 2] = d20 - d24;
            dArray[n11 + 3] = d21 - d25;
            d5 = d7 - d12;
            d6 = d8 + d11;
            dArray[n12] = d4 * d5 - d3 * d6;
            dArray[n12 + 1] = d4 * d6 + d3 * d5;
            d5 = d22 - d27;
            d6 = d23 + d26;
            dArray[n12 + 2] = d16 * d5 - d17 * d6;
            dArray[n12 + 3] = d16 * d6 + d17 * d5;
            d5 = d7 + d12;
            d6 = d8 - d11;
            dArray[n13] = d2 * d5 + d * d6;
            dArray[n13 + 1] = d2 * d6 - d * d5;
            d5 = d22 + d27;
            d6 = d23 - d26;
            dArray[n13 + 2] = d18 * d5 + d19 * d6;
            dArray[n13 + 3] = d18 * d6 - d19 * d5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d5 = dArray[n4] + dArray[n12];
            d6 = dArray[n4 + 1] + dArray[n12 + 1];
            d7 = dArray[n4] - dArray[n12];
            d8 = dArray[n4 + 1] - dArray[n12 + 1];
            d20 = dArray[n4 - 2] + dArray[n12 - 2];
            d21 = dArray[n4 - 1] + dArray[n12 - 1];
            d22 = dArray[n4 - 2] - dArray[n12 - 2];
            d23 = dArray[n4 - 1] - dArray[n12 - 1];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            d24 = dArray[n11 - 2] + dArray[n13 - 2];
            d25 = dArray[n11 - 1] + dArray[n13 - 1];
            d26 = dArray[n11 - 2] - dArray[n13 - 2];
            d27 = dArray[n11 - 1] - dArray[n13 - 1];
            dArray[n4] = d5 + d9;
            dArray[n4 + 1] = d6 + d10;
            dArray[n4 - 2] = d20 + d24;
            dArray[n4 - 1] = d21 + d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 - d10;
            dArray[n11 - 2] = d20 - d24;
            dArray[n11 - 1] = d21 - d25;
            d5 = d7 - d12;
            d6 = d8 + d11;
            dArray[n12] = d3 * d5 - d4 * d6;
            dArray[n12 + 1] = d3 * d6 + d4 * d5;
            d5 = d22 - d27;
            d6 = d23 + d26;
            dArray[n12 - 2] = d17 * d5 - d16 * d6;
            dArray[n12 - 1] = d17 * d6 + d16 * d5;
            d5 = d7 + d12;
            d6 = d8 - d11;
            dArray[n13] = d * d5 + d2 * d6;
            dArray[n13 + 1] = d * d6 - d2 * d5;
            d5 = d22 + d27;
            d6 = d23 - d26;
            dArray[n2 + n10 - 2] = d19 * d5 + d18 * d6;
            dArray[n2 + n10 - 1] = d19 * d6 - d18 * d5;
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d5 = dArray[n4 - 2] + dArray[n12 - 2];
        d6 = dArray[n4 - 1] + dArray[n12 - 1];
        d7 = dArray[n4 - 2] - dArray[n12 - 2];
        d8 = dArray[n4 - 1] - dArray[n12 - 1];
        d9 = dArray[n11 - 2] + dArray[n13 - 2];
        d10 = dArray[n11 - 1] + dArray[n13 - 1];
        d11 = dArray[n11 - 2] - dArray[n13 - 2];
        d12 = dArray[n11 - 1] - dArray[n13 - 1];
        dArray[n4 - 2] = d5 + d9;
        dArray[n4 - 1] = d6 + d10;
        dArray[n11 - 2] = d5 - d9;
        dArray[n11 - 1] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12 - 2] = d4 * d5 - d3 * d6;
        dArray[n12 - 1] = d4 * d6 + d3 * d5;
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13 - 2] = d2 * d5 + d * d6;
        dArray[n13 - 1] = d2 * d6 - d * d5;
        d5 = dArray[n4] + dArray[n12];
        d6 = dArray[n4 + 1] + dArray[n12 + 1];
        d7 = dArray[n4] - dArray[n12];
        d8 = dArray[n4 + 1] - dArray[n12 + 1];
        d9 = dArray[n11] + dArray[n13];
        d10 = dArray[n11 + 1] + dArray[n13 + 1];
        d11 = dArray[n11] - dArray[n13];
        d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d5 + d9;
        dArray[n4 + 1] = d6 + d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12] = d13 * (d5 - d6);
        dArray[n12 + 1] = d13 * (d6 + d5);
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13] = -d13 * (d5 + d6);
        dArray[n13 + 1] = -d13 * (d6 - d5);
        d5 = dArray[n4 + 2] + dArray[n12 + 2];
        d6 = dArray[n4 + 3] + dArray[n12 + 3];
        d7 = dArray[n4 + 2] - dArray[n12 + 2];
        d8 = dArray[n4 + 3] - dArray[n12 + 3];
        d9 = dArray[n11 + 2] + dArray[n13 + 2];
        d10 = dArray[n11 + 3] + dArray[n13 + 3];
        d11 = dArray[n11 + 2] - dArray[n13 + 2];
        d12 = dArray[n11 + 3] - dArray[n13 + 3];
        dArray[n4 + 2] = d5 + d9;
        dArray[n4 + 3] = d6 + d10;
        dArray[n11 + 2] = d5 - d9;
        dArray[n11 + 3] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12 + 2] = d3 * d5 - d4 * d6;
        dArray[n12 + 3] = d3 * d6 + d4 * d5;
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13 + 2] = d * d5 + d2 * d6;
        dArray[n13 + 3] = d * d6 - d2 * d5;
    }

    private void cftb1st(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d5 = dArray[n2] + dArray[n12];
        double d6 = -dArray[n2 + 1] - dArray[n12 + 1];
        double d7 = dArray[n2] - dArray[n12];
        double d8 = -dArray[n2 + 1] + dArray[n12 + 1];
        double d9 = dArray[n11] + dArray[n13];
        double d10 = dArray[n11 + 1] + dArray[n13 + 1];
        double d11 = dArray[n11] - dArray[n13];
        double d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d5 + d9;
        dArray[n2 + 1] = d6 - d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 + d10;
        dArray[n12] = d7 + d12;
        dArray[n12 + 1] = d8 + d11;
        dArray[n13] = d7 - d12;
        dArray[n13 + 1] = d8 - d11;
        double d13 = dArray2[n3 + 1];
        double d14 = dArray2[n3 + 2];
        double d15 = dArray2[n3 + 3];
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            d4 = d14 * (d16 + dArray2[n15]);
            d3 = d14 * (d17 + dArray2[n15 + 1]);
            d2 = d15 * (d18 + dArray2[n15 + 2]);
            d = d15 * (d19 + dArray2[n15 + 3]);
            d16 = dArray2[n15];
            d17 = dArray2[n15 + 1];
            d18 = dArray2[n15 + 2];
            d19 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d5 = dArray[n16] + dArray[n12];
            d6 = -dArray[n16 + 1] - dArray[n12 + 1];
            d7 = dArray[n16] - dArray[n2 + n9];
            d8 = -dArray[n16 + 1] + dArray[n12 + 1];
            double d20 = dArray[n16 + 2] + dArray[n12 + 2];
            double d21 = -dArray[n16 + 3] - dArray[n12 + 3];
            double d22 = dArray[n16 + 2] - dArray[n12 + 2];
            double d23 = -dArray[n16 + 3] + dArray[n12 + 3];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            double d24 = dArray[n11 + 2] + dArray[n13 + 2];
            double d25 = dArray[n11 + 3] + dArray[n13 + 3];
            double d26 = dArray[n11 + 2] - dArray[n13 + 2];
            double d27 = dArray[n11 + 3] - dArray[n13 + 3];
            dArray[n16] = d5 + d9;
            dArray[n16 + 1] = d6 - d10;
            dArray[n16 + 2] = d20 + d24;
            dArray[n16 + 3] = d21 - d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 + d10;
            dArray[n11 + 2] = d20 - d24;
            dArray[n11 + 3] = d21 + d25;
            d5 = d7 + d12;
            d6 = d8 + d11;
            dArray[n12] = d4 * d5 - d3 * d6;
            dArray[n12 + 1] = d4 * d6 + d3 * d5;
            d5 = d22 + d27;
            d6 = d23 + d26;
            dArray[n12 + 2] = d16 * d5 - d17 * d6;
            dArray[n12 + 3] = d16 * d6 + d17 * d5;
            d5 = d7 - d12;
            d6 = d8 - d11;
            dArray[n13] = d2 * d5 + d * d6;
            dArray[n13 + 1] = d2 * d6 - d * d5;
            d5 = d22 - d27;
            d6 = d23 - d26;
            dArray[n13 + 2] = d18 * d5 + d19 * d6;
            dArray[n13 + 3] = d18 * d6 - d19 * d5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d5 = dArray[n4] + dArray[n12];
            d6 = -dArray[n4 + 1] - dArray[n12 + 1];
            d7 = dArray[n4] - dArray[n12];
            d8 = -dArray[n4 + 1] + dArray[n12 + 1];
            d20 = dArray[n4 - 2] + dArray[n12 - 2];
            d21 = -dArray[n4 - 1] - dArray[n12 - 1];
            d22 = dArray[n4 - 2] - dArray[n12 - 2];
            d23 = -dArray[n4 - 1] + dArray[n12 - 1];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            d24 = dArray[n11 - 2] + dArray[n13 - 2];
            d25 = dArray[n11 - 1] + dArray[n13 - 1];
            d26 = dArray[n11 - 2] - dArray[n13 - 2];
            d27 = dArray[n11 - 1] - dArray[n13 - 1];
            dArray[n4] = d5 + d9;
            dArray[n4 + 1] = d6 - d10;
            dArray[n4 - 2] = d20 + d24;
            dArray[n4 - 1] = d21 - d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 + d10;
            dArray[n11 - 2] = d20 - d24;
            dArray[n11 - 1] = d21 + d25;
            d5 = d7 + d12;
            d6 = d8 + d11;
            dArray[n12] = d3 * d5 - d4 * d6;
            dArray[n12 + 1] = d3 * d6 + d4 * d5;
            d5 = d22 + d27;
            d6 = d23 + d26;
            dArray[n12 - 2] = d17 * d5 - d16 * d6;
            dArray[n12 - 1] = d17 * d6 + d16 * d5;
            d5 = d7 - d12;
            d6 = d8 - d11;
            dArray[n13] = d * d5 + d2 * d6;
            dArray[n13 + 1] = d * d6 - d2 * d5;
            d5 = d22 - d27;
            d6 = d23 - d26;
            dArray[n13 - 2] = d19 * d5 + d18 * d6;
            dArray[n13 - 1] = d19 * d6 - d18 * d5;
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d5 = dArray[n4 - 2] + dArray[n12 - 2];
        d6 = -dArray[n4 - 1] - dArray[n12 - 1];
        d7 = dArray[n4 - 2] - dArray[n12 - 2];
        d8 = -dArray[n4 - 1] + dArray[n12 - 1];
        d9 = dArray[n11 - 2] + dArray[n13 - 2];
        d10 = dArray[n11 - 1] + dArray[n13 - 1];
        d11 = dArray[n11 - 2] - dArray[n13 - 2];
        d12 = dArray[n11 - 1] - dArray[n13 - 1];
        dArray[n4 - 2] = d5 + d9;
        dArray[n4 - 1] = d6 - d10;
        dArray[n11 - 2] = d5 - d9;
        dArray[n11 - 1] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12 - 2] = d4 * d5 - d3 * d6;
        dArray[n12 - 1] = d4 * d6 + d3 * d5;
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13 - 2] = d2 * d5 + d * d6;
        dArray[n13 - 1] = d2 * d6 - d * d5;
        d5 = dArray[n4] + dArray[n12];
        d6 = -dArray[n4 + 1] - dArray[n12 + 1];
        d7 = dArray[n4] - dArray[n12];
        d8 = -dArray[n4 + 1] + dArray[n12 + 1];
        d9 = dArray[n11] + dArray[n13];
        d10 = dArray[n11 + 1] + dArray[n13 + 1];
        d11 = dArray[n11] - dArray[n13];
        d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d5 + d9;
        dArray[n4 + 1] = d6 - d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12] = d13 * (d5 - d6);
        dArray[n12 + 1] = d13 * (d6 + d5);
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13] = -d13 * (d5 + d6);
        dArray[n13 + 1] = -d13 * (d6 - d5);
        d5 = dArray[n4 + 2] + dArray[n12 + 2];
        d6 = -dArray[n4 + 3] - dArray[n12 + 3];
        d7 = dArray[n4 + 2] - dArray[n12 + 2];
        d8 = -dArray[n4 + 3] + dArray[n12 + 3];
        d9 = dArray[n11 + 2] + dArray[n13 + 2];
        d10 = dArray[n11 + 3] + dArray[n13 + 3];
        d11 = dArray[n11 + 2] - dArray[n13 + 2];
        d12 = dArray[n11 + 3] - dArray[n13 + 3];
        dArray[n4 + 2] = d5 + d9;
        dArray[n4 + 3] = d6 - d10;
        dArray[n11 + 2] = d5 - d9;
        dArray[n11 + 3] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12 + 2] = d3 * d5 - d4 * d6;
        dArray[n12 + 3] = d3 * d6 + d4 * d5;
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13 + 2] = d * d5 + d2 * d6;
        dArray[n13 + 3] = d * d6 - d2 * d5;
    }

    private void cftrec4_th(final int n, final double[] dArray, int n2, final int n3, final double[] dArray2) {
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        int n7 = n >> 1;
        if (n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n5 = 4;
            n6 = 1;
            n7 >>= 1;
        }
        Future[] futureArray = new Future[n5];
        final int n8 = n7;
        for (int i = 0; i < n5; ++i) {
            final int n9 = n2 + i * n7;
            futureArray[n4++] = i != n6 ? ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    int n6 = n9 + n8;
                    int n2 = n;
                    while (n2 > 512) {
                        DoubleFFT_1D.this.cftmdl1(n2 >>= 2, dArray, n6 - n2, dArray2, n3 - (n2 >> 1));
                    }
                    DoubleFFT_1D.this.cftleaf(n2, 1, dArray, n6 - n2, n3, dArray2);
                    int n32 = 0;
                    int n4 = n9 - n2;
                    for (int i = n8 - n2; i > 0; i -= n2) {
                        int n5 = DoubleFFT_1D.this.cfttree(n2, i, ++n32, dArray, n9, n3, dArray2);
                        DoubleFFT_1D.this.cftleaf(n2, n5, dArray, n4 + i, n3, dArray2);
                    }
                }
            }) : ConcurrencyUtils.submit((Runnable)new Runnable(){

                public void run() {
                    int n6 = n9 + n8;
                    int n2 = 1;
                    int n32 = n;
                    while (n32 > 512) {
                        n2 <<= 2;
                        DoubleFFT_1D.this.cftmdl2(n32 >>= 2, dArray, n6 - n32, dArray2, n3 - n32);
                    }
                    DoubleFFT_1D.this.cftleaf(n32, 0, dArray, n6 - n32, n3, dArray2);
                    n2 >>= 1;
                    int n4 = n9 - n32;
                    for (int i = n8 - n32; i > 0; i -= n32) {
                        int n5 = DoubleFFT_1D.this.cfttree(n32, i, ++n2, dArray, n9, n3, dArray2);
                        DoubleFFT_1D.this.cftleaf(n32, n5, dArray, n4 + i, n3, dArray2);
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion((Future[])futureArray);
    }

    private void cftrec4(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n;
        int n5 = n2 + n;
        while (n4 > 512) {
            this.cftmdl1(n4 >>= 2, dArray, n5 - n4, dArray2, n3 - (n4 >> 1));
        }
        this.cftleaf(n4, 1, dArray, n5 - n4, n3, dArray2);
        int n6 = 0;
        int n7 = n2 - n4;
        for (int i = n - n4; i > 0; i -= n4) {
            int n8 = this.cfttree(n4, i, ++n6, dArray, n2, n3, dArray2);
            this.cftleaf(n4, n8, dArray, n7 + i, n3, dArray2);
        }
    }

    private int cfttree(int n, int n2, int n3, double[] dArray, int n4, int n5, double[] dArray2) {
        int n6;
        int n7 = n4 - n;
        if ((n3 & 3) != 0) {
            n6 = n3 & 1;
            if (n6 != 0) {
                this.cftmdl1(n, dArray, n7 + n2, dArray2, n5 - (n >> 1));
            } else {
                this.cftmdl2(n, dArray, n7 + n2, dArray2, n5 - n);
            }
        } else {
            int n8 = n;
            int n9 = n3;
            while ((n9 & 3) == 0) {
                n8 <<= 2;
                n9 >>= 2;
            }
            n6 = n9 & 1;
            int n10 = n4 + n2;
            if (n6 != 0) {
                while (n8 > 128) {
                    this.cftmdl1(n8, dArray, n10 - n8, dArray2, n5 - (n8 >> 1));
                    n8 >>= 2;
                }
            } else {
                while (n8 > 128) {
                    this.cftmdl2(n8, dArray, n10 - n8, dArray2, n5 - n8);
                    n8 >>= 2;
                }
            }
        }
        return n6;
    }

    private void cftleaf(int n, int n2, double[] dArray, int n3, int n4, double[] dArray2) {
        if (n == 512) {
            this.cftmdl1(128, dArray, n3, dArray2, n4 - 64);
            this.cftf161(dArray, n3, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 32, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 64, dArray2, n4 - 8);
            this.cftf161(dArray, n3 + 96, dArray2, n4 - 8);
            this.cftmdl2(128, dArray, n3 + 128, dArray2, n4 - 128);
            this.cftf161(dArray, n3 + 128, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 160, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 192, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 224, dArray2, n4 - 32);
            this.cftmdl1(128, dArray, n3 + 256, dArray2, n4 - 64);
            this.cftf161(dArray, n3 + 256, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 288, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 320, dArray2, n4 - 8);
            this.cftf161(dArray, n3 + 352, dArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(128, dArray, n3 + 384, dArray2, n4 - 64);
                this.cftf161(dArray, n3 + 480, dArray2, n4 - 8);
            } else {
                this.cftmdl2(128, dArray, n3 + 384, dArray2, n4 - 128);
                this.cftf162(dArray, n3 + 480, dArray2, n4 - 32);
            }
            this.cftf161(dArray, n3 + 384, dArray2, n4 - 8);
            this.cftf162(dArray, n3 + 416, dArray2, n4 - 32);
            this.cftf161(dArray, n3 + 448, dArray2, n4 - 8);
        } else {
            this.cftmdl1(64, dArray, n3, dArray2, n4 - 32);
            this.cftf081(dArray, n3, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 16, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 32, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 48, dArray2, n4 - 8);
            this.cftmdl2(64, dArray, n3 + 64, dArray2, n4 - 64);
            this.cftf081(dArray, n3 + 64, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 80, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 96, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 112, dArray2, n4 - 8);
            this.cftmdl1(64, dArray, n3 + 128, dArray2, n4 - 32);
            this.cftf081(dArray, n3 + 128, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 144, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 160, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 176, dArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(64, dArray, n3 + 192, dArray2, n4 - 32);
                this.cftf081(dArray, n3 + 240, dArray2, n4 - 8);
            } else {
                this.cftmdl2(64, dArray, n3 + 192, dArray2, n4 - 64);
                this.cftf082(dArray, n3 + 240, dArray2, n4 - 8);
            }
            this.cftf081(dArray, n3 + 192, dArray2, n4 - 8);
            this.cftf082(dArray, n3 + 208, dArray2, n4 - 8);
            this.cftf081(dArray, n3 + 224, dArray2, n4 - 8);
        }
    }

    private void cftmdl1(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d = dArray[n2] + dArray[n12];
        double d2 = dArray[n2 + 1] + dArray[n12 + 1];
        double d3 = dArray[n2] - dArray[n12];
        double d4 = dArray[n2 + 1] - dArray[n12 + 1];
        double d5 = dArray[n11] + dArray[n13];
        double d6 = dArray[n11 + 1] + dArray[n13 + 1];
        double d7 = dArray[n11] - dArray[n13];
        double d8 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d + d5;
        dArray[n2 + 1] = d2 + d6;
        dArray[n11] = d - d5;
        dArray[n11 + 1] = d2 - d6;
        dArray[n12] = d3 - d8;
        dArray[n12 + 1] = d4 + d7;
        dArray[n13] = d3 + d8;
        dArray[n13 + 1] = d4 - d7;
        double d9 = dArray2[n3 + 1];
        int n14 = 0;
        for (int i = 2; i < n7; i += 2) {
            int n15 = n3 + (n14 += 4);
            double d10 = dArray2[n15];
            double d11 = dArray2[n15 + 1];
            double d12 = dArray2[n15 + 2];
            double d13 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d = dArray[n16] + dArray[n12];
            d2 = dArray[n16 + 1] + dArray[n12 + 1];
            d3 = dArray[n16] - dArray[n12];
            d4 = dArray[n16 + 1] - dArray[n12 + 1];
            d5 = dArray[n11] + dArray[n13];
            d6 = dArray[n11 + 1] + dArray[n13 + 1];
            d7 = dArray[n11] - dArray[n13];
            d8 = dArray[n11 + 1] - dArray[n13 + 1];
            dArray[n16] = d + d5;
            dArray[n16 + 1] = d2 + d6;
            dArray[n11] = d - d5;
            dArray[n11 + 1] = d2 - d6;
            d = d3 - d8;
            d2 = d4 + d7;
            dArray[n12] = d10 * d - d11 * d2;
            dArray[n12 + 1] = d10 * d2 + d11 * d;
            d = d3 + d8;
            d2 = d4 - d7;
            dArray[n13] = d12 * d + d13 * d2;
            dArray[n13 + 1] = d12 * d2 - d13 * d;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d = dArray[n4] + dArray[n12];
            d2 = dArray[n4 + 1] + dArray[n12 + 1];
            d3 = dArray[n4] - dArray[n12];
            d4 = dArray[n4 + 1] - dArray[n12 + 1];
            d5 = dArray[n11] + dArray[n13];
            d6 = dArray[n11 + 1] + dArray[n13 + 1];
            d7 = dArray[n11] - dArray[n13];
            d8 = dArray[n11 + 1] - dArray[n13 + 1];
            dArray[n4] = d + d5;
            dArray[n4 + 1] = d2 + d6;
            dArray[n11] = d - d5;
            dArray[n11 + 1] = d2 - d6;
            d = d3 - d8;
            d2 = d4 + d7;
            dArray[n12] = d11 * d - d10 * d2;
            dArray[n12 + 1] = d11 * d2 + d10 * d;
            d = d3 + d8;
            d2 = d4 - d7;
            dArray[n13] = d13 * d + d12 * d2;
            dArray[n13 + 1] = d13 * d2 - d12 * d;
        }
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d = dArray[n4] + dArray[n12];
        d2 = dArray[n4 + 1] + dArray[n12 + 1];
        d3 = dArray[n4] - dArray[n12];
        d4 = dArray[n4 + 1] - dArray[n12 + 1];
        d5 = dArray[n11] + dArray[n13];
        d6 = dArray[n11 + 1] + dArray[n13 + 1];
        d7 = dArray[n11] - dArray[n13];
        d8 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d + d5;
        dArray[n4 + 1] = d2 + d6;
        dArray[n11] = d - d5;
        dArray[n11 + 1] = d2 - d6;
        d = d3 - d8;
        d2 = d4 + d7;
        dArray[n12] = d9 * (d - d2);
        dArray[n12 + 1] = d9 * (d2 + d);
        d = d3 + d8;
        d2 = d4 - d7;
        dArray[n13] = -d9 * (d + d2);
        dArray[n13 + 1] = -d9 * (d2 - d);
    }

    private void cftmdl2(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6 = n >> 3;
        int n7 = 2 * n6;
        double d5 = dArray2[n3 + 1];
        int n8 = n7;
        int n9 = n8 + n7;
        int n10 = n9 + n7;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d6 = dArray[n2] - dArray[n12 + 1];
        double d7 = dArray[n2 + 1] + dArray[n12];
        double d8 = dArray[n2] + dArray[n12 + 1];
        double d9 = dArray[n2 + 1] - dArray[n12];
        double d10 = dArray[n11] - dArray[n13 + 1];
        double d11 = dArray[n11 + 1] + dArray[n13];
        double d12 = dArray[n11] + dArray[n13 + 1];
        double d13 = dArray[n11 + 1] - dArray[n13];
        double d14 = d5 * (d10 - d11);
        double d15 = d5 * (d11 + d10);
        dArray[n2] = d6 + d14;
        dArray[n2 + 1] = d7 + d15;
        dArray[n11] = d6 - d14;
        dArray[n11 + 1] = d7 - d15;
        d14 = d5 * (d12 - d13);
        d15 = d5 * (d13 + d12);
        dArray[n12] = d8 - d15;
        dArray[n12 + 1] = d9 + d14;
        dArray[n13] = d8 + d15;
        dArray[n13 + 1] = d9 - d14;
        int n14 = 0;
        int n15 = 2 * n7;
        for (int i = 2; i < n6; i += 2) {
            int n16 = n3 + (n14 += 4);
            d4 = dArray2[n16];
            d3 = dArray2[n16 + 1];
            double d16 = dArray2[n16 + 2];
            double d17 = dArray2[n16 + 3];
            int n17 = n3 + (n15 -= 4);
            double d18 = dArray2[n17];
            double d19 = dArray2[n17 + 1];
            double d20 = dArray2[n17 + 2];
            double d21 = dArray2[n17 + 3];
            n8 = i + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n18 = n2 + i;
            d6 = dArray[n18] - dArray[n12 + 1];
            d7 = dArray[n18 + 1] + dArray[n12];
            d8 = dArray[n18] + dArray[n12 + 1];
            d9 = dArray[n18 + 1] - dArray[n12];
            d10 = dArray[n11] - dArray[n13 + 1];
            d11 = dArray[n11 + 1] + dArray[n13];
            d12 = dArray[n11] + dArray[n13 + 1];
            d13 = dArray[n11 + 1] - dArray[n13];
            d14 = d4 * d6 - d3 * d7;
            d15 = d4 * d7 + d3 * d6;
            d2 = d19 * d10 - d18 * d11;
            d = d19 * d11 + d18 * d10;
            dArray[n18] = d14 + d2;
            dArray[n18 + 1] = d15 + d;
            dArray[n11] = d14 - d2;
            dArray[n11 + 1] = d15 - d;
            d14 = d16 * d8 + d17 * d9;
            d15 = d16 * d9 - d17 * d8;
            d2 = d21 * d12 + d20 * d13;
            d = d21 * d13 - d20 * d12;
            dArray[n12] = d14 + d2;
            dArray[n12 + 1] = d15 + d;
            dArray[n13] = d14 - d2;
            dArray[n13 + 1] = d15 - d;
            n5 = n7 - i;
            n8 = n5 + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d6 = dArray[n4] - dArray[n12 + 1];
            d7 = dArray[n4 + 1] + dArray[n12];
            d8 = dArray[n4] + dArray[n12 + 1];
            d9 = dArray[n4 + 1] - dArray[n12];
            d10 = dArray[n11] - dArray[n13 + 1];
            d11 = dArray[n11 + 1] + dArray[n13];
            d12 = dArray[n11] + dArray[n13 + 1];
            d13 = dArray[n11 + 1] - dArray[n13];
            d14 = d18 * d6 - d19 * d7;
            d15 = d18 * d7 + d19 * d6;
            d2 = d3 * d10 - d4 * d11;
            d = d3 * d11 + d4 * d10;
            dArray[n4] = d14 + d2;
            dArray[n4 + 1] = d15 + d;
            dArray[n11] = d14 - d2;
            dArray[n11 + 1] = d15 - d;
            d14 = d20 * d8 + d21 * d9;
            d15 = d20 * d9 - d21 * d8;
            d2 = d17 * d12 + d16 * d13;
            d = d17 * d13 - d16 * d12;
            dArray[n12] = d14 + d2;
            dArray[n12 + 1] = d15 + d;
            dArray[n13] = d14 - d2;
            dArray[n13 + 1] = d15 - d;
        }
        d4 = dArray2[n3 + n7];
        d3 = dArray2[n3 + n7 + 1];
        n5 = n6;
        n8 = n5 + n7;
        n9 = n8 + n7;
        n10 = n9 + n7;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d6 = dArray[n4] - dArray[n12 + 1];
        d7 = dArray[n4 + 1] + dArray[n12];
        d8 = dArray[n4] + dArray[n12 + 1];
        d9 = dArray[n4 + 1] - dArray[n12];
        d10 = dArray[n11] - dArray[n13 + 1];
        d11 = dArray[n11 + 1] + dArray[n13];
        d12 = dArray[n11] + dArray[n13 + 1];
        d13 = dArray[n11 + 1] - dArray[n13];
        d14 = d4 * d6 - d3 * d7;
        d15 = d4 * d7 + d3 * d6;
        d2 = d3 * d10 - d4 * d11;
        d = d3 * d11 + d4 * d10;
        dArray[n4] = d14 + d2;
        dArray[n4 + 1] = d15 + d;
        dArray[n11] = d14 - d2;
        dArray[n11 + 1] = d15 - d;
        d14 = d3 * d8 - d4 * d9;
        d15 = d3 * d9 + d4 * d8;
        d2 = d4 * d12 - d3 * d13;
        d = d4 * d13 + d3 * d12;
        dArray[n12] = d14 - d2;
        dArray[n12 + 1] = d15 - d;
        dArray[n13] = d14 + d2;
        dArray[n13 + 1] = d15 + d;
    }

    private void cftfx41(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        if (n == 128) {
            this.cftf161(dArray, n2, dArray2, n3 - 8);
            this.cftf162(dArray, n2 + 32, dArray2, n3 - 32);
            this.cftf161(dArray, n2 + 64, dArray2, n3 - 8);
            this.cftf161(dArray, n2 + 96, dArray2, n3 - 8);
        } else {
            this.cftf081(dArray, n2, dArray2, n3 - 8);
            this.cftf082(dArray, n2 + 16, dArray2, n3 - 8);
            this.cftf081(dArray, n2 + 32, dArray2, n3 - 8);
            this.cftf081(dArray, n2 + 48, dArray2, n3 - 8);
        }
    }

    private void cftf161(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 2];
        double d3 = dArray2[n2 + 3];
        double d4 = dArray[n] + dArray[n + 16];
        double d5 = dArray[n + 1] + dArray[n + 17];
        double d6 = dArray[n] - dArray[n + 16];
        double d7 = dArray[n + 1] - dArray[n + 17];
        double d8 = dArray[n + 8] + dArray[n + 24];
        double d9 = dArray[n + 9] + dArray[n + 25];
        double d10 = dArray[n + 8] - dArray[n + 24];
        double d11 = dArray[n + 9] - dArray[n + 25];
        double d12 = d4 + d8;
        double d13 = d5 + d9;
        double d14 = d4 - d8;
        double d15 = d5 - d9;
        double d16 = d6 - d11;
        double d17 = d7 + d10;
        double d18 = d6 + d11;
        double d19 = d7 - d10;
        d4 = dArray[n + 2] + dArray[n + 18];
        d5 = dArray[n + 3] + dArray[n + 19];
        d6 = dArray[n + 2] - dArray[n + 18];
        d7 = dArray[n + 3] - dArray[n + 19];
        d8 = dArray[n + 10] + dArray[n + 26];
        d9 = dArray[n + 11] + dArray[n + 27];
        d10 = dArray[n + 10] - dArray[n + 26];
        d11 = dArray[n + 11] - dArray[n + 27];
        double d20 = d4 + d8;
        double d21 = d5 + d9;
        double d22 = d4 - d8;
        double d23 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d24 = d2 * d4 - d3 * d5;
        double d25 = d2 * d5 + d3 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d26 = d3 * d4 - d2 * d5;
        double d27 = d3 * d5 + d2 * d4;
        d4 = dArray[n + 4] + dArray[n + 20];
        d5 = dArray[n + 5] + dArray[n + 21];
        d6 = dArray[n + 4] - dArray[n + 20];
        d7 = dArray[n + 5] - dArray[n + 21];
        d8 = dArray[n + 12] + dArray[n + 28];
        d9 = dArray[n + 13] + dArray[n + 29];
        d10 = dArray[n + 12] - dArray[n + 28];
        d11 = dArray[n + 13] - dArray[n + 29];
        double d28 = d4 + d8;
        double d29 = d5 + d9;
        double d30 = d4 - d8;
        double d31 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d32 = d * (d4 - d5);
        double d33 = d * (d5 + d4);
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d34 = d * (d4 + d5);
        double d35 = d * (d5 - d4);
        d4 = dArray[n + 6] + dArray[n + 22];
        d5 = dArray[n + 7] + dArray[n + 23];
        d6 = dArray[n + 6] - dArray[n + 22];
        d7 = dArray[n + 7] - dArray[n + 23];
        d8 = dArray[n + 14] + dArray[n + 30];
        d9 = dArray[n + 15] + dArray[n + 31];
        d10 = dArray[n + 14] - dArray[n + 30];
        d11 = dArray[n + 15] - dArray[n + 31];
        double d36 = d4 + d8;
        double d37 = d5 + d9;
        double d38 = d4 - d8;
        double d39 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d40 = d3 * d4 - d2 * d5;
        double d41 = d3 * d5 + d2 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d42 = d2 * d4 - d3 * d5;
        double d43 = d2 * d5 + d3 * d4;
        d4 = d18 - d34;
        d5 = d19 - d35;
        d6 = d18 + d34;
        d7 = d19 + d35;
        d8 = d26 - d42;
        d9 = d27 - d43;
        d10 = d26 + d42;
        d11 = d27 + d43;
        dArray[n + 24] = d4 + d8;
        dArray[n + 25] = d5 + d9;
        dArray[n + 26] = d4 - d8;
        dArray[n + 27] = d5 - d9;
        dArray[n + 28] = d6 - d11;
        dArray[n + 29] = d7 + d10;
        dArray[n + 30] = d6 + d11;
        dArray[n + 31] = d7 - d10;
        d4 = d16 + d32;
        d5 = d17 + d33;
        d6 = d16 - d32;
        d7 = d17 - d33;
        d8 = d24 + d40;
        d9 = d25 + d41;
        d10 = d24 - d40;
        d11 = d25 - d41;
        dArray[n + 16] = d4 + d8;
        dArray[n + 17] = d5 + d9;
        dArray[n + 18] = d4 - d8;
        dArray[n + 19] = d5 - d9;
        dArray[n + 20] = d6 - d11;
        dArray[n + 21] = d7 + d10;
        dArray[n + 22] = d6 + d11;
        dArray[n + 23] = d7 - d10;
        d4 = d22 - d39;
        d5 = d23 + d38;
        d8 = d * (d4 - d5);
        d9 = d * (d5 + d4);
        d4 = d22 + d39;
        d5 = d23 - d38;
        d10 = d * (d4 - d5);
        d11 = d * (d5 + d4);
        d4 = d14 - d31;
        d5 = d15 + d30;
        d6 = d14 + d31;
        d7 = d15 - d30;
        dArray[n + 8] = d4 + d8;
        dArray[n + 9] = d5 + d9;
        dArray[n + 10] = d4 - d8;
        dArray[n + 11] = d5 - d9;
        dArray[n + 12] = d6 - d11;
        dArray[n + 13] = d7 + d10;
        dArray[n + 14] = d6 + d11;
        dArray[n + 15] = d7 - d10;
        d4 = d12 + d28;
        d5 = d13 + d29;
        d6 = d12 - d28;
        d7 = d13 - d29;
        d8 = d20 + d36;
        d9 = d21 + d37;
        d10 = d20 - d36;
        d11 = d21 - d37;
        dArray[n] = d4 + d8;
        dArray[n + 1] = d5 + d9;
        dArray[n + 2] = d4 - d8;
        dArray[n + 3] = d5 - d9;
        dArray[n + 4] = d6 - d11;
        dArray[n + 5] = d7 + d10;
        dArray[n + 6] = d6 + d11;
        dArray[n + 7] = d7 - d10;
    }

    private void cftf162(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 4];
        double d3 = dArray2[n2 + 5];
        double d4 = dArray2[n2 + 6];
        double d5 = -dArray2[n2 + 7];
        double d6 = dArray2[n2 + 8];
        double d7 = dArray2[n2 + 9];
        double d8 = dArray[n] - dArray[n + 17];
        double d9 = dArray[n + 1] + dArray[n + 16];
        double d10 = dArray[n + 8] - dArray[n + 25];
        double d11 = dArray[n + 9] + dArray[n + 24];
        double d12 = d * (d10 - d11);
        double d13 = d * (d11 + d10);
        double d14 = d8 + d12;
        double d15 = d9 + d13;
        double d16 = d8 - d12;
        double d17 = d9 - d13;
        d8 = dArray[n] + dArray[n + 17];
        d9 = dArray[n + 1] - dArray[n + 16];
        d10 = dArray[n + 8] + dArray[n + 25];
        d11 = dArray[n + 9] - dArray[n + 24];
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        double d18 = d8 - d13;
        double d19 = d9 + d12;
        double d20 = d8 + d13;
        double d21 = d9 - d12;
        d10 = dArray[n + 2] - dArray[n + 19];
        d11 = dArray[n + 3] + dArray[n + 18];
        d8 = d2 * d10 - d3 * d11;
        d9 = d2 * d11 + d3 * d10;
        d10 = dArray[n + 10] - dArray[n + 27];
        d11 = dArray[n + 11] + dArray[n + 26];
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d22 = d8 + d12;
        double d23 = d9 + d13;
        double d24 = d8 - d12;
        double d25 = d9 - d13;
        d10 = dArray[n + 2] + dArray[n + 19];
        d11 = dArray[n + 3] - dArray[n + 18];
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = dArray[n + 10] + dArray[n + 27];
        d11 = dArray[n + 11] - dArray[n + 26];
        d12 = d2 * d10 + d3 * d11;
        d13 = d2 * d11 - d3 * d10;
        double d26 = d8 - d12;
        double d27 = d9 - d13;
        double d28 = d8 + d12;
        double d29 = d9 + d13;
        d10 = dArray[n + 4] - dArray[n + 21];
        d11 = dArray[n + 5] + dArray[n + 20];
        d8 = d6 * d10 - d7 * d11;
        d9 = d6 * d11 + d7 * d10;
        d10 = dArray[n + 12] - dArray[n + 29];
        d11 = dArray[n + 13] + dArray[n + 28];
        d12 = d7 * d10 - d6 * d11;
        d13 = d7 * d11 + d6 * d10;
        double d30 = d8 + d12;
        double d31 = d9 + d13;
        double d32 = d8 - d12;
        double d33 = d9 - d13;
        d10 = dArray[n + 4] + dArray[n + 21];
        d11 = dArray[n + 5] - dArray[n + 20];
        d8 = d7 * d10 - d6 * d11;
        d9 = d7 * d11 + d6 * d10;
        d10 = dArray[n + 12] + dArray[n + 29];
        d11 = dArray[n + 13] - dArray[n + 28];
        d12 = d6 * d10 - d7 * d11;
        d13 = d6 * d11 + d7 * d10;
        double d34 = d8 - d12;
        double d35 = d9 - d13;
        double d36 = d8 + d12;
        double d37 = d9 + d13;
        d10 = dArray[n + 6] - dArray[n + 23];
        d11 = dArray[n + 7] + dArray[n + 22];
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = dArray[n + 14] - dArray[n + 31];
        d11 = dArray[n + 15] + dArray[n + 30];
        d12 = d3 * d10 - d2 * d11;
        d13 = d3 * d11 + d2 * d10;
        double d38 = d8 + d12;
        double d39 = d9 + d13;
        double d40 = d8 - d12;
        double d41 = d9 - d13;
        d10 = dArray[n + 6] + dArray[n + 23];
        d11 = dArray[n + 7] - dArray[n + 22];
        d8 = d3 * d10 + d2 * d11;
        d9 = d3 * d11 - d2 * d10;
        d10 = dArray[n + 14] + dArray[n + 31];
        d11 = dArray[n + 15] - dArray[n + 30];
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d42 = d8 + d12;
        double d43 = d9 + d13;
        double d44 = d8 - d12;
        double d45 = d9 - d13;
        d8 = d14 + d30;
        d9 = d15 + d31;
        d12 = d22 + d38;
        d13 = d23 + d39;
        dArray[n] = d8 + d12;
        dArray[n + 1] = d9 + d13;
        dArray[n + 2] = d8 - d12;
        dArray[n + 3] = d9 - d13;
        d8 = d14 - d30;
        d9 = d15 - d31;
        d12 = d22 - d38;
        d13 = d23 - d39;
        dArray[n + 4] = d8 - d13;
        dArray[n + 5] = d9 + d12;
        dArray[n + 6] = d8 + d13;
        dArray[n + 7] = d9 - d12;
        d8 = d16 - d33;
        d9 = d17 + d32;
        d10 = d24 - d41;
        d11 = d25 + d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 8] = d8 + d12;
        dArray[n + 9] = d9 + d13;
        dArray[n + 10] = d8 - d12;
        dArray[n + 11] = d9 - d13;
        d8 = d16 + d33;
        d9 = d17 - d32;
        d10 = d24 + d41;
        d11 = d25 - d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 12] = d8 - d13;
        dArray[n + 13] = d9 + d12;
        dArray[n + 14] = d8 + d13;
        dArray[n + 15] = d9 - d12;
        d8 = d18 + d34;
        d9 = d19 + d35;
        d12 = d26 - d42;
        d13 = d27 - d43;
        dArray[n + 16] = d8 + d12;
        dArray[n + 17] = d9 + d13;
        dArray[n + 18] = d8 - d12;
        dArray[n + 19] = d9 - d13;
        d8 = d18 - d34;
        d9 = d19 - d35;
        d12 = d26 + d42;
        d13 = d27 + d43;
        dArray[n + 20] = d8 - d13;
        dArray[n + 21] = d9 + d12;
        dArray[n + 22] = d8 + d13;
        dArray[n + 23] = d9 - d12;
        d8 = d20 - d37;
        d9 = d21 + d36;
        d10 = d28 + d45;
        d11 = d29 - d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 24] = d8 + d12;
        dArray[n + 25] = d9 + d13;
        dArray[n + 26] = d8 - d12;
        dArray[n + 27] = d9 - d13;
        d8 = d20 + d37;
        d9 = d21 - d36;
        d10 = d28 - d45;
        d11 = d29 + d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 28] = d8 - d13;
        dArray[n + 29] = d9 + d12;
        dArray[n + 30] = d8 + d13;
        dArray[n + 31] = d9 - d12;
    }

    private void cftf081(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray[n] + dArray[n + 8];
        double d3 = dArray[n + 1] + dArray[n + 9];
        double d4 = dArray[n] - dArray[n + 8];
        double d5 = dArray[n + 1] - dArray[n + 9];
        double d6 = dArray[n + 4] + dArray[n + 12];
        double d7 = dArray[n + 5] + dArray[n + 13];
        double d8 = dArray[n + 4] - dArray[n + 12];
        double d9 = dArray[n + 5] - dArray[n + 13];
        double d10 = d2 + d6;
        double d11 = d3 + d7;
        double d12 = d2 - d6;
        double d13 = d3 - d7;
        double d14 = d4 - d9;
        double d15 = d5 + d8;
        double d16 = d4 + d9;
        double d17 = d5 - d8;
        d2 = dArray[n + 2] + dArray[n + 10];
        d3 = dArray[n + 3] + dArray[n + 11];
        d4 = dArray[n + 2] - dArray[n + 10];
        d5 = dArray[n + 3] - dArray[n + 11];
        d6 = dArray[n + 6] + dArray[n + 14];
        d7 = dArray[n + 7] + dArray[n + 15];
        d8 = dArray[n + 6] - dArray[n + 14];
        d9 = dArray[n + 7] - dArray[n + 15];
        double d18 = d2 + d6;
        double d19 = d3 + d7;
        double d20 = d2 - d6;
        double d21 = d3 - d7;
        d2 = d4 - d9;
        d3 = d5 + d8;
        d6 = d4 + d9;
        d7 = d5 - d8;
        double d22 = d * (d2 - d3);
        double d23 = d * (d2 + d3);
        double d24 = d * (d6 - d7);
        double d25 = d * (d6 + d7);
        dArray[n + 8] = d14 + d22;
        dArray[n + 9] = d15 + d23;
        dArray[n + 10] = d14 - d22;
        dArray[n + 11] = d15 - d23;
        dArray[n + 12] = d16 - d25;
        dArray[n + 13] = d17 + d24;
        dArray[n + 14] = d16 + d25;
        dArray[n + 15] = d17 - d24;
        dArray[n] = d10 + d18;
        dArray[n + 1] = d11 + d19;
        dArray[n + 2] = d10 - d18;
        dArray[n + 3] = d11 - d19;
        dArray[n + 4] = d12 - d21;
        dArray[n + 5] = d13 + d20;
        dArray[n + 6] = d12 + d21;
        dArray[n + 7] = d13 - d20;
    }

    private void cftf082(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 2];
        double d3 = dArray2[n2 + 3];
        double d4 = dArray[n] - dArray[n + 9];
        double d5 = dArray[n + 1] + dArray[n + 8];
        double d6 = dArray[n] + dArray[n + 9];
        double d7 = dArray[n + 1] - dArray[n + 8];
        double d8 = dArray[n + 4] - dArray[n + 13];
        double d9 = dArray[n + 5] + dArray[n + 12];
        double d10 = d * (d8 - d9);
        double d11 = d * (d9 + d8);
        d8 = dArray[n + 4] + dArray[n + 13];
        d9 = dArray[n + 5] - dArray[n + 12];
        double d12 = d * (d8 - d9);
        double d13 = d * (d9 + d8);
        d8 = dArray[n + 2] - dArray[n + 11];
        d9 = dArray[n + 3] + dArray[n + 10];
        double d14 = d2 * d8 - d3 * d9;
        double d15 = d2 * d9 + d3 * d8;
        d8 = dArray[n + 2] + dArray[n + 11];
        d9 = dArray[n + 3] - dArray[n + 10];
        double d16 = d3 * d8 - d2 * d9;
        double d17 = d3 * d9 + d2 * d8;
        d8 = dArray[n + 6] - dArray[n + 15];
        d9 = dArray[n + 7] + dArray[n + 14];
        double d18 = d3 * d8 - d2 * d9;
        double d19 = d3 * d9 + d2 * d8;
        d8 = dArray[n + 6] + dArray[n + 15];
        d9 = dArray[n + 7] - dArray[n + 14];
        double d20 = d2 * d8 - d3 * d9;
        double d21 = d2 * d9 + d3 * d8;
        d8 = d4 + d10;
        d9 = d5 + d11;
        double d22 = d14 + d18;
        double d23 = d15 + d19;
        dArray[n] = d8 + d22;
        dArray[n + 1] = d9 + d23;
        dArray[n + 2] = d8 - d22;
        dArray[n + 3] = d9 - d23;
        d8 = d4 - d10;
        d9 = d5 - d11;
        d22 = d14 - d18;
        d23 = d15 - d19;
        dArray[n + 4] = d8 - d23;
        dArray[n + 5] = d9 + d22;
        dArray[n + 6] = d8 + d23;
        dArray[n + 7] = d9 - d22;
        d8 = d6 - d13;
        d9 = d7 + d12;
        d22 = d16 - d20;
        d23 = d17 - d21;
        dArray[n + 8] = d8 + d22;
        dArray[n + 9] = d9 + d23;
        dArray[n + 10] = d8 - d22;
        dArray[n + 11] = d9 - d23;
        d8 = d6 + d13;
        d9 = d7 - d12;
        d22 = d16 + d20;
        d23 = d17 + d21;
        dArray[n + 12] = d8 - d23;
        dArray[n + 13] = d9 + d22;
        dArray[n + 14] = d8 + d23;
        dArray[n + 15] = d9 - d22;
    }

    private void cftf040(double[] dArray, int n) {
        double d = dArray[n] + dArray[n + 4];
        double d2 = dArray[n + 1] + dArray[n + 5];
        double d3 = dArray[n] - dArray[n + 4];
        double d4 = dArray[n + 1] - dArray[n + 5];
        double d5 = dArray[n + 2] + dArray[n + 6];
        double d6 = dArray[n + 3] + dArray[n + 7];
        double d7 = dArray[n + 2] - dArray[n + 6];
        double d8 = dArray[n + 3] - dArray[n + 7];
        dArray[n] = d + d5;
        dArray[n + 1] = d2 + d6;
        dArray[n + 2] = d3 - d8;
        dArray[n + 3] = d4 + d7;
        dArray[n + 4] = d - d5;
        dArray[n + 5] = d2 - d6;
        dArray[n + 6] = d3 + d8;
        dArray[n + 7] = d4 - d7;
    }

    private void cftb040(double[] dArray, int n) {
        double d = dArray[n] + dArray[n + 4];
        double d2 = dArray[n + 1] + dArray[n + 5];
        double d3 = dArray[n] - dArray[n + 4];
        double d4 = dArray[n + 1] - dArray[n + 5];
        double d5 = dArray[n + 2] + dArray[n + 6];
        double d6 = dArray[n + 3] + dArray[n + 7];
        double d7 = dArray[n + 2] - dArray[n + 6];
        double d8 = dArray[n + 3] - dArray[n + 7];
        dArray[n] = d + d5;
        dArray[n + 1] = d2 + d6;
        dArray[n + 2] = d3 + d8;
        dArray[n + 3] = d4 - d7;
        dArray[n + 4] = d - d5;
        dArray[n + 5] = d2 - d6;
        dArray[n + 6] = d3 - d8;
        dArray[n + 7] = d4 + d7;
    }

    private void cftx020(double[] dArray, int n) {
        double d = dArray[n] - dArray[n + 2];
        double d2 = -dArray[n + 1] + dArray[n + 3];
        int n2 = n;
        dArray[n2] = dArray[n2] + dArray[n + 2];
        int n3 = n + 1;
        dArray[n3] = dArray[n3] + dArray[n + 3];
        dArray[n + 2] = d;
        dArray[n + 3] = d2;
    }

    private void cftxb020(double[] dArray, int n) {
        double d = dArray[n] - dArray[n + 2];
        double d2 = dArray[n + 1] - dArray[n + 3];
        int n2 = n;
        dArray[n2] = dArray[n2] + dArray[n + 2];
        int n3 = n + 1;
        dArray[n3] = dArray[n3] + dArray[n + 3];
        dArray[n + 2] = d;
        dArray[n + 3] = d2;
    }

    private void cftxc020(double[] dArray, int n) {
        double d = dArray[n] - dArray[n + 2];
        double d2 = dArray[n + 1] + dArray[n + 3];
        int n2 = n;
        dArray[n2] = dArray[n2] + dArray[n + 2];
        int n3 = n + 1;
        dArray[n3] = dArray[n3] - dArray[n + 3];
        dArray[n + 2] = d;
        dArray[n + 3] = d2;
    }

    private void rftfsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            double d = 0.5 - dArray2[n4 + n3 - (n7 += n6)];
            double d2 = dArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            double d3 = dArray[n9] - dArray[n10];
            double d4 = dArray[n9 + 1] + dArray[n10 + 1];
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            int n11 = n9;
            dArray[n11] = dArray[n11] - d5;
            dArray[n9 + 1] = d6 - dArray[n9 + 1];
            int n12 = n10;
            dArray[n12] = dArray[n12] + d5;
            dArray[n10 + 1] = d6 - dArray[n10 + 1];
        }
        dArray[n2 + n5 + 1] = -dArray[n2 + n5 + 1];
    }

    private void rftbsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            double d = 0.5 - dArray2[n4 + n3 - (n7 += n6)];
            double d2 = dArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            double d3 = dArray[n9] - dArray[n10];
            double d4 = dArray[n9 + 1] + dArray[n10 + 1];
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            int n11 = n9;
            dArray[n11] = dArray[n11] - d5;
            int n12 = n9 + 1;
            dArray[n12] = dArray[n12] - d6;
            int n13 = n10;
            dArray[n13] = dArray[n13] + d5;
            int n14 = n10 + 1;
            dArray[n14] = dArray[n14] - d6;
        }
    }

    private void scale(double d, final double[] dArray, int n, boolean bl) {
        final double d2 = 1.0 / d;
        int n2 = bl ? 2 * this.n : this.n;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (int i = 0; i < n3; ++i) {
                final int n5 = n + i * n4;
                final int n6 = i == n3 - 1 ? n + n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int n = n5;
                        while (n < n6) {
                            int n2 = n++;
                            dArray[n2] = dArray[n2] * d2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n7 = n;
            while (n7 < n + n2) {
                int n8 = n7++;
                dArray[n8] = dArray[n8] * d2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Plans {
        SPLIT_RADIX,
        MIXED_RADIX,
        BLUESTEIN;

    }
}

