/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatFFT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65530, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static int[] sizes2D2 = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static int[] sizes3D2 = new int[]{2, 4, 8, 16, 32, 64, 128};
    private static double eps = Math.pow(2.0, -23.0);

    private AccuracyCheckFloatFFT() {
    }

    public static void checkAccuracyComplexFFT_1D() {
        System.out.println("Checking accuracy of 1D complex FFT...");
        for (int i = 0; i < sizes1D.length; ++i) {
            FloatFFT_1D floatFFT_1D = new FloatFFT_1D(sizes1D[i]);
            double d = 0.0;
            float[] fArray = new float[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D((int)(2 * sizes1D[i]), (float[])fArray);
            float[] fArray2 = new float[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D((int)(2 * sizes1D[i]), (float[])fArray2);
            floatFFT_1D.complexForward(fArray);
            floatFFT_1D.complexInverse(fArray, true);
            d = AccuracyCheckFloatFFT.computeRMSE(fArray, fArray2);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            }
            fArray = null;
            fArray2 = null;
            floatFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_2D() {
        Object object;
        Object object2;
        double d;
        FloatFFT_2D floatFFT_2D;
        int n;
        System.out.println("Checking accuracy of 2D complex FFT (float[] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            floatFFT_2D = new FloatFFT_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new float[2 * sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)(2 * sizes2D[n]), (float[])object2);
            object = new float[2 * sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)(2 * sizes2D[n]), (float[])object);
            floatFFT_2D.complexForward((float[])object2);
            floatFFT_2D.complexInverse((float[])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D complex FFT (float[][] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            floatFFT_2D = new FloatFFT_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new float[sizes2D[n]][2 * sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)(2 * sizes2D[n]), (float[][])object2);
            object = new float[sizes2D[n]][2 * sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)(2 * sizes2D[n]), (float[][])object);
            floatFFT_2D.complexForward((float[][])object2);
            floatFFT_2D.complexInverse((float[][])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][])object2, (float[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_3D() {
        Object object;
        Object object2;
        double d;
        FloatFFT_3D floatFFT_3D;
        int n;
        System.out.println("Checking accuracy of 3D complex FFT (float[] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            floatFFT_3D = new FloatFFT_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new float[2 * sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)(2 * sizes3D[n]), (float[])object2);
            object = new float[2 * sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)(2 * sizes3D[n]), (float[])object);
            floatFFT_3D.complexForward((float[])object2);
            floatFFT_3D.complexInverse((float[])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D complex FFT (float[][][] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            floatFFT_3D = new FloatFFT_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new float[sizes3D[n]][sizes3D[n]][2 * sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)(2 * sizes3D[n]), (float[][][])object2);
            object = new float[sizes3D[n]][sizes3D[n]][2 * sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)(2 * sizes3D[n]), (float[][][])object);
            floatFFT_3D.complexForward((float[][][])object2);
            floatFFT_3D.complexInverse((float[][][])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][][])object2, (float[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_1D() {
        int n;
        float[] fArray;
        float[] fArray2;
        double d;
        FloatFFT_1D floatFFT_1D;
        int n2;
        System.out.println("Checking accuracy of 1D real FFT...");
        for (n2 = 0; n2 < sizes1D.length; ++n2) {
            floatFFT_1D = new FloatFFT_1D(sizes1D[n2]);
            d = 0.0;
            fArray2 = new float[sizes1D[n2]];
            IOUtils.fillMatrix_1D((int)sizes1D[n2], (float[])fArray2);
            fArray = new float[sizes1D[n2]];
            IOUtils.fillMatrix_1D((int)sizes1D[n2], (float[])fArray);
            floatFFT_1D.realForward(fArray2);
            floatFFT_1D.realInverse(fArray2, true);
            d = AccuracyCheckFloatFFT.computeRMSE(fArray2, fArray);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            }
            fArray2 = null;
            fArray = null;
            floatFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of on 1D real forward full FFT...");
        for (n2 = 0; n2 < sizes1D.length; ++n2) {
            floatFFT_1D = new FloatFFT_1D(sizes1D[n2]);
            d = 0.0;
            fArray2 = new float[2 * sizes1D[n2]];
            IOUtils.fillMatrix_1D((int)sizes1D[n2], (float[])fArray2);
            fArray = new float[2 * sizes1D[n2]];
            for (n = 0; n < sizes1D[n2]; ++n) {
                fArray[2 * n] = fArray2[n];
            }
            floatFFT_1D.realForwardFull(fArray2);
            floatFFT_1D.complexInverse(fArray2, true);
            d = AccuracyCheckFloatFFT.computeRMSE(fArray2, fArray);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            }
            fArray2 = null;
            fArray = null;
            floatFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 1D real inverse full FFT...");
        for (n2 = 0; n2 < sizes1D.length; ++n2) {
            floatFFT_1D = new FloatFFT_1D(sizes1D[n2]);
            d = 0.0;
            fArray2 = new float[2 * sizes1D[n2]];
            IOUtils.fillMatrix_1D((int)sizes1D[n2], (float[])fArray2);
            fArray = new float[2 * sizes1D[n2]];
            for (n = 0; n < sizes1D[n2]; ++n) {
                fArray[2 * n] = fArray2[n];
            }
            floatFFT_1D.realInverseFull(fArray2, true);
            floatFFT_1D.complexForward(fArray2);
            d = AccuracyCheckFloatFFT.computeRMSE(fArray2, fArray);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            }
            fArray2 = null;
            fArray = null;
            floatFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_2D() {
        int n;
        int n2;
        Object object;
        Object object2;
        double d;
        FloatFFT_2D floatFFT_2D;
        int n3;
        System.out.println("Checking accuracy of 2D real FFT (float[] input)...");
        for (n3 = 0; n3 < sizes2D2.length; ++n3) {
            floatFFT_2D = new FloatFFT_2D(sizes2D2[n3], sizes2D2[n3]);
            d = 0.0;
            object2 = new float[sizes2D2[n3] * sizes2D2[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D2[n3], (int)sizes2D2[n3], (float[])object2);
            object = new float[sizes2D2[n3] * sizes2D2[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D2[n3], (int)sizes2D2[n3], (float[])object);
            floatFFT_2D.realForward((float[])object2);
            floatFFT_2D.realInverse((float[])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real FFT (float[][] input)...");
        for (n3 = 0; n3 < sizes2D2.length; ++n3) {
            floatFFT_2D = new FloatFFT_2D(sizes2D2[n3], sizes2D2[n3]);
            d = 0.0;
            object2 = new float[sizes2D2[n3]][sizes2D2[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D2[n3], (int)sizes2D2[n3], (float[][])object2);
            object = new float[sizes2D2[n3]][sizes2D2[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D2[n3], (int)sizes2D2[n3], (float[][])object);
            floatFFT_2D.realForward((float[][])object2);
            floatFFT_2D.realInverse((float[][])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][])object2, (float[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            floatFFT_2D = new FloatFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new float[2 * sizes2D[n3] * sizes2D[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D[n3], (int)sizes2D[n3], (float[])object2);
            object = new float[2 * sizes2D[n3] * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2 * 2 * AccuracyCheckFloatFFT.sizes2D[n3] + 2 * n] = object2[n2 * sizes2D[n3] + n];
                }
            }
            floatFFT_2D.realForwardFull((float[])object2);
            floatFFT_2D.complexInverse((float[])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[][] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            floatFFT_2D = new FloatFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new float[sizes2D[n3]][2 * sizes2D[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D[n3], (int)sizes2D[n3], (float[][])object2);
            object = new float[sizes2D[n3]][2 * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2][2 * n] = object2[n2][n];
                }
            }
            floatFFT_2D.realForwardFull((float[][])object2);
            floatFFT_2D.complexInverse((float[][])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][])object2, (float[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            floatFFT_2D = new FloatFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new float[2 * sizes2D[n3] * sizes2D[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D[n3], (int)sizes2D[n3], (float[])object2);
            object = new float[2 * sizes2D[n3] * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2 * 2 * AccuracyCheckFloatFFT.sizes2D[n3] + 2 * n] = object2[n2 * sizes2D[n3] + n];
                }
            }
            floatFFT_2D.realInverseFull((float[])object2, true);
            floatFFT_2D.complexForward((float[])object2);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[][] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            floatFFT_2D = new FloatFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new float[sizes2D[n3]][2 * sizes2D[n3]];
            IOUtils.fillMatrix_2D((int)sizes2D[n3], (int)sizes2D[n3], (float[][])object2);
            object = new float[sizes2D[n3]][2 * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2][2 * n] = object2[n2][n];
                }
            }
            floatFFT_2D.realInverseFull((float[][])object2, true);
            floatFFT_2D.complexForward((float[][])object2);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][])object2, (float[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_3D() {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        double d;
        FloatFFT_3D floatFFT_3D;
        int n4;
        System.out.println("Checking accuracy of 3D real FFT (float[] input)...");
        for (n4 = 0; n4 < sizes3D2.length; ++n4) {
            floatFFT_3D = new FloatFFT_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4]);
            d = 0.0;
            object2 = new float[sizes3D2[n4] * sizes3D2[n4] * sizes3D2[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D2[n4], (int)sizes3D2[n4], (int)sizes3D2[n4], (float[])object2);
            object = new float[sizes3D2[n4] * sizes3D2[n4] * sizes3D2[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D2[n4], (int)sizes3D2[n4], (int)sizes3D2[n4], (float[])object);
            floatFFT_3D.realForward((float[])object);
            floatFFT_3D.realInverse((float[])object, true);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real FFT (float[][][] input)...");
        for (n4 = 0; n4 < sizes3D2.length; ++n4) {
            floatFFT_3D = new FloatFFT_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4]);
            d = 0.0;
            object2 = new float[sizes3D2[n4]][sizes3D2[n4]][sizes3D2[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D2[n4], (int)sizes3D2[n4], (int)sizes3D2[n4], (float[][][])object2);
            object = new float[sizes3D2[n4]][sizes3D2[n4]][sizes3D2[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D2[n4], (int)sizes3D2[n4], (int)sizes3D2[n4], (float[][][])object);
            floatFFT_3D.realForward((float[][][])object);
            floatFFT_3D.realInverse((float[][][])object, true);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][][])object2, (float[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            floatFFT_3D = new FloatFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new float[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D[n4], (int)sizes3D[n4], (int)sizes3D[n4], (float[])object2);
            object = new float[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3 * 2 * AccuracyCheckFloatFFT.sizes3D[n4] * AccuracyCheckFloatFFT.sizes3D[n4] + n2 * 2 * AccuracyCheckFloatFFT.sizes3D[n4] + 2 * n] = object2[n3 * sizes3D[n4] * sizes3D[n4] + n2 * sizes3D[n4] + n];
                    }
                }
            }
            floatFFT_3D.realForwardFull((float[])object2);
            floatFFT_3D.complexInverse((float[])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[][][] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            floatFFT_3D = new FloatFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new float[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D[n4], (int)sizes3D[n4], (int)sizes3D[n4], (float[][][])object2);
            object = new float[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3][n2][2 * n] = object2[n3][n2][n];
                    }
                }
            }
            floatFFT_3D.realForwardFull((float[][][])object2);
            floatFFT_3D.complexInverse((float[][][])object2, true);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][][])object2, (float[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            floatFFT_3D = new FloatFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new float[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D[n4], (int)sizes3D[n4], (int)sizes3D[n4], (float[])object2);
            object = new float[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3 * 2 * AccuracyCheckFloatFFT.sizes3D[n4] * AccuracyCheckFloatFFT.sizes3D[n4] + n2 * 2 * AccuracyCheckFloatFFT.sizes3D[n4] + 2 * n] = object2[n3 * sizes3D[n4] * sizes3D[n4] + n2 * sizes3D[n4] + n];
                    }
                }
            }
            floatFFT_3D.realInverseFull((float[])object2, true);
            floatFFT_3D.complexForward((float[])object2);
            d = AccuracyCheckFloatFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[][][] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            floatFFT_3D = new FloatFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new float[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            IOUtils.fillMatrix_3D((int)sizes3D[n4], (int)sizes3D[n4], (int)sizes3D[n4], (float[][][])object2);
            object = new float[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3][n2][2 * n] = object2[n3][n2][n];
                    }
                }
            }
            floatFFT_3D.realInverseFull((float[][][])object2, true);
            floatFFT_3D.complexForward((float[][][])object2);
            d = AccuracyCheckFloatFFT.computeRMSE((float[][][])object2, (float[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
    }

    private static double computeRMSE(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            double d2 = fArray[i] - fArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)fArray.length);
    }

    private static double computeRMSE(float[][] fArray, float[][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                double d2 = fArray[i][j] - fArray2[i][j];
                d += d2 * d2;
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length));
    }

    private static double computeRMSE(float[][][] fArray, float[][][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length || fArray[0][0].length != fArray2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                for (int k = 0; k < fArray[0][0].length; ++k) {
                    double d2 = fArray[i][j][k] - fArray2[i][j][k];
                    d += d2 * d2;
                }
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length * fArray[0][0].length));
    }

    public static void main(String[] stringArray) {
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_1D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_1D();
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_2D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_2D();
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_3D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_3D();
        System.exit(0);
    }
}

