/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Arrays;

public class BenchmarkFloatDHT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static int[] sizes1D = new int[]{65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 10368, 27000, 75600, 165375, 362880, 1562500, 0x310000, 6250000};
    private static int[] sizes2D = new int[]{128, 256, 512, 1024, 2048, 4096, 8192, 16384, 260, 520, 1050, 1458, 1960, 2916, 4116, 5832};
    private static int[] sizes3D = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 5, 17, 30, 95, 180, 270, 324, 420};
    private static boolean doScaling = false;

    private BenchmarkFloatDHT() {
    }

    public static void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            int n;
            nthread = Integer.parseInt(stringArray[0]);
            threadsBegin2D = Integer.parseInt(stringArray[1]);
            threadsBegin3D = Integer.parseInt(stringArray[2]);
            niter = Integer.parseInt(stringArray[3]);
            doWarmup = Boolean.parseBoolean(stringArray[4]);
            doScaling = Boolean.parseBoolean(stringArray[5]);
            nsize = Integer.parseInt(stringArray[6]);
            sizes1D = new int[nsize];
            sizes2D = new int[nsize];
            sizes3D = new int[nsize];
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatDHT.sizes1D[n] = Integer.parseInt(stringArray[7 + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatDHT.sizes2D[n] = Integer.parseInt(stringArray[7 + nsize + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatDHT.sizes3D[n] = Integer.parseInt(stringArray[7 + nsize + nsize + n]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads((int)nthread);
        ConcurrencyUtils.setThreadsBeginN_2D((int)threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D((int)threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 1D of size " + sizes1D[i]);
            FloatDHT_1D floatDHT_1D = new FloatDHT_1D(sizes1D[i]);
            float[] fArray = new float[sizes1D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D((int)sizes1D[i], (float[])fArray);
                floatDHT_1D.forward(fArray);
                IOUtils.fillMatrix_1D((int)sizes1D[i], (float[])fArray);
                floatDHT_1D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D((int)sizes1D[i], (float[])fArray);
                l = System.nanoTime();
                floatDHT_1D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkFloatForwardDHT_1D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes1D, (double[])dArray);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            FloatDHT_2D floatDHT_2D = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            float[] fArray = new float[sizes2D[i] * sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (float[])fArray);
                floatDHT_2D.forward(fArray);
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (float[])fArray);
                floatDHT_2D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (float[])fArray);
                l = System.nanoTime();
                floatDHT_2D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkFloatForwardDHT_2D_input_1D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes2D, (double[])dArray);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            FloatDHT_2D floatDHT_2D = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            float[][] fArray = new float[sizes2D[i]][sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (float[][])fArray);
                floatDHT_2D.forward(fArray);
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (float[][])fArray);
                floatDHT_2D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (float[][])fArray);
                l = System.nanoTime();
                floatDHT_2D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkFloatForwardDHT_2D_input_2D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes2D, (double[])dArray);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            FloatDHT_3D floatDHT_3D = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            float[] fArray = new float[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (float[])fArray);
                floatDHT_3D.forward(fArray);
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (float[])fArray);
                floatDHT_3D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (float[])fArray);
                l = System.nanoTime();
                floatDHT_3D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkFloatForwardDHT_3D_input_1D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes3D, (double[])dArray);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            FloatDHT_3D floatDHT_3D = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            float[][][] fArray = new float[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (float[][][])fArray);
                floatDHT_3D.forward(fArray);
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (float[][][])fArray);
                floatDHT_3D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (float[][][])fArray);
                l = System.nanoTime();
                floatDHT_3D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkFloatForwardDHT_3D_input_3D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes3D, (double[])dArray);
    }

    public static void main(String[] stringArray) {
        BenchmarkFloatDHT.parseArguments(stringArray);
        BenchmarkFloatDHT.benchmarkForward_1D();
        BenchmarkFloatDHT.benchmarkForward_2D_input_1D();
        BenchmarkFloatDHT.benchmarkForward_2D_input_2D();
        BenchmarkFloatDHT.benchmarkForward_3D_input_1D();
        BenchmarkFloatDHT.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

