/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatDHT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -23.0);

    private AccuracyCheckFloatDHT() {
    }

    public static void checkAccuracyDHT_1D() {
        System.out.println("Checking accuracy of 1D DHT...");
        for (int i = 0; i < sizes1D.length; ++i) {
            FloatDHT_1D floatDHT_1D = new FloatDHT_1D(sizes1D[i]);
            double d = 0.0;
            float[] fArray = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D((int)sizes1D[i], (float[])fArray);
            float[] fArray2 = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D((int)sizes1D[i], (float[])fArray2);
            floatDHT_1D.forward(fArray);
            floatDHT_1D.inverse(fArray, true);
            d = AccuracyCheckFloatDHT.computeRMSE(fArray, fArray2);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            }
            fArray = null;
            fArray2 = null;
            floatDHT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_2D() {
        Object object;
        Object object2;
        double d;
        FloatDHT_2D floatDHT_2D;
        int n;
        System.out.println("Checking accuracy of 2D DHT (float[] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            floatDHT_2D = new FloatDHT_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new float[sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)sizes2D[n], (float[])object2);
            object = new float[sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)sizes2D[n], (float[])object);
            floatDHT_2D.forward((float[])object2);
            floatDHT_2D.inverse((float[])object2, true);
            d = AccuracyCheckFloatDHT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDHT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DHT (float[][] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            floatDHT_2D = new FloatDHT_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new float[sizes2D[n]][sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)sizes2D[n], (float[][])object2);
            object = new float[sizes2D[n]][sizes2D[n]];
            IOUtils.fillMatrix_2D((int)sizes2D[n], (int)sizes2D[n], (float[][])object);
            floatDHT_2D.forward((float[][])object2);
            floatDHT_2D.inverse((float[][])object2, true);
            d = AccuracyCheckFloatDHT.computeRMSE((float[][])object2, (float[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDHT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_3D() {
        Object object;
        Object object2;
        double d;
        FloatDHT_3D floatDHT_3D;
        int n;
        System.out.println("Checking accuracy of 3D DHT (float[] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            floatDHT_3D = new FloatDHT_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new float[sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)sizes3D[n], (float[])object2);
            object = new float[sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)sizes3D[n], (float[])object);
            floatDHT_3D.forward((float[])object2);
            floatDHT_3D.inverse((float[])object2, true);
            d = AccuracyCheckFloatDHT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDHT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DHT (float[][][] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            floatDHT_3D = new FloatDHT_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new float[sizes3D[n]][sizes3D[n]][sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)sizes3D[n], (float[][][])object2);
            object = new float[sizes3D[n]][sizes3D[n]][sizes3D[n]];
            IOUtils.fillMatrix_3D((int)sizes3D[n], (int)sizes3D[n], (int)sizes3D[n], (float[][][])object);
            floatDHT_3D.forward((float[][][])object2);
            floatDHT_3D.inverse((float[][][])object2, true);
            d = AccuracyCheckFloatDHT.computeRMSE((float[][][])object2, (float[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDHT_3D = null;
            System.gc();
        }
    }

    private static double computeRMSE(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            double d2 = fArray[i] - fArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)fArray.length);
    }

    private static double computeRMSE(float[][] fArray, float[][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                double d2 = fArray[i][j] - fArray2[i][j];
                d += d2 * d2;
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length));
    }

    private static double computeRMSE(float[][][] fArray, float[][][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length || fArray[0][0].length != fArray2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                for (int k = 0; k < fArray[0][0].length; ++k) {
                    double d2 = fArray[i][j][k] - fArray2[i][j][k];
                    d += d2 * d2;
                }
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length * fArray[0][0].length));
    }

    public static void main(String[] stringArray) {
        AccuracyCheckFloatDHT.checkAccuracyDHT_1D();
        AccuracyCheckFloatDHT.checkAccuracyDHT_2D();
        AccuracyCheckFloatDHT.checkAccuracyDHT_3D();
        System.exit(0);
    }
}

