/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Arrays;

public class BenchmarkDoubleDCT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static int[] sizes1D = new int[]{65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 10368, 27000, 75600, 165375, 362880, 1562500, 0x310000, 6250000};
    private static int[] sizes2D = new int[]{128, 256, 512, 1024, 2048, 4096, 8192, 16384, 260, 520, 1050, 1458, 1960, 2916, 4116, 5832};
    private static int[] sizes3D = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 5, 17, 30, 95, 180, 270, 324, 420};
    private static boolean doScaling = false;

    private BenchmarkDoubleDCT() {
    }

    public static void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            int n;
            nthread = Integer.parseInt(stringArray[0]);
            threadsBegin2D = Integer.parseInt(stringArray[1]);
            threadsBegin3D = Integer.parseInt(stringArray[2]);
            niter = Integer.parseInt(stringArray[3]);
            doWarmup = Boolean.parseBoolean(stringArray[4]);
            doScaling = Boolean.parseBoolean(stringArray[5]);
            nsize = Integer.parseInt(stringArray[6]);
            sizes1D = new int[nsize];
            sizes2D = new int[nsize];
            sizes3D = new int[nsize];
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDCT.sizes1D[n] = Integer.parseInt(stringArray[7 + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDCT.sizes2D[n] = Integer.parseInt(stringArray[7 + nsize + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleDCT.sizes3D[n] = Integer.parseInt(stringArray[7 + nsize + nsize + n]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads((int)nthread);
        ConcurrencyUtils.setThreadsBeginN_2D((int)threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D((int)threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DCT 1D of size " + sizes1D[i]);
            DoubleDCT_1D doubleDCT_1D = new DoubleDCT_1D(sizes1D[i]);
            double[] dArray2 = new double[sizes1D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D((int)sizes1D[i], (double[])dArray2);
                doubleDCT_1D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_1D((int)sizes1D[i], (double[])dArray2);
                doubleDCT_1D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D((int)sizes1D[i], (double[])dArray2);
                l = System.nanoTime();
                doubleDCT_1D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkDoubleForwardDCT_1D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes1D, (double[])dArray);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DCT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(sizes2D[i], sizes2D[i]);
            double[] dArray2 = new double[sizes2D[i] * sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (double[])dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (double[])dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (double[])dArray2);
                l = System.nanoTime();
                doubleDCT_2D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkDoubleForwardDCT_2D_input_1D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes2D, (double[])dArray);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DCT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(sizes2D[i], sizes2D[i]);
            double[][] dArray2 = new double[sizes2D[i]][sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (double[][])dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (double[][])dArray2);
                doubleDCT_2D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D((int)sizes2D[i], (int)sizes2D[i], (double[][])dArray2);
                l = System.nanoTime();
                doubleDCT_2D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkDoubleForwardDCT_2D_input_2D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes2D, (double[])dArray);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DCT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[] dArray2 = new double[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (double[])dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (double[])dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (double[])dArray2);
                l = System.nanoTime();
                doubleDCT_3D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkDoubleForwardDCT_3D_input_1D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes3D, (double[])dArray);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DCT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[][][] dArray2 = new double[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (double[][][])dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (double[][][])dArray2);
                doubleDCT_3D.forward(dArray2, doScaling);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D((int)sizes3D[i], (int)sizes3D[i], (int)sizes3D[i], (double[][][])dArray2);
                l = System.nanoTime();
                doubleDCT_3D.forward(dArray2, doScaling);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDCT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep((long)5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile((String)"benchmarkDoubleForwardDCT_3D_input_3D.txt", (int)nthread, (int)niter, (boolean)doWarmup, (boolean)doScaling, (int[])sizes3D, (double[])dArray);
    }

    public static void main(String[] stringArray) {
        BenchmarkDoubleDCT.parseArguments(stringArray);
        BenchmarkDoubleDCT.benchmarkForward_1D();
        BenchmarkDoubleDCT.benchmarkForward_2D_input_1D();
        BenchmarkDoubleDCT.benchmarkForward_2D_input_2D();
        BenchmarkDoubleDCT.benchmarkForward_3D_input_1D();
        BenchmarkDoubleDCT.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

