/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.image.ColorModel;

public class Orthogonal_Views
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener,
ImageListener,
WindowListener,
AdjustmentListener,
MouseWheelListener,
FocusListener,
CommandListener {
    private ImageWindow win;
    private ImagePlus imp;
    private ImageCanvas canvas;
    private static final int H_ROI = 0;
    private static final int H_ZOOM = 1;
    private ImagePlus xz_image;
    private ImagePlus yz_image;
    private static int xzID;
    private static int yzID;
    private ImageProcessor fp1;
    private ImageProcessor fp2;
    private double ax;
    private double ay;
    private double az;
    private static boolean rotate;
    private static boolean sticky;
    private int xyX;
    private int xyY;
    private Calibration cal = null;
    private Calibration cal_xz = new Calibration();
    private Calibration cal_yz = new Calibration();
    private double magnification = 1.0;
    private Color color = Roi.getColor();
    private static Orthogonal_Views instance;
    private Updater updater = new Updater();
    private double min;
    private double max;
    private Dimension screen = IJ.getScreenSize();
    private boolean flipXZ;
    private boolean syncZoom = true;
    private Point crossLoc;
    private boolean firstTime = true;

    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp.getStackSize() == 1) {
            IJ.error("Othogonal Views", "This command requires a stack.");
            return;
        }
        if (instance != null && this.imp == Orthogonal_Views.instance.imp) {
            return;
        }
        this.yz_image = WindowManager.getImage(yzID);
        if (this.yz_image == null || this.yz_image.getHeight() != this.imp.getHeight() || this.yz_image.getBitDepth() != this.imp.getBitDepth()) {
            this.yz_image = new ImagePlus();
        }
        this.xz_image = WindowManager.getImage(xzID);
        if (this.xz_image == null || this.xz_image.getWidth() != this.imp.getWidth() || this.xz_image.getBitDepth() != this.imp.getBitDepth()) {
            this.xz_image = new ImagePlus();
        }
        instance = this;
        ImageProcessor ip = this.imp.getProcessor();
        this.min = ip.getMin();
        this.max = ip.getMax();
        this.cal = this.imp.getCalibration();
        double calx = this.cal.pixelWidth;
        double caly = this.cal.pixelHeight;
        double calz = this.cal.pixelDepth;
        this.ax = 1.0;
        this.ay = caly / calx;
        this.az = calz / calx;
        this.win = this.imp.getWindow();
        this.canvas = this.win.getCanvas();
        this.addListeners(this.canvas);
        this.magnification = this.canvas.getMagnification();
        this.imp.killRoi();
        this.crossLoc = new Point(this.imp.getWidth() / 2, this.imp.getHeight() / 2);
        ImageStack is = this.imp.getStack();
        this.calibrate();
        if (this.createProcessors(is)) {
            if (ip.isColorLut() || ip.isInvertedLut()) {
                ColorModel cm = ip.getColorModel();
                this.fp1.setColorModel(cm);
                this.fp2.setColorModel(cm);
            }
            this.update();
        } else {
            this.dispose();
        }
    }

    private void addListeners(ImageCanvas canvass) {
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.canvas.addKeyListener(this);
        this.win.addWindowListener(this);
        this.win.addMouseWheelListener(this);
        this.win.addFocusListener(this);
        Component[] c = this.win.getComponents();
        ((Scrollbar)c[1]).addAdjustmentListener(this);
        ImagePlus.addImageListener(this);
        Executer.addCommandListener(this);
    }

    private void calibrate() {
        double arat = this.az / this.ax;
        double brat = this.az / this.ay;
        String unit = this.cal.getUnit();
        double o_depth = this.cal.pixelDepth;
        double o_height = this.cal.pixelHeight;
        double o_width = this.cal.pixelWidth;
        this.cal_xz.setUnit(unit);
        if (rotate) {
            this.cal_xz.pixelHeight = o_depth / arat;
            this.cal_xz.pixelWidth = o_width * this.ax;
        } else {
            this.cal_xz.pixelHeight = o_width * this.ax;
            this.cal_xz.pixelWidth = o_depth / arat;
        }
        this.xz_image.setCalibration(this.cal_xz);
        this.cal_yz.setUnit(unit);
        this.cal_yz.pixelWidth = o_height * this.ay;
        this.cal_yz.pixelHeight = o_depth / brat;
        this.yz_image.setCalibration(this.cal_yz);
    }

    private void updateMagnification(int x, int y) {
        double magnification = this.win.getCanvas().getMagnification();
        int z = this.imp.getCurrentSlice() - 1;
        ImageWindow win1 = this.xz_image.getWindow();
        if (win1 == null) {
            return;
        }
        ImageCanvas ic1 = win1.getCanvas();
        double mag1 = ic1.getMagnification();
        double arat = this.az / this.ax;
        int zcoord = (int)(arat * (double)z);
        if (this.flipXZ) {
            zcoord = (int)(arat * (double)(this.imp.getStackSize() - z));
        }
        while (mag1 < magnification) {
            ic1.zoomIn(x, zcoord);
            mag1 = ic1.getMagnification();
        }
        while (mag1 > magnification) {
            ic1.zoomOut(x, zcoord);
            mag1 = ic1.getMagnification();
        }
        ImageWindow win2 = this.yz_image.getWindow();
        if (win2 == null) {
            return;
        }
        ImageCanvas ic2 = win2.getCanvas();
        double mag2 = ic2.getMagnification();
        zcoord = (int)(arat * (double)z);
        while (mag2 < magnification) {
            ic2.zoomIn(zcoord, y);
            mag2 = ic2.getMagnification();
        }
        while (mag2 > magnification) {
            ic2.zoomOut(zcoord, y);
            mag2 = ic2.getMagnification();
        }
    }

    void updateViews(Point p, ImageStack is) {
        if (this.fp1 == null) {
            return;
        }
        this.updateXZView(p, is);
        double arat = this.az / this.ax;
        int width2 = (int)Math.round((double)this.fp1.getWidth() * this.ax);
        int height2 = (int)Math.round((double)this.fp1.getHeight() * arat);
        if (width2 != this.fp1.getWidth() || height2 != this.fp1.getHeight()) {
            this.fp1.setInterpolate(true);
            ImageProcessor sfp1 = this.fp1.resize(width2, height2);
            sfp1.setMinAndMax(this.min, this.max);
            this.xz_image.setProcessor("XZ " + p.y, sfp1);
        } else {
            this.fp1.setMinAndMax(this.min, this.max);
            this.xz_image.setProcessor("XZ " + p.y, this.fp1);
        }
        if (rotate) {
            this.updateYZView(p, is);
        } else {
            this.updateZYView(p, is);
        }
        arat = this.az / this.ay;
        width2 = (int)Math.round((double)this.fp2.getWidth() * arat);
        height2 = (int)Math.round((double)this.fp2.getHeight() * this.ay);
        String title = "YZ ";
        if (rotate) {
            int tmp = width2;
            width2 = height2;
            height2 = tmp;
            title = "ZY ";
        }
        if (width2 != this.fp2.getWidth() || height2 != this.fp2.getHeight()) {
            this.fp2.setInterpolate(true);
            ImageProcessor sfp2 = this.fp2.resize(width2, height2);
            sfp2.setMinAndMax(this.min, this.max);
            this.yz_image.setProcessor(title + p.x, sfp2);
        } else {
            this.fp2.setMinAndMax(this.min, this.max);
            this.yz_image.setProcessor(title + p.x, this.fp2);
        }
        this.calibrate();
        if (this.yz_image.getWindow() == null) {
            this.yz_image.show();
            this.yz_image.getCanvas().addKeyListener(this);
            yzID = this.yz_image.getID();
        }
        if (this.xz_image.getWindow() == null) {
            this.xz_image.show();
            this.xz_image.getCanvas().addKeyListener(this);
            xzID = this.xz_image.getID();
        }
    }

    void arrangeWindows(boolean sticky) {
        ImageWindow xyWin = this.imp.getWindow();
        if (xyWin == null) {
            return;
        }
        Point loc = xyWin.getLocation();
        if (this.xyX != loc.x || this.xyY != loc.y) {
            this.xyX = loc.x;
            this.xyY = loc.y;
            ImageWindow yzWin = null;
            long start = System.currentTimeMillis();
            while (yzWin == null && System.currentTimeMillis() - start <= 2500L) {
                yzWin = this.yz_image.getWindow();
                if (yzWin != null) continue;
                IJ.wait(50);
            }
            if (yzWin != null) {
                yzWin.setLocation(this.xyX + xyWin.getWidth(), this.xyY);
            }
            ImageWindow xzWin = null;
            start = System.currentTimeMillis();
            while (xzWin == null && System.currentTimeMillis() - start <= 2500L) {
                xzWin = this.xz_image.getWindow();
                if (xzWin != null) continue;
                IJ.wait(50);
            }
            if (xzWin != null) {
                xzWin.setLocation(this.xyX, this.xyY + xyWin.getHeight());
            }
            if (this.firstTime) {
                this.imp.getWindow().toFront();
                this.imp.setSlice(this.imp.getStackSize() / 2);
                this.firstTime = false;
            }
        }
    }

    boolean createProcessors(ImageStack is) {
        ImageProcessor ip = is.getProcessor(1);
        int width = is.getWidth();
        int height = is.getHeight();
        int ds = is.getSize();
        double arat = 1.0;
        double brat = 1.0;
        int za = (int)((double)ds * arat);
        int zb = (int)((double)ds * brat);
        if (ip instanceof FloatProcessor) {
            this.fp1 = new FloatProcessor(width, za);
            this.fp2 = rotate ? new FloatProcessor(height, zb) : new FloatProcessor(zb, height);
            return true;
        }
        if (ip instanceof ByteProcessor) {
            this.fp1 = new ByteProcessor(width, za);
            this.fp2 = rotate ? new ByteProcessor(height, zb) : new ByteProcessor(zb, height);
            return true;
        }
        if (ip instanceof ShortProcessor) {
            this.fp1 = new ShortProcessor(width, za);
            this.fp2 = rotate ? new ShortProcessor(height, zb) : new ShortProcessor(zb, height);
            return true;
        }
        if (ip instanceof ColorProcessor) {
            this.fp1 = new ColorProcessor(width, za);
            this.fp2 = rotate ? new ColorProcessor(height, zb) : new ColorProcessor(zb, height);
            return true;
        }
        return false;
    }

    void updateXZView(Point p, ImageStack is) {
        int width = is.getWidth();
        int size = is.getSize();
        ImageProcessor ip = is.getProcessor(1);
        int y = p.y;
        if (ip instanceof ShortProcessor) {
            short[] newpix = new short[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
        if (ip instanceof ByteProcessor) {
            byte[] newpix = new byte[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
        if (ip instanceof FloatProcessor) {
            float[] newpix = new float[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
        if (ip instanceof ColorProcessor) {
            int[] newpix = new int[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
    }

    void updateYZView(Point p, ImageStack is) {
        int j;
        Object[] pixels;
        int i;
        Object[] newpix;
        int width = is.getWidth();
        int height = is.getHeight();
        int ds = is.getSize();
        ImageProcessor ip = is.getProcessor(1);
        int x = p.x;
        if (ip instanceof FloatProcessor) {
            newpix = new float[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (float[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ByteProcessor) {
            newpix = new byte[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (byte[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ShortProcessor) {
            newpix = new short[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (short[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ColorProcessor) {
            newpix = new int[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (int[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
    }

    void updateZYView(Point p, ImageStack is) {
        int y;
        Object[] pixels;
        int i;
        Object[] newpix;
        int width = is.getWidth();
        int height = is.getHeight();
        int ds = is.getSize();
        ImageProcessor ip = is.getProcessor(1);
        int x = p.x;
        if (ip instanceof FloatProcessor) {
            newpix = new float[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (float[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ByteProcessor) {
            newpix = new byte[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (byte[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ShortProcessor) {
            newpix = new short[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (short[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ColorProcessor) {
            newpix = new int[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (int[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
    }

    void drawCross(ImagePlus imp, Point p, GeneralPath path) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        float x = p.x;
        float y = p.y;
        path.moveTo(0.0f, y);
        path.lineTo(width, y);
        path.moveTo(x, 0.0f);
        path.lineTo(x, height);
    }

    void dispose() {
        ImageWindow win2;
        this.updater.quit();
        this.updater = null;
        this.canvas.removeMouseListener(this);
        this.canvas.removeMouseMotionListener(this);
        this.canvas.removeKeyListener(this);
        this.canvas.setDisplayList(null);
        this.canvas.setCustomRoi(false);
        ImageWindow win1 = this.xz_image.getWindow();
        if (win1 != null) {
            win1.getCanvas().setDisplayList(null);
            win1.getCanvas().removeKeyListener(this);
        }
        if ((win2 = this.yz_image.getWindow()) != null) {
            win2.getCanvas().setDisplayList(null);
            win2.getCanvas().removeKeyListener(this);
        }
        ImagePlus.removeImageListener(this);
        Executer.removeCommandListener(this);
        this.win.removeWindowListener(this);
        this.win.removeFocusListener(this);
        this.win.setResizable(true);
        instance = null;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.crossLoc = this.canvas.getCursorLoc();
        this.update();
    }

    public void mouseReleased(MouseEvent e) {
    }

    void update() {
        if (this.updater != null) {
            this.updater.doUpdate();
        }
    }

    private void exec() {
        if (this.canvas == null) {
            return;
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        ImageStack is = this.imp.getStack();
        double arat = this.az / this.ax;
        double brat = this.az / this.ay;
        Point p = this.crossLoc;
        if (p.y >= height) {
            p.y = height - 1;
        }
        if (p.x >= width) {
            p.x = width - 1;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        this.updateViews(p, is);
        GeneralPath path = new GeneralPath();
        this.drawCross(this.imp, p, path);
        this.canvas.setDisplayList(path, this.color, new BasicStroke(1.0f));
        this.canvas.setCustomRoi(true);
        this.updateCrosses(p.x, p.y, arat, brat);
        if (this.syncZoom) {
            this.updateMagnification(p.x, p.y);
        }
        this.arrangeWindows(sticky);
    }

    private void updateCrosses(int x, int y, double arat, double brat) {
        int z = this.imp.getNSlices();
        int zlice = this.imp.getCurrentSlice() - 1;
        int zcoord = (int)Math.round(arat * (double)zlice);
        if (this.flipXZ) {
            zcoord = (int)Math.round(arat * (double)(z - zlice));
        }
        Point p = new Point(x, zcoord);
        ImageCanvas xz_canvas = this.xz_image.getCanvas();
        if (xz_canvas != null) {
            GeneralPath path = new GeneralPath();
            this.drawCross(this.xz_image, p, path);
            xz_canvas.setDisplayList(path, this.color, new BasicStroke(1.0f));
        }
        zcoord = (int)Math.round(brat * (double)(z - zlice));
        if (rotate) {
            p = new Point(y, zcoord);
        } else {
            zcoord = (int)Math.round(arat * (double)zlice);
            p = new Point(zcoord, y);
        }
        ImageCanvas yz_canvas = this.yz_image.getCanvas();
        if (yz_canvas != null) {
            GeneralPath path = new GeneralPath();
            this.drawCross(this.yz_image, p, path);
            yz_canvas.setDisplayList(path, this.color, new BasicStroke(1.0f));
        }
        IJ.showStatus(this.imp.getLocationAsString(this.crossLoc.x, this.crossLoc.y));
    }

    public void mouseDragged(MouseEvent e) {
        this.crossLoc = this.canvas.getCursorLoc();
        this.update();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 27) {
            IJ.beep();
            this.dispose();
        } else if (IJ.shiftKeyDown()) {
            int width = this.imp.getWidth();
            int height = this.imp.getHeight();
            switch (key) {
                case 37: {
                    --this.crossLoc.x;
                    if (this.crossLoc.x >= 0) break;
                    this.crossLoc.x = 0;
                    break;
                }
                case 39: {
                    ++this.crossLoc.x;
                    if (this.crossLoc.x < width) break;
                    this.crossLoc.x = width - 1;
                    break;
                }
                case 38: {
                    --this.crossLoc.y;
                    if (this.crossLoc.y >= 0) break;
                    this.crossLoc.y = 0;
                    break;
                }
                case 40: {
                    ++this.crossLoc.y;
                    if (this.crossLoc.y < height) break;
                    this.crossLoc.y = height - 1;
                    break;
                }
                default: {
                    return;
                }
            }
            this.update();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public void imageClosed(ImagePlus imp) {
        this.dispose();
    }

    public void imageOpened(ImagePlus imp) {
    }

    public void imageUpdated(ImagePlus imp) {
        if (imp == this.imp) {
            ImageProcessor ip = imp.getProcessor();
            this.min = ip.getMin();
            this.max = ip.getMax();
            this.update();
        }
    }

    public String commandExecuting(String command) {
        if (command.equals("In") || command.equals("Out")) {
            ImagePlus cimp = WindowManager.getCurrentImage();
            if (cimp == null) {
                return command;
            }
            if (cimp == this.imp) {
                IJ.runPlugIn("ij.plugin.Zoom", command.toLowerCase());
                this.xyX = 0;
                this.xyY = 0;
                this.update();
                return null;
            }
            if (cimp == this.xz_image || cimp == this.yz_image) {
                this.syncZoom = false;
                return command;
            }
            return command;
        }
        if (command.equals("Flip Vertically") && this.xz_image != null) {
            if (this.xz_image == WindowManager.getCurrentImage()) {
                this.flipXZ = !this.flipXZ;
                this.update();
                return null;
            }
            return command;
        }
        return command;
    }

    public void windowActivated(WindowEvent e) {
        this.arrangeWindows(sticky);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
        this.arrangeWindows(sticky);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.update();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.update();
    }

    public void focusGained(FocusEvent e) {
        ImageCanvas ic = this.imp.getCanvas();
        if (ic != null) {
            this.canvas.requestFocus();
        }
        this.arrangeWindows(sticky);
    }

    public void focusLost(FocusEvent e) {
        this.arrangeWindows(sticky);
    }

    public static ImagePlus getImage() {
        if (instance != null) {
            return Orthogonal_Views.instance.imp;
        }
        return null;
    }

    static {
        rotate = false;
        sticky = true;
    }

    private class Updater
    extends Thread {
        long request;

        Updater() {
            super("Othogonal Views Updater");
            this.request = 0L;
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doUpdate() {
            if (this.isInterrupted()) {
                return;
            }
            Updater updater = this;
            synchronized (updater) {
                ++this.request;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            this.interrupt();
            Updater updater = this;
            synchronized (updater) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    long r;
                    Updater updater = this;
                    synchronized (updater) {
                        r = this.request;
                    }
                    if (r > 0L) {
                        Orthogonal_Views.this.exec();
                    }
                    updater = this;
                    synchronized (updater) {
                        if (r == this.request) {
                            this.request = 0L;
                            this.wait();
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

