/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.io.PluginClassLoader;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class Macro_Runner
implements PlugIn {
    public void run(String name) {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        if (!threadName.endsWith("Macro$")) {
            thread.setName(threadName + "Macro$");
        }
        String path = null;
        if (name.equals("")) {
            OpenDialog od = new OpenDialog("Run Macro...", path);
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name != null) {
                this.runMacroFile(directory + name, null);
            }
        } else if (name.startsWith("JAR:")) {
            this.runMacroFromJar(name);
        } else if (name.startsWith("ij.jar:")) {
            this.runMacroFromIJJar(name, null);
        } else {
            if (!name.startsWith("ij.jar:")) {
                path = Menus.getPlugInsPath() + name;
            }
            this.runMacroFile(path, null);
        }
    }

    void runMacroFromJar(String name) {
        name = name.substring(4);
        String macro = null;
        try {
            int n;
            PluginClassLoader pcl = new PluginClassLoader(Menus.getPlugInsPath());
            InputStream is = pcl.getResourceAsStream("/" + name);
            if (is == null) {
                IJ.showMessage("Macro Runner", "Unable to load \"" + name + "\" from jar file");
                return;
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            macro = sb.toString();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("Macro Runner", msg);
        }
        if (macro != null) {
            this.runMacro(macro, null);
        }
    }

    public String runMacroFile(String name, String arg) {
        String name3;
        File file;
        int size;
        String macrosDir;
        boolean fullPath;
        if (name.startsWith("ij.jar:")) {
            return this.runMacroFromIJJar(name, arg);
        }
        if (name.indexOf(".") == -1) {
            name = name + ".txt";
        }
        String name2 = name;
        boolean bl = fullPath = name.startsWith("/") || name.startsWith("\\") || name.indexOf(":\\") == 1;
        if (!fullPath && (macrosDir = Menus.getMacrosPath()) != null) {
            name2 = Menus.getMacrosPath() + name;
        }
        if ((size = (int)(file = new File(name2)).length()) <= 0 && !fullPath && name2.endsWith(".txt") && (size = (int)(file = new File(name3 = name2.substring(0, name2.length() - 4) + ".ijm")).length()) > 0) {
            name2 = name3;
        }
        if (size <= 0 && !fullPath) {
            file = new File(System.getProperty("user.dir") + File.separator + name);
            size = (int)file.length();
        }
        if (size <= 0) {
            IJ.error("RunMacro", "Macro or script not found:\n \n" + name2);
            return null;
        }
        try {
            byte[] buffer = new byte[size];
            FileInputStream in = new FileInputStream(file);
            in.read(buffer, 0, size);
            String macro = new String(buffer, 0, size, "ISO8859_1");
            in.close();
            if (name.endsWith(".js")) {
                return this.runJavaScript(macro, arg);
            }
            return this.runMacro(macro, arg);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return null;
        }
    }

    public String runMacro(String macro, String arg) {
        Interpreter interp = new Interpreter();
        try {
            return interp.run(macro, arg);
        }
        catch (Throwable e) {
            interp.abortMacro();
            IJ.showStatus("");
            IJ.showProgress(1.0);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.unlock();
            }
            String msg = e.getMessage();
            if (e instanceof RuntimeException && msg != null && e.getMessage().equals("Macro canceled")) {
                return "[aborted]";
            }
            IJ.handleException(e);
            return "[aborted]";
        }
    }

    public String runMacroFromIJJar(String name, String arg) {
        ImageJ ij = IJ.getInstance();
        if (ij == null) {
            return null;
        }
        name = name.substring(7);
        String macro = null;
        try {
            int n;
            InputStream is = ij.getClass().getResourceAsStream("/macros/" + name + ".txt");
            if (is == null) {
                return this.runMacroFile(name, arg);
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            macro = sb.toString();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("Macro Runner", msg);
        }
        if (macro != null) {
            return this.runMacro(macro, arg);
        }
        return null;
    }

    public String runJavaScript(String script, String arg) {
        if (arg == null) {
            arg = "";
        }
        Object js = null;
        js = IJ.isJava16() && !IJ.isMacOSX() ? IJ.runPlugIn("JavaScriptEvaluator", "") : IJ.runPlugIn("JavaScript", "");
        if (js == null) {
            IJ.error(Editor.JS_NOT_FOUND);
        }
        script = Editor.getJSPrefix(arg) + script;
        try {
            Class<?> c = js.getClass();
            Method m = c.getMethod("run", script.getClass(), arg.getClass());
            String s = (String)m.invoke(js, script, arg);
        }
        catch (Exception e) {
            String msg = "" + e;
            if (msg.indexOf("NoSuchMethod") != 0) {
                msg = "\"JavaScript.jar\" (http://rsb.info.nih.gov/ij/download/tools/JavaScript.jar)\nis outdated";
            }
            IJ.error(msg);
            return null;
        }
        return null;
    }
}

