/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.plugin.PlugIn;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class JpegWriter
implements PlugIn {
    public static final int DEFAULT_QUALITY = 75;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        imp.startTiming();
        this.saveAsJpeg(imp, arg, FileSaver.getJpegQuality());
        IJ.showTime(imp, imp.getStartTime(), "JpegWriter: ");
    }

    public static String save(ImagePlus imp, String path, int quality) {
        imp.startTiming();
        String error = new JpegWriter().saveAsJpeg(imp, path, quality);
        IJ.showTime(imp, imp.getStartTime(), "JpegWriter: ");
        return error;
    }

    String saveAsJpeg(ImagePlus imp, String path, int quality) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        int biType = 1;
        if (imp.getProcessor().isDefaultLut()) {
            biType = 10;
        }
        BufferedImage bi = new BufferedImage(width, height, biType);
        String error = null;
        try {
            Graphics2D g = bi.createGraphics();
            g.drawImage(imp.getImage(), 0, 0, null);
            g.dispose();
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(path));
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality((float)quality / 100.0f);
            if (quality == 100) {
                param.setSourceSubsampling(1, 1, 0, 0);
            }
            IIOImage iioImage = new IIOImage(bi, null, null);
            writer.write(null, iioImage, param);
            ios.close();
            writer.dispose();
        }
        catch (Exception e) {
            error = "" + e;
            IJ.error("Jpeg Writer", "" + error);
        }
        return error;
    }

    public static void setQuality(int jpegQuality) {
        FileSaver.setJpegQuality(jpegQuality);
    }

    public static int getQuality() {
        return FileSaver.getJpegQuality();
    }
}

