/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Plots;
import ij.plugin.PlotsCanvas;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Properties;

public class GelAnalyzer
implements PlugIn {
    static final String GEL = "gel.options";
    static final int OD = 1;
    static final int PERCENT = 2;
    static final int OUTLINE = 4;
    static final int INVERT = 8;
    static int saveID;
    static int nLanes;
    static int saveNLanes;
    static Rectangle firstRect;
    static final int MAX_LANES = 100;
    static int[] x;
    static PlotsCanvas plotsCanvas;
    static ImageProcessor ipLanes;
    static ImagePlus gel;
    static int plotHeight;
    static int options;
    static boolean uncalibratedOD;
    static boolean labelWithPercentages;
    static boolean outlineLanes;
    static boolean invertPeaks;
    static Overlay overlay;
    boolean invertedLut;
    ImagePlus imp;
    Font f;
    double odMin = Double.MAX_VALUE;
    double odMax = -1.7976931348623157E308;
    static boolean isVertical;
    static boolean showLaneDialog;

    public void run(String arg) {
        if (arg.equals("options")) {
            this.showDialog();
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("reset")) {
            nLanes = 0;
            saveNLanes = 0;
            saveID = 0;
            if (plotsCanvas != null) {
                plotsCanvas.reset();
            }
            ipLanes = null;
            overlay = null;
            if (gel != null) {
                ImageCanvas ic = gel.getCanvas();
                if (ic != null) {
                    ic.setDisplayList(null);
                }
                gel.draw();
            }
            return;
        }
        if (arg.equals("percent") && plotsCanvas != null) {
            plotsCanvas.displayPercentages();
            return;
        }
        if (arg.equals("label") && plotsCanvas != null) {
            if (GelAnalyzer.plotsCanvas.counter == 0) {
                this.show("There are no peak area measurements.");
            } else {
                plotsCanvas.labelPeaks();
            }
            return;
        }
        if (this.imp.getID() != saveID) {
            nLanes = 0;
            ipLanes = null;
            saveID = 0;
        }
        if (arg.equals("replot")) {
            if (saveNLanes == 0) {
                this.show("The data needed to re-plot the lanes is not available");
                return;
            }
            nLanes = saveNLanes;
            this.plotLanes(gel, true);
            return;
        }
        if (arg.equals("draw")) {
            this.outlineLanes();
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi == null || roi.getType() != 0) {
            this.show("Rectangular selection required.");
            return;
        }
        Rectangle rect = roi.getBounds();
        if (nLanes == 0) {
            this.invertedLut = this.imp.isInvertedLut();
            IJ.register(GelAnalyzer.class);
        }
        if (arg.equals("first")) {
            this.selectFirstLane(rect);
            return;
        }
        if (nLanes == 0) {
            this.show("You must first use the \"Outline First Lane\" command.");
            return;
        }
        if (arg.equals("next")) {
            this.selectNextLane(rect);
            return;
        }
        if (arg.equals("plot")) {
            if (isVertical && rect.x != x[nLanes] || !isVertical && rect.y != x[nLanes]) {
                this.selectNextLane(rect);
            }
            this.plotLanes(gel, false);
            return;
        }
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Gel Analyzer");
        gd.addCheckbox("Uncalibrated OD", uncalibratedOD);
        gd.addCheckbox("Label with Percentages", labelWithPercentages);
        gd.addCheckbox("Invert Peaks", invertPeaks);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        uncalibratedOD = gd.getNextBoolean();
        labelWithPercentages = gd.getNextBoolean();
        invertPeaks = gd.getNextBoolean();
        options = 0;
        if (uncalibratedOD) {
            options |= 1;
        }
        if (labelWithPercentages) {
            options |= 2;
        }
        if (invertPeaks) {
            options |= 8;
        }
    }

    void selectFirstLane(Rectangle rect) {
        if (rect.width / rect.height >= 2 || IJ.altKeyDown()) {
            if (showLaneDialog) {
                String msg = "Are the lanes really horizontal?\n \nImageJ assumes the lanes are\nhorizontal if the selection is more\nthan twice as wide as it is tall. Note\nthat the selection can only be moved\nvertically when the lanes are horizontal.";
                GenericDialog gd = new GenericDialog("Gel Analyzer");
                gd.addMessage(msg);
                gd.setOKLabel("Yes");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                showLaneDialog = false;
            }
            isVertical = false;
        } else {
            isVertical = true;
        }
        IJ.showStatus("Lane 1 selected (" + (isVertical ? "vertical" : "horizontal") + " lanes)");
        firstRect = rect;
        nLanes = 1;
        saveNLanes = 0;
        GelAnalyzer.x[1] = isVertical ? rect.x : rect.y;
        gel = this.imp;
        saveID = this.imp.getID();
        overlay = null;
        this.updateRoiList(rect);
    }

    void selectNextLane(Rectangle rect) {
        if (rect.width != GelAnalyzer.firstRect.width || rect.height != GelAnalyzer.firstRect.height) {
            this.show("Selections must all be the same size.");
            return;
        }
        if (nLanes < 100) {
            ++nLanes;
        }
        IJ.showStatus("Lane " + nLanes + " selected");
        GelAnalyzer.x[GelAnalyzer.nLanes] = isVertical ? rect.x : rect.y;
        if (isVertical && rect.y != GelAnalyzer.firstRect.y) {
            rect.y = GelAnalyzer.firstRect.y;
            gel.setRoi(rect);
        } else if (!isVertical && rect.x != GelAnalyzer.firstRect.x) {
            rect.x = GelAnalyzer.firstRect.x;
            gel.setRoi(rect);
        }
        this.updateRoiList(rect);
    }

    void updateRoiList(Rectangle rect) {
        if (gel == null) {
            return;
        }
        if (overlay == null) {
            overlay = new Overlay();
            overlay.drawLabels(true);
        }
        overlay.add(new Roi(rect.x, rect.y, rect.width, rect.height, null));
        gel.setOverlay(overlay);
    }

    void plotLanes(ImagePlus imp, boolean replot) {
        int plotWidth;
        int topMargin = 16;
        int bottomMargin = 2;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double[][] profiles = new double[101][];
        IJ.showStatus("Plotting " + nLanes + " lanes");
        ImageProcessor ipRotated = imp.getProcessor();
        if (isVertical) {
            ipRotated = ipRotated.rotateLeft();
        }
        ImagePlus imp2 = new ImagePlus("", ipRotated);
        imp2.setCalibration(imp.getCalibration());
        if (uncalibratedOD && (imp2.getType() == 1 || imp2.getType() == 2)) {
            new ImageConverter(imp2).convertToGray8();
        }
        if (invertPeaks) {
            ImageProcessor ip2 = imp2.getProcessor().duplicate();
            ip2.invert();
            imp2.setProcessor(null, ip2);
        }
        for (int i = 1; i <= nLanes; ++i) {
            if (isVertical) {
                imp2.setRoi(GelAnalyzer.firstRect.y, ipRotated.getHeight() - x[i] - GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height, GelAnalyzer.firstRect.width);
            } else {
                imp2.setRoi(GelAnalyzer.firstRect.x, x[i], GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
            }
            ProfilePlot pp = new ProfilePlot(imp2);
            profiles[i] = pp.getProfile();
            if (pp.getMin() < min) {
                min = pp.getMin();
            }
            if (pp.getMax() > max) {
                max = pp.getMax();
            }
            if (!uncalibratedOD) continue;
            profiles[i] = this.od(profiles[i]);
        }
        if (uncalibratedOD) {
            min = this.odMin;
            max = this.odMax;
        }
        if ((plotWidth = isVertical ? GelAnalyzer.firstRect.height : GelAnalyzer.firstRect.width) < 500) {
            plotWidth = 500;
        }
        if (isVertical) {
            if (plotWidth > 2 * GelAnalyzer.firstRect.height) {
                plotWidth = 2 * GelAnalyzer.firstRect.height;
            }
        } else if (plotWidth > 2 * GelAnalyzer.firstRect.width) {
            plotWidth = 2 * GelAnalyzer.firstRect.width;
        }
        Dimension screen = IJ.getScreenSize();
        if (plotWidth > screen.width - 40) {
            plotWidth = screen.width - 40;
        }
        if ((plotHeight = plotWidth / 2) < 200) {
            plotHeight = 200;
        }
        if (plotHeight > 400) {
            plotHeight = 400;
        }
        ByteProcessor ip = new ByteProcessor(plotWidth, topMargin + nLanes * plotHeight + bottomMargin);
        ((ImageProcessor)ip).setColor(Color.white);
        ip.fill();
        ((ImageProcessor)ip).setColor(Color.black);
        int h = ip.getHeight();
        ip.moveTo(0, 0);
        ip.lineTo(plotWidth - 1, 0);
        ip.lineTo(plotWidth - 1, h - 1);
        ip.lineTo(0, h - 1);
        ip.lineTo(0, 0);
        ip.moveTo(0, h - 2);
        ip.lineTo(plotWidth - 1, h - 2);
        String s = imp.getTitle() + "; ";
        Calibration cal = imp.getCalibration();
        s = cal.calibrated() ? s + cal.getValueUnit() : (uncalibratedOD ? s + "Uncalibrated OD" : s + "Uncalibrated");
        ip.moveTo(5, topMargin);
        ip.drawString(s);
        double xScale = (double)plotWidth / (double)profiles[1].length;
        double yScale = max - min == 0.0 ? 1.0 : (double)plotHeight / (max - min);
        for (int i = 1; i <= nLanes; ++i) {
            double[] profile = profiles[i];
            int top = (i - 1) * plotHeight + topMargin;
            int base = top + plotHeight;
            ip.moveTo(0, base);
            ip.lineTo((int)((double)profile.length * xScale), base);
            ip.moveTo(0, base - (int)((profile[0] - min) * yScale));
            for (int j = 1; j < profile.length; ++j) {
                ip.lineTo((int)((double)j * xScale + 0.5), base - (int)((profile[j] - min) * yScale + 0.5));
            }
        }
        Line.setWidth(1);
        Plots plots = new Plots();
        plots.setProcessor("Plots of " + imp.getShortTitle(), ip);
        plots.changes = true;
        ip.setThreshold(0.0, 0.0, 2);
        if (cal.calibrated()) {
            double pixelsAveraged = isVertical ? (double)GelAnalyzer.firstRect.width : (double)GelAnalyzer.firstRect.height;
            double scale = Math.sqrt(xScale * yScale / pixelsAveraged);
            Calibration plotsCal = plots.getCalibration();
            plotsCal.setUnit("unit");
            plotsCal.pixelWidth = 1.0 / scale;
            plotsCal.pixelHeight = 1.0 / scale;
        }
        ((ImagePlus)plots).show();
        saveNLanes = nLanes;
        nLanes = 0;
        saveID = 0;
        ipLanes = null;
        Toolbar toolbar = Toolbar.getInstance();
        toolbar.setColor(Color.black);
        toolbar.setTool(4);
        ImageWindow win = WindowManager.getCurrentWindow();
        ImageCanvas canvas = win.getCanvas();
        plotsCanvas = canvas instanceof PlotsCanvas ? (PlotsCanvas)canvas : null;
    }

    double[] od(double[] profile) {
        for (int i = 0; i < profile.length; ++i) {
            double v = 0.434294481 * Math.log(255.0 / (255.0 - profile[i]));
            if (v < this.odMin) {
                this.odMin = v;
            }
            if (v > this.odMax) {
                this.odMax = v;
            }
            profile[i] = v;
        }
        return profile;
    }

    void outlineLanes() {
        if (gel == null || overlay == null) {
            this.show("Data needed to outline lanes is no longer available.");
            return;
        }
        int lineWidth = (int)(1.0 / gel.getCanvas().getMagnification());
        if (lineWidth < 1) {
            lineWidth = 1;
        }
        Font f = new Font("Helvetica", 0, 12 * lineWidth);
        ImageProcessor ip = gel.getProcessor();
        ImageProcessor ipLanes = ip.duplicate();
        if (!(ipLanes instanceof ByteProcessor)) {
            ipLanes = ipLanes.convertToByte(true);
        }
        ipLanes.setFont(f);
        ipLanes.setLineWidth(lineWidth);
        this.setCustomLut(ipLanes);
        ImagePlus lanes = new ImagePlus("Lanes of " + gel.getShortTitle(), ipLanes);
        lanes.changes = true;
        lanes.setRoi(gel.getRoi());
        gel.killRoi();
        for (int i = 0; i < overlay.size(); ++i) {
            Roi roi = overlay.get(i);
            Rectangle r = roi.getBounds();
            ipLanes.drawRect(r.x, r.y, r.width, r.height);
            String s = "" + (i + 1);
            if (isVertical) {
                int yloc = r.y;
                if (yloc < lineWidth * 12) {
                    yloc += lineWidth * 14;
                }
                ipLanes.drawString(s, r.x + r.width / 2 - ipLanes.getStringWidth(s) / 2, yloc);
                continue;
            }
            int xloc = r.x - ipLanes.getStringWidth(s) - 2;
            if (xloc < lineWidth * 10) {
                xloc = r.x + 2;
            }
            ipLanes.drawString(s, xloc, r.y + r.height / 2 + 6);
        }
        lanes.killRoi();
        lanes.show();
    }

    void setCustomLut(ImageProcessor ip) {
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        reds[1] = -1;
        greens[1] = 0;
        blues[1] = 0;
        ip.setColorModel(new IndexColorModel(8, 256, reds, greens, blues));
        byte[] pixels = (byte[])ip.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            if ((pixels[i] & 0xFF) != 1) continue;
            pixels[i] = 0;
        }
        ip.setColor(1);
    }

    void show(String msg) {
        IJ.showMessage("Gel Analyzer", msg);
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(GEL, Integer.toString(options));
    }

    static {
        x = new int[101];
        options = Prefs.getInt(GEL, 10);
        uncalibratedOD = (options & 1) != 0;
        labelWithPercentages = (options & 2) != 0;
        invertPeaks = (options & 8) != 0;
        showLaneDialog = true;
    }
}

