/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;

public class ArrowToolOptions
implements PlugIn,
DialogListener {
    private String colorName;
    private static GenericDialog gd;

    public void run(String arg) {
        if (gd != null && gd.isVisible()) {
            gd.toFront();
        } else {
            this.arrowToolOptions();
        }
    }

    void arrowToolOptions() {
        if (!Toolbar.getToolName().equals("arrow")) {
            IJ.setTool("arrow");
        }
        double width = Arrow.getDefaultWidth();
        double headSize = Arrow.getDefaultHeadSize();
        Color color = Toolbar.getForegroundColor();
        this.colorName = Colors.getColorName(color, "red");
        int style = Arrow.getDefaultStyle();
        gd = new NonBlockingGenericDialog("Arrow Tool");
        gd.addSlider("Width:", 1.0, 50.0, (int)width);
        gd.addSlider("Size:", 0.0, 30.0, headSize);
        gd.addChoice("Color:", Colors.colors, this.colorName);
        gd.addChoice("Style:", Arrow.styles, Arrow.styles[style]);
        gd.addDialogListener(this);
        gd.showDialog();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        double width2 = gd.getNextNumber();
        double headSize2 = gd.getNextNumber();
        String colorName2 = gd.getNextChoice();
        int style2 = gd.getNextChoiceIndex();
        this.updateArrow(width2, headSize2, style2);
        if (this.colorName != null && !colorName2.equals(this.colorName)) {
            Color color = Colors.getColor(colorName2, Color.black);
            Toolbar.setForegroundColor(color);
        }
        this.colorName = colorName2;
        return true;
    }

    void updateArrow(double width2, double headSize2, int style2) {
        Arrow.setDefaultWidth(width2);
        Arrow.setDefaultHeadSize(headSize2);
        Arrow.setDefaultStyle(style2);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            return;
        }
        if (roi instanceof Arrow) {
            roi.setStrokeWidth((float)width2);
            ((Arrow)roi).setHeadSize(headSize2);
            ((Arrow)roi).setStyle(style2);
            imp.draw();
        }
    }
}

