/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RoiDecoder {
    public static final int VERSION_OFFSET = 4;
    public static final int TYPE = 6;
    public static final int TOP = 8;
    public static final int LEFT = 10;
    public static final int BOTTOM = 12;
    public static final int RIGHT = 14;
    public static final int N_COORDINATES = 16;
    public static final int X1 = 18;
    public static final int Y1 = 22;
    public static final int X2 = 26;
    public static final int Y2 = 30;
    public static final int STROKE_WIDTH = 34;
    public static final int SHAPE_ROI_SIZE = 36;
    public static final int STROKE_COLOR = 40;
    public static final int FILL_COLOR = 44;
    public static final int SUBTYPE = 48;
    public static final int OPTIONS = 50;
    public static final int COORDINATES = 64;
    public static final int TEXT = 1;
    public static final int SPLINE_FIT = 1;
    private final int polygon = 0;
    private final int rect = 1;
    private final int oval = 2;
    private final int line = 3;
    private final int freeline = 4;
    private final int polyline = 5;
    private final int noRoi = 6;
    private final int freehand = 7;
    private final int traced = 8;
    private final int angle = 9;
    private final int point = 10;
    private byte[] data;
    private String path;
    private InputStream is;
    private String name;
    private int size;

    public RoiDecoder(String path) {
        this.path = path;
    }

    public RoiDecoder(byte[] bytes, String name) {
        this.is = new ByteArrayInputStream(bytes);
        this.name = name;
        this.size = bytes.length;
    }

    public Roi getRoi() throws IOException {
        boolean isComposite;
        if (this.path != null) {
            File f = new File(this.path);
            this.size = (int)f.length();
            if (this.size > 500000) {
                throw new IOException("This is not an ImageJ ROI");
            }
            this.name = f.getName();
            this.is = new FileInputStream(this.path);
        }
        this.data = new byte[this.size];
        for (int total = 0; total < this.size; total += this.is.read(this.data, total, this.size - total)) {
        }
        this.is.close();
        if (this.getByte(0) != 73 || this.getByte(1) != 111) {
            throw new IOException("This is not an ImageJ ROI");
        }
        int version = this.getShort(4);
        int type = this.getByte(6);
        int top = this.getShort(8);
        int left = this.getShort(10);
        int bottom = this.getShort(12);
        int right = this.getShort(14);
        int width = right - left;
        int height = bottom - top;
        int n = this.getShort(16);
        if (this.name.endsWith(".roi")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        boolean bl = isComposite = this.getInt(36) > 0;
        if (isComposite) {
            return this.getShapeRoi();
        }
        Roi roi = null;
        switch (type) {
            case 1: {
                roi = new Roi(left, top, width, height);
                break;
            }
            case 2: {
                roi = new OvalRoi(left, top, width, height);
                break;
            }
            case 3: {
                int x1 = (int)this.getFloat(18);
                int y1 = (int)this.getFloat(22);
                int x2 = (int)this.getFloat(26);
                int y2 = (int)this.getFloat(30);
                roi = new Line(x1, y1, x2, y2);
                break;
            }
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (n == 0) break;
                int[] x = new int[n];
                int[] y = new int[n];
                int base1 = 64;
                int base2 = base1 + 2 * n;
                for (int i = 0; i < n; ++i) {
                    int ytmp;
                    int xtmp = this.getShort(base1 + i * 2);
                    if (xtmp < 0) {
                        xtmp = 0;
                    }
                    if ((ytmp = this.getShort(base2 + i * 2)) < 0) {
                        ytmp = 0;
                    }
                    x[i] = left + xtmp;
                    y[i] = top + ytmp;
                }
                if (type == 10) {
                    roi = new PointRoi(x, y, n);
                    break;
                }
                int roiType = type == 0 ? 2 : (type == 7 ? 3 : (type == 8 ? 4 : (type == 5 ? 6 : (type == 4 ? 7 : (type == 9 ? 8 : 3)))));
                roi = new PolygonRoi(x, y, n, roiType);
                break;
            }
            default: {
                throw new IOException("Unrecognized ROI type: " + type);
            }
        }
        roi.setName(this.name);
        if (version >= 218) {
            int options;
            boolean splineFit;
            int fillColor;
            int strokeColor;
            int strokeWidth = this.getShort(34);
            if (strokeWidth > 0) {
                roi.setStrokeWidth(strokeWidth);
            }
            if ((strokeColor = this.getInt(40)) != 0) {
                int alpha = strokeColor >> 24 & 0xFF;
                roi.setStrokeColor(new Color(strokeColor, alpha != 255));
            }
            if ((fillColor = this.getInt(44)) != 0) {
                int alpha = fillColor >> 24 & 0xFF;
                roi.setFillColor(new Color(fillColor, alpha != 255));
            }
            boolean bl2 = splineFit = ((options = this.getShort(50)) & 1) != 0;
            if (splineFit && roi instanceof PolygonRoi) {
                ((PolygonRoi)roi).fitSpline();
            }
        }
        int subtype = this.getShort(48);
        if (version >= 218 && subtype == 1) {
            roi = this.getTextRoi(roi);
        }
        return roi;
    }

    public Roi getShapeRoi() throws IOException {
        int type = this.getByte(6);
        if (type != 1) {
            throw new IllegalArgumentException("Invalid composite ROI type");
        }
        int top = this.getShort(8);
        int left = this.getShort(10);
        int bottom = this.getShort(12);
        int right = this.getShort(14);
        int width = right - left;
        int height = bottom - top;
        int n = this.getInt(36);
        ShapeRoi roi = null;
        float[] shapeArray = new float[n];
        int base = 64;
        for (int i = 0; i < n; ++i) {
            shapeArray[i] = this.getFloat(base);
            base += 4;
        }
        roi = new ShapeRoi(shapeArray);
        roi.setName(this.name);
        return roi;
    }

    Roi getTextRoi(Roi roi) {
        int i;
        Rectangle r = roi.getBounds();
        int hdrSize = 64;
        int size = this.getInt(hdrSize);
        int style = this.getInt(hdrSize + 4);
        int nameLength = this.getInt(hdrSize + 8);
        int textLength = this.getInt(hdrSize + 12);
        char[] name = new char[nameLength];
        char[] text = new char[textLength];
        for (i = 0; i < nameLength; ++i) {
            name[i] = (char)this.getShort(hdrSize + 16 + i * 2);
        }
        for (i = 0; i < textLength; ++i) {
            text[i] = (char)this.getShort(hdrSize + 16 + nameLength * 2 + i * 2);
        }
        Font font = new Font(new String(name), style, size);
        TextRoi roi2 = new TextRoi(r.x, r.y, new String(text), font);
        roi2.setStrokeColor(roi.getStrokeColor());
        roi2.setFillColor(roi.getFillColor());
        return roi2;
    }

    int getByte(int base) {
        return this.data[base] & 0xFF;
    }

    int getShort(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        int n = (b0 << 8) + b1;
        if (n < -5000) {
            n = (b0 << 8) + b1;
        }
        return n;
    }

    int getInt(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        int b2 = this.data[base + 2] & 0xFF;
        int b3 = this.data[base + 3] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    float getFloat(int base) {
        return Float.intBitsToFloat(this.getInt(base));
    }
}

