/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.JFileChooser;

public class DirectoryChooser {
    private String directory;
    private static String defaultDir;
    private String title;

    public DirectoryChooser(String title) {
        this.title = title;
        if (IJ.isMacOSX()) {
            this.getDirectoryUsingFileDialog(title);
        } else {
            String macroOptions = Macro.getOptions();
            if (macroOptions != null) {
                this.directory = Macro.getValue(macroOptions, title, null);
            }
            if (this.directory == null) {
                if (EventQueue.isDispatchThread()) {
                    this.getDirectoryUsingJFileChooserOnThisThread(title);
                } else {
                    this.getDirectoryUsingJFileChooser(title);
                }
            }
        }
    }

    void getDirectoryUsingJFileChooser(final String title) {
        Java2.setSystemLookAndFeel();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    JFileChooser chooser = new JFileChooser();
                    if (defaultDir != null) {
                        chooser.setCurrentDirectory(new File(defaultDir));
                    }
                    chooser.setDialogTitle(title);
                    chooser.setFileSelectionMode(1);
                    chooser.setApproveButtonText("Select");
                    if (chooser.showOpenDialog(null) == 0) {
                        String fileName;
                        File dir = chooser.getCurrentDirectory();
                        File file = chooser.getSelectedFile();
                        DirectoryChooser.this.directory = dir.getPath();
                        if (!DirectoryChooser.this.directory.endsWith(File.separator)) {
                            DirectoryChooser.this.directory = DirectoryChooser.this.directory + File.separator;
                        }
                        if (DirectoryChooser.this.directory != null) {
                            defaultDir = new File(DirectoryChooser.this.directory).getParent();
                        }
                        if ((fileName = file.getName()).indexOf(":\\") != -1) {
                            DirectoryChooser.this.directory = (defaultDir = fileName);
                        } else {
                            DirectoryChooser.this.directory = DirectoryChooser.this.directory + (fileName + File.separator);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getDirectoryUsingJFileChooserOnThisThread(String title) {
        Java2.setSystemLookAndFeel();
        try {
            JFileChooser chooser = new JFileChooser();
            if (defaultDir != null) {
                chooser.setCurrentDirectory(new File(defaultDir));
            }
            chooser.setDialogTitle(title);
            chooser.setFileSelectionMode(1);
            chooser.setApproveButtonText("Select");
            if (chooser.showOpenDialog(null) == 0) {
                String fileName;
                File dir = chooser.getCurrentDirectory();
                File file = chooser.getSelectedFile();
                this.directory = dir.getPath();
                if (!this.directory.endsWith(File.separator)) {
                    this.directory = this.directory + File.separator;
                }
                if (this.directory != null) {
                    defaultDir = new File(this.directory).getParent();
                }
                this.directory = (fileName = file.getName()).indexOf(":\\") != -1 ? (defaultDir = fileName) : this.directory + fileName + File.separator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getDirectoryUsingFileDialog(String title) {
        boolean saveUseJFC = Prefs.useJFileChooser;
        Prefs.useJFileChooser = false;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        OpenDialog od = new OpenDialog(title, defaultDir, null);
        this.directory = od.getDirectory() == null ? null : od.getDirectory() + od.getFileName() + "/";
        if (this.directory != null) {
            defaultDir = new File(this.directory).getParent();
        }
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        Prefs.useJFileChooser = saveUseJFC;
    }

    public String getDirectory() {
        if (Recorder.record && !IJ.isMacOSX()) {
            Recorder.recordPath(this.title, this.directory);
        }
        return this.directory;
    }

    public static void setDefaultDirectory(String dir) {
        if (dir == null || new File(dir).isDirectory()) {
            defaultDir = dir;
        }
    }
}

