/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;

public class Toolbar
extends Canvas
implements MouseListener,
MouseMotionListener,
ItemListener,
ActionListener {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int LINE = 4;
    public static final int POLYLINE = 5;
    public static final int FREELINE = 6;
    public static final int POINT = 7;
    public static final int CROSSHAIR = 7;
    public static final int WAND = 8;
    public static final int TEXT = 9;
    public static final int SPARE1 = 10;
    public static final int MAGNIFIER = 11;
    public static final int HAND = 12;
    public static final int DROPPER = 13;
    public static final int ANGLE = 14;
    public static final int SPARE2 = 15;
    public static final int SPARE3 = 16;
    public static final int SPARE4 = 17;
    public static final int SPARE5 = 18;
    public static final int SPARE6 = 19;
    public static final int SPARE7 = 20;
    public static final int SPARE8 = 21;
    public static final int SPARE9 = 22;
    public static final int DOUBLE_CLICK_THRESHOLD = 650;
    private static final int NUM_TOOLS = 23;
    private static final int NUM_BUTTONS = 21;
    private static final int SIZE = 26;
    private static final int OFFSET = 5;
    private static final String BRUSH_SIZE = "toolbar.brush.size";
    private static final String ARC_SIZE = "toolbar.arc.size";
    private Dimension ps = new Dimension(546, 26);
    private boolean[] down;
    private static int current;
    private int previous;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static Toolbar instance;
    private int mpPrevious = 0;
    private String[] names = new String[23];
    private String[] icons = new String[23];
    private PopupMenu[] menus = new PopupMenu[23];
    private int pc;
    private String icon;
    private MacroInstaller macroInstaller;
    private int startupTime;
    private PopupMenu rectPopup;
    private PopupMenu ovalPopup;
    private PopupMenu pointPopup;
    private PopupMenu linePopup;
    private PopupMenu switchPopup;
    private CheckboxMenuItem rectItem;
    private CheckboxMenuItem roundRectItem;
    private CheckboxMenuItem ovalItem;
    private CheckboxMenuItem brushItem;
    private CheckboxMenuItem pointItem;
    private CheckboxMenuItem multiPointItem;
    private CheckboxMenuItem straightLineItem;
    private CheckboxMenuItem polyLineItem;
    private CheckboxMenuItem freeLineItem;
    private CheckboxMenuItem arrowItem;
    private String currentSet = "Startup Macros";
    private static Color foregroundColor;
    private static Color backgroundColor;
    private static boolean brushEnabled;
    private static boolean multiPointMode;
    private static boolean roundRectMode;
    private static boolean arrowMode;
    private static int brushSize;
    private static int arcSize;
    private int lineType = 4;
    private Color gray = ImageJ.backgroundColor;
    private Color brighter = this.gray.brighter();
    private Color darker = new Color(175, 175, 175);
    private Color evenDarker = new Color(110, 110, 110);
    private Color triangleColor = new Color(150, 0, 0);
    private Color toolColor = new Color(0, 25, 45);

    public Toolbar() {
        this.down = new boolean[23];
        this.resetButtons();
        this.down[0] = true;
        this.setForeground(Color.black);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        instance = this;
        this.names[22] = "Switch to alternate macro tool sets";
        this.icons[22] = "C900T1c12>T7c12>";
        this.addPopupMenus();
        if (IJ.isMacOSX() || IJ.isVista()) {
            Prefs.antialiasedTools = true;
        }
    }

    void addPopupMenus() {
        this.rectPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.rectPopup.setFont(Menus.getFont());
        }
        this.rectItem = new CheckboxMenuItem("Rectangle Tool", !roundRectMode);
        this.rectItem.addItemListener(this);
        this.rectPopup.add(this.rectItem);
        this.roundRectItem = new CheckboxMenuItem("Rounded Rectangle Tool", roundRectMode);
        this.roundRectItem.addItemListener(this);
        this.rectPopup.add(this.roundRectItem);
        this.add(this.rectPopup);
        this.ovalPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.ovalPopup.setFont(Menus.getFont());
        }
        this.ovalItem = new CheckboxMenuItem("Elliptical Selection Tool", !brushEnabled);
        this.ovalItem.addItemListener(this);
        this.ovalPopup.add(this.ovalItem);
        this.brushItem = new CheckboxMenuItem("Selection Brush Tool", brushEnabled);
        this.brushItem.addItemListener(this);
        this.ovalPopup.add(this.brushItem);
        this.add(this.ovalPopup);
        this.pointPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.pointPopup.setFont(Menus.getFont());
        }
        this.pointItem = new CheckboxMenuItem("Point Tool", !multiPointMode);
        this.pointItem.addItemListener(this);
        this.pointPopup.add(this.pointItem);
        this.multiPointItem = new CheckboxMenuItem("Multi-point Tool", multiPointMode);
        this.multiPointItem.addItemListener(this);
        this.pointPopup.add(this.multiPointItem);
        this.add(this.pointPopup);
        this.linePopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.linePopup.setFont(Menus.getFont());
        }
        this.straightLineItem = new CheckboxMenuItem("Straight Line", this.lineType == 4 && !arrowMode);
        this.straightLineItem.addItemListener(this);
        this.linePopup.add(this.straightLineItem);
        this.polyLineItem = new CheckboxMenuItem("Segmented Line", this.lineType == 5);
        this.polyLineItem.addItemListener(this);
        this.linePopup.add(this.polyLineItem);
        this.freeLineItem = new CheckboxMenuItem("Freehand Line", this.lineType == 6);
        this.freeLineItem.addItemListener(this);
        this.linePopup.add(this.freeLineItem);
        this.arrowItem = new CheckboxMenuItem("Arrow tool", this.lineType == 4 && !arrowMode);
        this.arrowItem.addItemListener(this);
        this.linePopup.add(this.arrowItem);
        this.add(this.linePopup);
        this.switchPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.switchPopup.setFont(Menus.getFont());
        }
        this.add(this.switchPopup);
    }

    public static int getToolId() {
        return current;
    }

    public int getToolId(String name) {
        int tool = -1;
        for (int i = 0; i <= 22; ++i) {
            if (this.names[i] == null || !this.names[i].startsWith(name)) continue;
            tool = i;
            break;
        }
        return tool;
    }

    public static Toolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics g) {
        int i;
        if (Prefs.antialiasedTools) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        for (i = 0; i < 4; ++i) {
            this.drawButton(g, i);
        }
        this.drawButton(g, this.lineType);
        for (i = 7; i < 23; ++i) {
            this.drawButton(g, i);
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (null == g) {
            return;
        }
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(raised ? this.brighter : this.evenDarker);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
    }

    private void drawButton(Graphics g, int tool) {
        if (g == null) {
            return;
        }
        int index = this.toolIndex(tool);
        this.fill3DRect(g, index * 26 + 1, 1, 26, 25, !this.down[tool]);
        g.setColor(this.toolColor);
        int x = index * 26 + 5;
        int y = 5;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        if (tool >= 10 && tool <= 22 && this.icons[tool] != null) {
            this.drawIcon(g, tool, x, y);
            return;
        }
        switch (tool) {
            case 0: {
                this.xOffset = x;
                this.yOffset = y;
                if (roundRectMode) {
                    g.drawRoundRect(x + 1, y + 2, 15, 12, 8, 8);
                } else {
                    g.drawRect(x + 1, y + 2, 15, 12);
                }
                this.drawTriangle(15, 14);
                return;
            }
            case 1: {
                this.xOffset = x;
                this.yOffset = y;
                if (brushEnabled) {
                    this.m(9, 2);
                    this.d(13, 2);
                    this.d(13, 2);
                    this.d(15, 5);
                    this.d(15, 8);
                    this.d(13, 10);
                    this.d(10, 10);
                    this.d(8, 13);
                    this.d(4, 13);
                    this.d(2, 11);
                    this.d(2, 7);
                    this.d(4, 5);
                    this.d(7, 5);
                    this.d(9, 2);
                } else {
                    g.drawOval(x + 1, y + 2, 15, 12);
                }
                this.drawTriangle(15, 14);
                return;
            }
            case 2: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(4, 0);
                this.d(14, 0);
                this.d(14, 1);
                this.d(10, 5);
                this.d(10, 6);
                this.d(13, 9);
                this.d(13, 10);
                this.d(0, 10);
                this.d(0, 4);
                this.d(4, 0);
                return;
            }
            case 3: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(3, 0);
                this.d(5, 0);
                this.d(7, 2);
                this.d(9, 2);
                this.d(11, 0);
                this.d(13, 0);
                this.d(14, 1);
                this.d(15, 2);
                this.d(15, 4);
                this.d(14, 5);
                this.d(14, 6);
                this.d(12, 8);
                this.d(11, 8);
                this.d(10, 9);
                this.d(9, 9);
                this.d(8, 10);
                this.d(5, 10);
                this.d(3, 8);
                this.d(2, 8);
                this.d(1, 7);
                this.d(1, 6);
                this.d(0, 5);
                this.d(0, 2);
                this.d(1, 1);
                this.d(2, 1);
                return;
            }
            case 4: {
                this.xOffset = x;
                this.yOffset = y;
                if (arrowMode) {
                    this.m(1, 14);
                    this.d(14, 1);
                    this.m(6, 5);
                    this.d(14, 1);
                    this.m(10, 9);
                    this.d(14, 1);
                    this.m(6, 5);
                    this.d(10, 9);
                } else {
                    this.m(0, 12);
                    this.d(17, 3);
                }
                this.drawTriangle(12, 14);
                return;
            }
            case 5: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(14, 6);
                this.d(11, 3);
                this.d(1, 3);
                this.d(1, 4);
                this.d(6, 9);
                this.d(2, 13);
                this.drawTriangle(12, 14);
                return;
            }
            case 6: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(16, 4);
                this.d(14, 6);
                this.d(12, 6);
                this.d(9, 3);
                this.d(8, 3);
                this.d(6, 7);
                this.d(2, 11);
                this.d(1, 11);
                this.drawTriangle(12, 14);
                return;
            }
            case 7: {
                this.xOffset = x;
                this.yOffset = y;
                if (multiPointMode) {
                    this.drawPoint(1, 3);
                    this.drawPoint(9, 1);
                    this.drawPoint(15, 5);
                    this.drawPoint(10, 11);
                    this.drawPoint(2, 12);
                } else {
                    this.m(1, 8);
                    this.d(6, 8);
                    this.d(6, 6);
                    this.d(10, 6);
                    this.d(10, 10);
                    this.d(6, 10);
                    this.d(6, 9);
                    this.m(8, 1);
                    this.d(8, 5);
                    this.m(11, 8);
                    this.d(15, 8);
                    this.m(8, 11);
                    this.d(8, 15);
                    this.m(8, 8);
                    this.d(8, 8);
                    g.setColor(Roi.getColor());
                    g.fillRect(x + 7, y + 7, 3, 3);
                }
                this.drawTriangle(14, 14);
                return;
            }
            case 8: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.dot(4, 0);
                this.m(2, 0);
                this.d(3, 1);
                this.d(4, 2);
                this.m(0, 0);
                this.d(1, 1);
                this.m(0, 2);
                this.d(1, 3);
                this.d(2, 4);
                this.dot(0, 4);
                this.m(3, 3);
                this.d(12, 12);
                return;
            }
            case 9: {
                this.xOffset = x + 2;
                this.yOffset = y + 1;
                this.m(0, 13);
                this.d(3, 13);
                this.m(1, 12);
                this.d(7, 0);
                this.d(12, 13);
                this.m(11, 13);
                this.d(14, 13);
                this.m(3, 8);
                this.d(10, 8);
                return;
            }
            case 11: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
                return;
            }
            case 12: {
                this.xOffset = x + 1;
                this.yOffset = y + 1;
                this.m(5, 14);
                this.d(2, 11);
                this.d(2, 10);
                this.d(0, 8);
                this.d(0, 7);
                this.d(1, 6);
                this.d(2, 6);
                this.d(4, 8);
                this.d(4, 6);
                this.d(3, 5);
                this.d(3, 4);
                this.d(2, 3);
                this.d(2, 2);
                this.d(3, 1);
                this.d(4, 1);
                this.d(5, 2);
                this.d(5, 3);
                this.m(6, 5);
                this.d(6, 1);
                this.d(7, 0);
                this.d(8, 0);
                this.d(9, 1);
                this.d(9, 5);
                this.m(9, 1);
                this.d(11, 1);
                this.d(12, 2);
                this.d(12, 6);
                this.m(13, 4);
                this.d(14, 3);
                this.d(15, 4);
                this.d(15, 7);
                this.d(14, 8);
                this.d(14, 10);
                this.d(13, 11);
                this.d(13, 12);
                this.d(12, 13);
                this.d(12, 14);
                return;
            }
            case 13: {
                this.xOffset = x;
                this.yOffset = y;
                g.setColor(foregroundColor);
                this.m(12, 2);
                this.d(14, 2);
                this.m(11, 3);
                this.d(15, 3);
                this.m(11, 4);
                this.d(15, 4);
                this.m(8, 5);
                this.d(15, 5);
                this.m(9, 6);
                this.d(14, 6);
                this.m(10, 7);
                this.d(12, 7);
                this.d(12, 9);
                this.m(8, 7);
                this.d(2, 13);
                this.d(2, 15);
                this.d(4, 15);
                this.d(11, 8);
                g.setColor(backgroundColor);
                this.m(0, 0);
                this.d(16, 0);
                this.d(16, 16);
                this.d(0, 16);
                this.d(0, 0);
                return;
            }
            case 14: {
                this.xOffset = x + 1;
                this.yOffset = y + 2;
                this.m(0, 11);
                this.d(11, 0);
                this.m(0, 11);
                this.d(15, 11);
                this.m(10, 11);
                this.d(10, 8);
                this.m(9, 7);
                this.d(9, 6);
                this.dot(8, 5);
                return;
            }
        }
    }

    void drawTriangle(int x, int y) {
        this.g.setColor(this.triangleColor);
        this.xOffset += x;
        this.yOffset += y;
        this.m(0, 0);
        this.d(4, 0);
        this.m(1, 1);
        this.d(3, 1);
        this.dot(2, 2);
    }

    void drawPoint(int x, int y) {
        this.g.setColor(this.toolColor);
        this.m(x - 2, y);
        this.d(x + 2, y);
        this.m(x, y - 2);
        this.d(x, y + 2);
        this.g.setColor(Roi.getColor());
        this.dot(x, y);
    }

    void drawIcon(Graphics g, int tool, int x, int y) {
        if (null == g) {
            return;
        }
        this.icon = this.icon = this.icons[tool];
        int length = this.icon.length();
        this.pc = 0;
        block12: do {
            char command = this.icon.charAt(this.pc++);
            if (this.pc >= length) break;
            switch (command) {
                case 'B': {
                    x += this.v();
                    y += this.v();
                    break;
                }
                case 'R': {
                    g.drawRect(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'F': {
                    g.fillRect(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'O': {
                    g.drawOval(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'o': {
                    g.fillOval(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'C': {
                    g.setColor(new Color(this.v() * 16, this.v() * 16, this.v() * 16));
                    break;
                }
                case 'L': {
                    g.drawLine(x + this.v(), y + this.v(), x + this.v(), y + this.v());
                    break;
                }
                case 'D': {
                    g.fillRect(x + this.v(), y + this.v(), 1, 1);
                    break;
                }
                case 'P': {
                    int y2;
                    int x2;
                    int x1 = x + this.v();
                    int y1 = y + this.v();
                    while ((x2 = this.v()) != 0 && (y2 = this.v()) != 0) {
                        g.drawLine(x1, y1, x2 += x, y2 += y);
                        x1 = x2;
                        y1 = y2;
                    }
                    continue block12;
                }
                case 'T': {
                    int x2 = x + this.v();
                    int y2 = y + this.v();
                    int size = this.v() * 10 + this.v();
                    char[] c = new char[]{this.pc < this.icon.length() ? (char)this.icon.charAt(this.pc++) : (char)'e'};
                    g.setFont(new Font("SansSerif", 1, size));
                    g.drawString(new String(c), x2, y2);
                    break;
                }
            }
        } while (this.pc < length);
        if (this.menus[tool] != null && this.menus[tool].getItemCount() > 0) {
            this.xOffset = x;
            this.yOffset = y;
            this.drawTriangle(14, 14);
        }
    }

    int v() {
        if (this.pc >= this.icon.length()) {
            return 0;
        }
        char c = this.icon.charAt(this.pc++);
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    private void showMessage(int tool) {
        if (tool >= 10 && tool <= 22 && this.names[tool] != null) {
            String name = this.names[tool];
            int index = name.indexOf("Action Tool");
            if (index != -1) {
                name = name.substring(0, index);
            } else {
                index = name.indexOf("Menu Tool");
                if (index != -1) {
                    name = name.substring(0, index + 4);
                }
            }
            IJ.showStatus(name);
            return;
        }
        String hint = " (right click to switch)";
        switch (tool) {
            case 0: {
                if (roundRectMode) {
                    IJ.showStatus("Rectangular or *rounded rectangular* selections" + hint);
                } else {
                    IJ.showStatus("*Rectangular* or rounded rectangular selections" + hint);
                }
                return;
            }
            case 1: {
                if (brushEnabled) {
                    IJ.showStatus("Elliptical or *brush* selections" + hint);
                } else {
                    IJ.showStatus("*Elliptical* or brush selections" + hint);
                }
                return;
            }
            case 2: {
                IJ.showStatus("Polygon selections");
                return;
            }
            case 3: {
                IJ.showStatus("Freehand selections");
                return;
            }
            case 4: {
                if (arrowMode) {
                    IJ.showStatus("Arrow tool" + hint);
                } else {
                    IJ.showStatus("Straight line selections (right click for other types)");
                }
                return;
            }
            case 5: {
                IJ.showStatus("Segmented line selections" + hint);
                return;
            }
            case 6: {
                IJ.showStatus("Freehand line selections" + hint);
                return;
            }
            case 7: {
                if (multiPointMode) {
                    IJ.showStatus("Point or *multi-point* selections" + hint);
                } else {
                    IJ.showStatus("*Point* or multi-point selections" + hint);
                }
                return;
            }
            case 8: {
                IJ.showStatus("Wand (tracing) tool");
                return;
            }
            case 9: {
                IJ.showStatus("Text tool");
                TextRoi.recordSetFont();
                return;
            }
            case 11: {
                IJ.showStatus("Magnifying glass (or use \"+\" and \"-\" keys)");
                return;
            }
            case 12: {
                IJ.showStatus("Scrolling tool (or press space bar and drag)");
                return;
            }
            case 13: {
                IJ.showStatus("Color picker (" + foregroundColor.getRed() + "," + foregroundColor.getGreen() + "," + foregroundColor.getBlue() + ")");
                return;
            }
            case 14: {
                IJ.showStatus("Angle tool");
                return;
            }
        }
        IJ.showStatus("ImageJ " + IJ.getVersion() + " / Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " (64-bit)" : " (32-bit)"));
    }

    private void m(int x, int y) {
        this.x = this.xOffset + x;
        this.y = this.yOffset + y;
    }

    private void d(int x, int y) {
        this.g.drawLine(this.x, this.y, x += this.xOffset, y += this.yOffset);
        this.x = x;
        this.y = y;
    }

    private void dot(int x, int y) {
        this.g.fillRect(x + this.xOffset, y + this.yOffset, 1, 1);
    }

    private void resetButtons() {
        for (int i = 0; i < 23; ++i) {
            this.down[i] = false;
        }
    }

    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        this.drawButtons(g);
    }

    public boolean setTool(String name) {
        name = name.toLowerCase(Locale.US);
        boolean ok = true;
        if (name.indexOf("round") != -1) {
            roundRectMode = true;
            this.setTool(0);
        } else if (name.indexOf("rect") != -1) {
            roundRectMode = false;
            this.setTool(0);
        } else if (name.indexOf("ellip") != -1 || name.indexOf("oval") != -1) {
            brushEnabled = false;
            this.setTool(1);
        } else if (name.indexOf("brush") != -1) {
            brushEnabled = true;
            this.setTool(1);
        } else if (name.indexOf("polygon") != -1) {
            this.setTool(2);
        } else if (name.indexOf("polyline") != -1) {
            this.setTool(5);
        } else if (name.indexOf("freeline") != -1) {
            this.setTool(6);
        } else if (name.indexOf("line") != -1) {
            arrowMode = false;
            this.setTool(4);
        } else if (name.indexOf("arrow") != -1) {
            arrowMode = true;
            this.setTool(4);
        } else if (name.indexOf("free") != -1) {
            this.setTool(3);
        } else if (name.indexOf("multi") != -1) {
            multiPointMode = true;
            Prefs.multiPointMode = true;
            this.setTool(7);
        } else if (name.indexOf("point") != -1) {
            multiPointMode = false;
            Prefs.multiPointMode = false;
            this.setTool(7);
        } else if (name.indexOf("wand") != -1) {
            this.setTool(8);
        } else if (name.indexOf("text") != -1) {
            this.setTool(9);
        } else if (name.indexOf("hand") != -1) {
            this.setTool(12);
        } else if (name.indexOf("zoom") != -1) {
            this.setTool(11);
        } else if (name.indexOf("dropper") != -1 || name.indexOf("color") != -1) {
            this.setTool(13);
        } else if (name.indexOf("angle") != -1) {
            this.setTool(14);
        } else {
            ok = false;
        }
        return ok;
    }

    public static String getToolName() {
        String name = instance.getName(current);
        if (current >= 10 && current <= 22 && Toolbar.instance.names[current] != null) {
            name = Toolbar.instance.names[current];
        }
        return name != null ? name : "";
    }

    String getName(int id) {
        switch (id) {
            case 0: {
                return roundRectMode ? "roundrect" : "rectangle";
            }
            case 1: {
                return brushEnabled ? "brush" : "oval";
            }
            case 2: {
                return "polygon";
            }
            case 3: {
                return "freehand";
            }
            case 4: {
                return arrowMode ? "arrow" : "line";
            }
            case 5: {
                return "polyline";
            }
            case 6: {
                return "freeline";
            }
            case 14: {
                return "angle";
            }
            case 7: {
                return Prefs.multiPointMode ? "multipoint" : "point";
            }
            case 8: {
                return "wand";
            }
            case 9: {
                return "text";
            }
            case 12: {
                return "hand";
            }
            case 11: {
                return "zoom";
            }
            case 13: {
                return "dropper";
            }
        }
        return null;
    }

    public void setTool(int tool) {
        if (tool == current && tool != 1 && tool != 7 || tool < 0 || tool >= 22) {
            return;
        }
        if (tool == 10 || tool >= 15 && tool <= 21) {
            if (this.names[tool] == null) {
                this.names[tool] = "Spare tool";
            }
            if (this.names[tool].indexOf("Action Tool") != -1) {
                return;
            }
        }
        if (this.isLine(tool)) {
            this.lineType = tool;
        }
        this.setTool2(tool);
    }

    private void setTool2(int tool) {
        String name;
        if (!this.isValidTool(tool)) {
            return;
        }
        current = tool;
        this.down[Toolbar.current] = true;
        if (current != this.previous) {
            this.down[this.previous] = false;
        }
        Graphics g = this.getGraphics();
        if (Prefs.antialiasedTools) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawButton(g, this.previous);
        this.drawButton(g, current);
        if (null == g) {
            return;
        }
        g.dispose();
        this.showMessage(current);
        this.previous = current;
        if (Recorder.record && (name = this.getName(current)) != null) {
            Recorder.record("setTool", name);
        }
        if (IJ.isMacOSX()) {
            this.repaint();
        }
    }

    boolean isValidTool(int tool) {
        if (tool < 0 || tool >= 23) {
            return false;
        }
        return tool != 10 && (tool < 15 || tool > 22) || this.names[tool] != null;
    }

    public Color getColor() {
        return foregroundColor;
    }

    public void setColor(Color c) {
        if (c != null) {
            foregroundColor = c;
            this.drawButton(this.getGraphics(), 13);
        }
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public static void setForegroundColor(Color c) {
        if (c != null) {
            foregroundColor = c;
            Toolbar.repaintTool(13);
            if (!IJ.isMacro()) {
                Toolbar.setRoiColor(c);
            }
        }
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(Color c) {
        if (c != null) {
            backgroundColor = c;
            Toolbar.repaintTool(13);
        }
    }

    private static void setRoiColor(Color c) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi != null && roi.isDrawingTool()) {
            roi.setStrokeColor(c);
            imp.draw();
        }
    }

    public static int getBrushSize() {
        if (brushEnabled) {
            return brushSize;
        }
        return 0;
    }

    public static void setBrushSize(int size) {
        brushSize = size;
        if (brushSize < 5) {
            brushSize = 5;
        }
        Prefs.set(BRUSH_SIZE, brushSize);
    }

    public static int getRoundRectArcSize() {
        if (!roundRectMode) {
            return 0;
        }
        return arcSize;
    }

    public static void setRoundRectArcSize(int size) {
        Roi roi;
        if (size <= 0) {
            roundRectMode = false;
        } else {
            arcSize = size;
            Prefs.set(ARC_SIZE, arcSize);
        }
        Toolbar.repaintTool(0);
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi2 = roi = imp != null ? imp.getRoi() : null;
        if (roi != null && roi.getType() == 0) {
            roi.setRoundRectArcSize(roundRectMode ? arcSize : 0);
        }
    }

    public static boolean getMultiPointMode() {
        return multiPointMode;
    }

    public static int getButtonSize() {
        return 26;
    }

    static void repaintTool(int tool) {
        if (IJ.getInstance() != null) {
            Toolbar tb = Toolbar.getInstance();
            Graphics g = tb.getGraphics();
            if (Prefs.antialiasedTools) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            tb.drawButton(g, tool);
            if (g != null) {
                g.dispose();
            }
        }
    }

    int toolIndex(int tool) {
        switch (tool) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 9;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 5;
            }
            case 10: {
                return 12;
            }
        }
        return tool - 2;
    }

    int toolID(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return this.lineType;
            }
            case 5: {
                return 14;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 11;
            }
            case 10: {
                return 12;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 10;
            }
        }
        return index + 2;
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int newTool = 0;
        for (int i = 0; i < 21; ++i) {
            if (x <= i * 26 || x >= i * 26 + 26) continue;
            newTool = this.toolID(i);
        }
        if (newTool == 22) {
            this.showSwitchPopupMenu(e);
            return;
        }
        if (!this.isValidTool(newTool)) {
            return;
        }
        if (this.menus[newTool] != null && this.menus[newTool].getItemCount() > 0) {
            this.menus[newTool].show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        boolean doubleClick = newTool == current && System.currentTimeMillis() - this.mouseDownTime <= 650L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!doubleClick) {
            boolean isRightClick;
            this.mpPrevious = current;
            if (this.isMacroTool(newTool)) {
                String name = this.names[newTool];
                if (name.indexOf("Unused Tool") != -1) {
                    return;
                }
                if (name.indexOf("Action Tool") != -1) {
                    if (e.isPopupTrigger() || e.isMetaDown()) {
                        name = name.endsWith(" ") ? name : name + " ";
                        this.macroInstaller.runMacroTool(name + "Options");
                    } else {
                        this.drawTool(newTool, true);
                        IJ.wait(50);
                        this.drawTool(newTool, false);
                        this.runMacroTool(newTool);
                    }
                    return;
                }
                name = name.endsWith(" ") ? name : name + " ";
                this.macroInstaller.runMacroTool(name + "Selected");
            }
            this.setTool2(newTool);
            boolean bl = isRightClick = e.isPopupTrigger() || e.isMetaDown();
            if (current == 0 && isRightClick) {
                this.rectItem.setState(!roundRectMode);
                this.roundRectItem.setState(roundRectMode);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.rectPopup.show(e.getComponent(), x, this.y);
                this.mouseDownTime = 0L;
            }
            if (current == 1 && isRightClick) {
                this.ovalItem.setState(!brushEnabled);
                this.brushItem.setState(brushEnabled);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.ovalPopup.show(e.getComponent(), x, this.y);
                this.mouseDownTime = 0L;
            }
            if (current == 7 && isRightClick) {
                this.pointItem.setState(!multiPointMode);
                this.multiPointItem.setState(multiPointMode);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.pointPopup.show(e.getComponent(), x, this.y);
                this.mouseDownTime = 0L;
            }
            if (this.isLine(current) && isRightClick) {
                this.straightLineItem.setState(this.lineType == 4 && !arrowMode);
                this.polyLineItem.setState(this.lineType == 5);
                this.freeLineItem.setState(this.lineType == 6);
                this.arrowItem.setState(this.lineType == 4 && arrowMode);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.linePopup.show(e.getComponent(), x, this.y);
                this.mouseDownTime = 0L;
            }
            if (this.isMacroTool(current) && isRightClick) {
                String name = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.macroInstaller.runMacroTool(name + "Options");
            }
        } else {
            if (this.isMacroTool(current)) {
                String name = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.macroInstaller.runMacroTool(name + "Options");
                return;
            }
            ImagePlus imp = WindowManager.getCurrentImage();
            switch (current) {
                case 0: {
                    if (!roundRectMode) break;
                    this.showRoundRectDialog();
                    break;
                }
                case 1: {
                    this.showBrushDialog();
                    break;
                }
                case 11: {
                    ImageCanvas ic;
                    if (imp == null || (ic = imp.getCanvas()) == null) break;
                    ic.unzoom();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (current == 4 && arrowMode) {
                        IJ.doCommand("Arrow Tool...");
                        break;
                    }
                    IJ.runPlugIn("ij.plugin.frame.LineWidthAdjuster", "");
                    break;
                }
                case 7: {
                    if (multiPointMode) {
                        if (imp == null || imp.getRoi() == null) break;
                        IJ.doCommand("Add Selection...");
                        break;
                    }
                    IJ.doCommand("Point Tool...");
                    break;
                }
                case 8: {
                    IJ.doCommand("Wand Tool...");
                    break;
                }
                case 9: {
                    IJ.doCommand("Fonts...");
                    break;
                }
                case 13: {
                    IJ.doCommand("Color Picker...");
                    this.setTool2(this.mpPrevious);
                    break;
                }
            }
        }
    }

    void showSwitchPopupMenu(MouseEvent e) {
        int i;
        String[] list;
        String path = IJ.getDirectory("macros") + "toolsets/";
        if (path == null) {
            return;
        }
        boolean applet = IJ.getApplet() != null;
        File f = new File(path);
        if (!applet && f.exists() && f.isDirectory()) {
            list = f.list();
            if (list == null) {
                return;
            }
        } else {
            list = new String[]{};
        }
        boolean stackTools = false;
        for (i = 0; i < list.length; ++i) {
            if (!list[i].equals("Stack Tools.txt")) continue;
            stackTools = true;
            break;
        }
        this.switchPopup.removeAll();
        path = IJ.getDirectory("macros") + "StartupMacros.txt";
        f = new File(path);
        if (!applet && f.exists()) {
            this.addItem("Startup Macros");
        } else {
            this.addItem("StartupMacros*");
        }
        if (!stackTools) {
            this.addItem("Stack Tools*");
        }
        for (i = 0; i < list.length; ++i) {
            String name = list[i];
            if (name.endsWith(".txt")) {
                name = name.substring(0, name.length() - 4);
                this.addItem(name);
                continue;
            }
            if (!name.endsWith(".ijm")) continue;
            name = name.substring(0, name.length() - 4) + " ";
            this.addItem(name);
        }
        this.addItem("Help...");
        this.add(this.ovalPopup);
        if (IJ.isMacOSX()) {
            IJ.wait(10);
        }
        this.switchPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    void addItem(String name) {
        CheckboxMenuItem item = new CheckboxMenuItem(name, name.equals(this.currentSet));
        item.addItemListener(this);
        this.switchPopup.add(item);
    }

    void drawTool(int tool, boolean drawDown) {
        this.down[tool] = drawDown;
        Graphics g = this.getGraphics();
        if (!drawDown && Prefs.antialiasedTools) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawButton(g, tool);
        if (null == g) {
            return;
        }
        g.dispose();
    }

    boolean isLine(int tool) {
        return tool == 4 || tool == 5 || tool == 6;
    }

    public void restorePreviousTool() {
        this.setTool2(this.mpPrevious);
    }

    boolean isMacroTool(int tool) {
        return tool >= 10 && tool <= 22 && this.names[tool] != null && this.macroInstaller != null;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem item = (CheckboxMenuItem)e.getSource();
        if (item == this.rectItem || item == this.roundRectItem) {
            Roi roi;
            roundRectMode = item == this.roundRectItem;
            Toolbar.repaintTool(0);
            this.showMessage(0);
            ImagePlus imp = WindowManager.getCurrentImage();
            Roi roi2 = roi = imp != null ? imp.getRoi() : null;
            if (roi != null && roi.getType() == 0) {
                roi.setRoundRectArcSize(roundRectMode ? arcSize : 0);
            }
        } else if (item == this.ovalItem || item == this.brushItem) {
            brushEnabled = item == this.brushItem;
            Toolbar.repaintTool(1);
            this.showMessage(1);
        } else if (item == this.pointItem || item == this.multiPointItem) {
            Prefs.multiPointMode = multiPointMode = item == this.multiPointItem;
            Toolbar.repaintTool(7);
            this.showMessage(7);
        } else if (item == this.straightLineItem) {
            this.lineType = 4;
            arrowMode = false;
            this.setTool2(4);
            this.showMessage(4);
        } else if (item == this.polyLineItem) {
            this.lineType = 5;
            this.setTool2(5);
            this.showMessage(5);
        } else if (item == this.freeLineItem) {
            this.lineType = 6;
            this.setTool2(6);
            this.showMessage(6);
        } else if (item == this.arrowItem) {
            this.lineType = 4;
            arrowMode = true;
            this.setTool2(4);
            this.showMessage(4);
        } else {
            String label = item.getActionCommand();
            if (!label.equals("Help...")) {
                this.currentSet = label;
            }
            if (label.equals("Help...")) {
                IJ.showMessage("Tool Switcher", "Use this drop down menu to switch to macro tool\nsets located in the ImageJ/macros/toolsets folder,\nor to revert to the ImageJ/macros/StartupMacros\nset. The default tool sets, which have names\nending in '*', are loaded from ij.jar.\n \nHold the shift key down while selecting a tool\nset to view its source code.\n \nSeveral example tool sets are available at\n<http://rsb.info.nih.gov/ij/macros/toolsets/>.");
                return;
            }
            if (label.endsWith("*")) {
                MacroInstaller mi = new MacroInstaller();
                label = label.substring(0, label.length() - 1) + ".txt";
                String path = "/macros/" + label;
                if (IJ.shiftKeyDown()) {
                    String macros = mi.openFromIJJar(path);
                    Editor ed = new Editor();
                    ed.setSize(350, 300);
                    ed.create(label, macros);
                    IJ.setKeyUp(16);
                } else {
                    mi.installFromIJJar(path);
                }
            } else {
                String path = label.equals("Startup Macros") ? IJ.getDirectory("macros") + "StartupMacros.txt" : (label.endsWith(" ") ? IJ.getDirectory("macros") + "toolsets/" + label.substring(0, label.length() - 1) + ".ijm" : IJ.getDirectory("macros") + "toolsets/" + label + ".txt");
                try {
                    if (IJ.shiftKeyDown()) {
                        IJ.open(path);
                        IJ.setKeyUp(16);
                    } else {
                        new MacroInstaller().run(path);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        String cmd = e.getActionCommand();
        PopupMenu popup = (PopupMenu)item.getParent();
        int tool = -1;
        for (int i = 10; i < 23; ++i) {
            if (popup != this.menus[i]) continue;
            tool = i;
            break;
        }
        if (tool == -1) {
            return;
        }
        if (this.macroInstaller != null) {
            this.macroInstaller.runMenuTool(this.names[tool], cmd);
        }
    }

    public Dimension getPreferredSize() {
        return this.ps;
    }

    public Dimension getMinimumSize() {
        return this.ps;
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        x = this.toolID(x / 26);
        this.showMessage(x);
    }

    public int addTool(String toolTip) {
        int index = toolTip.indexOf(45);
        boolean hasIcon = index >= 0 && toolTip.length() - index > 4;
        int tool = -1;
        if (this.names[10] == null) {
            tool = 10;
        }
        if (tool == -1) {
            for (int i = 15; i <= 21; ++i) {
                if (this.names[i] != null) continue;
                tool = i;
                break;
            }
        }
        if (tool == -1) {
            return -1;
        }
        if (hasIcon) {
            this.icons[tool] = toolTip.substring(index + 1);
            this.names[tool] = index > 0 && toolTip.charAt(index - 1) == ' ' ? toolTip.substring(0, index - 1) : toolTip.substring(0, index);
        } else {
            if (toolTip.endsWith("-")) {
                toolTip = toolTip.substring(0, toolTip.length() - 1);
            } else if (toolTip.endsWith("- ")) {
                toolTip = toolTip.substring(0, toolTip.length() - 2);
            }
            this.names[tool] = toolTip;
        }
        if (tool == current && (this.names[tool].indexOf("Action Tool") != -1 || this.names[tool].indexOf("Unused Tool") != -1)) {
            this.setTool(0);
        }
        if (this.names[tool].endsWith(" Menu Tool")) {
            this.installMenu(tool);
        }
        return tool;
    }

    void installMenu(int tool) {
        Program pgm = this.macroInstaller.getProgram();
        Hashtable h = pgm.getMenus();
        if (h == null) {
            return;
        }
        String[] commands = (String[])h.get(this.names[tool]);
        if (commands == null) {
            return;
        }
        if (this.menus[tool] == null) {
            this.menus[tool] = new PopupMenu("");
            if (Menus.getFontSize() != 0) {
                this.menus[tool].setFont(Menus.getFont());
            }
            this.add(this.menus[tool]);
        } else {
            this.menus[tool].removeAll();
        }
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].equals("-")) {
                this.menus[tool].addSeparator();
                continue;
            }
            MenuItem mi = new MenuItem(commands[i]);
            mi.addActionListener(this);
            this.menus[tool].add(mi);
        }
        if (tool == current) {
            this.setTool(0);
        }
    }

    public void addMacroTool(String name, MacroInstaller macroInstaller, int id) {
        if (id == 0) {
            for (int i = 10; i < 22; ++i) {
                this.names[i] = null;
                this.icons[i] = null;
                if (this.menus[i] == null) continue;
                this.menus[i].removeAll();
            }
        }
        this.macroInstaller = macroInstaller;
        this.addTool(name);
    }

    void runMacroTool(int id) {
        if (this.macroInstaller != null) {
            this.macroInstaller.runMacroTool(this.names[id]);
        }
    }

    void showBrushDialog() {
        Roi roi;
        GenericDialog gd = new GenericDialog("Selection Brush");
        gd.addCheckbox("Enable Selection Brush", brushEnabled);
        gd.addNumericField("           Size:", brushSize, 0, 4, "pixels");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        brushEnabled = gd.getNextBoolean();
        brushSize = (int)gd.getNextNumber();
        Toolbar.repaintTool(1);
        ImagePlus img = WindowManager.getCurrentImage();
        Roi roi2 = roi = img != null ? img.getRoi() : null;
        if (roi != null && roi.getType() == 1 && brushEnabled) {
            img.killRoi();
        }
        Prefs.set(BRUSH_SIZE, brushSize);
    }

    void showRoundRectDialog() {
        GenericDialog gd = new GenericDialog("Rounded Rectangle");
        gd.addNumericField("Corner arc size:", arcSize, 0, 4, "pixels");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        Toolbar.setRoundRectArcSize((int)gd.getNextNumber());
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
        multiPointMode = Prefs.multiPointMode;
        brushSize = (int)Prefs.get(BRUSH_SIZE, 15.0);
        arcSize = (int)Prefs.get(ARC_SIZE, 20.0);
    }
}

