/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;

public class PointRoi
extends PolygonRoi {
    private static Font font;
    private static int fontSize;
    private double saveMag;

    public PointRoi(int[] ox, int[] oy, int points) {
        super(ox, oy, points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(Polygon poly) {
        this(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public PointRoi(int ox, int oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(int sx, int sy, ImagePlus imp) {
        super(PointRoi.makeXArray(sx, imp), PointRoi.makeYArray(sy, imp), 1, 10);
        this.setImage(imp);
        this.width = 1;
        this.height = 1;
        if (imp != null) {
            imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        if (Recorder.record && !Recorder.scriptMode()) {
            Recorder.record("makePoint", this.x, this.y);
        }
    }

    static int[] makeXArray(int value, ImagePlus imp) {
        int[] array = new int[]{imp != null ? imp.getCanvas().offScreenX(value) : value};
        return array;
    }

    static int[] makeYArray(int value, ImagePlus imp) {
        int[] array = new int[]{imp != null ? imp.getCanvas().offScreenY(value) : value};
        return array;
    }

    void handleMouseMove(int ox, int oy) {
    }

    protected void handleMouseUp(int sx, int sy) {
        super.handleMouseUp(sx, sy);
        this.modifyRoi();
    }

    public void draw(Graphics g) {
        this.updatePolygon();
        if (this.ic != null) {
            this.mag = this.ic.getMagnification();
        }
        int size2 = 2;
        if (!Prefs.noPointLabels && (this.nPoints > 1 || Toolbar.getMultiPointMode())) {
            fontSize = 9;
            if (this.mag > 1.0) {
                fontSize = (int)(((this.mag - 1.0) / 3.0 + 1.0) * 9.0);
            }
            if (fontSize > 18) {
                fontSize = 18;
            }
            if (font == null || this.mag != this.saveMag) {
                font = new Font("SansSerif", 0, fontSize);
            }
            g.setFont(font);
            if (fontSize > 9) {
                Java2.setAntialiasedText(g, true);
            }
            this.saveMag = this.mag;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.drawPoint(g, this.xp2[i] - size2, this.yp2[i] - size2, i + 1);
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawPoint(Graphics g, int x, int y, int n) {
        g.setColor(this.fillColor != null ? this.fillColor : Color.white);
        g.drawLine(x - 4, y + 2, x + 8, y + 2);
        g.drawLine(x + 2, y - 4, x + 2, y + 8);
        g.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        g.fillRect(x + 1, y + 1, 3, 3);
        if (!Prefs.noPointLabels && (this.nPoints > 1 || Toolbar.getMultiPointMode())) {
            g.drawString("" + n, x + 6, y + fontSize + 4);
        }
        g.setColor(Color.black);
        g.drawRect(x, y, 4, 4);
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(Analyzer.markWidth);
        for (int i = 0; i < this.nPoints; ++i) {
            ip.moveTo(this.x + this.xp[i], this.y + this.yp[i]);
            ip.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
        }
    }

    public PointRoi addPoint(int x, int y) {
        Polygon poly = this.getPolygon();
        poly.addPoint(x, y);
        PointRoi p = new PointRoi(poly.xpoints, poly.ypoints, poly.npoints);
        IJ.showStatus("count=" + poly.npoints);
        return p;
    }

    public PointRoi subtractPoints(Roi roi) {
        Polygon points = this.getPolygon();
        Polygon poly = roi.getPolygon();
        Polygon points2 = new Polygon();
        for (int i = 0; i < points.npoints; ++i) {
            if (poly.contains(points.xpoints[i], points.ypoints[i])) continue;
            points2.addPoint(points.xpoints[i], points.ypoints[i]);
        }
        if (points2.npoints == 0) {
            return null;
        }
        return new PointRoi(points2.xpoints, points2.ypoints, points2.npoints);
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        for (int i = 0; i < this.nPoints; ++i) {
            ((ImageProcessor)mask).putPixel(this.xp[i], this.yp[i], 255);
        }
        this.cachedMask = mask;
        return mask;
    }

    public boolean contains(int x, int y) {
        for (int i = 0; i < this.nPoints; ++i) {
            if (x != this.x + this.xp[i] || y != this.y + this.yp[i]) continue;
            return true;
        }
        return false;
    }

    static {
        fontSize = 9;
    }
}

