/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class OvalRoi
extends Roi {
    public OvalRoi(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.type = 1;
    }

    public OvalRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        this.type = 1;
    }

    public OvalRoi(int x, int y, int width, int height, ImagePlus imp) {
        this(x, y, width, height);
        this.setImage(imp);
    }

    protected void moveHandle(int sx, int sy) {
        double asp;
        if (this.clipboard != null) {
            return;
        }
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        int x1 = this.x;
        int y1 = this.y;
        int x2 = this.x + this.width;
        int y2 = this.y + this.height;
        int xc = this.x + this.width / 2;
        int yc = this.y + this.height / 2;
        int w2 = (int)(0.14645 * (double)this.width);
        int h2 = (int)(0.14645 * (double)this.height);
        if (this.width > 7 && this.height > 7) {
            this.asp_bk = asp = (double)this.width / (double)this.height;
        } else {
            asp = this.asp_bk;
        }
        switch (this.activeHandle) {
            case 0: {
                this.x = ox - w2;
                this.y = oy - h2;
                break;
            }
            case 1: {
                this.y = oy;
                break;
            }
            case 2: {
                x2 = ox + w2;
                this.y = oy - h2;
                break;
            }
            case 3: {
                x2 = ox;
                break;
            }
            case 4: {
                x2 = ox + w2;
                y2 = oy + h2;
                break;
            }
            case 5: {
                y2 = oy;
                break;
            }
            case 6: {
                this.x = ox - w2;
                y2 = oy + h2;
                break;
            }
            case 7: {
                this.x = ox;
            }
        }
        if (this.x < x2) {
            this.width = x2 - this.x;
        } else {
            this.width = 1;
            this.x = x2;
        }
        if (this.y < y2) {
            this.height = y2 - this.y;
        } else {
            this.height = 1;
            this.y = y2;
        }
        if (this.center) {
            switch (this.activeHandle) {
                case 0: {
                    this.width = (xc - this.x) * 2;
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 1: {
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 2: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 3: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    break;
                }
                case 4: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 5: {
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 6: {
                    this.width = (xc - this.x) * 2;
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 7: {
                    this.width = (xc - this.x) * 2;
                }
            }
            if (this.x >= x2) {
                this.width = 1;
                this.x = x2 = xc;
            }
            if (this.y >= y2) {
                this.height = 1;
                this.y = y2 = yc;
            }
        }
        if (this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = this.height;
            } else {
                this.height = this.width;
            }
            if (this.center) {
                this.x = xc - this.width / 2;
                this.y = yc - this.height / 2;
            }
            if (this.x >= x2) {
                this.width = 1;
                this.x = x2 = xc;
            }
            if (this.y >= y2) {
                this.height = 1;
                this.y = y2 = yc;
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = x2 - this.width;
                    this.y = y2 - this.height;
                    break;
                }
                case 1: {
                    this.x = xc - this.width / 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 2: {
                    this.y = y2 - this.height;
                    break;
                }
                case 3: {
                    this.y = yc - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = xc - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = x2 - this.width;
                    break;
                }
                case 7: {
                    this.y = yc - this.height / 2;
                    this.x = x2 - this.width;
                }
            }
        }
        if (this.aspect && !this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = (int)Math.rint((double)this.height * asp);
            } else {
                this.height = (int)Math.rint((double)this.width / asp);
            }
            if (this.center) {
                this.x = xc - this.width / 2;
                this.y = yc - this.height / 2;
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = x2 - this.width;
                    this.y = y2 - this.height;
                    break;
                }
                case 1: {
                    this.x = xc - this.width / 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 2: {
                    this.y = y2 - this.height;
                    break;
                }
                case 3: {
                    this.y = yc - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = xc - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = x2 - this.width;
                    break;
                }
                case 7: {
                    this.y = yc - this.height / 2;
                    this.x = x2 - this.width;
                }
            }
            if (this.width < 8) {
                if (this.width < 1) {
                    this.width = 1;
                }
                this.height = (int)Math.rint((double)this.width / this.asp_bk);
            }
            if (this.height < 8) {
                if (this.height < 1) {
                    this.height = 1;
                }
                this.width = (int)Math.rint((double)this.height * this.asp_bk);
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.cachedMask = null;
    }

    public void draw(Graphics g) {
        Color color;
        if (this.ic == null) {
            return;
        }
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        g.setColor(color);
        this.mag = this.ic.getMagnification();
        int sw = (int)((double)this.width * this.mag);
        int sh = (int)((double)this.height * this.mag);
        int sw2 = (int)(0.14645 * (double)this.width * this.mag);
        int sh2 = (int)(0.14645 * (double)this.height * this.mag);
        int sx1 = this.ic.screenX(this.x);
        int sy1 = this.ic.screenY(this.y);
        int sx2 = sx1 + sw / 2;
        int sy2 = sy1 + sh / 2;
        int sx3 = sx1 + sw;
        int sy3 = sy1 + sh;
        Graphics2D g2d = (Graphics2D)g;
        if (this.stroke != null) {
            g2d.setStroke(this.getScaledStroke());
        }
        if (this.fillColor != null) {
            g.fillOval(sx1, sy1, sw, sh);
        } else {
            g.drawOval(sx1, sy1, sw, sh);
        }
        if (this.state != 0 && this.clipboard == null && !this.overlay) {
            int size2 = 2;
            this.drawHandle(g, sx1 + sw2 - size2, sy1 + sh2 - size2);
            this.drawHandle(g, sx3 - sw2 - size2, sy1 + sh2 - size2);
            this.drawHandle(g, sx3 - sw2 - size2, sy3 - sh2 - size2);
            this.drawHandle(g, sx1 + sw2 - size2, sy3 - sh2 - size2);
            this.drawHandle(g, sx2 - size2, sy1 - size2);
            this.drawHandle(g, sx3 - size2, sy2 - size2);
            this.drawHandle(g, sx2 - size2, sy3 - size2);
            this.drawHandle(g, sx1 - size2, sy2 - size2);
        }
        this.drawPreviousRoi(g);
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        if (this.state != 3) {
            this.showStatus();
        }
    }

    public void drawPixels(ImageProcessor ip) {
        Polygon p = this.getPolygon();
        if (p.npoints > 0) {
            int saveWidth = ip.getLineWidth();
            if (this.getStrokeWidth() > 1.0f) {
                ip.setLineWidth(Math.round(this.getStrokeWidth()));
            }
            ip.drawPolygon(p);
            ip.setLineWidth(saveWidth);
        }
        if (Line.getWidth() > 1 || this.getStrokeWidth() > 1.0f) {
            this.updateFullWindow = true;
        }
    }

    public Polygon getPolygon() {
        ImageProcessor mask = this.getMask();
        Wand wand = new Wand(mask);
        wand.autoOutline(this.width / 2, this.height / 2, 255, 255);
        int i = 0;
        while (i < wand.npoints) {
            int n = i;
            wand.xpoints[n] = wand.xpoints[n] + this.x;
            int n2 = i++;
            wand.ypoints[n2] = wand.ypoints[n2] + this.y;
        }
        return new Polygon(wand.xpoints, wand.ypoints, wand.npoints);
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        double twoDx = 2 * x - (2 * this.x + this.width - 1);
        double twoRx = this.width;
        double twoDy = 2 * y - (2 * this.y + this.height - 1);
        double twoRy = this.height;
        return twoDx * twoDx / (twoRx * twoRx) + twoDy * twoDy / (twoRy * twoRy) < 1.0;
    }

    public int isHandle(int sx, int sy) {
        if (this.clipboard != null || this.ic == null) {
            return -1;
        }
        double mag = this.ic.getMagnification();
        int size = 8;
        int halfSize = size / 2;
        int sx1 = this.ic.screenX(this.x) - halfSize;
        int sy1 = this.ic.screenY(this.y) - halfSize;
        int sx3 = this.ic.screenX(this.x + this.width) - halfSize;
        int sy3 = this.ic.screenY(this.y + this.height) - halfSize;
        int sx2 = sx1 + (sx3 - sx1) / 2;
        int sy2 = sy1 + (sy3 - sy1) / 2;
        int sw2 = (int)(0.14645 * (double)(sx3 - sx1));
        int sh2 = (int)(0.14645 * (double)(sy3 - sy1));
        if (sx >= sx1 + sw2 && sx <= sx1 + sw2 + size && sy >= sy1 + sh2 && sy <= sy1 + sh2 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy1 && sy <= sy1 + size) {
            return 1;
        }
        if (sx >= sx3 - sw2 && sx <= sx3 - sw2 + size && sy >= sy1 + sh2 && sy <= sy1 + sh2 + size) {
            return 2;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy2 && sy <= sy2 + size) {
            return 3;
        }
        if (sx >= sx3 - sw2 && sx <= sx3 - sw2 + size && sy >= sy3 - sh2 && sy <= sy3 - sh2 + size) {
            return 4;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy3 && sy <= sy3 + size) {
            return 5;
        }
        if (sx >= sx1 + sw2 && sx <= sx1 + sw2 + size && sy >= sy3 - sh2 && sy <= sy3 - sh2 + size) {
            return 6;
        }
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy2 && sy <= sy2 + size) {
            return 7;
        }
        return -1;
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        double a = (double)this.width / 2.0;
        double b = (double)this.height / 2.0;
        double a2 = a * a;
        double b2 = b * b;
        a -= 0.5;
        b -= 0.5;
        byte[] pixels = (byte[])((ImageProcessor)mask).getPixels();
        for (int y = 0; y < this.height; ++y) {
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                double xx = (double)x - a;
                double yy = (double)y - b;
                if (!(xx * xx / a2 + yy * yy / b2 <= 1.0)) continue;
                pixels[offset + x] = -1;
            }
        }
        this.cachedMask = mask;
        return mask;
    }

    public double getLength() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        return Math.PI * ((double)this.width * pw + (double)this.height * ph) / 2.0;
    }
}

