(defproject im.chit/purnam.native "0.4.4"
  :description "Native objects and arrays functions for clojurescript"
  :url "http://www.github.com/purnam/purnam.native/"
  :license {:name "The MIT License"
            :url "http://opensource.org/licencses/MIT"}
  :dependencies [[org.clojure/clojure "1.6.0"]]
  :profiles {:dev {:dependencies [[org.clojure/clojurescript "0.0-2342"]
                                  [im.chit/purnam.test "0.4.4"]
                                  [midje "1.6.3"]]
                   :plugins [[lein-ancient "0.5.5"]
                             [lein-cljsbuild "1.0.3"]]}}
  :documentation {:files {"doc/index"
                          {:input "test/midje_doc/purnam_native_guide.clj"
                           :title "purnam.native"
                           :sub-title "Native objects and arrays functions for clojurescript"
                           :author "Chris Zheng"
                           :email "z@caudate.me"
                           :tracking "UA-31320512-2"}}}
  :cljsbuild {:builds [{:source-paths ["src" "test"]
                        :compiler {:output-to "target/purnam.native.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}]})