(defproject im.chit/lucid.publish "1.2.0"
  :description "tools for code clarity"
  :url "https://www.github.com/zcaudate/lucidity"
  :license {:name "The MIT License"
            :url "http://http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" ":exit"]}
  :dependencies [[org.clojure/clojure "1.8.0"] [im.chit/hara.io.project "2.4.5"] [stencil/stencil "0.5.0"] [hiccup/hiccup "1.0.5"] [im.chit/hara.test "2.4.5"] [im.chit/hara.io.file "2.4.5"] [im.chit/hara.data.diff "2.4.5"] [markdown-clj/markdown-clj "0.9.89"] [rewrite-clj/rewrite-clj "0.5.2"] [im.chit/hara.string "2.4.5"] [im.chit/lucid.core.code "1.2.0"] [im.chit/lucid.query "1.2.0"]]
  :deploy-repositories {"clojars" {:sign-releases false}}                 
  :publish {:theme  "stark"
            
            :template {:site   "lucid"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}
            
            :files {"index"
                    {:template "home.html"
                     :input "test/documentation/home_lucidity.clj"
                     :title "lucidity"
                     :subtitle "tools for code clarity"}
                    "lucid-core"
                    {:input "test/documentation/lucid_core.clj"
                     :title "core"
                     :subtitle "functions for the code environment"}
                    "lucid-mind"
                    {:input "test/documentation/lucid_mind.clj"
                     :title "mind"
                     :subtitle "contemplative reflection for the jvm"}
                    "lucid-publish"
                    {:input "test/documentation/lucid_publish.clj"
                     :title "publish"
                     :subtitle "generate documentation from code"}
                    "lucid-query"
                    {:input "test/documentation/lucid_query.clj"
                     :title "query"
                     :subtitle "intuitive search for code"}
                    "lucid-space"
                    {:input "test/documentation/lucid_space.clj"
                     :title "space"
                     :subtitle "management of project externals"}
                    "lucid-unit"
                    {:input "test/documentation/lucid_unit.clj"
                     :title "unit"
                     :subtitle "metadata through unit tests"}}
   
            :link {:auto-tag    true
                   :auto-number  true}}
   
   

  :java-source-paths ["example/java"]
  :jar-exclusions [#"^test\..+\.class"] :scm {:connection "scm:git:git://github.com/zcaudate/lucidity.git", :developerConnection "scm:git:ssh://git@github.com/zcaudate/lucidity.git", :tag "a4fd0f1994c0e74233f3a8e2cec2f2cb8e48ddc1\n", :url "https://github.com/zcaudate/lucidity"})
