(defproject im.chit/lucid.core.namespace "1.3.0"
  :description "tools for code clarity"
  :url "https://www.github.com/zcaudate/lucidity"
  :license {:name "The MIT License"
            :url "http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" ":exit"]}
  :dependencies [[org.clojure/clojure "1.8.0"]]
  
  :publish {:theme  "stark"
            
            :template {:site   "lucid"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}
            
            :files {"index"
                    {:template "home.html"
                     :input "test/documentation/home_lucidity.clj"
                     :title "lucidity"
                     :subtitle "tools for code clarity"}
                    "lucid-aether"
                    {:input "test/documentation/lucid_aether.clj"
                     :title "aether"
                     :subtitle "wrapper for org.eclipse.aether"}
                    "lucid-core"
                    {:input "test/documentation/lucid_core.clj"
                     :title "core"
                     :subtitle "functions for the code environment"}
                    "lucid-distribute"
                    {:input "test/documentation/lucid_distribute.clj"
                     :title "distribute"
                     :subtitle "code repackaging and distribution"}
                    "lucid-mind"
                    {:input "test/documentation/lucid_mind.clj"
                     :title "mind"
                     :subtitle "contemplative reflection for the jvm"}
                    "lucid-package"
                    {:input "test/documentation/lucid_package.clj"
                     :title "package"
                     :subtitle "project packaging and dependencies"}
                    "lucid-publish"
                    {:input "test/documentation/lucid_publish.clj"
                     :title "publish"
                     :subtitle "generate documentation from code"}
                    "lucid-query"
                    {:input "test/documentation/lucid_query.clj"
                     :title "query"
                     :subtitle "intuitive search for code"}
                    "lucid-unit"
                    {:input "test/documentation/lucid_unit.clj"
                     :title "unit"
                     :subtitle "metadata through unit tests"}}}
  
   
  
    
  
  :java-source-paths ["java"]
  
  :jar-exclusions [#"^test\..+\.class"])
