(defproject im.chit/hara "2.2.14"
  :description "patterns and utilities"
  :url "https://github.com/zcaudate/hara"
  :license {:name "The MIT License"
            :url "http://http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.6.0"] [im.chit/hara.common.watch "2.2.14"] [im.chit/hara.concurrent.procedure "2.2.14"] [im.chit/hara.object "2.2.14"] [im.chit/hara.string "2.2.14"] [im.chit/hara.protocol.map "2.2.14"] [im.chit/hara.namespace.eval "2.2.14"] [im.chit/hara.protocol.state "2.2.14"] [im.chit/hara.expression.compile "2.2.14"] [im.chit/hara.group "2.2.14"] [im.chit/hara.class "2.2.14"] [im.chit/hara.common.string "2.2.14"] [im.chit/hara.protocol.time "2.2.14"] [im.chit/hara.concurrent.notification "2.2.14"] [im.chit/hara.data.record "2.2.14"] [im.chit/hara.data.path "2.2.14"] [im.chit/hara.component "2.2.14"] [im.chit/hara.common.hash "2.2.14"] [im.chit/hara.extend.abstract "2.2.14"] [im.chit/hara.namespace.resolve "2.2.14"] [im.chit/hara.namespace.import "2.2.14"] [im.chit/hara.reflect "2.2.14"] [im.chit/hara.extend.all "2.2.14"] [im.chit/hara.expression "2.2.14"] [im.chit/hara.event "2.2.14"] [im.chit/hara.concurrent.propagate "2.2.14"] [im.chit/hara.protocol.string "2.2.14"] [im.chit/hara.sort.topological "2.2.14"] [im.chit/hara.sort "2.2.14"] [im.chit/hara.protocol.constructor "2.2.14"] [im.chit/hara.data.complex "2.2.14"] [im.chit/hara.common.pretty "2.2.14"] [im.chit/hara.string.case "2.2.14"] [im.chit/hara.class.checks "2.2.14"] [im.chit/hara.sort.hierarchical "2.2.14"] [im.chit/hara.common.state "2.2.14"] [im.chit/hara.common.primitives "2.2.14"] [im.chit/hara.class.inheritance "2.2.14"] [im.chit/hara.protocol.data "2.2.14"] [im.chit/hara.expression.load "2.2.14"] [im.chit/hara.common.error "2.2.14"] [im.chit/hara.data.diff "2.2.14"] [im.chit/hara.time "2.2.14"] [im.chit/hara.protocol.watch "2.2.14"] [im.chit/hara.function "2.2.14"] [im.chit/hara.io.watch "2.2.14"] [im.chit/hara.function.dispatch "2.2.14"] [im.chit/hara.data.seq "2.2.14"] [im.chit/hara.data.nested "2.2.14"] [im.chit/hara.data.map "2.2.14"] [im.chit/hara.concurrent.ova "2.2.14"] [im.chit/hara.common.checks "2.2.14"] [im.chit/hara.expression.shorthand "2.2.14"] [im.chit/hara.io.scheduler "2.2.14"] [im.chit/hara.concurrent "2.2.14"] [im.chit/hara.extend "2.2.14"] [im.chit/hara.expression.form "2.2.14"] [im.chit/hara.namespace "2.2.14"] [im.chit/hara.string.path "2.2.14"] [im.chit/hara.data "2.2.14"] [im.chit/hara.concurrent.latch "2.2.14"] [im.chit/hara.data.combine "2.2.14"] [im.chit/hara.common "2.2.14"] [im.chit/hara.function.args "2.2.14"]]
   
  :documentation {:site   "hara"
                  :output "docs"
                  :description "patterns and utilities"
                  :tracking "UA-31320512-2"
                  :owners [{:name    "Chris Zheng"
                            :email   "z@caudate.me"
                            :website "http://z.caudate.me"}]
                  :template {:path "template"
                             :copy ["assets/css" "assets/js"]
                             :defaults {:template "article-basic.html"
                                        :navbar  [:file "partials/navbar.html"]
                                        :sidebar [:file "partials/sidebar.html"]
                                        :footer  [:file "partials/footer.html"]
                                        :dependencies [:file "partials/deps-web.html"]
                                        :contentbar  :navigation
                                        :article     :article}}
                  :paths ["test/documentation"]
                  :files {"index"
                          {:template "home.html"
                           :title "hara"
                           :subtitle "patterns and utilities"}
                          ;"api"
                          ;{:input "test/documentation/hara_api.clj"
                          ; :title "api examples"}
                          "hara-class"
                          {:input "test/documentation/hara_class.clj"
                           :title "class"
                           :subtitle "functions for reasoning about classes"}
                          "hara-common"
                          {:input "test/documentation/hara_common.clj"
                           :title "common"
                           :subtitle "primitives declarations and functions"}
                          "hara-component"
                          {:input "test/documentation/hara_component.clj"
                           :title "component"
                           :subtitle "constructing composable systems"}
                          "hara-concurrent"
                          {:input "test/documentation/hara_concurrent.clj"
                           :title "concurrent"
                           :subtitle "methods and datastructures for concurrency"}
                          "hara-concurrent-ova"
                          {:input "test/documentation/hara_concurrent_ova.clj"
                           :title "concurrent.ova"
                           :subtitle "shared mutable state for multi-threaded applications"}
                          "hara-concurrent-procedure"
                          {:input "test/documentation/hara_concurrent_procedure.clj"
                           :title "concurrent.procedure"
                           :subtitle "model for controllable execution"}
                          "hara-data"
                          {:input "test/documentation/hara_data.clj"
                           :title "data"
                           :subtitle "manipulation of maps and representations of data"}
                          "hara-event"
                          {:input "test/documentation/hara_event.clj"
                           :title "event"
                           :subtitle "event signalling and conditional restart"}
                          "hara-expression"
                          {:input "test/documentation/hara_expression.clj"
                           :title "expression"
                           :subtitle "interchange between code and data"}
                          "hara-extend"
                          {:input "test/documentation/hara_extend.clj"
                           :title "extend"
                           :subtitle "macros for extensible objects"}
                          "hara-function"
                          {:input "test/documentation/hara_function.clj"
                           :title "function"
                           :subtitle "functions for reasoning about functions"}
                          "hara-group"
                          {:input "test/documentation/hara_group.clj"
                           :title "group"
                           :subtitle "generic typed collections"}
                          "hara-io-scheduler"
                          {:input "test/documentation/hara_io_scheduler.clj"
                           :title "io.scheduler"
                           :subtitle "easy and intuitive task scheduling"}
                          "hara-io-watch"
                          {:input "test/documentation/hara_io_watch.clj"
                           :title "io.watch"
                           :subtitle "watch for filesystem changes"}
                          "hara-namespace"
                          {:input "test/documentation/hara_namespace.clj"
                           :title "namespace"
                           :subtitle "utilities for manipulation of namespaces"}
                          "hara-object"
                          {:input "test/documentation/hara_object.clj"
                           :title "object"
                           :subtitle "think data, escape encapsulation"}
                          "hara-reflect"
                          {:input "test/documentation/hara_reflect.clj"
                           :title "reflect"
                           :subtitle "java reflection made easy"}
                          "hara-sort"
                          {:input "test/documentation/hara_sort.clj"
                           :title "sort"
                           :subtitle "micellaneous sorting functions"}
                          "hara-string"
                          {:input "test/documentation/hara_string.clj"
                           :title "string"
                           :subtitle "methods for string manipulation"}}
                :html {:logo "hara.png"
                       :home  "index"}
                :link {:auto-tag    true
                       :auto-number true}}

  :global-vars {*warn-on-reflection* true}
    :scm {:connection "scm:git:git://github.com/zcaudate/hara.git", :developerConnection "scm:git:ssh://git@github.com/zcaudate/hara.git", :tag "3ceacc224e83eae4437f9453f0f273afe004bca4\n", :url "https://github.com/zcaudate/hara"})
