(defproject im.chit/hara.io.scheduler "2.2.3"
  :description "patterns and utilities"
  :url "https://github.com/zcaudate/hara"
  :license {:name "The MIT License"
            :url "http://http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.6.0"] [im.chit/hara.concurrent.procedure "2.2.3"] [im.chit/hara.component "2.2.3"] [im.chit/hara.event "2.2.3"] [im.chit/hara.common.primitives "2.2.3"] [im.chit/hara.common.error "2.2.3"] [im.chit/hara.time "2.2.3"] [im.chit/hara.data.nested "2.2.3"] [im.chit/hara.data.map "2.2.3"] [im.chit/hara.concurrent.ova "2.2.3"]]
   
  :documentation {:site   "hara"
                  :output "docs"
                  :description "patterns and utilities"
                  :tracking "UA-31320512-2"
                  :owners [{:name    "Chris Zheng"
                            :email   "z@caudate.me"
                            :website "http://z.caudate.me"}]
                  :template {:path "template"
                             :copy ["assets/css" "assets/js"]
                             :defaults {:template "article-basic.html"
                                        :navbar  [:file "partials/navbar.html"]
                                        :sidebar [:file "partials/sidebar.html"]
                                        :footer  [:file "partials/footer.html"]
                                        :dependencies [:file "partials/deps-web.html"]
                                        :contentbar  :navigation
                                        :article     :article}}
                  :paths ["test/documentation"]
                  :files {"index"
                          {:template "home.html"
                           :title "hara"
                           :subtitle "patterns and utilities"}
                          ;"api"
                          ;{:input "test/documentation/hara_api.clj"
                          ; :title "api examples"}
                          "hara-component"
                          {:input "test/documentation/hara_component.clj"
                           :title "component"
                           :subtitle "constructing composable systems"}
                          "hara-concurrent-ova"
                          {:input "test/documentation/hara_concurrent_ova.clj"
                           :title "concurrent.ova"
                           :subtitle "shared mutable state for multi-threaded applications"}
                          ;"hara-concurrent-procedure"
                          ;{:input "test/documentation/hara_concurrent_procedure.clj"
                          ; :title "hara.concurrent.procedure"
                          ; :subtitle ""}
                          "hara-event"
                          {:input "test/documentation/hara_event.clj"
                           :title "event"
                           :subtitle "event signalling and conditional restart"}
                          ;"hara-io-watch"
                          ;{:input "test/documentation/hara_io_watch.clj"
                          ; :title "hara.io.watch"
                          ; :subtitle "watch for filesystem changes"}
                          "hara-io-scheduler"
                          {:input "test/documentation/hara_io_scheduler.clj"
                           :title "io.scheduler"
                           :subtitle "easy and intuitive task scheduling"}
                          "hara-reflect"
                          {:input "test/documentation/hara_reflect.clj"
                           :title "reflect"
                           :subtitle "java reflection made easy"}}
                :html {:logo "hara.png"
                       :home  "index",
                       :navigation ["home"
                                    {:link "api", :text "api"}
                                    ["guides" ["hara-component"
                                               "hara-concurrent-ova"
                                               ;;"hara-concurrent-procedure"
                                               "hara-event"
                                               ;;"hara-io-watch"
                                               "hara-io-scheduler"
                                               "hara-reflect"]]
                                    {:link "https://gitter.im/zcaudate/hara",
                                     :text "support"}
                                    {:link "https://www.github.com/zcaudate/hara",
                                     :text "source"}]}
                :link {:auto-tag    true
                       :auto-number true}}

  :global-vars {*warn-on-reflection* true}
    :scm {:connection "scm:git:git://github.com/zcaudate/hara.git" :developerConnection "scm:git:ssh://git@github.com/zcaudate/hara.git" :tag "1882f635f35e6a5430cfc173b39e0e678b0a9abc\n" :url "https://github.com/zcaudate/hara"})
