(defproject iku000888/schema "1.1.7-SNAPSHOT"
  :description "Clojure(Script) library for declarative data description and validation"
  :url "http://github.com/plumatic/schema"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :profiles {:dev {:dependencies [[org.clojure/clojure "1.8.0"]
                                  [org.clojure/clojurescript "1.9.908"]
                                  ;;[org.clojure/clojurescript "0.0-2760"]
                                  ;;[org.clojure/tools.nrepl "0.2.5"]
                                  [org.clojure/test.check "0.9.0"]
                                  [potemkin "0.4.1"]
                                  [com.cemerick/piggieback "0.2.2"]]
                   :plugins [;;[cljsee "0.1.0"]
                             [codox "0.8.8"]
                             [lein-cljsbuild "1.1.7"]
                             [com.cemerick/clojurescript.test "0.3.1"]]
                   :cljsee {:builds [{:source-paths ["src/cljx"]
                                      :output-path "target/generated/src/clj"
                                      :rules :clj}
                                     {:source-paths ["src/cljx"]
                                      :output-path "target/generated/src/cljs"
                                      :rules :cljs}
                                     {:source-paths ["test/cljx"]
                                      :output-path "target/generated/test/clj"
                                      :rules :clj}
                                     {:source-paths ["test/cljx"]
                                      :output-path "target/generated/test/cljs"
                                      :rules :cljs}]}}
             :1.8 {:dependencies [[org.clojure/clojure "1.8.0"] [org.clojure/clojurescript "0.0-3308"]]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0-alpha5"] [org.clojure/clojurescript "0.0-3308"]]}}

  :aliases {"all" ["with-profile" "dev:dev,1.8:dev,1.9"]
            ;;"deploy" ["do" "clean," "cljsee" "once," "deploy" "clojars"]
            "test" ["do" "clean,"
                    ;;"cljsee" "once,"
                    "test," "with-profile" "dev" "cljsbuild" "test"]}

  :jar-exclusions [#"\.cljx|\.swp|\.swo|\.DS_Store"]

  :lein-release {:deploy-via :shell
                 :shell ["lein" "deploy"]}

  :auto-clean false

  ;;:source-paths ["target/generated/src/clj" "src/clj"]
  :source-paths ["src/clj" "src/cljx"]

  ;;:resource-paths ["target/generated/src/cljs"]

  ;;:test-paths ["target/generated/test/clj" "test/clj"]
  :test-paths ["test/cljx" "test/clj"]

  :cljsbuild {:test-commands {"unit" ["phantomjs" :runner
                                      "this.literal_js_was_evaluated=true"
                                      "target/unit-test.js"]
                              "unit-no-assert" ["phantomjs" :runner
                                                "this.literal_js_was_evaluated=true"
                                                "target/unit-test-no-assert.js"]}
              :builds
              {:dev {:source-paths ["src/clj" "src/cljx"]
                     :compiler {:output-to "target/main.js"
                                :optimizations :whitespace
                                :pretty-print true}}
               :test {:source-paths ["src/clj" "test/clj"
                                     "src/cljx" "test/cljx"
                                     ;;"target/generated/src/cljs"
                                     ;;"target/generated/test/cljs"
                                     ]
                      :compiler {:output-to "target/unit-test.js"
                                 :optimizations :whitespace
                                 :pretty-print true}}
               :test-no-assert
               {:source-paths ["src/clj" "test/clj"
                               "src/cljx" "test/cljx"
                               ;;"target/generated/src/cljs"
                               ;;"target/generated/test/cljs"
                               ]
                :assert false
                :compiler {:output-to "target/unit-test-no-assert.js"
                           :optimizations :whitespace
                           :pretty-print true}}}}

  :codox {:src-uri-mapping {#"target/generated/src/clj" #(str "src/cljx/" % "x")}
          :src-dir-uri "http://github.com/plumatic/schema/blob/master/"
          :src-linenum-anchor-prefix "L"}

  :signing {:gpg-key "66E0BF75"})
