(ns ike.util.aleph
  (:require [aleph.http :as http]
            [manifold.stream :as stream]
            [ike.util.ring :as ring]
            [ike.util.component :as component]))

(defrecord AlephRingServer
  [handler options server]
  component/IdempotentLifecycle
  (-started? [this] (:server this))
  (-start [this]
    (let [handler (-> this :handler ring/make-handler)
          server (http/start-server handler (:options this))]
      (assoc this :server server)))
  (-stop [this]
    (-> this :server .close)
    (dissoc this :server)))

(component/extend-lifecycle AlephRingServer)

(defn new-server
  "Creates a new server with just the options populated."
  [options]
  (map->AlephRingServer {:options options}))

(defn websocket->async
  "Opens a websocket connection from the given request
  and uses the provided core.async channels to handle
  the input and provide the output."
  [request in-ch out-ch]
  (let [stream @(http/websocket-connection request)]
    (stream/connect stream in-ch)
    (stream/connect out-ch stream)))

(defn async->websocket
  "Opens a websocket connection to the given url and
  uses the provided core.async channels to handle the
  input and provide the output."
  [url in-ch out-ch]
  (let [stream @(http/websocket-client url)]
    (stream/connect stream in-ch)
    (stream/connect out-ch stream)))
